<?php

namespace garethp\ews\API\Message;

/**
 * Class representing GetServiceConfigurationType
 *
 *
 * XSD Type: GetServiceConfigurationType
 */
class GetServiceConfigurationType extends BaseRequestType
{

    /**
     * @var \garethp\ews\API\Type\EmailAddressType
     */
    protected $actingAs = null;

    /**
     * @var \garethp\ews\API\Enumeration\ServiceConfigurationType[]
     */
    protected $requestedConfiguration = null;

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\EmailAddressType
     */
    public function getActingAs()
    {
        return $this->actingAs;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\EmailAddressType
     * @return GetServiceConfigurationType
     */
    public function setActingAs(\garethp\ews\API\Type\EmailAddressType $value)
    {
        $this->actingAs = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Enumeration\ServiceConfigurationType
     * @return GetServiceConfigurationType
     */
    public function addRequestedConfiguration(\garethp\ews\API\Enumeration\ServiceConfigurationType $value)
    {
        if ($this->requestedConfiguration === null) {
                        $this->requestedConfiguration = array();
        }

        if (!is_array($this->requestedConfiguration)) {
            $this->requestedConfiguration = array($this->requestedConfiguration);
        }

        $this->requestedConfiguration[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Enumeration\ServiceConfigurationType[]
     */
    public function getRequestedConfiguration()
    {
        return $this->requestedConfiguration;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value
     * \garethp\ews\API\Enumeration\ServiceConfigurationType[]|\garethp\ews\API\Enumeration\ServiceConfigurationType
     * @return GetServiceConfigurationType
     */
    public function setRequestedConfiguration(array|\garethp\ews\API\Enumeration\ServiceConfigurationType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->requestedConfiguration = $value;
        return $this;
    }
}
