<?php

namespace garethp\ews\API\Message;

/**
 * Class representing GetMessageTrackingReportResponseMessageType
 *
 *
 * XSD Type: GetMessageTrackingReportResponseMessageType
 */
class GetMessageTrackingReportResponseMessageType extends ResponseMessageType
{

    /**
     * @var \garethp\ews\API\Type\MessageTrackingReportType
     */
    protected $messageTrackingReport = null;

    /**
     * @var string[]
     */
    protected $diagnostics = null;

    /**
     * @var \garethp\ews\API\Type\ArrayOfTrackingPropertiesType[]
     */
    protected $errors = null;

    /**
     * @var \garethp\ews\API\Type\TrackingPropertyType[]
     */
    protected $properties = null;

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\MessageTrackingReportType
     */
    public function getMessageTrackingReport()
    {
        return $this->messageTrackingReport;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\MessageTrackingReportType
     * @return GetMessageTrackingReportResponseMessageType
     */
    public function setMessageTrackingReport(\garethp\ews\API\Type\MessageTrackingReportType $value)
    {
        $this->messageTrackingReport = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string
     * @return GetMessageTrackingReportResponseMessageType
     */
    public function addDiagnostics($value)
    {
        if ($this->diagnostics === null) {
                        $this->diagnostics = array();
        }

        if (!is_array($this->diagnostics)) {
            $this->diagnostics = array($this->diagnostics);
        }

        $this->diagnostics[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return string[]
     */
    public function getDiagnostics()
    {
        return $this->diagnostics;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value string[]|string
     * @return GetMessageTrackingReportResponseMessageType
     */
    public function setDiagnostics(array|string $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->diagnostics = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\ArrayOfTrackingPropertiesType
     * @return GetMessageTrackingReportResponseMessageType
     */
    public function addErrors(\garethp\ews\API\Type\ArrayOfTrackingPropertiesType $value)
    {
        if ($this->errors === null) {
                        $this->errors = array();
        }

        if (!is_array($this->errors)) {
            $this->errors = array($this->errors);
        }

        $this->errors[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\ArrayOfTrackingPropertiesType[]
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value
     * \garethp\ews\API\Type\ArrayOfTrackingPropertiesType[]|\garethp\ews\API\Type\ArrayOfTrackingPropertiesType
     * @return GetMessageTrackingReportResponseMessageType
     */
    public function setErrors(array|\garethp\ews\API\Type\ArrayOfTrackingPropertiesType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->errors = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\TrackingPropertyType
     * @return GetMessageTrackingReportResponseMessageType
     */
    public function addProperties(\garethp\ews\API\Type\TrackingPropertyType $value)
    {
        if ($this->properties === null) {
                        $this->properties = array();
        }

        if (!is_array($this->properties)) {
            $this->properties = array($this->properties);
        }

        $this->properties[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\TrackingPropertyType[]
     */
    public function getProperties()
    {
        return $this->properties;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value
     * \garethp\ews\API\Type\TrackingPropertyType[]|\garethp\ews\API\Type\TrackingPropertyType
     * @return GetMessageTrackingReportResponseMessageType
     */
    public function setProperties(array|\garethp\ews\API\Type\TrackingPropertyType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->properties = $value;
        return $this;
    }
}
