<?php

namespace garethp\ews\API\Message;

/**
 * Class representing GetInboxRulesResponseType
 *
 *
 * XSD Type: GetInboxRulesResponseType
 */
class GetInboxRulesResponseType extends ResponseMessageType
{

    /**
     * @var boolean
     */
    protected $outlookRuleBlobExists = null;

    /**
     * @var \garethp\ews\API\Type\RuleType[]
     */
    protected $inboxRules = null;

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isOutlookRuleBlobExists()
    {
        return ((bool) $this->outlookRuleBlobExists);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getOutlookRuleBlobExists()
    {
        return $this->outlookRuleBlobExists;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return GetInboxRulesResponseType
     */
    public function setOutlookRuleBlobExists($value)
    {
        $this->outlookRuleBlobExists = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\RuleType
     * @return GetInboxRulesResponseType
     */
    public function addInboxRules(\garethp\ews\API\Type\RuleType $value)
    {
        if ($this->inboxRules === null) {
                        $this->inboxRules = array();
        }

        if (!is_array($this->inboxRules)) {
            $this->inboxRules = array($this->inboxRules);
        }

        $this->inboxRules[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\RuleType[]
     */
    public function getInboxRules()
    {
        return $this->inboxRules;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\RuleType[]|\garethp\ews\API\Type\RuleType
     * @return GetInboxRulesResponseType
     */
    public function setInboxRules(array|\garethp\ews\API\Type\RuleType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->inboxRules = $value;
        return $this;
    }
}
