<?php

namespace garethp\ews\API\Message;

/**
 * Class representing GetDelegateType
 *
 *
 * XSD Type: GetDelegateType
 */
class GetDelegateType extends BaseDelegateType
{

    /**
     * @var boolean
     */
    protected $includePermissions = null;

    /**
     * @var \garethp\ews\API\Type\UserIdType[]
     */
    protected $userIds = null;

    /**
     * @autogenerated This method is safe to replace
     * @return bool
     */
    public function isIncludePermissions()
    {
        return ((bool) $this->includePermissions);
    }

    /**
     * @autogenerated This method is safe to replace
     * @return boolean
     */
    public function getIncludePermissions()
    {
        return $this->includePermissions;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value bool
     * @return GetDelegateType
     */
    public function setIncludePermissions($value)
    {
        $this->includePermissions = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value \garethp\ews\API\Type\UserIdType
     * @return GetDelegateType
     */
    public function addUserIds(\garethp\ews\API\Type\UserIdType $value)
    {
        if ($this->userIds === null) {
                        $this->userIds = array();
        }

        if (!is_array($this->userIds)) {
            $this->userIds = array($this->userIds);
        }

        $this->userIds[] = $value;
        return $this;
    }

    /**
     * @autogenerated This method is safe to replace
     * @return \garethp\ews\API\Type\UserIdType[]
     */
    public function getUserIds()
    {
        return $this->userIds;
    }

    /**
     * @autogenerated This method is safe to replace
     * @param $value
     * \garethp\ews\API\Type\UserIdType[]|\garethp\ews\API\Type\UserIdType
     * @return GetDelegateType
     */
    public function setUserIds(array|\garethp\ews\API\Type\UserIdType $value)
    {
        if (!is_array($value)) {
            $value = [$value];
        }
        $this->userIds = $value;
        return $this;
    }
}
