<?php
/**
 * EmailValidationResult
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  ElasticEmail
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Elastic Email REST API
 *
 * This API is based on the REST API architecture, allowing the user to easily manage their data with this resource-based approach.    Every API call is established on which specific request type (GET, POST, PUT, DELETE) will be used.    The API has a limit of 20 concurrent connections and a hard timeout of 600 seconds per request.    To start using this API, you will need your Access Token (available <a target=\"_blank\" href=\"https://app.elasticemail.com/marketing/settings/new/manage-api\">here</a>). Remember to keep it safe. Required access levels are listed in the given request’s description.    Downloadable library clients can be found in our Github repository <a target=\"_blank\" href=\"https://github.com/ElasticEmail?tab=repositories&q=%22rest+api%22+in%3Areadme\">here</a>
 *
 * The version of the OpenAPI document: 4.0.0
 * Contact: support@elasticemail.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace ElasticEmail\Model;

use \ArrayAccess;
use \ElasticEmail\ObjectSerializer;

/**
 * EmailValidationResult Class Doc Comment
 *
 * @category Class
 * @package  ElasticEmail
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class EmailValidationResult implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'EmailValidationResult';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'account' => 'string',
        'domain' => 'string',
        'email' => 'string',
        'suggested_spelling' => 'string',
        'disposable' => 'bool',
        'role' => 'bool',
        'reason' => 'string',
        'date_added' => '\DateTime',
        'result' => '\ElasticEmail\Model\EmailValidationStatus',
        'predicted_score' => 'float',
        'predicted_status' => '\ElasticEmail\Model\EmailPredictedValidationStatus'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'account' => 'string',
        'domain' => 'string',
        'email' => 'string',
        'suggested_spelling' => 'string',
        'disposable' => 'boolean',
        'role' => 'boolean',
        'reason' => 'string',
        'date_added' => 'date-time',
        'result' => null,
        'predicted_score' => 'single',
        'predicted_status' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'account' => false,
        'domain' => false,
        'email' => false,
        'suggested_spelling' => false,
        'disposable' => false,
        'role' => false,
        'reason' => false,
        'date_added' => false,
        'result' => false,
        'predicted_score' => false,
        'predicted_status' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'account' => 'Account',
        'domain' => 'Domain',
        'email' => 'Email',
        'suggested_spelling' => 'SuggestedSpelling',
        'disposable' => 'Disposable',
        'role' => 'Role',
        'reason' => 'Reason',
        'date_added' => 'DateAdded',
        'result' => 'Result',
        'predicted_score' => 'PredictedScore',
        'predicted_status' => 'PredictedStatus'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'account' => 'setAccount',
        'domain' => 'setDomain',
        'email' => 'setEmail',
        'suggested_spelling' => 'setSuggestedSpelling',
        'disposable' => 'setDisposable',
        'role' => 'setRole',
        'reason' => 'setReason',
        'date_added' => 'setDateAdded',
        'result' => 'setResult',
        'predicted_score' => 'setPredictedScore',
        'predicted_status' => 'setPredictedStatus'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'account' => 'getAccount',
        'domain' => 'getDomain',
        'email' => 'getEmail',
        'suggested_spelling' => 'getSuggestedSpelling',
        'disposable' => 'getDisposable',
        'role' => 'getRole',
        'reason' => 'getReason',
        'date_added' => 'getDateAdded',
        'result' => 'getResult',
        'predicted_score' => 'getPredictedScore',
        'predicted_status' => 'getPredictedStatus'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('account', $data ?? [], null);
        $this->setIfExists('domain', $data ?? [], null);
        $this->setIfExists('email', $data ?? [], null);
        $this->setIfExists('suggested_spelling', $data ?? [], null);
        $this->setIfExists('disposable', $data ?? [], null);
        $this->setIfExists('role', $data ?? [], null);
        $this->setIfExists('reason', $data ?? [], null);
        $this->setIfExists('date_added', $data ?? [], null);
        $this->setIfExists('result', $data ?? [], null);
        $this->setIfExists('predicted_score', $data ?? [], null);
        $this->setIfExists('predicted_status', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets account
     *
     * @return string|null
     */
    public function getAccount()
    {
        return $this->container['account'];
    }

    /**
     * Sets account
     *
     * @param string|null $account Local part of an email
     *
     * @return self
     */
    public function setAccount($account)
    {
        if (is_null($account)) {
            throw new \InvalidArgumentException('non-nullable account cannot be null');
        }
        $this->container['account'] = $account;

        return $this;
    }

    /**
     * Gets domain
     *
     * @return string|null
     */
    public function getDomain()
    {
        return $this->container['domain'];
    }

    /**
     * Sets domain
     *
     * @param string|null $domain Name of selected domain.
     *
     * @return self
     */
    public function setDomain($domain)
    {
        if (is_null($domain)) {
            throw new \InvalidArgumentException('non-nullable domain cannot be null');
        }
        $this->container['domain'] = $domain;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email Full email address that was verified
     *
     * @return self
     */
    public function setEmail($email)
    {
        if (is_null($email)) {
            throw new \InvalidArgumentException('non-nullable email cannot be null');
        }
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets suggested_spelling
     *
     * @return string|null
     */
    public function getSuggestedSpelling()
    {
        return $this->container['suggested_spelling'];
    }

    /**
     * Sets suggested_spelling
     *
     * @param string|null $suggested_spelling Suggested spelling if a possible mistake was found
     *
     * @return self
     */
    public function setSuggestedSpelling($suggested_spelling)
    {
        if (is_null($suggested_spelling)) {
            throw new \InvalidArgumentException('non-nullable suggested_spelling cannot be null');
        }
        $this->container['suggested_spelling'] = $suggested_spelling;

        return $this;
    }

    /**
     * Gets disposable
     *
     * @return bool|null
     */
    public function getDisposable()
    {
        return $this->container['disposable'];
    }

    /**
     * Sets disposable
     *
     * @param bool|null $disposable Does the email have a temporary domain
     *
     * @return self
     */
    public function setDisposable($disposable)
    {
        if (is_null($disposable)) {
            throw new \InvalidArgumentException('non-nullable disposable cannot be null');
        }
        $this->container['disposable'] = $disposable;

        return $this;
    }

    /**
     * Gets role
     *
     * @return bool|null
     */
    public function getRole()
    {
        return $this->container['role'];
    }

    /**
     * Sets role
     *
     * @param bool|null $role Is an email a role email (e.g. info@, noreply@ etc.)
     *
     * @return self
     */
    public function setRole($role)
    {
        if (is_null($role)) {
            throw new \InvalidArgumentException('non-nullable role cannot be null');
        }
        $this->container['role'] = $role;

        return $this;
    }

    /**
     * Gets reason
     *
     * @return string|null
     */
    public function getReason()
    {
        return $this->container['reason'];
    }

    /**
     * Sets reason
     *
     * @param string|null $reason All detected issues
     *
     * @return self
     */
    public function setReason($reason)
    {
        if (is_null($reason)) {
            throw new \InvalidArgumentException('non-nullable reason cannot be null');
        }
        $this->container['reason'] = $reason;

        return $this;
    }

    /**
     * Gets date_added
     *
     * @return \DateTime|null
     */
    public function getDateAdded()
    {
        return $this->container['date_added'];
    }

    /**
     * Sets date_added
     *
     * @param \DateTime|null $date_added Added date
     *
     * @return self
     */
    public function setDateAdded($date_added)
    {
        if (is_null($date_added)) {
            throw new \InvalidArgumentException('non-nullable date_added cannot be null');
        }
        $this->container['date_added'] = $date_added;

        return $this;
    }

    /**
     * Gets result
     *
     * @return \ElasticEmail\Model\EmailValidationStatus|null
     */
    public function getResult()
    {
        return $this->container['result'];
    }

    /**
     * Sets result
     *
     * @param \ElasticEmail\Model\EmailValidationStatus|null $result result
     *
     * @return self
     */
    public function setResult($result)
    {
        if (is_null($result)) {
            throw new \InvalidArgumentException('non-nullable result cannot be null');
        }
        $this->container['result'] = $result;

        return $this;
    }

    /**
     * Gets predicted_score
     *
     * @return float|null
     */
    public function getPredictedScore()
    {
        return $this->container['predicted_score'];
    }

    /**
     * Sets predicted_score
     *
     * @param float|null $predicted_score Predicted score
     *
     * @return self
     */
    public function setPredictedScore($predicted_score)
    {
        if (is_null($predicted_score)) {
            throw new \InvalidArgumentException('non-nullable predicted_score cannot be null');
        }
        $this->container['predicted_score'] = $predicted_score;

        return $this;
    }

    /**
     * Gets predicted_status
     *
     * @return \ElasticEmail\Model\EmailPredictedValidationStatus|null
     */
    public function getPredictedStatus()
    {
        return $this->container['predicted_status'];
    }

    /**
     * Sets predicted_status
     *
     * @param \ElasticEmail\Model\EmailPredictedValidationStatus|null $predicted_status predicted_status
     *
     * @return self
     */
    public function setPredictedStatus($predicted_status)
    {
        if (is_null($predicted_status)) {
            throw new \InvalidArgumentException('non-nullable predicted_status cannot be null');
        }
        $this->container['predicted_status'] = $predicted_status;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


