<?php

// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.

//This the Bootstrap icon set, currently v1.9.0. Bootstrap Icons are SVGs, so they scale quickly and easily and can be styled with CSS. MIT license.

// This script may only be included - so its better to die if called directly.
if (strpos($_SERVER['SCRIPT_NAME'], basename(__FILE__)) !== false) {
    header('location: index.php');
    exit;
}

function iconset_bootstrap_icon_font()
{
    $file = __DIR__ . '/../../../' . GENERATED_ICONSET_PATH . '/all_bootstrap_icons.php';
    global $prefs;
    $bs_generated_icons = [];
    if (is_readable($file)) {
        include_once $file;
        $bs_generated_icons = $prefs['bs_generated_icons'] ?? [];
    }
    return [
        'name'        => tr('Bootstrap icon font'),
        'description' => tr('Bootstrap\'s own icon library, in icon font format'),
        'tag'         => 'span',
        'prepend'     => 'bi bi-',
        'append'      => '',
//        'styles'      => [
//            'default' => [
//                'name' => tr('Solid'),
//                'description' => tr(''),
//                'prepend' => 'bi bi-',
//                'append' => '',
//            ],
//        ],
        'icons'       => [
            'accordion'       => [
                'id' => 'view-list',
            ],
            'actions'       => [
                'id' => 'play',
            ],
            'admin'         => [
                'id' => 'wrench',
            ],
            'admin_ads' => [
                'id' => 'tv',
            ],
            'admin_articles' => [
                'id' => 'journal-richtext',
            ],
            'admin_blogs' => [
                'id' => 'journal-text',
            ],
            'admin_calendar' => [
                'id' => 'calendar3',
            ],
            'admin_category' => [
                'id' => 'diagram-3',
            ],
            'admin_comments' => [
                'id' => 'chat-dots',
            ],
            'admin_community' => [
                'id' => 'people',
            ],
            'admin_connect' => [
                'id' => 'link',
            ],
            'admin_copyright' => [
                'id' => 'c-circle',
            ],
            'admin_directory' => [
                'id' => 'folder',
            ],
            'admin_faqs' => [
                'id' => 'question-square',
            ],
            'admin_features' => [
                'id' => 'power',
            ],
            'admin_fgal' => [
                'id' => 'folder2-open',
            ],
            'admin_forums' => [
                'id' => 'chat-left-dots',
            ],
            'admin_freetags' => [
                'id' => 'tags',
            ],
            'admin_general' => [
                'id' => 'gear-wide',
            ],
            'admin_i18n' => [
                'id' => 'translate',
            ],
            'admin_intertiki' => [
                'id' => 'arrow-left-right',
            ],
            'admin_login' => [
                'id' => 'door-open',
            ],
            'admin_look' => [
                'id' => 'image',
            ],
            'admin_maps' => [
                'id' => 'map',
            ],
            'admin_messages' => [
                'id' => 'mailbox',
            ],
            'admin_metatags' => [
                'id' => 'tag',
            ],
            'admin_module' => [
                'id' => 'boxes',
            ],
            'admin_packages' => [
                'id' => 'gift',
            ],
            'admin_payment' => [
                'id' => 'credit-card',
            ],
            'admin_performance' => [
                'id' => 'speedometer2',
            ],
            'admin_polls' => [
                'id' => 'list-check',
            ],
            'admin_print' => [
                'id' => 'printer',
            ],
            'admin_profiles' => [
                'id' => 'layout-wtf',
            ],
            'admin_rating' => [
                'id' => 'check-square-fill',
            ],
            'admin_rss' => [
                'id' => 'rss',
            ],
            'admin_rtc' => [
                'id' => 'telephone-plus',
            ],
            'admin_score' => [
                'id' => 'trophy',
            ],
            'admin_search' => [
                'id' => 'search',
            ],
            'admin_section_general' => [
                'id' => 'tools',
            ],
            'admin_security' => [
                'id' => 'incognito',
            ],
            'admin_sefurl' => [
                'id' => 'search-heart',
            ],
            'admin_semantic' => [
                'id' => 'arrows-angle-contract',
            ],
            'admin_share' => [
                'id' => 'share',
            ],
            'admin_socialnetworks' => [
                'id' => 'hand-thumbs-up',
            ],
            'admin_stats' => [
                'id' => 'bar-chart-line',
            ],
            'admin_textarea' => [
                'id' => 'pencil-square',
            ],
            'admin_trackers' => [
                'id' => 'textarea-t',
            ],
            'admin_user' => [
                'id' => 'person-square',
            ],
            'admin_video' => [
                'id' => 'camera-video',
            ],
            'admin_webmail' => [
                'id' => 'inboxes',
            ],
            'admin_webservices' => [
                'id' => 'cloud-plus',
            ],
            'admin_wiki' => [
                'id' => 'file-word',
            ],
            'admin_wizard' => [
                'id' => 'magic',
            ],
            'admin_wysiwyg' => [
                'id' => 'file-richtext',
            ],
            'admin_workspace' => [
                'id' => 'pc-display-horizontal',
            ],
            'attach' => [
                'id' => 'paperclip',
            ],
            'arrow-circle-up' => [
                'id' => 'arrow-up-circle-fill',
            ],
            'bold' => [
                'id' => 'type-bold',
            ],
            'circle-half' => [
                'id' => 'circle-half',
            ],
            'clipboard-list' => [
                'id' => 'card-checklist',
            ],
            'cog' => [
                'id' => 'gear-wide-connected',
            ],
            'cogs' => [
                'id' => 'gear-wide-connected',
            ],
            'comments' => [
                'id' => 'chat-quote',
            ],
            'content' => [
                'id' => 'box-seam',
            ],
            'copy' => [
                'id' => 'files',
            ],
            'create' => [
                'id' => 'plus-square-dotted',
            ],
            'cubes' => [
                'id' => 'boxes',
            ],
            'database' => [
                'id' => 'database-fill',
            ],
            'delete' => [
                'id' => 'x',
            ],
            'directory' => [
                'id' => 'list-ul',
            ],
            'edit' => [
                'id' => 'pencil-square',
            ],
            'export' => [
                'id' => 'box-arrow-up',
            ],
            'faq' => [
                'id' => 'patch-question',
            ],
            'file-archive' => [
                'id' => 'file-arrow-up-fill',
            ],
            'groupedit' => [
                'id' => 'people-fill',
            ],
            'help' => [
                'id' => 'question-circle',
            ],
            'history' => [
                'id' => 'clock-history',
            ],
            'h1' => [
                'id' => 'type-h1',
            ],
            'h2' => [
                'id' => 'type-h2',
            ],
            'h3' => [
                'id' => 'type-h3',
            ],
            'heartbeat' => [
                'id' => 'heart-pulse',
            ],
            'heartbeat-fill' => [
                'id' => 'heart-pulse-fill',
            ],
            'home' => [
                'id' => 'house-door',
            ],
            'horizontal-rule' => [
                'id' => 'type-h1',
            ],
            'html-pages' => [
                'id' => 'filetype-html',
            ],
            'import' => [
                'id' => 'box-arrow-in-down',
            ],
            'italic' => [
                'id' => 'type-italic',
            ],
            'kaltura' => [
                'id' => 'brightness-high',
            ],
            'link-external' => [
                'id' => 'box-arrow-up-right',
            ],
            'list-numbered' => [
                'id' => 'list-ol',
            ],
            'manage' => [
                'id' => 'controller',
            ],
            'message' => [
                'id' => 'chat-dots-fill',
            ],
            'minus-circle' => [
                'id' => 'dash-circle-fill',
            ],
            'monitor' => [
                'id' => 'display',
            ],
            'notepad' => [
                'id' => 'journal-medical',
            ],
            'page-break' => [
                'id' => 'file-break',
            ],
            'permission' => [
                'id' => 'key',
            ],
            'ranking' => [
                'id' => 'sort-numeric-down',
            ],
            'remove' => [
                'id' => 'x-lg',
            ],
            'image' => [
                'id' => 'file-image',
            ],
            'information' => [
                'id' => 'info-circle',
            ],
            'post' => [
                'id' => 'pen',
            ],
            'ok' => [
                'id' => 'check-circle',
            ],
            'php' => [
                'id' => 'filetype-php',
            ],
            'poll' => [
                'id' => 'bar-chart-line',
            ],
            'quiz' => [
                'id' => 'question-square',
            ],
            'settings' => [
                'id' => 'wrench-adjustable',
            ],
            'server-rack' => [
                'id' => 'hdd-stack',
            ],
            'server-rack-fill' => [
                'id' => 'hdd-stack-fill',
            ],
            'smile' => [
                'id' => 'emoji-smile',
            ],
            'sort' => [
                'id' => 'emoji-smile',
            ],
            'spreadsheet' => [
                'id' => 'table',
            ],
            'strikethrough' => [
                'id' => 'type-strikethrough',
            ],
            'survey' => [
                'id' => 'person-raised-hand',
            ],
            'sync' => [
                'id' => 'arrow-repeat',
            ],
            'system' => [
                'id' => 'bezier2',
            ],
            'refresh' => [
                'id' => 'arrow-repeat',
            ],
            'tasks' => [
                'id' => 'list-check',
            ],
            'th-list' => [
                'id' => 'list-columns-reverse',
            ],
            'tikimanager' => [
                'id' => 'wrench-adjustable-circle',
            ],
            'toggle-left' => [
                'id' => 'chevron-left',
            ],
            'toggle-right' => [
                'id' => 'chevron-right',
            ],
            'underline' => [
                'id' => 'type-underline',
            ],
            'undo' => [
                'id' => 'arrow-counterclockwise',
            ],
            'user' => [
                'id' => 'person',
            ],
            'user-circle' => [
                'id' => 'person-circle',
            ],
            'address-card' => [
                'id' => 'person-vcard',
            ],
            'view' => [
                'id' => 'eyeglasses',
            ],
            'warning' => [
                'id' => 'exclamation-triangle',
            ],
            'wizards' => [
                'id' => 'magic'
            ],
            'zip' => [
                'id' => 'file-zip',
            ]
        ] + $bs_generated_icons,
        'defaults'    => [
            '1-square',
            '1-square-fill',
            '2-circle',
            '2-circle-fill',
            '2-square',
            '2-square-fill',
            '3-circle',
            '3-circle-fill',
            '3-square',
            '3-square-fill',
            '4-circle',
            '4-circle-fill',
            '4-square',
            '4-square-fill',
            '5-circle',
            '5-circle-fill',
            '5-square',
            '5-square-fill',
            '6-circle',
            '6-circle-fill',
            '6-square',
            '6-square-fill',
            '7-circle',
            '7-circle-fill',
            '7-square',
            '7-square-fill',
            '8-circle',
            '8-circle-fill',
            '8-square',
            '8-square-fill',
            '9-circle',
            '9-circle-fill',
            '9-square',
            '9-square-fill',
            '123',
            'activity',
            'airplane',
            'airplane-engines',
            'airplane-engines-fill',
            'airplane-fill',
            'alarm',
            'alarm-fill',
            'alexa',
            'align-bottom',
            'align-center',
            'align-end',
            'align-middle',
            'align-start',
            'align-top',
            'alipay',
            'alt',
            'android',
            'android2',
            'app',
            'app-indicator',
            'apple',
            'archive',
            'archive-fill',
            'arrow-90deg-down',
            'arrow-90deg-left',
            'arrow-90deg-right',
            'arrow-90deg-up',
            'arrow-bar-down',
            'arrow-bar-left',
            'arrow-bar-right',
            'arrow-bar-up',
            'arrow-clockwise',
            'arrow-counterclockwise',
            'arrow-down',
            'arrow-down-circle',
            'arrow-down-circle-fill',
            'arrow-down-left',
            'arrow-down-left-circle',
            'arrow-down-left-circle-fill',
            'arrow-down-left-square',
            'arrow-down-left-square-fill',
            'arrow-down-right',
            'arrow-down-right-circle',
            'arrow-down-right-circle-fill',
            'arrow-down-right-square',
            'arrow-down-right-square-fill',
            'arrow-down-short',
            'arrow-down-square',
            'arrow-down-square-fill',
            'arrow-down-up',
            'arrow-left',
            'arrow-left-circle',
            'arrow-left-circle-fill',
            'arrow-left-right',
            'arrow-left-short',
            'arrow-left-square',
            'arrow-left-square-fill',
            'arrow-repeat',
            'arrow-return-left',
            'arrow-return-right',
            'arrow-right',
            'arrow-right-circle',
            'arrow-right-circle-fill',
            'arrow-right-short',
            'arrow-right-square',
            'arrow-right-square-fill',
            'arrows-angle-contract',
            'arrows-angle-expand',
            'arrows-collapse',
            'arrows-expand',
            'arrows-fullscreen',
            'arrows-move',
            'arrow-through-heart',
            'arrow-through-heart-fill',
            'arrow-up',
            'arrow-up-circle',
            'arrow-up-circle-fill',
            'arrow-up-left',
            'arrow-up-left-circle',
            'arrow-up-left-circle-fill',
            'arrow-up-left-square',
            'arrow-up-left-square-fill',
            'arrow-up-right',
            'arrow-up-right-circle',
            'arrow-up-right-circle-fill',
            'arrow-up-right-square',
            'arrow-up-right-square-fill',
            'arrow-up-short',
            'arrow-up-square',
            'arrow-up-square-fill',
            'aspect-ratio',
            'aspect-ratio-fill',
            'asterisk',
            'at',
            'award',
            'award-fill',
            'back',
            'backspace',
            'backspace-fill',
            'backspace-reverse',
            'backspace-reverse-fill',
            'badge-3d',
            'badge-3d-fill',
            'badge-4k',
            'badge-4k-fill',
            'badge-8k',
            'badge-8k-fill',
            'badge-ad',
            'badge-ad-fill',
            'badge-ar',
            'badge-ar-fill',
            'badge-cc',
            'badge-cc-fill',
            'badge-hd',
            'badge-hd-fill',
            'badge-sd',
            'badge-sd-fill',
            'badge-tm',
            'badge-tm-fill',
            'badge-vo',
            'badge-vo-fill',
            'badge-vr',
            'badge-vr-fill',
            'badge-wc',
            'badge-wc-fill',
            'bag',
            'bag-check',
            'bag-check-fill',
            'bag-dash',
            'bag-dash-fill',
            'bag-fill',
            'bag-heart',
            'bag-heart-fill',
            'bag-plus',
            'bag-plus-fill',
            'bag-x',
            'bag-x-fill',
            'balloon',
            'balloon-fill',
            'balloon-heart',
            'balloon-heart-fill',
            'bandaid',
            'bandaid-fill',
            'bank',
            'bank2',
            'bar-chart',
            'bar-chart-fill',
            'bar-chart-line',
            'bar-chart-line-fill',
            'bar-chart-steps',
            'basket',
            'basket2',
            'basket2-fill',
            'basket3',
            'basket3-fill',
            'basket-fill',
            'battery',
            'battery-charging',
            'battery-full',
            'battery-half',
            'behance',
            'bell',
            'bell-fill',
            'bell-slash',
            'bell-slash-fill',
            'bezier',
            'bezier2',
            'bicycle',
            'box-arrow-up-right',
            'binoculars',
            'binoculars-fill',
            'blockquote-left',
            'blockquote-right',
            'bluetooth',
            'body-text',
            'book',
            'book-fill',
            'book-half',
            'bookmark',
            'bookmark-check',
            'bookmark-check-fill',
            'bookmark-dash',
            'bookmark-dash-fill',
            'bookmark-fill',
            'bookmark-heart',
            'bookmark-heart-fill',
            'bookmark-plus',
            'bookmark-plus-fill',
            'bookmarks',
            'bookmarks-fill',
            'bookmark-star',
            'bookmark-star-fill',
            'bookmark-x',
            'bookmark-x-fill',
            'bookshelf',
            'boombox',
            'boombox-fill',
            'bootstrap',
            'bootstrap-fill',
            'bootstrap-reboot',
            'border',
            'border-all',
            'border-bottom',
            'border-center',
            'border-inner',
            'border-left',
            'border-middle',
            'border-outer',
            'border-right',
            'border-style',
            'border-top',
            'border-width',
            'bounding-box',
            'bounding-box-circles',
            'box',
            'box2',
            'box2-fill',
            'box2-heart',
            'box2-heart-fill',
            'box-arrow-down',
            'box-arrow-down-left',
            'box-arrow-down-right',
            'box-arrow-in-down',
            'box-arrow-in-down-left',
            'box-arrow-in-down-right',
            'box-arrow-in-left',
            'box-arrow-in-right',
            'box-arrow-in-up',
            'box-arrow-in-up-left',
            'box-arrow-in-up-right',
            'box-arrow-left',
            'box-arrow-right',
            'box-arrow-up',
            'box-arrow-up-left',
            'box-arrow-up-right',
            'boxes',
            'box-fill',
            'box-seam',
            'box-seam-fill',
            'braces',
            'braces-asterisk',
            'bricks',
            'briefcase',
            'briefcase-fill',
            'brightness-alt-high',
            'brightness-alt-high-fill',
            'brightness-alt-low',
            'brightness-alt-low-fill',
            'brightness-high',
            'brightness-high-fill',
            'brightness-low',
            'brightness-low-fill',
            'broadcast',
            'broadcast-pin',
            'browser-chrome',
            'browser-edge',
            'browser-firefox',
            'browser-safari',
            'brush',
            'brush-fill',
            'bucket',
            'bucket-fill',
            'bug',
            'bug-fill',
            'building',
            'bullseye',
            'calculator',
            'calculator-fill',
            'calendar',
            'calendar2',
            'calendar2-check',
            'calendar2-check-fill',
            'calendar2-date',
            'calendar2-date-fill',
            'calendar2-day',
            'calendar2-day-fill',
            'calendar2-event',
            'calendar2-event-fill',
            'calendar2-fill',
            'calendar2-heart',
            'calendar2-heart-fill',
            'calendar2-minus',
            'calendar2-minus-fill',
            'calendar2-month',
            'calendar2-month-fill',
            'calendar2-plus',
            'calendar2-plus-fill',
            'calendar2-range',
            'calendar2-range-fill',
            'calendar2-week',
            'calendar2-week-fill',
            'calendar2-x',
            'calendar2-x-fill',
            'calendar3',
            'calendar3-event',
            'calendar3-event-fill',
            'calendar3-fill',
            'calendar3-range',
            'calendar3-range-fill',
            'calendar3-week',
            'calendar3-week-fill',
            'calendar4',
            'calendar4-event',
            'calendar4-range',
            'calendar4-week',
            'calendar-check',
            'calendar-check-fill',
            'calendar-date',
            'calendar-date-fill',
            'calendar-day',
            'calendar-day-fill',
            'calendar-event',
            'calendar-event-fill',
            'calendar-fill',
            'calendar-heart',
            'calendar-heart-fill',
            'calendar-minus',
            'calendar-minus-fill',
            'calendar-month',
            'calendar-month-fill',
            'calendar-plus',
            'calendar-plus-fill',
            'calendar-range',
            'calendar-range-fill',
            'calendar-week',
            'calendar-week-fill',
            'calendar-x',
            'calendar-x-fill',
            'camera',
            'camera2',
            'camera-fill',
            'camera-reels',
            'camera-reels-fill',
            'camera-video',
            'camera-video-fill',
            'camera-video-off',
            'camera-video-off-fill',
            'capslock',
            'capslock-fill',
            'capsule',
            'capsule-pill',
            'card-checklist',
            'card-heading',
            'card-image',
            'card-list',
            'card-text',
            'caret-down',
            'caret-down-fill',
            'caret-down-square',
            'caret-down-square-fill',
            'caret-left',
            'caret-left-fill',
            'caret-left-square',
            'caret-left-square-fill',
            'caret-right',
            'caret-right-fill',
            'caret-right-square',
            'caret-right-square-fill',
            'caret-up',
            'caret-up-fill',
            'caret-up-square',
            'caret-up-square-fill',
            'car-front',
            'car-front-fill',
            'cart',
            'cart2',
            'cart3',
            'cart4',
            'cart-check',
            'cart-check-fill',
            'cart-dash',
            'cart-dash-fill',
            'cart-fill',
            'cart-plus',
            'cart-plus-fill',
            'cart-x',
            'cart-x-fill',
            'cash',
            'cash-coin',
            'cash-stack',
            'cassette',
            'cassette-fill',
            'cast',
            'cc-circle',
            'cc-circle-fill',
            'c-circle',
            'c-circle-fill',
            'cc-square',
            'cc-square-fill',
            'chat',
            'chat-dots',
            'chat-dots-fill',
            'chat-fill',
            'chat-heart',
            'chat-heart-fill',
            'chat-left',
            'chat-left-dots',
            'chat-left-dots-fill',
            'chat-left-fill',
            'chat-left-heart',
            'chat-left-heart-fill',
            'chat-left-quote',
            'chat-left-quote-fill',
            'chat-left-text',
            'chat-left-text-fill',
            'chat-quote',
            'chat-quote-fill',
            'chat-right',
            'chat-right-dots',
            'chat-right-dots-fill',
            'chat-right-fill',
            'chat-right-heart',
            'chat-right-heart-fill',
            'chat-right-quote',
            'chat-right-quote-fill',
            'chat-right-text',
            'chat-right-text-fill',
            'chat-square',
            'chat-square-dots',
            'chat-square-dots-fill',
            'chat-square-fill',
            'chat-square-heart',
            'chat-square-heart-fill',
            'chat-square-quote',
            'chat-square-quote-fill',
            'chat-square-text',
            'chat-square-text-fill',
            'chat-text',
            'chat-text-fill',
            'check',
            'check2',
            'check2-all',
            'check2-circle',
            'check2-square',
            'check-all',
            'check-circle',
            'check-circle-fill',
            'check-lg',
            'check-square',
            'check-square-fill',
            'chevron-bar-contract',
            'chevron-bar-down',
            'chevron-bar-expand',
            'chevron-bar-left',
            'chevron-bar-right',
            'chevron-bar-up',
            'chevron-compact-down',
            'chevron-compact-left',
            'chevron-compact-right',
            'chevron-compact-up',
            'chevron-contract',
            'chevron-double-down',
            'chevron-double-left',
            'chevron-double-right',
            'chevron-double-up',
            'chevron-down',
            'chevron-expand',
            'chevron-left',
            'chevron-right',
            'chevron-up',
            'circle',
            'circle-fill',
            'circle-half',
            'circle-square',
            'clipboard',
            'clipboard2',
            'clipboard2-check',
            'clipboard2-check-fill',
            'clipboard2-data',
            'clipboard2-data-fill',
            'clipboard2-fill',
            'clipboard2-heart',
            'clipboard2-heart-fill',
            'clipboard2-minus',
            'clipboard2-minus-fill',
            'clipboard2-plus',
            'clipboard2-plus-fill',
            'clipboard2-pulse',
            'clipboard2-pulse-fill',
            'clipboard2-x',
            'clipboard2-x-fill',
            'clipboard-check',
            'clipboard-check-fill',
            'clipboard-data',
            'clipboard-data-fill',
            'clipboard-fill',
            'clipboard-heart',
            'clipboard-heart-fill',
            'clipboard-minus',
            'clipboard-minus-fill',
            'clipboard-plus',
            'clipboard-plus-fill',
            'clipboard-pulse',
            'clipboard-x',
            'clipboard-x-fill',
            'clock',
            'clock-fill',
            'clock-history',
            'cloud',
            'cloud-arrow-down',
            'cloud-arrow-down-fill',
            'cloud-arrow-up',
            'cloud-arrow-up-fill',
            'cloud-check',
            'cloud-check-fill',
            'cloud-download',
            'cloud-download-fill',
            'cloud-drizzle',
            'cloud-drizzle-fill',
            'cloud-fill',
            'cloud-fog',
            'cloud-fog2',
            'cloud-fog2-fill',
            'cloud-fog-fill',
            'cloud-hail',
            'cloud-hail-fill',
            'cloud-haze',
            'cloud-haze2',
            'cloud-haze2-fill',
            'cloud-haze-fill',
            'cloud-lightning',
            'cloud-lightning-fill',
            'cloud-lightning-rain',
            'cloud-lightning-rain-fill',
            'cloud-minus',
            'cloud-minus-fill',
            'cloud-moon',
            'cloud-moon-fill',
            'cloud-plus',
            'cloud-plus-fill',
            'cloud-rain',
            'cloud-rain-fill',
            'cloud-rain-heavy',
            'cloud-rain-heavy-fill',
            'clouds',
            'clouds-fill',
            'cloud-slash',
            'cloud-slash-fill',
            'cloud-sleet',
            'cloud-sleet-fill',
            'cloud-snow',
            'cloud-snow-fill',
            'cloud-sun',
            'cloud-sun-fill',
            'cloud-upload',
            'cloud-upload-fill',
            'cloudy',
            'cloudy-fill',
            'code',
            'code-slash',
            'code-square',
            'coin',
            'collection',
            'collection-fill',
            'collection-play',
            'collection-play-fill',
            'columns',
            'columns-gap',
            'command',
            'compass',
            'compass-fill',
            'cone',
            'cone-striped',
            'controller',
            'cpu',
            'cpu-fill',
            'credit-card',
            'credit-card-2-back',
            'credit-card-2-back-fill',
            'credit-card-2-front',
            'credit-card-2-front-fill',
            'credit-card-fill',
            'crop',
            'c-square',
            'c-square-fill',
            'cup',
            'cup-fill',
            'cup-hot',
            'cup-hot-fill',
            'cup-straw',
            'currency-bitcoin',
            'currency-dollar',
            'currency-euro',
            'currency-exchange',
            'currency-pound',
            'currency-rupee',
            'currency-yen',
            'cursor',
            'cursor-fill',
            'cursor-text',
            'dash',
            'dash-circle',
            'dash-circle-dotted',
            'dash-circle-fill',
            'dash-lg',
            'dash-square',
            'dash-square-dotted',
            'dash-square-fill',
            'database-fill',
            'device-hdd',
            'device-hdd-fill',
            'device-ssd',
            'device-ssd-fill',
            'diagram-2',
            'diagram-2-fill',
            'diagram-3',
            'diagram-3-fill',
            'diamond',
            'diamond-fill',
            'diamond-half',
            'dice-1',
            'dice-1-fill',
            'dice-2',
            'dice-2-fill',
            'dice-3',
            'dice-3-fill',
            'dice-4',
            'dice-4-fill',
            'dice-5',
            'dice-5-fill',
            'dice-6',
            'dice-6-fill',
            'disc',
            'disc-fill',
            'discord',
            'display',
            'display-fill',
            'displayport',
            'displayport-fill',
            'distribute-horizontal',
            'distribute-vertical',
            'door-closed',
            'door-closed-fill',
            'door-open',
            'door-open-fill',
            'dot',
            'download',
            'dpad',
            'dpad-fill',
            'dribbble',
            'dropbox',
            'droplet',
            'droplet-fill',
            'droplet-half',
            'ear',
            'earbuds',
            'ear-fill',
            'easel',
            'easel2',
            'easel2-fill',
            'easel3',
            'easel3-fill',
            'easel-fill',
            'egg',
            'egg-fill',
            'egg-fried',
            'eject',
            'eject-fill',
            'emoji-angry',
            'emoji-angry-fill',
            'emoji-dizzy',
            'emoji-dizzy-fill',
            'emoji-expressionless',
            'emoji-expressionless-fill',
            'emoji-frown',
            'emoji-frown-fill',
            'emoji-heart-eyes',
            'emoji-heart-eyes-fill',
            'emoji-kiss',
            'emoji-kiss-fill',
            'emoji-laughing',
            'emoji-laughing-fill',
            'emoji-neutral',
            'emoji-neutral-fill',
            'emoji-smile',
            'emoji-smile-fill',
            'emoji-smile-upside-down',
            'emoji-smile-upside-down-fill',
            'emoji-sunglasses',
            'emoji-sunglasses-fill',
            'emoji-wink',
            'emoji-wink-fill',
            'envelope',
            'envelope-check',
            'envelope-check-fill',
            'envelope-dash',
            'envelope-dash-fill',
            'envelope-exclamation',
            'envelope-exclamation-fill',
            'envelope-fill',
            'envelope-heart',
            'envelope-heart-fill',
            'envelope-open',
            'envelope-open-fill',
            'envelope-open-heart',
            'envelope-open-heart-fill',
            'envelope-paper',
            'envelope-paper-fill',
            'envelope-paper-heart',
            'envelope-paper-heart-fill',
            'envelope-plus',
            'envelope-plus-fill',
            'envelope-slash',
            'envelope-slash-fill',
            'envelope-x',
            'envelope-x-fill',
            'eraser',
            'eraser-fill',
            'escape',
            'ethernet',
            'exclamation',
            'exclamation-circle',
            'exclamation-circle-fill',
            'exclamation-diamond',
            'exclamation-diamond-fill',
            'exclamation-lg',
            'exclamation-octagon',
            'exclamation-octagon-fill',
            'exclamation-square',
            'exclamation-square-fill',
            'exclamation-triangle',
            'exclamation-triangle-fill',
            'exclude',
            'explicit',
            'explicit-fill',
            'eye',
            'eyedropper',
            'eye-fill',
            'eyeglasses',
            'eye-slash',
            'eye-slash-fill',
            'facebook',
            'fan',
            'fast-forward',
            'fast-forward-btn',
            'fast-forward-btn-fill',
            'fast-forward-circle',
            'fast-forward-circle-fill',
            'fast-forward-fill',
            'file',
            'file-arrow-down',
            'file-arrow-down-fill',
            'file-arrow-up',
            'file-arrow-up-fill',
            'file-bar-graph',
            'file-bar-graph-fill',
            'file-binary',
            'file-binary-fill',
            'file-break',
            'file-break-fill',
            'file-check',
            'file-check-fill',
            'file-code',
            'file-code-fill',
            'file-diff',
            'file-diff-fill',
            'file-earmark',
            'file-earmark-arrow-down',
            'file-earmark-arrow-down-fill',
            'file-earmark-arrow-up',
            'file-earmark-arrow-up-fill',
            'file-earmark-bar-graph',
            'file-earmark-bar-graph-fill',
            'file-earmark-binary',
            'file-earmark-binary-fill',
            'file-earmark-break',
            'file-earmark-break-fill',
            'file-earmark-check',
            'file-earmark-check-fill',
            'file-earmark-code',
            'file-earmark-code-fill',
            'file-earmark-diff',
            'file-earmark-diff-fill',
            'file-earmark-easel',
            'file-earmark-easel-fill',
            'file-earmark-excel',
            'file-earmark-excel-fill',
            'file-earmark-fill',
            'file-earmark-font',
            'file-earmark-font-fill',
            'file-earmark-image',
            'file-earmark-image-fill',
            'file-earmark-lock',
            'file-earmark-lock2',
            'file-earmark-lock2-fill',
            'file-earmark-lock-fill',
            'file-earmark-medical',
            'file-earmark-medical-fill',
            'file-earmark-minus',
            'file-earmark-minus-fill',
            'file-earmark-music',
            'file-earmark-music-fill',
            'file-earmark-pdf',
            'file-earmark-pdf-fill',
            'file-earmark-person',
            'file-earmark-person-fill',
            'file-earmark-play',
            'file-earmark-play-fill',
            'file-earmark-plus',
            'file-earmark-plus-fill',
            'file-earmark-post',
            'file-earmark-post-fill',
            'file-earmark-ppt',
            'file-earmark-ppt-fill',
            'file-earmark-richtext',
            'file-earmark-richtext-fill',
            'file-earmark-ruled',
            'file-earmark-ruled-fill',
            'file-earmark-slides',
            'file-earmark-slides-fill',
            'file-earmark-spreadsheet',
            'file-earmark-spreadsheet-fill',
            'file-earmark-text',
            'file-earmark-text-fill',
            'file-earmark-word',
            'file-earmark-word-fill',
            'file-earmark-x',
            'file-earmark-x-fill',
            'file-earmark-zip',
            'file-earmark-zip-fill',
            'file-easel',
            'file-easel-fill',
            'file-excel',
            'file-excel-fill',
            'file-fill',
            'file-font',
            'file-font-fill',
            'file-image',
            'file-image-fill',
            'file-lock',
            'file-lock2',
            'file-lock2-fill',
            'file-lock-fill',
            'file-medical',
            'file-medical-fill',
            'file-minus',
            'file-minus-fill',
            'file-music',
            'file-music-fill',
            'file-pdf',
            'file-pdf-fill',
            'file-person',
            'file-person-fill',
            'file-play',
            'file-play-fill',
            'file-plus',
            'file-plus-fill',
            'file-post',
            'file-post-fill',
            'file-ppt',
            'file-ppt-fill',
            'file-richtext',
            'file-richtext-fill',
            'file-ruled',
            'file-ruled-fill',
            'files',
            'files-alt',
            'file-slides',
            'file-slides-fill',
            'file-spreadsheet',
            'file-spreadsheet-fill',
            'file-text',
            'file-text-fill',
            'filetype-aac',
            'filetype-ai',
            'filetype-bmp',
            'filetype-cs',
            'filetype-css',
            'filetype-csv',
            'filetype-doc',
            'filetype-docx',
            'filetype-exe',
            'filetype-gif',
            'filetype-heic',
            'filetype-html',
            'filetype-java',
            'filetype-jpg',
            'filetype-js',
            'filetype-json',
            'filetype-jsx',
            'filetype-key',
            'filetype-m4p',
            'filetype-md',
            'filetype-mdx',
            'filetype-mov',
            'filetype-mp3',
            'filetype-mp4',
            'filetype-otf',
            'filetype-pdf',
            'filetype-php',
            'filetype-png',
            'filetype-ppt',
            'filetype-pptx',
            'filetype-psd',
            'filetype-py',
            'filetype-raw',
            'filetype-rb',
            'filetype-sass',
            'filetype-scss',
            'filetype-sh',
            'filetype-sql',
            'filetype',
            'filetype-tiff',
            'filetype-tsx',
            'filetype-ttf',
            'filetype-txt',
            'filetype-wav',
            'filetype-woff',
            'filetype-xls',
            'filetype-xlsx',
            'filetype-xml',
            'filetype-yml',
            'file-word',
            'file-word-fill',
            'file-x',
            'file-x-fill',
            'file-zip',
            'file-zip-fill',
            'film',
            'filter',
            'filter-circle',
            'filter-circle-fill',
            'filter-left',
            'filter-right',
            'filter-square',
            'filter-square-fill',
            'fingerprint',
            'fire',
            'flag',
            'flag-fill',
            'flower1',
            'flower2',
            'flower3',
            'folder',
            'folder2',
            'folder2-open',
            'folder-check',
            'folder-fill',
            'folder-minus',
            'folder-plus',
            'folder-symlink',
            'folder-symlink-fill',
            'folder-x',
            'fonts',
            'forward',
            'forward-fill',
            'front',
            'fullscreen',
            'fullscreen-exit',
            'funnel',
            'funnel-fill',
            'gear',
            'gear-fill',
            'gear-wide',
            'gear-wide-connected',
            'gem',
            'gender-ambiguous',
            'gender-female',
            'gender-male',
            'gender-trans',
            'geo',
            'geo-alt',
            'geo-alt-fill',
            'geo-fill',
            'gift',
            'gift-fill',
            'git',
            'github',
            'globe',
            'globe2',
            'google',
            'google-play',
            'gpu-card',
            'graph-down',
            'graph-down-arrow',
            'graph-up',
            'graph-up-arrow',
            'grid',
            'grid-1x2',
            'grid-1x2-fill',
            'grid-3x2',
            'grid-3x2-gap',
            'grid-3x2-gap-fill',
            'grid-3x3',
            'grid-3x3-gap',
            'grid-3x3-gap-fill',
            'grid-fill',
            'grip-horizontal',
            'grip-vertical',
            'hammer',
            'handbag',
            'handbag-fill',
            'hand-index',
            'hand-index-fill',
            'hand-index-thumb',
            'hand-index-thumb-fill',
            'hand-thumbs-down',
            'hand-thumbs-down-fill',
            'hand-thumbs-up',
            'hand-thumbs-up-fill',
            'hash',
            'h-circle',
            'h-circle-fill',
            'hdd',
            'hdd-fill',
            'hdd-network',
            'hdd-network-fill',
            'hdd-rack',
            'hdd-rack-fill',
            'hdd-stack',
            'hdd-stack-fill',
            'hdmi',
            'hdmi-fill',
            'headphones',
            'headset',
            'headset-vr',
            'heart',
            'heart-arrow',
            'heartbreak',
            'heartbreak-fill',
            'heart-fill',
            'heart-half',
            'heart-pulse',
            'heart-pulse-fill',
            'hearts',
            'heptagon',
            'heptagon-fill',
            'heptagon-half',
            'hexagon',
            'hexagon-fill',
            'hexagon-half',
            'hospital',
            'hospital-fill',
            'hourglass',
            'hourglass-bottom',
            'hourglass-split',
            'hourglass-top',
            'house',
            'house-door',
            'house-door-fill',
            'house-fill',
            'house-heart',
            'house-heart-fill',
            'hr',
            'h-square',
            'h-square-fill',
            'hurricane',
            'hypnotize',
            'image',
            'image-alt',
            'image-fill',
            'images',
            'inbox',
            'inboxes',
            'inboxes-fill',
            'inbox-fill',
            'incognito',
            'indent',
            'infinity',
            'info',
            'info-circle',
            'info-circle-fill',
            'info-lg',
            'info-square',
            'info-square-fill',
            'input-cursor',
            'input-cursor-text',
            'instagram',
            'intersect',
            'journal',
            'journal-album',
            'journal-arrow-down',
            'journal-arrow-up',
            'journal-bookmark',
            'journal-bookmark-fill',
            'journal-check',
            'journal-code',
            'journal-medical',
            'journal-minus',
            'journal-plus',
            'journal-richtext',
            'journals',
            'journal-text',
            'journal-x',
            'joystick',
            'justify',
            'justify-left',
            'justify-right',
            'kanban',
            'kanban-fill',
            'key',
            'keyboard',
            'keyboard-fill',
            'key-fill',
            'ladder',
            'lamp',
            'lamp-fill',
            'laptop',
            'laptop-fill',
            'layer-backward',
            'layer-forward',
            'layers',
            'layers-fill',
            'layers-half',
            'layout-sidebar',
            'layout-sidebar-inset',
            'layout-sidebar-inset-reverse',
            'layout-sidebar-reverse',
            'layout-split',
            'layout-text-sidebar',
            'layout-text-sidebar-reverse',
            'layout-text-window',
            'layout-text-window-reverse',
            'layout-three-columns',
            'layout-wtf',
            'life-preserver',
            'lightbulb',
            'lightbulb-fill',
            'lightbulb-off',
            'lightbulb-off-fill',
            'lightning',
            'lightning-charge',
            'lightning-charge-fill',
            'lightning-fill',
            'line',
            'link',
            'link-45deg',
            'linkedin',
            'list',
            'list-check',
            'list-columns',
            'list-columns-reverse',
            'list-nested',
            'list-ol',
            'list-stars',
            'list-task',
            'list-ul',
            'lock',
            'lock-fill',
            'lungs',
            'lungs-fill',
            'magic',
            'magnet',
            'magnet-fill',
            'mailbox',
            'mailbox2',
            'map',
            'map-fill',
            'markdown',
            'markdown-fill',
            'mask',
            'mastodon',
            'medium',
            'megaphone',
            'megaphone-fill',
            'memory',
            'menu-app',
            'menu-app-fill',
            'menu-button',
            'menu-button-fill',
            'menu-button-wide',
            'menu-button-wide-fill',
            'menu-down',
            'menu-up',
            'messenger',
            'meta',
            'mic',
            'mic-fill',
            'mic-mute',
            'mic-mute-fill',
            'microsoft',
            'microsoft-teams',
            'minecart',
            'minecart-loaded',
            'modem',
            'modem-fill',
            'moisture',
            'moon',
            'moon-fill',
            'moon-stars',
            'moon-stars-fill',
            'mortarboard',
            'mortarboard-fill',
            'motherboard',
            'motherboard-fill',
            'mouse',
            'mouse2',
            'mouse2-fill',
            'mouse3',
            'mouse3-fill',
            'mouse-fill',
            'music-note',
            'music-note-beamed',
            'music-note-list',
            'music-player',
            'music-player-fill',
            'newspaper',
            'nintendo-switch',
            'node-minus',
            'node-minus-fill',
            'node-plus',
            'node-plus-fill',
            'nut',
            'nut-fill',
            'octagon',
            'octagon-fill',
            'octagon-half',
            'optical-audio',
            'optical-audio-fill',
            'option',
            'outlet',
            'paint-bucket',
            'palette',
            'palette2',
            'palette-fill',
            'paperclip',
            'paragraph',
            'pass',
            'pass-fill',
            'patch-check',
            'patch-check-fill',
            'patch-exclamation',
            'patch-exclamation-fill',
            'patch-minus',
            'patch-minus-fill',
            'patch-plus',
            'patch-plus-fill',
            'patch-question',
            'patch-question-fill',
            'pause',
            'pause-btn',
            'pause-btn-fill',
            'pause-circle',
            'pause-circle-fill',
            'pause-fill',
            'paypal',
            'pc',
            'pc-display',
            'pc-display-horizontal',
            'pc-horizontal',
            'pci-card',
            'p-circle',
            'p-circle-fill',
            'peace',
            'peace-fill',
            'pen',
            'pencil',
            'pencil-fill',
            'pencil-square',
            'pen-fill',
            'pentagon',
            'pentagon-fill',
            'pentagon-half',
            'people',
            'people-fill',
            'percent',
            'person',
            'person-badge',
            'person-badge-fill',
            'person-bounding-box',
            'person-check',
            'person-check-fill',
            'person-circle',
            'person-dash',
            'person-dash-fill',
            'person-fill',
            'person-heart',
            'person-hearts',
            'person-lines-fill',
            'person-plus',
            'person-plus-fill',
            'person-rolodex',
            'person-square',
            'person-video',
            'person-vcard',
            'person-video2',
            'person-video3',
            'person-workspace',
            'person-x',
            'person-x-fill',
            'phone',
            'phone-fill',
            'phone-flip',
            'phone-landscape',
            'phone-landscape-fill',
            'phone-vibrate',
            'phone-vibrate-fill',
            'pie-chart',
            'pie-chart-fill',
            'piggy-bank',
            'piggy-bank-fill',
            'pin',
            'pin-angle',
            'pin-angle-fill',
            'pin-fill',
            'pin-map',
            'pin-map-fill',
            'pinterest',
            'pip',
            'pip-fill',
            'play',
            'play-btn',
            'play-btn-fill',
            'play-circle',
            'play-circle-fill',
            'play-fill',
            'playstation',
            'plug',
            'plug-fill',
            'plugin',
            'plus',
            'plus-circle',
            'plus-circle-dotted',
            'plus-circle-fill',
            'plus-lg',
            'plus-slash-minus',
            'plus-square',
            'plus-square-dotted',
            'plus-square-fill',
            'postage',
            'postage-fill',
            'postage-heart',
            'postage-heart-fill',
            'postcard',
            'postcard-fill',
            'postcard-heart',
            'postcard-heart-fill',
            'power',
            'prescription',
            'prescription2',
            'printer',
            'printer-fill',
            'projector',
            'projector-fill',
            'p-square',
            'p-square-fill',
            'puzzle',
            'puzzle-fill',
            'qr-code',
            'qr-code-scan',
            'question',
            'question-circle',
            'question-circle-fill',
            'question-diamond',
            'question-diamond-fill',
            'question-lg',
            'question-octagon',
            'question-octagon-fill',
            'question-square',
            'question-square-fill',
            'quora',
            'quote',
            'radioactive',
            'rainbow',
            'r-circle',
            'r-circle-fill',
            'receipt',
            'receipt-cutoff',
            'reception-0',
            'reception-1',
            'reception-2',
            'reception-3',
            'reception-4',
            'record',
            'record2',
            'record2-fill',
            'record-btn',
            'record-btn-fill',
            'record-circle',
            'record-circle-fill',
            'record-fill',
            'recycle',
            'reddit',
            'repeat',
            'repeat-1',
            'reply',
            'reply-all',
            'reply-all-fill',
            'reply-fill',
            'rewind',
            'rewind-btn',
            'rewind-btn-fill',
            'rewind-circle',
            'rewind-circle-fill',
            'rewind-fill',
            'robot',
            'router',
            'router-fill',
            'r-square',
            'r-square-fill',
            'rss',
            'rss-fill',
            'rulers',
            'safe',
            'safe2',
            'safe2-fill',
            'safe-fill',
            'save',
            'save2',
            'save2-fill',
            'save-fill',
            'scissors',
            'screwdriver',
            'sd-card',
            'sd-card-fill',
            'search',
            'search-heart',
            'search-heart-fill',
            'segmented-nav',
            'send',
            'send-check',
            'send-check-fill',
            'send-dash',
            'send-dash-fill',
            'send-exclamation',
            'send-exclamation-fill',
            'send-fill',
            'send-plus',
            'send-plus-fill',
            'send-slash',
            'send-slash-fill',
            'send-x',
            'send-x-fill',
            'server',
            'share',
            'share-fill',
            'shield',
            'shield-check',
            'shield-exclamation',
            'shield-fill',
            'shield-fill-check',
            'shield-fill-exclamation',
            'shield-fill-minus',
            'shield-fill-plus',
            'shield-fill-x',
            'shield-lock',
            'shield-lock-fill',
            'shield-minus',
            'shield-plus',
            'shield-shaded',
            'shield-slash',
            'shield-slash-fill',
            'shield-x',
            'shift',
            'shift-fill',
            'shop',
            'shop-window',
            'shuffle',
            'signal',
            'signpost',
            'signpost-2',
            'signpost-2-fill',
            'signpost-fill',
            'signpost-split',
            'signpost-split-fill',
            'sign-stop',
            'sign-stop-fill',
            'sign-stop-lights',
            'sign-stop-lights-fill',
            'sign-turn-left',
            'sign-turn-left-fill',
            'sign-turn-right',
            'sign-turn-right-fill',
            'sign-turn-slight-left',
            'sign-turn-slight-left-fill',
            'sign-turn-slight-right',
            'sign-turn-slight-right-fill',
            'sign-yield',
            'sign-yield-fill',
            'sim',
            'sim-fill',
            'skip-backward',
            'skip-backward-btn',
            'skip-backward-btn-fill',
            'skip-backward-circle',
            'skip-backward-circle-fill',
            'skip-backward-fill',
            'skip-end',
            'skip-end-btn',
            'skip-end-btn-fill',
            'skip-end-circle',
            'skip-end-circle-fill',
            'skip-end-fill',
            'skip-forward',
            'skip-forward-btn',
            'skip-forward-btn-fill',
            'skip-forward-circle',
            'skip-forward-circle-fill',
            'skip-forward-fill',
            'skip-start',
            'skip-start-btn',
            'skip-start-btn-fill',
            'skip-start-circle',
            'skip-start-circle-fill',
            'skip-start-fill',
            'skype',
            'slack',
            'slash',
            'slash-circle',
            'slash-circle-fill',
            'slash-lg',
            'slash-square',
            'slash-square-fill',
            'sliders',
            'sliders2',
            'sliders2-vertical',
            'smartwatch',
            'snapchat',
            'snow',
            'snow2',
            'snow3',
            'sort-alpha-down',
            'sort-alpha-down-alt',
            'sort-alpha-up',
            'sort-alpha-up-alt',
            'sort-down',
            'sort-down-alt',
            'sort-numeric-down',
            'sort-numeric-down-alt',
            'sort-numeric-up',
            'sort-numeric-up-alt',
            'sort-up',
            'sort-up-alt',
            'soundwave',
            'speaker',
            'speaker-fill',
            'speedometer',
            'speedometer2',
            'spellcheck',
            'spotify',
            'square',
            'square-fill',
            'square-half',
            'stack',
            'stack-overflow',
            'star',
            'star-fill',
            'star-half',
            'stars',
            'steam',
            'stickies',
            'stickies-fill',
            'sticky',
            'sticky-fill',
            'stop',
            'stop-btn',
            'stop-btn-fill',
            'stop-circle',
            'stop-circle-fill',
            'stop-fill',
            'stoplights',
            'stoplights-fill',
            'stopwatch',
            'stopwatch-fill',
            'strava',
            'subtract',
            'suit-club',
            'suit-club-fill',
            'suit-diamond',
            'suit-diamond-fill',
            'suit-heart',
            'suit-heart-fill',
            'suit-spade',
            'suit-spade-fill',
            'sun',
            'sun-fill',
            'sunglasses',
            'sunrise',
            'sunrise-fill',
            'sunset',
            'sunset-fill',
            'symmetry-horizontal',
            'symmetry-vertical',
            'table',
            'tablet',
            'tablet-fill',
            'tablet-landscape',
            'tablet-landscape-fill',
            'tag',
            'tag-fill',
            'tags',
            'tags-fill',
            'telegram',
            'telephone',
            'telephone-fill',
            'telephone-forward',
            'telephone-forward-fill',
            'telephone-inbound',
            'telephone-inbound-fill',
            'telephone-minus',
            'telephone-minus-fill',
            'telephone-outbound',
            'telephone-outbound-fill',
            'telephone-plus',
            'telephone-plus-fill',
            'telephone-x',
            'telephone-x-fill',
            'terminal',
            'terminal-dash',
            'terminal-fill',
            'terminal-plus',
            'terminal-split',
            'terminal-x',
            'textarea',
            'textarea-resize',
            'textarea-t',
            'text-center',
            'text-indent-left',
            'text-indent-right',
            'text-left',
            'text-paragraph',
            'text-right',
            'thermometer',
            'thermometer-half',
            'thermometer-high',
            'thermometer-low',
            'thermometer-snow',
            'thermometer-sun',
            'three-dots',
            'three-dots-vertical',
            'thunderbolt',
            'thunderbolt-fill',
            'ticket',
            'ticket-detailed',
            'ticket-detailed-fill',
            'ticket-fill',
            'ticket-perforated',
            'ticket-perforated-fill',
            'tiktok',
            'toggle2-off',
            'toggle2-on',
            'toggle-off',
            'toggle-on',
            'toggles',
            'toggles2',
            'tools',
            'tornado',
            'train-freight-front',
            'train-freight-front-fill',
            'train-front',
            'train-front-fill',
            'train-lightrail-front',
            'train-lightrail-front-fill',
            'translate',
            'trash',
            'trash2',
            'trash2-fill',
            'trash3',
            'trash3-fill',
            'trash-fill',
            'tree',
            'tree-fill',
            'triangle',
            'triangle-fill',
            'triangle-half',
            'trophy',
            'trophy-fill',
            'tropical-storm',
            'truck',
            'truck-flatbed',
            'truck-front',
            'truck-front-fill',
            'tsunami',
            'tv',
            'tv-fill',
            'twitch',
            'twitter',
            'type',
            'type-bold',
            'type-h1',
            'type-h2',
            'type-h3',
            'type-italic',
            'type-strikethrough',
            'type-underline',
            'ubuntu',
            'ui-checks',
            'ui-checks-grid',
            'ui-radios',
            'ui-radios-grid',
            'umbrella',
            'umbrella-fill',
            'unindent',
            'union',
            'unity',
            'universal-access',
            'universal-access-circle',
            'unlock',
            'unlock-fill',
            'upc',
            'upc-scan',
            'upload',
            'usb',
            'usb-c',
            'usb-c-fill',
            'usb-drive',
            'usb-drive-fill',
            'usb-fill',
            'usb-micro',
            'usb-micro-fill',
            'usb-mini',
            'usb-mini-fill',
            'usb-plug',
            'usb-plug-fill',
            'usb-symbol',
            'valentine',
            'valentine2',
            'vector-pen',
            'view-list',
            'view-stacked',
            'vimeo',
            'vinyl',
            'vinyl-fill',
            'virus',
            'virus2',
            'voicemail',
            'volume-down',
            'volume-down-fill',
            'volume-mute',
            'volume-mute-fill',
            'volume-off',
            'volume-off-fill',
            'volume-up',
            'volume-up-fill',
            'vr',
            'wallet',
            'wallet2',
            'wallet-fill',
            'watch',
            'water',
            'webcam',
            'webcam-fill',
            'wechat',
            'whatsapp',
            'wifi',
            'wifi-1',
            'wifi-2',
            'wifi-off',
            'wind',
            'window',
            'window-dash',
            'window-desktop',
            'window-dock',
            'window-fullscreen',
            'window-plus',
            'windows',
            'window-sidebar',
            'window-split',
            'window-stack',
            'window-x',
            'wordpress',
            'wrench',
            'wrench-adjustable',
            'wrench-adjustable-circle',
            'wrench-adjustable-circle-fill',
            'x',
            'xbox',
            'x-circle',
            'x-circle-fill',
            'x-diamond',
            'x-diamond-fill',
            'x-lg',
            'x-octagon',
            'x-octagon-fill',
            'x-square',
            'x-square-fill',
            'yelp',
            'yin-yang',
            'youtube',
            'zoom-in',
            'zoom-out',
            '1-circle',
            '1-circle-fill'
        ],
    ];
}
