/* ========================================================================
 * TastyIgniter: flashmessage.js v2.2.0
 * https://tastyigniter.com/docs/javascript
 * ======================================================================== */
+function ($) {
    "use strict"

    var FlashMessage = function (options, el) {
        var options = $.extend({}, FlashMessage.DEFAULTS, options),
            $element = $(el)

        $('body > p.flash-message').remove()

        if ($element.length === 0) {
            $element = $('<div />', {
                class: 'alert alert-'+options.class
            }).html(options.text)
        }

        $element.addClass('flash-message animated fadeInDown')
        $element.attr('data-control', null)

        if (options.allowDismiss) {
            $element.addClass('alert-dismissible')
            $element.append('<button type="button" class="btn-close" data-bs-dismiss="alert" aria-hidden="true"></button>')
        }

        $element.on('click', 'button', remove)
        if (options.interval > 0) $element.on('click', remove)

        $(options.container).prepend($element)

        var timer = null

        setTimeout(function () {
            $element.addClass('show')
        }, 100)

        if (options.allowDismiss && options.interval > 0)
            timer = window.setTimeout(remove, options.interval * 1000)

        function removeElement() {
            $element.remove()
        }

        function remove() {
            window.clearInterval(timer)

            $element.addClass('fadeOutUp')
            $element.on('animationend', () => {
                removeElement()
            });
        }
    }

    FlashMessage.DEFAULTS = {
        container: '#notification',
        class: 'success',
        text: 'text',
        interval: 5,
        allowDismiss: true,
    }

    // FLASH MESSAGE PLUGIN DEFINITION
    // ============================

    if ($.ti === undefined)
        $.ti = {}

    $.ti.flashMessage = FlashMessage

    // FLASH MESSAGE DATA-API
    // ===============

    $(document).render(function () {
        $('[data-control="flash-message"]').each(function (index, element) {
            setTimeout(function () {
                $.ti.flashMessage($(element).data(), element)
            }, (index + 1) * 500)
        })

        $('[data-control="flash-overlay"]').each(function (index, element) {
            var $this = $(element),
                options = $.extend({}, $this.data(), $this.data('closeOnEsc') === true ? {
                timer: (index + 1) * 3000
            } : {})
            Swal.fire(options)
        })
    })

    $(document).on('ajaxValidation', '[data-request][data-request-validate]', function (event, context, errorMsg, fields) {
        var $this = $(this).closest('form'),
            $container = $('[data-validate-error]', $this),
            messages = [],
            $field

        $.each(fields, function (fieldName, fieldMessages) {
            $field = $('[data-validate-for="' + fieldName + '"]', $this)
            messages = $.merge(messages, fieldMessages)
            if (!!$field.length) {
                if (!$field.text().length || $field.data('emptyMode') == true) {
                    $field
                        .data('emptyMode', true)
                        .text(fieldMessages.join(', '))
                }
                $field.addClass('visible')
            }
        })

        if (!!$container.length) {
            $container = $('[data-validate-error]', $this)
        }

        if (!!$container.length) {
            var $oldMessages = $('[data-message]', $container)
            $container.addClass('visible')

            if (!!$oldMessages.length) {
                var $clone = $oldMessages.first()

                $.each(messages, function (key, message) {
                    $clone.clone().text(message).insertAfter($clone)
                })

                $oldMessages.remove()
            } else {
                $container.text(errorMsg)
            }
        }

        $this.one('ajaxError', function (event) {
            event.preventDefault()
        })
    })

    $(document).on('ajaxPromise', '[data-request][data-request-validate]', function () {
        var $this = $(this).closest('form')
        $('[data-validate-for]', $this).removeClass('visible')
        $('[data-validate-error]', $this).removeClass('visible')
    })

}(window.jQuery)
