<?php
/**
||-> Shortcode: Skills
*/
function sweetthemes_skills_shortcode($params, $content) {
    extract( shortcode_atts( 
        array(
            'title'                    => '',
            'skillvalue'               => '',
            'text_color_value'         => '',
            'number_color_value'       => '',
            'image_skill'              => ''
        ), $params ) );
    $image_skill      = wp_get_attachment_image_src($image_skill, "");
    $image_skillsrc  = $image_skill[0];
    $skill = '';
    $skill .= '<div style="background:url('.esc_attr($image_skillsrc).');" class="stats-block statistics">';
        $skill .= '<div class="stats-content percentage" data-perc="'.esc_attr($skillvalue).'">';
          $skill .= '<span class="skill-count" style="color: '.esc_attr($text_color_value).'">'.esc_attr($skillvalue).'</span>';
          $skill .= '<p style="color: '.esc_attr($number_color_value).'">'.esc_attr($title).'</p>';
        $skill .= '</div>';
    $skill .= '</div>';
    return $skill;
}
add_shortcode('st_skill', 'sweetthemes_skills_shortcode');
/**
||-> Map Shortcode in Visual Composer with: vc_map();
*/
if ( is_plugin_active( 'js_composer/js_composer.php' ) ) {
    require_once __DIR__ . '/../vc-shortcodes.inc.arrays.php';
  #SHORTCODE: Skill counter shortcode
  vc_map( array(
     "name" => esc_attr__("ST - Skill counter", 'sweetthemes'),
     "base" => "st_skill",
     "category" => esc_attr__('MT: SweetThemes', 'sweetthemes'),
     "icon" => "venor_shortcode",
     "params" => array(
        array(
          "group" => "Options",
          "type" => "attach_images",
          "holder" => "div",
          "class" => "",
          "heading" => esc_attr__( "Choose image", 'sweetthemes' ),
          "param_name" => "image_skill",
          "value" => "",
          "description" => esc_attr__( "Choose image for skill", 'sweetthemes' )
        ),
        array(
           "group" => "Options",
           "type" => "textfield",
           "holder" => "div",
           "class" => "",
           "heading" => esc_attr__("Title", 'sweetthemes'),
           "param_name" => "title",
           "value" => "",
           "description" => ""
        ),
        array(
          "group" => "Styling",
          "type" => "colorpicker",
          "class" => "",
          "heading" => esc_attr__( "Text color", 'sweetthemes' ),
          "param_name" => "text_color_value",
          "value" => "", //Default color
          "description" => esc_attr__( "Choose text color", 'sweetthemes' )
        ),
        array(
          "group" => "Styling",
          "type" => "colorpicker",
          "class" => "",
          "heading" => esc_attr__( "Skill value color", 'sweetthemes' ),
          "param_name" => "number_color_value",
          "value" => "", //Default color
          "description" => esc_attr__( "Choose skill value color", 'sweetthemes' )
        ),
        array(
           "group" => "Options",
           "type" => "textfield",
           "holder" => "div",
           "class" => "",
           "heading" => esc_attr__("Skill value", 'sweetthemes'),
           "param_name" => "skillvalue",
           "value" => "",
           "description" => ""
        )
     )
  ));
}