<?php 
require_once(__DIR__.'/../vc-shortcodes.inc.arrays.php');
/**
||-> Shortcode: Info boxes
*/
function st_shortcode_info_box($params,  $content = NULL) {
    extract( shortcode_atts( 
        array(

          'el_class'  => ''

        ), $params ) );

    $info_box = '';

    $info_box .= '<div class="info_box_shortcode '.$el_class.'">';
      $info_box .= '<div class="row service_info_box">';
        $info_box .= do_shortcode($content);
      $info_box .= '</div>';
    $info_box .= '</div>'; 

    return $info_box;
}
add_shortcode('st_shortcode_info_box_short', 'st_shortcode_info_box');
/**
||-> Shortcode: Child Shortcode v1
*/
function st_shortcode_info_box_items($params, $content = NULL) {

    extract( shortcode_atts( 
        array(

          'info_box_image' => '',
          'info_box_heading_icon' => '',
          'info_box_heading_text' => '',
          'info_box_paragraph_text' => '',
          'info_box_button_text' => '',
          'info_box_button_icon' => '',
          'info_box_button_link' => '',

          'info_box_background_color_overlay' => '',
          'info_box_bottom_section_background_color' => '',
          'info_box_icon_heading_color' => '',
          'info_box_icon_content_overlay_color' => '',
          'info_box_icon_icon_overlay_color' => '',

          'info_box_width' => '',

          'animation'        => '',
          
        
        ), $params ) );

    $animation_final = '';
    if(!empty($animation)) {
        $animation_final = 'wow ' . $animation;
    }

    $thumb      = wp_get_attachment_image_src($info_box_image, "sweetthemes_info_box");
  	$thumb_src  = $thumb[0];

    $info_box = '';

    $unique_id = 'info_box_'.uniqid();

    $info_box = '<style>
      .'.$unique_id.' .default_link:hover{
          color: '.$info_box_icon_icon_overlay_color.' !important;
      }
    </style>';

    $info_box .= '<div class="'.$info_box_width.' '.$unique_id.' '.$animation_final.'">
     <div class="item">
        <figure class="img-box">
           <a href="#"><img alt="info-box-img" src="'.$thumb_src.'"></a>
           <div style="background: '.esc_attr($info_box_bottom_section_background_color).'" class="bottom-content">
              <div class="clearfix">
                 <div class="icon_box">
                    <span style="color: '.esc_attr($info_box_icon_heading_color).'" class="'.esc_attr($info_box_heading_icon).'"></span>
                 </div>
                 <h4 style="color: '.esc_attr($info_box_icon_heading_color).'">'.$info_box_heading_text.'</h4>
              </div>
           </div>
           <div style="background-color: '.esc_attr($info_box_background_color_overlay).'" class="overlay-box">
              <div class="inner-box">
                 <div class="clearfix">
                    <div class="icon_box">
                       <span style="color: '.esc_attr($info_box_icon_icon_overlay_color).'" class="'.esc_attr($info_box_heading_icon).'"></span>
                    </div>
                    <h4 style="color: '.esc_attr($info_box_icon_content_overlay_color).'">'.$info_box_heading_text.'</h4>
                 </div>
                 <div class="text">
                    <p style="color: '.esc_attr($info_box_icon_content_overlay_color).'">'.$info_box_paragraph_text.'</p>
                 </div>
                 <div class="div-link">
                    <a style="color: '.esc_attr($info_box_icon_content_overlay_color).'" href="'.$info_box_button_link.'" class="default_link">'.$info_box_button_text.' <i class="'.esc_attr($info_box_button_icon).'"></i></a>
                 </div>
              </div>
           </div>
        </figure>
     </div>';
    $info_box .= '</div>';

    return $info_box;
}
add_shortcode('st_shortcode_info_box_short_item', 'st_shortcode_info_box_items');
/**
||-> Map Shortcode in Visual Composer with: vc_map();
*/
if ( is_plugin_active( 'js_composer/js_composer.php' ) ) {
    //require_once('../vc-shortcodes.inc.arrays.php');
    //Register "container" content element. It will hold all your inner (child) content elements
    vc_map( array(
        "name" => esc_attr__("ST - Info Box", 'sweetthemes'),
        "base" => "st_shortcode_info_box_short",
        "as_parent" => array('only' => 'st_shortcode_info_box_short_item'), 
        "content_element" => true,
        "show_settings_on_create" => true,
        "icon" => "venor_shortcode",
        "category" => esc_attr__('ST: SweetThemes', 'sweetthemes'),
        "is_container" => true,
        "params" => array(
            // add params same as with any other content element
          array(
               "group" => "Options",
               "type" => "textfield",
               "holder" => "div",
               "class" => "",
               "heading" => esc_attr__("Custom Class", 'sweetthemes'),
               "param_name" => "el_class",
               "value" => "",
               "description" => ""
          ),    
        ),
        "js_view" => 'VcColumnView'
    ) );
    vc_map( array(
        "name" => esc_attr__("Info Box Item", 'sweetthemes'),
        "base" => "st_shortcode_info_box_short_item",
        "content_element" => true,
        "as_child" => array('only' => 'st_shortcode_info_box_short'), // Use only|except attributes to limit parent (separate multiple values with comma)
        "params" => array(
            // add params same as with any other content element
            array(
                "group" => "Styling",
                "type" => "dropdown",
                "holder" => "div",
                "std" => '',
                "class" => "",
                "heading" => esc_attr__("Info box width", 'sweetthemes'),
                "param_name" => "info_box_width",
                "description" => "",
                "value" => array(
                    esc_attr__('1/2 from row', 'sweetthemes') => 'col-xs-6 col-sm-6 col-md-6',
                    esc_attr__('1/3 from row', 'sweetthemes') => 'col-xs-6 col-sm-6 col-md-4'
                )
            ),
        	  array(
    	        "group" => "Content Setup",
    	        "type" => "attach_images",
    	        "heading" => esc_attr__("Icon", 'sweetthemes'),
    	        "param_name" => "info_box_image",
    	        "std" => '',
    	        "holder" => "div",
    	        "class" => "",
    	        "description" => ""
        	 ),
            array(
              "group" => "Content Setup",
              "type" => "dropdown",
              "heading" => esc_attr__("Heading Icon", 'sweetthemes'),
              "param_name" => "info_box_heading_icon",
              "std" => '',
              "holder" => "div",
              "class" => "",
              "description" => "",
              "value" => $fa_list
            ),
            array(
               "group" => "Content Setup",
               "type" => "textfield",
               "holder" => "div",
               "class" => "",
               "heading" => esc_attr__("Heading Text", 'sweetthemes'),
               "param_name" => "info_box_heading_text",
               "value" => "",
               "description" => ""
            ),
            array(
               "group" => "Content Setup",
               "type" => "textfield",
               "holder" => "div",
               "class" => "",
               "heading" => esc_attr__("Paragraph Text", 'sweetthemes'),
               "param_name" => "info_box_paragraph_text",
               "value" => "",
               "description" => ""
            ),
            array(
               "group" => "Content Setup",
               "type" => "textfield",
               "holder" => "div",
               "class" => "",
               "heading" => esc_attr__("Button Text", 'sweetthemes'),
               "param_name" => "info_box_button_text",
               "value" => "",
               "description" => ""
            ),
            array(
              "group" => "Content Setup",
              "type" => "dropdown",
              "heading" => esc_attr__("Button Icon", 'sweetthemes'),
              "param_name" => "info_box_button_icon",
              "std" => '',
              "holder" => "div",
              "class" => "",
              "description" => "",
              "value" => $fa_list
            ),
            array(
               "group" => "Content Setup",
               "type" => "textfield",
               "holder" => "div",
               "class" => "",
               "heading" => esc_attr__("Button link", 'sweetthemes'),
               "param_name" => "info_box_button_link",
               "value" => "",
               "description" => ""
            ),         

            array(
               "group" => "Styling",
               "type" => "colorpicker",
               "holder" => "div",
               "class" => "",
               "heading" => esc_attr__("Box overlay - background color", 'sweetthemes'),
               "param_name" => "info_box_background_color_overlay",
               "value" => esc_attr__("", 'sweetthemes'),
               "description" => ""
            ),
            array(
               "group" => "Styling",
               "type" => "colorpicker",
               "holder" => "div",
               "class" => "",
               "heading" => esc_attr__("Box bottom section - background color", 'sweetthemes'),
               "param_name" => "info_box_bottom_section_background_color",
               "value" => esc_attr__("", 'sweetthemes'),
               "description" => ""
            ),
            array(
               "group" => "Styling",
               "type" => "colorpicker",
               "holder" => "div",
               "class" => "",
               "heading" => esc_attr__("Icon and heading - color", 'sweetthemes'),
               "param_name" => "info_box_icon_heading_color",
               "value" => esc_attr__("", 'sweetthemes'),
               "description" => ""
            ),
            array(
               "group" => "Styling",
               "type" => "colorpicker",
               "holder" => "div",
               "class" => "",
               "heading" => esc_attr__("Content overlay - color", 'sweetthemes'),
               "param_name" => "info_box_icon_content_overlay_color",
               "value" => esc_attr__("", 'sweetthemes'),
               "description" => ""
            ),
            array(
               "group" => "Styling",
               "type" => "colorpicker",
               "holder" => "div",
               "class" => "",
               "heading" => esc_attr__("Icon overlay - color", 'sweetthemes'),
               "param_name" => "info_box_icon_icon_overlay_color",
               "value" => esc_attr__("", 'sweetthemes'),
               "description" => ""
            ),
            array(
              "group" => "Animation",
              "type" => "dropdown",
              "heading" => esc_attr__("Animation", 'sweetthemes'),
              "param_name" => "animation",
              "std" => '',
              "holder" => "div",
              "class" => "",
              "description" => "",
              "value" => $animations_list
            )
        )
    ) );
    //Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
    if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
        class WPBakeryShortCode_st_shortcode_info_box_short extends WPBakeryShortCodesContainer {
        }
    }
    if ( class_exists( 'WPBakeryShortCode' ) ) {
        class WPBakeryShortCode_st_shortcode_info_box_short_item extends WPBakeryShortCode {
        }
    }
}
?>