# -*- coding: utf-8 -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2021 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

"""
This module contains SSA manager utility main run function
"""
import sys
from .cmdline_parser import cmd_parser_manager, parse_cmd_arguments
from .validations import validate
from ..internal.utils import configure_logging
from ..internal.constants import manager_log
from ..manager import initialize_manager
from ..internal.exceptions import SSAError


def run() -> None:
    """
    Main run function
    """
    configure_logging(manager_log)
    try:
        args = parse_cmd_arguments(cmd_parser_manager())
        cmd, validated_args = validate(args.__dict__)
    except SSAError as e:
        print(e)
        sys.exit(1)
    manager_run(cmd, **validated_args)


def manager_run(command, *args, **kwargs):
    """
    SSA Manager run function
    """
    try:
        manager_instance = initialize_manager()
        if command == 'set-config':
            result = manager_instance.set_config(kwargs)
        elif command == 'get-config':
            result = manager_instance.get_config()
        elif command == 'get-ssa-status':
            result = manager_instance.get_ssa_status()
        elif command == 'enable-ssa':
            result = manager_instance.enable_ssa()
        elif command == 'disable-ssa':
            result = manager_instance.disable_ssa()
        elif command == 'get-report':
            result = manager_instance.get_report()
        elif command == 'get-stat':
            result = manager_instance.get_stats()
        else:
            raise SSAError(f'Unknown action {command}')
        print(result)
    except SSAError as e:
        print(e)
        sys.exit(1)
