# -*- coding: utf-8 -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2021 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

"""
This module contains SSA Agent main run function
"""
import sys

from ssa.agent import SimpleAgent as Agent
from ssa.internal.constants import agent_log
from ssa.internal.exceptions import SSAError
from ssa.internal.tools import register_sigterm
from ssa.internal.utils import configure_logging


def run() -> None:
    """
    Main run function
    """
    configure_logging(agent_log)
    register_sigterm()

    try:
        agent = Agent()
        agent()
    except SSAError as e:
        print(e)
        sys.exit(1)
