<?php
// Version: 2.1.3; Install

// These should be the same as those in index.language.php.
$txt['lang_character_set'] = 'UTF-8';
$txt['lang_rtl'] = '0';

$txt['install_step_welcome'] = 'Willkommen';
$txt['install_step_writable'] = 'Beschreibbarkeitsprüfung';
$txt['install_step_forum'] = 'Forums Einstellungen';
$txt['install_step_databaseset'] = 'Datenbank Einstellungen';
$txt['install_step_databasechange'] = 'Datenbank Befüllung';
$txt['install_step_admin'] = 'Administrator-Benutzerkonto';
$txt['install_step_delete'] = 'Installation abschlie&szlig;en';

$txt['smf_installer'] = 'SMF-Installation';
$txt['installer_language'] = 'Sprache';
$txt['installer_language_set'] = 'Speichern';
$txt['congratulations'] = 'Glückwunsch, die Installation ist abgeschlossen!';
$txt['congratulations_help'] = 'Wenn du Unterstützung brauchst oder SMF nicht einwandfrei läuft, denke bitte daran, dass <a href="https://www.simplemachines.org/community/index.php" target="_blank" rel="noopener">wir dir helfen können</a>, falls du es wünschst.';
$txt['still_writable'] = 'Dein Installationsverzeichnis ist noch beschreibbar. Es ist aus Sicherheitsgründen sinnvoll, die chmod-Berechtigungen zu ändern, so dass es schreibgeschützt ist.';
$txt['delete_installer'] = 'Klicke hier, um diese „install.php“-Datei zu löschen';
$txt['delete_installer_maybe'] = '<em>(funktioniert nicht auf allen Servern).</em>';
$txt['go_to_your_forum'] = 'Jetzt kannst du <a href="%s">dein neues Forum</a> ansehen und benutzen. Sobald du dich eingeloggt hast, kannst du auf das Administrationszentrum zugreifen.';
$txt['good_luck'] = 'Viel Glück!<br>Simple Machines';

$txt['install_welcome'] = 'Willkommen';
$txt['install_welcome_desc'] = 'Willkommen bei SMF. Dieses Skript wird dich durch den Installationsprozess von %1$s führen. Im Folgenden werden einige Daten über dein Forum gesammelt und in ein paar Minuten wird es verfügbar sein.';
$txt['install_no_https'] = 'Deine Umgebung unterstützt keine HTTPS-Streams. Einige Funktionen, z. B. das Empfangen von Updates von simplemachines.org, werden nicht funktionieren.';
$txt['install_no_mbstring'] = 'Deine Umgebung unterstützt die benötigte mbstring-Bibliothek nicht. Bitte aktiviere mbstring und versuche es dann erneut.';
$txt['install_no_fileinfo'] = 'Deine Umgebung unterstützt die benötigte fileinfo-Bibliothek nicht. Bitte aktiviere fileinfo und versuche es dann erneut.';
$txt['install_all_lovely'] = 'Ein paar Eingangstests wurden durchgeführt, und alles scheint in Ordnung zu sein. Betätige den "Fortfahren" Button unten um zu beginnen.';

$txt['user_refresh_install'] = 'Forum aktualisiert';
$txt['user_refresh_install_desc'] = 'Während der Installation wurde festgestellt, dass (mit den von dir eingegebenen Daten) eine oder mehrere Datenbanktabellen, die das Installationsskript anlegen könnte, bereits existieren.<br>Alle fehlenden Tabellen deiner Installation wurden mit den Standard-Daten frisch erstellt, aus den vorhandenen Tabellen wurden aber keine Daten gelöscht.';

$txt['default_topic_subject'] = 'Willkommen bei SMF!';
$txt['default_topic_message'] = 'Willkommen im Simple-Machines-Forum!<br><br>Wir hoffen, dass dir dein neues Forum Spaß macht.&nbsp; Wenn du Probleme hast, zögere nicht, uns [url=https://www.simplemachines.org/community/index.php]um Hilfe zu fragen[/url].<br><br>Danke!<br>Simple Machines';
$txt['default_board_name'] = 'Allgemeine Diskussionen';
$txt['default_board_description'] = 'Diskutiere in diesem Board über alles, was dir einfällt.';
$txt['default_category_name'] = 'Kategorie';
$txt['default_time_format'] = '%d. %B %Y, %H:%M:%S';
$txt['default_news'] = 'SMF - Neu installiert!';
$txt['default_reserved_names'] = 'Administrator\nAdmin\nWebmaster\nGast\nroot';
$txt['default_fugue_smileyset_name'] = 'Fugues Sammlung';
$txt['default_alienine_smileyset_name'] = 'Alienines Sammlung';
$txt['default_aaron_smileyset_name'] = 'Aarons Sammlung';
$txt['default_akyhne_smileyset_name'] = 'Akyhnes Sammlung';
$txt['default_legacy_smileyset_name'] = '2.0-Standard';
$txt['default_theme_name'] = 'SMF Standard-Theme - Curve';

$txt['default_administrator_group'] = 'Administratoren';
$txt['default_global_moderator_group'] = 'Globaler Moderator';
$txt['default_moderator_group'] = 'Moderator';
$txt['default_newbie_group'] = 'Neuling';
$txt['default_junior_group'] = 'Jr. Mitglied';
$txt['default_full_group'] = 'Vollwertiges Mitglied';
$txt['default_senior_group'] = 'Sr. Mitglied';
$txt['default_hero_group'] = 'Held Mitglied';

$txt['default_smiley_smiley'] = 'Smiley';
$txt['default_wink_smiley'] = 'Zwinker';
$txt['default_cheesy_smiley'] = 'Lächeln';
$txt['default_grin_smiley'] = 'Grins';
$txt['default_angry_smiley'] = 'Wütend';
$txt['default_sad_smiley'] = 'Traurig';
$txt['default_shocked_smiley'] = 'Schockiert';
$txt['default_cool_smiley'] = 'Cool';
$txt['default_huh_smiley'] = 'Hä?';
$txt['default_roll_eyes_smiley'] = 'Augenrollen';
$txt['default_tongue_smiley'] = 'Zunge';
$txt['default_embarrassed_smiley'] = 'Verlegen';
$txt['default_lips_sealed_smiley'] = 'Schweigend';
$txt['default_undecided_smiley'] = 'Unentschlossen';
$txt['default_kiss_smiley'] = 'Kuss';
$txt['default_cry_smiley'] = 'Heul';
$txt['default_evil_smiley'] = 'Teuflisch';
$txt['default_azn_smiley'] = 'Asiatisch';
$txt['default_afro_smiley'] = 'Afro';
$txt['default_laugh_smiley'] = 'Lach';
$txt['default_police_smiley'] = 'Polizei';
$txt['default_angel_smiley'] = 'Engel';

$txt['error_message_click'] = 'Klicke hier,';
$txt['error_message_try_again'] = 'um den Schritt erneut zu versuchen.';
$txt['error_message_bad_try_again'] = 'um trotzdem zu installieren. Beachte bitte, dass dies <i>nicht</i> empfehlenswert ist.';

$txt['install_settings'] = 'Einstellungen';
$txt['install_settings_info'] = 'Nur ein paar Einstellungen ;).';
$txt['install_settings_name'] = 'Name des Forums';
$txt['install_settings_name_info'] = 'Das ist der Name deines Forums, z. B. „Das Test-Forum“.';
$txt['install_settings_name_default'] = 'Mein Forum';
$txt['install_settings_url'] = 'Forums-URL';
$txt['install_settings_url_info'] = 'Dies ist die URL zu deinem Forum <strong>ohne den abschließenden "/"!</strong>.<br>In den meisten Fällen kannst du den voreingestellten Wert belassen – normalerweise stimmt er.';
$txt['install_settings_reg_mode'] = 'Registrierungs-Modus';
$txt['install_settings_reg_modes'] = 'Registrierungs-Modi';
$txt['install_settings_reg_immediate'] = 'Sofortige Registrierung';
$txt['install_settings_reg_email'] = 'E-Mail-Aktivierung';
$txt['install_settings_reg_admin'] = 'Admin-Genehmigung';
$txt['install_settings_reg_disabled'] = 'Registrierung abgeschaltet';
$txt['install_settings_reg_mode_info'] = 'Dieses Feld erlaubt es dir, den Registrierungsmodus bereits bei der Installtions zu ändern, um ungewollte Registrierungen zu vermeiden.';
$txt['install_settings_compress'] = 'Gzip Ausgabe';
$txt['install_settings_compress_title'] = 'Komprimiere Datenausgabe um Bandbreite zu sparen.';
// In this string, you can translate the word "PASS" to change what it says when the test passes.
$txt['install_settings_compress_info'] = 'Diese Option funktioniert nicht auf allen Servern, kann aber eine Menge Bandbreite sparen.<br>Klicke <a href="install.php?obgz=1&amp;pass_string=Erfolgreich" onclick="return reqWin(this.href, 200, 60);" target="_blank">hier</a> um es zu testen (der Test sollte „Erfolgreich“ zurückmelden).';
$txt['install_settings_dbsession'] = 'Datenbanksitzungen';
$txt['install_settings_dbsession_title'] = 'Benutze die Datenbank für Sitzungen anstelle von Dateien.';
$txt['install_settings_dbsession_info1'] = 'Diese Option ist fast immer die beste Wahl, da sie Sitzungen zuverlässiger macht.';
$txt['install_settings_dbsession_info2'] = 'Diese Option wird wahrscheinlich nicht fehlerfrei auf diesem Server funktionieren.';
$txt['install_settings_stats'] = 'Sammeln von Statistiken erlauben';
$txt['install_settings_stats_title'] = 'Erlaubt Simple Machines das Sammeln von monatlichen Statistiken';
$txt['install_settings_stats_info'] = 'Falls aktiviert, erlaubt dies Simple Machines, deine Webseite monatlich zu besuchen, um grundlegende Statistiken zu sammeln. Dies hilft uns, Entscheidungen zu treffen, für welche Konfigurationen die Software optimiert wird. Für weitere Informationen besuche bitte unsere <a href="https://www.simplemachines.org/about/stats.php" target="_blank" rel="noopener">Informationsseite</a>.';
$txt['install_settings_proceed'] = 'Weiter';

$txt['db_settings'] = 'Datenbankservereinstellungen';
$txt['db_settings_info'] = 'Gib hier die Einstellungen für deinen Datenbankserver ein. Solltest du diese Daten nicht kennen, frage deinen Serveranbieter.';
$txt['db_settings_type'] = 'Datenbanktyp';
$txt['db_settings_type_info'] = 'Mehrere unterstützte Datenbanktypen wurden erkannt – bitte wähle den gewünschten Typ aus. Bitte beachte, dass es nicht möglich ist, SMF-Versionen vor 2.0 RC3 gleichzeitig mit neueren SMF-Versionen in derselben PostgreSQL-Datenbank zu betreiben. In diesem Fall musst du deine älteren Installationen aktualisieren.';
$txt['db_settings_server'] = 'Servername';
$txt['db_settings_server_info'] = 'Dies ist fast immer „localhost“ – solltest du ihn nicht wissen, versuche „localhost“.';
$txt['db_settings_username'] = 'Benutzername';
$txt['db_settings_username_info'] = 'Trage hier den Benutzernamen ein, den du zum Verbinden mit deiner Datenbank benötigst.<br>Solltest du ihn nicht wissen, versuche den Benutzernamen deines FTP-Zugangs, da diese oft übereinstimmen.';
$txt['db_settings_password'] = 'Passwort';
$txt['db_settings_password_info'] = 'Trage hier das Passwort ein, das du zum Verbinden mit deiner Datenbank benötigst.<br>Solltest du es nicht wissen, versuche das Passwort deines FTP-Zugangs.';
$txt['db_settings_database'] = 'Datenbankname';
$txt['db_settings_database_info'] = 'Trage hier den Namen der Datenbank ein, die du für die Speicherung der SMF-Daten benutzen möchtest.';
$txt['db_settings_database_info_note'] = 'Falls diese Datenbank nicht existiert, wird dieses Installationsscript versuchen sie zu erstellen.';
$txt['db_settings_port'] = 'Datenbank-Port';
$txt['db_settings_port_info'] = 'Lass dies leer, um den Standardwert zu verwenden';
$txt['db_settings_prefix'] = 'Tabellenpräfix';
$txt['db_settings_prefix_info'] = 'Das Präfix (Vorsilbe) für jede Tabelle in der Datenbank. <strong>Installiere niemals zwei Foren mit demselben Präfix!</strong><br>Diese Option erlaubt mehrere Installationen in einer Datenbank.';
$txt['db_populate'] = 'Datenbank Initialisiert';
$txt['db_populate_info'] = 'Deine Einstellungen wurden nun gespeichert und deine Datenbank mit den nötigen Werten initialisiert um dein Forum funktionstüchtig zu machen. Zusammenfassung der Initialisierung:';
$txt['db_populate_info2'] = 'Klicke auf "Fortfahren" um zur Administratorenkonto Erzeugungsseite zu gelangen.';
$txt['db_populate_inserts'] = '%1$d Zeilen eingefügt.';
$txt['db_populate_tables'] = '%1$d Tabellen erstellt.';
$txt['db_populate_insert_dups'] = '%1$d doppelte Einträge ignoriert.';
$txt['db_populate_table_dups'] = '%1$d doppelte Tabellen ignoriert.';

$txt['user_settings'] = 'Benutzerkonto erstellen';
$txt['user_settings_info'] = 'Das Installationsprogramm wird nun ein neues Administratorkonto für dich erstellen.';
$txt['user_settings_username'] = 'Dein Benutzername';
$txt['user_settings_username_info'] = 'Trage hier den Namen ein, mit dem du dich später einloggen möchtest.<br>Dies kann später geändert werden.';
$txt['user_settings_password'] = 'Passwort';
$txt['user_settings_password_info'] = 'Setze hier das gewünschte Passwort und merke es dir gut!';
$txt['user_settings_again'] = 'Passwort';
$txt['user_settings_again_info'] = '(zur Bestätigung).';
$txt['user_settings_admin_email'] = 'Administrator-E-Mail-Adresse';
$txt['user_settings_admin_email_info'] = 'Gib deine E-Mail-Adresse an. Dies muss eine gültige E-Mail-Adresse sein!';
$txt['user_settings_server_email'] = 'Webmaster-E-Mail-Adresse';
$txt['user_settings_server_email_info'] = 'Gib <strong>die E-Mail-Adresse ein, die SMF nutzen wird, um E-Mails zu verschicken</strong>. Dies muss eine gültige E-Mail-Adresse sein!';
$txt['user_settings_database'] = 'MySQL Datenbank-Passwort';
$txt['user_settings_database_info'] = 'Aus Sicherheitsgründen erfordert das Installationsprogramm die Eingabe des Datenbankpassworts zur Erzeugung eines Administrations-Kontos.';
$txt['user_settings_skip'] = 'Überspringen';
$txt['user_settings_skip_sure'] = 'Bist du sicher, dass du die Erzeugung des Administratorkontos überspringen möchtest?';
$txt['user_settings_proceed'] = 'Fertig';

$txt['ftp_checking_writable'] = 'Überprüfe, ob Dateien geschrieben werden können';
$txt['ftp_setup'] = 'FTP-Verbindungsinformationen';
$txt['ftp_setup_info'] = 'Dieses Installationsprogramm kann sich per FTP mit dem Server verbinden und die Dateien beschreibbar machen, die es erfordern. Sollte dies nicht funktionieren, musst du dich selbst einloggen und dies manuell machen. Bitte beachte, dass hierfür SSL momentan nicht unterstützt wird.';
$txt['ftp_setup_why'] = 'Was macht dieser Schritt?';
$txt['ftp_setup_why_info'] = 'Einige Dateien müssen beschreibbar sein, damit SMF richtig funktioniert. Dieser Schritt ermöglicht dem Installationsskript, dies selbsttätig zu ändern. In manchen Fällen kann es vorkommen, dass dies nicht funktioniert – ändere dann bitte bei folgenden Dateien die Berechtigungen auf 777 (beschreibbar, 755 auf einigen Servern):';
$txt['ftp_setup_again'] = 'Erneut testen, ob die Dateien beschreibbar sind.';

$txt['error_missing_files'] = 'Einige wichtige Dateien konnten im Verzeichnis des Installationsskripts nicht gefunden werden!<br><br>Bitte vergewissere dich, dass du alle Dateien – inklusive der sql-Datei – hochgeladen hast und versuche es erneut.';
$txt['error_session_save_path'] = 'Bitte informiere Deinen Serveranbieter, dass der <strong>session.save_path in der Datei php.ini</strong> ungültig ist! Der Pfad sollte auf ein Verzeichnis verweisen, das <strong>existiert</strong> und vom Benutzer, unter dem PHP läuft, <strong>beschreibbar</strong> ist.<br>';
$txt['error_windows_chmod'] = 'Du benutzt einen Windows-Server und einige wichtige Dateien sind nicht beschreibbar. Bitte deinen Serveranbieter um <strong>Schreibberechtigungen</strong> für den Benutzer, unter dem PHP läuft, für die Dateien deiner SMF-Installation. Die folgenden Dateien müssen beschreibbar sein:';
$txt['settings_error'] = 'Deine Einstellungen kontnen nicht in Settings.php gespeichert werden.';
$txt['error_ftp_no_connect'] = 'Die Verbindung zum FTP-Server ist mit den angegebenen Daten nicht möglich.';
$txt['error_db_file'] = 'Das Datenbankskript kann nicht gefunden werden! Bitte prüfe, ob sich die Datei „%1$s“ im Forumsverzeichnis befindet.';
$txt['error_db_connect'] = 'Die Verbindung zum Datenbankserver kann mit den angegebenen Daten nicht aufgebaut werden.<br><br>Wenn dwu nicht sicher bist, was du eingeben musst, kontaktiere deinen Serveranbieter.';
$txt['error_db_connect_settings'] = 'Die Verbindung kann nicht aufgebaut werden.<br><br>Bitte überprüfe, dass die Datenbank-Verbindungsinformationen in der Datei "Settings.php" korrekt sind.';
$txt['error_db_database'] = 'Das Installationsskript konnte nicht auf die Datenbank „<em>%1$s</em>“ zugreifen. Bei manchen Hosts musst du die Datenbank zuerst im Administrationsbereich erstellen, bevor du diese nutzen kannst. Andere Hosts fügen ein Präfix – z. B. deinen Benutzernamen – zu dem Datenbanknamen hinzu.';
$txt['error_db_queries'] = 'Einige der Anfragen konnten nicht ausgeführt werden. Dies kann verursacht werden durch eine nicht unterstützte Version der Datenbanksoftware (Entwicklerversion oder veraltet).<br><br>Technische Informationen zu den Abfragen:';
$txt['error_db_queries_line'] = 'Zeile #';
$txt['error_db_missing'] = 'Das Installationsskript konnte keine Datenbankunterstützung in PHP erkennen. Bitte frage deinen Serveranbieter, ob PHP mit Unterstützung für die gewünschte Datenbank kompiliert wurde und ob die richtige Erweiterung geladen wird.';
$txt['error_db_script_missing'] = 'Das Installationsskript konnte keine Installationsskriptdateien für den gewählten Datenbanktyp finden. Bitte prüfe, dass alle benötigten Installationsskriptdateien in das Forumsverzeichnis hochgeladen wurden, zum Beispiel &quot;%1$s&quot;';
$txt['error_session_missing'] = 'Das Installationsskript konnte keine Unterstützung für Sitzungen in deiner PHP-Umgebung finden. Bitte deinen Serveranbieter, sicherzustellen, dass PHP mit Sitzungsunterstützung kompiliert wurde (dies ist eigentlich Standard und bedeutet, dass dein Serveranbieter dies momentan explizit abgeschaltet hat).';
$txt['error_user_settings_again_match'] = 'Du hast zwei verschiedene Passwörter eingegeben!';
$txt['error_user_settings_no_password'] = 'Dein Passwort muss mindestens vier Zeichen lang sein.';
$txt['error_user_settings_taken'] = 'Ein Mitglied ist bereits mit diesem Benutzernamen und/oder dieser E-Mail-Adresse registriert.<br><br>Es wurde kein neues Benutzerkonto erstellt.';
$txt['error_user_settings_query'] = 'Ein Datenbankfehler ist beim Erstellen des Administratorkontos aufgetreten. Der Fehler lautet:';
$txt['error_sourcefile_missing'] = 'Die Datei "Sources/%1$s" konnte nicht gefunden werden. Bitte überprüfe, dass sie erfolgreich hochgeladen wurde und versuche es dann nochmal.';
$txt['error_db_alter_priv'] = 'Der Datenbankzugang, den Du angegeben hast, hat keine ALTER-, CREATE- und/oder DROP-Berechtigung für Tabellen in der Datenbank. Dies ist notwendig, damit SMF reibungslos funktioniert.';
$txt['error_versions_do_not_match'] = 'Das Installationsskript hat eine andere Version von SMF gefunden, die bereits mit den angegebenen Informationen installiert ist. Wenn du das Forum aktualisieren möchtest, solltest du das Aktualisierungsskript benutzen, nicht das Installationsskript.<br><br>Andernfalls kannst du andere Zugangsdaten benutzen oder ein Backup erstellen und anschließend die vorhandenen Daten in der Datenbank löschen.';
$txt['error_mod_security'] = 'Das Installationsskript hat das Modul „mod_security“ auf deinem Server gefunden. mod_security blockiert gesendete Formulardaten, bevor SMF etwas dagegen unternehmen kann. SMF hat einen eingebauten Sicherheits-Scanner, der effektiver als mod_security arbeitet und keine Formulardaten blockiert.<br><br><a href="https://www.simplemachines.org/redirect/mod_security">Mehr Informationen zum Deaktivieren von mod_security</a>';
$txt['error_mod_security_no_write'] = 'Das Installationsskript hat erkannt, dass das „mod_security“-Modul auf deinem Webserver installiert ist. "mod_security" blockiert abgeschickte Formulardaten, bevor SMF eingreifen kann. SMF hat einen eingebauten Sicherheits-Scanner, der effizienter als "mod_security" arbeitet und keine Formulardaten blockiert.<br><br><a href="https://www.simplemachines.org/redirect/mod_security">Weitere Informationen zum Deaktivieren von mod_security</a><br><br>Alternativ kannst du mit deinem FTP-Programm die Datei „.htaccess“ beschreibbar machen (777) und die Seite neu laden.';
$txt['error_utf8_version'] = 'Die aktuelle Version deiner Datenbank unterstützt den UTF-8-Zeichensatz nicht. Du kannst SMF trotzdem installieren, musst jedoch die UTF-8-Unterstützung deaktivieren. Möchtest du in Zukunft zu UTF-8 wechseln (z. B. nachdem deine Datenbank auf Version >= %1$s aktualisiert wurde), kannst du dies über den Administrationsbereich tun.';
$txt['error_valid_admin_email_needed'] = 'Du hast keine gültige E-Mail-Adresse für dein Administrator-Benutzerkonto angegeben.';
$txt['error_valid_server_email_needed'] = 'Du hast keine gültige Webmaster-E-Mail-Adresse angegeben.';
$txt['error_already_installed'] = 'Das Installationsskript hat erkannt, dass Du SMF bereits installiert hast. Es wird empfohlen, dass du <strong>nicht</strong> versuchst, die vorhandene Installation zu überschreiben – solltest du fortfahren, <strong>kann dies zu Datenverlust führen oder die existierenden Daten beschädigen</strong>.<br><br>Falls du dein Forum aktualisieren willst, besuche bitte die <a href="https://www.simplemachines.org">Simple-Machines-Webseite</a> und lade das neueste <em>Aktualisierungs</em>-Paket herunter.<br><br>Falls du deine aktuelle Installation inklusive aller Daten trotzdem überschreiben willst, wird empfohlen, dass du vorher alle existierenden Datenbanktabellen löschst, die Datei „Settings.php“ ersetzt und es dann erneut versuchst.';
$txt['error_warning_notice'] = 'Warnung!';
$txt['error_script_outdated'] = 'Dieses Installationsskript ist veraltet! Die aktuelle Version von SMF ist %1$s, das Installationsskript ist jedoch für Version %2$s.<br><br>
	Es ist empfehlenswert, die <a href="https://www.simplemachines.org">Simple-Machines</a>-Webseite zu besuchen, um sicherzustellen, dass Du die neueste Version installierst.';
$txt['error_db_prefix_numeric'] = 'Der gewählte Datenbanktyp unterstützt keine numerischen Präfixe.';
$txt['error_pg_scs'] = 'PostgreSQL ist falsch konfiguriert. Bitte schalte die standard_conforming_strings Konfigurationsparameter ein.';
$txt['error_invalid_characters_username'] = 'Ungültiges Zeichen im Benutzernamen verwendet.';
$txt['error_username_too_long'] = 'Benutzername darf maximal 25 Zeichen lang sein.';
$txt['error_username_left_empty'] = 'Das Benutzernamensfeld wurde leer gelassen.';
$txt['error_db_prefix_reserved'] = 'Das Präfix, dass Du eingegeben haben ist reserviert. Bitte gib ein anderes ein.';
$txt['error_utf8_support'] = 'Die Datenbank, die Du benutzen möchtest, verwendet keinen UTF8-Zeichensatz';

$txt['ftp_login'] = 'Deine FTP-Zugangsdaten';
$txt['ftp_login_info'] = 'Dieses Web-Installationsskript benötigt Deine FTP-Daten, um die Installation für Dich zu automatisieren. Bitte beachte, dass diese Daten nicht gespeichert werden, sondern lediglich während der SMF-Installation genutzt werden.';
$txt['ftp_server'] = 'FTP-Server';
$txt['ftp_server_info'] = 'Die Adresse (oft „localhost“) und der Port deines FTP-Servers.';
$txt['ftp_port'] = 'FTP-Port';
$txt['ftp_username'] = 'Benutzername';
$txt['ftp_username_info'] = 'Der Benutzername zum Einloggen. <em>Dies wird nicht gespeichert.</em>';
$txt['ftp_password'] = 'Passwort';
$txt['ftp_password_info'] = 'Das Passwort zum Einloggen. <em>Dies wird nicht gespeichert.</em>';
$txt['ftp_path'] = 'Installationspfad';
$txt['ftp_path_info'] = 'Dies ist der <em>relative</em> Pfad, den Du im FTP-Client benutztst.';
$txt['ftp_path_found_info'] = 'Der Pfad in der oberen Box wurde automatisch ausgelesen.';
$txt['ftp_path_help'] = 'Dein FTP-Pfad ist das (relative) Verzeichnis, das du siehst, wenn du dich mit deinem FTP-Client auf deinem Server einloggst. Häufig beginnt dieser mit „<pre>www</pre>“, „<pre>public_html</pre>“ oder „<pre>httpdocs</pre>“. Dein SMF-Verzeichnis sollte unterhalb deines FTP-Pfades liegen, z. B. „/public_html/forum“. Dein FTP-Pfad unterscheidet sich von deiner URL und deinem vollen Pfad.<br><br>Dateien in diesem Pfad könnten überschrieben werden, also stelle sicher, dass dieser korrekt ist.';
$txt['ftp_path_help_close'] = 'Schließen';
$txt['ftp_connect'] = 'Verbinden';

$txt['force_ssl'] = 'SSL aktivieren';
$txt['force_ssl_label'] = 'Erzwinge SSL überall im Forum';
$txt['force_ssl_info'] = 'Stelle sicher, dass SSL und HTTPS überall im Forum unterstützt werden, sonst könnte dein Forum nicht mehr zugreifbar sein';

$txt['chmod_linux_info'] = 'Falls du einen Shell-Zugang hast, kann der Befehl unterhalb automatisch die Berechtigungen dieser Dateien korrigieren';

// The upgrader needs text strings too!
$txt['upgrade_step_login'] = 'Einloggen';
$txt['upgrade_step_options'] = 'Aktualisierungs-Optionen';
$txt['upgrade_step_backup'] = 'Sicherung';
$txt['upgrade_step_database'] = 'Datenbank-Änderungen';
$txt['upgrade_step_convertutf'] = 'Umstellung auf UTF-8';
$txt['upgrade_step_convertjson'] = 'Umstellung serialisierter Strings auf JSON';
$txt['upgrade_step_delete'] = 'Löschen von Upgrade.php';

$txt['upgrade_upgrade_utility'] = 'SMF Aktualisierungs Dienstprogramm';
$txt['upgrade_warning'] = 'Warnung!';
$txt['upgrade_critical_error'] = 'Kritischer Fehler!';
$txt['upgrade_continue'] = 'Weiter';
$txt['upgrade_skip'] = 'Überspringen';
$txt['upgrade_note'] = 'Hinweis!';
$txt['upgrade_step'] = 'Schritt';
$txt['upgrade_steps'] = 'Schritte';
$txt['upgrade_progress'] = 'Fortschritt';
$txt['upgrade_overall_progress'] = 'Gesamtfortschritt';
$txt['upgrade_step_progress'] = 'Schritt Fortschritt';
$txt['upgrade_time_elapsed'] = 'Zeit Verstrichen';
$txt['upgrade_time_mins'] = 'Minuten';
$txt['upgrade_time_secs'] = 'Sekunden';
$txt['upgrade_username'] = 'Benutzername:';
$txt['upgrade_wrong_username'] = 'Benutzername falsch';
$txt['upgrade_password'] = 'Passwort:';
$txt['upgrade_wrong_password'] = 'Passwort falsch';
$txt['upgrade_script_timeout_minutes'] = 'Dieses Aktualisierungsskript kann nicht ausgeführt werden, bis %1$s für mindestens %2$d Minuten inaktiv war';
$txt['upgrade_script_timeout_seconds'] = 'Dieses Aktualisierungsskript kann nicht ausgeführt werden, bis %1$s für mindestens %2$d Sekunden inaktiv war';

$txt['upgrade_wait'] = 'Bitte warte, während ein Backup erzeugt wird. Bei großen Foren kann dies einige Zeit dauern!';
$txt['upgrade_wait2'] = 'Bitte warte, während deine Datenbank auf UTF-8 konvertiert wird. Für große Foren kann dies einige Zeit dauern!';
$txt['upgrade_sec_login'] = 'Aus Sicherheitsgründen logge dich bitte mit deinem Administratoren-Benutzerkonto ein, um mit der Aktualisierung fortzufahren.';
$txt['upgrade_incomplete'] = 'Unvollständig';
$txt['upgrade_not_quite_done'] = 'Noch nicht ganz fertig!';
$txt['upgrade_paused_overload'] = 'Diese Aktualisierung wurde pausiert, um eine Überbeanspruchung des Servers zu vermeiden. Keine Sorge, alles ist in Ordnung – klicke einfach unten den <label for="contbutt">Weiter-Button</label>, um die Aktualisierung fortzusetzen.';
$txt['upgrade_continue_step'] = 'Setze an der Stelle fort, die du bei der letzten Ausführung des Aktualisierungsskripts erreicht hast.';
$txt['upgrade_bypass'] = '<strong>Hinweis:</strong> Falls notwendig, kann die obige Sicherheitsprüfung von Benutzern, die zwar den Server administrieren, aber keine Administrationsrechte im Forum haben, umgangen werden. Um die Prüfung zu umgehen, öffne die Datei „upgrade.php“ in einem Texteditor, ersetze „$disable_security = false;“ mit „$disable_security = true;“ und lade diese Seite erneut.';
$txt['upgrade_areyouready'] = 'Bevor die Aktualisierung beginnt, prüfe bitte die Optionen unterhalb – und klicke „Weiter“, sobald du bereit bist.';
$txt['upgrade_backup_table'] = 'Sicherung der Datenbanktabellen mit dem folgenden Präfix durchführen';
$txt['upgrade_backup_complete'] = 'Sicherung abgeschlossen! Klicke „Weiter“ um fortzufahren.';
$txt['upgrade_recommended'] = 'empfohlen!';
$txt['upgrade_maintenance'] = 'Das Forum während der Aktualisierung in den Wartungsmodus versetzen.';
$txt['upgrade_maintenance_title'] = 'Wartungstitel:';
$txt['upgrade_maintenance_message'] = 'Wartungsnachricht:';
$txt['upgrade_customize'] = 'Anpassen';
$txt['upgrade_debug_info'] = 'Zusätzliche Debug-Informationen ausgeben.';
$txt['upgrade_empty_errorlog'] = 'Fehlerprotokoll vor der Aktualisierung leeren.';
$txt['upgrade_delete_karma'] = 'Alle Karma-Einstellungen und -Informationen aus der Datenbank löschen';
$txt['upgrade_reprocess_attachments'] = 'Dateianhangskonvertierung erneut durchführen';
$txt['upgrade_stats_collection'] = 'Erlaube Simple Machines, monatlich grundlegende Statistiken zu sammeln.';
$txt['upgrade_stats_info'] = 'Falls aktiviert, erlaubt dies Simple Machines, deine Webseite monatlich zu besuchen, um grundlegende Statistiken zu sammeln. Dies hilft uns, Entscheidungen zu treffen, für welche Konfigurationen die Software optimiert wird. Für weitere Informationen besuche bitte unsere <a href="%1$s" target="_blank" rel="noopener">Informationsseite</a>.';
$txt['upgrade_migrate_settings_file'] = 'Auf eine neue Einstellungs-Datei migrieren.';
$txt['upgrade_db_changes'] = 'Datenbank-Änderungen werden durchgeführt';
$txt['upgrade_db_patient'] = 'Bitte warte – dies könnte in großen Foren einige Zeit dauern. Die verstrichene Zeit wird vom Server aktualisiert, um den Fortschritt anzuzeigen.';
$txt['upgrade_db_complete'] = '1 Datenbank-Aktualisierungen abgeschlossen! Klicke auf "Weiter", um fortzufahren.';
$txt['upgrade_db_complete2'] = 'Datenbank-Aktualisierungen abgeschlossen! Klicke auf "Weiter", um fortzufahren.';
$txt['upgrade_script'] = 'Aktualisierungsskript wird ausgeführt';
$txt['upgrade_error'] = 'Fehler!';
$txt['upgrade_unknown_error'] = 'Unbekannter Fehler!';
/* Same sentence, 3 different strings */
$txt['upgrade_completed'] = 'Abgeschlossen:';
$txt['upgrade_outof'] = 'von';
$txt['upgrade_tables'] = 'Tabellen.';

$txt['upgrade_run_script'] = 'Wir empfehlen, dass du dieses Skript nicht ausführst, es sei denn, du bist dir sicher, dass';
$txt['upgrade_run_script2'] = 'seine/ihre Aktualisierung abgeschlossen hat.';
$txt['upgrade_run'] = 'Du kannst die Aktualisierung entweder nochmal von vorne beginnen oder beim letzten Schritt fortsetzen, den du während der letzten Aktualisierung erreicht hast.';

$txt['upgrade_completed_table'] = 'Tabelle abgeschlossen:';
$txt['upgrade_current_table'] = 'Aktuelle Tabelle:';
$txt['upgrade_fulltext'] = 'Bitte beachte, dass dein Volltext-Index entfernt wurde, um die Konvertierung zu ermöglichen. Du musst ihn manuell im Administrationsbereich wieder erzeugen, nachdem die Aktualisierung abgeschlossen ist.';
$txt['upgrade_conversion_proceed'] = 'Konvertierung abgeschlossen! Klicke "Weiter" um fortzufahren.';
$txt['upgrade_convert_datajson'] = 'Konvertiere Daten von PHP-Serialisierung zu JSON…';
$txt['upgrade_json_completed'] = 'Konvertierung zu JSON abgeschlossen! Klicke "Weiter" um fortzufahren.';
$txt['upgrade_executing'] = 'Führe aus:';
$txt['upgrade_of'] = 'von';
$txt['upgrade_admin_login'] = 'Admin-Login:';
$txt['upgrade_admin_disabled'] = '(DEAKTIVIERT)';
$txt['upgrade_done'] = 'Aktualisierung abgeschlossen. Du kannst <a href="%1$s/index.php">deine Installation von SMF</a> nun nutzen. Wir hoffen, es gefällt dir!';

$txt['upgrade_delete_now'] = 'upgrade.php und dessen Dateien jetzt löschen';
$txt['upgrade_delete_server'] = '(funktioniert nicht auf allen Servern).';
$txt['upgrade_problems'] = 'Falls du während der Aktualisierung irgendwelche Probleme hattest oder Probleme bei der Benutzung von SMF hast, zögere bitte nicht, <a href="%1$s">uns um Hilfe zu fragen</a>.';
$txt['upgrade_luck'] = 'Viel Glück,';

$txt['upgrade_ftp_login'] = 'Deine FTP-Verbindungsinformationen';
$txt['upgrade_ftp_perms'] = 'Das Aktualisierungsskript kann Dateiberechtigungsprobleme beheben, um die Aktualisierung so einfach wie möglich zu machen. Gib einfach unten deine Zugangsdaten ein oder klicke <a href="#" onclick="warning_popup();">hier</a> für eine Liste der Dateien, die geändert werden müssen.';
$txt['upgrade_ftp_warning'] = 'Warnung';
$txt['upgrade_ftp_files'] = 'Die folgenden Dateien müssen beschreibbar sein, um fortzufahren:';
$txt['upgrade_ftp_shell'] = 'Falls du einen Shell-Zugang hast, kann der Befehl unterhalb automatisch die Berechtigungen dieser Dateien korrigieren';
$txt['upgrade_ftp_error'] = 'Der folgende Fehler ist beim Verbindungsversuch aufgetreten:';

$txt['upgrade_ready_proceed'] = 'Danke, dass du dich entschieden hast, auf SMF %1$s zu aktualisieren. Alle Dateien scheinen am richtigen Ort zu sein und die Aktualisierung kann nun weitergehen.';
$txt['upgrade_error_script_js'] = 'Das Aktualisierungsskript kann die Datei script.js nicht finden oder sie ist von einer älteren Version. Stelle sicher, dass die Theme Pfade korrekt sind. Du kannst ein Einstellungsüberprüfungs Dienstprogramm von der <a href="http://www.simplemachines.org">Simple Machines Webseite</a> herunterladen.';
$txt['upgrade_warning_lots_data'] = 'Dieses Aktualisierungsskript hat festgestellt, dass viele der Daten deines Forums einer Aktualisierung bedürfen. Dieser Prozess kann einige Zeit in Anspruch nehmen, je nach Größe deines Servers und Forums. Für sehr große Foren (~300.000 Nachrichten) bis zu einigen Stunden.';
$txt['upgrade_warning_out_of_date'] = 'Dieses Aktualisierungsskript ist nicht mehr auf dem neuesten Stand! Die aktuelle Version von SMF ist <em id="smfVersion" style="white-space: nowrap;">??</i> aber dieses Aktualisierungsskript ist für Version <em id="yourVersion" style="white-space: nowrap;">%1$s</i>.<br><br>Es wird empfohlen, dass du die <a href="http://www.simplemachines.org">Simple-Machines</a>-Webseite besuchst, um sicherzustellen, dass du auf die aktuelle Version aktualisierst.';

$txt['upgrade_forumdir_settings'] = 'Deine Forumsverzeichnis-Einstellungen <em>könnten</em> falsch sein. Dein Forums-Hauptverzeichnis ist momentan auf „%1$s“ gesetzt, sollte aber vermutlich „%2$s“ sein. Laut „Settings.php“ sind deine Verzeichnisse momentan:';
$txt['upgrade_forumdir'] = 'Forumsverzeichnis:';
$txt['upgrade_sourcedir'] = '"Source"-Verzeichnis:';
$txt['upgrade_cachedir'] = 'Cache-Verzeichnis:';
$txt['upgrade_incorrect_settings'] = 'Falls diese Angaben falsch sind, öffne bitte "Settings.php" in einem Texteditor, bevor du diese Aktualisierung fortsetzt. Falls sie falsch sind, weil du dein Forum an einen neuen Ort umziehst, lade bitte das <a href="https://download.simplemachines.org/?tools">Einstellungs-Reparatur</a>-Dienstprogramm von der Simple-Machines-Webseite herunter und führe es aus, bevor du fortfährst.';

$txt['upgrade_fulltext_error'] = 'Dein Volltext-Suchindex wurde entfernt, um die Konvertierung zu ermöglichen. Du wirst ihn neu erzeugen müssen.';
$txt['upgrade_writable_files'] = 'Die folgenden Dateien müssen beschreibbar sein, um die Aktualisierung fortzusetzen. Bitte stelle sicher, dass die Windows-Berechtigungen korrekt gesetzt sind und dies erlauben:';
$txt['upgrade_time_user'] = '„%1$s“ führt das Aktualisierungsskript aus.';

// We represent the time here in backwards variables, as it makes the code easier.
$txt['upgrade_time_hms'] = 'Das Aktualisierungsskript läuft seit %3$d Stunden, %2$d Minuten und %1$d Sekunden.';
$txt['upgrade_time_ms'] = 'Das Aktualisierungsskript läuft seit %2$d Minuten und %1$d Sekunden.';
$txt['upgrade_time_s'] = 'Das Aktualisierungsskript läuft seit %1$d Sekunden.';
$txt['upgrade_time_updated_hms'] = 'Das Aktualisierungsskript wurde zuletzt vor %3$d Stunden, %2$d Minuten und %1$d Sekunden aktualisiert.';
$txt['upgrade_time_updated_hm'] = 'Das Aktualisierungsskript wurde zuletzt vor %2$d Minuten und %1$d Sekunden aktualisiert.';
$txt['upgrade_time_updated_s'] = 'Das Aktualisierungsskript wurde zuletzt vor %1$d Sekunden aktualisiert.';
$txt['upgrade_completed_time_hms'] = 'Aktualisierung abgeschlossen in %3$d Stunden, %2$s Minuten und %1$s Sekunden';
$txt['upgrade_completed_time_ms'] = 'Aktualisierung abgeschlossen in %2$s Minuten und %1$s Sekunden';
$txt['upgrade_completed_time_s'] = 'Aktualisierung abgeschlossen in %1$s Sekunden';
$txt['upgrade_success_time_db'] = 'Erfolgreich! Datenbank-Aktualisierungen abgeschlossen in %3$d Stunden, %2$d Minuten und %1$d Sekunden.';

$txt['upgrade_unsuccessful'] = 'Fehlgeschlagen!';
$txt['upgrade_thisquery'] = 'Diese Datenbankabfrage:';
$txt['upgrade_causerror'] = 'Verursachte diesen Fehler:';
$txt['upgrade_completedtables_outof'] = '<span id="tab_done">%1$d</span> von %2$d Tabellen abgeschlossen.';
$txt['upgrade_success'] = 'Erfolgreich!';
$txt['upgrade_loop'] = 'Das Aktualisierungsskript scheint sich in einer Endlosschleife zu befinden – Schritt: ';
$txt['upgrade_respondtime'] = 'Der Server hat seit %1$d Sekunden nicht geantwortet. Wahrscheinlich lohnt es sich, noch ein wenig länger zu warten, bevor du es nochmal versuchst.';
$txt['upgrade_respondtime_clickhere'] = 'Klicke hier, um es nochmal zu versuchen.';
$txt['mtitle'] = 'Aktualisiere das Forum…';
$txt['mmessage'] = 'Keine Sorge, dein Forum wird in Kürze aktualisiert sein. Es wird nur einen Augenblick dauern ;).';

// Upgrader error messages
// argument(s): template name (if applicable)
$txt['error_unexpected_template_call'] = 'Fehler: Unerwarteter Aufruf bei Benutzung der „%1$s“-Vorlage. Bitte kopiere den vollständigen Text oberhalb und besuche das SMF-Supportforum, um die Entwickler über diesen Bug zu informieren.';
$txt['error_invalid_template'] = 'Aktualisierung abgebrochen! Ungültige Vorlage: template_%1$s';
$txt['error_lang_index_missing'] = 'Das Aktualisierungsskript konnte keine Sprachdateien für die ausgewählte Sprache "%1$s" finden.<br>SMF wird ohne installierte Sprachdateien nicht in dieser Sprache funktionieren.<br><br>Bitte installiere sie, oder <a href="%2$s?step=0;lang=english">versuche es auf Englisch</a>.';
$txt['error_upgrade_files_missing'] = 'Das Aktualisierungsskript konnte einige wichtige Dateien nicht finden.<br><br>Bitte stelle sicher, dass du alle Dateien im Paket hochgeladen hast, einschließlich der "Themes"-, "Sources"- und anderer Verzeichnisse.';
$txt['error_upgrade_old_files'] = 'Das Aktualisierungsskript hat einige alte oder veraltete Dateien gefunden.<br><br>Bitte stelle sicher, dass du die neuen Versionen aller Dateien im Paket hochgeladen hast.';
$txt['error_upgrade_old_lang_files'] = 'Das Aktualisierungsskript hat einige alte oder veraltete Sprachdateien für die ausgewählte Sprache "%1$s" gefunden.<br><br>Bitte stelle sicher, dass du die neuen Versionen aller Dateien im Paket hochgeladen hast, inklusive Theme- und Sprachdateien des Standard-Themes.<br>&nbsp;&nbsp;&nbsp;[<a href="%2$s?skiplang">Überspringen</a>] [<a href="%2$s?lang=english">Versuche es auf Englisch</a>]';
$txt['error_php_too_low'] = 'Achtung! Auf deinem Server scheint eine PHP-Version installiert zu sein, die nicht den Mindestanforderungen von SMF entspricht.<br><br>Bitte deinen Serveranbieter um eine Aktualisierung.';
$txt['error_db_too_low'] = 'Deine Datenbank-Version „%1$s“ genügt nicht den Mindestanforderungen von SMF.<br><br>Bitte deinen Serveranbieter um eine Aktualisierung.';
$txt['error_db_privileges'] = 'Der in der Datei "Settings.php" angegebene Benutzer "%1$s" hat keine passenden Berechtigungen.<br><br>Bitte deinen Serveranbieter, diesem Benutzer die Berechtigungen ALTER, CREATE und DROP zu geben.';
$txt['error_dir_not_writable'] = 'Das Verzeichnis "%1$s" muss beschreibbar sein, um die Aktualisierung fortzusetzen. Bitte stelle sicher, dass die Berechtigungen stimmen, um dies zu erlauben.';
$txt['error_cache_not_found'] = 'Das Cache-Verzeichnis konnte nicht gefunden werden.<br><br>Bitte stelle sicher, dass du ein Verzeichnis namens &quot;cache&quot; in deinem Forumsverzeichnis hast, bevor du fortfährst.';
$txt['error_agreement_not_writable'] = 'Das Aktualisierungsskript konnte die Datei "agreement.txt" nicht beschreiben.<br><br>Falls du einen Linux- oder Unix-basierten Server nutzt stelle bitte sicher, dass die Datei auf 777 chmod\'et ist oder, falls sie nicht existiert, dass das Verzeichnis, in dem das Aktualisierungsskript liegt, die Berechtigung 777 hat.<br>Falls dein Server auf Windows läuft, stelle bitte sicher, dass das Internet-Gastkonto die passenden Berechtigungen für das Skript oder dessen Verzeichnis hat.';
$txt['error_not_admin'] = 'Du musst ein Administrator sein, um eine Aktualisierung durchzuführen!';

$txt['warning_lang_old'] = 'Die ausgewählten Sprachdateien für "%1$s" wurden nicht auf die neueste Version aktualisiert. Die Aktualisierung wird mit der Forums-Standardsprache "%2$s" fortgesetzt.';
$txt['warning_lang_missing'] = 'Das Aktualisierungsskript konnte die &quot;Install&quot;-Sprachdatei für die von dir gewählte Sprache "%1$s" nicht finden. Die Aktualisierung wird mit der Forums-Standardsprache "%2$s" fortgesetzt.';

// Attachment & Avatar folder checks
$txt['warning_av_missing'] = 'Achtung! Profilbild-Verzeichnis nicht gefunden. Fortsetzen könnte unsicher sein. Bitte bestätige die Verzeichniseinstellungen bevor du fortfährst.';
$txt['warning_custom_av_missing'] = 'Achtung! Benutzerdefiniertes-Profilbild-Verzeichnis nicht gefunden. Fortsetzen könnte unsicher sein. Bitte bestätige die Verzeichniseinstellungen bevor du fortfährst.';
$txt['warning_att_dir_missing'] = 'Achtung! Ein oder mehrere Dateianhangs-Verzeichnisse nicht gefunden. Fortsetzen könnte unsicher sein. Bitte bestätige die Verzeichniseinstellungen bevor du fortfährst.';

// Page titles
$txt['updating_smf_installation'] = 'Deine SMF-Installation wird aktualisiert!';
$txt['upgrade_options'] = 'Aktualisierungsoptionen';
$txt['backup_database'] = 'Sichern der Datenbank';
$txt['database_changes'] = 'Datenbank-Änderungen';
$txt['upgrade_complete'] = 'Aktualisierung abgeschlossen';
$txt['converting_utf8'] = 'Zu UTF-8 konvertieren';
$txt['converting_json'] = 'Konvertiere zu JSON';

?>