<?php
// Version: 2.1.5; index

global $forum_copyright, $webmaster_email, $scripturl, $context, $boardurl;

// Native name, please use full HTML entities to write your language's name.
$txt['native_name'] = 'Nederlands';

// Locale (strftime, basename). For more information see:
//   - https://php.net/function.setlocale
$txt['lang_locale'] = 'nl_NL';
$txt['lang_dictionary'] = 'nl';
//https://developers.google.com/recaptcha/docs/language
$txt['lang_recaptcha'] = 'nl';

// Ensure you remember to use uppercase for character set strings.
$txt['lang_character_set'] = 'UTF-8';
// Character set right to left?  0 = ltr; 1 = rtl
$txt['lang_rtl'] = '0';
// Number format.
$txt['number_format'] = '1.234,00';

$txt['days_title'] = 'Dagen';
$txt['days'] = array('zondag', 'maandag', 'dinsdag', 'woensdag', 'donderdag', 'vrijdag', 'zaterdag');
$txt['days_short'] = array('zo', 'ma', 'di', 'wo', 'do', 'vr', 'za');
// Months must start with 1 => 'January'. (or translated, of course.)
$txt['months_title'] = 'Maanden';
$txt['months'] = array(1 => 'januari', 2 => 'februari', 3 => 'maart', 4 => 'april', 5 => 'mei', 6 => 'juni', 7 => 'juli', 8 => 'augustus', 9 => 'september', 10 => 'oktober', 11 => 'november', 12 => 'december');
$txt['months_titles'] = array(1 => 'januari', 2 => 'februari', 3 => 'maart', 4 => 'april', 5 => 'mei', 6 => 'juni', 7 => 'juli', 8 => 'augustus', 9 => 'september', 10 => 'oktober', 11 => 'november', 12 => 'december');
$txt['months_short'] = array(1 => 'jan', 2 => 'feb', 3 => 'mrt', 4 => 'apr', 5 => 'mei', 6 => 'jun', 7 => 'jul', 8 => 'aug', 9 => 'sep', 10 => 'okt', 11 => 'nov', 12 => 'dec');
$txt['prev_month'] = 'Vorige maand';
$txt['next_month'] = 'Volgende maand';
$txt['start'] = 'Begin';
$txt['end'] = 'Einde';
$txt['starts'] = 'Begint';
$txt['ends'] = 'Eindigt';
$txt['none'] = 'Geen';

$txt['minutes_label'] = 'Minuten';
$txt['hours_label'] = 'Uren';
$txt['years_title'] = 'Jaren';

$txt['time_am'] = 'am';
$txt['time_pm'] = 'pm';

// Short form of minutes
$txt['minutes_short'] = 'min.';
// Short form of hour
$txt['hour_short'] = 'u.';
// Short form of hours
$txt['hours_short'] = 'u.';
// Decimal sign
$txt['decimal_sign'] = ',';

$txt['admin'] = 'Beheer';
$txt['moderate'] = 'Modereren';

$txt['save'] = 'Opslaan';
$txt['reset'] = 'Resetten';
$txt['upload'] = 'Uploaden';
$txt['upload_all'] = 'Upload alles';
$txt['processing'] = 'In bewerking...';

$txt['modify'] = 'Verander';
$txt['forum_index'] = '%1$s - Forumindex';
$txt['members'] = 'Leden';
$txt['board_name'] = 'Forumnaam';
$txt['posts'] = 'Berichten';

$txt['member_postcount'] = 'Berichten';
$txt['no_subject'] = '(Geen onderwerp)';
$txt['view_profile'] = 'Bekijk profiel';
$txt['guest_title'] = 'gast';
$txt['author'] = 'Auteur';
$txt['on'] = 'op';
$txt['remove'] = 'Verwijder';
$txt['start_new_topic'] = 'Begin een nieuw topic';

$txt['login'] = 'Inloggen';
// Use numeric entities in the below string.
$txt['username'] = 'Gebruikersnaam';
$txt['password'] = 'Wachtwoord';

$txt['username_no_exist'] = 'Deze gebruikersnaam bestaat niet.';
$txt['no_user_with_email'] = 'Er zijn geen gebruikersnamen verbonden aan dat e-mailadres.';

$txt['board_moderator'] = 'Board-moderator';
$txt['remove_topic'] = 'Verwijder topic';
$txt['topics'] = 'Topics';
$txt['modify_msg'] = 'Bewerk bericht';
$txt['name'] = 'Naam';
$txt['email'] = 'E-mail';
$txt['user_email_address'] = 'E-mailadres';
$txt['subject'] = 'Onderwerp';
$txt['message'] = 'Bericht';
$txt['redirects'] = 'keer aangeklikt';
$txt['quick_modify'] = 'Inline bewerken';
$txt['quick_modify_message'] = 'Je hebt dit bericht succesvol gewijzigd';
$txt['reason_for_edit'] = 'Reden voor wijziging';

$txt['choose_pass'] = 'Kies wachtwoord';
$txt['verify_pass'] = 'Bevestig wachtwoord';
$txt['notify_announcements'] = 'Sta beheerders toe mij belangrijke berichten per e-mail te verzenden';

$txt['position'] = 'Positie';

// argument(s): username
$txt['view_profile_of_username'] = 'Bekijk het profiel van %1$s';
$txt['total'] = 'Totaal';
$txt['website'] = 'Website';
$txt['register'] = 'Registreren';
$txt['warning_status'] = 'Waarschuwingsstatus';
$txt['user_warn_watch'] = 'Gebruiker staat op moderatietoezichtlijst';
$txt['user_warn_moderate'] = 'Gebruikersposts komen op goedkeuringslijst';
$txt['user_warn_mute'] = 'Gebruiker is verbannen van posten';
$txt['warn_watch'] = 'Toezicht';
$txt['warn_moderate'] = 'Gemodereerd';
$txt['warn_mute'] = 'Stilgelegd';

$txt['message_index'] = 'Berichtenindex';
$txt['news'] = 'Nieuws';
$txt['home'] = 'Index';
$txt['page'] = 'Pagina';
$txt['prev'] = 'Vorige pagina';
$txt['next'] = 'Volgende pagina';

$txt['lock_unlock'] = 'Sluit/Open topic';
$txt['post'] = 'Verzenden';
$txt['error_occured'] = 'Er is een fout opgetreden';
$txt['at'] = 'om';
$txt['by'] = 'door';
$txt['logout'] = 'Uitloggen';
$txt['started_by'] = 'Gestart door';
$txt['topic_started_by'] = 'Gestart door <strong>%1$s</strong> in <em>%2$s</em>';
$txt['replies'] = 'Reacties';
$txt['last_post'] = 'Laatste bericht';
$txt['first_post'] = 'Eerste bericht';
$txt['last_poster'] = 'Laatste bericht door';
$txt['last_post_message'] = '<strong>Laatste bericht: </strong>%3$s <span class="postby">%2$s door %1$s</span>';
$txt['last_post_topic'] = '%1$s<br>door %2$s';
$txt['post_by_member'] = '<strong>%1$s</strong> door <strong>%2$s</strong><br>';
$txt['boardindex_total_posts'] = '%1$s Berichten in %2$s Topics door %3$s Leden';
$txt['show'] = 'Toon';
$txt['hide'] = 'Verberg';

$txt['admin_login'] = 'Inloggen (voor beheerders)';
// Use numeric entities in the below string.
$txt['topic'] = 'Topic';
$txt['help'] = 'Help';
$txt['terms_and_rules'] = 'Forumregels';
$txt['watch_board'] = 'Volg dit board';
$txt['unwatch_board'] = 'Stop volgen van dit board';
$txt['watch_topic'] = 'Volg dit topic';
$txt['unwatch_topic'] = 'Stop volgen van dit topic';
$txt['watching_topic'] = 'Topic dat je volgt';
$txt['watching_this_topic'] = 'Je volgt dit topic, en je zult er notificaties van ontvangen.';
$txt['notify'] = 'Notificatie';
$txt['unnotify'] = 'Notificatie opzeggen';

// Use numeric entities in the below string.
// argument(s): forum name
$txt['regards_team'] = 'Met vriendelijke groet,
Het team van %1$s.';

$txt['notify_replies'] = 'Notificatie bij reacties';
$txt['move_topic'] = 'Verplaats topic';
$txt['move_to'] = 'Verplaats naar';
$txt['pages'] = 'Pagina\'s';
$txt['users_active'] = 'Gebruikers actief in de afgelopen %1$d minuten';
$txt['personal_messages'] = 'Persoonlijke berichten';
$txt['reply_quote'] = 'Reageer met citaat';
$txt['reply'] = 'Reageer';
$txt['reply_noun'] = 'Reactie';
$txt['reply_number'] = 'Reactie #%1$s%2$s';
$txt['approve'] = 'Goedkeuren';
$txt['unapprove'] = 'Afkeuren';
$txt['approve_all'] = 'alles goedkeuren';
$txt['issue_warning'] = 'Geef waarschuwing';
$txt['awaiting_approval'] = 'Wachtend op goedkeuring';
$txt['attach_awaiting_approve'] = 'Bijlagen wachtend op goedkeuring';
$txt['post_awaiting_approval'] = 'Dit bericht wacht op goedkeuring van een moderator.';
$txt['there_are_unapproved_topics'] = 'In dit board wachten %1$s topics en %2$s posts op goedkeuring. Klik <a href="%3$s">hier</a> om ze te bekijken.';
$txt['send_message'] = 'Stuur bericht';

$txt['msg_alert_no_messages'] = 'je hebt geen berichten';
$txt['msg_alert_one_message'] = 'je hebt <a href="%1$s">1 bericht</a>';
$txt['msg_alert_many_message'] = 'je hebt <a href="%1$s">%2$d berichten</a>';
$txt['msg_alert_one_new'] = '1 is nieuw';
$txt['msg_alert_many_new'] = '%1$d zijn nieuw';
$txt['new_alert'] = 'Nieuwe notificatie';
$txt['remove_message'] = 'Verwijder dit bericht';
$txt['remove_message_question'] = 'Wil je deze post daadwerkelijk verwijderen?';

$txt['topic_alert_none'] = 'Geen berichten...';
$txt['pm_alert_none'] = 'Geen berichten...';
$txt['no_messages'] = 'Geen berichten';

$txt['online_users'] = 'Gebruikers Online';
$txt['jump_to'] = 'Ga naar';
$txt['go'] = 'ga';
$txt['are_sure_remove_topic'] = 'Weet je zeker dat je dit topic wilt verwijderen?';
$txt['yes'] = 'ja';
$txt['no'] = 'nee';

$txt['search_end_results'] = 'Einde van de resultaten';
$txt['search_on'] = 'op';

$txt['search'] = 'Zoek';
$txt['all'] = 'Allemaal';
$txt['search_entireforum'] = 'Gehele forum';
$txt['search_thisboard'] = 'Dit board';
$txt['search_thistopic'] = 'Dit topic';
$txt['search_members'] = 'Leden';

$txt['back'] = 'Terug';
$txt['continue'] = 'Volgende';
$txt['password_reminder'] = 'Wachtwoord vergeten?';
$txt['topic_started'] = 'Topic gestart door';
$txt['title'] = 'Titel';
$txt['post_by'] = 'Bericht door';
$txt['memberlist_searchable'] = 'Doorzoekbare lijst van alle geregistreerde leden.';
$txt['welcome_newest_member'] = 'Verwelkom %1$s, ons nieuwste lid.';
$txt['admin_center'] = 'Beheerscherm';
$txt['last_edit_by'] = '<span class="lastedit">Laatste wijziging</span>: %1$s door %2$s';
$txt['last_edit_reason'] = '<span id="reason" class="lastedit">Reden</span>: %1$s';
$txt['notify_deactivate'] = 'Weet je zeker dat je geen notificatie e-mails meer wilt ontvangen bij nieuwe reacties in dit topic?';
$txt['modified_time'] = 'Laatst bewerkt';
$txt['modified_by'] = 'Bewerkt door';

$txt['recent_posts'] = 'Recente berichten';

$txt['location'] = 'Locatie';
$txt['location_desc'] = 'Geografische locatie.';
$txt['gender'] = 'Geslacht';
$txt['gender_0'] = 'Geen';
$txt['gender_1'] = 'Man';
$txt['gender_2'] = 'Vrouw';
$txt['gender_desc'] = 'Je geslacht.';
$txt['icq'] = 'ICQ';
$txt['icq_desc'] = 'Dit is je ICQ-nummer.';
$txt['skype'] = 'Skype';
$txt['skype_desc'] = 'Je Skype-gebruikersnaam';
$txt['personal_text'] = 'Persoonlijke tekst';
$txt['date_registered'] = 'Datum van registratie';

$txt['recent_view'] = 'Bekijk de meest recente berichten op het forum.';
$txt['recent_updated'] = 'is een van de meest recente topics';
$txt['is_recent_updated'] = '%1$s is het laatst gewijzigde topic';

$txt['male'] = 'Man';
$txt['female'] = 'Vrouw';

$txt['error_invalid_characters_username'] = 'Ongeldige tekens gebruikt in de gebruikersnaam.';

// argument(s): forum name, login URL, login JavaScript snippet
$txt['welcome_guest'] = 'Welkom bij <strong>%1$s</strong>. Graag <a href="%2$s" onclick="%3$s">inloggen</a>.';

// argument(s): forum name, login URL, login JavaScript snippet, signup URL
$txt['welcome_guest_register'] = 'Welkom bij <strong>%1$s</strong>. Graag <a href="%2$s" onclick="%3$s">inloggen</a> of <a href="%4$s">registreren</a>.';

// argument(s): $scripturl
$txt['welcome_guest_activate'] = '<a href="%1$s?action=activate">Heb je de activerings-mail niet ontvangen?</a>';

// argument(s): $scripturl
$txt['register_prompt'] = 'Heb je nog geen account? <a href="%1$s?action=signup">Registreren</a>.';

// argument(s): forum name
$txt['welcome_to_forum'] = 'Welkom bij <strong>%1$s</strong>.';

// @todo the following to sprintf
$txt['hello_member'] = 'Hoi,';
// Use numeric entities in the below string.
$txt['hello_guest'] = 'Welkom,';
$txt['select_destination'] = 'Selecteer een bestemming';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['posted_by'] = 'Geplaatst door';

$txt['icon_smiley'] = 'Glimlach';
$txt['icon_angry'] = 'Boos';
$txt['icon_cheesy'] = 'Lachen';
$txt['icon_laugh'] = 'Lach';
$txt['icon_sad'] = 'Droevig';
$txt['icon_wink'] = 'Knipoog';
$txt['icon_grin'] = 'Grijns';
$txt['icon_shocked'] = 'Geschrokken';
$txt['icon_cool'] = 'Cool';
$txt['icon_huh'] = 'Verbaasd';
$txt['icon_rolleyes'] = 'Rollende ogen';
$txt['icon_tongue'] = 'Tong';
$txt['icon_embarrassed'] = 'Beschaamd';
$txt['icon_lips'] = 'Lippen verzegeld';
$txt['icon_undecided'] = 'Ik weet het niet';
$txt['icon_kiss'] = 'Kus';
$txt['icon_cry'] = 'Huilen';

$txt['moderator'] = 'Moderator';
$txt['moderators'] = 'Moderators';

$txt['views'] = 'Gelezen';
$txt['new'] = 'Nieuw';

$txt['view_all_members'] = 'Bekijk alle leden';
$txt['view'] = 'Bekijk';

$txt['viewing_members'] = 'Bekijk de leden %1$s tot %2$s';
$txt['of_total_members'] = 'van het totale aantal %1$s';

$txt['forgot_your_password'] = 'Wachtwoord vergeten?';

$txt['date'] = 'Datum';
// Use numeric entities in the below string.
$txt['from'] = 'Van';
$txt['check_new_messages'] = 'Controleer op nieuwe berichten';
$txt['to'] = 'Naar';

$txt['board_topics'] = 'Topics';
$txt['members_title'] = 'Leden';
$txt['members_list'] = 'Ledenlijst';
$txt['new_posts'] = 'Nieuw bericht';
$txt['old_posts'] = 'Geen nieuw bericht';
$txt['redirect_board'] = 'Doorlinkboard';

$txt['sendtopic_send'] = 'Zenden';
$txt['report_sent'] = 'Je rapport is met succes verstuurd.';
$txt['post_becomes_unapproved'] = 'Je bericht wacht op goedkeuring omdat het is geplaatst in een topic dat nog niet is goedgekeurd. Zodra het topic wordt goedgekeurd zal jouw bericht ook worden goedgekeurd.';

$txt['time_offset'] = 'Tijdafwijking';
$txt['or'] = 'of';

$txt['no_matches'] = 'Geen resultaten gevonden.';

$txt['notification'] = 'Notificatie';

$txt['your_ban'] = 'Sorry %1$s, je bent verbannen van gebruik van dit forum!';
$txt['your_ban_expires'] = 'Deze verbanning loopt af op %1$s.';
$txt['your_ban_expires_never'] = 'Deze verbanning is permanent.';
$txt['ban_continue_browse'] = 'Je kunt het forum blijven doorbladeren als gast.';

$txt['mark_as_read'] = 'Markeer alle berichten als gelezen';

$txt['locked_topic'] = 'Gesloten topic';
$txt['normal_topic'] = 'Normaal topic';
$txt['participation_caption'] = 'Topic waaraan je hebt deelgenomen';
$txt['moved_topic'] = 'Verplaatst Topic';

$txt['go_caps'] = 'GA';

$txt['print'] = 'Afdrukken';
$txt['profile'] = 'Profiel';
$txt['topic_summary'] = 'Samenvatting van topic';
$txt['not_applicable'] = 'Niet aanwezig';
$txt['name_in_use'] = 'Deze naam is al in gebruik bij een ander lid.';

$txt['total_members'] = 'Totaal leden';
$txt['total_posts'] = 'Totaal berichten';
$txt['total_topics'] = 'Totaal topics';

$txt['time_logged_in'] = 'Tijd om ingelogd te blijven';

$txt['preview'] = 'Bekijken';
$txt['always_logged_in'] = 'Blijvend';

$txt['logged'] = 'Gelogd';
$txt['show_ip'] = 'Toon IP-adres';
// Use numeric entities in the below string.
$txt['ip'] = 'IP';
$txt['url'] = 'URL';
$txt['www'] = 'WWW';

$txt['hours'] = 'uren';
$txt['minutes'] = 'minuten';
$txt['seconds'] = 'seconden';

// Used upper case in Paid subscriptions management
$txt['hour'] = 'Uur';
$txt['days_word'] = 'dagen';

$txt['search_for'] = 'Zoek naar';
$txt['search_match'] = 'Overeenkomst';

$txt['forum_in_maintenance'] = 'Het forum is in Onderhoudsmodus. Alleen beheerders kunnen momenteel inloggen.';
$txt['maintenance_page'] = 'Je kunt de Onderhoudsmodus uitzetten bij de <a href="%1$s">Serverinstellingen</a>.';

$txt['read_one_time'] = '1 keer gelezen';
$txt['read_many_times'] = '%1$d keer gelezen';

$txt['forum_stats'] = 'Statistieken';
$txt['latest_member'] = 'Nieuwste lid';
$txt['total_cats'] = 'Totaal categorie&euml;n';
$txt['latest_post'] = 'Laatste bericht';

$txt['total_boards'] = 'Totaal boards';

$txt['print_page'] = 'Print pagina';
$txt['print_page_text'] = 'Alleen tekst';
$txt['print_page_images'] = 'Tekst met afbeeldingen';

$txt['valid_email'] = 'Dit moet een geldig e-mailadres zijn.';

$txt['geek'] = 'een heleboel';
$txt['info_center_title'] = '%1$s - Infocentrum';

$txt['watch'] = 'Volgen';
$txt['unwatch'] = 'Stop volgen';

$txt['check_all'] = 'Alles selecteren';

// Use numeric entities in the below string.
$txt['database_error'] = 'Databasefout';
$txt['try_again'] = 'Probeer het opnieuw. Gaat het weer fout, meld het dan aan de beheerder.';
$txt['file'] = 'Bestand';
$txt['line'] = 'Regel';
// Use numeric entities in the below string.
$txt['tried_to_repair'] = 'SMF heeft een fout in je database gedetecteerd en automatisch geprobeerd deze te repareren. Als de problemen blijven bestaan of als je voortdurend deze e-mail krijgt, neem dan contact op met je host.';
$txt['database_error_versions'] = '<strong>Opmerking:</strong> het ziet er naar uit dat je database wellicht een upgrade nodig heeft. De versie van je forumbestanden is momenteel %1$s, terwijl je database op dit moment op versie %2$s staat. Het probleem kan mogelijk verholpen worden door de nieuwste versie van upgrade.php uit te voeren.';
$txt['template_parse_error'] = 'Template-verwerkingsfout!';
$txt['template_parse_error_message'] = 'Het lijkt erop dat er iets verkeerd gegaan is met het templatesysteem van het forum. Dit probleem zou slechts tijdelijk moeten zijn, dus probeer het later opnieuw. Als je dit bericht blijft krijgen, neem dan contact op met de beheerder.<br><br>Je kunt ook proberen om <a href="javascript:location.reload();">deze pagina te verversen</a>.';
// argument(s): filename, $boardurl, $scripturl
$txt['template_parse_error_details'] = 'Er is een probleem ontstaan bij het laden van het template- of taalbestand <pre><strong>%1$s</strong></pre>. Controleer de syntaxis hiervan en probeer het opnieuw. Vergeet niet dat apostrofs (<pre>\'</pre>) vaak nog eens afgebroken moeten worden met een schuine streep (<pre>\\</pre>). Om meer specifieke foutinformatie van PHP te verkrijgen, kun je <a href="%2$s%1$s">het bestand direct benaderen</a>.<br><br>Je wilt wellicht <a href="javascript:location.reload();">deze pagina vernieuwen</a> of <a href="%3$s?theme=1">het standaardthema gebruiken</a>.';
$txt['template_parse_errmsg'] = 'Helaas is er op dit moment geen informatie beschikbaar over wat er precies fout is.';

$txt['today'] = '<strong>Vandaag</strong> om ';
$txt['yesterday'] = '<strong>Gisteren</strong> om ';
$txt['new_poll'] = 'Nieuwe poll';
$txt['poll_question'] = 'Vraag';
$txt['poll_vote'] = 'Stem';
$txt['poll_total_voters'] = 'Totaal aantal stemmen';
$txt['poll_results'] = 'Bekijk de resultaten';
$txt['poll_lock'] = 'Vergrendel de poll';
$txt['poll_unlock'] = 'Ontgrendel de poll';
$txt['poll_edit'] = 'Bewerk de poll';
$txt['poll'] = 'Poll';
$txt['one_hour'] = '1 uur';
$txt['one_day'] = '1 dag';
$txt['one_week'] = '1 week';
$txt['two_weeks'] = '2 Weken';
$txt['one_month'] = '1 maand';
$txt['two_months'] = '2 Maanden';
$txt['forever'] = 'Blijvend';
$txt['moved'] = 'VERPLAATST';
$txt['move_why'] = 'Vul alsjeblieft een korte beschrijving in<br>waarom dit topic verplaatst is.';
$txt['board'] = 'Board';
$txt['in'] = 'in';
$txt['sticky_topic'] = 'Sticky topic';

$txt['delete'] = 'Verwijder';
$txt['no_change'] = 'Geen wijzigingen';

$txt['your_pms'] = 'Je persoonlijke berichten';

$txt['kilobyte'] = 'kB';
$txt['megabyte'] = 'MB';

$txt['more_stats'] = '[Meer statistieken]';

// Use numeric entities in the below three strings.
$txt['code'] = 'Code';
$txt['code_select'] = 'Selecteer';
$txt['code_expand'] = 'Uitklappen';
$txt['code_shrink'] = 'Inklappen';
$txt['quote_from'] = 'Citaat van';
$txt['quote'] = 'Citeer';
$txt['quote_action'] = 'Citeer';
$txt['quote_selected_action'] = 'Citeer geselecteerde tekst';
$txt['fulledit'] = 'Volledig&nbsp;aanpassen';
$txt['edit'] = 'Bewerken';
$txt['quick_edit'] = 'Snel bewerken';
$txt['post_options'] = 'Meer...';

$txt['merge_to_topic_id'] = 'ID van doeltopic';
$txt['split'] = 'Splits topic';
$txt['merge'] = 'Voeg topic samen';
$txt['target_id'] = 'Selecteer doel topic ID';
$txt['target_below'] = 'Selecteer het doel uit de lijst hieronder';
$txt['subject_new_topic'] = 'Titel van het nieuwe topic';
$txt['split_this_post'] = 'Splits alleen dit bericht';
$txt['split_after_and_this_post'] = 'Splits topic vanaf dit bericht.';
$txt['select_split_posts'] = 'Selecteer berichten om te splitsen.';
$txt['new_topic'] = 'Nieuw topic';
$txt['split_successful'] = 'Onderwerp succesvol gesplitst in twee topics.';
$txt['origin_topic'] = 'Oorspronkelijke topic';
$txt['please_select_split'] = 'Selecteer welke berichten je wilt afsplitsen.';
$txt['merge_successful'] = 'Topics succesvol samengevoegd.';
$txt['new_merged_topic'] = 'Nieuw samengevoegd topic';
$txt['topic_to_merge'] = 'Topic dat moet worden samengevoegd';
$txt['target_board'] = 'Doelboard';
$txt['target_topic'] = 'Doeltopic ';
$txt['merge_desc'] = 'Deze optie zal de twee topics samenvoegen. De berichten zullen worden gesorteerd op datum, dus het eerst geplaatste bericht zal bovenaan komen te staan in het samengevoegde topic.';

$txt['set_sticky'] = 'Maak topic sticky';
$txt['set_nonsticky'] = 'Maak topic niet-sticky';
$txt['set_lock'] = 'Sluit topic';
$txt['set_unlock'] = 'Slot verwijderen';

$txt['search_advanced'] = 'Geavanceerd zoeken';

$txt['security_risk'] = 'GROOT BEVEILIGINGSRISICO:';
$txt['not_removed'] = 'Je hebt het volgende bestand niet verwijderd: ';
$txt['not_removed_extra'] = '%1$s is een niet door SMF gegenereerde backup van %2$s. Dit bestand kan worden gebruikt om ongeautoriseerd toegang te krijgen tot je forum - verwijder het zo snel mogelijk.';
$txt['generic_warning'] = 'Waarschuwing';
$txt['agreement_missing'] = 'Nieuwe gebruikers moeten de registratieovereenkomst accepteren, maar dit bestand (agreement.txt) bestaat niet.';
$txt['policy_agreement_missing'] = 'Nieuwe gebruikers moeten de privacyverklaring accepteren, maar deze is leeg.';
$txt['auth_secret_missing'] = 'Het is niet mogelijk om de authenticatie code in Settings.php op te slaan. Hierdoor komt de beveiliging van het forum in gevaar en maakt het kwetsbaar voor aanvallen. Controleer de bestandspermissies voor Settings.php opdat SMF het bestand kan wijzigen.';

$txt['cache_writable'] = 'De cachemap is niet beschrijfbaar! Dit zal je forumprestaties ongunstig be&iuml;nvloeden.';

$txt['page_created_full'] = 'Pagina opgebouwd in %1$.3f seconden met %2$d queries.';

$txt['report_to_mod_func'] = 'Gebruik deze functie om de moderators en administrators op de hoogte te stellen van berichten die verkeerd geplaatst zijn of strijdig zijn met de forumregels.';
$txt['report_profile_func'] = 'Gebruik deze functie om de beheerders en moderators op de hoogte te stellen van profielen die in strijd zijn met de forumregels, spam zijn of ongepaste afbeeldingen bevatten.';

$txt['online'] = 'Online';
$txt['member_is_online'] = '%1$s is online';
$txt['offline'] = 'Offline';
$txt['member_is_offline'] = '%1$s is offline';
$txt['pm_online'] = 'Persoonlijk bericht (Online)';
$txt['pm_offline'] = 'Persoonlijk bericht (Offline)';
$txt['status'] = 'Status';

$txt['go_up'] = 'Omhoog';
$txt['go_down'] = 'Omlaag';

// argument(s): SMF_FULL_VERSION, SMF_SOFTWARE_YEAR, $scripturl
$forum_copyright = '<a href="%3$s?action=credits" title="Licentie" target="_blank" rel="noopener">%1$s &copy; %2$s</a>, <a href="https://www.simplemachines.org" title="Simple Machines" target="_blank" rel="noopener">Simple Machines</a>';

$txt['birthdays'] = 'Verjaardagen:';
$txt['events'] = 'Gebeurtenissen:';
$txt['birthdays_upcoming'] = 'Aanstaande verjaardagen:';
$txt['events_upcoming'] = 'Aanstaande evenementen:';
// Prompt for holidays in the calendar, leave blank to just display the holiday's name.
$txt['calendar_prompt'] = 'Vakantiedagen:';
$txt['calendar_month'] = 'Maand';
$txt['calendar_year'] = 'Jaar';
$txt['calendar_day'] = 'Dag';
$txt['calendar_event_title'] = 'Titel van gebeurtenis';
$txt['calendar_event_options'] = 'Opties voor gebeurtenis';
$txt['calendar_post_in'] = 'Plaatsen in';
$txt['calendar_edit'] = 'Bewerk gebeurtenis';
$txt['calendar_export'] = 'Exporteer Gebeurtenis';
$txt['calendar_view_week'] = 'Toon week';
$txt['event_delete_confirm'] = 'Deze gebeurtenis verwijderen?';
$txt['event_delete'] = 'Verwijder deze gebeurtenis';
$txt['calendar_post_event'] = 'Nieuwe gebeurtenis';
$txt['calendar'] = 'Kalender';
$txt['calendar_link'] = 'Link aan de kalender';
$txt['calendar_upcoming'] = 'Aanstaande kalender';
$txt['calendar_today'] = 'Kalender van vandaag';
$txt['calendar_week'] = 'Week';
$txt['calendar_week_title'] = 'Week %1$d van %2$d';
// %1$s is the month, %2$s is the day, %3$s is the year. Change to suit your language.
$txt['calendar_week_beginning'] = 'Week die begint op %1$s %2$s, %3$s';
$txt['calendar_numb_days'] = 'Aantal dagen';
$txt['calendar_how_edit'] = 'Hoe bewerk je deze gebeurtenissen?';
$txt['calendar_link_event'] = 'Koppel gebeurtenis aan bericht';
$txt['calendar_confirm_delete'] = 'Weet je zeker dat je deze gebeurtenis wilt verwijderen?';
$txt['calendar_linked_events'] = 'Gekoppelde gebeurtenissen';
$txt['calendar_click_all'] = 'klik hier om alle %1$s te zien';
$txt['calendar_allday'] = 'De hele dag';
$txt['calendar_timezone'] = 'Tijdzone';
$txt['calendar_list'] = 'Lijst';
$txt['calendar_empty'] = 'Er zijn geen gebeurtenissen.';

$txt['movetopic_change_subject'] = 'Wijzig het onderwerp van het topic';
$txt['movetopic_new_subject'] = 'Nieuwe titel';
$txt['movetopic_change_all_subjects'] = 'Wijzig het onderwerp van alle berichten';
$txt['move_topic_unapproved_js'] = 'Waarschuwing! Dit topic is nog niet goedgekeurd.\n\nHet wordt afgeraden een verplaatst-topic te maken, tenzij je van plan bent het topic direct na het verplaatsen goed te keuren.';
$txt['movetopic_auto_board'] = '[BOARD]';
$txt['movetopic_auto_topic'] = '[TOPIC LINK]';

// argument(s): $txt['movetopic_auto_board'], $txt['movetopic_auto_topic']
$txt['movetopic_default'] = 'Dit topic is verplaatst naar %1$s.

%2$s';

$txt['movetopic_redirect'] = 'Doorsturen naar het verplaatste topic';

$txt['post_redirection'] = 'Plaats een doorverwijzingstopic';
$txt['redirect_topic_expires'] = 'Verwijder het doorverwijzingstopic automatisch';
$txt['mergetopic_redirect'] = 'Doorverwijzen naar het samengevoegde topic';
$txt['merge_topic_unapproved_js'] = 'Waarschuwing! Dit topic is nog niet goedgekeurd.\n\nHet wordt niet aanbevolen een doorverwijzingstopic te maken tenzij je van plan bent het topic direct na het samenvoegen goed te keuren.';

$txt['theme_template_error'] = 'Kan template \'%1$s\' niet laden.';
$txt['theme_language_error'] = 'Kan taalbestand \'%1$s\' niet laden.';

$txt['sub_boards'] = 'Sub-Boards';
$txt['restricted_board'] = 'Board met beperkte toegang';

$txt['smtp_no_connect'] = 'Kan geen verbinding krijgen met de SMTP host';
$txt['smtp_port_ssl'] = 'SMTP-poortinstelling onjuist; het zou 465 moeten zijn voor SSL-servers. De hostnaam kan ssl:// prefix nodig hebben.';
$txt['smtp_bad_response'] = 'Kan antwoordcodes van mailserver niet ophalen';
$txt['smtp_error'] = 'Problemen opgetreden gedurende het verzenden van mail. Foutmelding: ';
$txt['mail_send_unable'] = 'Kon mail niet verzenden naar e-mailadres \'%1$s\'';

$txt['mlist_search'] = 'Zoek naar leden';
$txt['mlist_search_again'] = 'Herhaal zoekopdracht';
$txt['mlist_search_filter'] = 'Zoekopties';
$txt['mlist_search_email'] = 'Zoek op e-mailadres';
$txt['mlist_search_messenger'] = 'Zoek op messengeradres';
$txt['mlist_search_group'] = 'Zoek op ledengroep';
$txt['mlist_search_name'] = 'Zoek op naam';
$txt['mlist_search_website'] = 'Zoek op website';
$txt['mlist_search_results'] = 'Zoekresultaten voor';
$txt['mlist_search_by'] = 'Zoek op %1$s';
$txt['mlist_menu_view'] = 'Bekijk de ledenlijst';

$txt['attach_downloaded'] = '%1$d keer gedownload';
$txt['attach_viewed'] = '%1$d keer bekeken';

$txt['settings'] = 'Instellingen';
$txt['never'] = 'Nooit';
$txt['more'] = 'meer';
$txt['etc'] = 'etc.';

$txt['hostname'] = 'Hostnaam';
$txt['you_are_post_banned'] = 'Sorry %1$s, je bent verbannen van het plaatsen van berichten en het versturen van persoonlijke berichten op dit forum.';
$txt['ban_reason'] = 'Reden';
$txt['select_item_check'] = 'Selecteer ten minste één item uit de lijst';

$txt['tables_optimized'] = 'Databasetabellen geoptimaliseerd';

$txt['add_poll'] = 'Voeg poll toe';
$txt['poll_options_limit'] = 'Je kunt tot %1$s opties selecteren.';
$txt['poll_remove'] = 'Verwijder poll';
$txt['poll_remove_warn'] = 'Weet je zeker dat je deze poll van dit topic wilt verwijderen?';
$txt['poll_results_expire'] = 'Resultaten zullen worden getoond als de stemming is gesloten';
$txt['poll_expires_on'] = 'Stemmen sluit';
$txt['poll_expired_on'] = 'Stemmen gesloten';
$txt['poll_change_vote'] = 'Verwijder stem';
$txt['poll_return_vote'] = 'Stemopties';
$txt['poll_cannot_see'] = 'Je kunt op dit moment de uitslag van deze poll niet bekijken.';

$txt['quick_mod_approve'] = 'Keur selectie goed';
$txt['quick_mod_remove'] = 'Verwijder selectie';
$txt['quick_mod_lock'] = 'Sluit/heropen selectie';
$txt['quick_mod_sticky'] = 'Maak selectie (niet-)sticky';
$txt['quick_mod_move'] = 'Verplaats selectie naar';
$txt['quick_mod_merge'] = 'Voeg selectie samen';
$txt['quick_mod_markread'] = 'Markeer selectie als gelezen';
$txt['quick_mod_markunread'] = 'Markeer selectie als ongelezen';
$txt['quick_mod_selected'] = 'De geselecteerde opties';
$txt['quick_mod_go'] = 'Voer uit!';
$txt['quickmod_confirm'] = 'Weet je zeker dat je dit wilt doen?';

$txt['spell_check'] = 'Spellingscontrole';

$txt['quick_reply'] = 'Snel beantwoorden';
$txt['quick_reply_warning'] = '<strong>Waarschuwing</strong>: dit topic is op dit moment gesloten! Alleen moderators en administrators kunnen reageren.';
$txt['quick_reply_verification'] = 'Na het verzenden van je post word je doorgewezen naar de reguliere postpagina om je bericht te verifi&euml;ren %1$s.';
$txt['quick_reply_verification_guests'] = '(vereist voor alle gasten)';
$txt['quick_reply_verification_posts'] = '(vereist voor alle leden met minder dan %1$d berichten)';
$txt['wait_for_approval'] = 'Let op: het bericht zal niet zichtbaar zijn tot het is goedgekeurd door een moderator.';

$txt['notification_enable_board'] = 'Weet je zeker dat je notificatie van nieuwe topics voor dit board wilt activeren?';
$txt['notification_disable_board'] = 'Weet je zeker dat je notificatie van nieuwe topics voor dit board wilt deactiveren?';
$txt['notification_enable_topic'] = 'Weet je zeker dat je notificatie van nieuwe berichten voor dit topic wilt activeren?';
$txt['notification_disable_topic'] = 'Weet je zeker dat je notificatie van nieuwe berichten voor dit topic wilt deactiveren?';

// Mentions
$txt['mentions'] = 'Vermeldingen';

// Likes
$txt['likes'] = 'Vind ik leuks';
$txt['like'] = 'Vind ik leuk';
$txt['unlike'] = 'Vind ik niet leuk';
$txt['like_success'] = 'Vind ik leuk toegevoegd aan je bijdrage.';
$txt['like_delete'] = 'Je bijdrage is succesvol verwijderd.';
$txt['like_insert'] = 'Je bijdrage is succesvol toegevoegd.';
$txt['like_error'] = 'Er is een iets fout gegaan met je aanvraag.';
$txt['like_disable'] = 'Vind ik leuk-optie is uitgeschakeld.';
$txt['not_valid_like_type'] = 'Geen geldige Vind ik Leuk';
// Translators, if you need to make more strings to suit your language, e.g. $txt['likes_2'] = 'Two people like this', please do so.
$txt['likes_1'] = '<a href="%1$s">%2$s persoon</a> vindt dit leuk.';
$txt['likes_n'] = '<a href="%1$s">%2$s personen</a> vinden dit leuk.';
$txt['you_likes_0'] = 'Je vindt dit leuk.';
$txt['you_likes_1'] = 'Jij en <a href="%1$s">%2$s andere persoon</a> vinden dit leuk.';
$txt['you_likes_n'] = 'Jij en <a href="%1$s">%2$s andere personen</a> vinden dit leuk.';

$txt['report_to_mod'] = 'Meld dit bericht aan de moderator';
$txt['report_profile'] = 'Meld het profiel van %1$s';

$txt['unread_topics_visit'] = 'Recente ongelezen topics';
// argument(s): scripturl
$txt['unread_topics_visit_none'] = 'Geen ongelezen berichten gevonden sinds je laatste bezoek. <a href="%1$s?action=unread;all">Klik hier om alle ongelezen berichten te tonen</a>.';
$txt['updated_topics_visit_none'] = 'Geen bijgewerkte topics gevonden sinds je laatste bezoek.';
$txt['unread_topics_all'] = 'Alle ongelezen berichten';
$txt['unread_replies'] = 'Ongelezen reacties';

$txt['who_title'] = 'Wie is online?';
$txt['who_and'] = ' en ';
$txt['who_viewing_topic'] = ' bekijken dit topic.';
$txt['who_viewing_board'] = ' bekijken dit board.';
$txt['who_member'] = 'lid';

// No longer used by default theme, but for backwards compat
$txt['powered_by_php'] = 'Powered by PHP';
$txt['powered_by_mysql'] = 'Powered by MySQL';
$txt['valid_css'] = 'Valid CSS!';

$txt['rss'] = 'RSS';
$txt['atom'] = 'Atoom';
$txt['html'] = 'HTML';

$txt['guest'] = 'gast';
$txt['guests'] = 'gasten';
$txt['user'] = 'lid';
$txt['users'] = 'leden';
$txt['hidden'] = 'verborgen';

// Plural form of hidden for languages other than English
$txt['hidden_s'] = 'verborgen';
$txt['buddy'] = 'vriend';
$txt['buddies'] = 'vrienden';
$txt['most_online_ever'] = 'Meeste online ooit';
$txt['most_online_today'] = 'Meeste online vandaag';

$txt['merge_select_target_board'] = 'Selecteer het doel-board waar het samen te voegen topic terecht komt';
$txt['merge_select_poll'] = 'Selecteer welke poll het samengevoegde topic moet krijgen';
$txt['merge_topic_list'] = 'Selecteer de samen te voegen topics';
$txt['merge_select_subject'] = 'Selecteer het onderwerp van het samengevoegde topic';
$txt['merge_custom_subject'] = 'Aangepast onderwerp';
$txt['merge_include_notifications'] = 'neem notificatie mee?';
$txt['merge_check'] = 'Samenvoegen?';
$txt['merge_no_poll'] = 'Geen poll';
$txt['merge_why'] = 'Geef een korte beschrijving van de reden voor het samenvoegen van deze topics.';
$txt['merged_subject'] = '[SAMENGEVOEGD] %1$s';
// argument(s): $txt['movetopic_auto_topic']
$txt['mergetopic_default'] = 'Dit topic is samengevoegd met %2$s.';

$txt['response_prefix'] = 'Re: ';
$txt['current_icon'] = 'Huidige icoon';
$txt['message_icon'] = 'Berichticoon';

$txt['smileys_current'] = 'Huidige smileyset';
$txt['smileys_none'] = 'Geen smileys';
$txt['smileys_forum_board_default'] = 'Forum- of boardstandaard';

$txt['search_results'] = 'Zoekresultaten';
$txt['search_no_results'] = 'Geen resultaten gevonden.';

$txt['total_time_logged_days'] = ' dagen, ';
$txt['total_time_logged_hours'] = ' uren en ';
$txt['total_time_logged_minutes'] = ' minuten';
$txt['total_time_logged_d'] = 'd ';
$txt['total_time_logged_h'] = 'u ';
$txt['total_time_logged_m'] = 'm';

$txt['approve_members_waiting'] = 'Leden wachtend op goedkeuring.';

$txt['activate_code'] = 'Je activeringscode is';

$txt['find_members'] = 'Zoek leden';
$txt['find_username'] = 'Naam, gebruikersnaam, of e-mailadres';
$txt['find_buddies'] = 'Toon alleen vrienden?';
$txt['find_wildcards'] = 'Toegestane jokertekens: *, ?';
$txt['find_no_results'] = 'Geen resultaten gevonden';
$txt['find_results'] = 'Resultaten';
$txt['find_close'] = 'Sluiten';

$txt['unread_since_visit'] = 'Toon ongelezen berichten sinds je laatste bezoek.';
$txt['show_unread_replies'] = 'Toon nieuwe reacties op jouw berichten.';

$txt['change_color'] = 'Verander kleur';

$txt['quickmod_delete_selected'] = 'Verwijder selectie';
$txt['quickmod_split_selected'] = 'Splits selectie';

$txt['show_personal_messages_heading'] = 'Nieuwe berichten';
$txt['show_personal_messages'] = 'Je hebt <strong>%1$s</strong> ongelezen bericht(en) in je postvak IN.<br><br><a href="%2$s">Bekijk je postvak IN</a>';

$txt['help_popup'] = 'Hulp nodig? Laat me het uitleggen:';

$txt['previous_next_back'] = 'Vorige topic';
$txt['previous_next_forward'] = 'Volgende topic';

$txt['mark_unread'] = 'Markeer als ongelezen';

$txt['ssi_not_direct'] = 'Het is niet mogelijk om SSI.php direct per URL te benaderen; gebruik het pad (%1$s) of voeg ?ssi_function=something toe.';
$txt['ssi_session_broken'] = 'SSI.php kon geen sessie laden! Dit zou tot problemen kunnen leiden bij het uitloggen en andere functies - zorg ervoor dat SSI.php ingevoegd staat voor ook maar *iets* anders in je scripts!';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['preview_title'] = 'Bekijk bericht';
$txt['preview_fetch'] = 'Haalt concept op...';
$txt['preview_new'] = 'Nieuw bericht';
$txt['pm_error_while_submitting'] = 'De volgende fout of fouten zijn opgetreden tijdens het versturen van het persoonlijk bericht:';
$txt['error_while_submitting'] = 'Er is een fout opgetreden bij het versturen van dit bericht.';
$txt['error_old_topic'] = 'Waarschuwing: er is al ten minste %1$d dagen geen nieuw bericht geplaatst in dit topic.<br>Tenzij je zeker weet dat je hier wilt reageren, overweeg je beter om een nieuw topic aan te maken.';

$txt['split_selected_posts'] = 'Geselecteerde berichten';
$txt['split_selected_posts_desc'] = 'De berichten hieronder worden na het splitsen een nieuw topic.';
$txt['split_reset_selection'] = 'deselecteer alles';

$txt['modify_cancel'] = 'Annuleren';
$txt['modify_cancel_all'] = 'Alles annuleren';
$txt['mark_read_short'] = 'Markeer gelezen';

$txt['alerts'] = 'Notificaties';

$txt['pm_short'] = 'Mijn berichten';
$txt['pm_menu_read'] = 'Lees je berichten';
$txt['pm_menu_send'] = 'Stuur een bericht';

$txt['unapproved_posts'] = 'Niet-goedgekeurde berichten (topics: %1$d, berichten: %2$d)';

$txt['ajax_in_progress'] = 'Laden...';

$txt['mod_reports_waiting'] = 'Gerapporteerde posts';

$txt['view_unread_category'] = 'Ongelezen berichten';
$txt['new_posts_in_category'] = 'Klik hier om de nieuwe berichten te zien in %1$s';
$txt['verification'] = 'Verificatie';
$txt['visual_verification_hidden'] = 'Laat dit vak leeg alsjeblieft';
$txt['visual_verification_description'] = 'Typ de afgebeelde letters over';
$txt['visual_verification_sound'] = 'Luister naar de letters';
$txt['visual_verification_request_new'] = 'Vraag een andere afbeelding aan';

// Sub menu labels
$txt['summary'] = 'Overzicht';
$txt['account'] = 'Accountinstellingen';
$txt['theme'] = 'Layout-voorkeuren';
$txt['forumprofile'] = 'Forumprofiel';
$txt['activate_changed_email_title'] = 'E-mailadres gewijzigd';
$txt['activate_changed_email_desc'] = 'Je hebt je e-mailadres gewijzigd. Je ontvangt een e-mail om het nieuwe adres te valideren. Klik op de link in de mail om je account te activeren.';
$txt['modSettings_title'] = 'Foruminstellingen';
$txt['package'] = 'Pakketbeheerder';
$txt['errorlog'] = 'Foutenlog';
$txt['edit_permissions'] = 'Permissies';
$txt['mc_unapproved_attachments'] = 'Niet-goedgekeurde bijlagen';
$txt['mc_unapproved_poststopics'] = 'Niet-goedgekeurde posts en topics';
$txt['mc_reported_posts'] = 'Gerapporteerde posts';
$txt['mc_reported_members'] = 'Gerapporteerde leden';
$txt['modlog_view'] = 'Moderatielog';
$txt['calendar_menu'] = 'Bekijk kalender';

// @todo Send email strings - should move?
$txt['send_email'] = 'Verstuur e-mail';

$txt['ignoring_user'] = 'Je negeert deze gebruiker.';
$txt['show_ignore_user_post'] = 'Toon mij deze post.';

$txt['spider'] = 'spider';
$txt['spiders'] = 'spiders';

$txt['downloads'] = 'Downloads';
$txt['filesize'] = 'Bestandsgrootte';

// Restore topic
$txt['restore_topic'] = 'Herstel topic';
$txt['restore_message'] = 'Herstel bericht';
$txt['quick_mod_restore'] = 'Herstel selectie';

// Editor prompt.
$txt['prompt_text_email'] = 'Welk e-mailadres wil je invoegen?';
$txt['prompt_text_ftp'] = 'Welk FTP-adres wil je invoegen?';
$txt['prompt_text_url'] = 'Naar welke URL wil je linken?';
$txt['prompt_text_img'] = 'Wat is de URL van de afbeelding die je wilt invoegen?';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['autosuggest_delete_item'] = 'Verwijder item';

// Debug related - when $db_show_debug is true.
$txt['debug_templates'] = 'Templates: ';
$txt['debug_subtemplates'] = 'Subtemplates: ';
$txt['debug_language_files'] = 'Taalbestanden: ';
$txt['debug_stylesheets'] = 'Stylesheets: ';
$txt['debug_files_included'] = 'Geopende bestanden: ';
$txt['debug_memory_use'] = 'Geheugen gebruikt:';
$txt['debug_kb'] = 'kB.';
$txt['debug_show'] = 'toon';
$txt['debug_cache_hits'] = 'Cachehits: ';
$txt['debug_cache_misses'] = 'Gemiste Cache: ';
$txt['debug_cache_seconds_bytes'] = '%1$ss - %2$s bytes';
$txt['debug_cache_seconds_bytes_total'] = '%1$ss voor %2$s bytes';
$txt['debug_queries_used'] = 'Gebruikte query\'s: %1$d.';
$txt['debug_queries_used_and_warnings'] = 'Gebruikte query\'s: %1$d, %2$d waarschuwingen.';
$txt['debug_query_in_line'] = 'in <em>%1$s</em> regel <em>%2$s</em>, ';
$txt['debug_query_which_took'] = 'die %1$s duurde.';
$txt['debug_query_which_took_at'] = 'die %1$s seconden duurde na %2$s in het verzoek.';
$txt['debug_show_queries'] = '[Toon query\'s]';
$txt['debug_hide_queries'] = '[Verberg query\'s]';
$txt['debug_tokens'] = 'Tokens: ';
$txt['debug_browser'] = 'Browser ID: ';
$txt['debug_hooks'] = 'Hooks aangeroepen: ';
$txt['debug_instances'] = 'Instanties aangemaakt: ';
$txt['are_sure_mark_read'] = 'Weet je zeker dat je alle berichten als gelezen wilt markeren?';

// Inline attachments messages.
$txt['attachments_not_enable'] = 'Bijlagen zijn gedeactiveerd';
$txt['attachments_no_data_loaded'] = 'Geen geldig bijlage ID.';
$txt['attachments_not_allowed_to_see'] = 'Je hebt geen rechten om deze bijlage te bekijken.';
$txt['attachments_no_msg_associated'] = 'Er is geen bericht gekoppeld aan deze bijlage.';
$txt['attachments_unapproved'] = 'Bijlage wacht op goedkeuring.';

// Accessibility
$txt['hide_category'] = 'Verberg categorie';
$txt['show_category'] = 'Toon categorie';
$txt['hide_infocenter'] = 'Verberg infocentrum';
$txt['show_infocenter'] = 'Toon infocentrum';

// Notification post control
$txt['notify_topic_0'] = 'Niet volgend';
$txt['notify_topic_1'] = 'Geen notificaties of e-mails';
$txt['notify_topic_2'] = 'Ontvang notificaties';
$txt['notify_topic_3'] = 'Ontvang e-mails en notificaties';
$txt['notify_topic_0_desc'] = 'Je zult geen e-mails of notificaties voor dit topic ontvangen en het zal ook niet getoond worden in je lijst met ongelezen berichten. Je zult nog wel @vermeldingen voor dit topic ontvangen.';
$txt['notify_topic_1_desc'] = 'Je zult geen e-mails of notificaties ontvangen maar alleen @vermeldingen door andere leden.';
$txt['notify_topic_2_desc'] = 'Je zult notificaties ontvangen voor dit topic.';
$txt['notify_topic_3_desc'] = 'Je zult zowel notificaties als e-mails ontvangen voor dit topic.';
$txt['notify_board_1'] = 'Geen notificaties of e-mails';
$txt['notify_board_2'] = 'Ontvang notificaties';
$txt['notify_board_3'] = 'Ontvang e-mails en notificaties';
$txt['notify_board_1_desc'] = 'Je zult geen e-mails of notificaties ontvangen voor nieuwe topics';
$txt['notify_board_2_desc'] = 'Je zult notificaties ontvangen voor dit board.';
$txt['notify_board_3_desc'] = 'Je zult zowel notificaties als e-mails ontvangen voor dit board.';

$txt['notify_board_prompt'] = 'Wil je een notificatie per e-mail ontvangen wanneer iemand een nieuw topic start in dit board?';
$txt['notify_board_subscribed'] = '%1$s is geabonneerd op notificaties van nieuwe topics in dit board.';
$txt['notify_board_unsubscribed'] = '%1$s is niet langer geabonneerd op notificaties van nieuwe topics in dit board.';

$txt['notify_topic_prompt'] = 'Wil je een e-mail ontvangen als iemand antwoord geeft in dit topic?';
$txt['notify_topic_subscribed'] = '%1$s is geabonneerd op notificaties voor nieuwe reacties in dit board.';
$txt['notify_topic_unsubscribed'] = '%1$s is niet meer geabonneerd op notificaties voor nieuwe reacties in dit board.';

$txt['notify_announcements_prompt'] = 'Wil je forum forum nieuwsbrieven, aankondigingen en belangrijke meldingen per mail ontvangen?';
$txt['notify_announcements_subscribed'] = '%1$s is geabonneerd op forum nieuwsbrieven, aankondigingen en belangrijke meldingen.';
$txt['notify_announcements_unsubscribed'] = '%1$s is niet langer geabonneerd op forum nieuwsbrieven, aankondigingen en belangrijke meldingen.';

$txt['unsubscribe_announcements_plain'] = 'Om je abonnement op forum nieuwsbrieven, aankondigingen en belangrijke meldingen te stoppen, klik op deze link: %1$s';
$txt['unsubscribe_announcements_html'] = '<span style="font-size:small"><a href="%1$s">Afmelden</a> voor forum nieuwsbrieven, aankondigingen en belangrijke meldingen.</span>';
$txt['unsubscribe_announcements_manual'] = 'Indien je geen nieuwsbrieven, aankondigingen en belangrijke meldingen van het forum meer wilt ontvangen, neem dan contact met ons op via %1$s met je verzoek.';

// Mobile Actions
$txt['mobile_action'] = 'Gebruikersacties';
$txt['mobile_moderation'] = 'Moderatie';
$txt['mobile_user_menu'] = 'Hoofdmenu';
$txt['mobile_generic_menu'] = '%1$s Menu';

// Formats for lists in a sentence (e.g. "Alice, Bob, and Charlie")
// Examples:
// 	$txt['sentence_list_format'][2] specifies a format for a list with two items
// 	$txt['sentence_list_format']['n'] specifies the default format
// Notes on placeholders:
// 	{1} = first item in the list, {2} = second item, etc.
// 	{-1} = last item in the list, {-2} = second last item, etc.
// 	{series} = concatenated string of the rest of the items in the list
$txt['sentence_list_format'][1] = '{1}';
$txt['sentence_list_format'][2] = '{1} en {-1}';
$txt['sentence_list_format'][3] = '{series}, en {-1}';
$txt['sentence_list_format'][4] = '{series}, en {-1}';
$txt['sentence_list_format'][5] = '{series}, en {-1}';
$txt['sentence_list_format']['n'] = '{series}, en {-1}';
// Separators used to build lists in a sentence
$txt['sentence_list_separator'] = ', ';
$txt['sentence_list_separator_alt'] = '; ';

?>