<?php
// Version: 2.1.5; index

global $forum_copyright, $webmaster_email, $scripturl, $context, $boardurl;

// Native name, please use full HTML entities to write your language's name.
$txt['native_name'] = 'English';

// Locale (strftime, basename). For more information see:
//   - https://php.net/function.setlocale
$txt['lang_locale'] = 'en_US';
$txt['lang_dictionary'] = 'ja';
//https://developers.google.com/recaptcha/docs/language
$txt['lang_recaptcha'] = 'ja';

// Ensure you remember to use uppercase for character set strings.
$txt['lang_character_set'] = 'UTF-8';
// Character set right to left?  0 = ltr; 1 = rtl
$txt['lang_rtl'] = '0';
// Number format.
$txt['number_format'] = '1,234.00';

$txt['days_title'] = '日数';
$txt['days'] = array('日曜日', '月曜日', '火曜日', '水曜日', '木曜日', '金曜日', '土曜日');
$txt['days_short'] = array('日', '月', '火', '水', '木', '金', '土');
// Months must start with 1 => 'January'. (or translated, of course.)
$txt['months_title'] = 'ヶ月';
$txt['months'] = array(1 => '１月', 2 => '２月', 3 => '３月（弥生）', 4 => '４月', 5 => '５月', 6 => '６月', 7 => '７月', 8 => '８月', 9 => '９月', 10 => '１０月', 11 => '１１月', 12 => '１２月');
$txt['months_titles'] = array(1 => '１月（睦月）', 2 => '２月', 3 => '３月（弥生）', 4 => '４月', 5 => '５月', 6 => '６月', 7 => '７月', 8 => '８月', 9 => '９月', 10 => '１０月', 11 => '１１月', 12 => '１２月');
$txt['months_short'] = array(1 => '3', 2 => '2', 3 => 'Mar', 4 => '4', 5 => '５月', 6 => '6', 7 => '7', 8 => '8', 9 => '9', 10 => '10', 11 => '11', 12 => '12');
$txt['prev_month'] = 'Previous month';
$txt['next_month'] = 'Next month';
$txt['start'] = 'Start';
$txt['end'] = 'End';
$txt['starts'] = 'Starts';
$txt['ends'] = 'Ends';
$txt['none'] = '無し';

$txt['minutes_label'] = '分';
$txt['hours_label'] = '時間';
$txt['years_title'] = '年';

$txt['time_am'] = '午前';
$txt['time_pm'] = '午後';

// Short form of minutes
$txt['minutes_short'] = 'mins';
// Short form of hour
$txt['hour_short'] = 'hr';
// Short form of hours
$txt['hours_short'] = 'hrs';
// Decimal sign
$txt['decimal_sign'] = '.';

$txt['admin'] = '管理人室';
$txt['moderate'] = 'モデレート';

$txt['save'] = '保存';
$txt['reset'] = 'Reset';
$txt['upload'] = 'アップロード';
$txt['upload_all'] = 'Upload all';
$txt['processing'] = 'Processing...';

$txt['modify'] = '修正';
$txt['forum_index'] = '%1$s - インデックス';
$txt['members'] = 'メンバーリスト';
$txt['board_name'] = '掲示板名';
$txt['posts'] = '投稿';

$txt['member_postcount'] = '件の投稿';
$txt['no_subject'] = '（題名無し）';
$txt['view_profile'] = 'プロフィールを見る';
$txt['guest_title'] = 'ゲスト';
$txt['author'] = '投稿者';
$txt['on'] = 'より';
$txt['remove'] = '削除';
$txt['start_new_topic'] = 'スレッドを建てる';

$txt['login'] = 'Log in';
// Use numeric entities in the below string.
$txt['username'] = 'ユーザー名';
$txt['password'] = 'パスワード';

$txt['username_no_exist'] = 'そのようなユーザ名は存在しません。';
$txt['no_user_with_email'] = 'このメールアドレスに関連付けられているユーザー名はありません。';

$txt['board_moderator'] = '掲示板のモデレーター';
$txt['remove_topic'] = 'スレッドの削除';
$txt['topics'] = '件のスレッド';
$txt['modify_msg'] = '投稿内容を編集';
$txt['name'] = '名前';
$txt['email'] = 'メール';
$txt['user_email_address'] = 'メールアドレス';
$txt['subject'] = '題名';
$txt['message'] = '内容';
$txt['redirects'] = 'リダイレクト';
$txt['quick_modify'] = 'Modify inline';
$txt['quick_modify_message'] = 'You have successfully modified this message.';
$txt['reason_for_edit'] = '編集の理由';

$txt['choose_pass'] = 'パスワード';
$txt['verify_pass'] = 'パスワード確認';
$txt['notify_announcements'] = 'Allow the administrators to send me important news by email';

$txt['position'] = '地位';

// argument(s): username
$txt['view_profile_of_username'] = 'View the profile of %1$s';
$txt['total'] = 'トータル';
$txt['website'] = 'サイト';
$txt['register'] = 'Sign up';
$txt['warning_status'] = 'Warning status';
$txt['user_warn_watch'] = 'ユーザーはモデレーターウォッチリストにあります';
$txt['user_warn_moderate'] = 'ユーザー投稿承認キューへの参加';
$txt['user_warn_mute'] = 'ユーザーは投稿からBANされています';
$txt['warn_watch'] = '視聴済み';
$txt['warn_moderate'] = 'モデレート済み';
$txt['warn_mute'] = 'ミュート中';

$txt['message_index'] = '投稿内容一覧';
$txt['news'] = 'お知らせの編集';
$txt['home'] = 'ホーム';
$txt['page'] = 'ページ';
$txt['prev'] = 'Previous page';
$txt['next'] = 'Next page';

$txt['lock_unlock'] = 'スレッドのロック／アンロック';
$txt['post'] = '投稿';
$txt['error_occured'] = 'エラー発生！';
$txt['at'] = 'にて';
$txt['by'] = '作成者:';
$txt['logout'] = 'Log out';
$txt['started_by'] = 'スレッド開設者';
$txt['topic_started_by'] = '<strong>%1$s</strong> <em>%2$s</em> によって開始されました';
$txt['replies'] = '投稿数';
$txt['last_post'] = '最新の投稿';
$txt['first_post'] = '最初の投稿';
$txt['last_poster'] = '最終投稿者:';
$txt['last_post_message'] = '<strong>最後の投稿: </strong>%3$s <span class="postby">%2$s by %1$s</span>';
$txt['last_post_topic'] = '%1$s<br>by %2$s';
$txt['post_by_member'] = '<strong>%1$s</strong> by <strong>%2$s</strong><br>';
$txt['boardindex_total_posts'] = '%1$s は %2$s メンバーの %3$s トピックに投稿されました';
$txt['show'] = '表示';
$txt['hide'] = '非表示';

$txt['admin_login'] = '管理人ログイン';
// Use numeric entities in the below string.
$txt['topic'] = 'スレッド';
$txt['help'] = 'ヘルプ';
$txt['terms_and_rules'] = '規約とルール';
$txt['watch_board'] = 'このボードを見る';
$txt['unwatch_board'] = 'Stop watching Board';
$txt['watch_topic'] = 'このトピックを見る';
$txt['unwatch_topic'] = 'Stop watching Topic';
$txt['watching_topic'] = 'Topic you are watching';
$txt['watching_this_topic'] = 'あなたはこのトピックを視聴しており、それについての通知を受け取ります。';
$txt['notify'] = '更新通知';
$txt['unnotify'] = '通知解除';

// Use numeric entities in the below string.
// argument(s): forum name
$txt['regards_team'] = 'Regards,
The %1$s Team.';

$txt['notify_replies'] = 'スレッドの更新の通知';
$txt['move_topic'] = 'スレッドの移動';
$txt['move_to'] = '移動先';
$txt['pages'] = 'ページ';
$txt['users_active'] = '%s分前までのアクティブなユーザ';
$txt['personal_messages'] = '個人メッセージ';
$txt['reply_quote'] = '引用して返信';
$txt['reply'] = '返信する';
$txt['reply_noun'] = '返信する';
$txt['reply_number'] = 'Reply #%1$s%2$s';
$txt['approve'] = '承認';
$txt['unapprove'] = '承認を解除';
$txt['approve_all'] = 'すべて承認する';
$txt['issue_warning'] = '問題の警告';
$txt['awaiting_approval'] = 'Awaiting approval';
$txt['attach_awaiting_approve'] = '承認待ちの添付ファイル';
$txt['post_awaiting_approval'] = 'This message is awaiting approval by a moderator.';
$txt['there_are_unapproved_topics'] = 'このボードには %1$s のトピックと %2$s の投稿があります。 <a href="%3$s">ここ</a> をクリックしてすべてを表示してください。';
$txt['send_message'] = 'メッセージを送信';

$txt['msg_alert_no_messages'] = 'you don\'t have any messages';
$txt['msg_alert_one_message'] = 'you have <a href="%1$s">1 message</a>';
$txt['msg_alert_many_message'] = '<a href="%1$s">%2$d メッセージ</a>';
$txt['msg_alert_one_new'] = '1 is new';
$txt['msg_alert_many_new'] = '%1$d が新しいです';
$txt['new_alert'] = 'New alert';
$txt['remove_message'] = '投稿内容を削除';
$txt['remove_message_question'] = '投稿内容を削除?';

$txt['topic_alert_none'] = 'メッセージがありません...';
$txt['pm_alert_none'] = 'メッセージがありません...';
$txt['no_messages'] = 'メッセージはありません';

$txt['online_users'] = 'オンラインのユーザ数';
$txt['jump_to'] = 'ジャンプ先';
$txt['go'] = '実行！';
$txt['are_sure_remove_topic'] = '本当にこのスレッドを削除してもいいですか？';
$txt['yes'] = 'はい';
$txt['no'] = 'いいえ';

$txt['search_end_results'] = '検索終了';
$txt['search_on'] = '投稿日：';

$txt['search'] = '検索';
$txt['all'] = 'すべて';
$txt['search_entireforum'] = 'Entire forum';
$txt['search_thisboard'] = 'This board';
$txt['search_thistopic'] = 'このトピック';
$txt['search_members'] = 'メンバーリスト';

$txt['back'] = '戻る';
$txt['continue'] = '続ける';
$txt['password_reminder'] = 'パスワードの再発行';
$txt['topic_started'] = 'スレッド開設者';
$txt['title'] = 'タイトル';
$txt['post_by'] = '投稿者';
$txt['memberlist_searchable'] = '検索可能な全てのメンバー';
$txt['welcome_newest_member'] = '当社の最新メンバーである %1$sを歓迎してください。';
$txt['admin_center'] = '管理人室';
$txt['last_edit_by'] = '<span class="lastedit">最後の編集</span>: %1$s by %2$s';
$txt['last_edit_reason'] = '<span id="reason" class="lastedit">Reason</span>: %1$s';
$txt['notify_deactivate'] = 'このスレッドの更新情報のメール通知を解除しますか？';
$txt['modified_time'] = 'Last edited';
$txt['modified_by'] = 'Edited by';

$txt['recent_posts'] = '最近の投稿';

$txt['location'] = '位置';
$txt['location_desc'] = 'Geographic location.';
$txt['gender'] = '性別';
$txt['gender_0'] = 'None';
$txt['gender_1'] = 'Male';
$txt['gender_2'] = 'Female';
$txt['gender_desc'] = 'Your gender.';
$txt['icq'] = 'ICQ';
$txt['icq_desc'] = 'This is your ICQ number.';
$txt['skype'] = 'Skype';
$txt['skype_desc'] = 'Your Skype username';
$txt['personal_text'] = 'Personal text';
$txt['date_registered'] = '登録日';

$txt['recent_view'] = '新着１０件の投稿';
$txt['recent_updated'] = 'が、最近更新されたスレッドです。';
$txt['is_recent_updated'] = '%1$s は最新のトピックです';

$txt['male'] = '男性';
$txt['female'] = '女性';

$txt['error_invalid_characters_username'] = 'ユーザ名に不正な文字が含まれています。<storng>半角英数字のみ</strong>で書いてください。';

// argument(s): forum name, login URL, login JavaScript snippet
$txt['welcome_guest'] = 'Welcome to <strong>%1$s</strong>. Please <a href="%2$s" onclick="%3$s">log in</a>.';

// argument(s): forum name, login URL, login JavaScript snippet, signup URL
$txt['welcome_guest_register'] = 'Welcome to <strong>%1$s</strong>. Please <a href="%2$s" onclick="%3$s">log in</a> or <a href="%4$s">sign up</a>.';

// argument(s): $scripturl
$txt['welcome_guest_activate'] = '<a href="%1$s?action=activate">Did you miss your activation email?</a>';

// argument(s): $scripturl
$txt['register_prompt'] = 'Don\'t have an account? <a href="%1$s?action=signup">Sign up</a>.';

// argument(s): forum name
$txt['welcome_to_forum'] = 'Welcome to <strong>%1$s</strong>.';

// @todo the following to sprintf
$txt['hello_member'] = 'ようこそ、';
// Use numeric entities in the below string.
$txt['hello_guest'] = 'ようこそ、';
$txt['select_destination'] = '行き先を指定してください';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['posted_by'] = '投稿者：';

$txt['icon_smiley'] = 'スマイリー';
$txt['icon_angry'] = '怒り';
$txt['icon_cheesy'] = 'ほほえみ';
$txt['icon_laugh'] = '笑い';
$txt['icon_sad'] = '悲しい';
$txt['icon_wink'] = 'ウィンク';
$txt['icon_grin'] = 'ニヤリ';
$txt['icon_shocked'] = 'ショック';
$txt['icon_cool'] = 'クール';
$txt['icon_huh'] = '疑問';
$txt['icon_rolleyes'] = '目が回る';
$txt['icon_tongue'] = 'アカンベー';
$txt['icon_embarrassed'] = '困惑';
$txt['icon_lips'] = '口を紡ぐ';
$txt['icon_undecided'] = '未決';
$txt['icon_kiss'] = 'キス';
$txt['icon_cry'] = '泣き';

$txt['moderator'] = 'モデレーター';
$txt['moderators'] = 'モデレーター';

$txt['views'] = '参照数';
$txt['new'] = '最新';

$txt['view_all_members'] = '全ユーザを表示';
$txt['view'] = '表示';

$txt['viewing_members'] = '%1$s から %2$sのメンバーを見る';
$txt['of_total_members'] = '合計メンバー数 %1$s';

$txt['forgot_your_password'] = 'パスワードを忘れましたか？';

$txt['date'] = '日時';
// Use numeric entities in the below string.
$txt['from'] = '送信者';
$txt['check_new_messages'] = '新しいメッセージの確認';
$txt['to'] = '受信者';

$txt['board_topics'] = 'スレッド';
$txt['members_title'] = 'メンバーの閲覧／削除';
$txt['members_list'] = 'メンバーリスト';
$txt['new_posts'] = '新しい投稿';
$txt['old_posts'] = '新着投稿無し';
$txt['redirect_board'] = 'リダイレクトボード';

$txt['sendtopic_send'] = '送信';
$txt['report_sent'] = 'レポートが正常に送信されました。';
$txt['post_becomes_unapproved'] = 'Your message was not approved because it was posted in an unapproved topic. Once the topic is approved your message will be approved too.';

$txt['time_offset'] = '時差';
$txt['or'] = 'もしくは';

$txt['no_matches'] = '何も見つかりませんでした。';

$txt['notification'] = '通知';

$txt['your_ban'] = '%sさん、あなたはこのフォーラム使用を停止されています！';
$txt['your_ban_expires'] = 'Your ban is set to expire %s';
$txt['your_ban_expires_never'] = 'このBANは期限切れに設定されていません。';
$txt['ban_continue_browse'] = '引き続きフォーラムをゲストとして閲覧できます。';

$txt['mark_as_read'] = 'すべての投稿を読んだことにする';

$txt['locked_topic'] = 'ロックされたスレッド';
$txt['normal_topic'] = '普通のスレッド';
$txt['participation_caption'] = 'あなたが投稿したスレッド：';
$txt['moved_topic'] = 'トピックを移動';

$txt['go_caps'] = '実行';

$txt['print'] = '印刷';
$txt['profile'] = 'プロフィール';
$txt['topic_summary'] = 'スレッドの概要';
$txt['not_applicable'] = 'なし';
$txt['name_in_use'] = 'そのユーザ名は、すでに他のメンバーが使用しています。';

$txt['total_members'] = '全メンバー数';
$txt['total_posts'] = '全投稿数';
$txt['total_topics'] = '全スレッド数';

$txt['time_logged_in'] = 'Time to stay logged in';

$txt['preview'] = 'プレビュー';
$txt['always_logged_in'] = '期間限定無し';

$txt['logged'] = 'ＩＰ記録';
$txt['show_ip'] = 'Show IP address';
// Use numeric entities in the below string.
$txt['ip'] = 'ＩＰ';
$txt['url'] = 'URL';
$txt['www'] = 'サイト';

$txt['hours'] = '時間';
$txt['minutes'] = '分';
$txt['seconds'] = '秒';

// Used upper case in Paid subscriptions management
$txt['hour'] = '時間';
$txt['days_word'] = '日';

$txt['search_for'] = '以下を検索';
$txt['search_match'] = '一致';

$txt['forum_in_maintenance'] = 'Your forum is in Maintenance Mode. Only administrators can currently log in.';
$txt['maintenance_page'] = '<a href="%1$s">サーバー設定</a> エリアからメンテナンスモードをオフにできます。';

$txt['read_one_time'] = '1回読みます';
$txt['read_many_times'] = '%1$d 回読んでください';

$txt['forum_stats'] = 'フォーラムの統計情報';
$txt['latest_member'] = '最新メンバー';
$txt['total_cats'] = '全カテゴリ';
$txt['latest_post'] = '最新投稿';

$txt['total_boards'] = '全掲示板';

$txt['print_page'] = 'ページを印刷';
$txt['print_page_text'] = 'テキストのみ';
$txt['print_page_images'] = '画像付きテキスト';

$txt['valid_email'] = '正しいメールアドレスを指定してください。';

$txt['geek'] = '私はオタクです!!';
$txt['info_center_title'] = '%1$s - 情報センター';

$txt['watch'] = '見る';
$txt['unwatch'] = 'ウォッチを停止';

$txt['check_all'] = 'Select all';

// Use numeric entities in the below string.
$txt['database_error'] = 'データーベースエラー';
$txt['try_again'] = '再度実行してみてください。もし、このエラーがもう一度起こるようなら、管理人に連絡してください。';
$txt['file'] = 'ファイル';
$txt['line'] = '行';
// Use numeric entities in the below string.
$txt['tried_to_repair'] = 'SMFはデータベースにおけるエラーを検知し、自動的に修復しました。もし、同じ問題が引き続き起きるか、これらのメールが送付されてくる場合は、サーバーの管理人と連絡をとってください。';
$txt['database_error_versions'] = '<b>Note:</b> 使用中のデーターベースのバージョンが低いように思われます。あなたの使用しているフォーラムのバージョンは%sで、データーベース側のバージョンは%sです。upgrade.phpを実行してバージョンアップする必要があります。';
$txt['template_parse_error'] = 'テンプレートパースエラー';
$txt['template_parse_error_message'] = 'テンプレートシステム上で何らかの不具合があるように思われます。この問題は、一時的な物で再試行すれば直ります。もし、同じメッセージが出た場合は、お手数ですが管理人に連絡を取ってください。<br /><br /><a href="javascript:location.reload();">ここ</a>から再試行できます。';
// argument(s): filename, $boardurl, $scripturl
$txt['template_parse_error_details'] = 'There was a problem loading the <pre><strong>%1$s</strong></pre> template or language file. Please check the syntax and try again - remember, single quotes (<pre>\'</pre>) often have to be escaped with a slash (<pre>\\</pre>). To see more specific error information from PHP, try <a href="%2$s%1$s">accessing the file directly</a>.<br><br>You may want to try to <a href="javascript:location.reload();">refresh this page</a> or <a href="%3$s?theme=1">use the default theme</a>.';
$txt['template_parse_errmsg'] = '残念ながら、現時点では正確に何が間違っているのかについては、より多くの情報は入手できません。';

$txt['today'] = '<b>今日</b>の';
$txt['yesterday'] = '<b>昨日</b>の';
$txt['new_poll'] = '投票箱の設置';
$txt['poll_question'] = '質問';
$txt['poll_vote'] = '票を入れる';
$txt['poll_total_voters'] = '全投票数';
$txt['poll_results'] = '結果を表示する。';
$txt['poll_lock'] = '投票のロック';
$txt['poll_unlock'] = '投票のロック解除';
$txt['poll_edit'] = '投票箱を修正';
$txt['poll'] = '投票箱';
$txt['one_hour'] = '１時間';
$txt['one_day'] = '１日';
$txt['one_week'] = '１週間';
$txt['two_weeks'] = '2 週間';
$txt['one_month'] = '１ヶ月';
$txt['two_months'] = '2ヶ月';
$txt['forever'] = '常時ログイン';
$txt['moved'] = '移転';
$txt['move_why'] = 'Please enter a brief description as to<br>why this topic is being moved.';
$txt['board'] = '掲示板';
$txt['in'] = 'in';
$txt['sticky_topic'] = 'スティッキートピック';

$txt['delete'] = '削除';
$txt['no_change'] = '変更しない';

$txt['your_pms'] = '個人メッセージ';

$txt['kilobyte'] = 'KB';
$txt['megabyte'] = 'MB';

$txt['more_stats'] = '[詳細]';

// Use numeric entities in the below three strings.
$txt['code'] = 'コード';
$txt['code_select'] = '選択';
$txt['code_expand'] = 'Expand';
$txt['code_shrink'] = 'Shrink';
$txt['quote_from'] = '引用元：';
$txt['quote'] = '引用';
$txt['quote_action'] = '引用';
$txt['quote_selected_action'] = '選択したテキストを引用する';
$txt['fulledit'] = '完全な&nbsp;編集';
$txt['edit'] = '編集';
$txt['quick_edit'] = 'クイック編集';
$txt['post_options'] = 'その他...';

$txt['merge_to_topic_id'] = '対象トピックのID';
$txt['split'] = 'スレッドの分割';
$txt['merge'] = 'スレッドの結合';
$txt['target_id'] = 'トピックIDでターゲットを選択';
$txt['target_below'] = '以下のリストからターゲットを選択してください';
$txt['subject_new_topic'] = 'スレッドの題名';
$txt['split_this_post'] = 'この投稿だけ分割';
$txt['split_after_and_this_post'] = 'このスレッドのこの投稿から分割する';
$txt['select_split_posts'] = '分割したい投稿';
$txt['new_topic'] = 'スレッドを立てる';
$txt['split_successful'] = 'スレッドは無事２つに分割されました。';
$txt['origin_topic'] = '元のスレッド';
$txt['please_select_split'] = '分割したい投稿を指定してください。';
$txt['merge_successful'] = 'スレッドの結合は成功しました';
$txt['new_merged_topic'] = '最近の結合されたスレッド';
$txt['topic_to_merge'] = '結合されたスレッド';
$txt['target_board'] = 'ターゲットとなる板';
$txt['target_topic'] = 'ターゲットとなるスレッド';
$txt['merge_desc'] = 'この機能は２つのスレッドの内容を１つのスレッドに結合するものです。投稿は、時間によってソートされます。一番最初に投稿されたメッセージがスレッドの先頭になります。';

$txt['set_sticky'] = 'スレッドの更新通知を受ける';
$txt['set_nonsticky'] = 'スレッドの更新通知を解除';
$txt['set_lock'] = 'スレッドのロック';
$txt['set_unlock'] = 'スレッドのロック解除';

$txt['search_advanced'] = '詳細検索';

$txt['security_risk'] = '重大なセキュリティ上の問題があります：';
$txt['not_removed'] = 'あなたはまだ、以下を削除していません：';
$txt['not_removed_extra'] = '%1$s はSMFによって生成されていない %2$s のバックアップです。 それは直接アクセスし、あなたのフォーラムへの不正アクセスを得るために使用することができます。あなたはすぐにそれを削除する必要があります。';
$txt['generic_warning'] = '警告';
$txt['agreement_missing'] = 'You are requiring new users to accept a registration agreement; however, the file (agreement.txt) does not exist.';
$txt['policy_agreement_missing'] = 'You are requiring new users to accept a privacy policy; however, the privacy policy is empty.';
$txt['auth_secret_missing'] = 'Unable to set authentication secret in Settings.php. This weakens the security of your forum and puts it at risk for attacks. Check the file permissions on Settings.php to make sure SMF can write to the file.';

$txt['cache_writable'] = 'キャッシュディレクトリは書き込み可能ではありません - これはフォーラムのパフォーマンスに悪影響を及ぼします。';

$txt['page_created_full'] = '%1$.3f 秒で %2$d クエリが作成されました。';

$txt['report_to_mod_func'] = 'この機能は、不適切な語句を入力したか、間違って入力した際に管理人とモデレーターに通知させるものです。';
$txt['report_profile_func'] = 'スパムや不適切な画像などの不正なプロフィールコンテンツを管理者に通知するためにこの機能を使用します。';

$txt['online'] = 'オンライン';
$txt['member_is_online'] = '%1$s はオンラインです';
$txt['offline'] = 'オフライン';
$txt['member_is_offline'] = '%1$s はオフラインです';
$txt['pm_online'] = '個人メッセージ（オンライン）';
$txt['pm_offline'] = '個人メッセージ（オフライン）';
$txt['status'] = 'ステータス';

$txt['go_up'] = '最上部へ';
$txt['go_down'] = '最下部へ';

// argument(s): SMF_FULL_VERSION, SMF_SOFTWARE_YEAR, $scripturl
$forum_copyright = '<a href="%3$s?action=credits" title="License" target="_blank" rel="noopener">%1$s &copy; %2$s</a>, <a href="https://www.simplemachines.org" title="Simple Machines" target="_blank" rel="noopener">Simple Machines</a>';

$txt['birthdays'] = '誕生日:';
$txt['events'] = 'イベント：';
$txt['birthdays_upcoming'] = '近づいている誕生日：';
$txt['events_upcoming'] = '近づいているイベント：';
// Prompt for holidays in the calendar, leave blank to just display the holiday's name.
$txt['calendar_prompt'] = '祝日:';
$txt['calendar_month'] = '月：';
$txt['calendar_year'] = '年：';
$txt['calendar_day'] = '日：';
$txt['calendar_event_title'] = 'イベント名：';
$txt['calendar_event_options'] = 'イベントオプション';
$txt['calendar_post_in'] = '投稿内容：';
$txt['calendar_edit'] = 'イベント編集';
$txt['calendar_export'] = 'イベントをエクスポート';
$txt['calendar_view_week'] = '週を表示';
$txt['event_delete_confirm'] = 'このイベントを削除しますか？';
$txt['event_delete'] = 'イベントを削除';
$txt['calendar_post_event'] = 'イベントを投稿';
$txt['calendar'] = 'カレンダー';
$txt['calendar_link'] = 'カレンダーにリンク';
$txt['calendar_upcoming'] = '今度の予定';
$txt['calendar_today'] = '今日のカレンダー';
$txt['calendar_week'] = '週：';
$txt['calendar_week_title'] = '%1$d %2$d 週目';
// %1$s is the month, %2$s is the day, %3$s is the year. Change to suit your language.
$txt['calendar_week_beginning'] = '%1$s %2$s週始まる, %3$s';
$txt['calendar_numb_days'] = '日付：';
$txt['calendar_how_edit'] = 'これらのイベントを編集しますか？';
$txt['calendar_link_event'] = 'イベントにリンク';
$txt['calendar_confirm_delete'] = 'このイベントを削除しますか？';
$txt['calendar_linked_events'] = 'リンクされたイベント';
$txt['calendar_click_all'] = 'クリックしてすべての %1$sを表示';
$txt['calendar_allday'] = 'All day';
$txt['calendar_timezone'] = 'Time zone';
$txt['calendar_list'] = 'List';
$txt['calendar_empty'] = 'There are no events to display.';

$txt['movetopic_change_subject'] = 'トピックの件名を変更する';
$txt['movetopic_new_subject'] = '新しい件名';
$txt['movetopic_change_all_subjects'] = 'すべてのメッセージの件名を変更する';
$txt['move_topic_unapproved_js'] = '警告！このトピックはまだ承認されていません。\n\n移動直後に投稿を承認しない限り、リダイレクトのトピックを作成することはお勧めしません。';
$txt['movetopic_auto_board'] = '[BOARD]';
$txt['movetopic_auto_topic'] = 'format@@0';

// argument(s): $txt['movetopic_auto_board'], $txt['movetopic_auto_topic']
$txt['movetopic_default'] = 'This topic has been moved to %1$s.

%2$s';

$txt['movetopic_redirect'] = '移動したトピックにリダイレクト';

$txt['post_redirection'] = 'リダイレクトのトピックを投稿';
$txt['redirect_topic_expires'] = 'リダイレクトのトピックを自動的に削除';
$txt['mergetopic_redirect'] = 'マージされたトピックにリダイレクト';
$txt['merge_topic_unapproved_js'] = '警告！このトピックはまだ承認されていません。\n\nマージ直後に投稿を承認しない限り、リダイレクショントピックを作成することは推奨されません。';

$txt['theme_template_error'] = 'テンプレート「%s」の読み取りに失敗しました。';
$txt['theme_language_error'] = '言語ファイル「%s」の読み取りに失敗しました。';

$txt['sub_boards'] = 'サブボード';
$txt['restricted_board'] = '制限付きボード';

$txt['smtp_no_connect'] = 'SMTPホストに接続できません。';
$txt['smtp_port_ssl'] = 'SMTPのポート設定が認識されませんでした。it should be 465 for SSL servers.';
$txt['smtp_bad_response'] = 'メールサーバからのレスポンスがありません。';
$txt['smtp_error'] = 'メール送信時に以下のエラーが発生しました：';
$txt['mail_send_unable'] = '指定されたメールアドレス「%s」にメールを送ることができませんでした。';

$txt['mlist_search'] = 'ユーザを検索';
$txt['mlist_search_again'] = '再検索';
$txt['mlist_search_filter'] = 'Search options';
$txt['mlist_search_email'] = 'メールアドレスで検索';
$txt['mlist_search_messenger'] = 'ニックネームで検索';
$txt['mlist_search_group'] = 'グループで検索';
$txt['mlist_search_name'] = '名前で検索';
$txt['mlist_search_website'] = 'サイトで検索';
$txt['mlist_search_results'] = '検索結果：';
$txt['mlist_search_by'] = '%1$sで検索';
$txt['mlist_menu_view'] = 'メンバーリストを閲覧';

$txt['attach_downloaded'] = 'ダウンロード回数';
$txt['attach_viewed'] = '閲覧回数';

$txt['settings'] = '設定';
$txt['never'] = 'しない';
$txt['more'] = '続き';
$txt['etc'] = 'etc.';

$txt['hostname'] = 'ホスト名';
$txt['you_are_post_banned'] = '%sさん、すみませんが、あなたはこのフォーラム上での投稿および個人メッセージのやりとりを停止されています。';
$txt['ban_reason'] = '理由';
$txt['select_item_check'] = 'Please select at least one item in the list';

$txt['tables_optimized'] = 'データーベースの再構築は済んでいます。';

$txt['add_poll'] = '投票欄追加';
$txt['poll_options_limit'] = 'You may only select up to %1$s options.';
$txt['poll_remove'] = '投票欄削除';
$txt['poll_remove_warn'] = 'このスレッドから投票箱を削除しても良いですか？';
$txt['poll_results_expire'] = '投票完了したら結果を表示';
$txt['poll_expires_on'] = '投票締め切り';
$txt['poll_expired_on'] = '投票締め切り';
$txt['poll_change_vote'] = '投票を削除';
$txt['poll_return_vote'] = '投票のオプション';
$txt['poll_cannot_see'] = '現在、このアンケートの結果を見ることはできません。';

$txt['quick_mod_approve'] = '承認を選択しました';
$txt['quick_mod_remove'] = '選択を削除';
$txt['quick_mod_lock'] = '選択されたものをロック';
$txt['quick_mod_sticky'] = '選択されたものの更新通知を受ける';
$txt['quick_mod_move'] = '選択されたものを移動';
$txt['quick_mod_merge'] = '選択されたものを結合';
$txt['quick_mod_markread'] = '選択した既読にする';
$txt['quick_mod_markunread'] = '選択した未読にする';
$txt['quick_mod_selected'] = '選択されたオプションを実行すると';
$txt['quick_mod_go'] = '移動';
$txt['quickmod_confirm'] = '本当に実行しますか？';

$txt['spell_check'] = 'スペルチェック';

$txt['quick_reply'] = '簡易返信';
$txt['quick_reply_warning'] = '警告：このスレッドは現在ロックされています！<br />管理人、モデレーターのみが返信できます。';
$txt['quick_reply_verification'] = '投稿を送信すると、通常の投稿ページに移動し、あなたの投稿 %1$s を確認します。';
$txt['quick_reply_verification_guests'] = '(すべてのゲストに必要)';
$txt['quick_reply_verification_posts'] = '( %1$d 投稿未満のすべてのユーザーに必須)';
$txt['wait_for_approval'] = 'Note: this post will not display until it has been approved by a moderator.';

$txt['notification_enable_board'] = '全ての新しいスレッドからの更新通知を有効にしますか？';
$txt['notification_disable_board'] = 'この掲示板の新しいスレッドからの更新通知を無効化しますか？';
$txt['notification_enable_topic'] = 'このスレッドに新しい投稿があった際に通知を受けますか？';
$txt['notification_disable_topic'] = 'このスレッドの新しい投稿の通知を無効化しますか？';

// Mentions
$txt['mentions'] = 'メンション';

// Likes
$txt['likes'] = 'いいね';
$txt['like'] = 'いいね！';
$txt['unlike'] = 'いいね！を解除';
$txt['like_success'] = 'コンテンツが正常にいいね！されました。';
$txt['like_delete'] = 'コンテンツは正常に削除されました。';
$txt['like_insert'] = 'コンテンツが正常に挿入されました。';
$txt['like_error'] = 'リクエストにエラーが発生しました。';
$txt['like_disable'] = 'いいね機能は無効です';
$txt['not_valid_like_type'] = '「いいね」タイプは有効なタイプではありません。';
// Translators, if you need to make more strings to suit your language, e.g. $txt['likes_2'] = 'Two people like this', please do so.
$txt['likes_1'] = '<a href="%1$s">%2$s 人</a> これが気に入っています。';
$txt['likes_n'] = '<a href="%1$s">%2$s 人</a> このような感じです。';
$txt['you_likes_0'] = 'あなたはこれが好きです。';
$txt['you_likes_1'] = 'You and <a href="%1$s">%2$s other person</a> like this.';
$txt['you_likes_n'] = 'あなたと <a href="%1$s">%2$s 他の人々</a> はこのようです。';

$txt['report_to_mod'] = 'モデレーターに連絡';
$txt['report_profile'] = '%1$s のプロファイルを報告';

$txt['unread_topics_visit'] = '最近の未読のスレッド';
// argument(s): scripturl
$txt['unread_topics_visit_none'] = 'No unread topics found since your last visit. <a href="%1$s?action=unread;all">Click here to try all unread topics</a>.';
$txt['updated_topics_visit_none'] = 'No updated topics found since your last visit.';
$txt['unread_topics_all'] = '全ての未読のスレッド';
$txt['unread_replies'] = '更新されたスレッド';

$txt['who_title'] = 'オンラインのメンバー';
$txt['who_and'] = 'さんと、';
$txt['who_viewing_topic'] = 'さんが、このスレッドを見ています。';
$txt['who_viewing_board'] = 'さんが、この掲示板を見ています。';
$txt['who_member'] = 'メンバー';

// No longer used by default theme, but for backwards compat
$txt['powered_by_php'] = 'Powered by PHP';
$txt['powered_by_mysql'] = 'Powered by MySQL';
$txt['valid_css'] = 'Valid CSS';

$txt['rss'] = 'RSS';
$txt['atom'] = 'Atom';
$txt['html'] = 'HTML';

$txt['guest'] = 'ゲスト';
$txt['guests'] = 'ゲスト';
$txt['user'] = 'ユーザ';
$txt['users'] = 'ユーザー';
$txt['hidden'] = '表示しない';

// Plural form of hidden for languages other than English
$txt['hidden_s'] = '表示しない';
$txt['buddy'] = '仲間';
$txt['buddies'] = '仲間';
$txt['most_online_ever'] = 'これまでの最大オンライン人数';
$txt['most_online_today'] = '本日の最大オンライン人数';

$txt['merge_select_target_board'] = '結合されたスレッドの行き先となる掲示板を選択';
$txt['merge_select_poll'] = '結合されたスレッドの投票箱を選択';
$txt['merge_topic_list'] = '結合されたスレッドを選択';
$txt['merge_select_subject'] = '結合されたスレッドの題名を選択';
$txt['merge_custom_subject'] = '題名';
$txt['merge_include_notifications'] = '更新通知を継ぐ';
$txt['merge_check'] = '結合しますか？';
$txt['merge_no_poll'] = '投票無し';
$txt['merge_why'] = 'Please enter a brief description as to why these topics are being merged.';
$txt['merged_subject'] = '[MERGED] %1$s';
// argument(s): $txt['movetopic_auto_topic']
$txt['mergetopic_default'] = 'This topic has been merged into %2$s.';

$txt['response_prefix'] = 'Re：';
$txt['current_icon'] = '現在のアイコン';
$txt['message_icon'] = 'メッセージアイコン';

$txt['smileys_current'] = '現在のスマイリーセット';
$txt['smileys_none'] = 'スマイリー無し';
$txt['smileys_forum_board_default'] = 'フォーラムもしくは掲示板のデフォルト';

$txt['search_results'] = '検索結果';
$txt['search_no_results'] = 'マッチしませんでした';

$txt['total_time_logged_days'] = ' days, ';
$txt['total_time_logged_hours'] = ' hours and ';
$txt['total_time_logged_minutes'] = ' minutes';
$txt['total_time_logged_d'] = 'd ';
$txt['total_time_logged_h'] = 'h ';
$txt['total_time_logged_m'] = 'm';

$txt['approve_members_waiting'] = 'が承認待ちです。';

$txt['activate_code'] = 'あなたのアクティべーションコードは';

$txt['find_members'] = 'メンバーを検索';
$txt['find_username'] = '名前、ユーザ名、メールアドレス';
$txt['find_buddies'] = '仲間のみを表示';
$txt['find_wildcards'] = 'ワイルドカードを使う：*,';
$txt['find_no_results'] = '見つかりませんでした。';
$txt['find_results'] = '結果';
$txt['find_close'] = '閉じる';

$txt['unread_since_visit'] = '新着の未読の投稿を読む';
$txt['show_unread_replies'] = '更新のあったスレッドを読む';

$txt['change_color'] = '色を変える';

$txt['quickmod_delete_selected'] = '選択を削除';
$txt['quickmod_split_selected'] = 'Split selected';

$txt['show_personal_messages_heading'] = '新しいメッセージ';
$txt['show_personal_messages'] = 'あなたに、他の新しい個人メッセージが届いています。\nすぐに閲覧しますか？（別窓で）';

$txt['help_popup'] = '少し迷っていますか？説明しましょう。';

$txt['previous_next_back'] = '←前へ';
$txt['previous_next_forward'] = '次へ→';

$txt['mark_unread'] = '未読にする';

$txt['ssi_not_direct'] = 'SSI.phpへURLで直接アクセスしないでください。このファイルは、パス（%s）に?ssi_function=somethingという形式で使用します。';
$txt['ssi_session_broken'] = 'SSI.php は、セッションをロードすることができませんでした。This may cause problems with logout and other functions - please make sure SSI.php is included before *anything* else in all your scripts!';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['preview_title'] = '投稿のプレビュー';
$txt['preview_fetch'] = 'プレビューを取得中…';
$txt['preview_new'] = '新しい投稿';
$txt['pm_error_while_submitting'] = 'この個人的なメッセージを送信中に次のエラーまたはエラーが発生しました:';
$txt['error_while_submitting'] = 'このメッセージを投稿するときにエラーが発生しました：';
$txt['error_old_topic'] = 'Warning: this topic has not been posted in for at least %1$d days.<br>Unless you\'re sure you want to reply, please consider starting a new topic.';

$txt['split_selected_posts'] = '選択された投稿';
$txt['split_selected_posts_desc'] = '分割後、下記の投稿から新しいスレッドを形成するでしょう。';
$txt['split_reset_selection'] = '選択を解除';

$txt['modify_cancel'] = 'キャンセル';
$txt['modify_cancel_all'] = 'Cancel All';
$txt['mark_read_short'] = '既読';

$txt['alerts'] = 'アラート';

$txt['pm_short'] = '個人メッセージ';
$txt['pm_menu_read'] = 'メッセージを読む';
$txt['pm_menu_send'] = 'メッセージを送信';

$txt['unapproved_posts'] = '未承認の投稿 (トピック: %1$d, Posts: %2$d)';

$txt['ajax_in_progress'] = '読み込み中...';

$txt['mod_reports_waiting'] = '報告された投稿';

$txt['view_unread_category'] = '未読の投稿';
$txt['new_posts_in_category'] = 'クリックして %1$sの新しい投稿を表示';
$txt['verification'] = '認証';
$txt['visual_verification_hidden'] = 'このボックスを空のままにしてください';
$txt['visual_verification_description'] = '画像に表示される文字を入力してください';
$txt['visual_verification_sound'] = '文字を聞く';
$txt['visual_verification_request_new'] = '別の画像をリクエスト';

// Sub menu labels
$txt['summary'] = 'Summary';
$txt['account'] = 'アカウント設定';
$txt['theme'] = 'ルック＆レイアウト';
$txt['forumprofile'] = 'フォーラムプロフィール';
$txt['activate_changed_email_title'] = 'メールアドレスが変更されました';
$txt['activate_changed_email_desc'] = 'メールアドレスを変更しました。このメールアドレスを認証するには、メールが届きます。 メール内のリンクをクリックしてアカウントを再開します。';
$txt['modSettings_title'] = '機能とオプション';
$txt['package'] = 'パッケージマネージャー';
$txt['errorlog'] = 'Error Log';
$txt['edit_permissions'] = '権限';
$txt['mc_unapproved_attachments'] = '未承認の添付ファイル';
$txt['mc_unapproved_poststopics'] = '未承認の投稿とトピック';
$txt['mc_reported_posts'] = '報告された投稿';
$txt['mc_reported_members'] = '報告されたメンバー';
$txt['modlog_view'] = 'モデレーションログ';
$txt['calendar_menu'] = 'カレンダーを表示';

// @todo Send email strings - should move?
$txt['send_email'] = 'メール送信';

$txt['ignoring_user'] = 'このユーザーを無視しています。';
$txt['show_ignore_user_post'] = 'ポストを見せてください。';

$txt['spider'] = 'Spider';
$txt['spiders'] = 'Spiders';

$txt['downloads'] = 'ダウンロード';
$txt['filesize'] = 'ファイル化';

// Restore topic
$txt['restore_topic'] = 'トピックを復元';
$txt['restore_message'] = '復元';
$txt['quick_mod_restore'] = '選択したものを復元';

// Editor prompt.
$txt['prompt_text_email'] = 'メールアドレスを入力してください。';
$txt['prompt_text_ftp'] = 'FTPアドレスを入力してください。';
$txt['prompt_text_url'] = 'リンクしたいURLを入力してください。';
$txt['prompt_text_img'] = '画像の場所を入力してください';

// Escape any single quotes in here twice.. 'it\'s' -> 'it\\\'s'.
$txt['autosuggest_delete_item'] = 'アイテムを削除';

// Debug related - when $db_show_debug is true.
$txt['debug_templates'] = 'テンプレート: ';
$txt['debug_subtemplates'] = 'サブテンプレート: ';
$txt['debug_language_files'] = '言語ファイル: ';
$txt['debug_stylesheets'] = 'スタイルシート: ';
$txt['debug_files_included'] = '含まれるファイル: ';
$txt['debug_memory_use'] = 'メモリ使用量: ';
$txt['debug_kb'] = 'KB';
$txt['debug_show'] = '表示';
$txt['debug_cache_hits'] = 'キャッシュヒット数: ';
$txt['debug_cache_misses'] = 'Cache misses: ';
$txt['debug_cache_seconds_bytes'] = '%1$ss - %2$s バイト';
$txt['debug_cache_seconds_bytes_total'] = '%1$ss for %2$s bytes';
$txt['debug_queries_used'] = '使用するクエリ: %1$d.';
$txt['debug_queries_used_and_warnings'] = '使用されたクエリ: %1$d、 %2$d の警告。';
$txt['debug_query_in_line'] = '<em>%1$s</em> 行 <em>%2$s</em>で ';
$txt['debug_query_which_took'] = '%1$s 秒かかりました。';
$txt['debug_query_which_took_at'] = '%1$s 秒で %2$s をリクエストしました。';
$txt['debug_show_queries'] = 'format@@0';
$txt['debug_hide_queries'] = 'format@@0';
$txt['debug_tokens'] = 'トークン: ';
$txt['debug_browser'] = 'ブラウザID: ';
$txt['debug_hooks'] = '呼ばれるフック: ';
$txt['debug_instances'] = '作成したインスタンス: ';
$txt['are_sure_mark_read'] = '既読に設定してもよろしいですか？';

// Inline attachments messages.
$txt['attachments_not_enable'] = 'Attachments are disabled';
$txt['attachments_no_data_loaded'] = 'Not a valid attachment ID.';
$txt['attachments_not_allowed_to_see'] = 'You cannot view this attachment.';
$txt['attachments_no_msg_associated'] = 'No message is associated with this attachment.';
$txt['attachments_unapproved'] = 'Attachment is awaiting approval.';

// Accessibility
$txt['hide_category'] = 'カテゴリを隠す';
$txt['show_category'] = 'カテゴリを表示';
$txt['hide_infocenter'] = '情報センターを隠す';
$txt['show_infocenter'] = '情報センターを表示';

// Notification post control
$txt['notify_topic_0'] = 'フォローしていません';
$txt['notify_topic_1'] = 'アラートやメールがありません';
$txt['notify_topic_2'] = 'アラートを受信する';
$txt['notify_topic_3'] = 'メールとアラートを受信する';
$txt['notify_topic_0_desc'] = 'You will not receive any emails or alerts for this topic and it will also not show up in your unread replies and topics list. You will still receive @mentions for this topic.';
$txt['notify_topic_1_desc'] = 'メールやアラートは受信せず、他のメンバーによる@メンションのみ受信します。';
$txt['notify_topic_2_desc'] = 'このトピックのアラートを受信します。';
$txt['notify_topic_3_desc'] = 'このトピックのアラートと電子メールの両方を受け取ります。';
$txt['notify_board_1'] = 'アラートやメールがありません';
$txt['notify_board_2'] = 'アラートを受信する';
$txt['notify_board_3'] = 'メールとアラートを受信する';
$txt['notify_board_1_desc'] = '新しいトピックのメールやアラートは受信されません';
$txt['notify_board_2_desc'] = 'このボードのアラートを受け取ります。';
$txt['notify_board_3_desc'] = 'このボードのアラートと電子メールの両方を受け取ります。';

$txt['notify_board_prompt'] = 'この掲示板の新しいスレッドに投稿した際の更新通知メールを受け取りますか？';
$txt['notify_board_subscribed'] = '%1$s has been subscribed to new topic notifications for this board.';
$txt['notify_board_unsubscribed'] = '%1$s has been unsubscribed from new topic notifications for this board.';

$txt['notify_topic_prompt'] = 'このスレッドが更新された際にメールで通知を受けますか？';
$txt['notify_topic_subscribed'] = '%1$s has been subscribed to new reply notifications for this topic.';
$txt['notify_topic_unsubscribed'] = '%1$s has been unsubscribed from new reply notifications for this topic.';

$txt['notify_announcements_prompt'] = 'Do you want to receive forum newsletters, announcements and important notifications by email?';
$txt['notify_announcements_subscribed'] = '%1$s has been subscribed to forum newsletters, announcements and important notifications.';
$txt['notify_announcements_unsubscribed'] = '%1$s has been unsubscribed from forum newsletters, announcements and important notifications.';

$txt['unsubscribe_announcements_plain'] = 'To unsubscribe from forum newsletters, announcements and important notifications, follow this link: %1$s';
$txt['unsubscribe_announcements_html'] = '<span style="font-size:small"><a href="%1$s">Unsubscribe</a> from forum newsletters, announcements and important notifications.</span>';
$txt['unsubscribe_announcements_manual'] = 'To unsubscribe from forum newsletters, announcements and important notifications, contact us at %1$s with your request.';

// Mobile Actions
$txt['mobile_action'] = 'User actions';
$txt['mobile_moderation'] = 'Moderation';
$txt['mobile_user_menu'] = 'Main Menu';
$txt['mobile_generic_menu'] = '%1$s Menu';

// Formats for lists in a sentence (e.g. "Alice, Bob, and Charlie")
// Examples:
// 	$txt['sentence_list_format'][2] specifies a format for a list with two items
// 	$txt['sentence_list_format']['n'] specifies the default format
// Notes on placeholders:
// 	{1} = first item in the list, {2} = second item, etc.
// 	{-1} = last item in the list, {-2} = second last item, etc.
// 	{series} = concatenated string of the rest of the items in the list
$txt['sentence_list_format'][1] = '{1}';
$txt['sentence_list_format'][2] = '{1} and {-1}';
$txt['sentence_list_format'][3] = '{series}, and {-1}';
$txt['sentence_list_format'][4] = '{series}, and {-1}';
$txt['sentence_list_format'][5] = '{series}, and {-1}';
$txt['sentence_list_format']['n'] = '{series}, and {-1}';
// Separators used to build lists in a sentence
$txt['sentence_list_separator'] = ', ';
$txt['sentence_list_separator_alt'] = '; ';

?>