<?php
// Version: 2.1.5; Help

global $helptxt, $scripturl;

$txt['close_window'] = 'Fechar janela';

$helptxt['manage_boards'] = '
	<strong>Editar quadros</strong><br>
	Nesta página pode criar/ordenar/remover quadros, e as categorias acima deles. Por exemplo, se tem um fórum com vários assuntos que tem informação sobre desporto, carros e música, estas seriam as categorias pincipais que criaria. Dentro de cada uma dessas categorias poderia querer criar quadros para tópicos em cada uma. É uma simples estrutura hierárquica, com este formato: <br>
	<ul class="normallist">
		<li>
			<strong>Desporto</strong>
			&nbsp;- Uma &quot;categoria&quot;
			<ul class="normallist">
				<li>
					<strong>Futebol</strong>
					&nbsp;- Um quadro dentro dessa categoria de &quot;Desporto&quot;
					<ul class="normallist">
						<li>
							<strong>Equipas</strong>
							&nbsp;- Um sub-quadro dentro do quadro de &quot;Futebol&quot;
						</li>
					</ul>
				</li>
				<li><strong>Basquetebol</strong>
				&nbsp;- Um quadro dentro dessa categoria de &quot;Desporto&quot;</li>
			</ul>
		</li>
	</ul>
	As categorais permitem-lhe dividir os quadros em vários tópicos (&quot;Carros,
	Desporto&quot;), e os &quot;quadros&quot; dentro deles permitem aos utilizadores colocar tópicos atuais.
	Um utilizador interessado em automóveis da Ford irá colocar a mensagem em  &quot;Carros->Ford&quot;.
	As funções administrativas para esta página são para criar novos quadros dentro de cada categoria, ordená-los (colocar &quot;Ford&quot; abaixo de &quot;Ferrari&quot;), ou
	para apagar esse quadro completamente.';

$helptxt['edit_news'] = '
	<ul class="normallist">
		<li>
			<strong>Notícias</strong><br>
			Esta página permite-lhe definir o texto dos itens das notícias mostrados no índice de quadros.
			Adicione os itens que quiser (ex. &quot;Não percam a conferência desta terça-feira&quot;). Cada item é mostrado aleatoriamente e deverá ser colocado numa caixa separada.
		</li>
		<li>
			<strong>Boletins informativos</strong><br>
			Esta página permite-lhe enviar boletins informativos aos membros do fórum via mensagem pessoal ou e-mail. Primeiro selecione os grupos que deseja que recebam o boletim informativo, e aqueles que não quer. Se quiser, pode adicionar membros adicionais e endereços de e-mail que irão receber o boletim. Finalmente, coloque a mensagem que quer enviar e selecione se quer que os membros recebam como mensagem pessoal ou como e-mail.
		</li>
		<li>
			<strong>Configurações</strong><br>
				Esta página contém algumas configurações relacionadas com as notícias e boletins informativos, incluindo que grupos podem editar as notícias do fórum ou enviar boletins informativos. Também há uma opção para configurar se quer os feeds de notícias ligados no fórum, assim como um opção para configurar o comprimento (quantos caracteres são mostrados) para cada nova mensagem que apareça no feed.
		</li>
	</ul>';

$helptxt['view_members'] = '
	<ul class="normallist">
		<li>
			<strong>Ver todos os membros</strong><br>
			Veja todos os membros do fórum. É-lhe apresentada uma lista com os nomes dos membros. Pode clicar em qualquer dos nomes e encontrar detalhes dos membros, e como administrador pode modificar esses parâmetros. Tem o controlo completo sobre os membros, incluindo a habilidade de os apagar do fórum.<br><br>
		</li>
		<li>
			<strong>À espera de aprovação</strong><br>
			Esta página só é mostrada se tiver ligado a aprovação de membros por um administrador para todos os novos registos. Quem se registe no seu fórum só se irá tornar um membro completo uma vez que for aprovado por um administrador. Esta página lista todos esses membros que ainda estão à espera de aprovação, juntamente com o seu e-mail e endereço IP. Pode escolher aceitar ou rejeitar (apagar) qualquer membro na lista selecionando a caixa de verificação ao lado do membro e escolhendo a ação da lista em cascata no fundo da página. Quando rejeita um membro, pode escolher apagar o membro com ou sem notificação da sua decisão.<br><br>
		</li>
		<li>
			<strong>À espera de ativação</strong><br>
			Esta página só será visível se tiver ativação por e-mail para novas contas no fórum. Esta página irá listar todos os membros que ainda não ativaram a sua conta. A partir desta página pode escolher aceitar, rejeitar ou relembrar os membros com ativação pendente. Tal como anteriormente, pode escolher enviar um e-mail para o membro a informá-lo da ação que tomou.<br><br>
		</li>
	</ul>';

$helptxt['ban_members'] = '<strong>Banir membros</strong><br>
	O SMF permite a habilidade de banir utilizadores, o que pode ser uma ação útil contra utilizadores que violaram a confiança do fórum. Isto permite-lhe excluir utilizadores que são peças prejudiciais ao seu fórum. Como administrador, quando estiver as mensagens feitas no fórum, pode ver o endereço de IP que o utilizador tinha na altura em que colocou a mensagem.
	Na lista de banimentos, pode simplesmente digitar esse endereço IP, guardar, e o utilizador não consegue mais colocar mensagens com aquele IP. <br>Também pode banir pessoas através dos seus endereços de e-mail.';

$helptxt['featuresettings'] = '<strong>Características e opções</strong><br>
	Existem várias características nesta página que podem ser mudadas consoante a sua preferência.';

$helptxt['modsettings'] = '<strong>Configuração de Modificações</strong><br>
	Esta página contém as configurações adicionadas pelas modificações instaladas no seu fórum.';

$helptxt['time_format'] = '<strong>Formato da hora</strong><br>
	Aqui pode ajustar como a hora e a data são mostradas. Há muitas letras, mas é bastante simples. As convenções seguem a função strftime do PHP e são descritas abaixo (mais detalhes pode ser encontrado em <a href="https://php.net/manual/function.strftime.php" target="_blank" rel="noopener">php.net</a>).<br>
	<br>
	Os seguintes caracteres são reconhecidos da seguinte maneira: <br>
	<span class="smalltext">
	&nbsp;&nbsp;%a - nome abreviado do dia da semana<br>
	&nbsp;&nbsp;%A - nome completo do dia da semana<br>
	&nbsp;&nbsp;%b - nome abreviado do mês<br>
	&nbsp;&nbsp;%B - nome do mês completo<br>
	&nbsp;&nbsp;%d - dia do mês (01 a 31) <br>
	&nbsp;&nbsp;%D<strong>*</strong> - o mesmo que %m/%d/%y <br>
	&nbsp;&nbsp;%e<strong>*</strong> - dia do mês (1 a 31) <br>
	&nbsp;&nbsp;%H - relógio de 24 horas (das 00 às 23) <br>
	&nbsp;&nbsp;%I - relógio de 12 horas (da 01 às 12) <br>
	&nbsp;&nbsp;%m - mês como número (01 a 12) <br>
	&nbsp;&nbsp;%M - minuto como número <br>
	&nbsp;&nbsp;%p - &quot;am&quot; ou &quot;pm&quot; de acordo com a hora do dia<br>
	&nbsp;&nbsp;%R<strong>*</strong> - hora com notação em 24 horas <br>
	&nbsp;&nbsp;%S - segundos como número decimal <br>
	&nbsp;&nbsp;%T<strong>*</strong> - hora atual, igual a %H:%M:%S <br>
	&nbsp;&nbsp;%y - ano com dois dígitos (00 a 99) <br>
	&nbsp;&nbsp;%Y - ano com quatro dígitos<br>
	&nbsp;&nbsp;%% - literalmente o caracter \'%\' <br>
	<br>
	<em>* Não funciona em servidores Windows.</em></span>';

$helptxt['live_news'] = '<strong>Anúncios ao vivo</strong><br>
	Esta caixa mostra os anúncios recentes do <a href="https://www.simplemachines.org/" target="_blank" rel="noopener">www.simplemachines.org</a>.
	Deve verificar isto de vez em quando para ver se existem atualizações, novas versões, e informações importantes do Simple Machines.';

$helptxt['registrations'] = '<strong>Gestão de registos</strong><br>
	Esta página contém todas as funções que podem ser necessárias para gerir novos registos no fórum. Contém até quatro páginas que são visíveis dependendo das configurações do seu fórum. Estas são:<br><br>
	<ul class="normallist">
		<li>
			<strong>Registar novo membro</strong><br>
			A partir desta página pode escolher registar contas para novos membros na vez deles. Isto pode ser útil em fórum onde o registo está fechado a novos membros, ou em casos onde o administrador deseja criar uma conta de teste. Se a configuração para ativação da conta é selecionada, o membro irá receber um e-mail de ativação que deverá seguir antes de poder usar a conta. De forma semelhante, pode selecionar enviar a nova senha do utilizador para o endereço de e-mail definido.<br><br>
		</li>
		<li>
			<strong>Editar o acordo de registo</strong><br>
			Esta página permite-lhe definir o texto para o acordo de registo mostrado quando os membros se registam no seu fórum.
			Pode adicionar ou remover o que quiser do acordo de registo padrão que é incluído no SMF.<br><br>
		</li>
		<li>
			<strong>Definir nomes reservados</strong><br>
			Nesta página pode especificar palavras ou nomes que não podem ser usados pelos seus utilizadores<br><br>
		</li>
		<li>
			<strong>Configurações</strong><br>
			Esta página só será visível se tiver permissões para administrar o fórum. A partir desta página pode decidir o método de registo a ser usado no seu fórum, assim como outras configurações relacionadas com o registo.
		</li>
	</ul>';

$helptxt['modlog'] = '<strong>Registo de moderação</strong><br>
	Esta página permite aos membros da equipa de moderação seguir todas as ações de moderação que os moderadores do fórum fizeram. Note que limpar o registo será registado para prevenir abusos.';
$helptxt['adminlog'] = '<strong>Registo de administração</strong><br>
	Esta página permite aos membros da equipa de administração seguir todas as ações de administração que os administradores do fórum fizeram. Note que limpar o registo será registado para prevenir abusos.';
$helptxt['userlog'] = '<strong>Registo de edições de perfil</strong><br>
	Esta página permite aos membros da equipa de administração ver as mudanças que os utilizadores fizeram aos seus perfis, e está disponível através da área de perfil do utilizador.';
$helptxt['warning_enable'] = '<strong>Sistema de advertências</strong><br>
	Esta característica permite aos membros da equipa administração e moderação dar advertências aos membros - e e usar o nível de advertência dos membros para determinar as ações disponíveis para eles no fórum. Depois de ligar esta característica, permissões irão estar disponíveis na página de permissões para definir que grupos pode dar advertências aos membros. Os níveis de advertência podem ser ajustados a partir do perfil dos membros.';
$helptxt['warning_watch'] = 'Esta opção define a percentagem do nível de advertência que um membro tem de ter para automaticamente ficar em observação. Qualquer membro que esteja em observação irá aparecer na lista de membros observados que irá aparecer numa lista no centro de moderação.';
$helptxt['warning_moderate'] = 'Qualquer membro que passe o valor desta opção irá ter as suas mensagens sob aprovação de um moderador antes de aparecer no fórum. Isto irá sobrepor qualquer permissão local de quadros que possa existir relacionada com a moderação de mensagens.';
$helptxt['warning_mute'] = 'Se este nível de advertência for passado por um membro ,este irá ficar impedido de colocar mensagens. O membro irá perder todos os direitos relacionados com mensagens.';
$helptxt['user_limit'] = 'Esta opção define os limites de pontos que um moderador pode adicionar/remover a um membro em particular no período de 24 horas. Isto pode ser usado para limitar o que um moderador pode fazer num pequeno período de tempo. Isto pode ser desligado definindo o valor como zero. Note que qualquer membro com permissões de administrador não é afetado por este valor.';

$helptxt['error_log'] = '<strong>Registo de erros</strong><br>
	O registo de erros rastreia todos os erros sérios encontrados por utilizadores do seu fórum. Lista todos esses erros por data, que podem ser organizados clicando na seta branca ao lado de cada data. Adicionalmente pode filtrar os erros clicando na imagem ao lado de cada erro. Isto permite-lhe filtrar, por exemplo, por membro. Quando um filtro está ativo apenas os resultados desse filtro serão mostrados.';
$helptxt['theme_settings'] = '<strong>Configurações de tema</strong><br>
	A página de configurações permite-lhe mudar as configurações específicas de um tema. Estas configurações incluem opções como o diretório e URL dos temas mas também opções que afetam o esquema do tema no fórum. A maioria dos tema têm uma variedade de opções configuráveis pelos utilizadores, que permitem adaptar um tema às suas necessidades individuais.';
$helptxt['smileys'] = '<strong>Centro de smilies</strong><br>
	Aqui pode adicionar e remover smilies, e conjuntos de smilies. Se um smiley está presente num conjunto, deverá estar presente em todos os conjuntos - caso contrário poderá ser confuso para os seus utilizadores usar conjuntos diferentes.<br><br>

	Também pode editar os ícones de mensagens a partir daqui, se os tiver ligados na página de definições.';
$helptxt['calendar'] = '<strong>Gerir calendário</strong><br>
	Aqui pode modificar as configurações atuais do calendário assim como adicionar e remover feriados que aparecem no calendário.';
$helptxt['cal_export'] = 'Exporta um ficheiro de texto no formato iCal para ser importado para outras aplicações de calendário';
$helptxt['cal_highlight_events'] = 'Esta opção permite-lhe destacar eventos nos mini calendários, calendário principal, em ambos, ou desativar o destaque de eventos.';
$helptxt['cal_highlight_holidays'] = 'Esta opção permite-lhe destacar feriados nos mini calendários, calendário principal, em ambos, ou desativar o destaque de feriados.';
$helptxt['cal_highlight_birthdays'] = 'Esta opção permite-lhe destacar aniversários nos mini calendários, calendário principal, em ambos, ou desativar o destaque de aniversários.';
$helptxt['cal_disable_prev_next'] = 'Se esta opção estiver ligada, os blocos de três meses do lado esquerdo da página serão desligados.';
$helptxt['cal_display_type'] = 'Esta opção permite-lhe mudar o aspeto do tipo de calendário.<br><br><strong>Confortável:</strong> torna as colunas do calendário grandes.<br><strong>Compacto:</strong> torna as colunas do calendário pequenas.';
$helptxt['cal_week_links'] = 'Se esta opção estiver ligada, as ligações serão adicionadas juntamente com cada semana no calendário.';
$helptxt['cal_prev_next_links'] = 'Se esta opção estiver ligada, as ligações para o mês anterior/seguinte serão adicionadas no topo de cada mês para uma fácil navegação.';
// argument(s): $txt['months_short'][1], $txt['months_titles'][1]
$helptxt['cal_short_months'] = 'Se esta opção estiver ligada, os nomes dos meses no calendário serão encurtados.<br><br><strong>Ligado:</strong> %1$s 1<br><strong>Desligado:</strong> %2$s 1';
// argument(s): $txt['days_short'][1], $txt['days'][1]
$helptxt['cal_short_days'] = 'Se esta opção estiver ligada, os nomes dos dias no calendário serão encurtados.<br><br><strong>Ligado:</strong> %1$s<br><strong>Desligado:</strong> %2$s';

$helptxt['serversettings'] = '<strong>Configurações do servidor</strong><br>
	Aqui você pode realizar algumas configurações básicas no seu fórum. Esta página inclui as configurações da base de dados e URL, bem como outros itens de configuração importantes, como configurações de e-mail e armazenamento em cache. Pense com cuidado sempre que editar essas configurações, pois um erro pode tornar o fórum inacessível';
$helptxt['manage_files'] = '
	<ul class="normallist">
		<li>
			<strong>Ver ficheiros</strong><br>
			Veja todos os anexos, avatares e miniaturas armazenados pelo SMF.<br><br>
		</li><li>
			<strong>Configurações de anexos</strong><br>
			Configure onde os anexos são armazenados e defina restrições no tipo de anexos.<br><br>
		</li><li>
			<strong>Configurações de avatares</strong><br>
			Configure onde os avatares são armazenados e faça a gestão do redimensionamento dos avatares.<br><br>
		</li><li>
			<strong>Manutenção de ficheiros</strong><br>
			Verifique e repare qualquer erro no diretório de anexos e apagar os anexos selecionados.<br><br>
		</li>
	</ul>';

$helptxt['topicSummaryPosts'] = 'Isto permite-lhe definir o número de mensagens mostradas no resumo do tópico na página de resposta.';
$helptxt['enableAllMessages'] = 'Definir isto para o número <em>máximo</em> de mensagens que um tópico pode ter para mostrar a ligação <em>tudo</em>. Definir isto para um valor mais baixo que o número de mensagens a mostrar na página do tópico irá simplesmente significar que nunca é mostrado, e definir um valor demasiado alto poderá abrandar o seu fórum.';
$helptxt['allow_guestAccess'] = 'Desativar esta opção irá impedir visitantes de fazer tudo exceto ações básicas no seu fórum - login, registo, lembrar senha, etc. Isto não é o mesmo que impedir visitantes de aceder aos quadros.';
$helptxt['userLanguage'] = 'Ligar esta opção irá permitir aos utilizadores selecionar que ficheiros de idioma podem usar. Não irá afetar a seleção padrão.';
$helptxt['trackStats'] = 'Estatísticas:<br> Isto irá permitir aos utilizadores verem as últimas mensagens e os tópicos mais populares do seu fórum. Também irá mostrar várias estatísticas, como os membros que passam mais tempo no fórum, novos membros e novos tópicos.<hr>
		Visualizações de páginas:<br>Adiciona outra coluna à página de estatísticas com o número de visualizações de páginas do seu fórum.';
$helptxt['titlesEnable'] = 'Ligar os títulos personalizados irá permitir que os membros com permissões criem um título especial para si próprios.
		Isto irá ser mostrado por baixo do nome.<br><em>Por exemplo:</em><br>António<br>Tipo fixe';
$helptxt['onlineEnable'] = 'Isto irá mostrar uma imagem que indica se o membro está ou não online';
$helptxt['todayMod'] = 'Isto irá mostrar &quot;Hoje&quot; ou &quot;Ontem&quot; em vez da data.<br><br>
		<strong>Exemplos:</strong><br><br>
		<ul class="normallist">
			<li>
			<strong>Desligado</strong><br>
			3 de Outubro de 2009 às 12:59:18</li>
			<li><strong>Apenas hoje</strong><br>
			Hoje às 12:59:18</li>
			<li><strong>Hoje &amp; Ontem</strong><br>
			Ontem às 12:59:18</li>
		</ul>';
$helptxt['disableCustomPerPage'] = 'Ligue esta opção para impedir que os utilizadores personalizem a quantidade de mensagens e tópicos a mostrar por página no índice de mensagens e tópicos respetivamente.';
$helptxt['enablePreviousNext'] = 'Isto irá mostrar uma ligação para o tópico anterior/seguinte.';
$helptxt['pollMode'] = 'Isto permite definir se as sondagens estão ativadas ou não. Se as sondagens estiverem desativadas, todas as sondagens existentes serão escondidas da lista de tópicos. Pode escolher continuar a mostrar os tópicos com sondagens selecionando a opção &quot;mostrar sondagens como tópicos&quot;.<br /><br />Para escolher quem pode iniciar novas sondagens, ver as sondagens, etc, basta editar as permissões necessárias. Lembre-se disto se as sondagens não estiverem a funcionar por alguma razão.';
$helptxt['enableCompressedOutput'] = 'Esta opção irá comprimir os dados de modo a poupar largura de banda, mas requer que o zlib esteja instalado.';
$helptxt['httponlyCookies'] = 'Os cookies não serão acessíveis por linguagens escritas, como JavaScript. Esta definição pode ajudar a reduzir o roubo de identidades através de ataques XSS. Isto pode causar problemas com outros scripts, mas deverá estar ativado sempre que possível.';
$helptxt['samesiteCookies'] = 'O SameSite atibui à resposta HTTP que define o cookie se o seu cookie deve ser restrito ou num contexto de mesmo local. Para mais informação, veja o <a href="https://developer.mozilla.org/docs/Web/HTTP/Headers/Set-Cookie/SameSite">MDN</a>';
$helptxt['databaseSession_enable'] = 'Esta opção usa a base de dados para o armazenamento das sessões - ajuda nos problemas de expiração da sessão e pode tornar o fórum mais rápido.';
$helptxt['databaseSession_loose'] = 'Ao ativar esta opção irá diminuir a largura de banda utilizada pelo fórum, e fazer com que ao retroceder a página não seja recarregada - a desvantagem é que os ícones (novo) não serão atualizados, entre outras coisas. (a não ser que clique no link para a página em vez de retroceder).';
$helptxt['databaseSession_lifetime'] = 'Isto é o número de segundos para a duração das sessões. Se uma sessão não for acedida durante demasiado tempo, diz-se que &quot;expirou&quot;. Recomenda-se qualquer coisa acima de 2400.';
$helptxt['tfa_mode'] = 'Pode adicionar um segundo nível de segurança ao seu fórum ligando a <a href="https://en.wikipedia.org/wiki/Two_factor_authentication">autenticação por dois fatores</a>. A autenticação por dois fatores força os seus utilizadores a adicionar um código gerado depois do login regular. Precisa de configurar a autenticação por dois fatores antes de poder forçar os outros utilizadores!';
$helptxt['cache_enable'] = 'O SMF executa a cache em vários níveis. Quanto maior o nível de cache, mais tempo de CPU será gasto na recuperação de informações em cache. Se a cache estiver disponível na sua máquina, é recomendável que tente a cache no nível 1 primeiro.';
$helptxt['cache_memcached'] = 'Se estiver a usar memcached precisa de providenciar os detalhes do servidor. Isto deverá ser introduzido numa lista separada por vírgulas como mostrado no exemplo abaixo:<br><br>	&quot;servidor1,servidor2,servidor3:porta,servidor4&quot;<br><br>Note que se nenhuma porta for especificada o SMF vai usar a porta 11211 a não ser que o servidor contenha uma barra, nesse caso é assumido que é um transporte alternativo e a porta será definida para 0.';
$helptxt['cache_cachedir'] = 'Esta definição é apenas para os ficheiros do sistema de cache smf. Especifica o caminho para o diretório da cache. É recomendado que coloque isto em /tmp/ se for usar isto, apesar de trabalhar em qualquer diretório.';
$helptxt['cache_sqlite_cachedir'] = 'Esta definição é apenas para o sistema de cache de base de dados SQLite. Especifica o caminho para o diretório da cache. É recomendado que coloque isto em /tmp/ se for usar isto, apesar de trabalhar em qualquer diretório';
$helptxt['enableErrorLogging'] = 'Isto irá registar todos os erros, tais como logins falhados, de modo a saber o que correu mal.';
$helptxt['enableErrorQueryLogging'] = 'Isto irá incluir a totalidade da query enviada à base de dados no registo de erros. É necessário ter o registo de erros ativado.<br /><br /><strong>Nota: Isto irá afetar a possibilidade de filtrar o registo de erros por mensagem de erro.</strong>';
$helptxt['disallow_sendBody'] = 'Esta opção remove a possibilidade de receber o texto completo das mensagens e tópicos nos e-mails de notificação.<br /><br />Muitas vezes, os membros respondem à notificação via e-mail, o que, na maioria dos casos vai parar à caixa de correio do webmaster.';
$helptxt['enable_ajax_alerts'] = 'Esta opção permite que os seus membros recebam notificação AJAX. Isto significa que o membro não precisa de atualizar a página para receber novas atualizações.<br><strong>NOTA:</strong> Esta opção pode causar uma sobrecarga no seu servidor quando estiverem muitos utilizadores online.';
$helptxt['alerts_auto_purge'] = 'Assim que um alerta for lido, raramente é preciso outra vez. Por razões de desempenho, é uma boa ideia apagar automaticamente após algum tempo.';
$helptxt['jquery_source'] = 'Isto irá determinar que recursos serão usados para carregar a biblioteca jQuery. <em>Google CDN, jQuery CDN</em> e <em>Microsoft CDN</em> irão carregar a biblioteca jQuery das respetivas redes CDN. <em>Local</em> irá apenas usar recursos locais. <em>Personalizado</em> permite-lhe especificar uma URL para a biblioteca.';
$helptxt['compactTopicPagesEnable'] = 'Isto simplesmente mostra o número de páginas.<br /><em>Exemplo:</em>
		&quot;3&quot; para mostrar: 1 ... 4 [5] 6 ... 9 <br />
		&quot;5&quot; para mostrar: 1 ... 3 4 [5] 6 7 ... 9';
$helptxt['timeLoadPageEnable'] = 'Isto irá mostrar o tempo (em segundos) que o SMF demorou a criar a página no rodapé do fórum.';
$helptxt['removeNestedQuotes'] = 'Isto irá remover as citações agrupadas inseridas numa mensagem, quando estiver a citar a mensagem em questão através de uma ligação de citação.';
$helptxt['max_image_width'] = 'Isto permite definir um tamanho máximo para as imagens enviadas. As imagens mais pequenas do que o tamanho máximo não serão afetadas. Isto também determina como as miniaturas de imagens anexadas são mostradas quando clica numa miniatura.';
$helptxt['mail_type'] = 'Isto permite escolher entre o programa de e-mail padrão do PHP ou substituir estas configurações com SMTP. O PHP não suporta o uso de autenticação com SMTP (que muitos servidores obrigam), se quiser isso deve selecionar SMTP. Por favor, note que o SMTP pode ser lento, e alguns servidores não aceitam nomes de utilizador e senhas.<br><br>Não precisa de preencher as definições SMTP se estiver definido para o padrão PHP.';
$helptxt['attachment_manager_settings'] = 'Anexos são ficheiros que os membros podem enviar e anexar a uma mensagem. Diferentes sites podem usar isto de diferentes maneiras, que pode configurar aqui.';
$helptxt['attachmentCheckExtensions'] = 'Para algumas comunidades, pode querer limitar os tipos de ficheiros que os utilizadores podem enviar ao verificar a extensão. Por exemplo, minhafoto.jpg tem a extensão jpg.';
// References setting attachmentCheckExtensions
$helptxt['attachmentExtensions'] = 'Se "verificar a extensão dos anexos" estiver ligada, estas são as extensões que serão permitidas para novos anexos.';
$helptxt['attachmentUploadDir'] = 'O caminho para a pasta de anexos no servidor<br>(Exemplo: /home/sites/meusite/www/forum/anexos)';
$helptxt['attachmentDirSizeLimit'] = 'Selecione o tamanho que pasta de anexos pode ter.';
$helptxt['attachmentPostLimit'] = 'Selecione o tamanho máximo dos ficheiros (em KB) de todos os ficheiros por mensagem. Se for mais baixo que o limite por anexo, este será o limite..';
$helptxt['attachmentSizeLimit'] = 'Selecione o tamanho máximo do ficheiro para cada anexo separadamente.';
$helptxt['attachmentNumPerPostLimit'] = 'Selecione o número de anexos que um utilizador por enviar por mensagem.';
$helptxt['attachmentShowImages'] = 'Se o ficheiro enviado for uma imagem, será mostrado por baixo da mensagem.';
$helptxt['attachmentThumbnails'] = 'Se a opção abaixo estiver selecionada, isto irá guarda um anexo (mais pequeno) separadamente para a miniatura de forma a poupar largura de banda.';
$helptxt['attachmentThumbWidth'] = 'Apenas usado com a opção &quot;Redimensionar imagens quando mostradas abaixo da mensagem&quot;. Isto é a largura máxima para redimensionar anexos. Serão redimensionados proporcionalmente.';
$helptxt['attachmentThumbHeight'] = 'Apenas usado com a opção &quot;Redimensionar imagens quando mostradas abaixo da mensagem&quot;. Isto é a altura máxima para redimensionar anexos. Serão redimensionados proporcionalmente.';
$helptxt['attachmentDirFileLimit'] = 'Número máximo de ficheiros por diretório';
$helptxt['attachmentEnable'] = 'Esta opção permite-lhe configurar como os anexos são feitos.<br><br>
	<ul class="normallist">
		<li>
			<strong>Desativar anexos</strong><br>
			Todos os anexos são desativados. Os anexos existentes não são apagados, mas ficaram escondidos (nem mesmo os administradores os vêm). Novos anexos não podem ser feitos, independentemente das permissões.<br><br>
		</li>
		<li>
			<strong>Permitir todos os anexos</strong><br>
			Tudo se comporta normalmente, com os utilizadores com permissão para ver anexos a conseguirem fazê-lo, e utilizadores com permissão para enviar anexos a conseguirem fazê-lo.<br><br>
		</li>
		<li>
			<strong>Desativar novos anexos</strong><br>
			Os anexos existentes ainda são acessíveis, mas nenhum novo anexo pode ser adicionado, independentemente das permissões.
		</li>
	</ul>';
$helptxt['attachment_image_paranoid'] = 'Selecionar esta opção irá ligar uma verificação de anexos de imagem muito rígida. <strong>Atenção!</strong> Esta verificação extensiva pode falhar com imagens válidas. É fortemente recomendado usar esta opção juntamente com a recodificação de imagens, de forma a ter o SMF a tentar redimensionar as imagens que falhem a verificação de segurança. Se tiver sucesso será enviada. Caso contrário, se a recodificação não estiver ligada, todos os anexos que falhem a verificação serão rejeitados.';
$helptxt['attachment_image_reencode'] = 'Ao selecionar esta opção irá permitir que o SMF tente recodificar os anexos de imagem enviados. A recodificação oferece melhor segurança. Note, contudo, que a recodificação torna as imagens animadas em imagens estáticas.<br>Esta opção só é possível se o módulo GD estiver instalado no seu servidor.';
$helptxt['attachment_thumb_memory'] = 'Quanto maior a imagem (altura e largura), mais memória é necessária para o sistema criar uma miniatura com sucesso.<br>Ligar esta opção o sistema irá estimar a memória necessária e então irá pedir essa quantidade. Se tiver sucesso, apenas aí irá criar a miniatura.<br>Isto vai resultar em algumas páginas em branco, mas poderá dar origem a menos miniaturas criadas (com uma quantidade de memória fixa). Isto pode resultar em mais erros de páginas em branco.';
$helptxt['attachmentRecodeLineEndings'] = 'O script irá recodificar os finais de linha de acordo com seu servidor.';
$helptxt['automanage_attachments'] = 'Por defeito, o SMF coloca os novos anexos numa única pasta. Para a maioria dos sites isso não é um problema, mas à medida que um site cresce, pode ser útil ter várias pastas para armazenar anexos.<br><br>Esta configuração permite que defina se quer gerir essas pastas (por exemplo, criando uma segunda pasta e passar para ela quando quiser) ou se permite que o SMF faça isso, com base em critérios, como quando o diretório atual atinge um determinado tamanho, ou dividir pastas por anos ou até meses em sites com muito fluxo.';
$helptxt['dont_show_attach_under_post'] = 'Se ativado, os anexos incorporados nas mensagens não aparecerão abaixo da mensagem, mas ainda poderão ser excluídos.';
$helptxt['use_subdirectories_for_attachments'] = 'Cria novos diretórios.';
$helptxt['max_image_height'] = 'Assim como a largura máxima, essa configuração indica a altura máxima que uma imagem colocada numa mensagem pode ter.';
$helptxt['avatar_paranoid'] = 'Selecionar esta configuração permitirá verificações de segurança muito rigorosas em avatares. <strong>Atenção!</strong> Essas verificações extensas também podem falhar com imagens válidas. É altamente recomendável usar essa configuração apenas junto com a recodificação do avatar, para que o SMF tente codificar as imagens que falham nas verificações de segurança: se forem bem-sucedidas, elas serão higienizadas e carregadas. Caso contrário, se a recodificação de avatares não estiver habilitada, todos os avatares que falharem nas verificações serão rejeitados.';
$helptxt['avatar_reencode'] = 'Selecionar esta configuração permitirá tentar recodificar os avatares enviados. A recodificação de imagem oferece melhor segurança. Observe, no entanto, que a recodificação de imagem também renderiza todas as imagens animadas estáticas. <br> Este recurso só é possível se o módulo GD estiver instalado no seu servidor.';
$helptxt['cal_enabled'] = 'O calendário pode ser usado para mostrar aniversários ou eventos importantes que acontecem na sua comunidade. Esta configuração habilita o calendário e todos os seus recursos.';
$helptxt['cal_link_postevent'] = 'Isso permitirá que os membros publiquem eventos para esse dia, quando clicarem nessa data';
$helptxt['cal_maxdays_advance'] = 'Se for definido como 7, os eventos da próxima semana serão mostrados';
$helptxt['cal_allow_unlinkedevents'] = 'Permitir que os membros publiquem eventos sem exigir que eles sejam vinculados a uma mensagem num quadro';
$helptxt['cal_min_year'] = 'Seleciona o &quot;primeiro&quot; ano na lista do calendário';
$helptxt['cal_max_year'] = 'Seleciona o &quot;último&quot; ano na lista do calendário';
$helptxt['cal_maxevent_span'] = 'Seleciona o número máximo de dia que um evento pode durar';
$helptxt['localCookies'] = 'O SMF usa cookies para armazenar informações da conexão no computador cliente.
	Os cookies podem ser armazenados globalmente (meuservidor.com) ou localmente (meuservidor.com/caminho/do/forum).<br><br>
	Experimente esta configuração se estiver a ter problemas com utilizadores a serem desconectados automaticamente.<hr>
	Os cookies armazenados globalmente são menos seguros quando usados ​​em um servidor compartilhado (como o Tripod).<hr>
	Os cookies locais não funcionam fora do diretório do fórum, portanto, se seu fórum estiver armazenado em www.meuservidor.com/forum, páginas como www.meuservidor.com/index.php não poderão aceder às informações da conta.<br><br>
	Cookies globais são especialmente recomendados ao usar SSI.php, mas funcionam bem para a maioria dos sites no seu próprio domínio.';
$helptxt['enableBBC'] = 'Selecionar esta configuração permitirá que os seus membros usem o Bulletin Board Code (BBC) em todo o fórum, permitindo que os utilizadores formatem as suas mensagens com imagens, tipo de formatação e muito mais.';
$helptxt['legacy_bbc'] = 'BBC legacy são BBC obsoletos e não podem ser usados ​​em novas mensagens. No entanto, eles serão analisados ​​em mensagens existentes, se ativados aqui.<br><br>Permitir isto apenas terá utilidade se o seu fórum tiver sido atualizado a partir de uma versão anterior do SMF.<br><br>Além disso, mesmo quando ativados, alguns BBC legacy não serão renderizados da mesma maneira que antes. Por exemplo, o [flash] simplesmente mostrará uma ligação para o conteúdo Flash em vez de incorporá-lo.';
$helptxt['default_timezone'] = 'Este é o fuso horário padrão usado para a exibição dos horários em todo o fórum.';
$helptxt['timezone_priority_countries'] = 'Esta configuração permite que você empurre os fusos horários de um determinado país ou países para o topo da lista de fusos horários selecionáveis ​​que é mostrada quando os utilizadores estão a configurar os seus perfis, a criar eventos de calendário, etc.<br><br>Por exemplo, se muitos dos membros do seu fórum moram na Nova Zelândia ou nas Ilhas Fiji, pode inserir "NZ,FJ" para facilitar a localização rápida dos fusos horários mais relevantes.<br><br>Você pode encontrar a lista completa de códigos ISO de país pesquisando na Internet por "<a href="https://www.google.com/search?q=iso+3166-1+alpha-2" target="_blank" rel="noopener">ISO 3166-1 alpha-2</a>".';
$helptxt['spamWaitTime'] = 'Aqui você pode selecionar a quantidade de tempo que deve passar entre cada mensagem enviada. Isto pode ser usado para impedir as pessoas de "enviar spam" no seu fórum, limitando a frequência com que elas podem colocar mensagens.';

$helptxt['enablePostHTML'] = 'Isto permitirá a utilização de algumas tags HTML básicas em mensagens:
	<ul class="normallist">
		<li>&lt;b&gt;, &lt;u&gt;, &lt;i&gt;, &lt;s&gt;, &lt;em&gt;, &lt;strong&gt;, &lt;ins&gt;, &lt;del&gt;</li>
		<li>&lt;a href=&quot;&quot;&gt;</li>
		<li>&lt;img src=&quot;&quot; alt=&quot;&quot; /&gt;</li>
		<li>&lt;br&gt;, &lt;hr&gt;</li>
		<li>&lt;pre&gt;, &lt;blockquote&gt;</li>
	</ul>';

$helptxt['themes_manage'] = 'Aqui pode instalar novos temas e selecionar quais temas os seus utilizadores podem escolher, o tema padrão que novos utilizadores e visitantes usarão, bem como outras configurações de seleção de temas.';
$helptxt['theme_install'] = 'Isto permite-lhe instalar novos temas. Pode fazer isto a partir de um diretório existente, enviando um ficheiro do tema, ou copiando o tema padrão.<br><br>Note que o ficheiro ou diretório tem de ter um ficheiro de definição <pre>theme_info.xml</pre>.';
$helptxt['xmlnews_enable'] = 'Permite às pessoas ligar a <a href="%1$s?action=.xml;sa=news" target="_blank" rel="noopener">notícias recentes</a> e dados semelhantes. Também é recomendado que limite o tamanho das mensagens/notícias recentes porque alguns clientes esperam que os dados RSS venham cortados para visualização.';
$helptxt['xmlnews_attachments'] = 'Permite que as ligações para os anexos sejam mostradas nos seus feeds XML/RSS. Ligue isto se quiser usar seu fórum como uma plataforma de distribuição de conteúdos como um podcast ou similar.
	<br><br>
	A permissão "Ver anexos" tem efeitos nesta configuração. Membros e visitantes só verão os anexos de uma mensagem no fedd se também puderem ver os anexos na mensagem original. Tenha em mente de que a maioria dos leitores de feed acedem ao seu fórum como visitantes.
	<br><br>
	Alguns formatos de feed só permitem um anexo por mensagem. Se a mensagem tem vários anexos, o SMF irá mostrar o maior nesses feeds';
$helptxt['globalCookies'] = 'Faz registos em cookies disponíveis pelos subdomínios. Por exemplo, se......<br>
	o seu site é https://www.examplo.com/,<br>
	e o seu fórum é https://forum.examplo.com/,<br>
	usar esta configuração irá permitir-lhe aceder aos cookies do fórum no seu site. Não ligue isto se houver outros subdomínios que não sejam controlados por si.<br><br>
	Es configuração não funciona quando os cookies locais estão ligados.';
$helptxt['globalCookiesDomain'] = 'Quando usa cookies independentes do subdomínio (cookies globais), pode especificar que domínio deve ser usado. Isto deve, obviamente, ser definido para o seu domínio principal - por exemplo, se estiver a usar <em>forum.exemplo.com</em> e <em>www.exemplo.com</em>, o domínio é <em>exemplo.com</em> neste caso. Não deve colocar <em>http://</em> nem <em>https://</em> antes do domínio.';
$helptxt['secureCookies'] = 'Ligar esta configuração irá forçar os cookies criados pelos seus utilizadores no seu fórum a serem marcados como seguros. Apenas ligue esta configuração se estiver a usar HTTPS pelo seu site, caso contrário isso irá significar que ninguém será capaz de fazer o login corretamente!';
$helptxt['securityDisable'] = 'Quando ligado, isto <em>desliga</em> a introdução de senha adicional da página de administração. Isto não é recomendado!';
$helptxt['securityDisable_why'] = 'Introduza a sua senha atual (a mesma que usa para fazer o login).<br><br>A obrigatoriedade de fazer isto ajuda a certificar de que quer realmente fazer a tarefa de administração que está a fazer, e que é mesmo <strong>você</strong> que a está a realizar.';
$helptxt['securityDisable_moderate'] = 'Quando ligado, isto <em>desliga</em> a introdução de senha adicional da página de moderação. Esta configuração está ligada por defeito.';
$helptxt['securityDisable_moderate_why'] = 'Introduza a sua senha atual (a mesma que usa para fazer o login).<br><br>A obrigatoriedade de fazer isto ajuda a certificar de que quer realmente fazer a tarefa de moderação que está a fazer, e que é mesmo <strong>você</strong> que a está a realizar.';
$helptxt['allow_cors'] = 'Cross Origin Resource Sharing ou CORS é uma política para navegadores modernos para recursos confiáveis que estão a ser requisitados entre diferentes domínios. Se estiver ligado, isto irá tentar resolver a política CORS para os scripts acederem aos recursos do fórum a partir de diferentes domínios. Se cookies independentes do subdomínio (cookies globais) estiverem ligadas, são feitas tentativas para determinar o domínio apropriado. Fornecer os domínios adicionais do CORS numa lista separada por vírgulas permite domínios adicionais. O formato deve ser  {SCHEMA}://{DOMAIN}.  Se uma extensão (*) for fornecida como único domínio adicional, todos os domínios são permitidos e isto pode apresentar um risco de segurança para o seu fórum e não deve ser usado exceto em casos extremos. Cabeçalhos adicionais podem ser fornecidos numa lista separada por vírgulas e serão permitidos durante pedidos que contenham esses cabeçalhos e extensões (*) sejam permitidas  .';
$helptxt['frame_security'] = 'Os navegadores modernos percebem o cabeçalho de segurança apresentado pelos servidores chamado X-Frame-Options. Ao definir esta opção especifica como quer permitir  que o seu site seja enquadrado, em frameset ou iframe. Desligar não irá enviar nenhum cabeçalho e é mais inseguro, contudo permite maior liberdade. Negar irá impedir todos os enquadramentos por completo e é o mais restritivo e seguro. Permitir a mesma origem irá apenas permitir que o seu domínio faça enquadramentos e é um maior termo relativamente às duas opções anteriores.';
$helptxt['proxy_ip_header'] = 'Este é o cabeçalho do servidor que será confiado pelo SMF para conter o endereço IP dos utilizadores reais. Alterar esta configuração pode causar resultados de IP inesperados nos membros. Verifique com o administrador do servidor, provedor de CDN ou administrador de proxy antes de alterar estas configurações. A maioria dos provedores entenderá e usará o HTTP_X_FORWARDED_FOR. Deve preencher a lista de servidores que enviam os cabeçalhos de proxy reverso por segurança para garantir que esses cabeçalhos venham apenas de fontes válidas.';
$helptxt['email_members'] = 'Nesta mensagem pode usar algumas &quot;variáveis&quot;. São as seguintes:<br>
	{$board_url} - A URL do seu fórum.<br>
	{$current_time} - A hora atual.<br>
	{$member.email} - O e-mail atual do membro.<br>
	{$member.link} - A ligação atual do membro.<br>
	{$member.id} - O ID atual do membro.<br>
	{$member.name} - O nome atual do membro. (para personalização).<br>
	{$latest_member.link} - A ligação para o membro registado mais recentemente.<br>
	{$latest_member.id} - O ID do membro registado mais recentemente.<br>
	{$latest_member.name} - O nome do membro registado mais recentemente.';

$helptxt['failed_login_threshold'] = 'Defina o número de tentativas falhadas de login antes de direcionar o utilizador para a página de recuperação de senha.';
$helptxt['loginHistoryDays'] = 'O número de dias para manter o histórico de login no rastreio do utilizador. O valor padrão são 30 dias.';
$helptxt['oldTopicDays'] = 'Se estiver ligado, um aviso irá ser mostrada ao utilizador quando tentar responder a um tópico que não teve nenhuma resposta pelo número de tempo, em dias, especificado por esta definição. Definir isto para 0 irá desligar a característica.';
$helptxt['edit_wait_time'] = 'O número de segundos em que é permitido editar uma mensagem antes que apareça na mensagem a informação da última edição.';
$helptxt['edit_disable_time'] = 'O número permitido de minutos antes que um utilizador não possa mais editar uma mensagem que tenha feito. Defina como 0 para desligar.<br><br><em>Nota: Isto não irá afetar nenhum utilizador que tenha permissão para editar as mensagens de outros utilizadores.</em>.';
$helptxt['preview_characters'] = 'Esta configuração define o número de caracteres disponíveis para a pré-visualização da primeira e última mensagem de um tópico.';
$helptxt['quote_expand'] = 'Esta configuração permite que grandes citações possam ser colapsadas, dando ao utilizador a opção de as expandir para o seu tamanho original. Citações menores do que definido aqui não serão afetadasd.';
$helptxt['posts_require_captcha'] = 'Esta configuração irá forçar os utilizadores a passarem a verificação anti-spam cada vez que façam uma mensagem num quadro. Apenas utilizadores com a contagem de mensagens abaixo do número definido irão precisar de introduzir o código - isto ajuda a combater scripts de spam automatizados.';
$helptxt['disable_wysiwyg'] = 'Esta configuração tira a opção a todos os utilizadores de usar o editor WYSIWYG (&quot;What You See Is What You Get&quot;) na página de mensagem.';
$helptxt['lastActive'] = 'Define o número de minutos para mostrar as pessoas ativas em X minutos no índice de quadros. O valor padrão são 15 minutos.';

$helptxt['customoptions'] = 'Isto define as opções que um utilizador pode escolher de uma lista em cascata. Há alguns pontos chave a ter atenção nesta página:
	<ul class="normallist">
		<li><strong>Configuração padrão:</strong> Qualquer que seja a caixa de verificação que tem o &quot;botão radial&quot; será a seleção padrãi para o utilizador quando entrar no seu perfil.</li>
		<li><strong>Remover opções:</strong> Para remover uma opção, simplesmente limpe a caixa de texto para essa opção - todos os utilizadores com isso selecionado irão ter a sua opção removida.</li>
		<li><strong>Reordenar opções:</strong> Pode reordenar as opções movendo o texto entre as caixas. Contudo - uma nota importante - certifique-se de que <strong>não</strong> muda o texto quando reorganiza as opções ou os dados do utilizador serão perdido.</li>
	</ul>';

$helptxt['autoFixDatabase'] = 'Isto irá corrigir automaticamente as tabelas e continuar como se nada tivesse acontecido. Recebe um e-mail quando isto acontece.<br>Se escolher desligar esta opção, o seu fórum irá ficar em baixo até que repare e corriga o problema.';
// argument(s): scripturl
$helptxt['pgFulltextSearch'] = 'Esta configuração define o idioma a usar para a pesquisa fulltext do PostgreSQL. Escolha o idioma que mais se aproxima do idioma que o seu fórum usa atualmente. Se o idioma usado atualmente pelo seu fórum não está listado, ou o seu fórum é multi-idiomas, escolha a opção simples.<br>
Esta configuração é independente das configurações principais de idiomas do SMF e não relacionada com o idioma instalado para o SMF.<br>Quando muda esta configuração precisa de <a href="%1$s?action=admin;area=managesearch;sa=method" target="_blank" rel="noopener">refazer o índice de pesquisa fulltext</a>.<br>
Se um idioma que necessita não está listado, peça ao seu administrador da base de dados para instalar o suporte ao idioma do PostgreSQL.';

$helptxt['enableParticipation'] = 'Isto mostra um pequeno ícone nos tópicos onde o utilizador colocou mensagens.';

$helptxt['db_persist'] = 'Isto mantém a conexão ativa para aumentar o desempenho. Se não está num servidor dedicado, isto pode causar problemas ao seu servidor.<br>Com esta opção desligada, pode precisa de ligar o mysqli.allow_persistent ou o pgsql.allow_persistent no seu ficheiro php.ini.';
$helptxt['ssi_db_user'] = 'Configuração opcional para usar um nome de utilizador e senha diferentes na base de dados quando está a usar o SSI.php.';

// argument(s): either $helptxt['queryless_urls_supported'] or $helptxt['queryless_urls_unsupported'], depending on whether the server uses a supported webserver
$helptxt['queryless_urls'] = 'Isto muda as URL do seu fórum para um formato mais agradável aos motores de pesquisa. Vão ficar deste tipo index.php/topic,1.0.html.<br><br>%1$s';
// is conditionally used as part of $helptxt['queryless_urls']
$helptxt['queryless_urls_supported'] = 'Esta opção vai funcionar no seu servidor.';
// is conditionally used as part of $helptxt['queryless_urls']
$helptxt['queryless_urls_unsupported'] = 'Esta opção não vai funcionar no seu servidor.';
$helptxt['minimize_files'] = 'Esta opção irá minimizar os ficheiros CSS e Javascript utilizados pelo seu fórum, reduzindo os pedidos ao seu servidor e acelerando os tempos de carregamento para os seus utilizadores.<br><br>Normalmente deve deixar esta opção ligada. A única ocasião em que pode querer desligar temporariamente é quando esta a alterar ficheiros CSS ou JavaScript no seu site (por exemplo, quando está a editar ficheiros do seu tema ou a desenvolver uma modificação).';
$helptxt['boardindex_max_depth'] = 'Esta opção controla quantos níveis de sub-quadros o SMF vai verificar quando procura por novas mensagens nos sub-quadros. Também afeta que quadros são incluídos quando a opção "Contar as mensagens do sub-quadro nos totais do quadro superior" está ligada.<br><br>Por exemplo, se estiver definido para 1, o sub-quadro só será marcado como "novo" no índice do próprio sub-quadro que contém a nova mensagem. Se estiver definido para 2, os sub-quadro será marcado como "novo" se tiver uma nova mensagem no sub-quadro ou noutro sub-quadro, e por aí fora até 10 níveis.<br><br>Fóruns grandes e ativos podem querer definir isto para um valor baixo de maneira a conservar os recursos do servidor.';
$helptxt['countChildPosts'] = 'Selecionar esta opção significa que as mensagens e tópicos num sub-quadro vão contar para o total no índice de quadros.<br><br>Isto significa que um quadro acima sem mensagens não vai mostrar um \'0\' se houverem mensagens nos seus sub-quadros.';
$helptxt['allow_ignore_boards'] = 'Selecionar esta opção irá permitir aos utilizadores selecionarem os quadros que desejam ignorar.';
$helptxt['deny_boards_access'] = 'Selecionar esta opção vai permitir-lhe negar o acesso a certos quadros baseado nos acessos dos grupos de membros.';

// argument(s): scripturl
$helptxt['who_enabled'] = 'Esta configuração permite-lhe ligar ou desligar a página de <a href="%1$s?action=who" target="_blank" rel="noopener">Quem está online</a>, que mostra quem está a navegar no fórum e o que estão a fazer .';

$helptxt['recycle_enable'] = '&quot;Recicla&quot; tópicos e mensagens para o quadro especificado.';

$helptxt['enableReportPM'] = 'Esta opção permite aos seus utilizadores denunciar mensagens pessoais que recebam à equipa de administração. Isto pode ser útil para ajudar a investigar qualquer abuso do sistema de mensagens pessoais.';
$helptxt['max_pm_recipients'] = 'Esta opção permite-lhe definir o máximo de recipientes permitidos numa única mensagem pessoal enviada a um membro do fórum. Isto pode ser usado para ajudar a parar o spam pelo sistema de mensagens pessoais. Note que os utilizadores com permissão para enviar boletins informativos são isentos desta restrição. Defina 0 para não haver limite.';
$helptxt['pm_posts_verification'] = 'Esta opção irá forçar os utilizadores a inserir o código da imagem de verificação cada vez que enviam uma mensagem pessoal. Apenas membros com um número de mensagens inferior ao número que definir vão precisar de inserir o código - isto ajuda a combater scripts automatizados de spam.';
$helptxt['pm_posts_per_hour'] = 'Isto vai limitar o número de mensagens pessoais que podem ser enviadas por um utilizador no período de uma hora. Não tem efeito sobre administradores e moderadores.';

$helptxt['default_personal_text'] = 'Define o texto padrão que um novo utilizador terá como seu texto pessoal. Esta opção não está disponível quando o texto pessoal está desligado, ou quando os utilizadores podem definir eles próprios o texto pessoal durante o registo.';

$helptxt['registration_method'] = 'Isto determina o método de registo usado pelas pessoas que se desejam juntar ao seu fórum. Pode selecionar os seguintes:<br><br>
	<ul class="normallist">
		<li>
			<strong>Registo desligado</strong><br>
				Desliga o processo de registo, o que significa que nenhum membro novo se pode resgistar no seu fórum.<br>
		</li><li>
			<strong>Registo imediato</strong><br>
				Novos membros podem entrar na conta e colocar mensagens imediatamente depois de se registarem no seu fórum.<br>
		</li><li>
			<strong>Ativação por e-mail</strong><br>
				Quando esta opção está selecionada qualquer membro que se registe no fórum vai receber um e-mail com uma ligação para ativar a conta antes de poderem utilizar o fórum.<br>
		</li><li>
			<strong>Aprovação pelo administrador</strong><br>
				Esta opção fará com que os todos os novos membros que se registem no seu fórum terão de ter as suas contas aprovadas por um administrador antes de poderem utilizar o fórum.
		</li>
	</ul>';

$helptxt['send_validation_onChange'] = 'Quando esta opção está ativa todos os membros que mudem o seu endereço de e-mail no seu perfil terão que reativar a sua conta a partir do e-mail enviado para esse endereço';
$helptxt['approveAccountDeletion'] = 'Quando esta opção está ligada, qualquer pedido de um utilizador para apagr a sua própria conta terá de ser aprovada por um administrador.';

$helptxt['send_welcomeEmail'] = 'Quando esta opção está ligada todos os novos membros  vão receber um e-mail de boas vindas à sua comunidade';
$helptxt['password_strength'] = 'Esta opção determina a complexidade necessária para as senhas selecionadas pelos utilizadores do seu fórum. Quanto mais complexa, mais difícil será comprometer a conta do membro. As opções possíveis são: 
	<ul class="normallist">
		<li><strong>Baixa:</strong>  A senha tem de conter pelo menos quatro caracteres de comprimento.</li>
		<li><strong>Média:</strong> A senha tem de conter pelo menos o oito caracteres de comprimento, e não pode conter o nome do utilizador ou o endereço de e-mail.</li>
		<li><strong>Alta:</strong> O mesmo que a anterior, exeto que a senha tem de conter uma mistura de maiúsculas e mínusculas e pelo menos um algarismo.</li>
	</ul>';
$helptxt['enable_password_conversion'] = 'Ao ligar esta opção, o SMF vai tentar detetar as senhas armazenadas em outros formatos e convertê-las para o formato que o SMF usa. Tipicamente isto é usado para fóruns convertidos para o SMF, mas pode ter outras utilizações. Desligar isto previne um utilizador de entrar na sua conta com a sua senha depois de uma conversão e terá que redefinir a sua senha.';

$helptxt['coppaAge'] = 'O valor especificado nesta caixa determinará a idade mínima que os novos membros devem ter para obter acesso imediato ao fórum.
Ao se registrarem, eles serão solicitados a confirmar se são maiores de idade e, caso contrário, terão sua inscrição rejeitada ou suspensa, aguardando aprovação dos pais, dependendo do tipo de restrição escolhida.
Se o valor 0 for escolhido para esta configuração, todas as outras configurações de restrição de idade serão ignoradas.';
$helptxt['coppaType'] = 'Se a restrição de idade estiver ligada, esta opção irá definir o que acontece quando um utilizador com idade inferior à idade mínima tenta registar-se no seu fórum. Há duas escolhas possíveis:
	<ul class="normallist">
		<li>
			<strong>Rejeitar o registo:</strong><br>
				Qualquer novo membro abaixo da idade mínima terá o seu registo rejeitado de imediato.<br>
		</li><li>
			<strong>Exigir aprovação parental</strong><br>
				Qualquer novo membro que se tente registar e esteja abaixo da idade mínima exigida terá a sua conta à espera de aprovação, e será apresentado um formulário que os pais/tutores terão que aprovar para se tornar membro do fórum.
				Também serão apresentados os detalhes e contatos do fórum introduzidos na página de configurações, para que possam enviar o formulário para o administrador por e-mail ou fax.
		</li>
	</ul>';
$helptxt['coppaPost'] = 'As caixas de contato são requeridas para que os formulários que garantem a permissão para os utilizadores menores de idade se possam registar. Estes detalhes serão mostrados a todos os menores e são obrigatórios para a provação parental. Pelo menos um endereço postal ou um número de fax tem de ser providenciado.';

$helptxt['allow_hideOnline'] = 'Com esta opção ligada todos os membros têm capacidade de esconder o seu estado online dos outros utilizadores (exceto dos administradores). Note que desligar esta opção não vai mudar o estado de nenhum membro existente - apenas impede que escondam o seu estado no futuro.';
$helptxt['meta_keywords'] = 'Estas palavras chaves são enviadas em cada página para indicar aos motores de pesquisa o conteúdo chave do seu site. Deve ser uma lista de palavras separadas por uma vírgula e não pode usar HTML.';

$helptxt['latest_themes'] = 'Esta área mostra alguns dos temas mais populares do <a href="https://www.simplemachines.org/" target="_blank" rel="noopener">www.simplemachines.org</a>. Pode não funcionar corretamente se o seu computador não puder encontrar o <a href="https://www.simplemachines.org/" target="_blank" rel="noopener">www.simplemachines.org</a>,.';

$helptxt['secret_why_blank'] = 'Para sua segurança, a sua senha e a resposta à sua pergunta secreta são encriptadas para que o SMF nunca lhe dia a si, ou a qualquer outra pessoa, quais são.';
$helptxt['moderator_why_missing'] = 'Uma vez que a moderação é feita quadro-a-quadro, tem de tornar os membros moderadores a partir <a href="%1$s?action=admin;area=manageboards" target="_blank" rel="noopener">da página de gerir quadros e categorias</a>.';

$helptxt['permissions'] = 'As permissões são como permite ou nega grupos de fazer coisas específicas.<br><br>Pode modificar vários quadros de uma vez com as caixas de verificação, ou olhar para as permissões de um grupo específico clicando em \'Modificar\'';
$helptxt['permissions_board'] = 'Se um quadro está definido para \'Global\', significa que o quadro não tem nenhumaas permissões especiais. \'Local\' significa que terá as suas próprias permissões - separadas dos globais. Isto permite que tenha quadros com mais ou menos permissões que outros, sem que tenha de as definir individualmente.';
$helptxt['permissions_quickgroups'] = 'Isto permite-lhe usar as configurações &quot;padrão&quot; de permissões -  <em>padrão</em> significa \'nada de especial\', <em>restritivo</em> significa \'como um visitante\', <em>moderador</em> significa \'o que um moderador tem\', e finalmente <em>manutenção</em> que significa \'permissões muito próximas de um administrador\'.';
$helptxt['permissions_deny'] = 'Negar permissões pode ser útil quando quer tirar permissões de certos membros. Pode adicionar um grupo e membros com permissão \'negar\' a membros que deseja negar a permissão.<br><br><strong>Use com cuidado</strong>, uma permissão negada vai continuar negada não interessando os outros grupos a que o membro pertence.';
$helptxt['permissions_postgroups'] = 'Permitir permissões para grupos baseados no número de mensagens permite-lhe atribuir permissões a membros que tenham colocado uma certa quantidade de mensagens. As permissões de grupos baseados no número de mensagens são <em>adicionadas</em> às permissões dos grupos de membros regulares..';
$helptxt['membergroup_guests'] = 'O grupo de visitantes são todos os utilizadores que não fizeram login.';
$helptxt['membergroup_regular_members'] = 'Os membros regulares são todos os membros que fizeram login, mas que não pertencem a nenhum grupo de membros.';
$helptxt['membergroup_administrator'] = 'O administrador pode, por definição, fazer o que quiser e ver qualquer quadro. Não há permissões por definir para o administrador.';
$helptxt['membergroup_moderator'] = 'O grupo de moderadores é um grupo especial. Permissões e configurações dadas a este grupo aplicam-se aos moderadores mas apenas <em>nos quadros que moderam</em>. Fora desses quadros são como qualquer outro membro. Note que as permissões para este grupo também se aplicam a qualquer grupo que modere um quadro.';
$helptxt['membergroups'] = 'No SMF há dois tipos de grupos a que os seus membros podem fazer parte. Estes são:
	<ul class="normallist">
		<li><strong>Grupos regulares:</strong> Um grupo regular é um grupo em que os membros não são automaticamente colocados. Para colocar um membro num grupo, simplesmente vá ao perfil do membro e clique em &quot;Configurações de conta&quot;. A partir daí pode definir qualquer grupo regular que deseja para esse membro.</li>
		<li><strong>Grupos baseados em mensagens:</strong> Ao contrário dos grupos regulares, os grupos baseados em mensagens não podem ser atribuídos individualmente. Em vez disso, os membros têm o grupo automaticamente atribuído quando alcançam o número de mensagens definido para cada grupo.</li>
	</ul>';

$helptxt['calendar_how_edit'] = 'Pode editar estes eventos clicando no asterisco vermelho (*) ao lado dos nomes.';

$helptxt['maintenance_backup'] = 'Esta área permite-lhe guardar uma cópia de todas as mensagens, configurações, membros e outras informações do seu fórum num ficheiro com algum tamanho.<br><br>é recomendado que faça isto com frequência, talvez uma vez por semana, por segurança.';
$helptxt['maintenance_rot'] = 'Isto permite-lhe remover <strong>completamente</strong> e <strong>irrevogavelmente</strong> os tópicos antigos. É recomendado que faça uma cópia de segurança antes, só para o caso de remover algo que não queria.';
$helptxt['maintenance_members'] = 'Isto permite-lhe remover <strong>completamente</strong> e <strong>irrevogavelmente</strong> contas de membros do seu fórum. É <strong>altamente</strong> recomendável que faça uma cópia de segurança antes, para o caso de remover algo que não queria.<br><br><strong> Use isto com cuidado</strong>.';

$helptxt['avatar_server_stored'] = 'Isto permite que os seus membros escolham avatares armazenados no seu servidor. Por defeito estão armazenados no diretório "avatars".';
$helptxt['avatar_external'] = 'Com isto ligado, os seus membros podem digitar uma URL para o seus próprios avatares. O ponto negativo nisto é que em alguns casos os membros podem usar avatares que são demasiado grandes ou imagens que não quer no seu fórum.';
$helptxt['avatar_download_external'] = 'Com esta opção ligada, os avatares externos serão descarregados das URL dadas pelos utilizadores. Quando tiver sucesso os avatares serão tratados como os avatares enviados para o servidor.';
$helptxt['avatar_action_too_large'] = 'Esta opção permite-lhe rejeitar imagens (de outros sites) que são demasiado grandes, ou diz ao navegador do utilizador para os redimensionar, ou descarrega-os para o seu servidor.<br><br>Se os utilizadores colocarem grandes imagens como avatar e o navegador redimensionar, isto pode causar um carregamento lento da página aos seus utilizadores - o ficheiro não é realmente redimensionado em tamanho, apenas é mostrado mais pequeno. Uma foto digital, por exemplo, ainda seria completamente carregada e então redimensionada - por isso os utilizadores podem experimentar lentidão e gastar mais largura de banda.<br><br>Por outro lado, ao descarregar a imagem significa usar a sua largura de banda e espaço no servidor, mas também assegura que a imagem é mais pequena, por isso deve deve ser mais rápido para os utilizadores. (Nota: descarregar e redimensionar requer que a biblioteca GD ou ImageMagick juntamente com a extensão Imagick ou MagickWand)';
$helptxt['avatar_upload'] = 'Esta configuração é muito parecida com &quot;avatares externos&quot;, exceto que tem um melhor controlo sobre os avatares, um melhor tempo a redimensioná-los, e os seus membros não têm de ter um sítio para guardar os avatares.<br><br>Contudo, isto vai ocupar espaço no servidor.';
$helptxt['avatar_download_png'] = 'Os ficheiros PNG são maiores, mas oferecem uma melhor qualidade de compressão. Se não estiver selecionado, será usado JPEG - que é normalmente mais pequeno, mas também com pior qualidade.';

$helptxt['disableHostnameLookup'] = 'Isto desliga a verificação dos nomes de servidor, que em alguns servidores é muito lento. Note que isto vai fazer com que o banimento seja menos efetivo.';

$helptxt['smiley_sameall'] = 'Se selecionado a opção "Mesma imagem para todos os conjuntos", a imagem será adicionada a todos os conjuntos de smilies. Se retirar o visto da caixa, uma imagem diferente terá de ser enviada para cada conjunto de smilies instalado. Note que uma imagem precisa de ser providenciada para cada conjuntos de smilies.';

$helptxt['search_weight_frequency'] = 'Os fatores de peso são usados para determinar a relevância de um resultado de pesquisa. Altere esses fatores de peso para corresponder às coisas que são especificamente importantes para o seu fórum. Por exemplo, um fórum de um site de notícias pode querer um valor relativamente alto para \'idade da última mensagem correspondente\'. Todos os valores são relativos entre si e devem ser números inteiros positivos.<br><br>Esse fator conta a quantidade de mensagens correspondentes e divide-as pelo número total de mensagens num tópico.';
$helptxt['search_weight_age'] = 'Os fatores de peso são usados para determinar a relevância de um resultado de pesquisa. Altere esses fatores de peso para corresponder às coisas que são especificamente importantes para o seu fórum. Por exemplo, um fórum de um site de notícias pode querer um valor relativamente alto para \'idade da última mensagem correspondente\'. Todos os valores são relativos entre si e devem ser números inteiros positivos.<br><br>Esse fator classifica a idade da última mensagem correspondente num tópico. Quanto mais recente for esta mensagem, maior será a pontuação.';
$helptxt['search_weight_length'] = 'Os fatores de peso são usados para determinar a relevância de um resultado de pesquisa. Altere esses fatores de peso para corresponder às coisas que são especificamente importantes para o seu fórum. Por exemplo, um fórum de um site de notícias pode querer um valor relativamente alto para \'idade da última mensagem correspondente\'. Todos os valores são relativos entre si e devem ser números inteiros positivos.<br><br>Esse fator é baseado no tamanho do tópico. Quanto mais mensagens estiverem dentro do tópico, maior será a pontuação.';
$helptxt['search_weight_subject'] = 'Os fatores de peso são usados para determinar a relevância de um resultado de pesquisa. Altere esses fatores de peso para corresponder às coisas que são especificamente importantes para o seu fórum. Por exemplo, um fórum de um site de notícias pode querer um valor relativamente alto para \'idade da última mensagem correspondente\'. Todos os valores são relativos entre si e devem ser números inteiros positivos.<br><br>Esse fator verifica se um termo de pesquisa pode ser encontrado no assunto de um tópico.';
$helptxt['search_weight_first_message'] = 'Os fatores de peso são usados para determinar a relevância de um resultado de pesquisa. Altere esses fatores de peso para corresponder às coisas que são especificamente importantes para o seu fórum. Por exemplo, um fórum de um site de notícias pode querer um valor relativamente alto para \'idade da última mensagem correspondente\'. Todos os valores são relativos entre si e devem ser números inteiros positivos.<br><br>Esse fator verifica se uma correspondência pode ser encontrada na primeira mensagem de um tópico.';
$helptxt['search_weight_sticky'] = 'Os fatores de peso são usados para determinar a relevância de um resultado de pesquisa. Altere esses fatores de peso para corresponder às coisas que são especificamente importantes para o seu fórum. Por exemplo, um fórum de um site de notícias pode querer um valor relativamente alto para \'idade da última mensagem correspondente\'. Todos os valores são relativos entre si e devem ser números inteiros positivos.<br><br>Este fator verifica se um tópico é fixo e aumenta a pontuação de relevância se for.';
$helptxt['search'] = 'Ajuste todas as configurações para a função de pesquisa aqui.';
$helptxt['search_why_use_index'] = 'Um índice de pesquisa pode melhorar muito o desempenho das pesquisas no seu fórum. Especialmente quando o número de mensagens num fórum cresce, pesquisar sem um índice pode levar muito tempo e aumentar a pressão na sua base de dados. Se o seu fórum tiver mais de 50.000 mensagens, considere criar um índice de pesquisa para garantir o desempenho máximo do seu fórum.<br><br>Observe que um índice de pesquisa pode ocupar bastante espaço. Um índice de texto completo é um índice interno do MySQL e do PostgreSQL. É relativamente compacto (aproximadamente do mesmo tamanho da tabela de mensagens), mas muitas palavras não são indexadas e pode, em algumas consultas de pesquisa, tornar-se muito lento. O índice personalizado geralmente é maior (dependendo da sua configuração, pode ter até 3 vezes o tamanho da tabela de mensagens), mas o seu desempenho é melhor que o de texto completo e relativamente estável.';

$helptxt['see_admin_ip'] = 'Os endereços IP são mostrados aos administradores e moderadores para facilitar a moderação e facilitar o rastreamento de pessoas que se portam mal. Lembre-se de que os endereços IP nem sempre são identificáveis, e os endereços IP da maioria das pessoas mudam periodicamente.<br><br>Os membros também podem ver seus próprios IP.';
$helptxt['see_member_ip'] = 'o seu endereço IP é mostrado apenas a si e aos moderadores. Lembre-se de que essas informações não são identificadoras e que a maioria dos IP muda periodicamente.<br><br>Não pode ver os endereços IP de outros membros e eles não podem ver o seu.';
$helptxt['whytwoip'] = 'O SMF usa vários métodos para detetar endereços IP dos utilizadores. Normalmente, esses dois métodos resultam no mesmo endereço, mas em alguns casos mais de um endereço pode ser detetado. Nesse caso, o SMF regista os dois endereços mais recentes e usa-os para verificações de banimento (etc). Pode clicar em qualquer endereço para rastrear esse IP e banir, se necessário.';

$helptxt['ban_cannot_post'] = 'A restrição \'não pode colocar mensagens\' faz com que o fórum passe apenas a ser de leitura para o utilizador banido. O utilizador não pode criar novos tópicos, ou responder aos existentes, enviar mensagens pessoais ou votar em sondagens. O utilizador banido pode, contudo, ler mensagens pessoais e tópicos.<br><br>Uma mensagem de aviso é mostrada aos utilizadores que estão banidos desta maneira.';

$helptxt['posts_and_topics'] = '
	<ul class="normallist">
		<li>
			<strong>Configurações de mensagens</strong><br>
			Modifica as configurações relativas à colocação de mensagens e à maneira como as mensagens são mostradas. Pode também ligar a verificação ortográfica aqui.
		</li><li>
			<strong>Bulletin Board Code</strong><br>
			Liga o código que mostra as mensagens do fórum no formato correto. Também ajusta que códigos são ou não permitidos.
		</li><li>
			<strong>Palavras censuradas</strong>
			De forma a controlar a linguagem no seu fórum, pode censurar certas palavras. Esta função permite-lhe substituir palavras proibidas em versões inocentes.
		</li><li>
			<strong>Configurações de tópicos</strong>
			Modifica as configurações relativas a tópicos. O número de mensagens por ágina, se a vista de impressão está ligada, etc.
		</li>
	</ul>';

$helptxt['spider_mode'] = 'Define o nível de registo.<br>
Padrão  - Regista o mínimo de atividade dos mecanismos de pesquisa.<br>
Moderado - Dá estatísticas mais exatas.<br>
Agressivo - O mesmo que &quot;Moderado&quot;, mas regista os dados sobre as páginas visitadas.';

$helptxt['spider_group'] = 'Ao selecionar um grupo restritivo, quando um visitante for detetado como um mecanismo de pesquisa, ele receberá automaticamente qualquer permissão &quot;negada&quot; deste grupo além das permissões normais de um visitante. Pode usar isso para fornecer menos acesso a um mecanismo de pesquisa do que faria com um visitante normal. Pode, por exemplo, criar um novo grupo chamado &quot;Mecanismos de pesquisa&quot; e selecionar aqui. Pode negar permissão para esse grupo visualizar perfis para impedir que os mecanismos de pesquisa indexem os perfis dos seus membros.<br>Observação: a deteção de mecanismos de pesquisa não é perfeita e pode ser simulada pelos utilizadores, portanto, este recurso não garante restringir o conteúdo apenas aos mecanismos de pesquisa que adicionou.';
$helptxt['show_spider_online'] = 'Esta opção permite-lhe selecionar se os mecanismos de pesquisa são listados na lista de &quot;quem está online&quot; no índice do fórum na página de &quot;quem está online&quot;. As opções são:
	<ul class="normallist">
		<li>
			<strong>Nada de todo</strong><br>
			Os mecanismos de pesquisa são mostrados como visitantes a todos os utilizadores.
		</li><li>
			<strong>Mostrar a quantidade de mecanismos de pesquisa</strong><br>
			No índice do fórum mostra o número de mecanismos de pesquisa a visitar o fórum no momento.
		</li><li>
			<strong>Mostrar o nome dos mecanismos de pesquisa</strong><br>
			Cada nome dos mecanismos de pesquisa será revelado, por isso os utilizadores podem ver que mecanismo está no fórum no momento - isto afeta tanto o índice do fórum como a página de quem está online.
		</li><li>
			<strong>Mostrar os nomes dos mecanismos de pesquisa - Apenas administrador</strong><br>
			Tal como o anterior, com a exceção de que apenas os administradores podem ver o estado dos mecanismos de pesquisa - para todos os outros serão mostrados como visitantes.
		</li>
	</ul>';

$helptxt['birthday_email'] = 'Escolhe a mensagem de aniversário que será enviada por e-mail. Uma pré-visualização será mostrada nos campos do assunto do e-mail do corpo do e-mail.<br><strong>Nota:</strong> Selecionar esta configuração não liga automaticamente os e-mails de aniversário. Para ligar os e-mails de aniversário use a página de <a href="%1$s?action=admin;area=scheduledtasks;%3$s=%2$s" target="_blank" rel="noopener">tarefas agendadas</a> e ligue a tarefa dos e-mails de aniversário.';
$helptxt['pm_bcc'] = 'Quando envia uma mensagem pessoal pode escolher adicionar um recipiente como BCC (Blind Carbon Copy). Os recipientes BCC recipients não têm as suas identidades reveladas para os outros recipientes da mensagem.';

$helptxt['move_topics_maintenance'] = 'Isto permite-lhe mover todas as mensagens de um quadro para outro quadro.';
$helptxt['maintain_reattribute_posts'] = 'Pode usar esta função para atribuir mensagens de visitantes no seu fórum para um membro registado. Isto é útil se, por exemplo, um utilizador apagar a sua conta e mudar de ideais mais tarde e desejar ter as suas antigas mensagens associadas à sua conta.';
$helptxt['chmod_flags'] = 'Pode definir manualmente as permissões que deseja atribuir aos ficheiros selecionados. Para fazer isto insira o valor chmod como um valor numérico. Nota - isto não terá efeito em servidores com um sistema operativo Microsoft Windows.';

$helptxt['postmod'] = 'Esta página permite que membros da equipa de moderação (com permissões suficientes) possam aprovar mensagens e tópicos antes de serem públicos.';

$helptxt['field_show_enclosed'] = 'Inclui a entrada do utilizador entre algum texto ou html. Isto permite que adicione mais provedores de mensagens instantâneas, imagens ou uma incorporação, etc. Por exemplo:<br><br>
		&lt;a href="https://examplo.com/{INPUT}"&gt;&lt;img src="{DEFAULT_IMAGES_URL} /icon.png" alt="{INPUT}" /&gt;&lt;/a&gt;<br><br>
		Note que pode usar as seguintes variáveis:<br>
		<ul class="normallist">
			<li>{INPUT} - A entrada especificada pelo utilizador.</li>
			<li>{SCRIPTURL} - Endereço web do fórum.</li>
			<li>{IMAGES_URL} - URL para o diretório de imagens do tema atual do utilizador.</li>
			<li>{DEFAULT_IMAGES_URL} - URL para o diretório de imagens do tema padrão.</li>
			<li>{KEY} - Usado quando um campo tem várias opções, é um ID unicamente numérico usado apra o identificar.</li>
		</ul>';

$helptxt['custom_mask'] = 'A máscara de introdução é importante para a segurança do seu fórum. Validar a introdução do utilizador ajuda a assegurar que os dados não são utilizados de outra forma que não a esperada. Algumas expressões regulares simples são fornecidas a título de exemplo.<br><br>
    Os delimitadores marcam o começo e o final do padrão necessário! São um til (~) nos exemplos abaixo.<br><br>
	<div class="smalltext" style="margin: 0 2em">
		&quot;~[A-Za-z]+~&quot; - Corresponder todas as maiúsculas e minúsculas do alfabeto.<br>
		&quot;~[0-9]+~&quot; - Corresponder todos os caracteres numéricos.<br>
		&quot;~[A-Za-z0-9]{7}~&quot; - Corresponder todas as maiúsculas e minúsculas do alfabeto e caracteres numéricos sete vezes.<br>
		&quot;~[^0-9]?~&quot; - Proibir a correspondência de qualquer número.<br>
		&quot;~^([A-Fa-f0-9]{3}|[A-Fa-f0-9]{6})$~&quot; - Permitir apenas 3 ou 6 caracteres hexadecimais.<br>
	</div><br><br>
	Additionally, special metacharacters ?+*^$ and {xx} can be defined.
	<div class="smalltext" style="margin: 0 2em">
		? - None or one match of previous expression.<br>
		+ - One or more of previous expression.<br>
		* - None or more of previous expression.<br>
		{xx} - An exact number from previous expression.<br>
		{xx,} - An exact number or more from previous expression.<br>
		{,xx} - An exact number or less from previous expression.<br>
		{xx,yy} - An exact match between the two numbers from previous expression.<br>
		^ - Start of string.<br>
		$ - End of string.<br>
		\\ - Escapes the next character.<br>
	</div><br><br>
	More information and advanced techniques may be found on the Internet.';

$helptxt['topic_move_any'] = 'Se selecionado, os utilizadores terão permissão para mover tópicos de qualquer quadro que possam aceder. Caso contrário, apenas podem mover para quadros onde possam abrir novos tópicos.';

$helptxt['alert_pm_new'] = 'Notificações de novas mensagens pessoais não aparecem no painel de alertas, em vez disso aparecem na lista de "Minhas mensagens".';
$helptxt['alert_event_new'] = 'Isto irá enviar um alerta ou e-mail como pedido se houver um novo evento adicionado ao calendário. Contudo, se esse evento for colocado e um tópico adicionado, não irá receber um alerta para o evento se não estiver a seguir esse quadro - o alerta do quadro irá substituir este.';

$helptxt['force_ssl'] = '<strong>Teste o SSL e HTTPS no seu servidor antes de ligar isto. Pode deixar o seu fórum inacessível.</strong> Ligue o modo de manutenção se for incapaz de aceder ao fórum depois disto.<br><br><strong>Mudar esta configuração irá atualizar a URL primária do seu fórum, assim como as URL dos ficheiros de temas e imagens, smilies e avatares, colocando-os em http ou https baseado na sua seleção. URL personalizadas não serão afetadas .</strong>';
$helptxt['image_proxy_enabled'] = 'Requerido para incorporar imagens externas quando está em SSL completo';
$helptxt['image_proxy_secret'] = 'Mantenha isto em segredo. Protege o seu fórum de imagens "hotlink". Mude para deixar inúteis as imagens atualmente ligadas';
$helptxt['image_proxy_maxsize'] = 'Tamanho máximo da imagem que o proxy de imagem SSL vai guardar em cache: imagens maiores não serão guardadas em cache. Imagens em cache serão armazenadas na pasta da cache do SMF, por isso certifique-se que tem espaço suficiente.';

$helptxt['enable_sm_stats'] = 'Se estiver ligado, irá permitir que o Simple Machines visite o seu site uma vez por mês para recolher estatísticas básicas. Isto irá ajudar-nos a tomar decisões como que configurações usar para otimizar o software. Para mais informação, visite a nossa <a href="https://www.simplemachines.org/about/stats.php" target="_blank" rel="noopener">página de informação</a>.';

$helptxt['field_reg_require'] = 'Se este campo é obrigatório durante o registo, também será obrigatório nas mudanças de perfil..';

$helptxt['translatable_fields'] = 'Se deseja oferecer suporte multi-idiomas para os seus campos de perfil personalizados, pode usar tokens que podem ser traduzidos tanto nos campos do nome como da descrição.<br><br>Tudo o que estiver entre chavetas <span class="monospace">{}</span> será considerado um token e será correspondido a uma linha $txt. Por exemplo, o token <span class="monospace">{gender}</span> será substituído pelo valor $txt[\'gender\']<br><br>É <strong>muito importante</strong> adicionar a linha de texto correspondente para todos os idiomas atualmente instalados. Para fazer isso vá a <a href="%1$s?action=admin;area=languages;sa=edit;%3$s=%2$s" class="bbc_link" target="_blank" rel="noopener">Editar idiomas</a> e complete os seguintes passos para cada idioma instalado:
<ol class="bbc_list" style="list-style-type: decimal">
	<li>Clique no botão "editar" ao lado do nome do idioma.</li>
	<li>Em "Selecione as entradas para editar" escolha "Modificações".</li>
	<li>Vá até ao fundo e clique em "Adicionar outro item".</li>
	<li>Siga as instruções para adicionar sua nova linha.</li>
</ol>';

// argument(s): $boarddir, $boardurl
$helptxt['cron_is_real_cron'] = 'Por defeito, o SMF adiciona a cada página um pouco de JavaScript que leva o navegador do utilizador a dispensar o cron.php em pano de fundo. Isto permite ao SMF executar as tarefas agendadas numa base regular sem requerer que o administrador tenha o trabalho extra na configuração do servidor. Contudo, alguns administradores podem preferir configurar os seus servidores diretamente para executar o cron.php de forma regular. Se fez isto, pode desativar o método JavaScript.<br><br><strong>Nota:</strong> Configurar o servidor para correr tarefas agendadas desta maneira não pode ser feito através do SMF. Precisa de usar o seu programa de configuração do servidor para isso. Ferramentas comuns para este propósito incluiem o <code>cron</code> (servidores Linux), <code>schtasks.exe</code> (servidores Windows), e <code>launchd</code> (servidores macOS). A maioria das companhias de hospedagem  providenciam algum tipo de painel de controlo que permite aos seus clientes aceder a estas ferramentas.<br><br>O caminho e a URL para o cron.php do seu fórum é:<br>Caminho: %1$s/cron.php<br>URL: %2$s/cron.php';

$helptxt['languages_txt'] = 'Estas entradas de idioma são usadas pelo SMF para definir versões de texto para diferentes idiomas.<br><br>Se vir um valor como <code>&#37;1$s</code> numa entrada, é um valor que o SMF preenche.';
$helptxt['languages_helptxt'] = 'Estas entradas de idioma são usadas para mostrar janelas flutuantes com ajuda (como esta).';
$helptxt['languages_editortxt'] = 'Estas entradas de idioma são usadas para elementos no editor de mensagens.';
$helptxt['languages_tztxt'] = 'Estas entradas de idioma são usadas para construir descrições para os fusos horáriors.<br><br>Por exemplo, a linha <code>Europe_Western</code> pode ser combinada com <code>daylight_saving_time_false</code> para produzir"Western European Standard Time".<br><br>Nota: se nenhuma descrição for dada para um fuso horário, o SMF irá gerar uma descrição com base na lista de locais dentro desse fuso horário.';
$helptxt['languages_txt_for_timezones'] = 'Estas entradas de idioma permitem-lhe fazer o seguinte:<br><ol class="bbc_list" style="list-style-type: decimal;"><li>Editar os nomes mostrados para localizações individuais em qualquer lugar que possam ser usados num contexto relacionado com fusos horários. Por exemplo, pode dizer ao SMF para mostrar "Qaanaaq" para o local "America/Thule" em vez de "Thule".</li><li>Editar os nomes mostrados para diferentes países. Isto pode ser feito editando a linha relevante <code>iso3166[]</code>.</li></ol>';
$helptxt['languages_txt_for_email_templates'] = 'Estas entradas do idioma são usadas para criar mensagens de e-mail que o SMF envia aos seus membros.';
$helptxt['languages_native_name'] = 'O nome do idioma, representado pelo seu próprio script.';
$helptxt['languages_character_set'] = 'O código de caracteres usado por este idioma. No SMF 2.1 deverá ser sempre UTF-8.';
$helptxt['languages_locale'] = 'O código local que é usado para determinar várias convenções de formatação, etc.<br><br>O código de localização tipicamente tem a forma de dois caracteres, opcionalmente seguido por uma barra inferior e dois caracteres do código do país. Por exemplo: <code>en</code> identifica o inglês genérico, enquanto <code>en_AU</code> identifica o inglês australiano em particular.';
$helptxt['languages_rtl'] = 'Introduza aqui um "1" se este idioma for lido da direita para a esquerda (ex. hebraico, árabe). Deixe um "0" para idiomas lidos da esquerda para a direita.';
$helptxt['languages_dictionary'] = 'Isto define o idioma principal do dicionário que será usado pelo corretor ortográfico <a href="https://php.net/function.pspell-new" target="_blank" rel="noopener">pSpell</a> (se estiver instalado)).';
$helptxt['languages_recaptcha'] = 'O código de idioma usado para a verificação do reCAPTCHA. Veja a documentação do reCAPTCHA para a <a href="https://developers.google.com/recaptcha/docs/language" target="_blank" rel="noopener" class="bbc_link">lista de idiomas suportados</a>.';
// The GDPR page of the EU exists in several languages; change the language code at the end of the url
$helptxt['requireAgreement'] = 'É recomendado que esta opção esteja ligada para cumprir com as regras <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_pt" target="_blank" rel="noopener" class="bbc_link">GDPR</a>.';
// The GDPR page of the EU exists in several languages; change the language code at the end of the url
$helptxt['requirePolicyAgreement'] = 'É recomendado que esta opção esteja ligada para cumprir com as regras <a href="https://ec.europa.eu/info/law/law-topic/data-protection/eu-data-protection-rules_pt" target="_blank" rel="noopener" class="bbc_link">GDPR</a>.';
$helptxt['gravatar'] = 'Gravatar são avatares reconhecidos globalmente. Registe uma conta em  <a href="https://www.gravatar.com" target="_blank" rel="noopener">https://www.gravatar.com</a> para selecionar uma imagem como avatar. Esse avatar estará então disponível em todos os sites que suportem gravatares. Se não tem uma conta gravatar, uma imagem padrão será usada.';

?>