<?php
// Version: 2.1.0; EmailTemplates

// Since all of these strings are being used in emails, numeric entities should be used.

// Do not translate anything that is between {}, they are used as replacement variables and MUST remain exactly how they are.
//   Additionally, do not translate the @additional_params: line or the variable names in the lines that follow it. You may
//   translate the description of the variable. Do not translate @description:, however you may translate the rest of that line.

// Do not use block comments in this file, they will have special meaning.

global $txtBirthdayEmails;

/**
	@additional_params: resend_activate_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONCODE:  The code needed to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['resend_activate_message_subject'] = 'Benvenuto su {FORUMNAME}';
$txt['resend_activate_message_body'] = 'Grazie per esserti registrato su {FORUMNAME}. Il tuo nome utente è {USERNAME}. 

Se dimentichi la tua password puoi resettarla visitando {FORGOTPASSWORDLINK}. 

Prima di poter effettuare l\'accesso devi attivare il tuo account cliccando su questo collegamento:

{ACTIVATIONLINK}

In caso di problemi con l\'attivazione visita {ACTIVATIONLINKWITHOUTCODE} e inserisci il codice "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: resend_pending_message
		REALNAME: The display name for the member receiving the email.
		USERNAME:  The user name for the member receiving the email.
	@description:
*/
$txt['resend_pending_message_subject'] = 'Benvenuto su {FORUMNAME}';
$txt['resend_pending_message_body'] = 'Ciao {REALNAME}, la tua richiesta di registrazione su {FORUMNAME} è stata ricevuta. 

Il tuo nome utente è {USERNAME}.

Prima di poter accedere e iniziare a utilizzare il forum la richiesta deve essere esaminata e approvata, in questo caso, riceverai un\'altra email di conferma da questo indirizzo.

{REGARDS}';

/**
	@additional_params: mc_group_approve
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was accepted into.
	@description: The request to join a particular membergroup has been accepted.
*/
$txt['mc_group_approve_subject'] = 'Approvazione adesione al gruppo';
$txt['mc_group_approve_body'] = '{USERNAME}, 

siamo lieti di comunicarti che la tua richiesta di entrare a far parte del gruppo "{GROUPNAME}" su {FORUMNAME} è stata accettata, il tuo account è stato aggiornato per includere tutte le funzioni del nuovo gruppo.

{REGARDS}';

/**
	@additional_params: mc_group_reject
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
	@description: The request to join a particular membergroup has been rejected.
*/
$txt['mc_group_reject_subject'] = 'Adesione al gruppo non approvata';
$txt['mc_group_reject_body'] = '{USERNAME},

ci dispiace comunicarti che la tua richiesta di entrare a far parte del gruppo "{GROUPNAME}" su {FORUMNAME} non è stata approvata.

{REGARDS}';

/**
	@additional_params: mc_group_reject_reason
		USERNAME: The user name for the member receiving the email.
		GROUPNAME: The name of the membergroup that the user was rejected from.
		REASON: Reason for the rejection.
	@description: The request to join a particular membergroup has been rejected with a reason given.
*/
$txt['mc_group_reject_reason_subject'] = 'Adesione al gruppo non approvata';
$txt['mc_group_reject_reason_body'] = '{USERNAME},

ci dispiace comunicarti che la tua richiesta di entrare a far parte del gruppo "{GROUPNAME}" su {FORUMNAME} non è stata approvata per il seguente motivo:

{REASON}

{REGARDS}';

/**
	@additional_params: admin_approve_accept
		NAME: The display name of the member.
		USERNAME: The user name for the member receiving the email.
		PROFILELINK: The URL of the profile page.
		FORGOTPASSWORDLINK: The URL of the "forgot password" page.
	@description:
*/
$txt['admin_approve_accept_subject'] = 'Benvenuto su {FORUMNAME}';
$txt['admin_approve_accept_body'] = 'Benvenuto {NAME}, 

il tuo account è stato attivato manualmente dall\'amministratore e ora puoi effettuare l\'accesso. 

Il tuo nome utente è {USERNAME}. 

Se dimentichi la tua password, puoi cambiarla su {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: admin_approve_activation
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_activation_subject'] = 'Benvenuto su {FORUMNAME}';
$txt['admin_approve_activation_body'] = 'Benvenuto {USERNAME}!

Il tuo account su {FORUMNAME} è stato approvato dall\'amministratore del forum. 

Prima di effettuare l\'accesso devi attivare il tuo account cliccando nel seguente collegamento:

{ACTIVATIONLINK}

Se riscontri problemi nell\'attivazione visita {ACTIVATIONLINKWITHOUTCODE} e inserisci il codice "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: admin_approve_reject
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_reject_subject'] = 'Registrazione rifiutata';
$txt['admin_approve_reject_body'] = '{USERNAME},

la tua registrazione su {FORUMNAME} è stata rifiutata.

{REGARDS}';

/**
	@additional_params: admin_approve_delete
		USERNAME: The user name for the member receiving the email.
	@description:
*/
$txt['admin_approve_delete_subject'] = 'Account eliminato';
$txt['admin_approve_delete_body'] = '{USERNAME},

il tuo account su {FORUMNAME} è stato eliminato. 

Questo potrebbe essere dovuto al fatto che non hai mai attivato il tuo account, in questo caso puoi effettuare nuovamente la registrazione.

{REGARDS}';

/**
	@additional_params: admin_approve_remind
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_approve_remind_subject'] = 'Promemoria di registrazione';
$txt['admin_approve_remind_body'] = '{USERNAME},

non hai ancora attivato il tuo account su {FORUMNAME}. 

Usa il seguente collegamento per procedere con l\'attivazione:

{ACTIVATIONLINK}

Se riscontri problemi con l\'attivazione visita {ACTIVATIONLINKWITHOUTCODE} e inserisci il codice "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params:
		USERNAME: The user name for the member receiving the email.
		ACTIVATIONLINK:  The URL link to activate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE: The activation code.
	@description:
*/
$txt['admin_register_activate_subject'] = 'Benvenuto su {FORUMNAME}';
$txt['admin_register_activate_body'] = 'Ti ringraziamo per esserti registrato su {FORUMNAME}. 

Il tuo nome utente è {USERNAME} e la tua password è {PASSWORD}.

Prima di poter effettuare l\'accesso devi attivare l\'account cliccando nel seguente collegamento:

{ACTIVATIONLINK}

Se riscontri problemi con l\'attivazione visita {ACTIVATIONLINKWITHOUTCODE} e inserisci il codice "{ACTIVATIONCODE}".

{REGARDS}';

$txt['admin_register_immediate_subject'] = 'Benvenuto su {FORUMNAME}';
$txt['admin_register_immediate_body'] = 'Ti ringraziamo per esserti registrato su {FORUMNAME}.

Il tuo nome utente è {USERNAME}, la tua password è {PASSWORD} e l\'indirizzo del forum è:

{SCRIPTURL}

{REGARDS}';

/**
	@additional_params: new_announcement
		TOPICSUBJECT: The subject of the topic being announced.
		MESSAGE: The message body of the first post of the announced topic.
		TOPICLINK: A link to the topic being announced.
		UNSUBSCRIBELINK: Link to unsubscribe from announcements.
	@description:
*/
$txt['new_announcement_subject'] = 'Nuovo annuncio: {TOPICSUBJECT}';
$txt['new_announcement_body'] = '{MESSAGE}

Per annullare l\'iscrizione a questi annunci effettua l\'accesso al forum e deseleziona l\'opzione "Consenti agli amministratori di inviarmi importanti notizie via e-mail" dalle impostazioni del tuo profilo.

Puoi visualizzare l\'annuncio completo cliccando nel seguente collegamento:
{TOPICLINK}

{REGARDS}';

/**
	@additional_params: notify_boards_once_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_body_subject'] = 'Nuova discussione: {TOPICSUBJECT}';
$txt['notify_boards_once_body_body'] = 'Una nuova discussione, \'{TOPICSUBJECT}\', è stato creata nella sezione che stai seguendo. 

Puoi visualizzarla cliccando nel seguente collegamento:
{TOPICLINK}

Potrebbero essere state create altre discussioni ma non riceverai ulteriori notifiche email fino a quando non ritornerai in quella sezione.

Il testo della discussione è il seguente:

{MESSAGE}

Se vuoi annullare le notifiche email per le nuove discussioni create in questa sezione clicca nel seguente collegamento:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_once
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_once_subject'] = 'Nuova discussione: {TOPICSUBJECT}';
$txt['notify_boards_once_body'] = 'Una nuova discussione, \'{TOPICSUBJECT}\', è stata creata nella sezione che stai seguendo.

Puoi visualizzarla cliccando nel seguente collegamento:
{TOPICLINK}

Potrebbero essere state create altre discussioni ma non riceverai ulteriori notifiche email fino a quando non ritornerai in quella sezione.

Se vuoi annullare le notifiche email per le nuove discussioni create in questa sezione clicca nel seguente collegamento:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards_body
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		MESSAGE: This is the body of the message.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_body_subject'] = 'Nuova discussione: {TOPICSUBJECT}';
$txt['notify_boards_body_body'] = 'Una nuova discussione, \'{TOPICSUBJECT}\', è stata creata nella sezione che stai seguendo.

Puoi visualizzarla cliccando nel seguente collegamento:
{TOPICLINK}

Il testo della discussione è il seguente:

{MESSAGE}

Se vuoi annullare le notifiche email per le nuove discussioni create in questa sezione clicca nel seguente collegamento:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notify_boards
		TOPICSUBJECT: The subject of the topic causing the notification
		TOPICLINK: A link to the topic.
		UNSUBSCRIBELINK: Link to unsubscribe from notifications.
	@description:
*/
$txt['notify_boards_subject'] = 'Nuova discussione: {TOPICSUBJECT}';
$txt['notify_boards_body'] = 'Una nuova discussione, \'{TOPICSUBJECT}\', è stata creata nella sezione che stai seguendo.

Puoi visualizzarla cliccando nel seguente collegamento:
{TOPICLINK}

Se vuoi annullare le notifiche email per le nuove discussioni create in questa sezione clicca nel seguente collegamento:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_reply
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_reply_subject'] = 'Risposta alla discussione: {SUBJECT}';
$txt['alert_unapproved_reply_body'] = 'Una risposta è stata inserita su \'{SUBJECT}\' da {POSTERNAME}. 

Visualizza la risposta:
{LINK}

{REGARDS}';

/**
	@additional_params: unapproved_attachment
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the message with the attachment.
	@description:
*/
$txt['unapproved_attachment_subject'] = 'Nuovo allegato non approvato in: {SUBJECT}';
$txt['unapproved_attachment_body'] = 'E\' stato inserito un nuovo allegato da approvare in \'{SUBJECT}\'.

Puoi approvare o rifiutare questo allegato cliccando nel seguente collegamento:
{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_post
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_post_subject'] = 'Nuovo messaggio non approvato: {SUBJECT}';
$txt['alert_unapproved_post_body'] = 'E\' stato creato un nuovo messaggio da approvare: \'{SUBJECT}\' 

Puoi approvare o rifiutare questo messaggio cliccando nel seguente collegamento:
{LINK}

{REGARDS}';

/**
	@additional_params: alert_unapproved_topic
		SUBJECT: The subject of the topic causing the notification
		LINK: A link to the topic.
	@description:
*/
$txt['alert_unapproved_topic_subject'] = 'Nuova discussione non approvata: {SUBJECT}';
$txt['alert_unapproved_topic_body'] = 'E\' stata creata una nuova discussione da approvare: \'{SUBJECT}\'

Puoi approvare o rifiutare questa discussione cliccando nel seguente collegamento:
{LINK}

{REGARDS}';

/**
	@additional_params: request_membership
		RECPNAME: The name of the person receiving the email
		APPLYNAME: The name of the person applying for group membership
		GROUPNAME: The name of the group being applied to.
		REASON: The reason given by the applicant for wanting to join the group.
		MODLINK: Link to the group moderation page.
	@description:
*/
$txt['request_membership_subject'] = 'Richiesta di adesione a un gruppo';
$txt['request_membership_body'] = '{RECPNAME},

{APPLYNAME} ha richiesto di far parte del gruppo "{GROUPNAME}".

L\'utente ha fornito la seguente motivazione:

{REASON}

Puoi approvare o rifiutare questa richiesta cliccando nel seguente collegamento:
{MODLINK}

{REGARDS}';

/**
	@additional_params: paid_subscription
		REALNAME: The real (display) name of the person receiving the email.
		PROFILE_LINK: Link to profile of member receiving email where can renew.
		SUBSCRIPTION: Name of the subscription.
		END_DATE: Date it expires.
	@description:
*/
$txt['paid_subscription_reminder_subject'] = 'Sottoscrizione in scadenza su {FORUMNAME}';
$txt['paid_subscription_reminder_body'] = '{REALNAME},

Un abbonamento a cui sei iscritto su {FORUMNAME} sta per scadere.
Se al momento dell\'iscrizione hai selezionato il rinnovo automatico non è necessaria alcuna azione altrimenti potresti decidere di iscriverti ancora una volta.
Di seguito i dettagli:

Nome abbonamento {SUBSCRIPTION}
Scadenza: {END_DATE}

Per modificare il tuo abbonamento clicca nel seguente collegamento:
{PROFILE_LINK}

{REGARDS}';

/**
	@additional_params: activate_reactivate
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
	@description:
*/
$txt['activate_reactivate_subject'] = 'Bentornato su {FORUMNAME}';
$txt['activate_reactivate_body'] = 'Per riconvalidare il tuo indirizzo email il tuo account è stato momentaneamente disattivato.

Clicca nel seguente collegamento per riattivarlo:
{ACTIVATIONLINK}

In caso di problemi con l\'attivazione visita {ACTIVATIONLINKWITHOUTCODE} e usa il codice "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: forgot_password
		REALNAME: The real (display) name of the person receiving the reminder.
		REMINDLINK: The link to reset the password.
		IP: The IP address of the requester.
		MEMBERNAME:
	@description:
*/
$txt['forgot_password_subject'] = 'Nuova password per {FORUMNAME}';
$txt['forgot_password_body'] = 'Ciao {REALNAME},
la procedura di recupero della password è stata attivata per il tuo account.
Per impostare una nuova password clicca nel seguente collegamento:
{REMINDLINK}

IP: {IP}
Nome utente {MEMBERNAME}

{REGARDS}';

/**
	@additional_params: send_email
		EMAILSUBJECT: The subject the user wants to email.
		EMAILBODY: The body the user wants to email.
		SENDERNAME: The name of the member sending the email.
		RECPNAME: The name of the person receiving the email.
	@description:
*/
$txt['send_email_subject'] = '{EMAILSUBJECT}';
$txt['send_email_body'] = '{EMAILBODY}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		REPORTERNAME: The name of the person reporting the post.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
		COMMENT: The comment left by the reporter, hopefully to explain why they are reporting the post.
	@description: When a user reports a post this email is sent out to moderators and admins of that board.
*/
$txt['report_to_moderator_subject'] = 'Messaggio segnalato: {TOPICSUBJECT} di {POSTERNAME}';
$txt['report_to_moderator_body'] = 'Il seguente messaggio, "{TOPICSUBJECT}" di {POSTERNAME} è stato segnalato da {REPORTERNAME} nella sezione che tu moderi.

La discussione: {TOPICLINK}

Centro moderazione: {REPORTLINK}

L\'utente che ha effettuato la segnalazione ha inserito il seguente commento:

{COMMENT}

{REGARDS}';

/**
	@additional_params: report_to_moderator
		TOPICSUBJECT: The subject of the reported post.
		POSTERNAME: The reported post's author's name.
		COMMENTERNAME: The name of the person who replied to the report.
		TOPICLINK: The URL of the post that is being reported.
		REPORTLINK: The URL of the moderation center report.
	@description: When a moderator replies to a moderation report, this can be sent to the other moderators who previously replied.
*/
$txt['reply_to_moderator_subject'] = 'Seguito del messaggio segnalato: {TOPICSUBJECT} di {POSTERNAME}';
$txt['reply_to_moderator_body'] = '{COMMENTERNAME} ha aggiunto un nuovo commento alla segnalazione della discussione "{TOPICSUBJECT}".

Per maggiori informazioni visita il forum. 

Discussione: {TOPICLINK} 

Centro moderazione: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		REPORTERNAME: The name of the person reporting the profile
		PROFILELINK: The link to the profile that was reported
		COMMENT: The comment left by the reporter.
 	@description: When a user's profile is reported
*/
$txt['report_member_profile_subject'] = 'Profilo segnalato: {MEMBERNAME}';
$txt['report_member_profile_body'] = 'Il profilo di "{MEMBERNAME}" è stato segnalato da {REPORTERNAME}.

Profilo: {PROFILELINK}

Centro moderazione: {REPORTLINK}

L\'utente che ha effettuato la segnalazione ha aggiunto il seguente commento:

{COMMENT}

{REGARDS}';

/**
	@additional_params: report_user_profile
		MEMBERNAME: The display name of the reported user
		COMMENTERNAME: The name of the person who added the comment
		PROFILELINK: The link to the profile that was reported
 	@description: When someone replies to a report about a profile, this can be sent to others who replied
*/
$txt['reply_to_member_report_subject'] = 'Prosecuzione del profilo utente segnalato: {MEMBERNAME}';
$txt['reply_to_member_report_body'] = '{COMMENTERNAME} ha aggiunto un nuovo commento alla segnalazione del profilo {MEMBERNAME}.

Per maggiori informazioni visita il forum.

Il profilo: {PROFILELINK}

Centro moderazione: {REPORTLINK}

{REGARDS}';

/**
	@additional_params: change_password
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
	@description:
*/
$txt['change_password_subject'] = 'Informazioni nuova password';
$txt['change_password_body'] = 'Ciao {USERNAME},
i dati di accesso a {FORUMNAME} sono stati modificati e la password è stata reimpostata.

Di seguito i tuoi nuovi dati per l\'accesso.

Il tuo nome utente è "{USERNAME}" e la tua password è "{PASSWORD}". 

Puoi cambiarli dopo aver effettuato l\'accesso andando alla pagina del profilo o visitando questa pagina dopo aver effettuato l\'accesso:
{SCRIPTURL}?action=profile

{REGARDS}';

/**
	@additional_params: register_activate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		ACTIVATIONLINK:  The URL link to reactivate the member's account.
		ACTIVATIONLINKWITHOUTCODE: The URL to the page where the activation code can be entered.
		ACTIVATIONCODE:  The code needed to reactivate the member's account.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_activate_subject'] = 'Benvenuto su {FORUMNAME}';
$txt['register_activate_body'] = 'Grazie per esserti registrato su {FORUMNAME}.

Il tuo nome utente è {USERNAME}.

Se dimentichi la password puoi reimpostarla visitando {FORGOTPASSWORDLINK}.

Prima di poter accedere devi attivare il tuo account, clicca nel seguente collegamento:
{ACTIVATIONLINK}

In caso di problemi con l\'attivazione visita {ACTIVATIONLINKWITHOUTCODE} e usa il codice "{ACTIVATIONCODE}".

{REGARDS}';

/**
	@additional_params: register_coppa
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		COPPALINK:  The URL link to the coppa form.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_coppa_subject'] = 'Benvenuto su {FORUMNAME}';
$txt['register_coppa_body'] = 'Grazie per esserti registrato su {FORUMNAME}.

Il tuo nome utente è {USERNAME}. 

Se dimentichi la password puoi reimpostarla visitando {FORGOTPASSWORDLINK}

Prima di poter accedere l\'amministratore richiede il consenso di un genitore/tutore.

Per ulteriori informazioni clicca nel seguente collegamento:
{COPPALINK}

{REGARDS}';

/**
	@additional_params: register_immediate
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_immediate_subject'] = 'Benvenuto su {FORUMNAME}';
$txt['register_immediate_body'] = 'Grazie per esserti registrato su {FORUMNAME}.

Il tuo nome utente è {USERNAME}.

Se dimentichi la password puoi reimpostarla visitando {FORGOTPASSWORDLINK}.

{REGARDS}';

/**
	@additional_params: register_pending
		REALNAME: The display name for the member receiving the email.
		USERNAME: The user name for the member receiving the email.
		PASSWORD: The password for the member.
		FORGOTPASSWORDLINK: The URL to the "forgot password" page.
	@description:
*/
$txt['register_pending_subject'] = 'Benvenuto su {FORUMNAME}';
$txt['register_pending_body'] = 'Ciao {REALNAME},
la tua richiesta di registrazione su {FORUMNAME} è stata ricevuta.

Il tuo nome utente è {USERNAME}.

Se dimentichi la password puoi reimpostarla visitando {FORGOTPASSWORDLINK}.

Prima di poter effettuare l\'accesso ed utilizzare il forum la tua richiesta dovrà essere visionata ed approvata, riceverai un altra email di conferma.

{REGARDS}';

/**
	@additional_params: notification_reply
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_subject'] = 'Risposta alla discussione: {TOPICSUBJECT}';
$txt['notification_reply_body'] = '{POSTERNAME} ha aggiunto una nuova risposta alla discussione che stai seguendo.

Visualizza la risposta:
{TOPICLINK}

Puoi disattivare le notifiche per questa discussione cliccando nel seguente collegamento:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_reply_body
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_subject'] = 'Risposta alla discussione: {TOPICSUBJECT}';
$txt['notification_reply_body_body'] = '{POSTERNAME} ha aggiunto una nuova risposta alla discussione che stai seguendo.

Visualizza la risposta: 
{TOPICLINK}

Puoi disattivare le notifiche per questa discussione cliccando nel seguente collegamento:
{UNSUBSCRIBELINK}

Il testo del messaggio è riportato qui sotto:
{MESSAGE}

{REGARDS}';

/**
	@additional_params: notification_reply_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
	@description:
*/
$txt['notification_reply_once_subject'] = 'Risposta alla discussione: {TOPICSUBJECT}';
$txt['notification_reply_once_body'] = '{POSTERNAME} ha aggiunto una nuova risposta alla discussione che stai seguendo.

Visualizza la risposta:
{TOPICLINK}

Puoi disattivare le notifiche per questa discussione cliccando nel seguente collegamento:
{UNSUBSCRIBELINK}

Potrebbero essere stati inseriti altri messaggi ma non riceverai ulteriori notifiche finché non leggerai la discussione.

{REGARDS}';

/**
	@additional_params: notification_reply_body_once
		TOPICSUBJECT:
		POSTERNAME:
		TOPICLINK:
		UNSUBSCRIBELINK:
		MESSAGE:
	@description:
*/
$txt['notification_reply_body_once_subject'] = 'Risposta alla discussione: {TOPICSUBJECT}';
$txt['notification_reply_body_once_body'] = '{POSTERNAME} ha aggiunto una nuova risposta alla discussione che stai seguendo.

Visualizza la risposta:
{TOPICLINK}

Puoi disattivare le notifiche per questa discussione cliccando nel seguente collegamento:
{UNSUBSCRIBELINK}

Il testo del messaggio è riportato qui sotto:

{MESSAGE}

Potrebbero essere stati inseriti altri messaggi ma non riceverai ulteriori notifiche finché non leggerai la discussione.

{REGARDS}';

/**
	@additional_params: notification_sticky
	@description:
*/
$txt['notification_sticky_subject'] = 'Discussione in evidenza: {TOPICSUBJECT}';
$txt['notification_sticky_body'] = 'Una discussione che stai seguendo è stato messa in evidenza.

Visualizza la discussione:
{TOPICLINK}

Puoi disattivare le notifiche per questa discussione cliccando nel seguente collegamento:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_lock
	@description:
*/
$txt['notification_lock_subject'] = 'Discussione chiusa: {TOPICSUBJECT}';
$txt['notification_lock_body'] = 'Una discussione che stai seguendo è stata chiusa.

Visualizza la discussione:
{TOPICLINK}

Puoi disattivare le notifiche per questa discussione cliccando nel seguente collegamento:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_unlock
	@description:
*/
$txt['notification_unlock_subject'] = 'Discussione sbloccata: {TOPICSUBJECT}';
$txt['notification_unlock_body'] = 'Una discussione che stai seguendo è stata riaperta.

Visualizza la discussione:
{TOPICLINK}

Puoi disattivare le notifiche per questa discussione cliccando nel seguente collegamento:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_remove
	@description:
*/
$txt['notification_remove_subject'] = 'Discussione eliminata: {TOPICSUBJECT}';
$txt['notification_remove_body'] = 'Una discussione che stai seguendo è stata eliminata.

{REGARDS}';

/**
	@additional_params: notification_move
	@description:
*/
$txt['notification_move_subject'] = 'Discussione spostata: {TOPICSUBJECT}';
$txt['notification_move_body'] = 'Una discussione che stai seguendo è stato spostata in un\'altra sezione.

Visualizza la discussione:
{TOPICLINK}

Puoi disattivare le notifiche per questa discussione cliccando nel seguente collegamento:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_merged
	@description:
*/
$txt['notification_merge_subject'] = 'Discussione unita: {TOPICSUBJECT}';
$txt['notification_merge_body'] = 'Una discussione che stai seguendo è stata unita con un altra discussione.

Visualizza la discussione:
{TOPICLINK}

Puoi disattivare le notifiche per questa discussione cliccando nel seguente collegamento:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: notification_split
	@description:
*/
$txt['notification_split_subject'] = 'Discussione divisa: {TOPICSUBJECT}';
$txt['notification_split_body'] = 'Una discussione che stai seguendo è stata divisa in due o più discussioni.

Visualizza la discussione:
{TOPICLINK}

Puoi disattivare le notifiche per questa discussione cliccando nel seguente collegamento:
{UNSUBSCRIBELINK}

{REGARDS}';

/**
	@additional_params: admin_notify
		USERNAME:
		PROFILELINK:
	@description:
*/
$txt['admin_notify_subject'] = 'Un nuovo utente si è iscritto';
$txt['admin_notify_body'] = '{USERNAME} si è appena registrato sul tuo forum.

Clicca nel seguente collegamento per visualizzare il suo profilo.
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: admin_notify_approval
		USERNAME:
		PROFILELINK:
		APPROVALLINK:
	@description:
*/
$txt['admin_notify_approval_subject'] = 'Un nuovo utente si è iscritto';
$txt['admin_notify_approval_body'] = '{USERNAME} si è appena registrato sul tuo forum.

Clicca nel seguente collegamento per visualizzare il suo profilo.
{PROFILELINK}

E\' necessario approvare questo account. Clicca nel seguente collegamento per andare alla schermata di approvazione.
{APPROVALLINK}

{REGARDS}';

/**
	@additional_params: admin_attachments_full
		REALNAME:
	@description:
*/
$txt['admin_attachments_full_subject'] = 'Urgente! La cartella degli allegati è quasi piena';
$txt['admin_attachments_full_body'] = '{REALNAME},
la directory degli allegati su {FORUMNAME} è quasi piena.

Visita il forum per risolvere il problema.
Quando la directory degli allegati raggiunge la dimensione massima consentita gli utenti non potranno più postare allegati o caricare avatars personali (se abilitati).

{REGARDS}';

/**
	@additional_params: paid_subscription_refund
		NAME: Subscription title.
		REALNAME: Recipients name
		REFUNDUSER: Username who took out the subscription.
		REFUNDNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_refund_subject'] = 'Sottoscrizione a pagamento rimborsata';
$txt['paid_subscription_refund_body'] = '{REALNAME},
un utente ha ricevuto un rimborso per una sottoscrizione pagata.

Di seguito i dettagli della sottoscrizione:
Sottoscrizione: {NAME}
Nome utente: {REFUNDNAME} ({REFUNDUSER})
Data: {DATE}

Puoi visualizzare il profilo di questo utente cliccando nel seguente collegamento:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_new
		NAME: Subscription title.
		REALNAME: Recipients name
		SUBEMAIL: Email address of the user who took out the subscription
		SUBUSER: Username who took out the subscription.
		SUBNAME: User's display name who took out the subscription.
		DATE: Today's date.
		PROFILELINK: Link to members profile.
	@description:
*/
$txt['paid_subscription_new_subject'] = 'Nuova sottoscrizione a pagamento';
$txt['paid_subscription_new_body'] = '{REALNAME},
un utente ha sottoscritto un nuovo abbonamento a pagamento.

Di seguito i dettagli della sottoscrizione:
Sottoscrizione: {NAME}
Nome utente: {SUBNAME} ({SUBUSER})
Email utente: {SUBEMAIL}
Prezzo: {PRICE}
Data: {DATE}

Puoi visualizzare il profilo di questo utente cliccando nel seguente collegamento:
{PROFILELINK}

{REGARDS}';

/**
	@additional_params: paid_subscription_error
		ERROR: Error message.
		REALNAME: Recipients name
	@description:
*/
$txt['paid_subscription_error_subject'] = 'Si è verificato un errore con la sottoscrizione a pagamento';
$txt['paid_subscription_error_body'] = 'Ciao {REALNAME},
si è verificato il seguente errore durante l\'elaborazione della sottoscrizione a pagamento:
{ERROR}

{REGARDS}';

/**
	@additional_params: new_pm
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_subject'] = 'Nuovo messaggio privato: {SUBJECT}';
$txt['new_pm_body'] = 'Hai ricevuto un nuovo messaggio privato da parte di {SENDER} su {FORUMNAME}.

IMPORTANTE: ricorda che questa è solo una notifica, non rispondere a questa email.

Leggi il messaggio privato qui: {READLINK}

Rispondi a questo messaggio privato qui: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_subject'] = 'Nuovo messaggio privato: {SUBJECT}';
$txt['new_pm_body_body'] = 'Hai ricevuto un nuovo messaggio privato da parte di {SENDER} su {FORUMNAME}.

IMPORTANTE: ricorda che questa è solo una notifica, non rispondere a questa email.

Il testo del messaggio è riportato qui sotto:

{MESSAGE}

Rispondi a questo messaggio privato:
{REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		READLINK:  The link to directly access the read page.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_tolist_subject'] = 'Nuovo messaggio privato: {SUBJECT}';
$txt['new_pm_tolist_body'] = 'Tu e {TOLIST} avete ricevuto un nuovo messaggio privato da {SENDER} su {FORUMNAME}.

IMPORTANTE: ricorda che questa è solo una notifica, non rispondere a questa email.

Leggi il messaggio privato qui: {READLINK}

Rispondi a questo messaggio privato (solo al mittente) qui: {REPLYLINK}

{REGARDS}';

/**
	@additional_params: new_pm_body_tolist
		SUBJECT: The personal message subject.
		SENDER:  The user name for the member sending the personal message.
		MESSAGE:  The text of the personal message.
		REPLYLINK:  The link to directly access the reply page.
		TOLIST:  The list of users that will receive the personal message.
	@description: A notification email sent to the receivers of a personal message
*/
$txt['new_pm_body_tolist_subject'] = 'Nuovo messaggio privato: {SUBJECT}';
$txt['new_pm_body_tolist_body'] = 'Tu e {TOLIST} avete ricevuto un nuovo messaggio privato da {SENDER} su {FORUMNAME}.

IMPORTANTE: ricorda che questa è solo una notifica, non rispondere a questa email.

Il testo del messaggio è riportato qui sotto:

{MESSAGE}

Rispondi a questo messaggio privato (solo al mittente):
{REPLYLINK}

{REGARDS}';

/**
	@additional_params: msg_quote
		CONTENTSUBJECT: The post subject.
		QUOTENAME:  The user name for the member creating the quote
		MEMBERNAME:  The user name for the member being quoted
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been quoted in a post
 */
$txt['msg_quote_subject'] = 'Sei stato citato nel messaggio: {CONTENTSUBJECT}';
$txt['msg_quote_body'] = 'Ciao {MEMBERNAME},
sei stato citato da {QUOTENAME} nel messaggio "{CONTENTSUBJECT}".

Puoi visualizzare il messaggio cliccando nel seguente collegamento:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: msg_mention
		CONTENTSUBJECT: The post subject.
		MENTIONNAME:  The user name for the member creating the mention
		MEMBERNAME:  The user name for the member being mentioned
		CONTENTLINK:  The post's link
	@description: A notification email sent to the members who've been mentioned in a post
 */
$txt['msg_mention_subject'] = 'Sei stato menzionato nel messaggio: {CONTENTSUBJECT}';
$txt['msg_mention_body'] = 'Ciao {MEMBERNAME},
sei stato menzionato da {MENTIONNAME} nel messaggio "{CONTENTSUBJECT}".

Puoi visualizzare il messaggio cliccando nel seguente collegamento:
{CONTENTLINK}

{REGARDS}';

/**
	@additional_params: happy_birthday
		REALNAME: The real (display) name of the person receiving the birthday message.
	@description: A message sent to members on their birthday.
*/
$txtBirthdayEmails['happy_birthday_subject'] = 'Buon Compleanno da {FORUMNAME}.';
$txtBirthdayEmails['happy_birthday_body'] = 'Ciao {REALNAME},
noi di {FORUMNAME} desideriamo augurarti un buon compleanno.
Possa questo giorno e l\'anno a venire essere pieno di gioia.

{REGARDS}';
$txtBirthdayEmails['happy_birthday_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=2676">Thantos</a>';

$txtBirthdayEmails['karlbenson1_subject'] = 'Per il tuo Compleanno...';
$txtBirthdayEmails['karlbenson1_body'] = 'Avremmo potuto mandarti una cartolina d\'auguri. Avremmo potuto mandarti alcuni fiori o una torta.
Ma non lo abbiamo fatto. Avremmo potuto mandarti uno di quei messaggi generati automaticamente per augurarti un buon compleanno senza dover nemmeno modificare la stringa INSERT_NAME.
Ma non lo abbiamo fatto, abbiamo scritto questo messaggio di auguri proprio per te.

Ti auguriamo un compleanno veramente speciale.

{REGARDS}

//:: Questo messaggio è stato generato automaticamente :://';
$txtBirthdayEmails['karlbenson1_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

$txtBirthdayEmails['nite0859_subject'] = 'Buon Compleanno!';
$txtBirthdayEmails['nite0859_body'] = 'Ciao {REALNAME},
i tuoi amici di {FORUMNAME} vorrebbero augurarti un buon compleanno.
Se non lo hai fatto di recente, visita il nostro sito per dare agli utenti la possibilità di offrirti i loro sinceri auguri.
Anche se oggi è il tuo compleanno, {REALNAME}, vorremmo ricordarti che la tua iscrizione al nostro sito è stato il tuo regalo più grande per noi.

I migliori auguri, lo staff di {FORUMNAME}';
$txtBirthdayEmails['nite0859_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=46625">nite0859</a>';

$txtBirthdayEmails['zwaldowski_subject'] = 'Auguri di Compleanno a {REALNAME}';
$txtBirthdayEmails['zwaldowski_body'] = 'Ciao {REALNAME},
un altro anno della tua vita è passato. Noi di {FORUMNAME} speriamo sia stato pieno di gioia e ti auguriamo tanta fortuna per quello a venire.

{REGARDS}';
$txtBirthdayEmails['zwaldowski_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=72038">zwaldowski</a>';

$txtBirthdayEmails['geezmo_subject'] = 'Buon Compleanno {REALNAME}!';
$txtBirthdayEmails['geezmo_body'] = 'Sai chi compie gli anni oggi, {REALNAME}?
Noi sì... TU! Buon compleanno!
Ora sei più vecchio di un anno ma speriamo che tu sia molto più felice dell\'anno scorso.

Divertiti oggi, {REALNAME}! - Saluti da {FORUMNAME}';
$txtBirthdayEmails['geezmo_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=48671">geezmo</a>';

$txtBirthdayEmails['karlbenson2_subject'] = 'Auguri di Buon Compleanno';
$txtBirthdayEmails['karlbenson2_body'] = 'Speriamo che tu possa ricevere una buona torta ma soprattutto tanto divertimento, ricordati di raccontarci cosa hai fatto.

Ti salutiamo con la speranza che questo messaggio ti abbia fatto sorridere, ci rivediamo il prossimo anno.

{REGARDS}';
$txtBirthdayEmails['karlbenson2_author'] = '<a href="https://www.simplemachines.org/community/?action=profile;u=63186">karlbenson</a>';

?>