import "./helpers/common-functions";

// Load components
import { SettingTabsControl } from "./components/setting-tabs-control";
import { RadioControl } from "./components/radio";
import { ColorControl } from "./components/color";
import { PaddingControl } from "./components/padding";
import { TypoControl } from "./components/typography";
import { SpinnerControl } from "./components/spinner";
import { SliderControl } from "./components/slider";
import { CheckboxControl } from "./components/checkbox";
import { SelectControl } from "./components/select";
import { BoxShadowControl } from "./components/box-shadow";
import { ImageControl } from "./components/image";
import { DimensionControl } from "./components/dimension";
import { GradientControl } from "./components/gradient";
import { RichTextControl } from "./components/rich_text";
import { IconControl } from "./components/icon";
import { CustomLinkControl } from "./components/link";
import { MediaControl } from "./components/media";
import { MultiImageControl } from "./components/multi-image";
import { TextShadowControl } from "./components/text-shadow";
import { DateTimeControl } from "./components/datetime";
import { MultiSelectControl } from "./components/multiselect";
import { FontFamilyControl } from "./components/font_family";
import { TextareaControl } from "./components/textarea";
import { FilterControl } from "./components/filter";
import { AccessControl } from "./components/access";
import { ModalControl } from "./components/modal";

// Register blogs
import "./helpers/register-blocks";

// Blobks components
import { RenderRowBlock } from "./blocks/row";
import { RenderColBlock } from "./blocks/col";
import { RenderQuoteBlock } from "./blocks/quote";
import { RenderTabsBlock } from "./blocks/tabs";
import { RenderGroupBlock } from "./blocks/render-group";
import { RenderVideoBlock } from "./blocks/video";
import { RenderImageSliderBlock } from "./blocks/image_slider";
import { RenderTestimonialSliderBlock } from "./blocks/testimonial_slider";
import { RenderReviewSliderBlock } from "./blocks/review_slider";
import { RenderVideoSliderBlock } from "./blocks/video_slider";
import { RenderSlidesBlock } from "./blocks/slides";
import { RenderFacebookButton } from "./blocks/facebook_button";
import { RenderPostsBlock } from "./blocks/posts";
import { RenderPostsFolioBlock } from "./blocks/post_folio";
import { RenderSitemapItem } from "./blocks/sitemap_item";
import { RenderPrimaryMenuBlock } from "./blocks/primary_menu";
import { RenderArchivePostsBlock } from "./blocks/archive-posts";

wp.PagelayerComponents = {
	setting_tabs: SettingTabsControl,
	radio: RadioControl,
	color: ColorControl,
	padding: PaddingControl,
	typography: TypoControl,
	spinner: SpinnerControl,
	slider: SliderControl,
	checkbox: CheckboxControl,
	select: SelectControl,
	box_shadow: BoxShadowControl,
	image: ImageControl,
	dimension: DimensionControl,
	gradient: GradientControl,
	rich_text: RichTextControl,
	icon: IconControl,
	link: CustomLinkControl,
	video: MediaControl,
	audio: MediaControl,
	media: MediaControl,
	multi_image: MultiImageControl,
	shadow: TextShadowControl,
	datetime: DateTimeControl,
	multiselect: MultiSelectControl,
	font_family: FontFamilyControl,
	textarea: TextareaControl,
	filter: FilterControl,
	access: AccessControl,
	modal: ModalControl,
	menus: SelectControl,
};

// Store Blocks components
// Name of PagelayerBlocks array key as per PHP sc name
wp.PagelayerBlocks = {
	row: RenderRowBlock,
	col: RenderColBlock,
	quote: RenderQuoteBlock,
	tabs: RenderTabsBlock,
	video: RenderVideoBlock,
	image_slider: RenderImageSliderBlock,
	testimonial_slider: RenderTestimonialSliderBlock,
	review_slider: RenderReviewSliderBlock,
	video_slider: RenderVideoSliderBlock,
	slides: RenderSlidesBlock,
	fb_btn: RenderFacebookButton,
	posts: RenderPostsBlock,
	post_folio: RenderPostsFolioBlock,
	sitemap_item: RenderSitemapItem,
	wp_menu: RenderPrimaryMenuBlock,
	archive_posts: RenderArchivePostsBlock,
	
	// Group rendring
	addGroupBlock: RenderGroupBlock,
};