import { useState, useEffect } from '@wordpress/element';

export const SettingTabsControl = (props) =>{
	
	const [activeTab, setActiveTab] = useState('settings');
	
	const tabChanged = (tab) => {
		setActiveTab(tab);	
	}
	
	useEffect(() => {
		tabChanged(activeTab);
		var componentsPanel = document.querySelector('.components-panel');
		
		componentsPanel.setAttribute('pagelayer-component-tab', activeTab);
		return () => {
			componentsPanel.removeAttribute('pagelayer-component-tab');
		}
	}, [activeTab]);
	
	// Toggle panels handler
	useEffect(() => {
		// Default open tab
		var tabs = document.querySelectorAll(`.pagelayer-components-tabs`);
		
		tabs.forEach((tab) =>{
			var currentOpened = tab.querySelectorAll(`.pagelayer-panel__body.is-opened`);
			var firstChild = tab.querySelector('.pagelayer-panel__body');
			if(currentOpened.length < 1 && firstChild){
				firstChild.querySelector('.components-button').click();
			}
		});
		
		// Panels click handler
		jQuery(document).on('mouseup.components_toggle_panel', '.components-panel__body', function(){
			var pEle = jQuery(this);
			var sPanel = pEle.closest('.pl-settings');
			var selector = sPanel.length > 0 ? '.pl-settings' : ':not(.pl-settings)';

			var openedPanels = jQuery(selector).find('.components-panel__body.is-opened').not(pEle);
			openedPanels.find('.components-button').click()
		});
		
		return (() => {
			jQuery(document).unbind('mouseup.components_toggle_panel');
		})
	}, []);
	
	return (
		<div className="pagelayer-setting-tabs">
			<button className={`pagelayer-setting-tab ${activeTab == 'settings' ? 'is-active': ''}`} onClick={() => tabChanged('settings')}> 
				<i className="fas fa-paint-brush"></i>
				Settings
			</button>
			<button className={`pagelayer-setting-tab ${activeTab == 'options' ? 'is-active': ''}`} onClick={() => tabChanged('options')}>
				<i className="pli pli-service"></i>
				Options
			</button>
		</div>
	);
}