import { LabelControl } from './label';

export const DateTimeControl = (props) => {
    
	const { prop, value, setAttributes } = props;
    const { name } = prop['c'];
	
    return (
        <div className="components-base-control pagelayer-base-control">
            <div className='pagelayer-form-item' pagelayer-elp-name={name}>
                <div className='pagelayer-elp-label-div' type={props.prop.type}>
                    <LabelControl {...props} />
                </div>
                <div className='pagelayer-elp-datetime-div'>
                    <input
                        className="pagelayer-elp-shadow-input"
                        type="date"
                        name={name}
                        value={value}
                        style={{ width: "100%" }}
                        onChange={(e) => setAttributes({ [name]: e.target.value })}
                    />
                </div>

            </div>

        </div>
    );

}