import { useEffect, useRef } from '@wordpress/element';
import { select, dispatch } from '@wordpress/data';
import { useBlockProps, InnerBlocks, RichText } from '@wordpress/block-editor';
import { RenderGroupBlock } from "./render-group";

export const RenderTabsBlock = (props) =>{
	
	const { _props, pl_props, tag, data } = props;
	const { setAttributes, clientId } = _props;
	const { id, atts: attributes } = data;
	const holderRef = useRef(null);
	
	const { getBlocks } = select("core/block-editor");
	const childBlocks = getBlocks(clientId);

	// Update title
	const setTabTitle = (blockClientId, newValue) =>{
		dispatch('core/block-editor').updateBlockAttributes(blockClientId, { title: newValue });
	}
	
	// Tabs click Handler
	const onClickTabHandler = (e) => {

		var jEle = jQuery(e.target).closest('.pagelayer-tablinks')
		var clientId = jEle.attr('client_id');
		
		// Remove all Active tabs
		jEle.parent().find('.pagelayer-tablinks').removeClass('active');
		jEle.addClass("active");
		
		var blockEle = pagelayer_query("#block-"+clientId);
		// Show tabs panel
		blockEle.parent().children().each(function(){
			jQuery(this).children('.pagelayer-tab').hide();
		});
		
		blockEle.children('.pagelayer-tab').show();
	}
	
	useEffect(()=> {
		var tabsHolder = jQuery(holderRef.current);
		var default_active = tabsHolder.find('[default_active="true"]');
		
		setTimeout( () => {
			// Set the default tab
			if(default_active.length > 0){
				default_active.last()[0].click();
			// Set the first tab as active
			}else if( 
				tabsHolder.find('.pagelayer-tablinks').length > 0
			){
				tabsHolder.find('.pagelayer-tablinks')[0].click();
			}
		}, 100);
	}, []);
	
	var pagelayer_tab_timer = null;
	useEffect(()=> {
		
		var children = jQuery(holderRef.current).children();
		
		// Are we to rotate
		if(attributes.rotate > 0){
			
			var i= 0;
			pagelayer_tab_timer = setInterval(function () {
				
				if(i >= children.length){
					i = 0;
				}
				
				jQuery(children[i])[0].click();
				
				i++;
		   
			}, attributes.rotate);
		}else{
			clearInterval(pagelayer_tab_timer);
		}
		
		// Clean up the interval when the component unmounts
		return () => {
			clearInterval(pagelayer_tab_timer);
		};
	}, [attributes?.rotate]);

	var eleProps = {
		plTag: 'pl_'+tag,
		_props: _props,
	}

	return (
		<>
			<div className="pagelayer-tabs-holder" ref={holderRef}>
			{childBlocks.map((block) => (
				<span
					tab-id={block.attributes['pagelayer-id']} 
					className="pagelayer-tablinks"
					client_id={block.clientId}
					onClick={onClickTabHandler}
					default_active={block.attributes?.default_active}
				>
					<i className={block.attributes?.tab_icon}></i> 
					<RichText
						key="editable"
						tagName="span"
						keepPlaceholderOnFocus
						placeholder={'Add Tab Title...'}
						onChange={(value) => setTabTitle(block.clientId, value)}
						onClick={onClickTabHandler}
						value={block.attributes?.title}
					/>
				</span>
			))}
			</div>
			<div className="pagelayer-tabcontainer">
				<RenderGroupBlock { ...eleProps } />
			</div>
		</>
	);
}
