<?php
/**
 * Show error messages
 *
 * This template can be overridden by copying it to yourtheme/kkart/notices/error.php.
 *
 * HOWEVER, on occasion Kkart will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.kkart.com/document/template-structure/
 * @package Kkart\Templates
 * @version 3.9.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! $notices ) {
	return;
}

?>
<ul class="kkart-error" role="alert">
	<?php foreach ( $notices as $notice ) : ?>
		<li<?php echo kkart_get_notice_data_attr( $notice ); ?>>
			<?php echo kkart_kses_notice( $notice['notice'] ); ?>
		</li>
	<?php endforeach; ?>
</ul>
