<?php
/**
 * Lost password form
 *
 * This template can be overridden by copying it to yourtheme/kkart/myaccount/form-lost-password.php.
 *
 * HOWEVER, on occasion Kkart will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.kkart.com/document/template-structure/
 * @package Kkart\Templates
 * @version 3.5.2
 */

defined( 'ABSPATH' ) || exit;

do_action( 'kkart_before_lost_password_form' );
?>

<form method="post" class="kkart-ResetPassword lost_reset_password">

	<p><?php echo apply_filters( 'kkart_lost_password_message', esc_html__( 'Lost your password? Please enter your username or email address. You will receive a link to create a new password via email.', 'kkart' ) ); ?></p><?php // @codingStandardsIgnoreLine ?>

	<p class="kkart-form-row kkart-form-row--first form-row form-row-first">
		<label for="user_login"><?php esc_html_e( 'Username or email', 'kkart' ); ?></label>
		<input class="kkart-Input kkart-Input--text input-text" type="text" name="user_login" id="user_login" autocomplete="username" />
	</p>

	<div class="clear"></div>

	<?php do_action( 'kkart_lostpassword_form' ); ?>

	<p class="kkart-form-row form-row">
		<input type="hidden" name="kkart_reset_password" value="true" />
		<button type="submit" class="kkart-Button button" value="<?php esc_attr_e( 'Reset password', 'kkart' ); ?>"><?php esc_html_e( 'Reset password', 'kkart' ); ?></button>
	</p>

	<?php wp_nonce_field( 'lost_password', 'kkart-lost-password-nonce' ); ?>

</form>
<?php
do_action( 'kkart_after_lost_password_form' );
