<?php
/**
 * Downloads
 *
 * Shows downloads on the account page.
 *
 * This template can be overridden by copying it to yourtheme/kkart/myaccount/downloads.php.
 *
 * HOWEVER, on occasion Kkart will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.kkart.com/document/template-structure/
 * @package Kkart\Templates
 * @version 3.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$downloads     = KKART()->customer->get_downloadable_products();
$has_downloads = (bool) $downloads;

do_action( 'kkart_before_account_downloads', $has_downloads ); ?>

<?php if ( $has_downloads ) : ?>

	<?php do_action( 'kkart_before_available_downloads' ); ?>

	<?php do_action( 'kkart_available_downloads', $downloads ); ?>

	<?php do_action( 'kkart_after_available_downloads' ); ?>

<?php else : ?>
	<div class="kkart-Message kkart-Message--info kkart-info">
		<a class="kkart-Button button" href="<?php echo esc_url( apply_filters( 'kkart_return_to_shop_redirect', kkart_get_page_permalink( 'shop' ) ) ); ?>">
			<?php esc_html_e( 'Browse products', 'kkart' ); ?>
		</a>
		<?php esc_html_e( 'No downloads available yet.', 'kkart' ); ?>
	</div>
<?php endif; ?>

<?php do_action( 'kkart_after_account_downloads', $has_downloads ); ?>
