<?php
/**
 * Auth form grant access
 *
 * This template can be overridden by copying it to yourtheme/kkart/auth/form-grant-access.php.
 *
 * HOWEVER, on occasion Kkart will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.kkart.com/document/template-structure/
 * @package Kkart\Templates\Auth
 * @version 4.3.0
 */

defined( 'ABSPATH' ) || exit;
?>

<?php do_action( 'kkart_auth_page_header' ); ?>

<h1>
	<?php
	/* Translators: %s App name. */
	printf( esc_html__( '%s would like to connect to your store', 'kkart' ), esc_html( $app_name ) );
	?>
</h1>

<?php kkart_print_notices(); ?>

<p>
	<?php
	/* Translators: %1$s App name, %2$s scope. */
	printf( esc_html__( 'This will give "%1$s" %2$s access which will allow it to:', 'kkart' ), '<strong>' . esc_html( $app_name ) . '</strong>', '<strong>' . esc_html( $scope ) . '</strong>' );
	?>
</p>

<ul class="kkart-auth-permissions">
	<?php foreach ( $permissions as $permission ) : ?>
		<li><?php echo esc_html( $permission ); ?></li>
	<?php endforeach; ?>
</ul>

<div class="kkart-auth-logged-in-as">
	<?php echo get_avatar( $user->ID, 70 ); ?>
	<p>
		<?php
		/* Translators: %s display name. */
		printf( esc_html__( 'Logged in as %s', 'kkart' ), esc_html( $user->display_name ) );
		?>
		<a href="<?php echo esc_url( $logout_url ); ?>" class="kkart-auth-logout"><?php esc_html_e( 'Logout', 'kkart' ); ?></a>
	</p>
</div>

<p class="kkart-auth-actions">
	<a href="<?php echo esc_url( $granted_url ); ?>" class="button button-primary kkart-auth-approve"><?php esc_html_e( 'Approve', 'kkart' ); ?></a>
	<a href="<?php echo esc_url( $return_url ); ?>" class="button kkart-auth-deny"><?php esc_html_e( 'Deny', 'kkart' ); ?></a>
</p>

<?php do_action( 'kkart_auth_page_footer' ); ?>
