/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { Fragment } from '@wordpress/element';
import PropTypes from 'prop-types';
import { ToggleControl } from '@wordpress/components';

/**
 * A combination of toggle controls for content visibility in product grids.
 *
 * @param {Object} props Incoming props for the component.
 * @param {function(any):any} props.onChange
 * @param {Object} props.settings
 */
const GridContentControl = ( { onChange, settings } ) => {
	const { button, price, rating, title } = settings;
	return (
		<Fragment>
			<ToggleControl
				label={ __( 'Product title', 'kkart' ) }
				help={
					title
						? __(
								'Product title is visible.',
								'kkart'
						  )
						: __(
								'Product title is hidden.',
								'kkart'
						  )
				}
				checked={ title }
				onChange={ () => onChange( { ...settings, title: ! title } ) }
			/>
			<ToggleControl
				label={ __( 'Product price', 'kkart' ) }
				help={
					price
						? __(
								'Product price is visible.',
								'kkart'
						  )
						: __(
								'Product price is hidden.',
								'kkart'
						  )
				}
				checked={ price }
				onChange={ () => onChange( { ...settings, price: ! price } ) }
			/>
			<ToggleControl
				label={ __( 'Product rating', 'kkart' ) }
				help={
					rating
						? __(
								'Product rating is visible.',
								'kkart'
						  )
						: __(
								'Product rating is hidden.',
								'kkart'
						  )
				}
				checked={ rating }
				onChange={ () => onChange( { ...settings, rating: ! rating } ) }
			/>
			<ToggleControl
				label={ __(
					'Add to Cart button',
					'kkart'
				) }
				help={
					button
						? __(
								'Add to Cart button is visible.',
								'kkart'
						  )
						: __(
								'Add to Cart button is hidden.',
								'kkart'
						  )
				}
				checked={ button }
				onChange={ () => onChange( { ...settings, button: ! button } ) }
			/>
		</Fragment>
	);
};

GridContentControl.propTypes = {
	/**
	 * The current title visibility.
	 */
	settings: PropTypes.shape( {
		button: PropTypes.bool.isRequired,
		price: PropTypes.bool.isRequired,
		rating: PropTypes.bool.isRequired,
		title: PropTypes.bool.isRequired,
	} ).isRequired,
	/**
	 * Callback to update the layout settings.
	 */
	onChange: PropTypes.func.isRequired,
};

export default GridContentControl;
