/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { FormStep } from '@kkart/base-components/cart-checkout';
import {
	useCheckoutContext,
	StoreNoticesProvider,
} from '@kkart/base-context';
import {
	useEmitResponse,
	usePaymentMethods,
	useStoreCart,
} from '@kkart/base-hooks';
import { PaymentMethods } from '@kkart/base-components/payment-methods';

const PaymentMethodStep = () => {
	const { isProcessing: checkoutIsProcessing } = useCheckoutContext();
	const { cartNeedsPayment } = useStoreCart();
	const { paymentMethods } = usePaymentMethods();
	const { noticeContexts } = useEmitResponse();

	if ( ! cartNeedsPayment ) {
		return null;
	}

	return (
		<FormStep
			id="payment-method"
			disabled={ checkoutIsProcessing }
			className="kkart-block-checkout__payment-method"
			title={ __( 'Payment method', 'kkart' ) }
			description={
				Object.keys( paymentMethods ).length > 1
					? __(
							'Select a payment method below.',
							'kkart'
					  )
					: ''
			}
		>
			<StoreNoticesProvider context={ noticeContexts.PAYMENTS }>
				<PaymentMethods />
			</StoreNoticesProvider>
		</FormStep>
	);
};

export default PaymentMethodStep;
