/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { CHECKOUT_SHOW_LOGIN_REMINDER } from '@kkart/block-settings';
import { useCheckoutContext } from '@kkart/base-context';

/**
 * Internal dependencies
 */
import { LOGIN_TO_CHECKOUT_URL } from '../utils';

const LoginPrompt = () => {
	const { customerId } = useCheckoutContext();

	if ( ! CHECKOUT_SHOW_LOGIN_REMINDER || customerId ) {
		return null;
	}

	return (
		<>
			{ __(
				'Already have an account? ',
				'kkart'
			) }
			<a href={ LOGIN_TO_CHECKOUT_URL }>
				{ __( 'Log in.', 'kkart' ) }
			</a>
		</>
	);
};

export default LoginPrompt;
