/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import {
	useEmitResponse,
	useExpressPaymentMethods,
} from '@kkart/base-hooks';
import {
	StoreNoticesProvider,
	useEditorContext,
} from '@kkart/base-context';
import Title from '@kkart/base-components/title';
import { CURRENT_USER_IS_ADMIN } from '@kkart/block-settings';

/**
 * Internal dependencies
 */
import ExpressPaymentMethods from '../express-payment-methods';
import './style.scss';

const CheckoutExpressPayment = () => {
	const { paymentMethods, isInitialized } = useExpressPaymentMethods();
	const { isEditor } = useEditorContext();
	const { noticeContexts } = useEmitResponse();

	if (
		! isInitialized ||
		( isInitialized && Object.keys( paymentMethods ).length === 0 )
	) {
		// Make sure errors are shown in the editor and for admins. For example,
		// when a payment method fails to register.
		if ( isEditor || CURRENT_USER_IS_ADMIN ) {
			return (
				<StoreNoticesProvider
					context={ noticeContexts.EXPRESS_PAYMENTS }
				></StoreNoticesProvider>
			);
		}
		return null;
	}

	return (
		<>
			<div className="kkart-block-components-express-payment kkart-block-components-express-payment--checkout">
				<div className="kkart-block-components-express-payment__title-container">
					<Title
						className="kkart-block-components-express-payment__title"
						headingLevel="2"
					>
						{ __(
							'Express checkout',
							'kkart'
						) }
					</Title>
				</div>
				<div className="kkart-block-components-express-payment__content">
					<StoreNoticesProvider
						context={ noticeContexts.EXPRESS_PAYMENTS }
					>
						<p>
							{ __(
								'In a hurry? Use one of our express checkout options below:',
								'kkart'
							) }
						</p>
						<ExpressPaymentMethods />
					</StoreNoticesProvider>
				</div>
			</div>
			<div className="kkart-block-components-express-payment-continue-rule kkart-block-components-express-payment-continue-rule--checkout">
				{ __( 'Or continue below', 'kkart' ) }
			</div>
		</>
	);
};

export default CheckoutExpressPayment;
