<?php
/**
 * Kkart Admin Performance on mobile note.
 *
 * Adds a note to download the mobile app, performance on mobile.
 */

namespace Automattic\Kkart\Admin\Notes;

defined( 'ABSPATH' ) || exit;

/**
 * Performance_On_Mobile
 */
class PerformanceOnMobile {
	/**
	 * Note traits.
	 */
	use NoteTraits;

	/**
	 * Name of the note for use in the database.
	 */
	const NOTE_NAME = 'kkart-admin-performance-on-mobile';

	/**
	 * Get the note.
	 *
	 * @return Note
	 */
	public static function get_note() {
		// Only add this note if this store is at least 9 months old.
		$nine_months_in_seconds = MONTH_IN_SECONDS * 9;
		if ( ! self::kkart_admin_active_for( $nine_months_in_seconds ) ) {
			return;
		}

		// Check that the previous mobile app notes have not been actioned.
		if ( MobileApp::has_note_been_actioned() ) {
			return;
		}
		if ( RealTimeOrderAlerts::has_note_been_actioned() ) {
			return;
		}
		if ( ManageOrdersOnTheGo::has_note_been_actioned() ) {
			return;
		}

		$note = new Note();

		$note->set_title( __( 'Track your store performance on mobile', 'kkart' ) );
		$note->set_content( __( 'Monitor your sales and high performing products with the Woo app.', 'kkart' ) );
		$note->set_content_data( (object) array() );
		$note->set_type( Note::E_KKART_ADMIN_NOTE_INFORMATIONAL );
		$note->set_name( self::NOTE_NAME );
		$note->set_source( 'kkart-admin' );
		$note->add_action(
			'learn-more',
			__( 'Learn more', 'kkart' ),
			'https://kkart.com/mobile/?utm_source=inbox'
		);

		return $note;
	}
}
