<?php
/**
 * Kkart Admin: Insight - First sale
 *
 * Adds a note to give insight about the first sale.
 *
 * @package Kkart\Admin
 */

namespace Automattic\Kkart\Admin\Notes;

defined( 'ABSPATH' ) || exit;

/**
 * Insight_First_Sale.
 */
class InsightFirstSale {
	/**
	 * Note traits.
	 */
	use NoteTraits;

	/**
	 * Name of the note for use in the database.
	 */
	const NOTE_NAME = 'kkart-admin-insight-first-sale';

	/**
	 * Get the note.
	 *
	 * @return Note
	 */
	public static function get_note() {
		// We want to show the note after eight days.
		if ( ! self::kkart_admin_active_for( 8 * DAY_IN_SECONDS ) ) {
			return;
		}

		$note = new Note();
		$note->set_title( __( 'Did you know?', 'kkart' ) );
		$note->set_content( __( 'A Kkart powered store needs on average 31 days to get the first sale. You\'re on the right track! Do you find this type of insight useful?', 'kkart' ) );
		$note->set_type( Note::E_KKART_ADMIN_NOTE_SURVEY );
		$note->set_name( self::NOTE_NAME );
		$note->set_content_data( (object) array() );
		$note->set_source( 'kkart-admin' );

		// Note that there is no corresponding function called in response to
		// this. Apart from setting the note to actioned a tracks event is
		// sent in NoteActions.
		$note->add_action(
			'affirm-insight-first-sale',
			__( 'Yes', 'kkart' ),
			false,
			Note::E_KKART_ADMIN_NOTE_ACTIONED,
			false,
			__( 'Thanks for your feedback', 'kkart' )
		);
		$note->add_action(
			'deny-insight-first-sale',
			__( 'No', 'kkart' ),
			false,
			Note::E_KKART_ADMIN_NOTE_ACTIONED,
			false,
			__( 'Thanks for your feedback', 'kkart' )
		);

		return $note;
	}
}
