<?php
/**
 * Kkart Admin (Dashboard) Giving feedback notes provider
 *
 * Adds notes to the merchant's inbox about giving feedback.
 */

namespace Automattic\Kkart\Admin\Notes;

defined( 'ABSPATH' ) || exit;

/**
 * Giving_Feedback_Notes
 */
class GivingFeedbackNotes {
	/**
	 * Note traits.
	 */
	use NoteTraits;

	/**
	 * Name of the note for use in the database.
	 */
	const NOTE_NAME = 'kkart-admin-store-notice-giving-feedback-2';

	/**
	 * Get the note.
	 *
	 * @return Note
	 */
	protected static function get_note() {
		// We need to show Admin Giving feeback notification after 8 days of install.
		$eight_days_in_seconds = 8 * DAY_IN_SECONDS;
		if ( ! self::kkart_admin_active_for( $eight_days_in_seconds ) ) {
			return;
		}

		// Otherwise, create our new note.
		$note = new Note();
		$note->set_title( __( 'Give feedback', 'kkart' ) );
		$note->set_content( __( 'Now that you’ve chosen us as a partner, our goal is to make sure we\'re providing the right tools to meet your needs. We\'re looking forward to having your feedback on the store setup experience so we can improve it in the future.', 'kkart' ) );
		$note->set_content_data( (object) array() );
		$note->set_type( Note::E_KKART_ADMIN_NOTE_INFORMATIONAL );
		$note->set_name( self::NOTE_NAME );
		$note->set_source( 'kkart-admin' );
		$note->add_action(
			'share-feedback',
			__( 'Share feedback', 'kkart' ),
			'https://automattic.survey.fm/new-onboarding-survey'
		);
		return $note;
	}
}
