<?php
/**
 * Kkart Admin: Confirm tax settings
 *
 * Adds a note to ask the user to confirm tax settings after automated taxes
 * has been automatically enabled (see OnboardingAutomateTaxes).
 */

namespace Automattic\Kkart\Admin\Notes;

defined( 'ABSPATH' ) || exit;

/**
 * ConfirmTaxSettings.
 */
class ConfirmTaxSettings {
	/**
	 * Note traits.
	 */
	use NoteTraits;

	/**
	 * Name of the note for use in the database.
	 */
	const NOTE_NAME = 'kkart-admin-confirm-tax-settings';

	/**
	 * Get the note.
	 *
	 * @return Note
	 */
	public static function get_note() {
		$note = new Note();

		$note->set_title( __( 'Confirm tax settings', 'kkart' ) );
		$note->set_content( __( 'Automated tax calculations are enabled on your store through Kkart Shipping & Tax. Learn more about automated taxes <a href="https://docs.kkart.com/document/kkart-services/#section-12">here</a>.', 'kkart' ) );
		$note->set_source( 'kkart-admin' );
		$note->add_action(
			'confirm-tax-settings_edit-tax-settings',
			__( 'Edit tax settings', 'kkart' ),
			admin_url( 'admin.php?page=kkart-settings&tab=tax' ),
			Note::E_KKART_ADMIN_NOTE_UNACTIONED,
			true
		);

		return $note;
	}
}
