<?php
/**
 * Twenty Twenty One support.
 *
 * @since   4.7.0
 * @package Kkart\Classes
 */

use Automattic\Jetpack\Constants;

defined( 'ABSPATH' ) || exit;

/**
 * KKART_Twenty_Twenty_One class.
 */
class KKART_Twenty_Twenty_One {

	/**
	 * Theme init.
	 */
	public static function init() {

		// Change Kkart wrappers.
		remove_action( 'kkart_before_main_content', 'kkart_output_content_wrapper', 10 );
		remove_action( 'kkart_after_main_content', 'kkart_output_content_wrapper_end', 10 );

		add_action( 'kkart_before_main_content', array( __CLASS__, 'output_content_wrapper' ), 10 );
		add_action( 'kkart_after_main_content', array( __CLASS__, 'output_content_wrapper_end' ), 10 );

		// This theme doesn't have a traditional sidebar.
		remove_action( 'kkart_sidebar', 'kkart_get_sidebar', 10 );

		// Enqueue theme compatibility styles.
		add_filter( 'kkart_enqueue_styles', array( __CLASS__, 'enqueue_styles' ) );

		// Enqueue wp-admin compatibility styles.
		add_action( 'admin_enqueue_scripts', array( __CLASS__ , 'enqueue_admin_styles' ) );

		// Register theme features.
		add_theme_support( 'kkart-product-gallery-zoom' );
		add_theme_support( 'kkart-product-gallery-lightbox' );
		add_theme_support( 'kkart-product-gallery-slider' );
		add_theme_support(
			'kkart',
			array(
				'thumbnail_image_width' => 450,
				'single_image_width'    => 600,
			)
		);

	}

	/**
	 * Open the Twenty Twenty One wrapper.
	 */
	public static function output_content_wrapper() {
		echo '<section id="primary" class="content-area">';
		echo '<main id="main" class="site-main">';
	}

	/**
	 * Close the Twenty Twenty One wrapper.
	 */
	public static function output_content_wrapper_end() {
		echo '</main>';
		echo '</section>';
	}

	/**
	 * Enqueue CSS for this theme.
	 *
	 * @param  array $styles Array of registered styles.
	 * @return array
	 */
	public static function enqueue_styles( $styles ) {
		unset( $styles['kkart-general'] );

		$styles['kkart-general'] = array(
			'src'     => str_replace( array( 'http:', 'https:' ), '', KKART()->plugin_url() ) . '/assets/css/twenty-twenty-one.css',
			'deps'    => '',
			'version' => Constants::get_constant( 'KKART_VERSION' ),
			'media'   => 'all',
			'has_rtl' => true,
		);

		return apply_filters( 'kkart_twenty_twenty_one_styles', $styles );
	}

	/**
	 * Enqueue the wp-admin CSS overrides for this theme.
	 */
	public static function enqueue_admin_styles() {
		wp_enqueue_style(
			'kkart-twenty-twenty-one-admin',
			str_replace( array( 'http:', 'https:' ), '', KKART()->plugin_url() ) . '/assets/css/twenty-twenty-one-admin.css',
			'',
			Constants::get_constant( 'KKART_VERSION' ),
			'all'
		);
	}


}

KKART_Twenty_Twenty_One::init();
