<?php
/**
 * Admin View: Notice - Secure connection.
 *
 * @package Kkart\Admin\Notices
 */

defined( 'ABSPATH' ) || exit;

?>
<div id="message" class="updated kkart-message">
	<a class="kkart-message-close notice-dismiss" href="<?php echo esc_url( wp_nonce_url( add_query_arg( 'kkart-hide-notice', 'no_secure_connection' ), 'kkart_hide_notices_nonce', '_kkart_notice_nonce' ) ); ?>"><?php esc_html_e( 'Dismiss', 'kkart' ); ?></a>

	<p>
	<?php
		echo wp_kses_post( sprintf(
			/* translators: %s: documentation URL */
			__( 'Your store does not appear to be using a secure connection. We highly recommend serving your entire website over an HTTPS connection to help keep customer data secure. <a href="%s">Learn more here.</a>', 'kkart' ),
			'https://docs.kkart.com/document/ssl-and-https/'
		) );
	?>
	</p>
</div>
