<?php
/**
 * Kkart Settings Page/Tab
 *
 * @author      WooThemes
 * @category    Admin
 * @package     Kkart\Admin
 * @version     2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'KKART_Settings_Page', false ) ) :

	/**
	 * KKART_Settings_Page.
	 */
	abstract class KKART_Settings_Page {

		/**
		 * Setting page id.
		 *
		 * @var string
		 */
		protected $id = '';

		/**
		 * Setting page label.
		 *
		 * @var string
		 */
		protected $label = '';

		/**
		 * Constructor.
		 */
		public function __construct() {
			add_filter( 'kkart_settings_tabs_array', array( $this, 'add_settings_page' ), 20 );
			add_action( 'kkart_sections_' . $this->id, array( $this, 'output_sections' ) );
			add_action( 'kkart_settings_' . $this->id, array( $this, 'output' ) );
			add_action( 'kkart_settings_save_' . $this->id, array( $this, 'save' ) );
		}

		/**
		 * Get settings page ID.
		 *
		 * @since 3.0.0
		 * @return string
		 */
		public function get_id() {
			return $this->id;
		}

		/**
		 * Get settings page label.
		 *
		 * @since 3.0.0
		 * @return string
		 */
		public function get_label() {
			return $this->label;
		}

		/**
		 * Add this page to settings.
		 *
		 * @param array $pages
		 *
		 * @return mixed
		 */
		public function add_settings_page( $pages ) {
			$pages[ $this->id ] = $this->label;

			return $pages;
		}

		/**
		 * Get settings array.
		 *
		 * @return array
		 */
		public function get_settings() {
			return apply_filters( 'kkart_get_settings_' . $this->id, array() );
		}

		/**
		 * Get sections.
		 *
		 * @return array
		 */
		public function get_sections() {
			return apply_filters( 'kkart_get_sections_' . $this->id, array() );
		}

		/**
		 * Output sections.
		 */
		public function output_sections() {
			global $current_section;

			$sections = $this->get_sections();

			if ( empty( $sections ) || 1 === sizeof( $sections ) ) {
				return;
			}

			echo '<ul class="nav nav-pills">';

			$array_keys = array_keys( $sections );

			foreach ( $sections as $id => $label ) {
				echo '<li class="nav-item"><a href="' . admin_url( 'admin.php?page=kkart-settings&tab=' . $this->id . '&section=' . sanitize_title( $id ) ) . '" class="nav-link ' . ( $current_section == $id ? 'current active' : '' ) . '">' . $label . '</a></li>';
			}

			echo '</ul><br class="clear" />';
		}

		/**
		 * Output the settings.
		 */
		public function output() {
			$settings = $this->get_settings();

			KKART_Admin_Settings::output_fields( $settings );
		}

		/**
		 * Save settings.
		 */
		public function save() {
			global $current_section;

			$settings = $this->get_settings();
			KKART_Admin_Settings::save_fields( $settings );

			if ( $current_section ) {
				do_action( 'kkart_update_options_' . $this->id . '_' . $current_section );
			}
		}
	}

endif;
