<?php
/**
 * Kkart Integration Settings
 *
 * @author      WooThemes
 * @category    Admin
 * @package     Kkart\Admin
 * @version     2.1.0
 */

use Automattic\Jetpack\Constants;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'KKART_Settings_Integrations', false ) ) :

	/**
	 * KKART_Settings_Integrations.
	 */
	class KKART_Settings_Integrations extends KKART_Settings_Page {

		/**
		 * Constructor.
		 */
		public function __construct() {
			$this->id    = 'integration';
			$this->label = __( 'Integration', 'kkart' );

			if ( isset( KKART()->integrations ) && KKART()->integrations->get_integrations() ) {
				parent::__construct();
			}
		}

		/**
		 * Get sections.
		 *
		 * @return array
		 */
		public function get_sections() {
			global $current_section;

			$sections = array();

			if ( ! Constants::is_defined( 'KKART_INSTALLING' ) ) {
				$integrations = KKART()->integrations->get_integrations();

				if ( ! $current_section && ! empty( $integrations ) ) {
					$current_section = current( $integrations )->id;
				}

				if ( sizeof( $integrations ) > 1 ) {
					foreach ( $integrations as $integration ) {
						$title                                      = empty( $integration->method_title ) ? ucfirst( $integration->id ) : $integration->method_title;
						$sections[ strtolower( $integration->id ) ] = esc_html( $title );
					}
				}
			}

			return apply_filters( 'kkart_get_sections_' . $this->id, $sections );
		}

		/**
		 * Output the settings.
		 */
		public function output() {
			global $current_section;

			$integrations = KKART()->integrations->get_integrations();

			if ( isset( $integrations[ $current_section ] ) ) {
				$integrations[ $current_section ]->admin_options();
			}
		}
	}

endif;

return new KKART_Settings_Integrations();
