<?php
/**
 * Kkart advanced settings
 *
 * @package  Kkart\Admin
 */

defined( 'ABSPATH' ) || exit;

/**
 * Settings for API.
 */
if ( class_exists( 'KKART_Settings_Advanced', false ) ) {
	return new KKART_Settings_Advanced();
}

/**
 * KKART_Settings_Advanced.
 */
class KKART_Settings_Advanced extends KKART_Settings_Page {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->id    = 'advanced';
		$this->label = __( 'Advanced', 'kkart' );

		parent::__construct();
		$this->notices();
	}

	/**
	 * Get sections.
	 *
	 * @return array
	 */
	public function get_sections() {
		$sections = array(
			''                => __( 'Page setup', 'kkart' ),
			'keys'            => __( 'REST API', 'kkart' ),
			'webhooks'        => __( 'Webhooks', 'kkart' ),
			//'kkart_com' 		 => __( 'Kkart.com', 'kkart' ),
			'import_template' => __( 'Import template', 'kkart' ),
		);

		return apply_filters( 'kkart_get_sections_' . $this->id, $sections );
	}

	/**
	 * Get settings array.
	 *
	 * @param string $current_section Current section slug.
	 *
	 * @return array
	 */
	public function get_settings( $current_section = '' ) {
		$settings = array();

		if ( '' === $current_section ) {
			$settings = apply_filters(
				'kkart_settings_pages',
				array(

					array(
						'title' => __( 'Page setup', 'kkart' ),
						'desc'  => __( 'These pages need to be set so that Kkart knows where to send users to checkout.', 'kkart' ),
						'type'  => 'title',
						'id'    => 'advanced_page_options',
					),

					array(
						'title'    => __( 'Cart page', 'kkart' ),
						/* Translators: %s Page contents. */
						'desc'     => sprintf( __( 'Page contents: [%s]', 'kkart' ), apply_filters( 'kkart_cart_shortcode_tag', 'kkart_cart' ) ),
						'id'       => 'kkart_cart_page_id',
						'type'     => 'single_select_page',
						'default'  => '',
						'class'    => 'kkart-enhanced-select-nostd',
						'css'      => 'min-width:300px;',
						'args'     => array(
							'exclude' =>
								array(
									kkart_get_page_id( 'checkout' ),
									kkart_get_page_id( 'myaccount' ),
									kkart_get_page_id( 'order_pay' ),
									kkart_get_page_id( 'order_received' ),
								),
						),
						'desc_tip' => true,
						'autoload' => false,
					),

					array(
						'title'    => __( 'Checkout page', 'kkart' ),
						/* Translators: %s Page contents. */
						'desc'     => sprintf( __( 'Page contents: [%s]', 'kkart' ), apply_filters( 'kkart_checkout_shortcode_tag', 'kkart_checkout' ) ),
						'id'       => 'kkart_checkout_page_id',
						'type'     => 'single_select_page',
						'default'  => '',
						'class'    => 'kkart-enhanced-select-nostd',
						'css'      => 'min-width:300px;',
						'args'     => array(
							'exclude' =>
								array(
									kkart_get_page_id( 'cart' ),
									kkart_get_page_id( 'myaccount' ),
									kkart_get_page_id( 'order_pay' ),
									kkart_get_page_id( 'order_received' ),
								),
						),
						'desc_tip' => true,
						'autoload' => false,
					),

					array(
						'title'    => __( 'Checkout pay', 'kkart' ),
						/* Translators: %s Page contents. */
						'desc'     => __( 'Page contents for the "Checkout &rarr; Pay" page', 'kkart' ),
						'id'       => 'kkart_order_pay_page_id',
						'type'     => 'single_select_page',
						'default'  => '',
						'class'    => 'kkart-enhanced-select-nostd',
						'css'      => 'min-width:300px;',
						'args'     => array(
							'exclude' =>
								array(
									kkart_get_page_id( 'cart' ),
									kkart_get_page_id( 'myaccount' ),
									kkart_get_page_id( 'checkout' ),
									kkart_get_page_id( 'order_received' ),
								),
						),
						'desc_tip' => true,
						'autoload' => false,
					),

					array(
						'title'    => __( 'Checkout Order Received', 'kkart' ),
						/* Translators: %s Page contents. */
						'desc'     => __( 'Page contents for the "Checkout &rarr; Order received" page', 'kkart' ),
						'id'       => 'kkart_order_received_page_id',
						'type'     => 'single_select_page',
						'default'  => '',
						'class'    => 'kkart-enhanced-select-nostd',
						'css'      => 'min-width:300px;',
						'args'     => array(
							'exclude' =>
								array(
									kkart_get_page_id( 'cart' ),
									kkart_get_page_id( 'myaccount' ),
									kkart_get_page_id( 'order_pay' ),
									kkart_get_page_id( 'checkout' ),
								),
						),
						'desc_tip' => true,
						'autoload' => false,
					),

					array(
						'title'    => __( 'My account page', 'kkart' ),
						/* Translators: %s Page contents. */
						'desc'     => sprintf( __( 'Page contents: [%s]', 'kkart' ), apply_filters( 'kkart_my_account_shortcode_tag', 'kkart_my_account' ) ),
						'id'       => 'kkart_myaccount_page_id',
						'type'     => 'single_select_page',
						'default'  => '',
						'class'    => 'kkart-enhanced-select-nostd',
						'css'      => 'min-width:300px;',
						'args'     => array(
							'exclude' =>
								array(
									kkart_get_page_id( 'cart' ),
									kkart_get_page_id( 'checkout' ),
									kkart_get_page_id( 'order_pay' ),
									kkart_get_page_id( 'order_received' ),
								),
						),
						'desc_tip' => true,
						'autoload' => false,
					),

					array(
						'title'    => __( 'Terms and conditions', 'kkart' ),
						'desc'     => __( 'If you define a "Terms" page the customer will be asked if they accept them when checking out.', 'kkart' ),
						'id'       => 'kkart_terms_page_id',
						'default'  => '',
						'class'    => 'kkart-enhanced-select-nostd',
						'css'      => 'min-width:300px;',
						'type'     => 'single_select_page',
						'args'     => array( 'exclude' => kkart_get_page_id( 'checkout' ) ),
						'desc_tip' => true,
						'autoload' => false,
					),

					array(
						'type' => 'sectionend',
						'id'   => 'advanced_page_options',
					),

					array(
						'title' => '',
						'type'  => 'title',
						'id'    => 'checkout_process_options',
					),

					'force_ssl_checkout'   => array(
						'title'           => __( 'Secure checkout', 'kkart' ),
						'desc'            => __( 'Force secure checkout', 'kkart' ),
						'id'              => 'kkart_force_ssl_checkout',
						'default'         => 'no',
						'type'            => 'checkbox',
						'checkboxgroup'   => 'start',
						'show_if_checked' => 'option',
						/* Translators: %s Docs URL. */
						'desc_tip'        => sprintf( __( 'Force SSL (HTTPS) on the checkout pages (<a href="%s" target="_blank">an SSL Certificate is required</a>).', 'kkart' ), 'https://docs.kkart.com/document/ssl-and-https/#section-3' ),
					),

					'unforce_ssl_checkout' => array(
						'desc'            => __( 'Force HTTP when leaving the checkout', 'kkart' ),
						'id'              => 'kkart_unforce_ssl_checkout',
						'default'         => 'no',
						'type'            => 'checkbox',
						'checkboxgroup'   => 'end',
						'show_if_checked' => 'yes',
					),

					array(
						'type' => 'sectionend',
						'id'   => 'checkout_process_options',
					),

					array(
						'title' => __( 'Checkout endpoints', 'kkart' ),
						'type'  => 'title',
						'desc'  => __( 'Endpoints are appended to your page URLs to handle specific actions during the checkout process. They should be unique.', 'kkart' ),
						'id'    => 'checkout_endpoint_options',
					),

					array(
						'title'    => __( 'Add payment method', 'kkart' ),
						'desc'     => __( 'Endpoint for the "Checkout &rarr; Add payment method" page.', 'kkart' ),
						'id'       => 'kkart_myaccount_add_payment_method_endpoint',
						'type'     => 'text',
						'default'  => 'add-payment-method',
						'desc_tip' => true,
					),

					array(
						'title'    => __( 'Delete payment method', 'kkart' ),
						'desc'     => __( 'Endpoint for the delete payment method page.', 'kkart' ),
						'id'       => 'kkart_myaccount_delete_payment_method_endpoint',
						'type'     => 'text',
						'default'  => 'delete-payment-method',
						'desc_tip' => true,
					),

					array(
						'title'    => __( 'Set default payment method', 'kkart' ),
						'desc'     => __( 'Endpoint for the setting a default payment method page.', 'kkart' ),
						'id'       => 'kkart_myaccount_set_default_payment_method_endpoint',
						'type'     => 'text',
						'default'  => 'set-default-payment-method',
						'desc_tip' => true,
					),

					array(
						'type' => 'sectionend',
						'id'   => 'checkout_endpoint_options',
					),

					array(
						'title' => __( 'Account endpoints', 'kkart' ),
						'type'  => 'title',
						'desc'  => __( 'Endpoints are appended to your page URLs to handle specific actions on the accounts pages. They should be unique and can be left blank to disable the endpoint.', 'kkart' ),
						'id'    => 'account_endpoint_options',
					),

					array(
						'title'    => __( 'Orders', 'kkart' ),
						'desc'     => __( 'Endpoint for the "My account &rarr; Orders" page.', 'kkart' ),
						'id'       => 'kkart_myaccount_orders_endpoint',
						'type'     => 'text',
						'default'  => 'orders',
						'desc_tip' => true,
					),

					array(
						'title'    => __( 'View order', 'kkart' ),
						'desc'     => __( 'Endpoint for the "My account &rarr; View order" page.', 'kkart' ),
						'id'       => 'kkart_myaccount_view_order_endpoint',
						'type'     => 'text',
						'default'  => 'view-order',
						'desc_tip' => true,
					),

					array(
						'title'    => __( 'Downloads', 'kkart' ),
						'desc'     => __( 'Endpoint for the "My account &rarr; Downloads" page.', 'kkart' ),
						'id'       => 'kkart_myaccount_downloads_endpoint',
						'type'     => 'text',
						'default'  => 'downloads',
						'desc_tip' => true,
					),

					array(
						'title'    => __( 'Edit account', 'kkart' ),
						'desc'     => __( 'Endpoint for the "My account &rarr; Edit account" page.', 'kkart' ),
						'id'       => 'kkart_myaccount_edit_account_endpoint',
						'type'     => 'text',
						'default'  => 'edit-account',
						'desc_tip' => true,
					),

					array(
						'title'    => __( 'Addresses', 'kkart' ),
						'desc'     => __( 'Endpoint for the "My account &rarr; Addresses" page.', 'kkart' ),
						'id'       => 'kkart_myaccount_edit_address_endpoint',
						'type'     => 'text',
						'default'  => 'edit-address',
						'desc_tip' => true,
					),

					array(
						'title'    => __( 'Payment methods', 'kkart' ),
						'desc'     => __( 'Endpoint for the "My account &rarr; Payment methods" page.', 'kkart' ),
						'id'       => 'kkart_myaccount_payment_methods_endpoint',
						'type'     => 'text',
						'default'  => 'payment-methods',
						'desc_tip' => true,
					),

					array(
						'title'    => __( 'Lost password', 'kkart' ),
						'desc'     => __( 'Endpoint for the "My account &rarr; Lost password" page.', 'kkart' ),
						'id'       => 'kkart_myaccount_lost_password_endpoint',
						'type'     => 'text',
						'default'  => 'lost-password',
						'desc_tip' => true,
					),

					array(
						'title'    => __( 'Logout', 'kkart' ),
						'desc'     => __( 'Endpoint for the triggering logout. You can add this to your menus via a custom link: yoursite.com/?customer-logout=true', 'kkart' ),
						'id'       => 'kkart_logout_endpoint',
						'type'     => 'text',
						'default'  => 'customer-logout',
						'desc_tip' => true,
					),

					array(
						'type' => 'sectionend',
						'id'   => 'account_endpoint_options',
					),
				)
			);

			if ( kkart_site_is_https() ) {
				unset( $settings['unforce_ssl_checkout'], $settings['force_ssl_checkout'] );
			}
		} elseif ( 'kkart_com' === $current_section ) {
			$tracking_info_text = sprintf( '<a href="%s" target="_blank">%s</a>', 'https://kkart.com/usage-tracking', esc_html__( 'Kkart.com Usage Tracking Documentation', 'kkart' ) );

			$settings = apply_filters(
				'kkart_com_integration_settings',
				array(
					array(
						'title' => esc_html__( 'Usage Tracking', 'kkart' ),
						'type'  => 'title',
						'id'    => 'tracking_options',
						'desc'  => __( 'Gathering usage data allows us to make Kkart better — your store will be considered as we evaluate new features, judge the quality of an update, or determine if an improvement makes sense.', 'kkart' ),
					),
					array(
						'title'         => __( 'Enable tracking', 'kkart' ),
						'desc'          => __( 'Allow usage of Kkart to be tracked', 'kkart' ),
						/* Translators: %s URL to tracking info screen. */
						'desc_tip'      => sprintf( esc_html__( 'To opt out, leave this box unticked. Your store remains untracked, and no data will be collected. Read about what usage data is tracked at: %s.', 'kkart' ), $tracking_info_text ),
						'id'            => 'kkart_allow_tracking',
						'type'          => 'checkbox',
						'checkboxgroup' => 'start',
						'default'       => 'no',
						'autoload'      => false,
					),
					array(
						'type' => 'sectionend',
						'id'   => 'tracking_options',
					),
					array(
						'title' => esc_html__( 'Marketplace suggestions', 'kkart' ),
						'type'  => 'title',
						'id'    => 'marketplace_suggestions',
						'desc'  => __( 'We show contextual suggestions for official extensions that may be helpful to your store.', 'kkart' ),
					),
					array(
						'title'         => __( 'Show Suggestions', 'kkart' ),
						'desc'          => __( 'Display suggestions within Kkart', 'kkart' ),
						'desc_tip'      => esc_html__( 'Leave this box unchecked if you do not want to see suggested extensions.', 'kkart' ),
						'id'            => 'kkart_show_marketplace_suggestions',
						'type'          => 'checkbox',
						'checkboxgroup' => 'start',
						'default'       => 'yes',
						'autoload'      => false,
					),
					array(
						'type' => 'sectionend',
						'id'   => 'marketplace_suggestions',
					),
				)
			);
		}

		return apply_filters( 'kkart_get_settings_' . $this->id, $settings, $current_section );
	}

	/**
	 * Form method.
	 *
	 * @deprecated 3.4.4
	 *
	 * @param  string $method Method name.
	 *
	 * @return string
	 */
	public function form_method( $method ) {
		return 'post';
	}

	/**
	 * Notices.
	 */
	private function notices() {
		if ( isset( $_GET['section'] ) && 'webhooks' === $_GET['section'] ) { // WPCS: input var okay, CSRF ok.
			KKART_Admin_Webhooks::notices();
		}
		if ( isset( $_GET['section'] ) && 'keys' === $_GET['section'] ) { // WPCS: input var okay, CSRF ok.
			KKART_Admin_API_Keys::notices();
		}
	}

	/**
	 * Output the settings.
	 */
	public function output() {
		global $current_section;

		if ( 'webhooks' === $current_section ) {
			KKART_Admin_Webhooks::page_output();
		} elseif ( 'keys' === $current_section ) {
			KKART_Admin_API_Keys::page_output();
		} elseif( 'import_template' === $current_section ){
			KKART_Admin_Import_Template::import_template_view();
		} else {
			$settings = $this->get_settings( $current_section );
			KKART_Admin_Settings::output_fields( $settings );
		}
	}

	/**
	 * Save settings.
	 */
	public function save() {
		global $current_section;

		if ( apply_filters( 'kkart_rest_api_valid_to_save', ! in_array( $current_section, array( 'keys', 'webhooks' ), true ) ) ) {
			$settings = $this->get_settings( $current_section );

			// Prevent the T&Cs and checkout page from being set to the same page.
			if ( isset( $_POST['kkart_terms_page_id'], $_POST['kkart_checkout_page_id'] ) && $_POST['kkart_terms_page_id'] === $_POST['kkart_checkout_page_id'] ) { // WPCS: input var ok, CSRF ok.
				$_POST['kkart_terms_page_id'] = '';
			}

			// Prevent the Cart, checkout and my account page from being set to the same page.
			if ( isset( $_POST['kkart_cart_page_id'], $_POST['kkart_checkout_page_id'], $_POST['kkart_myaccount_page_id'] ) ) { // WPCS: input var ok, CSRF ok.
				if ( $_POST['kkart_cart_page_id'] === $_POST['kkart_checkout_page_id'] ) { // WPCS: input var ok, CSRF ok.
					$_POST['kkart_checkout_page_id'] = '';
				}
				if ( $_POST['kkart_cart_page_id'] === $_POST['kkart_myaccount_page_id'] ) { // WPCS: input var ok, CSRF ok.
					$_POST['kkart_myaccount_page_id'] = '';
				}
				if ( $_POST['kkart_checkout_page_id'] === $_POST['kkart_myaccount_page_id'] ) { // WPCS: input var ok, CSRF ok.
					$_POST['kkart_myaccount_page_id'] = '';
				}
			}

			KKART_Admin_Settings::save_fields( $settings );

			if ( $current_section ) {
				do_action( 'kkart_update_options_' . $this->id . '_' . $current_section );
			}
		}
	}
}

/**
 * KKART_Settings_Rest_API class.
 *
 * @deprecated 3.4 in favour of KKART_Settings_Advanced.
 * @todo remove in 4.0.
 */
class KKART_Settings_Rest_API extends KKART_Settings_Advanced {
} // @codingStandardsIgnoreLine.

return new KKART_Settings_Advanced();
