<?php
/**
 * Displays the inventory tab in the product data meta box.
 *
 * @package Kkart\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div id="inventory_product_data" class="panel kkart_options_panel hidden">

	<div class="options_group">
		<?php
		if ( kkart_product_sku_enabled() ) {
			kkart_wp_text_input(
				array(
					'id'          => '_sku',
					'value'       => $product_object->get_sku( 'edit' ),
					'label'       => '<abbr title="' . esc_attr__( 'Stock Keeping Unit', 'kkart' ) . '">' . esc_html__( 'SKU', 'kkart' ) . '</abbr>',
					'desc_tip'    => true,
					'description' => __( 'SKU refers to a Stock-keeping unit, a unique identifier for each distinct product and service that can be purchased.', 'kkart' ),
				)
			);
		}

		do_action( 'kkart_product_options_sku' );

		if ( 'yes' === get_option( 'kkart_manage_stock' ) ) {

			kkart_wp_checkbox(
				array(
					'id'            => '_manage_stock',
					'value'         => $product_object->get_manage_stock( 'edit' ) ? 'yes' : 'no',
					'wrapper_class' => 'show_if_simple show_if_variable',
					'label'         => __( 'Manage stock?', 'kkart' ),
					'description'   => __( 'Enable stock management at product level', 'kkart' ),
				)
			);

			do_action( 'kkart_product_options_stock' );

			echo '<div class="stock_fields show_if_simple show_if_variable">';

			kkart_wp_text_input(
				array(
					'id'                => '_stock',
					'value'             => kkart_stock_amount( $product_object->get_stock_quantity( 'edit' ) ),
					'label'             => __( 'Stock quantity', 'kkart' ),
					'desc_tip'          => true,
					'description'       => __( 'Stock quantity. If this is a variable product this value will be used to control stock for all variations, unless you define stock at variation level.', 'kkart' ),
					'type'              => 'number',
					'custom_attributes' => array(
						'step' => 'any',
					),
					'data_type'         => 'stock',
				)
			);

			echo '<input type="hidden" name="_original_stock" value="' . esc_attr( kkart_stock_amount( $product_object->get_stock_quantity( 'edit' ) ) ) . '" />';

			kkart_wp_select(
				array(
					'id'          => '_backorders',
					'value'       => $product_object->get_backorders( 'edit' ),
					'label'       => __( 'Allow backorders?', 'kkart' ),
					'options'     => kkart_get_product_backorder_options(),
					'desc_tip'    => true,
					'description' => __( 'If managing stock, this controls whether or not backorders are allowed. If enabled, stock quantity can go below 0.', 'kkart' ),
				)
			);

			kkart_wp_text_input(
				array(
					'id'                => '_low_stock_amount',
					'value'             => $product_object->get_low_stock_amount( 'edit' ),
					'placeholder'       => get_option( 'kkart_notify_low_stock_amount' ),
					'label'             => __( 'Low stock threshold', 'kkart' ),
					'desc_tip'          => true,
					'description'       => __( 'When product stock reaches this amount you will be notified by email', 'kkart' ),
					'type'              => 'number',
					'custom_attributes' => array(
						'step' => 'any',
					),
				)
			);

			do_action( 'kkart_product_options_stock_fields' );

			echo '</div>';
		}

		kkart_wp_select(
			array(
				'id'            => '_stock_status',
				'value'         => $product_object->get_stock_status( 'edit' ),
				'wrapper_class' => 'stock_status_field hide_if_variable hide_if_external hide_if_grouped',
				'label'         => __( 'Stock status', 'kkart' ),
				'options'       => kkart_get_product_stock_status_options(),
				'desc_tip'      => true,
				'description'   => __( 'Controls whether or not the product is listed as "in stock" or "out of stock" on the frontend.', 'kkart' ),
			)
		);

		do_action( 'kkart_product_options_stock_status' );
		?>
	</div>

	<div class="options_group show_if_simple show_if_variable">
		<?php
		kkart_wp_checkbox(
			array(
				'id'            => '_sold_individually',
				'value'         => $product_object->get_sold_individually( 'edit' ) ? 'yes' : 'no',
				'wrapper_class' => 'show_if_simple show_if_variable',
				'label'         => __( 'Sold individually', 'kkart' ),
				'description'   => __( 'Enable this to only allow one of this item to be bought in a single order', 'kkart' ),
			)
		);

		do_action( 'kkart_product_options_sold_individually' );
		?>
	</div>

	<?php do_action( 'kkart_product_options_inventory_product_data' ); ?>
</div>
