<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div id="product_attributes" class="panel kkart-metaboxes-wrapper hidden">
	<div class="toolbar toolbar-top">
		<span class="expand-close">
			<a href="#" class="expand_all"><?php esc_html_e( 'Expand', 'kkart' ); ?></a> / <a href="#" class="close_all"><?php esc_html_e( 'Close', 'kkart' ); ?></a>
		</span>
		<select name="attribute_taxonomy" class="attribute_taxonomy">
			<option value=""><?php esc_html_e( 'Custom product attribute', 'kkart' ); ?></option>
			<?php
			global $kkart_product_attributes;

			// Array of defined attribute taxonomies.
			$attribute_taxonomies = kkart_get_attribute_taxonomies();

			if ( ! empty( $attribute_taxonomies ) ) {
				foreach ( $attribute_taxonomies as $tax ) {
					$attribute_taxonomy_name = kkart_attribute_taxonomy_name( $tax->attribute_name );
					$label                   = $tax->attribute_label ? $tax->attribute_label : $tax->attribute_name;
					echo '<option value="' . esc_attr( $attribute_taxonomy_name ) . '">' . esc_html( $label ) . '</option>';
				}
			}
			?>
		</select>
		<button type="button" class="button add_attribute"><?php esc_html_e( 'Add', 'kkart' ); ?></button>
	</div>
	<div class="product_attributes kkart-metaboxes">
		<?php
		// Product attributes - taxonomies and custom, ordered, with visibility and variation attributes set.
		$attributes = $product_object->get_attributes( 'edit' );
		$i          = -1;

		foreach ( $attributes as $attribute ) {
			$i++;
			$metabox_class = array();

			if ( $attribute->is_taxonomy() ) {
				$metabox_class[] = 'taxonomy';
				$metabox_class[] = $attribute->get_name();
			}

			include __DIR__ . '/html-product-attribute.php';
		}
		?>
	</div>
	<div class="toolbar">
		<span class="expand-close">
			<a href="#" class="expand_all"><?php esc_html_e( 'Expand', 'kkart' ); ?></a> / <a href="#" class="close_all"><?php esc_html_e( 'Close', 'kkart' ); ?></a>
		</span>
		<button type="button" class="button save_attributes button-primary"><?php esc_html_e( 'Save attributes', 'kkart' ); ?></button>
	</div>
	<?php do_action( 'kkart_product_options_attributes' ); ?>
</div>
