<?php
/**
 * Product Images
 *
 * Display the product images meta box.
 *
 * @author      WooThemes
 * @category    Admin
 * @package     Kkart\Admin\Meta Boxes
 * @version     2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * KKART_Meta_Box_Product_Images Class.
 */
class KKART_Meta_Box_Product_Images {

	/**
	 * Output the metabox.
	 *
	 * @param WP_Post $post
	 */
	public static function output( $post ) {
		global $thepostid, $product_object;

		$thepostid      = $post->ID;
		$product_object = $thepostid ? kkart_get_product( $thepostid ) : new KKART_Product();
		wp_nonce_field( 'kkart_save_data', 'kkart_meta_nonce' );
		?>
		<div id="product_images_container">
			<ul class="product_images">
				<?php
				$product_image_gallery = $product_object->get_gallery_image_ids( 'edit' );
				$product_image_id = $product_object->get_image_id( 'edit' );
				
				// Add image id at the first
				array_unshift( $product_image_gallery, $product_image_id );

				$attachments         = array_filter( $product_image_gallery );
				$update_meta         = false;
				$updated_gallery_ids = array();

				if ( ! empty( $attachments ) ) {
					foreach ( $attachments as $attachment_id ) {
						$attachment = wp_get_attachment_image( $attachment_id, 'thumbnail' );

						// if attachment is empty skip.
						if ( empty( $attachment ) ) {
							$update_meta = true;
							continue;
						}
						?>
						<li class="image" data-attachment_id="<?php echo esc_attr( $attachment_id ); ?>">
							<?php echo $attachment; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
							<ul class="actions">
								<li><a href="#" class="delete tips" data-tip="<?php esc_attr_e( 'Delete image', 'kkart' ); ?>"><?php esc_html_e( 'Delete', 'kkart' ); ?></a></li>
							</ul>
							<?php
							// Allow for extra info to be exposed or extra action to be executed for this attachment.
							do_action( 'kkart_admin_after_product_gallery_item', $thepostid, $attachment_id );
							?>
						</li>
						<?php

						// rebuild ids to be saved.
						$updated_gallery_ids[] = $attachment_id;
					}

					// need to update product meta to set new gallery ids
					if ( $update_meta ) {
						update_post_meta( $post->ID, '_product_image_gallery', implode( ',', $updated_gallery_ids ) );
					}
				}
				?>
				<p class="add_product_images hide-if-no-js">
					<a href="#" data-choose="<?php esc_attr_e( 'Add images to product gallery', 'kkart' ); ?>" data-update="<?php esc_attr_e( 'Add to gallery', 'kkart' ); ?>" data-delete="<?php esc_attr_e( 'Delete image', 'kkart' ); ?>" data-text="<?php esc_attr_e( 'Delete', 'kkart' ); ?>">
						<span style="font-size:2em;"> + </span>
						<?php esc_html_e( 'Add product gallery', 'kkart' ); ?>
					</a>
				</p>
			</ul>

			<input type="hidden" id="product_image_gallery" name="product_image_gallery" value="<?php echo esc_attr( implode( ',', $updated_gallery_ids ) ); ?>" />
			
		</div>
		
		<?php
	}

	/**
	 * Save meta box data.
	 *
	 * @param int     $post_id
	 * @param WP_Post $post
	 */
	public static function save( $post_id, $post ) {
		$product_type   = empty( $_POST['product-type'] ) ? KKART_Product_Factory::get_product_type( $post_id ) : sanitize_title( stripslashes( $_POST['product-type'] ) );
		$classname      = KKART_Product_Factory::get_product_classname( $post_id, $product_type ? $product_type : 'simple' );
		$product        = new $classname( $post_id );
		$attachment_ids = isset( $_POST['product_image_gallery'] ) ? array_filter( pagelayer_maybe_explode( ',', kkart_clean( $_POST['product_image_gallery'] ) ) ) : array();
		
		$image_id = '';
		
		if(!empty( $attachment_ids )){
			$image_id = $attachment_ids[0];
			unset($attachment_ids[0]);
		}
		
		$product->set_image_id( $image_id );
		$product->set_gallery_image_ids( $attachment_ids );
		$product->save();
	}
}
