<?php
/**
 * Generic mappings
 *
 * @package Kkart\Admin\Importers
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Add generic mappings.
 *
 * @since 3.1.0
 * @param array $mappings Importer columns mappings.
 * @return array
 */
function kkart_importer_generic_mappings( $mappings ) {
	$generic_mappings = array(
		__( 'Title', 'kkart' )         => 'name',
		__( 'Product Title', 'kkart' ) => 'name',
		__( 'Price', 'kkart' )         => 'regular_price',
		__( 'Parent SKU', 'kkart' )    => 'parent_id',
		__( 'Quantity', 'kkart' )      => 'stock_quantity',
		__( 'Menu order', 'kkart' )    => 'menu_order',
	);

	return array_merge( $mappings, $generic_mappings );
}
add_filter( 'kkart_csv_product_import_mapping_default_columns', 'kkart_importer_generic_mappings' );
