<?php
/**
 * Countries
 *
 * Returns an array of countries and codes.
 * Country codes and names should follow the Unicode CLDR recommendation (http://cldr.unicode.org/translation/displaynames/country-names).
 *
 * See https://github.com/unicode-org/cldr/blob/master/common/subdivisions/en.xml
 *
 * @package Kkart\i18n
 * @version 3.8.0
 */

defined( 'ABSPATH' ) || exit;

return array(
	'AF' => __( 'Afghanistan', 'kkart' ),
	'AX' => __( 'Åland Islands', 'kkart' ),
	'AL' => __( 'Albania', 'kkart' ),
	'DZ' => __( 'Algeria', 'kkart' ),
	'AS' => __( 'American Samoa', 'kkart' ),
	'AD' => __( 'Andorra', 'kkart' ),
	'AO' => __( 'Angola', 'kkart' ),
	'AI' => __( 'Anguilla', 'kkart' ),
	'AQ' => __( 'Antarctica', 'kkart' ),
	'AG' => __( 'Antigua and Barbuda', 'kkart' ),
	'AR' => __( 'Argentina', 'kkart' ),
	'AM' => __( 'Armenia', 'kkart' ),
	'AW' => __( 'Aruba', 'kkart' ),
	'AU' => __( 'Australia', 'kkart' ),
	'AT' => __( 'Austria', 'kkart' ),
	'AZ' => __( 'Azerbaijan', 'kkart' ),
	'BS' => __( 'Bahamas', 'kkart' ),
	'BH' => __( 'Bahrain', 'kkart' ),
	'BD' => __( 'Bangladesh', 'kkart' ),
	'BB' => __( 'Barbados', 'kkart' ),
	'BY' => __( 'Belarus', 'kkart' ),
	'BE' => __( 'Belgium', 'kkart' ),
	'PW' => __( 'Belau', 'kkart' ),
	'BZ' => __( 'Belize', 'kkart' ),
	'BJ' => __( 'Benin', 'kkart' ),
	'BM' => __( 'Bermuda', 'kkart' ),
	'BT' => __( 'Bhutan', 'kkart' ),
	'BO' => __( 'Bolivia', 'kkart' ),
	'BQ' => __( 'Bonaire, Saint Eustatius and Saba', 'kkart' ),
	'BA' => __( 'Bosnia and Herzegovina', 'kkart' ),
	'BW' => __( 'Botswana', 'kkart' ),
	'BV' => __( 'Bouvet Island', 'kkart' ),
	'BR' => __( 'Brazil', 'kkart' ),
	'IO' => __( 'British Indian Ocean Territory', 'kkart' ),
	'BN' => __( 'Brunei', 'kkart' ),
	'BG' => __( 'Bulgaria', 'kkart' ),
	'BF' => __( 'Burkina Faso', 'kkart' ),
	'BI' => __( 'Burundi', 'kkart' ),
	'KH' => __( 'Cambodia', 'kkart' ),
	'CM' => __( 'Cameroon', 'kkart' ),
	'CA' => __( 'Canada', 'kkart' ),
	'CV' => __( 'Cape Verde', 'kkart' ),
	'KY' => __( 'Cayman Islands', 'kkart' ),
	'CF' => __( 'Central African Republic', 'kkart' ),
	'TD' => __( 'Chad', 'kkart' ),
	'CL' => __( 'Chile', 'kkart' ),
	'CN' => __( 'China', 'kkart' ),
	'CX' => __( 'Christmas Island', 'kkart' ),
	'CC' => __( 'Cocos (Keeling) Islands', 'kkart' ),
	'CO' => __( 'Colombia', 'kkart' ),
	'KM' => __( 'Comoros', 'kkart' ),
	'CG' => __( 'Congo (Brazzaville)', 'kkart' ),
	'CD' => __( 'Congo (Kinshasa)', 'kkart' ),
	'CK' => __( 'Cook Islands', 'kkart' ),
	'CR' => __( 'Costa Rica', 'kkart' ),
	'HR' => __( 'Croatia', 'kkart' ),
	'CU' => __( 'Cuba', 'kkart' ),
	'CW' => __( 'Cura&ccedil;ao', 'kkart' ),
	'CY' => __( 'Cyprus', 'kkart' ),
	'CZ' => __( 'Czech Republic', 'kkart' ),
	'DK' => __( 'Denmark', 'kkart' ),
	'DJ' => __( 'Djibouti', 'kkart' ),
	'DM' => __( 'Dominica', 'kkart' ),
	'DO' => __( 'Dominican Republic', 'kkart' ),
	'EC' => __( 'Ecuador', 'kkart' ),
	'EG' => __( 'Egypt', 'kkart' ),
	'SV' => __( 'El Salvador', 'kkart' ),
	'GQ' => __( 'Equatorial Guinea', 'kkart' ),
	'ER' => __( 'Eritrea', 'kkart' ),
	'EE' => __( 'Estonia', 'kkart' ),
	'ET' => __( 'Ethiopia', 'kkart' ),
	'FK' => __( 'Falkland Islands', 'kkart' ),
	'FO' => __( 'Faroe Islands', 'kkart' ),
	'FJ' => __( 'Fiji', 'kkart' ),
	'FI' => __( 'Finland', 'kkart' ),
	'FR' => __( 'France', 'kkart' ),
	'GF' => __( 'French Guiana', 'kkart' ),
	'PF' => __( 'French Polynesia', 'kkart' ),
	'TF' => __( 'French Southern Territories', 'kkart' ),
	'GA' => __( 'Gabon', 'kkart' ),
	'GM' => __( 'Gambia', 'kkart' ),
	'GE' => __( 'Georgia', 'kkart' ),
	'DE' => __( 'Germany', 'kkart' ),
	'GH' => __( 'Ghana', 'kkart' ),
	'GI' => __( 'Gibraltar', 'kkart' ),
	'GR' => __( 'Greece', 'kkart' ),
	'GL' => __( 'Greenland', 'kkart' ),
	'GD' => __( 'Grenada', 'kkart' ),
	'GP' => __( 'Guadeloupe', 'kkart' ),
	'GU' => __( 'Guam', 'kkart' ),
	'GT' => __( 'Guatemala', 'kkart' ),
	'GG' => __( 'Guernsey', 'kkart' ),
	'GN' => __( 'Guinea', 'kkart' ),
	'GW' => __( 'Guinea-Bissau', 'kkart' ),
	'GY' => __( 'Guyana', 'kkart' ),
	'HT' => __( 'Haiti', 'kkart' ),
	'HM' => __( 'Heard Island and McDonald Islands', 'kkart' ),
	'HN' => __( 'Honduras', 'kkart' ),
	'HK' => __( 'Hong Kong', 'kkart' ),
	'HU' => __( 'Hungary', 'kkart' ),
	'IS' => __( 'Iceland', 'kkart' ),
	'IN' => __( 'India', 'kkart' ),
	'ID' => __( 'Indonesia', 'kkart' ),
	'IR' => __( 'Iran', 'kkart' ),
	'IQ' => __( 'Iraq', 'kkart' ),
	'IE' => __( 'Ireland', 'kkart' ),
	'IM' => __( 'Isle of Man', 'kkart' ),
	'IL' => __( 'Israel', 'kkart' ),
	'IT' => __( 'Italy', 'kkart' ),
	'CI' => __( 'Ivory Coast', 'kkart' ),
	'JM' => __( 'Jamaica', 'kkart' ),
	'JP' => __( 'Japan', 'kkart' ),
	'JE' => __( 'Jersey', 'kkart' ),
	'JO' => __( 'Jordan', 'kkart' ),
	'KZ' => __( 'Kazakhstan', 'kkart' ),
	'KE' => __( 'Kenya', 'kkart' ),
	'KI' => __( 'Kiribati', 'kkart' ),
	'KW' => __( 'Kuwait', 'kkart' ),
	'KG' => __( 'Kyrgyzstan', 'kkart' ),
	'LA' => __( 'Laos', 'kkart' ),
	'LV' => __( 'Latvia', 'kkart' ),
	'LB' => __( 'Lebanon', 'kkart' ),
	'LS' => __( 'Lesotho', 'kkart' ),
	'LR' => __( 'Liberia', 'kkart' ),
	'LY' => __( 'Libya', 'kkart' ),
	'LI' => __( 'Liechtenstein', 'kkart' ),
	'LT' => __( 'Lithuania', 'kkart' ),
	'LU' => __( 'Luxembourg', 'kkart' ),
	'MO' => __( 'Macao', 'kkart' ),
	'MK' => __( 'North Macedonia', 'kkart' ),
	'MG' => __( 'Madagascar', 'kkart' ),
	'MW' => __( 'Malawi', 'kkart' ),
	'MY' => __( 'Malaysia', 'kkart' ),
	'MV' => __( 'Maldives', 'kkart' ),
	'ML' => __( 'Mali', 'kkart' ),
	'MT' => __( 'Malta', 'kkart' ),
	'MH' => __( 'Marshall Islands', 'kkart' ),
	'MQ' => __( 'Martinique', 'kkart' ),
	'MR' => __( 'Mauritania', 'kkart' ),
	'MU' => __( 'Mauritius', 'kkart' ),
	'YT' => __( 'Mayotte', 'kkart' ),
	'MX' => __( 'Mexico', 'kkart' ),
	'FM' => __( 'Micronesia', 'kkart' ),
	'MD' => __( 'Moldova', 'kkart' ),
	'MC' => __( 'Monaco', 'kkart' ),
	'MN' => __( 'Mongolia', 'kkart' ),
	'ME' => __( 'Montenegro', 'kkart' ),
	'MS' => __( 'Montserrat', 'kkart' ),
	'MA' => __( 'Morocco', 'kkart' ),
	'MZ' => __( 'Mozambique', 'kkart' ),
	'MM' => __( 'Myanmar', 'kkart' ),
	'NA' => __( 'Namibia', 'kkart' ),
	'NR' => __( 'Nauru', 'kkart' ),
	'NP' => __( 'Nepal', 'kkart' ),
	'NL' => __( 'Netherlands', 'kkart' ),
	'NC' => __( 'New Caledonia', 'kkart' ),
	'NZ' => __( 'New Zealand', 'kkart' ),
	'NI' => __( 'Nicaragua', 'kkart' ),
	'NE' => __( 'Niger', 'kkart' ),
	'NG' => __( 'Nigeria', 'kkart' ),
	'NU' => __( 'Niue', 'kkart' ),
	'NF' => __( 'Norfolk Island', 'kkart' ),
	'MP' => __( 'Northern Mariana Islands', 'kkart' ),
	'KP' => __( 'North Korea', 'kkart' ),
	'NO' => __( 'Norway', 'kkart' ),
	'OM' => __( 'Oman', 'kkart' ),
	'PK' => __( 'Pakistan', 'kkart' ),
	'PS' => __( 'Palestinian Territory', 'kkart' ),
	'PA' => __( 'Panama', 'kkart' ),
	'PG' => __( 'Papua New Guinea', 'kkart' ),
	'PY' => __( 'Paraguay', 'kkart' ),
	'PE' => __( 'Peru', 'kkart' ),
	'PH' => __( 'Philippines', 'kkart' ),
	'PN' => __( 'Pitcairn', 'kkart' ),
	'PL' => __( 'Poland', 'kkart' ),
	'PT' => __( 'Portugal', 'kkart' ),
	'PR' => __( 'Puerto Rico', 'kkart' ),
	'QA' => __( 'Qatar', 'kkart' ),
	'RE' => __( 'Reunion', 'kkart' ),
	'RO' => __( 'Romania', 'kkart' ),
	'RU' => __( 'Russia', 'kkart' ),
	'RW' => __( 'Rwanda', 'kkart' ),
	'BL' => __( 'Saint Barth&eacute;lemy', 'kkart' ),
	'SH' => __( 'Saint Helena', 'kkart' ),
	'KN' => __( 'Saint Kitts and Nevis', 'kkart' ),
	'LC' => __( 'Saint Lucia', 'kkart' ),
	'MF' => __( 'Saint Martin (French part)', 'kkart' ),
	'SX' => __( 'Saint Martin (Dutch part)', 'kkart' ),
	'PM' => __( 'Saint Pierre and Miquelon', 'kkart' ),
	'VC' => __( 'Saint Vincent and the Grenadines', 'kkart' ),
	'SM' => __( 'San Marino', 'kkart' ),
	'ST' => __( 'S&atilde;o Tom&eacute; and Pr&iacute;ncipe', 'kkart' ),
	'SA' => __( 'Saudi Arabia', 'kkart' ),
	'SN' => __( 'Senegal', 'kkart' ),
	'RS' => __( 'Serbia', 'kkart' ),
	'SC' => __( 'Seychelles', 'kkart' ),
	'SL' => __( 'Sierra Leone', 'kkart' ),
	'SG' => __( 'Singapore', 'kkart' ),
	'SK' => __( 'Slovakia', 'kkart' ),
	'SI' => __( 'Slovenia', 'kkart' ),
	'SB' => __( 'Solomon Islands', 'kkart' ),
	'SO' => __( 'Somalia', 'kkart' ),
	'ZA' => __( 'South Africa', 'kkart' ),
	'GS' => __( 'South Georgia/Sandwich Islands', 'kkart' ),
	'KR' => __( 'South Korea', 'kkart' ),
	'SS' => __( 'South Sudan', 'kkart' ),
	'ES' => __( 'Spain', 'kkart' ),
	'LK' => __( 'Sri Lanka', 'kkart' ),
	'SD' => __( 'Sudan', 'kkart' ),
	'SR' => __( 'Suriname', 'kkart' ),
	'SJ' => __( 'Svalbard and Jan Mayen', 'kkart' ),
	'SZ' => __( 'Swaziland', 'kkart' ),
	'SE' => __( 'Sweden', 'kkart' ),
	'CH' => __( 'Switzerland', 'kkart' ),
	'SY' => __( 'Syria', 'kkart' ),
	'TW' => __( 'Taiwan', 'kkart' ),
	'TJ' => __( 'Tajikistan', 'kkart' ),
	'TZ' => __( 'Tanzania', 'kkart' ),
	'TH' => __( 'Thailand', 'kkart' ),
	'TL' => __( 'Timor-Leste', 'kkart' ),
	'TG' => __( 'Togo', 'kkart' ),
	'TK' => __( 'Tokelau', 'kkart' ),
	'TO' => __( 'Tonga', 'kkart' ),
	'TT' => __( 'Trinidad and Tobago', 'kkart' ),
	'TN' => __( 'Tunisia', 'kkart' ),
	'TR' => __( 'Turkey', 'kkart' ),
	'TM' => __( 'Turkmenistan', 'kkart' ),
	'TC' => __( 'Turks and Caicos Islands', 'kkart' ),
	'TV' => __( 'Tuvalu', 'kkart' ),
	'UG' => __( 'Uganda', 'kkart' ),
	'UA' => __( 'Ukraine', 'kkart' ),
	'AE' => __( 'United Arab Emirates', 'kkart' ),
	'GB' => __( 'United Kingdom (UK)', 'kkart' ),
	'US' => __( 'United States (US)', 'kkart' ),
	'UM' => __( 'United States (US) Minor Outlying Islands', 'kkart' ),
	'UY' => __( 'Uruguay', 'kkart' ),
	'UZ' => __( 'Uzbekistan', 'kkart' ),
	'VU' => __( 'Vanuatu', 'kkart' ),
	'VA' => __( 'Vatican', 'kkart' ),
	'VE' => __( 'Venezuela', 'kkart' ),
	'VN' => __( 'Vietnam', 'kkart' ),
	'VG' => __( 'Virgin Islands (British)', 'kkart' ),
	'VI' => __( 'Virgin Islands (US)', 'kkart' ),
	'WF' => __( 'Wallis and Futuna', 'kkart' ),
	'EH' => __( 'Western Sahara', 'kkart' ),
	'WS' => __( 'Samoa', 'kkart' ),
	'YE' => __( 'Yemen', 'kkart' ),
	'ZM' => __( 'Zambia', 'kkart' ),
	'ZW' => __( 'Zimbabwe', 'kkart' ),
);
