
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `shopware6751`
--


-- --------------------------------------------------------

--
-- Table structure for table `acl_role`
--

CREATE TABLE `acl_role` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `privileges` json NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `deleted_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `acl_user_role`
--

CREATE TABLE `acl_user_role` (
  `user_id` binary(16) NOT NULL,
  `acl_role_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`user_id`,`acl_role_id`),
  KEY `fk.acl_user_role.acl_role_id` (`acl_role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app`
--

CREATE TABLE `app` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(4096) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `copyright` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `license` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `privacy` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `base_app_url` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `allow_disable` tinyint(1) NOT NULL DEFAULT '1',
  `configurable` tinyint(1) NOT NULL DEFAULT '0',
  `icon` mediumblob,
  `app_secret` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `modules` json DEFAULT NULL,
  `main_module` json DEFAULT NULL,
  `cookies` json DEFAULT NULL,
  `allowed_hosts` json DEFAULT NULL,
  `integration_id` binary(16) NOT NULL,
  `acl_role_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `template_load_priority` int DEFAULT '0',
  `checkout_gateway_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `self_managed` tinyint(1) NOT NULL DEFAULT '0',
  `source_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'local',
  `source_config` json NOT NULL DEFAULT (json_object()),
  `in_app_purchases_gateway_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `requested_privileges` json NOT NULL DEFAULT (json_array()),
  `context_gateway_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.name` (`name`),
  KEY `fk.app.integration_id` (`integration_id`),
  KEY `fk.app.acl_role_id` (`acl_role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_action_button`
--

CREATE TABLE `app_action_button` (
  `id` binary(16) NOT NULL,
  `entity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `view` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `app_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.app_action_button.action` (`action`,`app_id`),
  KEY `fk.app_action_button.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_action_button_translation`
--

CREATE TABLE `app_action_button_translation` (
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `app_action_button_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  PRIMARY KEY (`app_action_button_id`,`language_id`),
  KEY `fk.app_action_button_translation.app_action_button_id` (`app_action_button_id`),
  KEY `fk.app_action_button_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_administration_snippet`
--

CREATE TABLE `app_administration_snippet` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `locale_id` binary(16) NOT NULL,
  `value` json NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.app_id` (`app_id`),
  KEY `fk.locale_id` (`locale_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_cms_block`
--

CREATE TABLE `app_cms_block` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `block` json NOT NULL,
  `template` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `styles` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.app_cms_block.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_cms_block_translation`
--

CREATE TABLE `app_cms_block_translation` (
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `app_cms_block_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`app_cms_block_id`,`language_id`),
  KEY `fk.app_cms_block_translation.app_cms_block_id` (`app_cms_block_id`),
  KEY `fk.app_cms_block_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_config`
--

CREATE TABLE `app_config` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_flow_action`
--

CREATE TABLE `app_flow_action` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `badge` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL,
  `delayable` tinyint(1) NOT NULL DEFAULT '0',
  `parameters` json DEFAULT NULL,
  `config` json DEFAULT NULL,
  `headers` json DEFAULT NULL,
  `requirements` json DEFAULT NULL,
  `icon` mediumblob,
  `sw_icon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.app_flow_action.name` (`name`),
  KEY `fk.app_flow_action.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_flow_action_translation`
--

CREATE TABLE `app_flow_action_translation` (
  `app_flow_action_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `headline` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`app_flow_action_id`,`language_id`),
  KEY `fk.app_flow_action_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_flow_event`
--

CREATE TABLE `app_flow_event` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `aware` json NOT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `uniq.app_flow_event.name` (`name`),
  KEY `fk.app_flow_event.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_payment_method`
--

CREATE TABLE `app_payment_method` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) DEFAULT NULL,
  `payment_method_id` binary(16) NOT NULL,
  `app_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pay_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `finalize_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `validate_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `capture_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `refund_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `original_media_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `recurring_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.app_payment_method.payment_method_id` (`payment_method_id`),
  KEY `fk.app_payment_method.app_id` (`app_id`),
  KEY `fk.app_payment_method.original_media_id` (`original_media_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_script_condition`
--

CREATE TABLE `app_script_condition` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `group` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `script` longtext COLLATE utf8mb4_unicode_ci,
  `constraints` longblob,
  `config` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.app_script_condition.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_script_condition_translation`
--

CREATE TABLE `app_script_condition_translation` (
  `app_script_condition_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`app_script_condition_id`,`language_id`),
  KEY `fk.app_script_condition_translation.app_script_condition_id` (`app_script_condition_id`),
  KEY `fk.app_script_condition_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_shipping_method`
--

CREATE TABLE `app_shipping_method` (
  `id` binary(16) NOT NULL,
  `app_id` binary(16) DEFAULT NULL,
  `app_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_method_id` binary(16) NOT NULL,
  `original_media_id` binary(16) DEFAULT NULL,
  `identifier` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.app_shipping_method.shipping_method_id` (`shipping_method_id`),
  KEY `fk.app_shipping_method.app_id` (`app_id`),
  KEY `fk.app_shipping_method.original_media_id` (`original_media_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_template`
--

CREATE TABLE `app_template` (
  `id` binary(16) NOT NULL,
  `template` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL,
  `app_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.template.path` (`path`(256)),
  KEY `fk.template.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `app_translation`
--

CREATE TABLE `app_translation` (
  `app_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `privacy_policy_extensions` mediumtext COLLATE utf8mb4_unicode_ci,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`app_id`,`language_id`),
  KEY `fk.app_translation.app_id` (`app_id`),
  KEY `fk.app_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `cart`
--

CREATE TABLE `cart` (
  `token` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rule_ids` json NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `auto_increment` bigint NOT NULL AUTO_INCREMENT,
  `compressed` tinyint(1) NOT NULL DEFAULT '0',
  `payload` longblob,
  PRIMARY KEY (`token`),
  UNIQUE KEY `auto_increment` (`auto_increment`),
  KEY `idx.cart.created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `category`
--

CREATE TABLE `category` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL,
  `auto_increment` int NOT NULL AUTO_INCREMENT,
  `parent_id` binary(16) DEFAULT NULL,
  `parent_version_id` binary(16) DEFAULT NULL,
  `media_id` binary(16) DEFAULT NULL,
  `cms_page_id` binary(16) DEFAULT NULL,
  `cms_page_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `product_stream_id` binary(16) DEFAULT NULL,
  `product_assignment_type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'product',
  `path` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `after_category_id` binary(16) DEFAULT NULL,
  `after_category_version_id` binary(16) DEFAULT NULL,
  `level` int unsigned NOT NULL DEFAULT '1',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `child_count` int unsigned NOT NULL DEFAULT '0',
  `display_nested_products` tinyint unsigned NOT NULL DEFAULT '1',
  `visible` tinyint unsigned NOT NULL DEFAULT '1',
  `type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `custom_entity_type_id` binary(16) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  UNIQUE KEY `auto_increment` (`auto_increment`),
  KEY `idx.level` (`level`),
  KEY `fk.category.media_id` (`media_id`),
  KEY `fk.category.parent_id` (`parent_id`,`parent_version_id`),
  KEY `fk.category.after_category_id` (`after_category_id`,`after_category_version_id`),
  KEY `fk.category.product_stream_id` (`product_stream_id`),
  KEY `fk.category.cms_page_id` (`cms_page_id`,`cms_page_version_id`),
  KEY `fk.category.custom_entity_type_id` (`custom_entity_type_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `category`
--

INSERT INTO `category` VALUES
('vrrz31', 'jK¾Ku,4%', 1, NULL, NULL, NULL, NULL, 'jK¾Ku,4%', NULL, 'product', NULL, NULL, NULL, 1, 1, 0, 1, 1, 'page', '[[regtime_]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `category_tag`
--

CREATE TABLE `category_tag` (
  `category_id` binary(16) NOT NULL,
  `category_version_id` binary(16) NOT NULL,
  `tag_id` binary(16) NOT NULL,
  PRIMARY KEY (`category_id`,`category_version_id`,`tag_id`),
  KEY `fk.category_tag.tag_id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `category_translation`
--

CREATE TABLE `category_translation` (
  `category_id` binary(16) NOT NULL,
  `category_version_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `breadcrumb` json DEFAULT NULL,
  `internal_link` binary(16) DEFAULT NULL,
  `link_new_tab` tinyint DEFAULT NULL,
  `link_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `external_link` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `meta_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `slot_config` json DEFAULT NULL,
  PRIMARY KEY (`category_id`,`category_version_id`,`language_id`),
  KEY `fk.category_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `category_translation`
--

INSERT INTO `category_translation` VALUES
('vrrz31', 'jK¾Ku,4%', 'jlrm%LL7WJ', 'Home', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL, NULL),
('vrrz31', 'jK¾Ku,4%', '/_MpXT|', 'Home', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_block`
--

CREATE TABLE `cms_block` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `cms_section_id` binary(16) DEFAULT NULL,
  `cms_section_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `position` int NOT NULL,
  `section_position` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT 'main',
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `margin_top` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `margin_bottom` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `margin_left` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `margin_right` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `background_color` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `background_media_id` binary(16) DEFAULT NULL,
  `background_media_mode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visibility` json DEFAULT NULL,
  `css_class` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.cms_block.background_media_id` (`background_media_id`),
  KEY `fk.cms_block.cms_section_id` (`cms_section_id`,`cms_section_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_block`
--

INSERT INTO `cms_block` VALUES
('|ys(', 'jK¾Ku,4%', '%r]ЮK', 'jK¾Ku,4%', 3, 'main', 'product-listing', 'Category listing', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('|ys(-', 'jK¾Ku,4%', '%r]ЮK', 'jK¾Ku,4%', 1, 'main', 'image-text', 'Category info', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('qv3*', 'jK¾Ku,4%', '%r]ЮK', 'jK¾Ku,4%', 2, 'main', 'sidebar-filter', 'Filter', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('	pԡfA', 'jK¾Ku,4%', '\0phx8', 'jK¾Ku,4%', 1, 'main', 'image-text', 'Category info', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('	pԡg4o', 'jK¾Ku,4%', '\0phx', 'jK¾Ku,4%', 1, 'sidebar', 'category-navigation', 'Sidebar navigation', 1, NULL, '30px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('	pԡg)', 'jK¾Ku,4%', '\0phx', 'jK¾Ku,4%', 2, 'sidebar', 'sidebar-filter', 'Sidebar filter', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('	pԡg\r', 'jK¾Ku,4%', '\0phx', 'jK¾Ku,4%', 2, 'main', 'product-listing', 'Category listing', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
(']p$[', 'jK¾Ku,4%', 'ZpvZ^', 'jK¾Ku,4%', 1, 'main', 'form', 'Contact form', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('up8J', 'jK¾Ku,4%', 'rpW\\y', 'jK¾Ku,4%', 1, 'main', 'form', 'Newsletter form', 1, '20px', '20px', NULL, NULL, NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('Np:e{?', 'jK¾Ku,4%', 'Np:e{@', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('lpB	_.X', 'jK¾Ku,4%', 'lpB	_.ev', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('p0-KB8', 'jK¾Ku,4%', 'p0-J`', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('s"-pB', 'jK¾Ku,4%', 's"-Ƨ', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('sȉ^B!', 'jK¾Ku,4%', 'sȉ^ATw@', 'jK¾Ku,4%', 0, 'main', 'text', NULL, 0, '20px', '20px', '20px', '20px', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('\0s¶_Z[', 'jK¾Ku,4%', '\0sORx', 'jK¾Ku,4%', 0, 'main', 'product-heading', 'Product heading', 1, '0', '20px', '0', '0', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('\0s¶_0c', 'jK¾Ku,4%', '\0sORx', 'jK¾Ku,4%', 1, 'main', 'gallery-buybox', 'Gallery buy box', 1, '20px', '0', '0', '0', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('\0s¶_vg', 'jK¾Ku,4%', '\0sORx', 'jK¾Ku,4%', 2, 'main', 'product-description-reviews', 'Product description and reviews', 1, '20px', '20px', '0', '0', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('\0s¶_Ĕ', 'jK¾Ku,4%', '\0sORx', 'jK¾Ku,4%', 3, 'main', 'cross-selling', 'Cross selling', 1, '0', '0', '0', '0', NULL, NULL, 'cover', NULL, NULL, NULL, '[[regtime_]]', NULL),
('si\ZE', 'jK¾Ku,4%', '%r]ЮK', 'jK¾Ku,4%', 0, 'main', 'text', 'Category name', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('%s0b', 'jK¾Ku,4%', '\0phx8', 'jK¾Ku,4%', 0, 'main', 'text', 'Category name', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_page`
--

CREATE TABLE `cms_page` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `entity` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `preview_media_id` binary(16) DEFAULT NULL,
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `css_class` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `config` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.cms_page.preview_media_id` (`preview_media_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_page`
--

INSERT INTO `cms_page` VALUES
('|npݖ 4', 'jK¾Ku,4%', 'product_list', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL),
('sB)B', 'jK¾Ku,4%', 'product_list', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL),
('MpǮ+L;Լ', 'jK¾Ku,4%', 'page', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL),
('isW;m', 'jK¾Ku,4%', 'page', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL),
('Np:e{-$', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('lpB	_.''', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('p0-JS', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('s"-', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('sȉ^@V%', 'jK¾Ku,4%', 'page', NULL, NULL, 0, NULL, NULL, '[[regtime_]]', NULL),
('zm%:g @7oB', 'jK¾Ku,4%', 'product_detail', NULL, NULL, 1, NULL, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_page_translation`
--

CREATE TABLE `cms_page_translation` (
  `cms_page_id` binary(16) NOT NULL,
  `cms_page_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`cms_page_id`,`language_id`,`cms_page_version_id`),
  KEY `fk.cms_page_translation.language_id` (`language_id`),
  KEY `fk.cms_page_translation.cms_page_id` (`cms_page_id`,`cms_page_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_page_translation`
--

INSERT INTO `cms_page_translation` VALUES
('|npݖ 4', 'jK¾Ku,4%', 'jlrm%LL7WJ', 'Standard Kategorie-Layout', NULL, '[[regtime_]]', NULL),
('|npݖ 4', 'jK¾Ku,4%', '/_MpXT|', 'Default listing layout', NULL, '[[regtime_]]', NULL),
('sB)B', 'jK¾Ku,4%', 'jlrm%LL7WJ', 'Standard Kategorie-Layout mit Sidebar', NULL, '[[regtime_]]', NULL),
('sB)B', 'jK¾Ku,4%', '/_MpXT|', 'Default listing layout with sidebar', NULL, '[[regtime_]]', NULL),
('MpǮ+L;Լ', 'jK¾Ku,4%', 'jlrm%LL7WJ', 'Standard Shopseiten-Layout mit Kontaktformular', NULL, '[[regtime_]]', NULL),
('MpǮ+L;Լ', 'jK¾Ku,4%', '/_MpXT|', 'Default shop page layout with contact form', NULL, '[[regtime_]]', NULL),
('isW;m', 'jK¾Ku,4%', 'jlrm%LL7WJ', 'Standard Shopseiten-Layout mit Newsletterformular', NULL, '[[regtime_]]', NULL),
('isW;m', 'jK¾Ku,4%', '/_MpXT|', 'Default shop page layout with newsletter form', NULL, '[[regtime_]]', NULL),
('Np:e{-$', 'jK¾Ku,4%', 'jlrm%LL7WJ', 'Versand und Zahlung', NULL, '[[regtime_]]', NULL),
('Np:e{-$', 'jK¾Ku,4%', '/_MpXT|', 'Payment / Shipping', NULL, '[[regtime_]]', NULL),
('lpB	_.''', 'jK¾Ku,4%', 'jlrm%LL7WJ', 'AGB', NULL, '[[regtime_]]', NULL),
('lpB	_.''', 'jK¾Ku,4%', '/_MpXT|', 'Terms of service', NULL, '[[regtime_]]', NULL),
('p0-JS', 'jK¾Ku,4%', 'jlrm%LL7WJ', 'Widerrufsbelehrungen', NULL, '[[regtime_]]', NULL),
('p0-JS', 'jK¾Ku,4%', '/_MpXT|', 'Right of rescission', NULL, '[[regtime_]]', NULL),
('s"-', 'jK¾Ku,4%', 'jlrm%LL7WJ', 'Datenschutz', NULL, '[[regtime_]]', NULL),
('s"-', 'jK¾Ku,4%', '/_MpXT|', 'Privacy', NULL, '[[regtime_]]', NULL),
('sȉ^@V%', 'jK¾Ku,4%', 'jlrm%LL7WJ', 'Impressum', NULL, '[[regtime_]]', NULL),
('sȉ^@V%', 'jK¾Ku,4%', '/_MpXT|', 'Imprint', NULL, '[[regtime_]]', NULL),
('zm%:g @7oB', 'jK¾Ku,4%', 'jlrm%LL7WJ', 'Standard Produktseite-Layout', NULL, '[[regtime_]]', NULL),
('zm%:g @7oB', 'jK¾Ku,4%', '/_MpXT|', 'Default product page Layout', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_section`
--

CREATE TABLE `cms_section` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `cms_page_id` binary(16) NOT NULL,
  `cms_page_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `position` int NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `sizing_mode` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'boxed',
  `mobile_behavior` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'wrap',
  `background_color` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `background_media_id` binary(16) DEFAULT NULL,
  `background_media_mode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visibility` json DEFAULT NULL,
  `css_class` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.cms_section.background_media_id` (`background_media_id`),
  KEY `fk.cms_section.cms_page_id` (`cms_page_id`,`cms_page_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_section`
--

INSERT INTO `cms_section` VALUES
('%r]ЮK', 'jK¾Ku,4%', '|npݖ 4', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('\0phx8', 'jK¾Ku,4%', 'sB)B', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('\0phx', 'jK¾Ku,4%', 'sB)B', 'jK¾Ku,4%', 1, 'sidebar', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('ZpvZ^', 'jK¾Ku,4%', 'MpǮ+L;Լ', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('rpW\\y', 'jK¾Ku,4%', 'isW;m', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('Np:e{@', 'jK¾Ku,4%', 'Np:e{-$', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('lpB	_.ev', 'jK¾Ku,4%', 'lpB	_.''', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('p0-J`', 'jK¾Ku,4%', 'p0-JS', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('s"-Ƨ', 'jK¾Ku,4%', 's"-', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('sȉ^ATw@', 'jK¾Ku,4%', 'sȉ^@V%', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('\0sORx', 'jK¾Ku,4%', 'zm%:g @7oB', 'jK¾Ku,4%', 0, 'default', NULL, 0, 'boxed', 'wrap', NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_slot`
--

CREATE TABLE `cms_slot` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL,
  `cms_block_id` binary(16) NOT NULL,
  `cms_block_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slot` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.cms_slot.cms_block_id` (`cms_block_id`,`cms_block_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_slot`
--

INSERT INTO `cms_slot` VALUES
('|s0/]#W', 'jK¾Ku,4%', '|ys(', 'jK¾Ku,4%', 'product-listing', 'content', 1, '[[regtime_]]', NULL),
('|s0/]c7', 'jK¾Ku,4%', '|ys(-', 'jK¾Ku,4%', 'image', 'left', 1, '[[regtime_]]', NULL),
('|s0/]nX', 'jK¾Ku,4%', '|ys(-', 'jK¾Ku,4%', 'text', 'right', 1, '[[regtime_]]', NULL),
('ssZY', 'jK¾Ku,4%', 'qv3*', 'jK¾Ku,4%', 'sidebar-filter', 'content', 1, '[[regtime_]]', NULL),
('p\nU', 'jK¾Ku,4%', '	pԡfA', 'jK¾Ku,4%', 'image', 'left', 1, '[[regtime_]]', NULL),
('p\nР', 'jK¾Ku,4%', '	pԡfA', 'jK¾Ku,4%', 'text', 'right', 1, '[[regtime_]]', NULL),
('p\n0', 'jK¾Ku,4%', '	pԡg4o', 'jK¾Ku,4%', 'category-navigation', 'content', 1, '[[regtime_]]', NULL),
('p\nR', 'jK¾Ku,4%', '	pԡg)', 'jK¾Ku,4%', 'sidebar-filter', 'content', 1, '[[regtime_]]', NULL),
('p\nߧ', 'jK¾Ku,4%', '	pԡg)', 'jK¾Ku,4%', 'sidebar-filter', 'content', 1, '[[regtime_]]', NULL),
('p\nq', 'jK¾Ku,4%', '	pԡg\r', 'jK¾Ku,4%', 'product-listing', 'content', 1, '[[regtime_]]', NULL),
('`q&9}+I', 'jK¾Ku,4%', ']p$[', 'jK¾Ku,4%', 'form', 'content', 1, '[[regtime_]]', NULL),
('xrG@s', 'jK¾Ku,4%', 'up8J', 'jK¾Ku,4%', 'form', 'content', 1, '[[regtime_]]', NULL),
('Np:e{⥉', 'jK¾Ku,4%', 'Np:e{?', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('lpB	_/', 'jK¾Ku,4%', 'lpB	_.X', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('p0-KvO6', 'jK¾Ku,4%', 'p0-KB8', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('s"-v', 'jK¾Ku,4%', 's"-pB', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('sȉ^C}', 'jK¾Ku,4%', 'sȉ^B!', 'jK¾Ku,4%', 'text', 'content', 0, '[[regtime_]]', NULL),
('\0p<o', 'jK¾Ku,4%', '\0s¶_Z[', 'jK¾Ku,4%', 'product-name', 'left', 1, '[[regtime_]]', NULL),
('\0p<oAI', 'jK¾Ku,4%', '\0s¶_Z[', 'jK¾Ku,4%', 'manufacturer-logo', 'right', 1, '[[regtime_]]', NULL),
('\0p<o\Z!', 'jK¾Ku,4%', '\0s¶_0c', 'jK¾Ku,4%', 'image-gallery', 'left', 1, '[[regtime_]]', NULL),
('\0p<o:', 'jK¾Ku,4%', '\0s¶_0c', 'jK¾Ku,4%', 'buy-box', 'right', 1, '[[regtime_]]', NULL),
('\0p<o$', 'jK¾Ku,4%', '\0s¶_vg', 'jK¾Ku,4%', 'product-description-reviews', 'content', 1, '[[regtime_]]', NULL),
('\0p<oz', 'jK¾Ku,4%', '\0s¶_Ĕ', 'jK¾Ku,4%', 'cross-selling', 'content', 1, '[[regtime_]]', NULL),
('pN', 'jK¾Ku,4%', 'si\ZE', 'jK¾Ku,4%', 'text', 'content', 1, '[[regtime_]]', NULL),
('(sƢ89', 'jK¾Ku,4%', '%s0b', 'jK¾Ku,4%', 'text', 'content', 1, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `cms_slot_translation`
--

CREATE TABLE `cms_slot_translation` (
  `cms_slot_id` binary(16) NOT NULL,
  `cms_slot_version_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `config` json DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`cms_slot_id`,`cms_slot_version_id`,`language_id`),
  KEY `fk.cms_slot_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `cms_slot_translation`
--

INSERT INTO `cms_slot_translation` VALUES
('|s0/]#W', 'jK¾Ku,4%', 'jlrm%LL7WJ', '{"boxLayout": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('|s0/]#W', 'jK¾Ku,4%', '/_MpXT|', '{"boxLayout": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('|s0/]c7', 'jK¾Ku,4%', 'jlrm%LL7WJ', '{"url": {"value": null, "source": "static"}, "media": {"value": "category.media", "source": "mapped"}, "newTab": {"value": false, "source": "static"}, "minHeight": {"value": "320px", "source": "static"}, "displayMode": {"value": "cover", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('|s0/]c7', 'jK¾Ku,4%', '/_MpXT|', '{"url": {"value": null, "source": "static"}, "media": {"value": "category.media", "source": "mapped"}, "newTab": {"value": false, "source": "static"}, "minHeight": {"value": "320px", "source": "static"}, "displayMode": {"value": "cover", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('|s0/]nX', 'jK¾Ku,4%', 'jlrm%LL7WJ', '{"content": {"value": "category.description", "source": "mapped"}}', NULL, '[[regtime_]]', NULL),
('|s0/]nX', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "category.description", "source": "mapped"}}', NULL, '[[regtime_]]', NULL),
('ssZY', 'jK¾Ku,4%', '/_MpXT|', NULL, NULL, '[[regtime_]]', NULL),
('p\nU', 'jK¾Ku,4%', 'jlrm%LL7WJ', '{"url": {"value": null, "source": "static"}, "media": {"value": "category.media", "source": "mapped"}, "newTab": {"value": false, "source": "static"}, "minHeight": {"value": "320px", "source": "static"}, "displayMode": {"value": "cover", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('p\nU', 'jK¾Ku,4%', '/_MpXT|', '{"url": {"value": null, "source": "static"}, "media": {"value": "category.media", "source": "mapped"}, "newTab": {"value": false, "source": "static"}, "minHeight": {"value": "320px", "source": "static"}, "displayMode": {"value": "cover", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('p\nР', 'jK¾Ku,4%', 'jlrm%LL7WJ', '{"content": {"value": "category.description", "source": "mapped"}}', NULL, '[[regtime_]]', NULL),
('p\nР', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "category.description", "source": "mapped"}}', NULL, '[[regtime_]]', NULL),
('p\n0', 'jK¾Ku,4%', 'jlrm%LL7WJ', NULL, NULL, '[[regtime_]]', NULL),
('p\n0', 'jK¾Ku,4%', '/_MpXT|', NULL, NULL, '[[regtime_]]', NULL),
('p\nR', 'jK¾Ku,4%', 'jlrm%LL7WJ', '{"boxLayout": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('p\nR', 'jK¾Ku,4%', '/_MpXT|', '{"boxLayout": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('`q&9}+I', 'jK¾Ku,4%', 'jlrm%LL7WJ', '{"type": {"value": "contact", "source": "static"}, "mailReceiver": {"value": [], "source": "static"}, "confirmationText": {"value": "", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('`q&9}+I', 'jK¾Ku,4%', '/_MpXT|', '{"type": {"value": "contact", "source": "static"}, "mailReceiver": {"value": [], "source": "static"}, "confirmationText": {"value": "", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('xrG@s', 'jK¾Ku,4%', 'jlrm%LL7WJ', '{"type": {"value": "newsletter", "source": "static"}, "mailReceiver": {"value": [], "source": "static"}, "confirmationText": {"value": "", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('xrG@s', 'jK¾Ku,4%', '/_MpXT|', '{"type": {"value": "newsletter", "source": "static"}, "mailReceiver": {"value": [], "source": "static"}, "confirmationText": {"value": "", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Np:e{⥉', 'jK¾Ku,4%', 'jlrm%LL7WJ', '{"content": {"value": "<h2>Versand und Zahlung</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('Np:e{⥉', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Payment / Shipping</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('lpB	_/', 'jK¾Ku,4%', 'jlrm%LL7WJ', '{"content": {"value": "<h2>AGB</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('lpB	_/', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Terms of service</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('p0-KvO6', 'jK¾Ku,4%', 'jlrm%LL7WJ', '{"content": {"value": "<h2>Widerrufsbelehrungen</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('p0-KvO6', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Right of rescission</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('s"-v', 'jK¾Ku,4%', 'jlrm%LL7WJ', '{"content": {"value": "<h2>Datenschutz</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('s"-v', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Privacy</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('sȉ^C}', 'jK¾Ku,4%', 'jlrm%LL7WJ', '{"content": {"value": "<h2>Impressum</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('sȉ^C}', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h2>Imprint</h2><hr><p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.</p>", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('\0p<o', 'jK¾Ku,4%', 'jlrm%LL7WJ', '{"content": {"value": "product.name", "source": "mapped"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('\0p<o', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "product.name", "source": "mapped"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('\0p<oAI', 'jK¾Ku,4%', 'jlrm%LL7WJ', '{"url": {"value": null, "source": "static"}, "media": {"value": "product.manufacturer.media", "source": "mapped"}, "newTab": {"value": true, "source": "static"}, "minHeight": {"value": null, "source": "static"}, "displayMode": {"value": "standard", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('\0p<oAI', 'jK¾Ku,4%', '/_MpXT|', '{"url": {"value": null, "source": "static"}, "media": {"value": "product.manufacturer.media", "source": "mapped"}, "newTab": {"value": true, "source": "static"}, "minHeight": {"value": null, "source": "static"}, "displayMode": {"value": "standard", "source": "static"}, "verticalAlign": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('\0p<o\Z!', 'jK¾Ku,4%', 'jlrm%LL7WJ', '{"zoom": {"value": true, "source": "static"}, "minHeight": {"value": "430px", "source": "static"}, "fullScreen": {"value": true, "source": "static"}, "displayMode": {"value": "contain", "source": "static"}, "sliderItems": {"value": "product.media", "source": "mapped"}, "verticalAlign": {"value": null, "source": "static"}, "navigationDots": {"value": "inside", "source": "static"}, "galleryPosition": {"value": "left", "source": "static"}, "navigationArrows": {"value": "inside", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('\0p<o\Z!', 'jK¾Ku,4%', '/_MpXT|', '{"zoom": {"value": true, "source": "static"}, "minHeight": {"value": "430px", "source": "static"}, "fullScreen": {"value": true, "source": "static"}, "displayMode": {"value": "contain", "source": "static"}, "sliderItems": {"value": "product.media", "source": "mapped"}, "verticalAlign": {"value": null, "source": "static"}, "navigationDots": {"value": "inside", "source": "static"}, "galleryPosition": {"value": "left", "source": "static"}, "navigationArrows": {"value": "inside", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('\0p<o:', 'jK¾Ku,4%', 'jlrm%LL7WJ', '{"product": {"value": null, "source": "static"}, "alignment": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('\0p<o:', 'jK¾Ku,4%', '/_MpXT|', '{"product": {"value": null, "source": "static"}, "alignment": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('\0p<o$', 'jK¾Ku,4%', 'jlrm%LL7WJ', '{"product": {"value": null, "source": "static"}, "alignment": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('\0p<o$', 'jK¾Ku,4%', '/_MpXT|', '{"product": {"value": null, "source": "static"}, "alignment": {"value": null, "source": "static"}}', NULL, '[[regtime_]]', NULL),
('\0p<oz', 'jK¾Ku,4%', 'jlrm%LL7WJ', '{"product": {"value": null, "source": "static"}, "boxLayout": {"value": "standard", "source": "static"}, "elMinWidth": {"value": "200px", "source": "static"}, "displayMode": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('\0p<oz', 'jK¾Ku,4%', '/_MpXT|', '{"product": {"value": null, "source": "static"}, "boxLayout": {"value": "standard", "source": "static"}, "elMinWidth": {"value": "200px", "source": "static"}, "displayMode": {"value": "standard", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('pN', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h1>{{ category.name }}</h1>", "source": "static"}}', NULL, '[[regtime_]]', NULL),
('(sƢ89', 'jK¾Ku,4%', '/_MpXT|', '{"content": {"value": "<h1>{{ category.name }}</h1>", "source": "static"}}', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `country`
--

CREATE TABLE `country` (
  `id` binary(16) NOT NULL,
  `iso` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` int NOT NULL DEFAULT '1',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `iso3` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `display_state_in_registration` tinyint(1) NOT NULL DEFAULT '0',
  `force_state_in_registration` tinyint(1) NOT NULL DEFAULT '0',
  `check_vat_id_pattern` tinyint(1) NOT NULL DEFAULT '0',
  `vat_id_pattern` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vat_id_required` tinyint(1) NOT NULL DEFAULT '0',
  `customer_tax` json DEFAULT NULL,
  `company_tax` json DEFAULT NULL,
  `advanced_postal_code_pattern` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `check_advanced_postal_code_pattern` tinyint(1) NOT NULL DEFAULT '0',
  `check_postal_code_pattern` tinyint(1) NOT NULL DEFAULT '0',
  `default_postal_code_pattern` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postal_code_required` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `shipping_available` tinyint(1) NOT NULL DEFAULT '1',
  `is_eu` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `country`
--

INSERT INTO `country` VALUES
('js', 'DE', 1, 1, 'DEU', 0, 0, 0, 'DE\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('kqzݳ', 'GR', 10, 1, 'GRC', 0, 0, 0, '(EL|GR)\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3} ?\\d{2}', 1, '[[regtime_]]', NULL, 1, 1),
('ks>8W', 'GB', 5, 1, 'GBR', 0, 0, 0, '(GB)?([0-9]{9}([0-9]{3})?|[A-Z]{2}[0-9]{3})', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '^GIR ?0AA$|^(?:(?:AB|AL|B|BA|BB|BD|BH|BL|BN|BR|BS|BT|BX|CA|CB|CF|CH|CM|CO|CR|CT|CV|CW|DA|DD|DE|DG|DH|DL|DN|DT|DY|E|EC|EH|EN|EX|FK|FY|G|GL|GY|GU|HA|HD|HG|HP|HR|HS|HU|HX|IG|IM|IP|IV|JE|KA|KT|KW|KY|L|LA|LD|LE|LL|LN|LS|LU|M|ME|MK|ML|N|NE|NG|NN|NP|NR|NW|OL|OX|PA|PE|PH|PL|PO|PR|RG|RH|RM|S|SA|SE|SG|SK|SL|SM|SN|SO|SP|SR|SS|ST|SW|SY|TA|TD|TF|TN|TQ|TR|TS|TW|UB|W|WA|WC|WD|WF|WN|WR|WS|WV|YO|ZE)(?:\\d[\\dA-Z]? ?\\d[ABD-HJLN-UW-Z]{2}))$|^BFPO ?\\d{1,4}$', 1, '[[regtime_]]', NULL, 1, 0),
('qpIwEc', 'IE', 10, 1, 'IRL', 0, 0, 0, 'IE(\\d{7}[A-Z]{1,2}|(\\d{1}[A-Z]{1}\\d{5}[A-Z]{1}))', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[\\dA-Z]{3}( ?[\\dA-Z]{4})?', 1, '[[regtime_]]', NULL, 1, 1),
('qqH]u', 'IS', 10, 1, 'ISL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('qqtw''L', 'IT', 10, 1, 'ITA', 0, 0, 0, 'IT\\d{11}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('qrӥG&', 'JP', 10, 1, 'JPN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}-?\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('qpX粣}xI', 'CA', 10, 1, 'CAN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[ABCEGHJKLMNPRSTVXY]\\d[ABCEGHJ-NPRSTV-Z] ?\\d[ABCEGHJ-NPRSTV-Z]\\d', 1, '[[regtime_]]', NULL, 1, 0),
('qrah', 'LU', 10, 1, 'LUX', 0, 0, 0, 'LU\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('qqRᲭ', 'NA', 10, 1, 'NAM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('qp''$1,', 'NL', 10, 1, 'NLD', 0, 0, 0, 'NL\\d{9}B\\d{2}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[1-9]{1}\\d{3}([ ]?[A-Z]{2})', 1, '[[regtime_]]', NULL, 1, 1),
('qpG4uS', 'NO', 10, 1, 'NOR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('qp!Z=', 'AT', 10, 1, 'AUT', 0, 0, 0, 'ATU\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('qpjx', 'PT', 10, 1, 'PRT', 0, 0, 0, 'PT\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}-\\d{3}', 1, '[[regtime_]]', NULL, 1, 1),
('rr8:\Z,', 'SE', 10, 1, 'SWE', 0, 0, 0, 'SE\\d{12}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3} ?\\d{2}', 1, '[[regtime_]]', NULL, 1, 1),
('rrd >i', 'CH', 10, 1, 'CHE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 1, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[1-9]\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('rq5/', 'ES', 10, 1, 'ESP', 0, 0, 0, 'ES[A-Z]\\d{7}[A-Z]$|^ES[A-Z][0-9]{7}[0-9A-Z]$|^ES[0-9]{8}[A-Z]', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '^([0-4]\\d{4}|5[0-2]\\d{3})$', 1, '[[regtime_]]', NULL, 1, 1),
('rq̆\rnq', 'US', 10, 1, 'USA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(\\d{5})(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('t9rٲsUĻ', 'LI', 10, 1, 'LIE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '948[5-9]|949[0-7]', 1, '[[regtime_]]', NULL, 1, 0),
('tBq*;s', 'AE', 10, 1, 'ARE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('tMp	', 'PL', 10, 1, 'POL', 0, 0, 0, 'PL\\d{10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{2}-\\d{3}', 1, '[[regtime_]]', NULL, 1, 1),
('tVq0%.', 'HU', 10, 1, 'HUN', 0, 0, 0, 'HU\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('t_rJ)=', 'TR', 10, 1, 'TUR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('tipھ}@', 'CZ', 10, 1, 'CZE', 0, 0, 0, 'CZ\\d{8,10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3} ?\\d{2}', 1, '[[regtime_]]', NULL, 1, 1),
('tsw\\G', 'SK', 10, 1, 'SVK', 0, 0, 0, 'SK\\d{10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3} ?\\d{2}', 1, '[[regtime_]]', NULL, 1, 1),
('u@qB', 'RO', 10, 1, 'ROU', 0, 0, 0, 'RO(?!0)\\d{1,10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 1),
('upjWJ#]', 'BR', 10, 1, 'BRA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}-?\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('ur1@Y!q', 'IL', 10, 1, 'ISR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}(?:\\d{2})?', 1, '[[regtime_]]', NULL, 1, 0),
('uqlwv', 'AU', 10, 1, 'AUS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('usox]T[', 'BE', 10, 1, 'BEL', 0, 0, 0, 'BE\\d{10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('us,T؉', 'DK', 10, 1, 'DNK', 0, 0, 0, 'DK\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('ur(,', 'FI', 10, 1, 'FIN', 0, 0, 0, 'FI\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('upԃo}', 'FR', 10, 1, 'FRA', 0, 0, 0, 'FR[A-HJ-NP-Z0-9]{2}\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{1}(?:A|B|\\d{1}) ?\\d{3}', 1, '[[regtime_]]', NULL, 1, 1),
('rEsN', 'BG', 10, 1, 'BGR', 0, 0, 0, 'BG\\d{9,10}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('r"YQ', 'EE', 10, 1, 'EST', 0, 0, 0, 'EE\\d{9}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('r(da}', 'HR', 10, 1, 'HRV', 0, 0, 0, 'HR\\d{11}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('r*fqG', 'LV', 10, 1, 'LVA', 0, 0, 0, 'LV\\d{11}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(LV-)?\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('pr笈z', 'LT', 10, 1, 'LTU', 0, 0, 0, 'LT(\\d{12}|\\d{9})', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(LT-)?\\d{5}', 1, '[[regtime_]]', NULL, 1, 1),
('p*Y\nhT', 'MT', 10, 1, 'MLT', 0, 0, 0, 'MT\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[A-Z]{3} ?\\d{2,4}', 1, '[[regtime_]]', NULL, 1, 1),
('q2+?pr2b', 'SI', 10, 1, 'SVN', 0, 0, 0, 'SI\\d{8}', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('s"bx~pr', 'CY', 10, 1, 'CYP', 0, 0, 0, 'CY\\d{8}[A-Z]', 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 1),
('!p͟?4', 'AF', 10, 1, 'AFG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('*q͑~Ǥ', 'AX', 10, 1, 'ALA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '22\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('3s0x;f', 'AL', 10, 1, 'ALB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('<rS+&', 'DZ', 10, 1, 'DZA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Eq($', 'AS', 10, 1, 'ASM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(96799)(?  :[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('NrA`p+\\', 'AD', 10, 1, 'AND', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'AD[1-7]0\\d', 1, '[[regtime_]]', NULL, 1, 0),
('Xp#	o', 'AO', 10, 1, 'AGO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('cq:cMb', 'AI', 10, 1, 'AIA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:AI-)?2640', 1, '[[regtime_]]', NULL, 1, 0),
('lr%@zx', 'AQ', 10, 1, 'ATA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('up\0$jI:', 'AG', 10, 1, 'ATG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('~s޿ߚ]', 'AR', 10, 1, 'ARG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '((?:[A-HJ-NP-Z])?\\d{4})([A-Z]{3})?', 1, '[[regtime_]]', NULL, 1, 0),
('ȇpvjx3', 'AM', 10, 1, 'ARM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:37)?\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Ȑp7y+N', 'AW', 10, 1, 'ABW', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('șrDg]=', 'AZ', 10, 1, 'AZE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ȢrD\n;-', 'BS', 10, 1, 'BHS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ȫp̌wN%', 'BH', 10, 1, 'BHR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:\\d|1[0-2])\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('ȴq_k', 'BD', 10, 1, 'BGD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ȽsZ9tm', 'BB', 10, 1, 'BRB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'BB\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('sr)z', 'BY', 10, 1, 'BLR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('s	-ЄZ', 'BZ', 10, 1, 'BLZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('q''dg~', 'BJ', 10, 1, 'BEN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('r[3', 'BM', 10, 1, 'BMU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[A-Z]{2} ?[A-Z0-9]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('p\Z', 'BT', 10, 1, 'BTN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('p݈)', 'BO', 10, 1, 'BOL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('qT', 'BQ', 10, 1, 'BES', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('qt4Mh', 'BA', 10, 1, 'BIH', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('q ah@K', 'BW', 10, 1, 'BWA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('\Zrh62', 'BV', 10, 1, 'BVT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('$sj', 'IO', 10, 1, 'IOT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Bb]{2}[Nn][Dd]\\s{0,1}[1][Zz]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('/rЦ ''v".', 'UM', 10, 1, 'UMI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '96898', 1, '[[regtime_]]', NULL, 1, 0),
('8qeCgk', 'VG', 10, 1, 'VGB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'VG\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Ar\\e8i', 'VI', 10, 1, 'VIR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(008(?:(?:[0-4]\\d)|(?:5[01])))(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('JpʧdYGe', 'BN', 10, 1, 'BRN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[A-Z]{2} ?\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('SqG3-^', 'BF', 10, 1, 'BFA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('\\s|^l2O4', 'BI', 10, 1, 'BDI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('fq"7P', 'KH', 10, 1, 'KHM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('opֆ;)I', 'CM', 10, 1, 'CMR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('yqP1WH', 'CV', 10, 1, 'CPV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ɂqq', 'KY', 10, 1, 'CYM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'KY\\d-\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ɔrO	uIUF', 'CF', 10, 1, 'CAF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ɪpl	', 'TD', 10, 1, 'TCD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('ɿs1:BEd6', 'CL', 10, 1, 'CHL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{7}', 1, '[[regtime_]]', NULL, 1, 0),
('rfpZ', 'CN', 10, 1, 'CHN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('pds|', 'CX', 10, 1, 'CXR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '6798', 1, '[[regtime_]]', NULL, 1, 0),
('s	\0c', 'CC', 10, 1, 'CCK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '6799', 1, '[[regtime_]]', NULL, 1, 0),
('pڅ{<Iq', 'CO', 10, 1, 'COL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('.sTvڰ', 'KM', 10, 1, 'COM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('>s6BYZ', 'CG', 10, 1, 'COG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('TpZH6>', 'CD', 10, 1, 'COD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Cc][Dd]', 1, '[[regtime_]]', NULL, 1, 0),
('jpm?4i', 'CK', 10, 1, 'COK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('|q\r2.d\Z$', 'CR', 10, 1, 'CRI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4,5}|\\d{3}-\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ʏr..6', 'CU', 10, 1, 'CUB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('ʜrȰz!?[', 'CW', 10, 1, 'CUW', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ʥsꧠ{`8"', 'DJ', 10, 1, 'DJI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ʮr2]4', 'DM', 10, 1, 'DMA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ʸsA&t$ c', 'DO', 10, 1, 'DOM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('rIǂJQ', 'EC', 10, 1, 'ECU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('p/]x', 'EG', 10, 1, 'EGY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('qrs.', 'SV', 10, 1, 'SLV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'CP [1-3][1-7][0-2]\\d', 1, '[[regtime_]]', NULL, 1, 0),
('pSsTaS 0', 'GQ', 10, 1, 'GNQ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('p?#Ȱ17', 'ER', 10, 1, 'ERI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('sJ', 'ET', 10, 1, 'ETH', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('rP', 'FK', 10, 1, 'FLK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Ff][Ii][Qq]{2}\\s{0,1}[1][Zz]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('rO/q\Z', 'FO', 10, 1, 'FRO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('q۠`', 'FJ', 10, 1, 'FJI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('qJ\rd', 'GF', 10, 1, 'GUF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78]3\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
(' qOF', 'PF', 10, 1, 'PYF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '987\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('(pAK$\n:Ӛ', 'TF', 10, 1, 'ATF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('8sTH4', 'GA', 10, 1, 'GAB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{2}\\s[a-zA-Z-_ ]\\s\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('Ap	PR', 'GM', 10, 1, 'GMB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Jsk5', 'GE', 10, 1, 'GEO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Rprd#f', 'GH', 10, 1, 'GHA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('[pS8', 'GI', 10, 1, 'GIB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Gg][Xx][1]{2}\\s{0,1}[1][Aa]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('dpn/f-', 'GL', 10, 1, 'GRL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '39\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('pqut{z', 'GD', 10, 1, 'GRD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('yqN2g', 'GP', 10, 1, 'GLP', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78][01]\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('˅q*Κ䲚', 'GU', 10, 1, 'GUM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(969(?:[12]\\d|3[12]))(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('ˎq99J', 'GT', 10, 1, 'GTM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('˗r|9>_,', 'GG', 10, 1, 'GGY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'GY\\d[\\dA-Z]? ?\\d[ABD-HJLN-UW-Z]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('ˠp&r=LKu', 'GN', 10, 1, 'GIN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('˩p|c', 'GW', 10, 1, 'GNB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('˲p2', 'GY', 10, 1, 'GUY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('˻qgo', 'HT', 10, 1, 'HTI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('s$"Pt', 'HM', 10, 1, 'HMD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('s%_py ?', 'VA', 10, 1, 'VAT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '00120', 1, '[[regtime_]]', NULL, 1, 0),
('pU', 'HN', 10, 1, 'HND', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('s,.', 'HK', 10, 1, 'HKG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '999077', 1, '[[regtime_]]', NULL, 1, 0),
('pUƦc', 'IN', 10, 1, 'IND', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('r\ZϏ+V', 'ID', 10, 1, 'IDN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('r`dS', 'CI', 10, 1, 'CIV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('sz''dgٽP', 'IR', 10, 1, 'IRN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}-?\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('\rpO˟**', 'IQ', 10, 1, 'IRQ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('q''_''V', 'IM', 10, 1, 'IMN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'IM\\d[\\dA-Z]? ?\\d[ABD-HJLN-UW-Z]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('pzI&x', 'JM', 10, 1, 'JAM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[a-zA-Z]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('+qİqW=', 'JE', 10, 1, 'JEY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'JE\\d[\\dA-Z]? ?\\d[ABD-HJLN-UW-Z]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('4p"C@`B', 'JO', 10, 1, 'JOR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('=r{', 'KZ', 10, 1, 'KAZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('FqEJ', 'KE', 10, 1, 'KEN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Rq~ݜi?', 'KI', 10, 1, 'KIR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('[ssy', 'KW', 10, 1, 'KWT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('dr q"K', 'KG', 10, 1, 'KGZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('mr԰%9', 'LA', 10, 1, 'LAO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('vsٿ&Zq ', 'LB', 10, 1, 'LBN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:\\d{4})(?: ?(?:\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('̀r\r3be', 'LS', 10, 1, 'LSO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('̉q&h6ڷ>', 'LR', 10, 1, 'LBR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('̒s3st', 'LY', 10, 1, 'LBY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('̛qM%5U', 'MO', 10, 1, 'MAC', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '999078', 1, '[[regtime_]]', NULL, 1, 0),
('̤ry\r', 'MK', 10, 1, 'MKD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('̯s7ύ-/', 'MG', 10, 1, 'MDG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('̺r\Zcc9', 'MW', 10, 1, 'MWI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('r3''ؔ', 'MY', 10, 1, 'MYS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('rH', 'MV', 10, 1, 'MDV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('q?q', 'ML', 10, 1, 'MLI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('st', 'MH', 10, 1, 'MHL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(969[67]\\d)(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('rV', 'MQ', 10, 1, 'MTQ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78]2\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('p,Ps', 'MR', 10, 1, 'MRT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('rƈǄ	L', 'MU', 10, 1, 'MUS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}(?:\\d{2}|[A-Z]{2}\\d{3})', 1, '[[regtime_]]', NULL, 1, 0),
('s<@3#$h', 'YT', 10, 1, 'MYT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '976\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('\rqj)\0', 'MX', 10, 1, 'MEX', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('q9u', 'FM', 10, 1, 'FSM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(9694[1-4])(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('"s~', 'MD', 10, 1, 'MDA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('0q[hNx)', 'MC', 10, 1, 'MCO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '980\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('9ruuI#,', 'MN', 10, 1, 'MNG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Br"-', 'ME', 10, 1, 'MNE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '8\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Lp["D', 'MS', 10, 1, 'MSR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Mm][Ss][Rr]\\s{0,1}\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Usٸe5R"', 'MA', 10, 1, 'MAR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('^psEk', 'MZ', 10, 1, 'MOZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('gsE(D', 'MM', 10, 1, 'MMR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('xru~~', 'NR', 10, 1, 'NRU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0);
INSERT INTO `country` VALUES
('͎qRaTa', 'NP', 10, 1, 'NPL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('ͥrfp', 'NC', 10, 1, 'NCL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '988\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('ͽr～\r', 'NZ', 10, 1, 'NZL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('p7?%', 'NI', 10, 1, 'NIC', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('pۤ2-', 'NE', 10, 1, 'NER', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('pnn', 'NG', 10, 1, 'NGA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('srYh', 'NU', 10, 1, 'NIU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('*p\Z-', 'NF', 10, 1, 'NFK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '2899', 1, '[[regtime_]]', NULL, 1, 0),
('<rg:fàCȾ', 'KP', 10, 1, 'PRK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Zpa\n ', 'MP', 10, 1, 'MNP', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(9695[012])(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('ir׾c%', 'OM', 10, 1, 'OMN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:PC )?\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('sspIÎ', 'PK', 10, 1, 'PAK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('|s ', 'PW', 10, 1, 'PLW', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(969(?:39|40))(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('΅s|S[', 'PS', 10, 1, 'PSE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Ύpk8>^', 'PA', 10, 1, 'PAN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('Ηp''', 'PG', 10, 1, 'PNG', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('ΠpmxK7', 'PY', 10, 1, 'PRY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('άr/ѯ8b', 'PE', 10, 1, 'PER', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:LIMA \\d{1,2}|CALLAO 0?\\d)|[0-2]\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('εqፕ108T', 'PH', 10, 1, 'PHL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('νr#;M''', 'PN', 10, 1, 'PCN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'PCRN 1ZZ', 1, '[[regtime_]]', NULL, 1, 0),
('rA\0', 'PR', 10, 1, 'PRI', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(00[679]\\d{2})(?:[ \\-](\\d{4}))?', 1, '[[regtime_]]', NULL, 1, 0),
('r9?LA', 'QA', 10, 1, 'QAT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('r*`C', 'XK', 10, 1, 'KOS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[1-7]\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('q20j0', 'RE', 10, 1, 'REU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78]4\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('sJ\n', 'RU', 10, 1, 'RUS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('q\r֛^KQD', 'RW', 10, 1, 'RWA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('qg4@W', 'BL', 10, 1, 'BLM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78][01]\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('q  \n', 'SH', 10, 1, 'SHN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '(?:ASCN|STHL) 1ZZ', 1, '[[regtime_]]', NULL, 1, 0),
('pmE0f?', 'KN', 10, 1, 'KNA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('sKYi@', 'LC', 10, 1, 'LCA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('$r෵Mu', 'MF', 10, 1, 'MAF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78][01]\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('.q9oBN', 'PM', 10, 1, 'SPM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '9[78]5\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('8q\\\rz', 'VC', 10, 1, 'VCT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'VC\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('As򫔩(s', 'WS', 10, 1, 'WSM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Jrp', 'SM', 10, 1, 'SMR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '4789\\d', 1, '[[regtime_]]', NULL, 1, 0),
('Sq:zYV', 'ST', 10, 1, 'STP', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('\\pĲ', 'SA', 10, 1, 'SAU', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('esZܔj\0', 'SN', 10, 1, 'SEN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('nson<b', 'RS', 10, 1, 'SRB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5,6}', 1, '[[regtime_]]', NULL, 1, 0),
('ys˷.Q%', 'SC', 10, 1, 'SYC', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ςp]_%', 'SL', 10, 1, 'SLE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ϋr	$bD$', 'SG', 10, 1, 'SGP', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('ϔqŒlc', 'SX', 10, 1, 'SXM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ϝsBhb\nx', 'SB', 10, 1, 'SLB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('ϦqiQ)', 'SO', 10, 1, 'SOM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[A-Z]{2} ?\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('ϯq', 'ZA', 10, 1, 'ZAF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('ϸsknkE', 'GS', 10, 1, 'SGS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[Ss][Ii][Qq]{2}\\s{0,1}[1][Zz]{2}', 1, '[[regtime_]]', NULL, 1, 0),
('s3C5', 'KR', 10, 1, 'KOR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}(?:\\d{2}|-\\d{3})', 1, '[[regtime_]]', NULL, 1, 0),
('sŐ', 'SS', 10, 1, 'SSD', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('pO~', 'LK', 10, 1, 'LKA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('qwCY', 'SD', 10, 1, 'SDN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('pe5ig-', 'SR', 10, 1, 'SUR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('pi<', 'SJ', 10, 1, 'SJM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('pwџ''', 'SZ', 10, 1, 'SWZ', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '[HLMS]\\d{3}', 1, '[[regtime_]]', NULL, 1, 0),
('\rri3c', 'SY', 10, 1, 'SYR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('p/)5C'',]P', 'TW', 10, 1, 'TWN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{3}(?:\\d{2})?', 1, '[[regtime_]]', NULL, 1, 0),
('sz#ֲzF', 'TJ', 10, 1, 'TJK', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('(pC''', 'TZ', 10, 1, 'TZA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4,5}', 1, '[[regtime_]]', NULL, 1, 0),
('1r䈡$@nG', 'TH', 10, 1, 'THA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('=ph%Qw', 'TL', 10, 1, 'TLS', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('FqxX ׂE', 'TG', 10, 1, 'TGO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Opl8A', 'TK', 10, 1, 'TKL', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('XrÛ>S!', 'TO', 10, 1, 'TON', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('aq噃ak2D', 'TT', 10, 1, 'TTO', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('kq', 'TN', 10, 1, 'TUN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('tp&հGK)', 'TM', 10, 1, 'TKM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('}q&cI݂', 'TC', 10, 1, 'TCA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, 'TKCA 1ZZ', 1, '[[regtime_]]', NULL, 1, 0),
('Іpa]#HU', 'TV', 10, 1, 'TUV', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Џp[<', 'UG', 10, 1, 'UGA', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('Йr;Z,./', 'UA', 10, 1, 'UKR', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('Фpgg8Nq', 'UY', 10, 1, 'URY', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('ЭqL#@', 'UZ', 10, 1, 'UZB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('жp=', 'VU', 10, 1, 'VUT', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('пr~{V	]Gc_', 'VE', 10, 1, 'VEN', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{4}', 1, '[[regtime_]]', NULL, 1, 0),
('s2pkgk4', 'VN', 10, 1, 'VNM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{6}', 1, '[[regtime_]]', NULL, 1, 0),
('s*l~', 'WF', 10, 1, 'WLF', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '986\\d{2}', 1, '[[regtime_]]', NULL, 1, 0),
('r⻞H(', 'EH', 10, 1, 'ESH', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('r;o\0\r', 'YE', 10, 1, 'YEM', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0),
('sc\rG*', 'ZM', 10, 1, 'ZMB', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, '\\d{5}', 1, '[[regtime_]]', NULL, 1, 0),
('q\nm', 'ZW', 10, 1, 'ZWE', 0, 0, 0, NULL, 0, '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', '{"amount": 0, "enabled": 0, "currencyId": "b7d2554b0ce847cd82f3ac9bd1c0dfca"}', NULL, 0, 0, NULL, 1, '[[regtime_]]', NULL, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `country_state`
--

CREATE TABLE `country_state` (
  `id` binary(16) NOT NULL,
  `country_id` binary(16) NOT NULL,
  `short_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` int NOT NULL DEFAULT '1',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.country_state.country_id` (`country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `country_state`
--

INSERT INTO `country_state` VALUES
('kpcmx', 'js', 'DE-BW', 1, 1, '[[regtime_]]', NULL),
('kq$asU', 'js', 'DE-BY', 1, 1, '[[regtime_]]', NULL),
('k$qR', 'js', 'DE-BE', 1, 1, '[[regtime_]]', NULL),
('k.qj`', 'js', 'DE-BB', 1, 1, '[[regtime_]]', NULL),
('k8q^Iݓ[w', 'js', 'DE-HB', 1, 1, '[[regtime_]]', NULL),
('kArB/', 'js', 'DE-HH', 1, 1, '[[regtime_]]', NULL),
('kJs	d2', 'js', 'DE-HE', 1, 1, '[[regtime_]]', NULL),
('kSq4 ', 'js', 'DE-NI', 1, 1, '[[regtime_]]', NULL),
('kdpd', 'js', 'DE-MV', 1, 1, '[[regtime_]]', NULL),
('k|qՄOD#', 'js', 'DE-NW', 1, 1, '[[regtime_]]', NULL),
('kqM4-', 'js', 'DE-RP', 1, 1, '[[regtime_]]', NULL),
('ksP^A"B', 'js', 'DE-SL', 1, 1, '[[regtime_]]', NULL),
('ksWrq', 'js', 'DE-SN', 1, 1, '[[regtime_]]', NULL),
('kqdU"', 'js', 'DE-ST', 1, 1, '[[regtime_]]', NULL),
('kre!', 'js', 'DE-SH', 1, 1, '[[regtime_]]', NULL),
('kpNN\\', 'js', 'DE-TH', 1, 1, '[[regtime_]]', NULL),
('ksҟE`', 'ks>8W', 'GB-ENG', 1, 1, '[[regtime_]]', NULL),
('kq\Z\0', 'ks>8W', 'GB-NIR', 1, 1, '[[regtime_]]', NULL),
('krY~l', 'ks>8W', 'GB-SCT', 1, 1, '[[regtime_]]', NULL),
('krr|}', 'ks>8W', 'GB-WLS', 1, 1, '[[regtime_]]', NULL),
('lp\rLf', 'ks>8W', 'GB-EAW', 1, 1, '[[regtime_]]', NULL),
('ls~؁/B\\', 'ks>8W', 'GB-GBN', 1, 1, '[[regtime_]]', NULL),
('lqUӹ', 'ks>8W', 'GB-UKM', 1, 1, '[[regtime_]]', NULL),
('lrŉlHj', 'ks>8W', 'GB-BKM', 1, 1, '[[regtime_]]', NULL),
('l\Zs`o', 'ks>8W', 'GB-CAM', 1, 1, '[[regtime_]]', NULL),
('l sU', 'ks>8W', 'GB-CMA', 1, 1, '[[regtime_]]', NULL),
('l(p%', 'ks>8W', 'GB-DBY', 1, 1, '[[regtime_]]', NULL),
('l.s@', 'ks>8W', 'GB-DEV', 1, 1, '[[regtime_]]', NULL),
('l4sɠ`\Z\Z0', 'ks>8W', 'GB-DOR', 1, 1, '[[regtime_]]', NULL),
('l:q૧HSU', 'ks>8W', 'GB-ESX', 1, 1, '[[regtime_]]', NULL),
('lAr"Y\\`', 'ks>8W', 'GB-ESS', 1, 1, '[[regtime_]]', NULL),
('lFq6D', 'ks>8W', 'GB-GLS', 1, 1, '[[regtime_]]', NULL),
('lOpP\\\r', 'ks>8W', 'GB-HAM', 1, 1, '[[regtime_]]', NULL),
('lVq݌/P!O', 'ks>8W', 'GB-HRT', 1, 1, '[[regtime_]]', NULL),
('l\\pưX\r', 'ks>8W', 'GB-KEN', 1, 1, '[[regtime_]]', NULL),
('lbqQ!', 'ks>8W', 'GB-LAN', 1, 1, '[[regtime_]]', NULL),
('lhrҴf?C5', 'ks>8W', 'GB-LEC', 1, 1, '[[regtime_]]', NULL),
('lns;fFU\nb!', 'ks>8W', 'GB-LIN', 1, 1, '[[regtime_]]', NULL),
('ltrm,z', 'ks>8W', 'GB-NFK', 1, 1, '[[regtime_]]', NULL),
('lzq!&H', 'ks>8W', 'GB-NYK', 1, 1, '[[regtime_]]', NULL),
('lp^#lC', 'ks>8W', 'GB-NTH', 1, 1, '[[regtime_]]', NULL),
('lqɆ', 'ks>8W', 'GB-NTT', 1, 1, '[[regtime_]]', NULL),
('lsDe\rUN', 'ks>8W', 'GB-OXF', 1, 1, '[[regtime_]]', NULL),
('lq7M(', 'ks>8W', 'GB-SOM', 1, 1, '[[regtime_]]', NULL),
('lr(Hh1_Ԏ', 'ks>8W', 'GB-STS', 1, 1, '[[regtime_]]', NULL),
('lsC4', 'ks>8W', 'GB-SFK', 1, 1, '[[regtime_]]', NULL),
('lpUtfI', 'ks>8W', 'GB-SRY', 1, 1, '[[regtime_]]', NULL),
('lsڝs\Z}', 'ks>8W', 'GB-WAR', 1, 1, '[[regtime_]]', NULL),
('ls /#D', 'ks>8W', 'GB-WSX', 1, 1, '[[regtime_]]', NULL),
('lr䢸5', 'ks>8W', 'GB-WOR', 1, 1, '[[regtime_]]', NULL),
('lqp', 'ks>8W', 'GB-LND', 1, 1, '[[regtime_]]', NULL),
('lp<:', 'ks>8W', 'GB-BDG', 1, 1, '[[regtime_]]', NULL),
('lqpI>>', 'ks>8W', 'GB-BNE', 1, 1, '[[regtime_]]', NULL),
('lqպ_;z)', 'ks>8W', 'GB-BEX', 1, 1, '[[regtime_]]', NULL),
('lsĽEE', 'ks>8W', 'GB-BEN', 1, 1, '[[regtime_]]', NULL),
('ls@ig', 'ks>8W', 'GB-BRY', 1, 1, '[[regtime_]]', NULL),
('lqԸ}D0ϕ', 'ks>8W', 'GB-CMD', 1, 1, '[[regtime_]]', NULL),
('lrʿf', 'ks>8W', 'GB-CRY', 1, 1, '[[regtime_]]', NULL),
('lrPZa', 'ks>8W', 'GB-EAL', 1, 1, '[[regtime_]]', NULL),
('lrU=;\Z|', 'ks>8W', 'GB-ENF', 1, 1, '[[regtime_]]', NULL),
('lpw', 'ks>8W', 'GB-GRE', 1, 1, '[[regtime_]]', NULL),
('mscs', 'ks>8W', 'GB-HCK', 1, 1, '[[regtime_]]', NULL),
('mrƑߚ', 'ks>8W', 'GB-HMF', 1, 1, '[[regtime_]]', NULL),
('mqD@=we', 'ks>8W', 'GB-HRY', 1, 1, '[[regtime_]]', NULL),
('mr^&', 'ks>8W', 'GB-HRW', 1, 1, '[[regtime_]]', NULL),
('mrÚ,XO', 'ks>8W', 'GB-HAV', 1, 1, '[[regtime_]]', NULL),
('m"rLQ&', 'ks>8W', 'GB-HIL', 1, 1, '[[regtime_]]', NULL),
('m(q7hEqX', 'ks>8W', 'GB-HNS', 1, 1, '[[regtime_]]', NULL),
('m.sؘ', 'ks>8W', 'GB-ISL', 1, 1, '[[regtime_]]', NULL),
('m4pYv', 'ks>8W', 'GB-KEC', 1, 1, '[[regtime_]]', NULL),
('m:r0Qs.T', 'ks>8W', 'GB-KTT', 1, 1, '[[regtime_]]', NULL),
('m@sIYJ', 'ks>8W', 'GB-LBH', 1, 1, '[[regtime_]]', NULL),
('mFr&lgwVؓ', 'ks>8W', 'GB-LEW', 1, 1, '[[regtime_]]', NULL),
('mLpnfĲK', 'ks>8W', 'GB-MRT', 1, 1, '[[regtime_]]', NULL),
('mRpqT', 'ks>8W', 'GB-NWM', 1, 1, '[[regtime_]]', NULL),
('mXr歌Z', 'ks>8W', 'GB-RDB', 1, 1, '[[regtime_]]', NULL),
('m^sI`uq2O', 'ks>8W', 'GB-RIC', 1, 1, '[[regtime_]]', NULL),
('mdr`u`', 'ks>8W', 'GB-SWK', 1, 1, '[[regtime_]]', NULL),
('mjp63y', 'ks>8W', 'GB-STN', 1, 1, '[[regtime_]]', NULL),
('mpsC\n', 'ks>8W', 'GB-TWH', 1, 1, '[[regtime_]]', NULL),
('mxqs[fF', 'ks>8W', 'GB-WFT', 1, 1, '[[regtime_]]', NULL),
('mpͽ?\ZL', 'ks>8W', 'GB-WND', 1, 1, '[[regtime_]]', NULL),
('mqA_', 'ks>8W', 'GB-WSM', 1, 1, '[[regtime_]]', NULL),
('mr;(^$', 'ks>8W', 'GB-BNS', 1, 1, '[[regtime_]]', NULL),
('msŞ܇>', 'ks>8W', 'GB-BIR', 1, 1, '[[regtime_]]', NULL),
('mrH?uS㚩', 'ks>8W', 'GB-BOL', 1, 1, '[[regtime_]]', NULL),
('ms"O:', 'ks>8W', 'GB-BRD', 1, 1, '[[regtime_]]', NULL),
('mrMy4(xq', 'ks>8W', 'GB-BUR', 1, 1, '[[regtime_]]', NULL),
('mrXW/.t,', 'ks>8W', 'GB-CLD', 1, 1, '[[regtime_]]', NULL),
('mr7', 'ks>8W', 'GB-COV', 1, 1, '[[regtime_]]', NULL),
('mp׏*G', 'ks>8W', 'GB-DNC', 1, 1, '[[regtime_]]', NULL),
('mr?N4k', 'ks>8W', 'GB-DUD', 1, 1, '[[regtime_]]', NULL),
('ms\Z/', 'ks>8W', 'GB-GAT', 1, 1, '[[regtime_]]', NULL),
('mp2', 'ks>8W', 'GB-KIR', 1, 1, '[[regtime_]]', NULL),
('mrɳo+1', 'ks>8W', 'GB-KWL', 1, 1, '[[regtime_]]', NULL),
('mqW', 'ks>8W', 'GB-LDS', 1, 1, '[[regtime_]]', NULL),
('mq,31u\ZA', 'ks>8W', 'GB-LIV', 1, 1, '[[regtime_]]', NULL),
('mr	f0,', 'ks>8W', 'GB-MAN', 1, 1, '[[regtime_]]', NULL),
('mrηNIG5', 'ks>8W', 'GB-NET', 1, 1, '[[regtime_]]', NULL),
('mqtv.3', 'ks>8W', 'GB-NTY', 1, 1, '[[regtime_]]', NULL),
('ms0ݒUɥ', 'ks>8W', 'GB-OLD', 1, 1, '[[regtime_]]', NULL),
('mq<Tv', 'ks>8W', 'GB-RCH', 1, 1, '[[regtime_]]', NULL),
('n\0rͺi2', 'ks>8W', 'GB-ROT', 1, 1, '[[regtime_]]', NULL),
('nrsgkW', 'ks>8W', 'GB-SHN', 1, 1, '[[regtime_]]', NULL),
('npҒ@T[', 'ks>8W', 'GB-SLF', 1, 1, '[[regtime_]]', NULL),
('np\nt xR', 'ks>8W', 'GB-SAW', 1, 1, '[[regtime_]]', NULL),
('nqW<', 'ks>8W', 'GB-SFT', 1, 1, '[[regtime_]]', NULL),
('np$	', 'ks>8W', 'GB-SHF', 1, 1, '[[regtime_]]', NULL),
('n!r8MbD', 'ks>8W', 'GB-SOL', 1, 1, '[[regtime_]]', NULL),
('n''pɲ/}2v', 'ks>8W', 'GB-STY', 1, 1, '[[regtime_]]', NULL),
('n-pX/7', 'ks>8W', 'GB-SKP', 1, 1, '[[regtime_]]', NULL),
('n5p:.-}|', 'ks>8W', 'GB-SND', 1, 1, '[[regtime_]]', NULL),
('n;r(l1', 'ks>8W', 'GB-TAM', 1, 1, '[[regtime_]]', NULL),
('nBp3-', 'ks>8W', 'GB-TRF', 1, 1, '[[regtime_]]', NULL),
('nJpبS', 'ks>8W', 'GB-WKF', 1, 1, '[[regtime_]]', NULL),
('nOqh<7&4', 'ks>8W', 'GB-WLL', 1, 1, '[[regtime_]]', NULL),
('nUsXG', 'ks>8W', 'GB-WGN', 1, 1, '[[regtime_]]', NULL),
('n[p[r,8I', 'ks>8W', 'GB-WRL', 1, 1, '[[regtime_]]', NULL),
('n`sٓ!.m@', 'ks>8W', 'GB-WLV', 1, 1, '[[regtime_]]', NULL),
('nfqfe', 'ks>8W', 'GB-BAS', 1, 1, '[[regtime_]]', NULL),
('nlp[D?nI', 'ks>8W', 'GB-BDF', 1, 1, '[[regtime_]]', NULL),
('nrrNXD	\0"', 'ks>8W', 'GB-BBD', 1, 1, '[[regtime_]]', NULL),
('nwrVMIR', 'ks>8W', 'GB-BPL', 1, 1, '[[regtime_]]', NULL),
('n}qO<', 'ks>8W', 'GB-BMH', 1, 1, '[[regtime_]]', NULL),
('nqV\Z[B', 'ks>8W', 'GB-BRC', 1, 1, '[[regtime_]]', NULL),
('np {Z', 'ks>8W', 'GB-BNH', 1, 1, '[[regtime_]]', NULL),
('npĶV}&/u', 'ks>8W', 'GB-BST', 1, 1, '[[regtime_]]', NULL),
('nr''9 ', 'ks>8W', 'GB-CBF', 1, 1, '[[regtime_]]', NULL),
('nrv%t', 'ks>8W', 'GB-CHE', 1, 1, '[[regtime_]]', NULL),
('nrclv@', 'ks>8W', 'GB-CHW', 1, 1, '[[regtime_]]', NULL),
('nr):NJo;K', 'ks>8W', 'GB-CON', 1, 1, '[[regtime_]]', NULL),
('nq^jRR6', 'ks>8W', 'GB-DAL', 1, 1, '[[regtime_]]', NULL),
('nrߪÜX,~', 'ks>8W', 'GB-DER', 1, 1, '[[regtime_]]', NULL),
('np7e!z', 'ks>8W', 'GB-DUR', 1, 1, '[[regtime_]]', NULL),
('nrD>"', 'ks>8W', 'GB-ERY', 1, 1, '[[regtime_]]', NULL),
('nr5솹', 'ks>8W', 'GB-HAL', 1, 1, '[[regtime_]]', NULL),
('np{̧', 'ks>8W', 'GB-HPL', 1, 1, '[[regtime_]]', NULL),
('npL/''<H', 'ks>8W', 'GB-HEF', 1, 1, '[[regtime_]]', NULL),
('nqʀD4', 'ks>8W', 'GB-IOW', 1, 1, '[[regtime_]]', NULL),
('nqQF', 'ks>8W', 'GB-IOS', 1, 1, '[[regtime_]]', NULL),
('nqheW', 'ks>8W', 'GB-KHL', 1, 1, '[[regtime_]]', NULL),
('nqA', 'ks>8W', 'GB-LCE', 1, 1, '[[regtime_]]', NULL),
('nple', 'ks>8W', 'GB-LUT', 1, 1, '[[regtime_]]', NULL),
('nqL*ڇȤ', 'ks>8W', 'GB-MDW', 1, 1, '[[regtime_]]', NULL),
('ns[#? v', 'ks>8W', 'GB-MDB', 1, 1, '[[regtime_]]', NULL),
('osRI%Æ', 'ks>8W', 'GB-MIK', 1, 1, '[[regtime_]]', NULL),
('orOG)', 'ks>8W', 'GB-NEL', 1, 1, '[[regtime_]]', NULL),
('oq+9', 'ks>8W', 'GB-NLN', 1, 1, '[[regtime_]]', NULL),
('oqxXi', 'ks>8W', 'GB-NSM', 1, 1, '[[regtime_]]', NULL),
('oq7/	', 'ks>8W', 'GB-NBL', 1, 1, '[[regtime_]]', NULL),
('o%q]MHg6', 'ks>8W', 'GB-NGM', 1, 1, '[[regtime_]]', NULL),
('o+pdἩw', 'ks>8W', 'GB-PTE', 1, 1, '[[regtime_]]', NULL),
('o1pq%K', 'ks>8W', 'GB-PLY', 1, 1, '[[regtime_]]', NULL),
('o7pj,t', 'ks>8W', 'GB-POL', 1, 1, '[[regtime_]]', NULL),
('o=r*9R0', 'ks>8W', 'GB-POR', 1, 1, '[[regtime_]]', NULL),
('oGqKӞz', 'ks>8W', 'GB-RDG', 1, 1, '[[regtime_]]', NULL),
('oTpt=Ef)', 'ks>8W', 'GB-RCC', 1, 1, '[[regtime_]]', NULL),
('odps9Q', 'ks>8W', 'GB-RUT', 1, 1, '[[regtime_]]', NULL),
('osrHi'';T', 'ks>8W', 'GB-SHR', 1, 1, '[[regtime_]]', NULL),
('os;k&I', 'ks>8W', 'GB-SLG', 1, 1, '[[regtime_]]', NULL),
('or\Z', 'ks>8W', 'GB-SGC', 1, 1, '[[regtime_]]', NULL),
('oq<A(S\0', 'ks>8W', 'GB-STH', 1, 1, '[[regtime_]]', NULL),
('optGY;', 'ks>8W', 'GB-SOS', 1, 1, '[[regtime_]]', NULL),
('osȤҺ&', 'ks>8W', 'GB-STT', 1, 1, '[[regtime_]]', NULL),
('opgn', 'ks>8W', 'GB-STE', 1, 1, '[[regtime_]]', NULL),
('oqS\nTm҂', 'ks>8W', 'GB-SWD', 1, 1, '[[regtime_]]', NULL),
('opS9q', 'ks>8W', 'GB-TFW', 1, 1, '[[regtime_]]', NULL),
('os}&ms', 'ks>8W', 'GB-THR', 1, 1, '[[regtime_]]', NULL),
('or', 'ks>8W', 'GB-TOB', 1, 1, '[[regtime_]]', NULL),
('oqل@^lQT', 'ks>8W', 'GB-WRT', 1, 1, '[[regtime_]]', NULL),
('opD.=', 'ks>8W', 'GB-WBK', 1, 1, '[[regtime_]]', NULL),
('oro', 'ks>8W', 'GB-WIL', 1, 1, '[[regtime_]]', NULL),
('or^|@)ڂ', 'ks>8W', 'GB-WNM', 1, 1, '[[regtime_]]', NULL),
('op+;q', 'ks>8W', 'GB-WOK', 1, 1, '[[regtime_]]', NULL),
('opvN½E', 'ks>8W', 'GB-YOR', 1, 1, '[[regtime_]]', NULL),
('opJ\r͕', 'ks>8W', 'GB-ANN', 1, 1, '[[regtime_]]', NULL),
('oqJ9F+', 'ks>8W', 'GB-AND', 1, 1, '[[regtime_]]', NULL),
('oqZ*', 'ks>8W', 'GB-ABC', 1, 1, '[[regtime_]]', NULL),
('os]~P`I', 'ks>8W', 'GB-BFS', 1, 1, '[[regtime_]]', NULL),
('oq(Yez-', 'ks>8W', 'GB-CCG', 1, 1, '[[regtime_]]', NULL),
('pqԖ5̠', 'ks>8W', 'GB-DRS', 1, 1, '[[regtime_]]', NULL),
('ppbg', 'ks>8W', 'GB-FMO', 1, 1, '[[regtime_]]', NULL),
('prU/', 'ks>8W', 'GB-LBC', 1, 1, '[[regtime_]]', NULL),
('pr,', 'ks>8W', 'GB-MEA', 1, 1, '[[regtime_]]', NULL),
('pqnu', 'ks>8W', 'GB-MUL', 1, 1, '[[regtime_]]', NULL),
('p#pGT', 'ks>8W', 'GB-NMD', 1, 1, '[[regtime_]]', NULL),
('p*r	Tm\0', 'ks>8W', 'GB-ABE', 1, 1, '[[regtime_]]', NULL),
('p1r\\򸭡D', 'ks>8W', 'GB-ABD', 1, 1, '[[regtime_]]', NULL),
('p8rnn.m', 'ks>8W', 'GB-ANS', 1, 1, '[[regtime_]]', NULL),
('p@q藋t', 'ks>8W', 'GB-AGB', 1, 1, '[[regtime_]]', NULL),
('pFsՊNZ#J', 'ks>8W', 'GB-CLK', 1, 1, '[[regtime_]]', NULL),
('pLr	\Z2P', 'ks>8W', 'GB-DGY', 1, 1, '[[regtime_]]', NULL),
('pRpy(', 'ks>8W', 'GB-DND', 1, 1, '[[regtime_]]', NULL),
('pYrǒf\n', 'ks>8W', 'GB-EAY', 1, 1, '[[regtime_]]', NULL),
('p_pP$uB', 'ks>8W', 'GB-EDU', 1, 1, '[[regtime_]]', NULL),
('pesI\0JW', 'ks>8W', 'GB-ELN', 1, 1, '[[regtime_]]', NULL),
('pkq仠HE', 'ks>8W', 'GB-ERW', 1, 1, '[[regtime_]]', NULL),
('prr!FO9', 'ks>8W', 'GB-EDH', 1, 1, '[[regtime_]]', NULL),
('p~pqyg#:', 'ks>8W', 'GB-ELS', 1, 1, '[[regtime_]]', NULL),
('prDQ ', 'ks>8W', 'GB-FAL', 1, 1, '[[regtime_]]', NULL),
('prir', 'ks>8W', 'GB-FIF', 1, 1, '[[regtime_]]', NULL),
('pr34Rw;', 'ks>8W', 'GB-GLG', 1, 1, '[[regtime_]]', NULL),
('pqX@_O', 'ks>8W', 'GB-HLD', 1, 1, '[[regtime_]]', NULL),
('prz\0B', 'ks>8W', 'GB-IVC', 1, 1, '[[regtime_]]', NULL),
('pr[-Uj', 'ks>8W', 'GB-MLN', 1, 1, '[[regtime_]]', NULL),
('ps\0jE}jx', 'ks>8W', 'GB-MRY', 1, 1, '[[regtime_]]', NULL),
('pr"', 'ks>8W', 'GB-NAY', 1, 1, '[[regtime_]]', NULL),
('psҖ*%I', 'ks>8W', 'GB-NLK', 1, 1, '[[regtime_]]', NULL),
('pra#]~', 'ks>8W', 'GB-ORK', 1, 1, '[[regtime_]]', NULL),
('pqJ9>', 'ks>8W', 'GB-PKN', 1, 1, '[[regtime_]]', NULL),
('prBLR%', 'ks>8W', 'GB-RFW', 1, 1, '[[regtime_]]', NULL),
('pqȩ"D', 'ks>8W', 'GB-SCB', 1, 1, '[[regtime_]]', NULL),
('psep(p', 'ks>8W', 'GB-ZET', 1, 1, '[[regtime_]]', NULL),
('pp6S', 'ks>8W', 'GB-SAY', 1, 1, '[[regtime_]]', NULL),
('ppD*$/', 'ks>8W', 'GB-SLK', 1, 1, '[[regtime_]]', NULL),
('pr(<@', 'ks>8W', 'GB-STG', 1, 1, '[[regtime_]]', NULL),
('pq2V.', 'ks>8W', 'GB-WDU', 1, 1, '[[regtime_]]', NULL),
('pr& v-', 'ks>8W', 'GB-WLN', 1, 1, '[[regtime_]]', NULL),
('qsbs', 'ks>8W', 'GB-BGW', 1, 1, '[[regtime_]]', NULL),
('qsͮ54:=', 'ks>8W', 'GB-BGE', 1, 1, '[[regtime_]]', NULL),
('qp3F"|', 'ks>8W', 'GB-CAY', 1, 1, '[[regtime_]]', NULL),
('qq>dy', 'ks>8W', 'GB-CRF', 1, 1, '[[regtime_]]', NULL),
('qp\rŲq', 'ks>8W', 'GB-CMN', 1, 1, '[[regtime_]]', NULL),
('q$r1ت;', 'ks>8W', 'GB-CGN', 1, 1, '[[regtime_]]', NULL),
('q)sѲ^Mn', 'ks>8W', 'GB-CWY', 1, 1, '[[regtime_]]', NULL),
('q/qӷva.՗', 'ks>8W', 'GB-DEN', 1, 1, '[[regtime_]]', NULL),
('q6rj	ǜ', 'ks>8W', 'GB-FLN', 1, 1, '[[regtime_]]', NULL),
('q<r^3Td', 'ks>8W', 'GB-GWN', 1, 1, '[[regtime_]]', NULL),
('qBr"S', 'ks>8W', 'GB-AGY', 1, 1, '[[regtime_]]', NULL),
('qHpsoơȝW', 'ks>8W', 'GB-MTY', 1, 1, '[[regtime_]]', NULL),
('qNqz^b', 'ks>8W', 'GB-MON', 1, 1, '[[regtime_]]', NULL),
('qTrC/[', 'ks>8W', 'GB-NTL', 1, 1, '[[regtime_]]', NULL),
('qZp*g', 'ks>8W', 'GB-NWP', 1, 1, '[[regtime_]]', NULL),
('qas0\Z5Mq', 'ks>8W', 'GB-PEM', 1, 1, '[[regtime_]]', NULL),
('qlp!X:', 'ks>8W', 'GB-POW', 1, 1, '[[regtime_]]', NULL),
('qrppp\n', 'ks>8W', 'GB-RCT', 1, 1, '[[regtime_]]', NULL),
('qxqm', 'ks>8W', 'GB-SWA', 1, 1, '[[regtime_]]', NULL),
('q~s4A5', 'ks>8W', 'GB-TOF', 1, 1, '[[regtime_]]', NULL),
('qrY$', 'ks>8W', 'GB-VGL', 1, 1, '[[regtime_]]', NULL),
('qr=M', 'ks>8W', 'GB-WRX', 1, 1, '[[regtime_]]', NULL),
('rr+Im', 'rq̆\rnq', 'US-AL', 1, 1, '[[regtime_]]', NULL),
('rr@_7S<', 'rq̆\rnq', 'US-AK', 1, 1, '[[regtime_]]', NULL),
('rq-W', 'rq̆\rnq', 'US-AZ', 1, 1, '[[regtime_]]', NULL),
('rpn''j>zMO', 'rq̆\rnq', 'US-AR', 1, 1, '[[regtime_]]', NULL),
('rrVɲ2xDM', 'rq̆\rnq', 'US-CA', 1, 1, '[[regtime_]]', NULL),
('rqy', 'rq̆\rnq', 'US-CO', 1, 1, '[[regtime_]]', NULL),
('rqȲn~9', 'rq̆\rnq', 'US-CT', 1, 1, '[[regtime_]]', NULL),
('sp-L2', 'rq̆\rnq', 'US-DE', 1, 1, '[[regtime_]]', NULL),
('sr2e*Ϊ', 'rq̆\rnq', 'US-FL', 1, 1, '[[regtime_]]', NULL),
('s\rp(C=', 'rq̆\rnq', 'US-GA', 1, 1, '[[regtime_]]', NULL),
('srl $Dl', 'rq̆\rnq', 'US-HI', 1, 1, '[[regtime_]]', NULL),
('ssJh=Q', 'rq̆\rnq', 'US-ID', 1, 1, '[[regtime_]]', NULL),
('sqLɪv', 'rq̆\rnq', 'US-IL', 1, 1, '[[regtime_]]', NULL),
('s%s{dh+z', 'rq̆\rnq', 'US-IN', 1, 1, '[[regtime_]]', NULL),
('s.q4:k', 'rq̆\rnq', 'US-IA', 1, 1, '[[regtime_]]', NULL),
('s<qfxÿFc', 'rq̆\rnq', 'US-KS', 1, 1, '[[regtime_]]', NULL),
('sNq<TM', 'rq̆\rnq', 'US-KY', 1, 1, '[[regtime_]]', NULL),
('sYqߖj', 'rq̆\rnq', 'US-LA', 1, 1, '[[regtime_]]', NULL),
('siq\\a%', 'rq̆\rnq', 'US-ME', 1, 1, '[[regtime_]]', NULL),
('sorYp\rf>', 'rq̆\rnq', 'US-MD', 1, 1, '[[regtime_]]', NULL),
('surf"', 'rq̆\rnq', 'US-MA', 1, 1, '[[regtime_]]', NULL),
('s{qی\Z`', 'rq̆\rnq', 'US-MI', 1, 1, '[[regtime_]]', NULL),
('ssd', 'rq̆\rnq', 'US-MN', 1, 1, '[[regtime_]]', NULL),
('sqŘ\\%m̻:', 'rq̆\rnq', 'US-MS', 1, 1, '[[regtime_]]', NULL),
('sr\0', 'rq̆\rnq', 'US-MO', 1, 1, '[[regtime_]]', NULL),
('srSfa<J', 'rq̆\rnq', 'US-MT', 1, 1, '[[regtime_]]', NULL),
('sqBw', 'rq̆\rnq', 'US-NE', 1, 1, '[[regtime_]]', NULL),
('spRD', 'rq̆\rnq', 'US-NV', 1, 1, '[[regtime_]]', NULL),
('sq[bʺ', 'rq̆\rnq', 'US-NH', 1, 1, '[[regtime_]]', NULL),
('sr٥(', 'rq̆\rnq', 'US-NJ', 1, 1, '[[regtime_]]', NULL),
('sqz$^O', 'rq̆\rnq', 'US-NM', 1, 1, '[[regtime_]]', NULL),
('sqݿX:rA', 'rq̆\rnq', 'US-NY', 1, 1, '[[regtime_]]', NULL),
('sr̺%BSW', 'rq̆\rnq', 'US-NC', 1, 1, '[[regtime_]]', NULL),
('spzqJd', 'rq̆\rnq', 'US-ND', 1, 1, '[[regtime_]]', NULL),
('sp$}-', 'rq̆\rnq', 'US-OH', 1, 1, '[[regtime_]]', NULL),
('spF6X(', 'rq̆\rnq', 'US-OK', 1, 1, '[[regtime_]]', NULL),
('ss(', 'rq̆\rnq', 'US-OR', 1, 1, '[[regtime_]]', NULL),
('sqp&~\Z', 'rq̆\rnq', 'US-PA', 1, 1, '[[regtime_]]', NULL),
('sqhp>', 'rq̆\rnq', 'US-RI', 1, 1, '[[regtime_]]', NULL),
('spz-ν', 'rq̆\rnq', 'US-SC', 1, 1, '[[regtime_]]', NULL),
('spޏ-', 'rq̆\rnq', 'US-SD', 1, 1, '[[regtime_]]', NULL),
('sp)0', 'rq̆\rnq', 'US-TN', 1, 1, '[[regtime_]]', NULL),
('sqwY5\r&2', 'rq̆\rnq', 'US-TX', 1, 1, '[[regtime_]]', NULL),
('tpO3', 'rq̆\rnq', 'US-UT', 1, 1, '[[regtime_]]', NULL),
('tp1ѻo', 'rq̆\rnq', 'US-VT', 1, 1, '[[regtime_]]', NULL),
('tpۮB;n', 'rq̆\rnq', 'US-VA', 1, 1, '[[regtime_]]', NULL),
('tpi݊;', 'rq̆\rnq', 'US-WA', 1, 1, '[[regtime_]]', NULL),
('t\Zq}om', 'rq̆\rnq', 'US-WV', 1, 1, '[[regtime_]]', NULL),
('t q_', 'rq̆\rnq', 'US-WI', 1, 1, '[[regtime_]]', NULL),
('t,s>1l\r', 'rq̆\rnq', 'US-WY', 1, 1, '[[regtime_]]', NULL),
('t2qLy@', 'rq̆\rnq', 'US-DC', 1, 1, '[[regtime_]]', NULL),
('\rrO	', 'qpX粣}xI', 'CA-ON', 1, 1, '[[regtime_]]', NULL),
('\rrO؊', 'qpX粣}xI', 'CA-QC', 1, 1, '[[regtime_]]', NULL),
('\rrOvU', 'qpX粣}xI', 'CA-NS', 1, 1, '[[regtime_]]', NULL),
('\rrO;', 'qpX粣}xI', 'CA-NB', 1, 1, '[[regtime_]]', NULL),
('\rrOv', 'qpX粣}xI', 'CA-MB', 1, 1, '[[regtime_]]', NULL),
('\rrO.', 'qpX粣}xI', 'CA-BC', 1, 1, '[[regtime_]]', NULL),
('\rrOi', 'qpX粣}xI', 'CA-PE', 1, 1, '[[regtime_]]', NULL),
('\rrO\n', 'qpX粣}xI', 'CA-SK', 1, 1, '[[regtime_]]', NULL),
('\rrOڇ', 'qpX粣}xI', 'CA-AB', 1, 1, '[[regtime_]]', NULL),
('\rrOV_', 'qpX粣}xI', 'CA-NL', 1, 1, '[[regtime_]]', NULL),
('\rrOWǤ', 'qpX粣}xI', 'CA-NT', 1, 1, '[[regtime_]]', NULL),
('\rrOX', 'qpX粣}xI', 'CA-YT', 1, 1, '[[regtime_]]', NULL),
('\rrOۻ', 'qpX粣}xI', 'CA-NU', 1, 1, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `country_state_translation`
--

CREATE TABLE `country_state_translation` (
  `country_state_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`country_state_id`,`language_id`),
  KEY `fk.country_state_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `country_state_translation`
--

INSERT INTO `country_state_translation` VALUES
('kpcmx', 'jlrm%LL7WJ', 'Baden-Württemberg', NULL, '[[regtime_]]', NULL),
('kpcmx', '/_MpXT|', 'Baden-Württemberg', NULL, '[[regtime_]]', NULL),
('kq$asU', 'jlrm%LL7WJ', 'Bayern', NULL, '[[regtime_]]', NULL),
('kq$asU', '/_MpXT|', 'Bavaria', NULL, '[[regtime_]]', NULL),
('k$qR', 'jlrm%LL7WJ', 'Berlin', NULL, '[[regtime_]]', NULL),
('k$qR', '/_MpXT|', 'Berlin', NULL, '[[regtime_]]', NULL),
('k.qj`', 'jlrm%LL7WJ', 'Brandenburg', NULL, '[[regtime_]]', NULL),
('k.qj`', '/_MpXT|', 'Brandenburg', NULL, '[[regtime_]]', NULL),
('k8q^Iݓ[w', 'jlrm%LL7WJ', 'Bremen', NULL, '[[regtime_]]', NULL),
('k8q^Iݓ[w', '/_MpXT|', 'Bremen', NULL, '[[regtime_]]', NULL),
('kArB/', 'jlrm%LL7WJ', 'Hamburg', NULL, '[[regtime_]]', NULL),
('kArB/', '/_MpXT|', 'Hamburg', NULL, '[[regtime_]]', NULL),
('kJs	d2', 'jlrm%LL7WJ', 'Hessen', NULL, '[[regtime_]]', NULL),
('kJs	d2', '/_MpXT|', 'Hesse', NULL, '[[regtime_]]', NULL),
('kSq4 ', 'jlrm%LL7WJ', 'Niedersachsen', NULL, '[[regtime_]]', NULL),
('kSq4 ', '/_MpXT|', 'Lower Saxony', NULL, '[[regtime_]]', NULL),
('kdpd', 'jlrm%LL7WJ', 'Mecklenburg-Vorpommern', NULL, '[[regtime_]]', NULL),
('kdpd', '/_MpXT|', 'Mecklenburg-Western Pomerania', NULL, '[[regtime_]]', NULL),
('k|qՄOD#', 'jlrm%LL7WJ', 'Nordrhein-Westfalen', NULL, '[[regtime_]]', NULL),
('k|qՄOD#', '/_MpXT|', 'North Rhine-Westphalia', NULL, '[[regtime_]]', NULL),
('kqM4-', 'jlrm%LL7WJ', 'Rheinland-Pfalz', NULL, '[[regtime_]]', NULL),
('kqM4-', '/_MpXT|', 'Rhineland-Palatinate', NULL, '[[regtime_]]', NULL),
('ksP^A"B', 'jlrm%LL7WJ', 'Saarland', NULL, '[[regtime_]]', NULL),
('ksP^A"B', '/_MpXT|', 'Saarland', NULL, '[[regtime_]]', NULL),
('ksWrq', 'jlrm%LL7WJ', 'Sachsen', NULL, '[[regtime_]]', NULL),
('ksWrq', '/_MpXT|', 'Saxony', NULL, '[[regtime_]]', NULL),
('kqdU"', 'jlrm%LL7WJ', 'Sachsen-Anhalt', NULL, '[[regtime_]]', NULL),
('kqdU"', '/_MpXT|', 'Saxony-Anhalt', NULL, '[[regtime_]]', NULL),
('kre!', 'jlrm%LL7WJ', 'Schleswig-Holstein', NULL, '[[regtime_]]', NULL),
('kre!', '/_MpXT|', 'Schleswig-Holstein', NULL, '[[regtime_]]', NULL),
('kpNN\\', 'jlrm%LL7WJ', 'Thüringen', NULL, '[[regtime_]]', NULL),
('kpNN\\', '/_MpXT|', 'Thuringia', NULL, '[[regtime_]]', NULL),
('ksҟE`', '/_MpXT|', 'England', NULL, '[[regtime_]]', NULL),
('kq\Z\0', '/_MpXT|', 'Northern Ireland', NULL, '[[regtime_]]', NULL),
('krY~l', '/_MpXT|', 'Scotland', NULL, '[[regtime_]]', NULL),
('krr|}', '/_MpXT|', 'Wales', NULL, '[[regtime_]]', NULL),
('lp\rLf', '/_MpXT|', 'England and Wales', NULL, '[[regtime_]]', NULL),
('ls~؁/B\\', '/_MpXT|', 'Great Britain', NULL, '[[regtime_]]', NULL),
('lqUӹ', '/_MpXT|', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('lrŉlHj', '/_MpXT|', 'Buckinghamshire', NULL, '[[regtime_]]', NULL),
('l\Zs`o', '/_MpXT|', 'Cambridgeshire', NULL, '[[regtime_]]', NULL),
('l sU', '/_MpXT|', 'Cumbria', NULL, '[[regtime_]]', NULL),
('l(p%', '/_MpXT|', 'Derbyshire', NULL, '[[regtime_]]', NULL),
('l.s@', '/_MpXT|', 'Devon', NULL, '[[regtime_]]', NULL),
('l4sɠ`\Z\Z0', '/_MpXT|', 'Dorset', NULL, '[[regtime_]]', NULL),
('l:q૧HSU', '/_MpXT|', 'East Sussex', NULL, '[[regtime_]]', NULL),
('lAr"Y\\`', '/_MpXT|', 'Essex', NULL, '[[regtime_]]', NULL),
('lFq6D', '/_MpXT|', 'Gloucestershire', NULL, '[[regtime_]]', NULL),
('lOpP\\\r', '/_MpXT|', 'Hampshire', NULL, '[[regtime_]]', NULL),
('lVq݌/P!O', '/_MpXT|', 'Hertfordshire', NULL, '[[regtime_]]', NULL),
('l\\pưX\r', '/_MpXT|', 'Kent', NULL, '[[regtime_]]', NULL),
('lbqQ!', '/_MpXT|', 'Lancashire', NULL, '[[regtime_]]', NULL),
('lhrҴf?C5', '/_MpXT|', 'Leicestershire', NULL, '[[regtime_]]', NULL),
('lns;fFU\nb!', '/_MpXT|', 'Lincolnshire', NULL, '[[regtime_]]', NULL),
('ltrm,z', '/_MpXT|', 'Norfolk', NULL, '[[regtime_]]', NULL),
('lzq!&H', '/_MpXT|', 'North Yorkshire', NULL, '[[regtime_]]', NULL),
('lp^#lC', '/_MpXT|', 'Northamptonshire', NULL, '[[regtime_]]', NULL),
('lqɆ', '/_MpXT|', 'Nottinghamshire', NULL, '[[regtime_]]', NULL),
('lsDe\rUN', '/_MpXT|', 'Oxfordshire', NULL, '[[regtime_]]', NULL),
('lq7M(', '/_MpXT|', 'Somerset', NULL, '[[regtime_]]', NULL),
('lr(Hh1_Ԏ', '/_MpXT|', 'Staffordshire', NULL, '[[regtime_]]', NULL),
('lsC4', '/_MpXT|', 'Suffolk', NULL, '[[regtime_]]', NULL),
('lpUtfI', '/_MpXT|', 'Surrey', NULL, '[[regtime_]]', NULL),
('lsڝs\Z}', '/_MpXT|', 'Warwickshire', NULL, '[[regtime_]]', NULL),
('ls /#D', '/_MpXT|', 'West Sussex', NULL, '[[regtime_]]', NULL),
('lr䢸5', '/_MpXT|', 'Worcestershire', NULL, '[[regtime_]]', NULL),
('lqp', '/_MpXT|', 'London, City of', NULL, '[[regtime_]]', NULL),
('lp<:', '/_MpXT|', 'Barking and Dagenham', NULL, '[[regtime_]]', NULL),
('lqpI>>', '/_MpXT|', 'Barnet', NULL, '[[regtime_]]', NULL),
('lqպ_;z)', '/_MpXT|', 'Bexley', NULL, '[[regtime_]]', NULL),
('lsĽEE', '/_MpXT|', 'Brent', NULL, '[[regtime_]]', NULL),
('ls@ig', '/_MpXT|', 'Bromley', NULL, '[[regtime_]]', NULL),
('lqԸ}D0ϕ', '/_MpXT|', 'Camden', NULL, '[[regtime_]]', NULL),
('lrʿf', '/_MpXT|', 'Croydon', NULL, '[[regtime_]]', NULL),
('lrPZa', '/_MpXT|', 'Ealing', NULL, '[[regtime_]]', NULL),
('lrU=;\Z|', '/_MpXT|', 'Enfield', NULL, '[[regtime_]]', NULL),
('lpw', '/_MpXT|', 'Greenwich', NULL, '[[regtime_]]', NULL),
('mscs', '/_MpXT|', 'Hackney', NULL, '[[regtime_]]', NULL),
('mrƑߚ', '/_MpXT|', 'Hammersmith and Fulham', NULL, '[[regtime_]]', NULL),
('mqD@=we', '/_MpXT|', 'Haringey', NULL, '[[regtime_]]', NULL),
('mr^&', '/_MpXT|', 'Harrow', NULL, '[[regtime_]]', NULL),
('mrÚ,XO', '/_MpXT|', 'Havering', NULL, '[[regtime_]]', NULL),
('m"rLQ&', '/_MpXT|', 'Hillingdon', NULL, '[[regtime_]]', NULL),
('m(q7hEqX', '/_MpXT|', 'Hounslow', NULL, '[[regtime_]]', NULL),
('m.sؘ', '/_MpXT|', 'Islington', NULL, '[[regtime_]]', NULL),
('m4pYv', '/_MpXT|', 'Kensington and Chelsea', NULL, '[[regtime_]]', NULL),
('m:r0Qs.T', '/_MpXT|', 'Kingston upon Thames', NULL, '[[regtime_]]', NULL),
('m@sIYJ', '/_MpXT|', 'Lambeth', NULL, '[[regtime_]]', NULL),
('mFr&lgwVؓ', '/_MpXT|', 'Lewisham', NULL, '[[regtime_]]', NULL),
('mLpnfĲK', '/_MpXT|', 'Merton', NULL, '[[regtime_]]', NULL),
('mRpqT', '/_MpXT|', 'Newham', NULL, '[[regtime_]]', NULL),
('mXr歌Z', '/_MpXT|', 'Redbridge', NULL, '[[regtime_]]', NULL),
('m^sI`uq2O', '/_MpXT|', 'Richmond upon Thames', NULL, '[[regtime_]]', NULL),
('mdr`u`', '/_MpXT|', 'Southwark', NULL, '[[regtime_]]', NULL),
('mjp63y', '/_MpXT|', 'Sutton', NULL, '[[regtime_]]', NULL),
('mpsC\n', '/_MpXT|', 'Tower Hamlets', NULL, '[[regtime_]]', NULL),
('mxqs[fF', '/_MpXT|', 'Waltham Forest', NULL, '[[regtime_]]', NULL),
('mpͽ?\ZL', '/_MpXT|', 'Wandsworth', NULL, '[[regtime_]]', NULL),
('mqA_', '/_MpXT|', 'Westminster', NULL, '[[regtime_]]', NULL),
('mr;(^$', '/_MpXT|', 'Barnsley', NULL, '[[regtime_]]', NULL),
('msŞ܇>', '/_MpXT|', 'Birmingham', NULL, '[[regtime_]]', NULL),
('mrH?uS㚩', '/_MpXT|', 'Bolton', NULL, '[[regtime_]]', NULL),
('ms"O:', '/_MpXT|', 'Bradford', NULL, '[[regtime_]]', NULL),
('mrMy4(xq', '/_MpXT|', 'Bury', NULL, '[[regtime_]]', NULL),
('mrXW/.t,', '/_MpXT|', 'Calderdale', NULL, '[[regtime_]]', NULL),
('mr7', '/_MpXT|', 'Coventry', NULL, '[[regtime_]]', NULL),
('mp׏*G', '/_MpXT|', 'Doncaster', NULL, '[[regtime_]]', NULL),
('mr?N4k', '/_MpXT|', 'Dudley', NULL, '[[regtime_]]', NULL),
('ms\Z/', '/_MpXT|', 'Gateshead', NULL, '[[regtime_]]', NULL),
('mp2', '/_MpXT|', 'Kirklees', NULL, '[[regtime_]]', NULL),
('mrɳo+1', '/_MpXT|', 'Knowsley', NULL, '[[regtime_]]', NULL),
('mqW', '/_MpXT|', 'Leeds', NULL, '[[regtime_]]', NULL),
('mq,31u\ZA', '/_MpXT|', 'Liverpool', NULL, '[[regtime_]]', NULL),
('mr	f0,', '/_MpXT|', 'Manchester', NULL, '[[regtime_]]', NULL),
('mrηNIG5', '/_MpXT|', 'Newcastle upon Tyne', NULL, '[[regtime_]]', NULL),
('mqtv.3', '/_MpXT|', 'North Tyneside', NULL, '[[regtime_]]', NULL),
('ms0ݒUɥ', '/_MpXT|', 'Oldham', NULL, '[[regtime_]]', NULL),
('mq<Tv', '/_MpXT|', 'Rochdale', NULL, '[[regtime_]]', NULL),
('n\0rͺi2', '/_MpXT|', 'Rotherham', NULL, '[[regtime_]]', NULL),
('nrsgkW', '/_MpXT|', 'St. Helens', NULL, '[[regtime_]]', NULL),
('npҒ@T[', '/_MpXT|', 'Salford', NULL, '[[regtime_]]', NULL),
('np\nt xR', '/_MpXT|', 'Sandwell', NULL, '[[regtime_]]', NULL),
('nqW<', '/_MpXT|', 'Sefton', NULL, '[[regtime_]]', NULL),
('np$	', '/_MpXT|', 'Sheffield', NULL, '[[regtime_]]', NULL),
('n!r8MbD', '/_MpXT|', 'Solihull', NULL, '[[regtime_]]', NULL),
('n''pɲ/}2v', '/_MpXT|', 'South Tyneside', NULL, '[[regtime_]]', NULL),
('n-pX/7', '/_MpXT|', 'Stockport', NULL, '[[regtime_]]', NULL),
('n5p:.-}|', '/_MpXT|', 'Sunderland', NULL, '[[regtime_]]', NULL),
('n;r(l1', '/_MpXT|', 'Tameside', NULL, '[[regtime_]]', NULL),
('nBp3-', '/_MpXT|', 'Trafford', NULL, '[[regtime_]]', NULL),
('nJpبS', '/_MpXT|', 'Wakefield', NULL, '[[regtime_]]', NULL),
('nOqh<7&4', '/_MpXT|', 'Walsall', NULL, '[[regtime_]]', NULL),
('nUsXG', '/_MpXT|', 'Wigan', NULL, '[[regtime_]]', NULL),
('n[p[r,8I', '/_MpXT|', 'Wirral', NULL, '[[regtime_]]', NULL),
('n`sٓ!.m@', '/_MpXT|', 'Wolverhampton', NULL, '[[regtime_]]', NULL),
('nfqfe', '/_MpXT|', 'Bath and North East Somerset', NULL, '[[regtime_]]', NULL),
('nlp[D?nI', '/_MpXT|', 'Bedford', NULL, '[[regtime_]]', NULL),
('nrrNXD	\0"', '/_MpXT|', 'Blackburn with Darwen', NULL, '[[regtime_]]', NULL),
('nwrVMIR', '/_MpXT|', 'Blackpool', NULL, '[[regtime_]]', NULL),
('n}qO<', '/_MpXT|', 'Bournemouth', NULL, '[[regtime_]]', NULL),
('nqV\Z[B', '/_MpXT|', 'Bracknell Forest', NULL, '[[regtime_]]', NULL),
('np {Z', '/_MpXT|', 'Brighton and Hove', NULL, '[[regtime_]]', NULL),
('npĶV}&/u', '/_MpXT|', 'Bristol, City of', NULL, '[[regtime_]]', NULL),
('nr''9 ', '/_MpXT|', 'Central Bedfordshire', NULL, '[[regtime_]]', NULL),
('nrv%t', '/_MpXT|', 'Cheshire East', NULL, '[[regtime_]]', NULL),
('nrclv@', '/_MpXT|', 'Cheshire West and Chester', NULL, '[[regtime_]]', NULL),
('nr):NJo;K', '/_MpXT|', 'Cornwall', NULL, '[[regtime_]]', NULL),
('nq^jRR6', '/_MpXT|', 'Darlington', NULL, '[[regtime_]]', NULL),
('nrߪÜX,~', '/_MpXT|', 'Derby', NULL, '[[regtime_]]', NULL),
('np7e!z', '/_MpXT|', 'Durham County', NULL, '[[regtime_]]', NULL),
('nrD>"', '/_MpXT|', 'East Riding of Yorkshire', NULL, '[[regtime_]]', NULL),
('nr5솹', '/_MpXT|', 'Halton', NULL, '[[regtime_]]', NULL),
('np{̧', '/_MpXT|', 'Hartlepool', NULL, '[[regtime_]]', NULL),
('npL/''<H', '/_MpXT|', 'Herefordshire', NULL, '[[regtime_]]', NULL),
('nqʀD4', '/_MpXT|', 'Isle of Wight', NULL, '[[regtime_]]', NULL),
('nqQF', '/_MpXT|', 'Isles of Scilly', NULL, '[[regtime_]]', NULL),
('nqheW', '/_MpXT|', 'Kingston upon Hull', NULL, '[[regtime_]]', NULL),
('nqA', '/_MpXT|', 'Leicester', NULL, '[[regtime_]]', NULL),
('nple', '/_MpXT|', 'Luton', NULL, '[[regtime_]]', NULL),
('nqL*ڇȤ', '/_MpXT|', 'Medway', NULL, '[[regtime_]]', NULL),
('ns[#? v', '/_MpXT|', 'Middlesbrough', NULL, '[[regtime_]]', NULL),
('osRI%Æ', '/_MpXT|', 'Milton Keynes', NULL, '[[regtime_]]', NULL),
('orOG)', '/_MpXT|', 'North East Lincolnshire', NULL, '[[regtime_]]', NULL),
('oq+9', '/_MpXT|', 'North Lincolnshire', NULL, '[[regtime_]]', NULL),
('oqxXi', '/_MpXT|', 'North Somerset', NULL, '[[regtime_]]', NULL),
('oq7/	', '/_MpXT|', 'Northumberland', NULL, '[[regtime_]]', NULL),
('o%q]MHg6', '/_MpXT|', 'Nottingham', NULL, '[[regtime_]]', NULL),
('o+pdἩw', '/_MpXT|', 'Peterborough', NULL, '[[regtime_]]', NULL),
('o1pq%K', '/_MpXT|', 'Plymouth', NULL, '[[regtime_]]', NULL),
('o7pj,t', '/_MpXT|', 'Poole', NULL, '[[regtime_]]', NULL),
('o=r*9R0', '/_MpXT|', 'Portsmouth', NULL, '[[regtime_]]', NULL),
('oGqKӞz', '/_MpXT|', 'Reading', NULL, '[[regtime_]]', NULL),
('oTpt=Ef)', '/_MpXT|', 'Redcar and Cleveland', NULL, '[[regtime_]]', NULL),
('odps9Q', '/_MpXT|', 'Rutland', NULL, '[[regtime_]]', NULL),
('osrHi'';T', '/_MpXT|', 'Shropshire', NULL, '[[regtime_]]', NULL),
('os;k&I', '/_MpXT|', 'Slough', NULL, '[[regtime_]]', NULL),
('or\Z', '/_MpXT|', 'South Gloucestershire', NULL, '[[regtime_]]', NULL),
('oq<A(S\0', '/_MpXT|', 'Southampton', NULL, '[[regtime_]]', NULL),
('optGY;', '/_MpXT|', 'Southend-on-Sea', NULL, '[[regtime_]]', NULL),
('osȤҺ&', '/_MpXT|', 'Stockton-on-Tees', NULL, '[[regtime_]]', NULL),
('opgn', '/_MpXT|', 'Stoke-on-Trent', NULL, '[[regtime_]]', NULL),
('oqS\nTm҂', '/_MpXT|', 'Swindon', NULL, '[[regtime_]]', NULL),
('opS9q', '/_MpXT|', 'Telford and Wrekin', NULL, '[[regtime_]]', NULL),
('os}&ms', '/_MpXT|', 'Thurrock', NULL, '[[regtime_]]', NULL),
('or', '/_MpXT|', 'Torbay', NULL, '[[regtime_]]', NULL),
('oqل@^lQT', '/_MpXT|', 'Warrington', NULL, '[[regtime_]]', NULL),
('opD.=', '/_MpXT|', 'West Berkshire', NULL, '[[regtime_]]', NULL),
('oro', '/_MpXT|', 'Wiltshire', NULL, '[[regtime_]]', NULL),
('or^|@)ڂ', '/_MpXT|', 'Windsor and Maidenhead', NULL, '[[regtime_]]', NULL),
('op+;q', '/_MpXT|', 'Wokingham', NULL, '[[regtime_]]', NULL),
('opvN½E', '/_MpXT|', 'York', NULL, '[[regtime_]]', NULL),
('opJ\r͕', '/_MpXT|', 'Antrim and Newtownabbey', NULL, '[[regtime_]]', NULL),
('oqJ9F+', '/_MpXT|', 'Ards and North Down', NULL, '[[regtime_]]', NULL),
('oqZ*', '/_MpXT|', 'Armagh, Banbridge and Craigavon', NULL, '[[regtime_]]', NULL),
('os]~P`I', '/_MpXT|', 'Belfast', NULL, '[[regtime_]]', NULL),
('oq(Yez-', '/_MpXT|', 'Causeway Coast and Glens', NULL, '[[regtime_]]', NULL),
('pqԖ5̠', '/_MpXT|', 'Derry and Strabane', NULL, '[[regtime_]]', NULL),
('ppbg', '/_MpXT|', 'Fermanagh and Omagh', NULL, '[[regtime_]]', NULL),
('prU/', '/_MpXT|', 'Lisburn and Castlereagh', NULL, '[[regtime_]]', NULL),
('pr,', '/_MpXT|', 'Mid and East Antrim', NULL, '[[regtime_]]', NULL),
('pqnu', '/_MpXT|', 'Mid Ulster', NULL, '[[regtime_]]', NULL),
('p#pGT', '/_MpXT|', 'Newry, Mourne and Down', NULL, '[[regtime_]]', NULL),
('p*r	Tm\0', '/_MpXT|', 'Aberdeen City', NULL, '[[regtime_]]', NULL),
('p1r\\򸭡D', '/_MpXT|', 'Aberdeenshire', NULL, '[[regtime_]]', NULL),
('p8rnn.m', '/_MpXT|', 'Angus', NULL, '[[regtime_]]', NULL),
('p@q藋t', '/_MpXT|', 'Argyll and Bute', NULL, '[[regtime_]]', NULL),
('pFsՊNZ#J', '/_MpXT|', 'Clackmannanshire', NULL, '[[regtime_]]', NULL),
('pLr	\Z2P', '/_MpXT|', 'Dumfries and Galloway', NULL, '[[regtime_]]', NULL),
('pRpy(', '/_MpXT|', 'Dundee City', NULL, '[[regtime_]]', NULL),
('pYrǒf\n', '/_MpXT|', 'East Ayrshire', NULL, '[[regtime_]]', NULL),
('p_pP$uB', '/_MpXT|', 'East Dunbartonshire', NULL, '[[regtime_]]', NULL),
('pesI\0JW', '/_MpXT|', 'East Lothian', NULL, '[[regtime_]]', NULL),
('pkq仠HE', '/_MpXT|', 'East Renfrewshire', NULL, '[[regtime_]]', NULL),
('prr!FO9', '/_MpXT|', 'Edinburgh, City of', NULL, '[[regtime_]]', NULL),
('p~pqyg#:', '/_MpXT|', 'Eilean Siar', NULL, '[[regtime_]]', NULL),
('prDQ ', '/_MpXT|', 'Falkirk', NULL, '[[regtime_]]', NULL),
('prir', '/_MpXT|', 'Fife', NULL, '[[regtime_]]', NULL),
('pr34Rw;', '/_MpXT|', 'Glasgow City', NULL, '[[regtime_]]', NULL),
('pqX@_O', '/_MpXT|', 'Highland', NULL, '[[regtime_]]', NULL),
('prz\0B', '/_MpXT|', 'Inverclyde', NULL, '[[regtime_]]', NULL),
('pr[-Uj', '/_MpXT|', 'Midlothian', NULL, '[[regtime_]]', NULL),
('ps\0jE}jx', '/_MpXT|', 'Moray', NULL, '[[regtime_]]', NULL),
('pr"', '/_MpXT|', 'North Ayrshire', NULL, '[[regtime_]]', NULL),
('psҖ*%I', '/_MpXT|', 'North Lanarkshire', NULL, '[[regtime_]]', NULL),
('pra#]~', '/_MpXT|', 'Orkney Islands', NULL, '[[regtime_]]', NULL),
('pqJ9>', '/_MpXT|', 'Perth and Kinross', NULL, '[[regtime_]]', NULL),
('prBLR%', '/_MpXT|', 'Renfrewshire', NULL, '[[regtime_]]', NULL),
('pqȩ"D', '/_MpXT|', 'Scottish Borders, The', NULL, '[[regtime_]]', NULL),
('psep(p', '/_MpXT|', 'Shetland Islands', NULL, '[[regtime_]]', NULL),
('pp6S', '/_MpXT|', 'South Ayrshire', NULL, '[[regtime_]]', NULL),
('ppD*$/', '/_MpXT|', 'South Lanarkshire', NULL, '[[regtime_]]', NULL),
('pr(<@', '/_MpXT|', 'Stirling', NULL, '[[regtime_]]', NULL),
('pq2V.', '/_MpXT|', 'West Dunbartonshire', NULL, '[[regtime_]]', NULL),
('pr& v-', '/_MpXT|', 'West Lothian', NULL, '[[regtime_]]', NULL),
('qsbs', '/_MpXT|', 'Blaenau Gwent', NULL, '[[regtime_]]', NULL),
('qsͮ54:=', '/_MpXT|', 'Bridgend', NULL, '[[regtime_]]', NULL),
('qp3F"|', '/_MpXT|', 'Caerphilly', NULL, '[[regtime_]]', NULL),
('qq>dy', '/_MpXT|', 'Cardiff', NULL, '[[regtime_]]', NULL),
('qp\rŲq', '/_MpXT|', 'Carmarthenshire', NULL, '[[regtime_]]', NULL),
('q$r1ت;', '/_MpXT|', 'Ceredigion', NULL, '[[regtime_]]', NULL),
('q)sѲ^Mn', '/_MpXT|', 'Conwy', NULL, '[[regtime_]]', NULL),
('q/qӷva.՗', '/_MpXT|', 'Denbighshire', NULL, '[[regtime_]]', NULL),
('q6rj	ǜ', '/_MpXT|', 'Flintshire', NULL, '[[regtime_]]', NULL),
('q<r^3Td', '/_MpXT|', 'Gwynedd', NULL, '[[regtime_]]', NULL),
('qBr"S', '/_MpXT|', 'Isle of Anglesey', NULL, '[[regtime_]]', NULL),
('qHpsoơȝW', '/_MpXT|', 'Merthyr Tydfil', NULL, '[[regtime_]]', NULL),
('qNqz^b', '/_MpXT|', 'Monmouthshire', NULL, '[[regtime_]]', NULL),
('qTrC/[', '/_MpXT|', 'Neath Port Talbot', NULL, '[[regtime_]]', NULL),
('qZp*g', '/_MpXT|', 'Newport', NULL, '[[regtime_]]', NULL),
('qas0\Z5Mq', '/_MpXT|', 'Pembrokeshire', NULL, '[[regtime_]]', NULL),
('qlp!X:', '/_MpXT|', 'Powys', NULL, '[[regtime_]]', NULL),
('qrppp\n', '/_MpXT|', 'Rhondda, Cynon, Taff', NULL, '[[regtime_]]', NULL),
('qxqm', '/_MpXT|', 'Swansea', NULL, '[[regtime_]]', NULL),
('q~s4A5', '/_MpXT|', 'Torfaen', NULL, '[[regtime_]]', NULL),
('qrY$', '/_MpXT|', 'Vale of Glamorgan, The', NULL, '[[regtime_]]', NULL),
('qr=M', '/_MpXT|', 'Wrexham', NULL, '[[regtime_]]', NULL),
('rr+Im', '/_MpXT|', 'Alabama', NULL, '[[regtime_]]', NULL),
('rr@_7S<', '/_MpXT|', 'Alaska', NULL, '[[regtime_]]', NULL),
('rq-W', '/_MpXT|', 'Arizona', NULL, '[[regtime_]]', NULL),
('rpn''j>zMO', '/_MpXT|', 'Arkansas', NULL, '[[regtime_]]', NULL),
('rrVɲ2xDM', '/_MpXT|', 'California', NULL, '[[regtime_]]', NULL),
('rqy', '/_MpXT|', 'Colorado', NULL, '[[regtime_]]', NULL),
('rqȲn~9', '/_MpXT|', 'Connecticut', NULL, '[[regtime_]]', NULL),
('sp-L2', '/_MpXT|', 'Delaware', NULL, '[[regtime_]]', NULL),
('sr2e*Ϊ', '/_MpXT|', 'Florida', NULL, '[[regtime_]]', NULL),
('s\rp(C=', '/_MpXT|', 'Georgia', NULL, '[[regtime_]]', NULL),
('srl $Dl', '/_MpXT|', 'Hawaii', NULL, '[[regtime_]]', NULL),
('ssJh=Q', '/_MpXT|', 'Idaho', NULL, '[[regtime_]]', NULL),
('sqLɪv', '/_MpXT|', 'Illinois', NULL, '[[regtime_]]', NULL),
('s%s{dh+z', '/_MpXT|', 'Indiana', NULL, '[[regtime_]]', NULL),
('s.q4:k', '/_MpXT|', 'Iowa', NULL, '[[regtime_]]', NULL),
('s<qfxÿFc', '/_MpXT|', 'Kansas', NULL, '[[regtime_]]', NULL),
('sNq<TM', '/_MpXT|', 'Kentucky', NULL, '[[regtime_]]', NULL),
('sYqߖj', '/_MpXT|', 'Louisiana', NULL, '[[regtime_]]', NULL),
('siq\\a%', '/_MpXT|', 'Maine', NULL, '[[regtime_]]', NULL),
('sorYp\rf>', '/_MpXT|', 'Maryland', NULL, '[[regtime_]]', NULL),
('surf"', '/_MpXT|', 'Massachusetts', NULL, '[[regtime_]]', NULL),
('s{qی\Z`', '/_MpXT|', 'Michigan', NULL, '[[regtime_]]', NULL),
('ssd', '/_MpXT|', 'Minnesota', NULL, '[[regtime_]]', NULL),
('sqŘ\\%m̻:', '/_MpXT|', 'Mississippi', NULL, '[[regtime_]]', NULL),
('sr\0', '/_MpXT|', 'Missouri', NULL, '[[regtime_]]', NULL),
('srSfa<J', '/_MpXT|', 'Montana', NULL, '[[regtime_]]', NULL),
('sqBw', '/_MpXT|', 'Nebraska', NULL, '[[regtime_]]', NULL),
('spRD', '/_MpXT|', 'Nevada', NULL, '[[regtime_]]', NULL),
('sq[bʺ', '/_MpXT|', 'New Hampshire', NULL, '[[regtime_]]', NULL),
('sr٥(', '/_MpXT|', 'New Jersey', NULL, '[[regtime_]]', NULL),
('sqz$^O', '/_MpXT|', 'New Mexico', NULL, '[[regtime_]]', NULL),
('sqݿX:rA', '/_MpXT|', 'New York', NULL, '[[regtime_]]', NULL),
('sr̺%BSW', '/_MpXT|', 'North Carolina', NULL, '[[regtime_]]', NULL),
('spzqJd', '/_MpXT|', 'North Dakota', NULL, '[[regtime_]]', NULL),
('sp$}-', '/_MpXT|', 'Ohio', NULL, '[[regtime_]]', NULL),
('spF6X(', '/_MpXT|', 'Oklahoma', NULL, '[[regtime_]]', NULL),
('ss(', '/_MpXT|', 'Oregon', NULL, '[[regtime_]]', NULL),
('sqp&~\Z', '/_MpXT|', 'Pennsylvania', NULL, '[[regtime_]]', NULL),
('sqhp>', '/_MpXT|', 'Rhode Island', NULL, '[[regtime_]]', NULL),
('spz-ν', '/_MpXT|', 'South Carolina', NULL, '[[regtime_]]', NULL),
('spޏ-', '/_MpXT|', 'South Dakota', NULL, '[[regtime_]]', NULL),
('sp)0', '/_MpXT|', 'Tennessee', NULL, '[[regtime_]]', NULL),
('sqwY5\r&2', '/_MpXT|', 'Texas', NULL, '[[regtime_]]', NULL),
('tpO3', '/_MpXT|', 'Utah', NULL, '[[regtime_]]', NULL),
('tp1ѻo', '/_MpXT|', 'Vermont', NULL, '[[regtime_]]', NULL),
('tpۮB;n', '/_MpXT|', 'Virginia', NULL, '[[regtime_]]', NULL),
('tpi݊;', '/_MpXT|', 'Washington', NULL, '[[regtime_]]', NULL),
('t\Zq}om', '/_MpXT|', 'West Virginia', NULL, '[[regtime_]]', NULL),
('t q_', '/_MpXT|', 'Wisconsin', NULL, '[[regtime_]]', NULL),
('t,s>1l\r', '/_MpXT|', 'Wyoming', NULL, '[[regtime_]]', NULL),
('t2qLy@', '/_MpXT|', 'District of Columbia', NULL, '[[regtime_]]', NULL),
('\rrO	', 'jlrm%LL7WJ', 'Ontario', NULL, '[[regtime_]]', NULL),
('\rrO	', '/_MpXT|', 'Ontario', NULL, '[[regtime_]]', NULL),
('\rrO؊', 'jlrm%LL7WJ', 'Québec', NULL, '[[regtime_]]', NULL),
('\rrO؊', '/_MpXT|', 'Quebec', NULL, '[[regtime_]]', NULL),
('\rrOvU', 'jlrm%LL7WJ', 'Nova Scotia', NULL, '[[regtime_]]', NULL),
('\rrOvU', '/_MpXT|', 'Nova Scotia', NULL, '[[regtime_]]', NULL),
('\rrO;', 'jlrm%LL7WJ', 'New Brunswick', NULL, '[[regtime_]]', NULL),
('\rrO;', '/_MpXT|', 'New Brunswick', NULL, '[[regtime_]]', NULL),
('\rrOv', 'jlrm%LL7WJ', 'Manitoba', NULL, '[[regtime_]]', NULL),
('\rrOv', '/_MpXT|', 'Manitoba', NULL, '[[regtime_]]', NULL),
('\rrO.', 'jlrm%LL7WJ', 'British Columbia', NULL, '[[regtime_]]', NULL),
('\rrO.', '/_MpXT|', 'British Columbia', NULL, '[[regtime_]]', NULL),
('\rrOi', 'jlrm%LL7WJ', 'Prince Edward Island', NULL, '[[regtime_]]', NULL),
('\rrOi', '/_MpXT|', 'Prince Edward Island', NULL, '[[regtime_]]', NULL),
('\rrO\n', 'jlrm%LL7WJ', 'Saskatchewan', NULL, '[[regtime_]]', NULL),
('\rrO\n', '/_MpXT|', 'Saskatchewan', NULL, '[[regtime_]]', NULL),
('\rrOڇ', 'jlrm%LL7WJ', 'Alberta', NULL, '[[regtime_]]', NULL),
('\rrOڇ', '/_MpXT|', 'Alberta', NULL, '[[regtime_]]', NULL),
('\rrOV_', 'jlrm%LL7WJ', 'Neufundland und Labrador', NULL, '[[regtime_]]', NULL),
('\rrOV_', '/_MpXT|', 'Newfoundland and Labrador', NULL, '[[regtime_]]', NULL),
('\rrOWǤ', 'jlrm%LL7WJ', 'Nordwest-Territorien', NULL, '[[regtime_]]', NULL),
('\rrOWǤ', '/_MpXT|', 'Northwest Territories', NULL, '[[regtime_]]', NULL),
('\rrOX', 'jlrm%LL7WJ', 'Yukon', NULL, '[[regtime_]]', NULL),
('\rrOX', '/_MpXT|', 'Yukon', NULL, '[[regtime_]]', NULL),
('\rrOۻ', 'jlrm%LL7WJ', 'Nunavut', NULL, '[[regtime_]]', NULL),
('\rrOۻ', '/_MpXT|', 'Nunavut', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `country_translation`
--

CREATE TABLE `country_translation` (
  `country_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_format` json DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`country_id`,`language_id`),
  KEY `fk.country_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `country_translation`
--

INSERT INTO `country_translation` VALUES
('js', 'jlrm%LL7WJ', 'Deutschland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('js', '/_MpXT|', 'Germany', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('kqzݳ', 'jlrm%LL7WJ', 'Griechenland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('kqzݳ', '/_MpXT|', 'Greece', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ks>8W', 'jlrm%LL7WJ', 'Vereinigtes Königreich', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ks>8W', '/_MpXT|', 'United Kingdom', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qpIwEc', 'jlrm%LL7WJ', 'Irland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qpIwEc', '/_MpXT|', 'Ireland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qqH]u', 'jlrm%LL7WJ', 'Island', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qqH]u', '/_MpXT|', 'Iceland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qqtw''L', 'jlrm%LL7WJ', 'Italien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qqtw''L', '/_MpXT|', 'Italy', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qrӥG&', 'jlrm%LL7WJ', 'Japan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qrӥG&', '/_MpXT|', 'Japan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qpX粣}xI', 'jlrm%LL7WJ', 'Kanada', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qpX粣}xI', '/_MpXT|', 'Canada', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qrah', 'jlrm%LL7WJ', 'Luxemburg', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qrah', '/_MpXT|', 'Luxembourg', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qqRᲭ', 'jlrm%LL7WJ', 'Namibia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qqRᲭ', '/_MpXT|', 'Namibia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qp''$1,', 'jlrm%LL7WJ', 'Niederlande', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qp''$1,', '/_MpXT|', 'Netherlands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qpG4uS', 'jlrm%LL7WJ', 'Norwegen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qpG4uS', '/_MpXT|', 'Norway', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qp!Z=', 'jlrm%LL7WJ', 'Österreich', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qp!Z=', '/_MpXT|', 'Austria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qpjx', 'jlrm%LL7WJ', 'Portugal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qpjx', '/_MpXT|', 'Portugal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rr8:\Z,', 'jlrm%LL7WJ', 'Schweden', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rr8:\Z,', '/_MpXT|', 'Sweden', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rrd >i', 'jlrm%LL7WJ', 'Schweiz', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rrd >i', '/_MpXT|', 'Switzerland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rq5/', 'jlrm%LL7WJ', 'Spanien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rq5/', '/_MpXT|', 'Spain', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rq̆\rnq', 'jlrm%LL7WJ', 'Vereinigte Staaten von Amerika', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', '[[regtime_]]'),
('rq̆\rnq', '/_MpXT|', 'United States of America', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', '[[regtime_]]'),
('t9rٲsUĻ', 'jlrm%LL7WJ', 'Liechtenstein', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('t9rٲsUĻ', '/_MpXT|', 'Liechtenstein', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('tBq*;s', 'jlrm%LL7WJ', 'Arabische Emirate', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('tBq*;s', '/_MpXT|', 'Arab Emirates', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('tMp	', 'jlrm%LL7WJ', 'Polen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('tMp	', '/_MpXT|', 'Poland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('tVq0%.', 'jlrm%LL7WJ', 'Ungarn', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('tVq0%.', '/_MpXT|', 'Hungary', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('t_rJ)=', 'jlrm%LL7WJ', 'Türkei', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('t_rJ)=', '/_MpXT|', 'Turkey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('tipھ}@', 'jlrm%LL7WJ', 'Tschechische Republik', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('tipھ}@', '/_MpXT|', 'Czech Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('tsw\\G', 'jlrm%LL7WJ', 'Slowakei', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', '[[regtime_]]'),
('tsw\\G', '/_MpXT|', 'Slovakia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', '[[regtime_]]'),
('u@qB', 'jlrm%LL7WJ', 'Rumänien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('u@qB', '/_MpXT|', 'Romania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('upjWJ#]', 'jlrm%LL7WJ', 'Brasilien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('upjWJ#]', '/_MpXT|', 'Brazil', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ur1@Y!q', 'jlrm%LL7WJ', 'Israel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ur1@Y!q', '/_MpXT|', 'Israel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('uqlwv', 'jlrm%LL7WJ', 'Australien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('uqlwv', '/_MpXT|', 'Australia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('usox]T[', 'jlrm%LL7WJ', 'Belgien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('usox]T[', '/_MpXT|', 'Belgium', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('us,T؉', 'jlrm%LL7WJ', 'Dänemark', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('us,T؉', '/_MpXT|', 'Denmark', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ur(,', 'jlrm%LL7WJ', 'Finnland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ur(,', '/_MpXT|', 'Finland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('upԃo}', 'jlrm%LL7WJ', 'Frankreich', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('upԃo}', '/_MpXT|', 'France', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rEsN', 'jlrm%LL7WJ', 'Bulgarien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rEsN', '/_MpXT|', 'Bulgaria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r"YQ', 'jlrm%LL7WJ', 'Estland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r"YQ', '/_MpXT|', 'Estonia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r(da}', 'jlrm%LL7WJ', 'Kroatien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r(da}', '/_MpXT|', 'Croatia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r*fqG', 'jlrm%LL7WJ', 'Lettland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r*fqG', '/_MpXT|', 'Latvia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pr笈z', 'jlrm%LL7WJ', 'Litauen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pr笈z', '/_MpXT|', 'Lithuania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('p*Y\nhT', 'jlrm%LL7WJ', 'Malta', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('p*Y\nhT', '/_MpXT|', 'Malta', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q2+?pr2b', 'jlrm%LL7WJ', 'Slowenien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q2+?pr2b', '/_MpXT|', 'Slovenia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('s"bx~pr', 'jlrm%LL7WJ', 'Zypern', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('s"bx~pr', '/_MpXT|', 'Cyprus', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('!p͟?4', 'jlrm%LL7WJ', 'Afghanistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('!p͟?4', '/_MpXT|', 'Afghanistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('*q͑~Ǥ', 'jlrm%LL7WJ', 'Åland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('*q͑~Ǥ', '/_MpXT|', 'Åland Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('3s0x;f', 'jlrm%LL7WJ', 'Albanien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('3s0x;f', '/_MpXT|', 'Albania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('<rS+&', 'jlrm%LL7WJ', 'Algerien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('<rS+&', '/_MpXT|', 'Algeria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Eq($', 'jlrm%LL7WJ', 'Amerikanisch-Samoa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Eq($', '/_MpXT|', 'American Samoa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('NrA`p+\\', 'jlrm%LL7WJ', 'Andorra', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('NrA`p+\\', '/_MpXT|', 'Andorra', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Xp#	o', 'jlrm%LL7WJ', 'Angola', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Xp#	o', '/_MpXT|', 'Angola', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cq:cMb', 'jlrm%LL7WJ', 'Anguilla', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('cq:cMb', '/_MpXT|', 'Anguilla', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('lr%@zx', 'jlrm%LL7WJ', 'Antarktika', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('lr%@zx', '/_MpXT|', 'Antarctica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('up\0$jI:', 'jlrm%LL7WJ', 'Antigua und Barbuda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('up\0$jI:', '/_MpXT|', 'Antigua and Barbuda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('~s޿ߚ]', 'jlrm%LL7WJ', 'Argentinien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('~s޿ߚ]', '/_MpXT|', 'Argentina', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ȇpvjx3', 'jlrm%LL7WJ', 'Armenien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ȇpvjx3', '/_MpXT|', 'Armenia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Ȑp7y+N', 'jlrm%LL7WJ', 'Aruba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Ȑp7y+N', '/_MpXT|', 'Aruba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('șrDg]=', 'jlrm%LL7WJ', 'Aserbaidschan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('șrDg]=', '/_MpXT|', 'Azerbaijan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ȢrD\n;-', 'jlrm%LL7WJ', 'Bahamas', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ȢrD\n;-', '/_MpXT|', 'Bahamas', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ȫp̌wN%', 'jlrm%LL7WJ', 'Bahrain', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ȫp̌wN%', '/_MpXT|', 'Bahrain', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ȴq_k', 'jlrm%LL7WJ', 'Bangladesch', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ȴq_k', '/_MpXT|', 'Bangladesh', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ȽsZ9tm', 'jlrm%LL7WJ', 'Barbados', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ȽsZ9tm', '/_MpXT|', 'Barbados', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sr)z', 'jlrm%LL7WJ', 'Weißrussland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sr)z', '/_MpXT|', 'Belarus', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('s	-ЄZ', 'jlrm%LL7WJ', 'Belize', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('s	-ЄZ', '/_MpXT|', 'Belize', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q''dg~', 'jlrm%LL7WJ', 'Benin', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q''dg~', '/_MpXT|', 'Benin', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r[3', 'jlrm%LL7WJ', 'Bermuda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r[3', '/_MpXT|', 'Bermuda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('p\Z', 'jlrm%LL7WJ', 'Bhutan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('p\Z', '/_MpXT|', 'Bhutan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('p݈)', 'jlrm%LL7WJ', 'Bolivien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('p݈)', '/_MpXT|', 'Bolivia (Plurinational State of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qT', 'jlrm%LL7WJ', 'Bonaire, Sint Eustatius und Saba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qT', '/_MpXT|', 'Bonaire, Sint Eustatius and Saba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qt4Mh', 'jlrm%LL7WJ', 'Bosnien und Herzegowina', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qt4Mh', '/_MpXT|', 'Bosnia and Herzegovina', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q ah@K', 'jlrm%LL7WJ', 'Botswana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q ah@K', '/_MpXT|', 'Botswana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\Zrh62', 'jlrm%LL7WJ', 'Bouvetinsel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\Zrh62', '/_MpXT|', 'Bouvet Island', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('$sj', 'jlrm%LL7WJ', 'Britisches Territorium im Indischen Ozean', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('$sj', '/_MpXT|', 'British Indian Ocean Territory', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('/rЦ ''v".', 'jlrm%LL7WJ', 'Kleinere Inselbesitzungen der Vereinigten Staaten', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('/rЦ ''v".', '/_MpXT|', 'United States Minor Outlying Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('8qeCgk', 'jlrm%LL7WJ', 'Britische Jungferninseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('8qeCgk', '/_MpXT|', 'Virgin Islands (British)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Ar\\e8i', 'jlrm%LL7WJ', 'Amerikanische Jungferninseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Ar\\e8i', '/_MpXT|', 'Virgin Islands (U.S.)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('JpʧdYGe', 'jlrm%LL7WJ', 'Brunei', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('JpʧdYGe', '/_MpXT|', 'Brunei Darussalam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('SqG3-^', 'jlrm%LL7WJ', 'Burkina Faso', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('SqG3-^', '/_MpXT|', 'Burkina Faso', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\s|^l2O4', 'jlrm%LL7WJ', 'Burundi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\s|^l2O4', '/_MpXT|', 'Burundi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('fq"7P', 'jlrm%LL7WJ', 'Kambodscha', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('fq"7P', '/_MpXT|', 'Cambodia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('opֆ;)I', 'jlrm%LL7WJ', 'Kamerun', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('opֆ;)I', '/_MpXT|', 'Cameroon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('yqP1WH', 'jlrm%LL7WJ', 'Kap Verde', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('yqP1WH', '/_MpXT|', 'Cabo Verde', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ɂqq', 'jlrm%LL7WJ', 'Kaimaninseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ɂqq', '/_MpXT|', 'Cayman Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ɔrO	uIUF', 'jlrm%LL7WJ', 'Zentralafrikanische Republik', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ɔrO	uIUF', '/_MpXT|', 'Central African Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ɪpl	', 'jlrm%LL7WJ', 'Tschad', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ɪpl	', '/_MpXT|', 'Chad', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ɿs1:BEd6', 'jlrm%LL7WJ', 'Chile', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ɿs1:BEd6', '/_MpXT|', 'Chile', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rfpZ', 'jlrm%LL7WJ', 'China', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rfpZ', '/_MpXT|', 'China', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pds|', 'jlrm%LL7WJ', 'Weihnachtsinsel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pds|', '/_MpXT|', 'Christmas Island', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('s	\0c', 'jlrm%LL7WJ', 'Kokosinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('s	\0c', '/_MpXT|', 'Cocos (Keeling) Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pڅ{<Iq', 'jlrm%LL7WJ', 'Kolumbien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pڅ{<Iq', '/_MpXT|', 'Colombia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('.sTvڰ', 'jlrm%LL7WJ', 'Union der Komoren', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('.sTvڰ', '/_MpXT|', 'Comoros', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('>s6BYZ', 'jlrm%LL7WJ', 'Kongo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('>s6BYZ', '/_MpXT|', 'Congo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL);
INSERT INTO `country_translation` VALUES
('TpZH6>', 'jlrm%LL7WJ', 'Kongo (Dem. Rep.)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('TpZH6>', '/_MpXT|', 'Congo (Democratic Republic of the)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('jpm?4i', 'jlrm%LL7WJ', 'Cookinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('jpm?4i', '/_MpXT|', 'Cook Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('|q\r2.d\Z$', 'jlrm%LL7WJ', 'Costa Rica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('|q\r2.d\Z$', '/_MpXT|', 'Costa Rica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ʏr..6', 'jlrm%LL7WJ', 'Kuba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ʏr..6', '/_MpXT|', 'Cuba', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ʜrȰz!?[', 'jlrm%LL7WJ', 'Curaçao', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ʜrȰz!?[', '/_MpXT|', 'Curaçao', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ʥsꧠ{`8"', 'jlrm%LL7WJ', 'Dschibuti', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ʥsꧠ{`8"', '/_MpXT|', 'Djibouti', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ʮr2]4', 'jlrm%LL7WJ', 'Dominica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ʮr2]4', '/_MpXT|', 'Dominica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ʸsA&t$ c', 'jlrm%LL7WJ', 'Dominikanische Republik', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ʸsA&t$ c', '/_MpXT|', 'Dominican Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rIǂJQ', 'jlrm%LL7WJ', 'Ecuador', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rIǂJQ', '/_MpXT|', 'Ecuador', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('p/]x', 'jlrm%LL7WJ', 'Ägypten', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('p/]x', '/_MpXT|', 'Egypt', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qrs.', 'jlrm%LL7WJ', 'El Salvador', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qrs.', '/_MpXT|', 'El Salvador', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pSsTaS 0', 'jlrm%LL7WJ', 'Äquatorial-Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pSsTaS 0', '/_MpXT|', 'Equatorial Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('p?#Ȱ17', 'jlrm%LL7WJ', 'Eritrea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('p?#Ȱ17', '/_MpXT|', 'Eritrea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sJ', 'jlrm%LL7WJ', 'Äthiopien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sJ', '/_MpXT|', 'Ethiopia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rP', 'jlrm%LL7WJ', 'Falklandinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rP', '/_MpXT|', 'Falkland Islands (Malvinas)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rO/q\Z', 'jlrm%LL7WJ', 'Färöer-Inseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rO/q\Z', '/_MpXT|', 'Faroe Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q۠`', 'jlrm%LL7WJ', 'Fidschi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q۠`', '/_MpXT|', 'Fiji', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qJ\rd', 'jlrm%LL7WJ', 'Französisch Guyana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qJ\rd', '/_MpXT|', 'French Guiana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(' qOF', 'jlrm%LL7WJ', 'Französisch-Polynesien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
(' qOF', '/_MpXT|', 'French Polynesia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('(pAK$\n:Ӛ', 'jlrm%LL7WJ', 'Französische Süd- und Antarktisgebiete', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('(pAK$\n:Ӛ', '/_MpXT|', 'French Southern Territories', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('8sTH4', 'jlrm%LL7WJ', 'Gabun', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('8sTH4', '/_MpXT|', 'Gabon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Ap	PR', 'jlrm%LL7WJ', 'Gambia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Ap	PR', '/_MpXT|', 'Gambia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Jsk5', 'jlrm%LL7WJ', 'Georgien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Jsk5', '/_MpXT|', 'Georgia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Rprd#f', 'jlrm%LL7WJ', 'Ghana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Rprd#f', '/_MpXT|', 'Ghana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('[pS8', 'jlrm%LL7WJ', 'Gibraltar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('[pS8', '/_MpXT|', 'Gibraltar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dpn/f-', 'jlrm%LL7WJ', 'Grönland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dpn/f-', '/_MpXT|', 'Greenland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pqut{z', 'jlrm%LL7WJ', 'Grenada', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pqut{z', '/_MpXT|', 'Grenada', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('yqN2g', 'jlrm%LL7WJ', 'Guadeloupe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('yqN2g', '/_MpXT|', 'Guadeloupe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('˅q*Κ䲚', 'jlrm%LL7WJ', 'Guam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('˅q*Κ䲚', '/_MpXT|', 'Guam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ˎq99J', 'jlrm%LL7WJ', 'Guatemala', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ˎq99J', '/_MpXT|', 'Guatemala', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('˗r|9>_,', 'jlrm%LL7WJ', 'Guernsey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('˗r|9>_,', '/_MpXT|', 'Guernsey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ˠp&r=LKu', 'jlrm%LL7WJ', 'Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ˠp&r=LKu', '/_MpXT|', 'Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('˩p|c', 'jlrm%LL7WJ', 'Guinea-Bissau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('˩p|c', '/_MpXT|', 'Guinea-Bissau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('˲p2', 'jlrm%LL7WJ', 'Guyana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('˲p2', '/_MpXT|', 'Guyana', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('˻qgo', 'jlrm%LL7WJ', 'Haiti', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('˻qgo', '/_MpXT|', 'Haiti', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('s$"Pt', 'jlrm%LL7WJ', 'Heard und die McDonaldinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('s$"Pt', '/_MpXT|', 'Heard Island and McDonald Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('s%_py ?', 'jlrm%LL7WJ', 'Staat Vatikanstadt', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('s%_py ?', '/_MpXT|', 'Vatican City', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pU', 'jlrm%LL7WJ', 'Honduras', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pU', '/_MpXT|', 'Honduras', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('s,.', 'jlrm%LL7WJ', 'Hong Kong', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('s,.', '/_MpXT|', 'Hong Kong', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pUƦc', 'jlrm%LL7WJ', 'Indien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pUƦc', '/_MpXT|', 'India', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r\ZϏ+V', 'jlrm%LL7WJ', 'Indonesien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r\ZϏ+V', '/_MpXT|', 'Indonesia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r`dS', 'jlrm%LL7WJ', 'Elfenbeinküste', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r`dS', '/_MpXT|', 'Côte d''Ivoire', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sz''dgٽP', 'jlrm%LL7WJ', 'Iran', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sz''dgٽP', '/_MpXT|', 'Iran (Islamic Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\rpO˟**', 'jlrm%LL7WJ', 'Irak', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\rpO˟**', '/_MpXT|', 'Iraq', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q''_''V', 'jlrm%LL7WJ', 'Insel Man', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q''_''V', '/_MpXT|', 'Isle of Man', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pzI&x', 'jlrm%LL7WJ', 'Jamaika', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pzI&x', '/_MpXT|', 'Jamaica', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('+qİqW=', 'jlrm%LL7WJ', 'Jersey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('+qİqW=', '/_MpXT|', 'Jersey', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('4p"C@`B', 'jlrm%LL7WJ', 'Jordanien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('4p"C@`B', '/_MpXT|', 'Jordan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('=r{', 'jlrm%LL7WJ', 'Kasachstan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('=r{', '/_MpXT|', 'Kazakhstan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('FqEJ', 'jlrm%LL7WJ', 'Kenia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('FqEJ', '/_MpXT|', 'Kenya', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Rq~ݜi?', 'jlrm%LL7WJ', 'Kiribati', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Rq~ݜi?', '/_MpXT|', 'Kiribati', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('[ssy', 'jlrm%LL7WJ', 'Kuwait', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('[ssy', '/_MpXT|', 'Kuwait', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dr q"K', 'jlrm%LL7WJ', 'Kirgisistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('dr q"K', '/_MpXT|', 'Kyrgyzstan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('mr԰%9', 'jlrm%LL7WJ', 'Laos', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('mr԰%9', '/_MpXT|', 'Lao People''s Democratic Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('vsٿ&Zq ', 'jlrm%LL7WJ', 'Libanon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('vsٿ&Zq ', '/_MpXT|', 'Lebanon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('̀r\r3be', 'jlrm%LL7WJ', 'Lesotho', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('̀r\r3be', '/_MpXT|', 'Lesotho', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('̉q&h6ڷ>', 'jlrm%LL7WJ', 'Liberia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('̉q&h6ڷ>', '/_MpXT|', 'Liberia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('̒s3st', 'jlrm%LL7WJ', 'Libyen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('̒s3st', '/_MpXT|', 'Libya', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('̛qM%5U', 'jlrm%LL7WJ', 'Macao', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('̛qM%5U', '/_MpXT|', 'Macao', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('̤ry\r', 'jlrm%LL7WJ', 'Mazedonien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('̤ry\r', '/_MpXT|', 'Macedonia (the former Yugoslav Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('̯s7ύ-/', 'jlrm%LL7WJ', 'Madagaskar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('̯s7ύ-/', '/_MpXT|', 'Madagascar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('̺r\Zcc9', 'jlrm%LL7WJ', 'Malawi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('̺r\Zcc9', '/_MpXT|', 'Malawi', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r3''ؔ', 'jlrm%LL7WJ', 'Malaysia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r3''ؔ', '/_MpXT|', 'Malaysia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rH', 'jlrm%LL7WJ', 'Malediven', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rH', '/_MpXT|', 'Maldives', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q?q', 'jlrm%LL7WJ', 'Mali', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q?q', '/_MpXT|', 'Mali', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('st', 'jlrm%LL7WJ', 'Marshallinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('st', '/_MpXT|', 'Marshall Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rV', 'jlrm%LL7WJ', 'Martinique', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rV', '/_MpXT|', 'Martinique', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('p,Ps', 'jlrm%LL7WJ', 'Mauretanien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('p,Ps', '/_MpXT|', 'Mauritania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rƈǄ	L', 'jlrm%LL7WJ', 'Mauritius', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rƈǄ	L', '/_MpXT|', 'Mauritius', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('s<@3#$h', 'jlrm%LL7WJ', 'Mayotte', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('s<@3#$h', '/_MpXT|', 'Mayotte', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\rqj)\0', 'jlrm%LL7WJ', 'Mexiko', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\rqj)\0', '/_MpXT|', 'Mexico', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q9u', 'jlrm%LL7WJ', 'Mikronesien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q9u', '/_MpXT|', 'Micronesia (Federated States of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('"s~', 'jlrm%LL7WJ', 'Moldawie', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('"s~', '/_MpXT|', 'Moldova (Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('0q[hNx)', 'jlrm%LL7WJ', 'Monaco', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('0q[hNx)', '/_MpXT|', 'Monaco', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('9ruuI#,', 'jlrm%LL7WJ', 'Mongolei', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('9ruuI#,', '/_MpXT|', 'Mongolia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Br"-', 'jlrm%LL7WJ', 'Montenegro', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Br"-', '/_MpXT|', 'Montenegro', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Lp["D', 'jlrm%LL7WJ', 'Montserrat', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Lp["D', '/_MpXT|', 'Montserrat', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Usٸe5R"', 'jlrm%LL7WJ', 'Marokko', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Usٸe5R"', '/_MpXT|', 'Morocco', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^psEk', 'jlrm%LL7WJ', 'Mosambik', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('^psEk', '/_MpXT|', 'Mozambique', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('gsE(D', 'jlrm%LL7WJ', 'Myanmar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('gsE(D', '/_MpXT|', 'Myanmar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('xru~~', 'jlrm%LL7WJ', 'Nauru', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('xru~~', '/_MpXT|', 'Nauru', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('͎qRaTa', 'jlrm%LL7WJ', 'Népal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('͎qRaTa', '/_MpXT|', 'Nepal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ͥrfp', 'jlrm%LL7WJ', 'Neukaledonien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ͥrfp', '/_MpXT|', 'New Caledonia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ͽr～\r', 'jlrm%LL7WJ', 'Neuseeland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ͽr～\r', '/_MpXT|', 'New Zealand', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('p7?%', 'jlrm%LL7WJ', 'Nicaragua', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('p7?%', '/_MpXT|', 'Nicaragua', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pۤ2-', 'jlrm%LL7WJ', 'Niger', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pۤ2-', '/_MpXT|', 'Niger', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pnn', 'jlrm%LL7WJ', 'Nigeria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pnn', '/_MpXT|', 'Nigeria', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('srYh', 'jlrm%LL7WJ', 'Niue', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('srYh', '/_MpXT|', 'Niue', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('*p\Z-', 'jlrm%LL7WJ', 'Norfolkinsel', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('*p\Z-', '/_MpXT|', 'Norfolk Island', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('<rg:fàCȾ', 'jlrm%LL7WJ', 'Nordkorea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL);
INSERT INTO `country_translation` VALUES
('<rg:fàCȾ', '/_MpXT|', 'Korea (Democratic People''s Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zpa\n ', 'jlrm%LL7WJ', 'Nördliche Marianen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Zpa\n ', '/_MpXT|', 'Northern Mariana Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ir׾c%', 'jlrm%LL7WJ', 'Oman', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ir׾c%', '/_MpXT|', 'Oman', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sspIÎ', 'jlrm%LL7WJ', 'Pakistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sspIÎ', '/_MpXT|', 'Pakistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('|s ', 'jlrm%LL7WJ', 'Palau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('|s ', '/_MpXT|', 'Palau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('΅s|S[', 'jlrm%LL7WJ', 'Palästina', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('΅s|S[', '/_MpXT|', 'Palestine, State of', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Ύpk8>^', 'jlrm%LL7WJ', 'Panama', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Ύpk8>^', '/_MpXT|', 'Panama', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Ηp''', 'jlrm%LL7WJ', 'Papua-Neuguinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Ηp''', '/_MpXT|', 'Papua New Guinea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ΠpmxK7', 'jlrm%LL7WJ', 'Paraguay', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ΠpmxK7', '/_MpXT|', 'Paraguay', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('άr/ѯ8b', 'jlrm%LL7WJ', 'Peru', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('άr/ѯ8b', '/_MpXT|', 'Peru', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('εqፕ108T', 'jlrm%LL7WJ', 'Philippinen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('εqፕ108T', '/_MpXT|', 'Philippines', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('νr#;M''', 'jlrm%LL7WJ', 'Pitcairn', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('νr#;M''', '/_MpXT|', 'Pitcairn', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rA\0', 'jlrm%LL7WJ', 'Puerto Rico', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('rA\0', '/_MpXT|', 'Puerto Rico', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r9?LA', 'jlrm%LL7WJ', 'Katar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r9?LA', '/_MpXT|', 'Qatar', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r*`C', 'jlrm%LL7WJ', 'Republik Kosovo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r*`C', '/_MpXT|', 'Republic of Kosovo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q20j0', 'jlrm%LL7WJ', 'Réunion', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q20j0', '/_MpXT|', 'Réunion', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sJ\n', 'jlrm%LL7WJ', 'Russland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sJ\n', '/_MpXT|', 'Russian Federation', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q\r֛^KQD', 'jlrm%LL7WJ', 'Ruanda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q\r֛^KQD', '/_MpXT|', 'Rwanda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qg4@W', 'jlrm%LL7WJ', 'Saint-Barthélemy', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qg4@W', '/_MpXT|', 'Saint Barthélemy', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q  \n', 'jlrm%LL7WJ', 'Sankt Helena', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q  \n', '/_MpXT|', 'Saint Helena, Ascension and Tristan da Cunha', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pmE0f?', 'jlrm%LL7WJ', 'St. Kitts und Nevis', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pmE0f?', '/_MpXT|', 'Saint Kitts and Nevis', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sKYi@', 'jlrm%LL7WJ', 'Saint Lucia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sKYi@', '/_MpXT|', 'Saint Lucia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('$r෵Mu', 'jlrm%LL7WJ', 'Saint Martin', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('$r෵Mu', '/_MpXT|', 'Saint Martin (French part)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('.q9oBN', 'jlrm%LL7WJ', 'Saint-Pierre und Miquelon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('.q9oBN', '/_MpXT|', 'Saint Pierre and Miquelon', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('8q\\\rz', 'jlrm%LL7WJ', 'Saint Vincent und die Grenadinen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('8q\\\rz', '/_MpXT|', 'Saint Vincent and the Grenadines', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('As򫔩(s', 'jlrm%LL7WJ', 'Samoa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('As򫔩(s', '/_MpXT|', 'Samoa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Jrp', 'jlrm%LL7WJ', 'San Marino', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Jrp', '/_MpXT|', 'San Marino', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Sq:zYV', 'jlrm%LL7WJ', 'São Tomé und Príncipe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Sq:zYV', '/_MpXT|', 'Sao Tome and Principe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\pĲ', 'jlrm%LL7WJ', 'Saudi-Arabien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\\pĲ', '/_MpXT|', 'Saudi Arabia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('esZܔj\0', 'jlrm%LL7WJ', 'Senegal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('esZܔj\0', '/_MpXT|', 'Senegal', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('nson<b', 'jlrm%LL7WJ', 'Serbien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('nson<b', '/_MpXT|', 'Serbia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ys˷.Q%', 'jlrm%LL7WJ', 'Seychellen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ys˷.Q%', '/_MpXT|', 'Seychelles', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ςp]_%', 'jlrm%LL7WJ', 'Sierra Leone', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ςp]_%', '/_MpXT|', 'Sierra Leone', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ϋr	$bD$', 'jlrm%LL7WJ', 'Singapur', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ϋr	$bD$', '/_MpXT|', 'Singapore', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ϔqŒlc', 'jlrm%LL7WJ', 'Sint Maarten (niederl. Teil)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ϔqŒlc', '/_MpXT|', 'Sint Maarten (Dutch part)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ϝsBhb\nx', 'jlrm%LL7WJ', 'Salomonen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ϝsBhb\nx', '/_MpXT|', 'Solomon Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ϦqiQ)', 'jlrm%LL7WJ', 'Somalia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ϦqiQ)', '/_MpXT|', 'Somalia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ϯq', 'jlrm%LL7WJ', 'Republik Südafrika', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ϯq', '/_MpXT|', 'South Africa', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ϸsknkE', 'jlrm%LL7WJ', 'Südgeorgien und die Südlichen Sandwichinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ϸsknkE', '/_MpXT|', 'South Georgia and the South Sandwich Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('s3C5', 'jlrm%LL7WJ', 'Südkorea', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('s3C5', '/_MpXT|', 'Korea (Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sŐ', 'jlrm%LL7WJ', 'Südsudan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sŐ', '/_MpXT|', 'South Sudan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pO~', 'jlrm%LL7WJ', 'Sri Lanka', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pO~', '/_MpXT|', 'Sri Lanka', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qwCY', 'jlrm%LL7WJ', 'Sudan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('qwCY', '/_MpXT|', 'Sudan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pe5ig-', 'jlrm%LL7WJ', 'Suriname', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pe5ig-', '/_MpXT|', 'Suriname', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pi<', 'jlrm%LL7WJ', 'Svalbard und Jan Mayen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pi<', '/_MpXT|', 'Svalbard and Jan Mayen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pwџ''', 'jlrm%LL7WJ', 'Swasiland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('pwџ''', '/_MpXT|', 'Swaziland', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\rri3c', 'jlrm%LL7WJ', 'Syrien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('\rri3c', '/_MpXT|', 'Syrian Arab Republic', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('p/)5C'',]P', 'jlrm%LL7WJ', 'Taiwan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('p/)5C'',]P', '/_MpXT|', 'Taiwan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sz#ֲzF', 'jlrm%LL7WJ', 'Tadschikistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sz#ֲzF', '/_MpXT|', 'Tajikistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('(pC''', 'jlrm%LL7WJ', 'Tansania', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('(pC''', '/_MpXT|', 'Tanzania, United Republic of', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('1r䈡$@nG', 'jlrm%LL7WJ', 'Thailand', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('1r䈡$@nG', '/_MpXT|', 'Thailand', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('=ph%Qw', 'jlrm%LL7WJ', 'Timor-Leste', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('=ph%Qw', '/_MpXT|', 'Timor-Leste', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('FqxX ׂE', 'jlrm%LL7WJ', 'Togo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('FqxX ׂE', '/_MpXT|', 'Togo', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Opl8A', 'jlrm%LL7WJ', 'Tokelau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Opl8A', '/_MpXT|', 'Tokelau', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('XrÛ>S!', 'jlrm%LL7WJ', 'Tonga', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('XrÛ>S!', '/_MpXT|', 'Tonga', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('aq噃ak2D', 'jlrm%LL7WJ', 'Trinidad und Tobago', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('aq噃ak2D', '/_MpXT|', 'Trinidad and Tobago', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('kq', 'jlrm%LL7WJ', 'Tunesien', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('kq', '/_MpXT|', 'Tunisia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('tp&հGK)', 'jlrm%LL7WJ', 'Turkmenistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('tp&հGK)', '/_MpXT|', 'Turkmenistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('}q&cI݂', 'jlrm%LL7WJ', 'Turks- und Caicosinseln', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('}q&cI݂', '/_MpXT|', 'Turks and Caicos Islands', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Іpa]#HU', 'jlrm%LL7WJ', 'Tuvalu', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Іpa]#HU', '/_MpXT|', 'Tuvalu', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Џp[<', 'jlrm%LL7WJ', 'Uganda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Џp[<', '/_MpXT|', 'Uganda', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Йr;Z,./', 'jlrm%LL7WJ', 'Ukraine', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Йr;Z,./', '/_MpXT|', 'Ukraine', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Фpgg8Nq', 'jlrm%LL7WJ', 'Uruguay', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('Фpgg8Nq', '/_MpXT|', 'Uruguay', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ЭqL#@', 'jlrm%LL7WJ', 'Usbekistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('ЭqL#@', '/_MpXT|', 'Uzbekistan', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('жp=', 'jlrm%LL7WJ', 'Vanuatu', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('жp=', '/_MpXT|', 'Vanuatu', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('пr~{V	]Gc_', 'jlrm%LL7WJ', 'Venezuela', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('пr~{V	]Gc_', '/_MpXT|', 'Venezuela (Bolivarian Republic of)', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('s2pkgk4', 'jlrm%LL7WJ', 'Vietnam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('s2pkgk4', '/_MpXT|', 'Viet Nam', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('s*l~', 'jlrm%LL7WJ', 'Wallis und Futuna', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('s*l~', '/_MpXT|', 'Wallis and Futuna', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r⻞H(', 'jlrm%LL7WJ', 'Westsahara', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r⻞H(', '/_MpXT|', 'Western Sahara', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r;o\0\r', 'jlrm%LL7WJ', 'Jemen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('r;o\0\r', '/_MpXT|', 'Yemen', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sc\rG*', 'jlrm%LL7WJ', 'Sambia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('sc\rG*', '/_MpXT|', 'Zambia', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q\nm', 'jlrm%LL7WJ', 'Simbabwe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL),
('q\nm', '/_MpXT|', 'Zimbabwe', '[["address/company", "symbol/dash", "address/department"], ["address/first_name", "address/last_name"], ["address/street"], ["address/zipcode", "address/city"], ["address/country"]]', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `currency`
--

CREATE TABLE `currency` (
  `id` binary(16) NOT NULL,
  `iso_code` char(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `factor` double NOT NULL,
  `symbol` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` int NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `item_rounding` json DEFAULT NULL,
  `total_rounding` json DEFAULT NULL,
  `tax_free_from` double DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.currency.iso_code` (`iso_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `currency`
--

INSERT INTO `currency` VALUES
('UKG͂', 'USD', 1, '$', 1, '[[regtime_]]', NULL, '{"decimals": "2", "interval": 0.01, "roundForNet": true}', '{"decimals": "2", "interval": 0.01, "roundForNet": true}', 0);

-- --------------------------------------------------------

--
-- Table structure for table `currency_country_rounding`
--

CREATE TABLE `currency_country_rounding` (
  `id` binary(16) NOT NULL,
  `currency_id` binary(16) NOT NULL,
  `country_id` binary(16) NOT NULL,
  `item_rounding` json NOT NULL,
  `total_rounding` json NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `currency_id` (`currency_id`),
  KEY `country_id` (`country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `currency_translation`
--

CREATE TABLE `currency_translation` (
  `currency_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `short_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`currency_id`,`language_id`),
  KEY `fk.currency_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `currency_translation`
--

INSERT INTO `currency_translation` VALUES
('UKG͂', 'jlrm%LL7WJ', 'USD', 'US-Dollar', NULL, '[[regtime_]]', NULL),
('UKG͂', '/_MpXT|', 'USD', 'US-Dollar', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `customer`
--

CREATE TABLE `customer` (
  `id` binary(16) NOT NULL,
  `auto_increment` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_group_id` binary(16) NOT NULL,
  `requested_customer_group_id` binary(16) DEFAULT NULL,
  `sales_channel_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `last_payment_method_id` binary(16) DEFAULT NULL,
  `default_billing_address_id` binary(16) NOT NULL,
  `default_shipping_address_id` binary(16) NOT NULL,
  `customer_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `salutation_id` binary(16) DEFAULT NULL,
  `first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `company` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `legacy_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `legacy_encoder` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vat_ids` json DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `double_opt_in_registration` tinyint(1) NOT NULL DEFAULT '0',
  `double_opt_in_email_sent_date` datetime(3) DEFAULT NULL,
  `double_opt_in_confirm_date` datetime(3) DEFAULT NULL,
  `hash` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `guest` tinyint(1) NOT NULL DEFAULT '0',
  `first_login` datetime(3) DEFAULT NULL,
  `last_login` datetime(3) DEFAULT NULL,
  `newsletter_sales_channel_ids` json DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `last_order_date` datetime(3) DEFAULT NULL,
  `order_count` int NOT NULL DEFAULT '0',
  `order_total_amount` double DEFAULT '0',
  `custom_fields` json DEFAULT NULL,
  `affiliate_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `campaign_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `remote_address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tag_ids` json DEFAULT NULL,
  `bound_sales_channel_id` binary(16) DEFAULT NULL,
  `created_by_id` binary(16) DEFAULT NULL,
  `updated_by_id` binary(16) DEFAULT NULL,
  `account_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'private',
  `review_count` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.auto_increment` (`auto_increment`),
  UNIQUE KEY `hash` (`hash`),
  KEY `idx.firstlogin` (`first_login`),
  KEY `idx.lastlogin` (`last_login`),
  KEY `idx.customer.default_billing_address_id` (`default_billing_address_id`),
  KEY `idx.customer.default_shipping_address_id` (`default_shipping_address_id`),
  KEY `fk.customer.customer_group_id` (`customer_group_id`),
  KEY `fk.customer.last_payment_method_id` (`last_payment_method_id`),
  KEY `fk.customer.sales_channel_id` (`sales_channel_id`),
  KEY `fk.customer.requested_customer_group_id` (`requested_customer_group_id`),
  KEY `fk.customer.bound_sales_channel_id` (`bound_sales_channel_id`),
  KEY `idx.email` (`email`),
  KEY `fk.customer.salutation_id` (`salutation_id`),
  KEY `fk.customer.created_by_id` (`created_by_id`),
  KEY `fk.customer.updated_by_id` (`updated_by_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `customer_address`
--

CREATE TABLE `customer_address` (
  `id` binary(16) NOT NULL,
  `customer_id` binary(16) NOT NULL,
  `country_id` binary(16) NOT NULL,
  `country_state_id` binary(16) DEFAULT NULL,
  `company` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `department` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `salutation_id` binary(16) DEFAULT NULL,
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `street` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zipcode` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(70) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone_number` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_address_line1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_address_line2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.customer_address.country_id` (`country_id`),
  KEY `fk.customer_address.country_state_id` (`country_state_id`),
  KEY `fk.customer_address.customer_id` (`customer_id`),
  KEY `fk.customer_address.salutation_id` (`salutation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_group`
--

CREATE TABLE `customer_group` (
  `id` binary(16) NOT NULL,
  `display_gross` tinyint(1) NOT NULL DEFAULT '1',
  `registration_active` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `customer_group`
--

INSERT INTO `customer_group` VALUES
('ϽPӍAحOȽ', 1, 0, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `customer_group_registration_sales_channels`
--

CREATE TABLE `customer_group_registration_sales_channels` (
  `customer_group_id` binary(16) NOT NULL,
  `sales_channel_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  PRIMARY KEY (`customer_group_id`,`sales_channel_id`),
  KEY `fk.customer_group_registration_sales_channels.customer_group_id` (`customer_group_id`),
  KEY `fk.customer_group_registration_sales_channels.sales_channel_id` (`sales_channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_group_translation`
--

CREATE TABLE `customer_group_translation` (
  `customer_group_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `registration_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `registration_introduction` longtext COLLATE utf8mb4_unicode_ci,
  `registration_only_company_registration` tinyint(1) DEFAULT NULL,
  `registration_seo_meta_description` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`customer_group_id`,`language_id`),
  KEY `fk.customer_group_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `customer_group_translation`
--

INSERT INTO `customer_group_translation` VALUES
('ϽPӍAحOȽ', 'jlrm%LL7WJ', 'Standard-Kundengruppe', NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL),
('ϽPӍAحOȽ', '/_MpXT|', 'Standard customer group', NULL, NULL, NULL, NULL, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `customer_recovery`
--

CREATE TABLE `customer_recovery` (
  `id` binary(16) NOT NULL,
  `customer_id` binary(16) NOT NULL,
  `hash` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.customer_recovery.customer_id` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_tag`
--

CREATE TABLE `customer_tag` (
  `customer_id` binary(16) NOT NULL,
  `tag_id` binary(16) NOT NULL,
  PRIMARY KEY (`customer_id`,`tag_id`),
  KEY `fk.customer_tag.tag_id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_wishlist`
--

CREATE TABLE `customer_wishlist` (
  `id` binary(16) NOT NULL,
  `customer_id` binary(16) NOT NULL,
  `sales_channel_id` binary(16) NOT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.customer_wishlist` (`sales_channel_id`,`customer_id`),
  KEY `fk.customer_wishlist.sales_channel_id` (`sales_channel_id`),
  KEY `fk.customer_wishlist.customer_id` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `customer_wishlist_product`
--

CREATE TABLE `customer_wishlist_product` (
  `id` binary(16) NOT NULL,
  `customer_wishlist_id` binary(16) NOT NULL,
  `product_id` binary(16) NOT NULL,
  `product_version_id` binary(16) NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.customer_wishlist.sales_channel_id__customer_id` (`customer_wishlist_id`,`product_id`),
  KEY `fk.customer_wishlist_product.product_id` (`product_id`,`product_version_id`),
  KEY `fk.customer_wishlist_product.customer_wishlist_id` (`customer_wishlist_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_entity`
--

CREATE TABLE `custom_entity` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fields` json NOT NULL,
  `app_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `flags` json DEFAULT NULL,
  `plugin_id` binary(16) DEFAULT NULL,
  `custom_fields_aware` tinyint(1) NOT NULL DEFAULT '0',
  `label_property` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `app_id` (`app_id`),
  KEY `fk.custom_entity.plugin_id` (`plugin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_field`
--

CREATE TABLE `custom_field` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `config` json DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `set_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `allow_customer_write` tinyint NOT NULL DEFAULT '0',
  `allow_cart_expose` tinyint(1) NOT NULL DEFAULT '0',
  `store_api_aware` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.custom_field.name` (`name`),
  KEY `fk.custom_field.set_id` (`set_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_field_set`
--

CREATE TABLE `custom_field_set` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `config` json DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `app_id` binary(16) DEFAULT NULL,
  `position` int NOT NULL DEFAULT '1',
  `global` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.custom_field_set.app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_field_set_relation`
--

CREATE TABLE `custom_field_set_relation` (
  `id` binary(16) NOT NULL,
  `set_id` binary(16) NOT NULL,
  `entity_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.custom_field_set_relation.entity_name` (`set_id`,`entity_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `delivery_time`
--

CREATE TABLE `delivery_time` (
  `id` binary(16) NOT NULL,
  `min` int NOT NULL,
  `max` int NOT NULL,
  `unit` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `delivery_time`
--

INSERT INTO `delivery_time` VALUES
('vGp;L', 1, 3, 'day', '[[regtime_]]', NULL),
('vGpٝ', 2, 5, 'day', '[[regtime_]]', NULL),
('vGp!', 1, 2, 'week', '[[regtime_]]', NULL),
('vGp', 3, 4, 'week', '[[regtime_]]', NULL),
('T,qgΥ', 0, 0, 'hour', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `delivery_time_translation`
--

CREATE TABLE `delivery_time_translation` (
  `delivery_time_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`delivery_time_id`,`language_id`),
  KEY `fk.delivery_time_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `delivery_time_translation`
--

INSERT INTO `delivery_time_translation` VALUES
('vGp;L', 'jlrm%LL7WJ', '1-3 Tage', NULL, '[[regtime_]]', NULL),
('vGp;L', '/_MpXT|', '1-3 days', NULL, '[[regtime_]]', NULL),
('vGpٝ', 'jlrm%LL7WJ', '2-5 Tage', NULL, '[[regtime_]]', NULL),
('vGpٝ', '/_MpXT|', '2-5 days', NULL, '[[regtime_]]', NULL),
('vGp!', 'jlrm%LL7WJ', '1-2 Wochen', NULL, '[[regtime_]]', NULL),
('vGp!', '/_MpXT|', '1-2 weeks', NULL, '[[regtime_]]', NULL),
('vGp', 'jlrm%LL7WJ', '3-4 Wochen', NULL, '[[regtime_]]', NULL),
('vGp', '/_MpXT|', '3-4 weeks', NULL, '[[regtime_]]', NULL),
('T,qgΥ', 'jlrm%LL7WJ', 'Sofort verfügbar', NULL, '[[regtime_]]', NULL),
('T,qgΥ', '/_MpXT|', 'Instant download', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `document`
--

CREATE TABLE `document` (
  `id` binary(16) NOT NULL,
  `document_type_id` binary(16) NOT NULL,
  `referenced_document_id` binary(16) DEFAULT NULL,
  `order_id` binary(16) NOT NULL,
  `order_version_id` binary(16) NOT NULL,
  `config` json DEFAULT NULL,
  `sent` tinyint(1) NOT NULL DEFAULT '0',
  `static` tinyint(1) NOT NULL DEFAULT '0',
  `deep_link_code` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `document_media_file_id` binary(16) DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `document_number` varchar(255) COLLATE utf8mb4_unicode_ci GENERATED ALWAYS AS (json_unquote(json_extract(`config`,_utf8mb4'$.documentNumber'))) STORED,
  `document_a11y_media_file_id` binary(16) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.deep_link_code` (`deep_link_code`),
  KEY `fk.document.document_type_id` (`document_type_id`),
  KEY `fk.document.referenced_document_id` (`referenced_document_id`),
  KEY `fk.document.order_id` (`order_id`,`order_version_id`),
  KEY `fk.document.document_media_file_id` (`document_media_file_id`),
  KEY `idx.document.document_number` (`document_number`),
  KEY `fk.document.document_a11y_media_file_id` (`document_a11y_media_file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `document_base_config`
--

CREATE TABLE `document_base_config` (
  `id` binary(16) NOT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `filename_prefix` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `filename_suffix` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `document_number` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `global` tinyint(1) DEFAULT '0',
  `document_type_id` binary(16) NOT NULL,
  `logo_id` binary(16) DEFAULT NULL,
  `config` json DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.document_base_config.type_id` (`document_type_id`),
  KEY `fk.document_base_config.logo_id` (`logo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `document_base_config`
--

INSERT INTO `document_base_config` VALUES
('xpA^X(', 'cancellation_invoice', 'cancellation_invoice_', '', '', 1, 'xq9	?S', NULL, '{"vatId": "", "bankBic": "", "bankIban": "", "bankName": "", "pageSize": "a4", "fileTypes": ["html", "pdf"], "taxNumber": "", "taxOffice": "", "companyName": "Example Company", "itemsPerPage": 10, "displayFooter": true, "displayHeader": true, "displayPrices": true, "companyAddress": "", "pageOrientation": "portrait", "displayLineItems": true, "displayPageCount": true, "executiveDirector": "", "placeOfFulfillment": "", "placeOfJurisdiction": "", "displayReturnAddress": true, "displayCompanyAddress": true, "diplayLineItemPosition": true, "referencedDocumentType": "invoice", "displayAdditionalNoteDelivery": false}', NULL, '[[regtime_]]', NULL),
('xpA^Xf', 'invoice', 'invoice_', '', '', 1, 'jq~JJW', NULL, '{"vatId": "", "bankBic": "", "bankIban": "", "bankName": "", "pageSize": "a4", "fileTypes": ["html", "pdf"], "taxNumber": "", "taxOffice": "", "companyName": "Example Company", "itemsPerPage": 10, "displayFooter": true, "displayHeader": true, "displayPrices": true, "companyAddress": "", "pageOrientation": "portrait", "displayLineItems": true, "displayPageCount": true, "deliveryCountries": ["019b07996aff73e68f0caf0f99fda9d3", "019b07996bd3717a93aeddb303159595", "019b07996bdc733e883889d6fb9357a6", "019b0799718f704982bc1d7745fde463", "019b079971a27174bf7727b84c9ba3da", "019b079971be721c84981961e384ef68", "019b079971d2708eb827de1624312cdc", "019b079971e57021b7ad90945a8adf3d", "019b079971ee706aafd9d2f2f9af78c5", "019b079972b372b581bc383a9f1a2cb7", "019b079972c671c28e1dc01c35bd922f", "019b0799744d700f9204c409a581c7e9", "019b079974567130b225e1e5c92efeed", "019b0799746970dabe7dfe40faa79480", "019b079974d173bcbcd177ec5c47cdcf", "019b0799754071ee86a6859ce1bbde42", "019b079975c3736fb7d078fb5d54e75b", "019b079975cc732c8ef5b0edb054d889", "019b079975d67218919c282c1e85a6c4", "019b079975e170d4836ff6077f7d0393", "019b0799c7d272179d4573fae8aceb4e", "019b0799c7dc729b8a229b5951bcf48a", "019b0799c7e57228aac96461037de07f", "019b0799c7ee7202a52ac1667147a9cd", "019b0799c7f87002ba9272e7ac88947a", "019b0799c80670e688c22a590a68d754", "019b0799c80f7132a52b3ff770723262", "019b0799c81873228562787e70db72a1"], "executiveDirector": "", "placeOfFulfillment": "", "placeOfJurisdiction": "", "displayReturnAddress": true, "displayCompanyAddress": true, "diplayLineItemPosition": true}', NULL, '[[regtime_]]', NULL),
('xpA^Y$', 'delivery_note', 'delivery_note_', '', '', 1, 'jq~J%>', NULL, '{"vatId": "", "bankBic": "", "bankIban": "", "bankName": "", "pageSize": "a4", "fileTypes": ["html", "pdf"], "taxNumber": "", "taxOffice": "", "companyName": "Example Company", "itemsPerPage": 10, "displayFooter": true, "displayHeader": true, "displayPrices": false, "companyAddress": "", "pageOrientation": "portrait", "displayLineItems": true, "displayPageCount": true, "executiveDirector": "", "placeOfFulfillment": "", "placeOfJurisdiction": "", "displayReturnAddress": true, "displayCompanyAddress": true, "diplayLineItemPosition": true}', NULL, '[[regtime_]]', NULL),
('xpA^ZY7', 'credit_note', 'credit_note_', '', '', 1, 'jq~Jo(', NULL, '{"vatId": "", "bankBic": "", "bankIban": "", "bankName": "", "pageSize": "a4", "fileTypes": ["html", "pdf"], "taxNumber": "", "taxOffice": "", "companyName": "Example Company", "itemsPerPage": 10, "displayFooter": true, "displayHeader": true, "displayPrices": true, "companyAddress": "", "pageOrientation": "portrait", "displayLineItems": true, "displayPageCount": true, "executiveDirector": "", "placeOfFulfillment": "", "placeOfJurisdiction": "", "displayReturnAddress": true, "displayCompanyAddress": true, "diplayLineItemPosition": true, "displayAdditionalNoteDelivery": false}', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `document_base_config_sales_channel`
--

CREATE TABLE `document_base_config_sales_channel` (
  `id` binary(16) NOT NULL,
  `document_base_config_id` binary(16) NOT NULL,
  `document_type_id` binary(16) NOT NULL,
  `sales_channel_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.document_base_configuration_id__sales_channel_id` (`document_type_id`,`sales_channel_id`),
  KEY `fk.document_base_config_sales_channel.document_base_config_id` (`document_base_config_id`),
  KEY `fk.document_base_config_sales_channel.sales_channel_id` (`sales_channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `document_base_config_sales_channel`
--

INSERT INTO `document_base_config_sales_channel` VALUES
('xsL\\', 'xpA^X(', 'xq9	?S', NULL, '[[regtime_]]', NULL),
('xq^lFj#', 'xpA^Xf', 'jq~JJW', NULL, '[[regtime_]]', NULL),
('xqIR2\n@', 'xpA^Y$', 'jq~J%>', NULL, '[[regtime_]]', NULL),
('xr0i', 'xpA^ZY7', 'jq~Jo(', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `document_type`
--

CREATE TABLE `document_type` (
  `id` binary(16) NOT NULL,
  `technical_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.document_type.technical_name` (`technical_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `document_type`
--

INSERT INTO `document_type` VALUES
('jq~JJW', 'invoice', '[[regtime_]]', NULL),
('jq~J%>', 'delivery_note', '[[regtime_]]', NULL),
('jq~Jo(', 'credit_note', '[[regtime_]]', NULL),
('xq9	?S', 'storno', '[[regtime_]]', NULL),
('sE,U', 'zugferd_invoice', '[[regtime_]]', NULL),
('sE,o', 'zugferd_embedded_invoice', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `document_type_translation`
--

CREATE TABLE `document_type_translation` (
  `document_type_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`document_type_id`,`language_id`),
  KEY `fk.document_type_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `document_type_translation`
--

INSERT INTO `document_type_translation` VALUES
('jq~JJW', 'jlrm%LL7WJ', 'Rechnung', NULL, '[[regtime_]]', NULL),
('jq~JJW', '/_MpXT|', 'Invoice', NULL, '[[regtime_]]', NULL),
('jq~J%>', 'jlrm%LL7WJ', 'Lieferschein', NULL, '[[regtime_]]', NULL),
('jq~J%>', '/_MpXT|', 'Delivery note', NULL, '[[regtime_]]', NULL),
('jq~Jo(', 'jlrm%LL7WJ', 'Gutschrift', NULL, '[[regtime_]]', NULL),
('jq~Jo(', '/_MpXT|', 'Credit note', NULL, '[[regtime_]]', NULL),
('xq9	?S', 'jlrm%LL7WJ', 'Stornorechnung', NULL, '[[regtime_]]', NULL),
('xq9	?S', '/_MpXT|', 'Cancellation invoice', NULL, '[[regtime_]]', NULL),
('sE,U', 'jlrm%LL7WJ', 'Rechnung: ZUGFeRD E-Rechnung', NULL, '[[regtime_]]', NULL),
('sE,U', '/_MpXT|', 'Invoice: ZUGFeRD E-invoice', NULL, '[[regtime_]]', NULL),
('sE,o', 'jlrm%LL7WJ', 'Rechnung: PDF mit eingebetteter ZUGFeRD E-Rechnung', NULL, '[[regtime_]]', NULL),
('sE,o', '/_MpXT|', 'Invoice: PDF with embedded ZUGFeRD E-invoice', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `flow`
--

CREATE TABLE `flow` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `event_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `priority` int NOT NULL DEFAULT '1',
  `payload` longblob,
  `invalid` tinyint(1) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `app_flow_event_id` binary(16) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.flow.event_name` (`event_name`,`priority`),
  KEY `fk.flow.app_flow_event_id` (`app_flow_event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `flow`
--

INSERT INTO `flow` VALUES
('7rՁi^`Y', 'Order placed', NULL, 'checkout.order.placed', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7rՁi^`\n', 'Customer account registered', NULL, 'checkout.customer.register', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7rՁi^`\Z', 'Newsletter sign-up registered', NULL, 'newsletter.register', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7rՁi^`U"b', 'Newsletter sign-up confirmed', NULL, 'newsletter.confirm', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7rՁi^`Pf', 'User recovery request sent', NULL, 'user.recovery.request', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7rՁi^`G', 'Contact form sent', NULL, 'contact_form.send', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7rՁi^`#', 'Customer requests new password', NULL, 'customer.recovery.request', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7rՁi^`S', 'Customer account registered with double opt-in', NULL, 'checkout.customer.double_opt_in_registration', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7rՁi^`s', 'Guest account registered with double opt-in', NULL, 'checkout.customer.double_opt_in_guest_order', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7rՁi^`F', 'Customer group registration request accepted', NULL, 'customer.group.registration.accepted', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7rՁi^`g6', 'Customer group registration request declined', NULL, 'customer.group.registration.declined', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7rՁi^`(@', 'Shipment enters status partially returned', NULL, 'state_enter.order_delivery.state.returned_partially', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7rՁi^`', 'Shipment enters status partially shipped', NULL, 'state_enter.order_delivery.state.shipped_partially', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7rՁi^`)', 'Shipment enters status returned', NULL, 'state_enter.order_delivery.state.returned', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7rՁi^`"_T', 'Shipment enters status shipped', NULL, 'state_enter.order_delivery.state.shipped', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7rՁi^` ', 'Shipment enters status cancelled', NULL, 'state_enter.order_delivery.state.cancelled', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7qɳݶ_0', 'Payment enters status reminder sent', NULL, 'state_enter.order_transaction.state.reminded', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7qɳݷ;+', 'Payment enters status partially refunded', NULL, 'state_enter.order_transaction.state.refunded_partially', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7qɳݸA', 'Payment enters status cancelled', NULL, 'state_enter.order_transaction.state.cancelled', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7qɳݹ', 'Payment enters status paid', NULL, 'state_enter.order_transaction.state.paid', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7qɳݺZ', 'Payment enters status refunded', NULL, 'state_enter.order_transaction.state.refunded', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7qɳݼ/', 'Payment enters status partially paid', NULL, 'state_enter.order_transaction.state.paid_partially', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7qɳݼ', 'Payment enters status open', NULL, 'state_enter.order_transaction.state.open', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7qɳݽr1', 'Order enters status in progress', NULL, 'state_enter.order.state.in_progress', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7qɳݿJm', 'Order enters status cancelled', NULL, 'state_enter.order.state.cancelled', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('7qɳ ', 'Order enters status completed', NULL, 'state_enter.order.state.completed', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('Xs]+ڋ', 'Deliver ordered product downloads', NULL, 'state_enter.order_transaction.state.paid', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('qq7kc+', 'Review form sent', NULL, 'review_form.send', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('r32Dp', 'Order enters status authorized', NULL, 'state_enter.order_transaction.state.authorized', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('st4lls', 'Order enters status chargeback', NULL, 'state_enter.order_transaction.state.chargeback', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL),
('qg/@>', 'Order enters status unconfirmed', NULL, 'state_enter.order_transaction.state.unconfirmed', 1, NULL, 0, 1, NULL, '[[regtime_]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `flow_sequence`
--

CREATE TABLE `flow_sequence` (
  `id` binary(16) NOT NULL,
  `flow_id` binary(16) NOT NULL,
  `app_flow_action_id` binary(16) DEFAULT NULL,
  `parent_id` binary(16) DEFAULT NULL,
  `rule_id` binary(16) DEFAULT NULL,
  `action_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `config` json DEFAULT NULL,
  `position` int NOT NULL DEFAULT '1',
  `display_group` int NOT NULL DEFAULT '1',
  `true_case` tinyint(1) NOT NULL DEFAULT '0',
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.flow_sequence.flow_id` (`flow_id`),
  KEY `fk.flow_sequence.rule_id` (`rule_id`),
  KEY `fk.flow_sequence.parent_id` (`parent_id`),
  KEY `fk.flow_sequence.app_flow_action_id` (`app_flow_action_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `flow_sequence`
--

INSERT INTO `flow_sequence` VALUES
('7rՁi^`H,Q', '7rՁi^`Y', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b07997a3c72c5a8483539503befd6", "mailTemplateTypeId": "019b0799e9a4709c80dfc90d9b463805"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7rՁi^`i	', '7rՁi^`\n', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b07997a5073ada388b7821f7a0ddb", "mailTemplateTypeId": "019b0799e9ad72728440dff79e241525"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7rՁi^`^', '7rՁi^`\Z', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799788b70768c5778e7ede454d1", "mailTemplateTypeId": "019b0799e9b870919f5d27eba8619f3a"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7rՁi^`fs', '7rՁi^`U"b', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799788b70768c5778e7ee27ce50", "mailTemplateTypeId": "019b0799e9c371cdb2d29cb494a3042b"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7rՁi^`	', '7rՁi^`Pf', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b079984097275826d97ab8b0b61c6", "mailTemplateTypeId": "019b0799e9cd7115a5050d1d05ca9b50"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7rՁi^`)', '7rՁi^`G', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b079997c2737cbd004fb035f81c3c", "mailTemplateTypeId": "019b0799e9d37358b4847b6dda81fc88"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7rՁi^`=u', '7rՁi^`#', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b07999ca5727b8256ea32c1bd147a", "mailTemplateTypeId": "019b0799e9d870a49d9ba9434fd6c6d6"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7rՁi^`', '7rՁi^`S', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a3ed70c5b5bc8d7d0df4367a", "mailTemplateTypeId": "019b0799e9de730483db40ce16345784"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7rՁi^`h', '7rՁi^`s', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a48a72eaa56780e3f85229cc", "mailTemplateTypeId": "019b0799e9e272779803e95a99f43a57"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7rՁi^`kз', '7rՁi^`F', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799e36373d0876e02880a7f5856", "mailTemplateTypeId": "019b0799e9e571dc8f8d5b6f801834ea"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7rՁi^`8', '7rՁi^`g6', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799e37f720ca2d50f98d49b0593", "mailTemplateTypeId": "019b0799e9e872848c482db510bedd63"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7rՁi^`j', '7rՁi^`(@', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a065719d8f8348093cb1bc91", "mailTemplateTypeId": "019b0799e9ec710bab912cd9bc9fa654"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7rՁi^`މ', '7rՁi^`', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a052729a8f410fcc757035ff", "mailTemplateTypeId": "019b0799e9ef722dad1439ff8381bb15"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7rՁi^`*', '7rՁi^`)', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a07672ac9416c1a18175b6f1", "mailTemplateTypeId": "019b0799e9f273efa0de0d2836ed45d0"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7rՁi^`p&', '7rՁi^`"_T', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a09372a5a71c05454965f48c", "mailTemplateTypeId": "019b0799e9f5730bb831e34b4a346c07"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7rՁi^`R|', '7rՁi^` ', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a08673afb60a4919f4259d8d", "mailTemplateTypeId": "019b0799e9f872de9b5986b6e6c48353"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7qɳݶk', '7qɳݶ_0', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a10271c8bd69d2a2eb15abb9", "mailTemplateTypeId": "019b0799e9fc72298390f3e9ed271f6d"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7qɳݷ', '7qɳݷ;+', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a0f571b28973b06c9fc0280a", "mailTemplateTypeId": "019b0799ea00736f90f47125d30740c8"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7qɳݸ', '7qɳݸA', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a12d72299fb3231b4a3e1a44", "mailTemplateTypeId": "019b0799ea05710e9ecf93faf314f64a"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7qɳݹ', '7qɳݹ', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a11c70439871c0dc3698db9e", "mailTemplateTypeId": "019b0799ea0872e4b17f5c57bd1c7b89"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7qɳݻt[M', '7qɳݺZ', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a139722d94a15b0103317b06", "mailTemplateTypeId": "019b0799ea0b72b690b8d99ee49a9426"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7qɳݼR', '7qɳݼ/', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a14a710090a111afe52ff72a", "mailTemplateTypeId": "019b0799ea0f71f8a11e9a2e3d92daf4"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7qɳݽ!ׁ', '7qɳݼ', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a10e73d588325ed0eb182443", "mailTemplateTypeId": "019b0799ea12737e98a6972443619b81"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7qɳݾh#', '7qɳݽr1', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a0c570cfaa469e5595bed5b2", "mailTemplateTypeId": "019b0799ea1570ca8d6b4a429c7a09c7"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7qɳݿ˞', '7qɳݿJm', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a0e2737ca6b9b9ed56613ab7", "mailTemplateTypeId": "019b0799ea1873bfbdebc6fe334d2c79"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('7qɳ', '7qɳ ', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a0d37303a0acd957b224d6f2", "mailTemplateTypeId": "019b0799ea1c703c855babe48878174b"}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('Xr\Z9UAW', 'Xs]+ڋ', NULL, NULL, 'Xqoeꌺ', NULL, '[]', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('Xpճ%', 'Xs]+ڋ', NULL, 'Xr\Z9UAW', NULL, 'action.grant.download.access', '{"value": true}', 1, 1, 1, NULL, '[[regtime_]]', NULL),
('Xqq!w8S', 'Xs]+ڋ', NULL, 'Xr\Z9UAW', NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b079a565b72a5b160b1c730170422", "documentTypeIds": []}', 2, 1, 1, NULL, '[[regtime_]]', NULL),
('qrqH', 'qq7kc+', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "admin"}, "mailTemplateId": "019b079a711e72c4b9280f0cc86fd2fb", "documentTypeIds": []}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('rGG\0K', 'r32Dp', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b079a9cfc7266bc0866b1343f9bca", "documentTypeIds": []}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('s-', 'st4lls', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b079a9d177260a0bdecb6dd05ae16", "documentTypeIds": []}', 1, 1, 0, NULL, '[[regtime_]]', NULL),
('qϛ7cO', 'qg/@>', NULL, NULL, NULL, 'action.mail.send', '{"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b079a9d3672bcbfd8d26dad2358a5", "documentTypeIds": []}', 1, 1, 0, NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `flow_template`
--

CREATE TABLE `flow_template` (
  `id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `config` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `flow_template`
--

INSERT INTO `flow_template` VALUES
('Xzq.ַħ', 'Contact form sent', '{"eventName": "contact_form.send", "sequences": [{"id": "019b079a587a71a8b6e32ed6b750f947", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b079997c2737cbd004fb035f81c3c", "mailTemplateTypeId": "019b079987e07115b62a30f8bc82fd89"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('Xzq.ָ*3', 'Newsletter sign-up registered', '{"eventName": "newsletter.register", "sequences": [{"id": "019b079a587a71a8b6e32ed6b8a8db61", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799788b70768c5778e7ee27ce50", "mailTemplateTypeId": "019b079977a17038aadd381999b812b2"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('Xzq.ֹ1', 'User recovery request sent', '{"eventName": "user.recovery.request", "sequences": [{"id": "019b079a587a71a8b6e32ed6b965e301", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b079984097275826d97ab8b0b61c6", "mailTemplateTypeId": "019b079983ff71a799bee99f7bf85a24"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('Xzq.ֹt]E', 'Guest account registered with double opt-in', '{"eventName": "checkout.customer.double_opt_in_guest_order", "sequences": [{"id": "019b079a587a71a8b6e32ed6b9eeab68", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a48a72eaa56780e3f85229cc", "mailTemplateTypeId": "019b0799a48a72eaa56780e3f90400e6"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('Xzq.ֺM.', 'Customer account registered with double opt-in', '{"eventName": "checkout.customer.double_opt_in_registration", "sequences": [{"id": "019b079a587a71a8b6e32ed6badc7e4e", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a3ed70c5b5bc8d7d0df4367a", "mailTemplateTypeId": "019b0799a3ed70c5b5bc8d7d0ea8d1c3"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('Xzq.ֺZ', 'Order placed', '{"eventName": "checkout.order.placed", "sequences": [{"id": "019b079a587a71a8b6e32ed6bb66c3ee", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b07997a3c72c5a8483539503befd6", "mailTemplateTypeId": "019b079977a17038aadd38199a461301"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('Xzq.ּP', 'Customer group registration request declined', '{"eventName": "customer.group.registration.declined", "sequences": [{"id": "019b079a587a71a8b6e32ed6bc8eade4", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799e37f720ca2d50f98d49b0593", "mailTemplateTypeId": "019b0799e376706ca0938befaac95341"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('Xzq.ּ)\r', 'Customer group registration request accepted', '{"eventName": "customer.group.registration.accepted", "sequences": [{"id": "019b079a587a71a8b6e32ed6bccfcb8b", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799e36373d0876e02880a7f5856", "mailTemplateTypeId": "019b0799e3577232b6f6aa953d9b5233"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('Xzq.ֽ', 'Newsletter sign-up confirmed', '{"eventName": "newsletter.confirm", "sequences": [{"id": "019b079a587a71a8b6e32ed6be1b88c5", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799788b70768c5778e7ee27ce50", "mailTemplateTypeId": "019b079977a17038aadd381999b812b2"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('Xzq.־!', 'Customer requests new password', '{"eventName": "customer.recovery.request", "sequences": [{"id": "019b079a587a71a8b6e32ed6bed32347", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b07999ca5727b8256ea32c1bd147a", "mailTemplateTypeId": "019b07999c9a71ba833f47d43cf0ac7e"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('Xzq.ֿ_', 'Customer account registered', '{"eventName": "checkout.customer.register", "sequences": [{"id": "019b079a587a71a8b6e32ed6bff47ad1", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b07997a5073ada388b7821f7a0ddb", "mailTemplateTypeId": "019b079977a17038aadd3819989dea34"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('Xzq.ֿ', 'Payment enters status partially paid', '{"eventName": "state_enter.order_transaction.state.paid_partially", "sequences": [{"id": "019b079a587a71a8b6e32ed6c04b5920", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a14a710090a111afe52ff72a", "mailTemplateTypeId": "019b079977a17038aadd38199f8ce117"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('X{p<V8!', 'Shipment enters status returned', '{"eventName": "state_enter.order_delivery.state.returned", "sequences": [{"id": "019b079a587b70fe9dfb3c5639d4b646", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a07672ac9416c1a18175b6f1", "mailTemplateTypeId": "019b079977a17038aadd38199d412678"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('X{p<V9~', 'Shipment enters status partially returned', '{"eventName": "state_enter.order_delivery.state.returned_partially", "sequences": [{"id": "019b079a587b70fe9dfb3c5639f1716e", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a065719d8f8348093cb1bc91", "mailTemplateTypeId": "019b079977a17038aadd38199cc582fe"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('X{p<V:l', 'Payment enters status refunded', '{"eventName": "state_enter.order_transaction.state.refunded", "sequences": [{"id": "019b079a587b70fe9dfb3c563aa3a86b", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a139722d94a15b0103317b06", "mailTemplateTypeId": "019b079977a17038aadd38199f88a469"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('X{p<V;y_', 'Payment enters status paid', '{"eventName": "state_enter.order_transaction.state.paid", "sequences": [{"id": "019b079a587b70fe9dfb3c563b7fa9be", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a11c70439871c0dc3698db9e", "mailTemplateTypeId": "019b079977a17038aadd38199f86089b"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('X{p<V;X', 'Order enters status in progress', '{"eventName": "state_enter.order.state.in_progress", "sequences": [{"id": "019b079a587b70fe9dfb3c563c958fcb", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a0c570cfaa469e5595bed5b2", "mailTemplateTypeId": "019b079977a17038aadd3819a1929313"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('X{p<V<e', 'Payment enters status partially refunded', '{"eventName": "state_enter.order_transaction.state.refunded_partially", "sequences": [{"id": "019b079a587b70fe9dfb3c563d26248f", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a0f571b28973b06c9fc0280a", "mailTemplateTypeId": "019b079977a17038aadd38199ed38c32"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('X{p<V=[P', 'Payment enters status open', '{"eventName": "state_enter.order_transaction.state.open", "sequences": [{"id": "019b079a587b70fe9dfb3c563d9ac5f6", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a10e73d588325ed0eb182443", "mailTemplateTypeId": "019b079977a17038aadd38199fffe30c"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('X{p<V>', 'Shipment enters status shipped', '{"eventName": "state_enter.order_delivery.state.shipped", "sequences": [{"id": "019b079a587b70fe9dfb3c563ec2964d", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a09372a5a71c05454965f48c", "mailTemplateTypeId": "019b079977a17038aadd38199dcfab20"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('X{p<V?b', 'Shipment enters status partially shipped', '{"eventName": "state_enter.order_delivery.state.shipped_partially", "sequences": [{"id": "019b079a587b70fe9dfb3c564051365d", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a052729a8f410fcc757035ff", "mailTemplateTypeId": "019b079977a17038aadd38199cddce91"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('X{p<V@kW', 'Shipment enters status cancelled', '{"eventName": "state_enter.order_delivery.state.cancelled", "sequences": [{"id": "019b079a587b70fe9dfb3c56413c4a5f", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a08673afb60a4919f4259d8d", "mailTemplateTypeId": "019b079977a17038aadd38199e7f3db0"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('X{p<VAkP\\', 'Payment enters status cancelled', '{"eventName": "state_enter.order_transaction.state.cancelled", "sequences": [{"id": "019b079a587b70fe9dfb3c564222a7ae", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a12d72299fb3231b4a3e1a44", "mailTemplateTypeId": "019b079977a17038aadd38199ee48411"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('X{p<VB.r', 'Order enters status cancelled', '{"eventName": "state_enter.order.state.cancelled", "sequences": [{"id": "019b079a587b70fe9dfb3c5643c09bd0", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a0e2737ca6b9b9ed56613ab7", "mailTemplateTypeId": "019b079977a17038aadd3819a2232765"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('X{p<VDG', 'Payment enters status reminder sent', '{"eventName": "state_enter.order_transaction.state.reminded", "sequences": [{"id": "019b079a587b70fe9dfb3c5644b00be9", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a10271c8bd69d2a2eb15abb9", "mailTemplateTypeId": "019b079977a17038aadd38199eaf0039"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('X{p<VE5', 'Order enters status completed', '{"eventName": "state_enter.order.state.completed", "sequences": [{"id": "019b079a587b70fe9dfb3c5645a58cf5", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b0799a0d37303a0acd957b224d6f2", "mailTemplateTypeId": "019b079977a17038aadd3819a2dbe47a"}, "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('XqՔ?', 'Deliver ordered product downloads', '{"eventName": "state_enter.order_transaction.state.paid", "sequences": [{"id": "019b079a970670c092c791c43846fb30", "config": [], "ruleId": "019b079a588c716fa3e7c065c1ea8cba", "parentId": null, "position": 1, "trueCase": 0, "actionName": null, "displayGroup": 1}, {"id": "019b079a970670c092c791c438840ec0", "config": {"value": true}, "ruleId": null, "parentId": "019b079a970670c092c791c43846fb30", "position": 1, "trueCase": 1, "actionName": "action.grant.download.access", "displayGroup": 1}, {"id": "019b079a970670c092c791c43884525a", "config": {"recipient": {"data": [], "type": "default"}, "mailTemplateId": "019b079a565b72a5b160b1c730170422", "documentTypeIds": [], "mailTemplateTypeId": "019b079a564e738a9a57152d74d15cba"}, "ruleId": null, "parentId": "019b079a970670c092c791c43846fb30", "position": 2, "trueCase": 1, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('sa3d', 'Order enters status authorized', '{"eventName": "state_enter.order_transaction.state.authorized", "sequences": [{"id": "019b079aa5ac7361ad9304ae326688f0", "config": "{\\"recipient\\": {\\"data\\": [], \\"type\\": \\"default\\"}, \\"mailTemplateId\\": \\"019b079a9cfc7266bc0866b1343f9bca\\", \\"documentTypeIds\\": []}", "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('sF', 'Order enters status chargeback', '{"eventName": "state_enter.order_transaction.state.chargeback", "sequences": [{"id": "019b079aa5bc730f91101feaec0d445c", "config": "{\\"recipient\\": {\\"data\\": [], \\"type\\": \\"default\\"}, \\"mailTemplateId\\": \\"019b079a9d177260a0bdecb6dd05ae16\\", \\"documentTypeIds\\": []}", "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL),
('soŔ&G', 'Order enters status unconfirmed', '{"eventName": "state_enter.order_transaction.state.unconfirmed", "sequences": [{"id": "019b079aa5c6736f8ec594268a815412", "config": "{\\"recipient\\": {\\"data\\": [], \\"type\\": \\"default\\"}, \\"mailTemplateId\\": \\"019b079a9d3672bcbfd8d26dad2358a5\\", \\"documentTypeIds\\": []}", "ruleId": null, "parentId": null, "position": 1, "trueCase": 0, "actionName": "action.mail.send", "displayGroup": 1}], "description": null, "customFields": null}', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `import_export_file`
--

CREATE TABLE `import_export_file` (
  `id` binary(16) NOT NULL,
  `original_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expire_date` datetime(3) NOT NULL,
  `size` int DEFAULT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `access_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `import_export_log`
--

CREATE TABLE `import_export_log` (
  `id` binary(16) NOT NULL,
  `activity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `records` int NOT NULL,
  `username` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profile_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` binary(16) DEFAULT NULL,
  `profile_id` binary(16) DEFAULT NULL,
  `file_id` binary(16) DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `config` json DEFAULT NULL,
  `result` json DEFAULT NULL,
  `invalid_records_log_id` binary(16) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.import_export_log.user_id` (`user_id`),
  KEY `fk.import_export_log.profile_id` (`profile_id`),
  KEY `fk.import_export_log.invalid_records_log_id` (`invalid_records_log_id`),
  KEY `fk.import_export_log.file_id` (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `import_export_profile`
--

CREATE TABLE `import_export_profile` (
  `id` binary(16) NOT NULL,
  `system_default` tinyint unsigned NOT NULL DEFAULT '0',
  `source_entity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `delimiter` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enclosure` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'import-export',
  `mapping` longtext COLLATE utf8mb4_unicode_ci,
  `update_by` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `config` json DEFAULT NULL,
  `technical_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.import_export_profile.technical_name` (`technical_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `import_export_profile`
--

INSERT INTO `import_export_profile` VALUES
('q''VB=', 1, 'category', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"parentId","mappedKey":"parent_id","position":1},{"key":"active","mappedKey":"active","position":2},{"key":"type","mappedKey":"type","position":3},{"key":"visible","mappedKey":"visible","position":4},{"key":"translations.DEFAULT.name","mappedKey":"name","position":5},{"key":"translations.DEFAULT.externalLink","mappedKey":"external_link","position":6},{"key":"translations.DEFAULT.description","mappedKey":"description","position":7},{"key":"translations.DEFAULT.metaTitle","mappedKey":"meta_title","position":8},{"key":"translations.DEFAULT.metaDescription","mappedKey":"meta_description","position":9},{"key":"media.id","mappedKey":"media_id","position":10},{"key":"media.url","mappedKey":"media_url","position":11},{"key":"media.mediaFolderId","mappedKey":"media_folder_id","position":12},{"key":"media.mediaType","mappedKey":"media_type","position":13},{"key":"media.translations.DEFAULT.title","mappedKey":"media_title","position":14},{"key":"media.translations.DEFAULT.alt","mappedKey":"media_alt","position":15},{"key":"cmsPageId","mappedKey":"cms_page_id","position":16}]', NULL, '[[regtime_]]', NULL, NULL, 'default_category'),
('s&Kh\rN;', 1, 'media', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"mediaFolderId","mappedKey":"folder_id","position":1},{"key":"url","mappedKey":"url","position":2},{"key":"private","mappedKey":"private","position":3},{"key":"mediaType","mappedKey":"type","position":4},{"key":"translations.DEFAULT.title","mappedKey":"title","position":5},{"key":"translations.DEFAULT.alt","mappedKey":"alt","position":6}]', NULL, '[[regtime_]]', NULL, NULL, 'default_media'),
('si1 d', 1, 'product', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"parentId","mappedKey":"parent_id","position":1},{"key":"productNumber","mappedKey":"product_number","position":2},{"key":"active","mappedKey":"active","position":3},{"key":"stock","mappedKey":"stock","position":4},{"key":"translations.DEFAULT.name","mappedKey":"name","position":5},{"key":"translations.DEFAULT.description","mappedKey":"description","position":6},{"key":"price.DEFAULT.net","mappedKey":"price_net","position":7},{"key":"price.DEFAULT.gross","mappedKey":"price_gross","position":8},{"key":"purchasePrices.DEFAULT.net","mappedKey":"purchase_prices_net","position":9},{"key":"purchasePrices.DEFAULT.gross","mappedKey":"purchase_prices_gross","position":10},{"key":"tax.id","mappedKey":"tax_id","position":11},{"key":"tax.taxRate","mappedKey":"tax_rate","position":12},{"key":"tax.name","mappedKey":"tax_name","position":13},{"key":"cover.media.id","mappedKey":"cover_media_id","position":14},{"key":"cover.media.url","mappedKey":"cover_media_url","position":15},{"key":"cover.media.translations.DEFAULT.title","mappedKey":"cover_media_title","position":16},{"key":"cover.media.translations.DEFAULT.alt","mappedKey":"cover_media_alt","position":17},{"key":"manufacturer.id","mappedKey":"manufacturer_id","position":18},{"key":"manufacturer.translations.DEFAULT.name","mappedKey":"manufacturer_name","position":19},{"key":"categories","mappedKey":"categories","position":20},{"key":"visibilities.all","mappedKey":"sales_channel","position":21},{"key":"properties","mappedKey":"propertyIds","position":22},{"key":"options","mappedKey":"optionIds","position":23}]', NULL, '[[regtime_]]', NULL, NULL, 'default_product'),
('p)b', 1, 'newsletter_recipient', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"email","mappedKey":"email","position":1},{"key":"title","mappedKey":"title","position":2},{"key":"salutation.salutationKey","mappedKey":"salutation","position":3},{"key":"firstName","mappedKey":"first_name","position":4},{"key":"lastName","mappedKey":"last_name","position":5},{"key":"zipCode","mappedKey":"zip_code","position":6},{"key":"city","mappedKey":"city","position":7},{"key":"street","mappedKey":"street","position":8},{"key":"status","mappedKey":"status","position":9},{"key":"hash","mappedKey":"hash","position":10},{"key":"salesChannel.id","mappedKey":"sales_channel_id","position":11}]', NULL, '[[regtime_]]', NULL, NULL, 'default_newsletter_recipient'),
('q<\0/H', 1, 'product_configurator_setting', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"productId","mappedKey":"product_id","position":1},{"key":"optionId","mappedKey":"option_id","position":2},{"key":"position","mappedKey":"position","position":3},{"key":"media.id","mappedKey":"media_id","position":4},{"key":"media.url","mappedKey":"media_url","position":5},{"key":"media.mediaFolderId","mappedKey":"media_folder_id","position":6},{"key":"media.mediaType","mappedKey":"media_type","position":7},{"key":"media.translations.DEFAULT.title","mappedKey":"media_title","position":8},{"key":"media.translations.DEFAULT.alt","mappedKey":"media_alt","position":9},{"key":"price.DEFAULT.net","mappedKey":"price_net","position":10},{"key":"price.DEFAULT.gross","mappedKey":"price_gross","position":11}]', NULL, '[[regtime_]]', NULL, NULL, 'default_variant_configuration_settings'),
('q`]''D', 1, 'property_group_option', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"colorHexCode","mappedKey":"color_hex_code","position":1},{"key":"translations.DEFAULT.name","mappedKey":"name","position":2},{"key":"translations.DEFAULT.position","mappedKey":"position","position":3},{"key":"group.id","mappedKey":"group_id","position":4},{"key":"group.displayType","mappedKey":"group_display_type","position":5},{"key":"group.sortingType","mappedKey":"group_sorting_type","position":6},{"key":"group.translations.DEFAULT.name","mappedKey":"group_name","position":7},{"key":"group.translations.DEFAULT.description","mappedKey":"group_description","position":8},{"key":"group.translations.DEFAULT.position","mappedKey":"group_position","position":9},{"key":"media.id","mappedKey":"media_id","position":10},{"key":"media.url","mappedKey":"media_url","position":11},{"key":"media.mediaFolderId","mappedKey":"media_folder_id","position":12},{"key":"media.mediaType","mappedKey":"media_type","position":13},{"key":"media.translations.DEFAULT.title","mappedKey":"media_title","position":14},{"key":"media.translations.DEFAULT.alt","mappedKey":"media_alt","position":15}]', NULL, '[[regtime_]]', NULL, NULL, 'default_properties'),
('1sFI{p', 1, 'product_cross_selling', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"translations.DEFAULT.name","mappedKey":"name","position":1},{"key":"productId","mappedKey":"product_id","position":2},{"key":"active","mappedKey":"active","position":3},{"key":"position","mappedKey":"position","position":4},{"key":"limit","mappedKey":"limit","position":5},{"key":"type","mappedKey":"type","position":6},{"key":"sortBy","mappedKey":"sort_by","position":7},{"key":"sortDirection","mappedKey":"sort_direction","position":8},{"key":"assignedProducts","mappedKey":"assigned_products","position":9}]', NULL, '[[regtime_]]', NULL, NULL, 'default_cross_selling'),
('2Kr{-0̅', 1, 'customer', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"salutation.salutationKey","mappedKey":"salutation","position":1},{"key":"customerNumber","mappedKey":"customer_number","position":2},{"key":"firstName","mappedKey":"first_name","position":3},{"key":"lastName","mappedKey":"last_name","position":4},{"key":"email","mappedKey":"email","position":5},{"key":"active","mappedKey":"active","position":6},{"key":"guest","mappedKey":"guest","position":7},{"key":"group.translations.DEFAULT.name","mappedKey":"customer_group","position":8},{"key":"language.locale.code","mappedKey":"language","position":9},{"key":"salesChannel.translations.DEFAULT.name","mappedKey":"sales_channel","position":10},{"key":"defaultPaymentMethod.translations.DEFAULT.name","mappedKey":"payment_method","position":11},{"key":"defaultBillingAddress.id","mappedKey":"billing_id","position":12},{"key":"defaultBillingAddress.salutation.salutationKey","mappedKey":"billing_salutation","position":13},{"key":"defaultBillingAddress.title","mappedKey":"billing_title","position":14},{"key":"defaultBillingAddress.firstName","mappedKey":"billing_first_name","position":15},{"key":"defaultBillingAddress.lastName","mappedKey":"billing_last_name","position":16},{"key":"defaultBillingAddress.company","mappedKey":"billing_company","position":17},{"key":"defaultBillingAddress.street","mappedKey":"billing_street","position":18},{"key":"defaultBillingAddress.zipcode","mappedKey":"billing_zipcode","position":19},{"key":"defaultBillingAddress.city","mappedKey":"billing_city","position":20},{"key":"defaultBillingAddress.country.iso","mappedKey":"billing_country","position":21},{"key":"defaultBillingAddress.phoneNumber","mappedKey":"billing_phone_number","position":22},{"key":"defaultShippingAddress.id","mappedKey":"shipping_id","position":23},{"key":"defaultShippingAddress.salutation.salutationKey","mappedKey":"shipping_salutation","position":24},{"key":"defaultShippingAddress.title","mappedKey":"shipping_title","position":25},{"key":"defaultShippingAddress.firstName","mappedKey":"shipping_first_name","position":26},{"key":"defaultShippingAddress.lastName","mappedKey":"shipping_last_name","position":27},{"key":"defaultShippingAddress.company","mappedKey":"shipping_company","position":28},{"key":"defaultShippingAddress.street","mappedKey":"shipping_street","position":29},{"key":"defaultShippingAddress.zipcode","mappedKey":"shipping_zipcode","position":30},{"key":"defaultShippingAddress.city","mappedKey":"shipping_city","position":31},{"key":"defaultShippingAddress.country.iso","mappedKey":"shipping_country","position":32},{"key":"defaultShippingAddress.phoneNumber","mappedKey":"shipping_phone_number","position":33},{"key":"accountType","mappedKey":"account_type"}]', NULL, '[[regtime_]]', NULL, NULL, 'default_customer'),
('3rdrU%m}', 1, 'promotion_individual_code', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"promotionId","mappedKey":"promotion_id","position":1},{"key":"code","mappedKey":"code","position":2}]', NULL, '[[regtime_]]', NULL, NULL, 'default_promotion_codes'),
('3qͣ''*@', 1, 'order', 'text/csv', ';', '"', 'export', '[{"key":"id","mappedKey":"id","position":0},{"key":"orderNumber","mappedKey":"order_number","position":1},{"key":"salesChannelId","mappedKey":"sales_channel_id","position":2},{"key":"orderCustomer.firstName","mappedKey":"customer_firstname","position":3},{"key":"orderCustomer.lastName","mappedKey":"customer_lastname","position":4},{"key":"orderCustomer.email","mappedKey":"customer_email","position":5},{"key":"billingAddress.street","mappedKey":"billing_address_street","position":6},{"key":"billingAddress.zipcode","mappedKey":"billing_address_zipcode","position":7},{"key":"billingAddress.city","mappedKey":"billing_address_city","position":8},{"key":"billingAddress.company","mappedKey":"billing_address_company","position":9},{"key":"billingAddress.department","mappedKey":"billing_address_department","position":10},{"key":"billingAddress.countryId","mappedKey":"billing_address_country_id","position":11},{"key":"billingAddress.countryStateId","mappedKey":"billing_address_country_state_id","position":12},{"key":"deliveries.shippingOrderAddress.street","mappedKey":"shipping_address_street","position":13},{"key":"deliveries.shippingOrderAddress.zipcode","mappedKey":"shipping_address_zipcode","position":14},{"key":"deliveries.shippingOrderAddress.city","mappedKey":"shipping_address_city","position":15},{"key":"deliveries.shippingOrderAddress.company","mappedKey":"shipping_address_company","position":16},{"key":"deliveries.shippingOrderAddress.department","mappedKey":"shipping_address_department","position":17},{"key":"deliveries.shippingOrderAddress.countryId","mappedKey":"shipping_address_country_id","position":18},{"key":"deliveries.shippingOrderAddress.countryStateId","mappedKey":"shipping_address_country_state_id","position":19},{"key":"amountTotal","mappedKey":"amount_total","position":20},{"key":"stateId","mappedKey":"order_state_id","position":21},{"key":"lineItems","mappedKey":"line_items","position":22},{"key":"orderDateTime","mappedKey":"order_date_time","position":23}]', NULL, '[[regtime_]]', NULL, NULL, 'default_orders'),
('9s+K', 1, 'product_price', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"productId","mappedKey":"product_id","position":1},{"key":"ruleId","mappedKey":"rule_id","position":2},{"key":"price.DEFAULT.net","mappedKey":"price_net","position":3},{"key":"price.DEFAULT.gross","mappedKey":"price_gross","position":4},{"key":"quantityStart","mappedKey":"quantity_start","position":5},{"key":"quantityEnd","mappedKey":"quantity_end","position":6}]', NULL, '[[regtime_]]', NULL, NULL, 'default_advanced_prices'),
('9sRatt', 1, 'promotion_discount', 'text/csv', ';', '"', 'import-export', '[{"key":"id","mappedKey":"id","position":0},{"key":"promotionId","mappedKey":"promotion_id","position":1},{"key":"scope","mappedKey":"scope","position":2},{"key":"type","mappedKey":"type","position":3},{"key":"value","mappedKey":"value","position":4},{"key":"considerAdvancedRules","mappedKey":"consider_advanced_rules","position":5},{"key":"maxValue","mappedKey":"max_value","position":6},{"key":"sorterKey","mappedKey":"sorter_key","position":7,"useDefaultValue":true,"defaultValue":"PRICE_ASC"},{"key":"applierKey","mappedKey":"applier_key","position":8,"useDefaultValue":true,"defaultValue":"ALL"},{"key":"usageKey","mappedKey":"usage_key","position":9,"useDefaultValue":true,"defaultValue":"ALL"},{"key":"pickerKey","mappedKey":"picker_key","position":10},{"key":"discountRules","mappedKey":"discount_rules","position":11}]', NULL, '[[regtime_]]', NULL, NULL, 'default_promotion_discounts');

-- --------------------------------------------------------

--
-- Table structure for table `import_export_profile_translation`
--

CREATE TABLE `import_export_profile_translation` (
  `import_export_profile_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`import_export_profile_id`,`language_id`),
  KEY `fk.import_export_profile_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `import_export_profile_translation`
--

INSERT INTO `import_export_profile_translation` VALUES
('q''VB=', 'jlrm%LL7WJ', 'Standardprofil Kategorie', '[[regtime_]]', NULL),
('q''VB=', '/_MpXT|', 'Default category', '[[regtime_]]', NULL),
('s&Kh\rN;', 'jlrm%LL7WJ', 'Standardprofil Medien', '[[regtime_]]', NULL),
('s&Kh\rN;', '/_MpXT|', 'Default media', '[[regtime_]]', NULL),
('si1 d', 'jlrm%LL7WJ', 'Standardprofil Produkt', '[[regtime_]]', NULL),
('si1 d', '/_MpXT|', 'Default product', '[[regtime_]]', NULL),
('p)b', 'jlrm%LL7WJ', 'Standardprofil Newsletter-Empfänger', '[[regtime_]]', NULL),
('p)b', '/_MpXT|', 'Default newsletter recipient', '[[regtime_]]', NULL),
('q<\0/H', 'jlrm%LL7WJ', 'Standardprofil Variantenkonfiguration', '[[regtime_]]', NULL),
('q<\0/H', '/_MpXT|', 'Default variant configuration settings', '[[regtime_]]', NULL),
('q`]''D', 'jlrm%LL7WJ', 'Standardprofil Eigenschaften', '[[regtime_]]', NULL),
('q`]''D', '/_MpXT|', 'Default properties', '[[regtime_]]', NULL),
('1sFI{p', 'jlrm%LL7WJ', 'Standardprofil Cross-Selling', '[[regtime_]]', NULL),
('1sFI{p', '/_MpXT|', 'Default cross-selling', '[[regtime_]]', NULL),
('2Kr{-0̅', 'jlrm%LL7WJ', 'Standardprofil Kunde', '[[regtime_]]', NULL),
('2Kr{-0̅', '/_MpXT|', 'Default customer', '[[regtime_]]', NULL),
('3rdrU%m}', 'jlrm%LL7WJ', 'Standardprofil Aktionscodes', '[[regtime_]]', NULL),
('3rdrU%m}', '/_MpXT|', 'Default promotion codes', '[[regtime_]]', NULL),
('3qͣ''*@', 'jlrm%LL7WJ', 'Standardprofil Bestellungen', '[[regtime_]]', NULL),
('3qͣ''*@', '/_MpXT|', 'Default orders', '[[regtime_]]', NULL),
('9s+K', 'jlrm%LL7WJ', 'Standardprofil Erweiterte Preise', '[[regtime_]]', NULL),
('9s+K', '/_MpXT|', 'Default advanced prices', '[[regtime_]]', NULL),
('9sRatt', 'jlrm%LL7WJ', 'Standardprofil Aktionsrabatte', '[[regtime_]]', NULL),
('9sRatt', '/_MpXT|', 'Default promotion discounts', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `increment`
--

CREATE TABLE `increment` (
  `pool` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cluster` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `count` bigint unsigned NOT NULL DEFAULT '1',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`pool`,`cluster`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `integration`
--

CREATE TABLE `integration` (
  `id` binary(16) NOT NULL,
  `access_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret_access_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `admin` tinyint(1) NOT NULL DEFAULT '1',
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `last_usage_at` datetime(3) DEFAULT NULL,
  `deleted_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.access_key` (`access_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `integration_role`
--

CREATE TABLE `integration_role` (
  `integration_id` binary(16) NOT NULL,
  `acl_role_id` binary(16) NOT NULL,
  PRIMARY KEY (`integration_id`,`acl_role_id`),
  KEY `fk.integration_acl_role.acl_role_id` (`acl_role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `invalidation_tags`
--

CREATE TABLE `invalidation_tags` (
  `id` binary(16) NOT NULL,
  `tag` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tag` (`tag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `landing_page`
--

CREATE TABLE `landing_page` (
  `id` binary(16) NOT NULL,
  `version_id` binary(16) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `cms_page_id` binary(16) DEFAULT NULL,
  `cms_page_version_id` binary(16) NOT NULL DEFAULT 0x0FA91CE3E96A4BC2BE4BD9CE752C3425,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`,`version_id`),
  KEY `fk.landing_page.cms_page_id` (`cms_page_id`,`cms_page_version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `landing_page_sales_channel`
--

CREATE TABLE `landing_page_sales_channel` (
  `landing_page_id` binary(16) NOT NULL,
  `landing_page_version_id` binary(16) NOT NULL,
  `sales_channel_id` binary(16) NOT NULL,
  PRIMARY KEY (`landing_page_id`,`landing_page_version_id`,`sales_channel_id`),
  KEY `fk.landing_page_sales_channel.sales_channel_id` (`sales_channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `landing_page_tag`
--

CREATE TABLE `landing_page_tag` (
  `landing_page_id` binary(16) NOT NULL,
  `landing_page_version_id` binary(16) NOT NULL,
  `tag_id` binary(16) NOT NULL,
  PRIMARY KEY (`landing_page_id`,`landing_page_version_id`,`tag_id`),
  KEY `fk.landing_page_tag.tag_id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `landing_page_translation`
--

CREATE TABLE `landing_page_translation` (
  `landing_page_id` binary(16) NOT NULL,
  `landing_page_version_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `slot_config` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`landing_page_id`,`landing_page_version_id`,`language_id`),
  KEY `fk.landing_page_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `language`
--

CREATE TABLE `language` (
  `id` binary(16) NOT NULL,
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` binary(16) DEFAULT NULL,
  `locale_id` binary(16) NOT NULL,
  `translation_code_id` binary(16) DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx.language.translation_code_id` (`translation_code_id`),
  KEY `idx.language.language_id_parent_language_id` (`id`,`parent_id`),
  KEY `fk.language.parent_id` (`parent_id`),
  KEY `fk.language.locale_id` (`locale_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `language`
--

INSERT INTO `language` VALUES
('jlrm%LL7WJ', 'Deutsch', NULL, 'jlrm%LKks', 'jlrm%LKks', NULL, '[[regtime_]]', NULL, 1),
('/_MpXT|', 'English', NULL, 'jlrm%LJB', 'jlrm%LJB', NULL, '[[regtime_]]', NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `locale`
--

CREATE TABLE `locale` (
  `id` binary(16) NOT NULL,
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `locale`
--

INSERT INTO `locale` VALUES
('jlrm%LJB', 'en-GB', '[[regtime_]]', NULL),
('jlrm%LKks', 'de-DE', '[[regtime_]]', NULL),
('jsޤY\n)>', 'aa-DJ', '[[regtime_]]', NULL),
('jsޤY\n', 'aa-ER', '[[regtime_]]', NULL),
('jsޤY\n^', 'aa-ET', '[[regtime_]]', NULL),
('jsޤY\nVP', 'af-NA', '[[regtime_]]', NULL),
('jsޤY\n', 'af-ZA', '[[regtime_]]', NULL),
('jsޤY\n÷', 'ak-GH', '[[regtime_]]', NULL),
('jsޤY\n', 'am-ET', '[[regtime_]]', NULL),
('jsޤY\nL', 'ar-AE', '[[regtime_]]', NULL),
('jsޤY\njH', 'ar-BH', '[[regtime_]]', NULL),
('jsޤY\n]', 'ar-DZ', '[[regtime_]]', NULL),
('jsޤY\nP', 'ar-EG', '[[regtime_]]', NULL),
('jsޤY\nB', 'ar-IQ', '[[regtime_]]', NULL),
('jsޤY\n', 'ar-JO', '[[regtime_]]', NULL),
('jsޤY\nQIc', 'ar-KW', '[[regtime_]]', NULL),
('jsޤY\nU', 'ar-LB', '[[regtime_]]', NULL),
('jsޤY\nK', 'ar-LY', '[[regtime_]]', NULL),
('jsޤY\nh7C', 'ar-MA', '[[regtime_]]', NULL),
('jsEz', 'ar-OM', '[[regtime_]]', NULL),
('jsEzîm5', 'ar-QA', '[[regtime_]]', NULL),
('jsEz', 'ar-SA', '[[regtime_]]', NULL),
('jsEz3T', 'ar-SD', '[[regtime_]]', NULL),
('jsEzĐp', 'ar-SY', '[[regtime_]]', NULL),
('jsEzĬ', 'ar-TN', '[[regtime_]]', NULL),
('jsEzb', 'ar-YE', '[[regtime_]]', NULL),
('jsEz1', 'as-IN', '[[regtime_]]', NULL),
('jsEzt', 'az-AZ', '[[regtime_]]', NULL),
('jsEz', 'be-BY', '[[regtime_]]', NULL),
('jsEzǌ^.', 'bg-BG', '[[regtime_]]', NULL),
('jsEzf', 'bn-BD', '[[regtime_]]', NULL),
('jsEzM', 'bn-IN', '[[regtime_]]', NULL),
('jsEzP', 'bo-CN', '[[regtime_]]', NULL),
('jsEz''"w', 'bo-IN', '[[regtime_]]', NULL),
('jsEzȔ', 'bs-BA', '[[regtime_]]', NULL),
('jsEzDu', 'byn-ER', '[[regtime_]]', NULL),
('jsEzR,', 'ca-ES', '[[regtime_]]', NULL),
('jsEzh', 'cch-NG', '[[regtime_]]', NULL),
('jsEz)', 'cs-CZ', '[[regtime_]]', NULL),
('jsEzʉWB', 'cy-GB', '[[regtime_]]', NULL),
('jsEzʛ', 'da-DK', '[[regtime_]]', NULL),
('jsEzʽ', 'de-AT', '[[regtime_]]', NULL),
('jsEz˨', 'de-BE', '[[regtime_]]', NULL),
('jsEz<22', 'de-CH', '[[regtime_]]', NULL),
('jsEzڹD', 'de-LI', '[[regtime_]]', NULL),
('jsEz+', 'de-LU', '[[regtime_]]', NULL),
('jsEzaf[', 'dv-MV', '[[regtime_]]', NULL),
('jsEz͒f', 'dz-BT', '[[regtime_]]', NULL),
('jsEz', 'ee-GH', '[[regtime_]]', NULL),
('jsEzJ', 'ee-TG', '[[regtime_]]', NULL),
('jsEzϟA', 'el-CY', '[[regtime_]]', NULL),
('jsEzS', 'el-GR', '[[regtime_]]', NULL),
('jsEzЇ', 'en-AS', '[[regtime_]]', NULL),
('jsEzo', 'en-AU', '[[regtime_]]', NULL),
('jsEz', 'en-BE', '[[regtime_]]', NULL),
('jsEz', 'en-BW', '[[regtime_]]', NULL),
('jsEz', 'en-BZ', '[[regtime_]]', NULL),
('jsEz', 'en-CA', '[[regtime_]]', NULL),
('jsEz(', 'en-GU', '[[regtime_]]', NULL),
('jsEzғ}', 'en-HK', '[[regtime_]]', NULL),
('jsEz', 'en-IE', '[[regtime_]]', NULL),
('jsEzӃ', 'en-IN', '[[regtime_]]', NULL),
('jsEzӑ', 'en-JM', '[[regtime_]]', NULL),
('jsEzі*', 'en-MH', '[[regtime_]]', NULL),
('jsEzاg', 'en-MP', '[[regtime_]]', NULL),
('jsEzIHP', 'en-MT', '[[regtime_]]', NULL),
('jsEzk', 'en-NA', '[[regtime_]]', NULL),
('jsEzoI', 'en-NZ', '[[regtime_]]', NULL),
('jsEzA', 'en-PH', '[[regtime_]]', NULL),
('jsEzղ', 'en-PK', '[[regtime_]]', NULL),
('jsEz', 'en-SG', '[[regtime_]]', NULL),
('jsEz֍/:', 'en-TT', '[[regtime_]]', NULL),
('jsEzl', 'en-UM', '[[regtime_]]', NULL),
('jsEz', 'en-US', '[[regtime_]]', NULL),
('jsEz', 'en-VI', '[[regtime_]]', NULL),
('jsEz:U', 'en-ZA', '[[regtime_]]', NULL),
('jsEzs', 'en-ZW', '[[regtime_]]', NULL),
('jsEzDq', 'es-AR', '[[regtime_]]', NULL),
('jsEza@', 'es-BO', '[[regtime_]]', NULL),
('jsEzJ', 'es-CL', '[[regtime_]]', NULL),
('jsEzڒ', 'es-CO', '[[regtime_]]', NULL),
('jsEz9\\', 'es-CR', '[[regtime_]]', NULL),
('jsEz^!', 'es-DO', '[[regtime_]]', NULL),
('jsEzS', 'es-EC', '[[regtime_]]', NULL),
('jsEz܉7', 'es-ES', '[[regtime_]]', NULL),
('jsEzûU', 'es-GT', '[[regtime_]]', NULL),
('jsEz>', 'es-HN', '[[regtime_]]', NULL),
('jsEzݱ@', 'es-MX', '[[regtime_]]', NULL),
('jsEzr\nY', 'es-NI', '[[regtime_]]', NULL),
('jsEzވ', 'es-PA', '[[regtime_]]', NULL),
('jsEzɭ', 'es-PE', '[[regtime_]]', NULL),
('jsEz7', 'es-PR', '[[regtime_]]', NULL),
('jsEzvH', 'es-PY', '[[regtime_]]', NULL),
('jsEz߂q', 'es-SV', '[[regtime_]]', NULL),
('jsEzn', 'es-US', '[[regtime_]]', NULL),
('jsEz^`', 'es-UY', '[[regtime_]]', NULL),
('jsEzy', 'es-VE', '[[regtime_]]', NULL),
('jsEz38', 'et-EE', '[[regtime_]]', NULL),
('jsEzẫ', 'eu-ES', '[[regtime_]]', NULL),
('jsEzf', 'fa-AF', '[[regtime_]]', NULL),
('jsEz`', 'fa-IR', '[[regtime_]]', NULL),
('jsEz', 'fi-FI', '[[regtime_]]', NULL),
('jsEzcw:', 'fil-PH', '[[regtime_]]', NULL),
('jsEzI', 'fo-FO', '[[regtime_]]', NULL),
('jsEzk@L', 'fr-BE', '[[regtime_]]', NULL),
('jsEz{\n', 'fr-CA', '[[regtime_]]', NULL),
('jsEza', 'fr-CH', '[[regtime_]]', NULL),
('jsEzv', 'fr-FR', '[[regtime_]]', NULL),
('jsEz', 'fr-LU', '[[regtime_]]', NULL),
('jsEzL', 'fr-MC', '[[regtime_]]', NULL),
('jsEzf$', 'fr-SN', '[[regtime_]]', NULL),
('jsEz愤f', 'fur-IT', '[[regtime_]]', NULL),
('jsEz2\0', 'ga-IE', '[[regtime_]]', NULL),
('jsEza', 'gaa-GH', '[[regtime_]]', NULL),
('jsEz&A', 'gez-ER', '[[regtime_]]', NULL),
('jsEz$', 'gez-ET', '[[regtime_]]', NULL),
('jsEzJ', 'gl-ES', '[[regtime_]]', NULL),
('jsEz', 'gsw-CH', '[[regtime_]]', NULL),
('jsEzǐQ', 'gu-IN', '[[regtime_]]', NULL),
('jsEz30', 'gv-GB', '[[regtime_]]', NULL),
('jsEzv0', 'ha-GH', '[[regtime_]]', NULL),
('jsEzb7', 'ha-NE', '[[regtime_]]', NULL),
('jsEz=0', 'ha-NG', '[[regtime_]]', NULL),
('jsEz', 'ha-SD', '[[regtime_]]', NULL),
('jsEzU', 'haw-US', '[[regtime_]]', NULL),
('jsEz땜', 'he-IL', '[[regtime_]]', NULL),
('jsEzt', 'hi-IN', '[[regtime_]]', NULL),
('jsEz;', 'hr-HR', '[[regtime_]]', NULL),
('jsEzÂ', 'hu-HU', '[[regtime_]]', NULL),
('jsEzv', 'hy-AM', '[[regtime_]]', NULL),
('jsEz', 'id-ID', '[[regtime_]]', NULL),
('jsEz飼', 'ig-NG', '[[regtime_]]', NULL),
('jsEzu', 'ii-CN', '[[regtime_]]', NULL),
('jsEzu', 'is-IS', '[[regtime_]]', NULL),
('jsEzD', 'it-CH', '[[regtime_]]', NULL),
('jsEz-&', 'it-IT', '[[regtime_]]', NULL),
('jsEz!', 'ja-JP', '[[regtime_]]', NULL),
('jsEz0!v', 'ka-GE', '[[regtime_]]', NULL),
('jsEz󰯂', 'kaj-NG', '[[regtime_]]', NULL),
('jsEz&', 'kam-KE', '[[regtime_]]', NULL),
('jsEz%v', 'kcg-NG', '[[regtime_]]', NULL),
('jsEz)', 'kfo-CI', '[[regtime_]]', NULL),
('jsEzhQ', 'kk-KZ', '[[regtime_]]', NULL),
('jsEz|', 'kl-GL', '[[regtime_]]', NULL),
('jsEzv2', 'km-KH', '[[regtime_]]', NULL),
('jsEzz', 'kn-IN', '[[regtime_]]', NULL),
('jsEz@	', 'ko-KR', '[[regtime_]]', NULL),
('jsEz"m', 'kok-IN', '[[regtime_]]', NULL),
('jsEzp', 'kpe-GN', '[[regtime_]]', NULL),
('jsEzU#0', 'kpe-LR', '[[regtime_]]', NULL),
('jsEzn\Z', 'ku-IQ', '[[regtime_]]', NULL),
('jsEzQ', 'ku-IR', '[[regtime_]]', NULL),
('jsEz1/', 'ku-SY', '[[regtime_]]', NULL),
('jsEzNO', 'ku-TR', '[[regtime_]]', NULL),
('jsEz\0d', 'kw-GB', '[[regtime_]]', NULL),
('jsEz', 'ky-KG', '[[regtime_]]', NULL),
('jsEz&@', 'ln-CD', '[[regtime_]]', NULL),
('jsEzx', 'ln-CG', '[[regtime_]]', NULL),
('jsEzKmF', 'lo-LA', '[[regtime_]]', NULL),
('jsEzY', 'lt-LT', '[[regtime_]]', NULL),
('jsEzj', 'lv-LV', '[[regtime_]]', NULL),
('jsEz.', 'mk-MK', '[[regtime_]]', NULL),
('jsEzK', 'ml-IN', '[[regtime_]]', NULL),
('jsEzY@', 'mn-CN', '[[regtime_]]', NULL),
('jsE{\0SF', 'mn-MN', '[[regtime_]]', NULL),
('jsE{"ڧ', 'mr-IN', '[[regtime_]]', NULL),
('jsE{', 'ms-BN', '[[regtime_]]', NULL),
('jsE{8K', 'ms-MY', '[[regtime_]]', NULL),
('jsE{R', 'mt-MT', '[[regtime_]]', NULL),
('jsE{', 'my-MM', '[[regtime_]]', NULL),
('jsE{RVU', 'nb-NO', '[[regtime_]]', NULL),
('jsE{~V', 'nds-DE', '[[regtime_]]', NULL),
('jsE{', 'ne-IN', '[[regtime_]]', NULL),
('jsE{l_', 'ne-NP', '[[regtime_]]', NULL),
('jsE{.', 'nl-BE', '[[regtime_]]', NULL),
('jsE{Z', 'nl-NL', '[[regtime_]]', NULL),
('jsE{', 'nn-NO', '[[regtime_]]', NULL),
('jsE{o', 'nr-ZA', '[[regtime_]]', NULL),
('jsE{ӏ6', 'nso-ZA', '[[regtime_]]', NULL),
('js{Jwj', 'ny-MW', '[[regtime_]]', NULL),
('js{Kf', 'oc-FR', '[[regtime_]]', NULL),
('js{Ұ', 'om-ET', '[[regtime_]]', NULL),
('js{"', 'om-KE', '[[regtime_]]', NULL),
('js{c\Z', 'or-IN', '[[regtime_]]', NULL),
('js{', 'pa-IN', '[[regtime_]]', NULL),
('js{6', 'pa-PK', '[[regtime_]]', NULL),
('js{-oS', 'pl-PL', '[[regtime_]]', NULL),
('js{}', 'ps-AF', '[[regtime_]]', NULL),
('js{Ob', 'pt-BR', '[[regtime_]]', NULL),
('js{Q-', 'pt-PT', '[[regtime_]]', NULL),
('js{', 'ro-MD', '[[regtime_]]', NULL),
('js{6Z', 'ro-RO', '[[regtime_]]', NULL),
('js{a', 'ru-RU', '[[regtime_]]', NULL),
('js{x', 'ru-UA', '[[regtime_]]', NULL),
('js{Ԫ', 'rw-RW', '[[regtime_]]', NULL),
('js{L', 'sa-IN', '[[regtime_]]', NULL),
('js{', 'se-FI', '[[regtime_]]', NULL),
('js{Dx', 'se-NO', '[[regtime_]]', NULL),
('js{@', 'sh-BA', '[[regtime_]]', NULL),
('js{.', 'sh-CS', '[[regtime_]]', NULL),
('js{B:', 'si-LK', '[[regtime_]]', NULL),
('js{	Q', 'sid-ET', '[[regtime_]]', NULL),
('js{', 'sk-SK', '[[regtime_]]', NULL),
('js{2', 'sl-SI', '[[regtime_]]', NULL),
('js{vHs', 'so-DJ', '[[regtime_]]', NULL),
('js{9', 'so-ET', '[[regtime_]]', NULL),
('js{.	', 'so-KE', '[[regtime_]]', NULL),
('js{', 'so-SO', '[[regtime_]]', NULL),
('js{:L', 'sq-AL', '[[regtime_]]', NULL),
('js{@', 'sr-BA', '[[regtime_]]', NULL),
('js{w%k', 'sr-CS', '[[regtime_]]', NULL),
('js{I8', 'sr-ME', '[[regtime_]]', NULL),
('js{c', 'sr-RS', '[[regtime_]]', NULL),
('js{֗', 'ss-SZ', '[[regtime_]]', NULL),
('js{', 'ss-ZA', '[[regtime_]]', NULL),
('js{Tz', 'st-LS', '[[regtime_]]', NULL),
('js{bG', 'st-ZA', '[[regtime_]]', NULL),
('js{֔', 'sv-FI', '[[regtime_]]', NULL),
('js{', 'sv-SE', '[[regtime_]]', NULL),
('js{q', 'sw-KE', '[[regtime_]]', NULL),
('js{7K', 'sw-TZ', '[[regtime_]]', NULL),
('js{O', 'syr-SY', '[[regtime_]]', NULL),
('js{I', 'ta-IN', '[[regtime_]]', NULL),
('js{kQ', 'te-IN', '[[regtime_]]', NULL),
('js{\0', 'tg-TJ', '[[regtime_]]', NULL),
('js{.2{', 'th-TH', '[[regtime_]]', NULL),
('js{&', 'ti-ER', '[[regtime_]]', NULL),
('js{', 'ti-ET', '[[regtime_]]', NULL),
('js{|v', 'tig-ER', '[[regtime_]]', NULL),
('js{', 'tn-ZA', '[[regtime_]]', NULL),
('js{', 'to-TO', '[[regtime_]]', NULL),
('js{\0G', 'tr-TR', '[[regtime_]]', NULL),
('js{P', 'ts-ZA', '[[regtime_]]', NULL),
('js{$', 'tt-RU', '[[regtime_]]', NULL),
('js{2/', 'ug-CN', '[[regtime_]]', NULL),
('js{+F', 'uk-UA', '[[regtime_]]', NULL),
('js{/n', 'ur-IN', '[[regtime_]]', NULL),
('js{	h', 'ur-PK', '[[regtime_]]', NULL),
('js{|', 'uz-AF', '[[regtime_]]', NULL),
('js{,', 'uz-UZ', '[[regtime_]]', NULL),
('js{', 've-ZA', '[[regtime_]]', NULL),
('js{@', 'vi-VN', '[[regtime_]]', NULL),
('js{', 'wal-ET', '[[regtime_]]', NULL),
('js{kE]', 'wo-SN', '[[regtime_]]', NULL),
('js{Ěc', 'xh-ZA', '[[regtime_]]', NULL),
('js{*t', 'yo-NG', '[[regtime_]]', NULL),
('js{;T', 'zh-CN', '[[regtime_]]', NULL),
('js{Ň~', 'zh-HK', '[[regtime_]]', NULL),
('js{2', 'zh-MO', '[[regtime_]]', NULL),
('js{', 'zh-SG', '[[regtime_]]', NULL),
('js{w', 'zh-TW', '[[regtime_]]', NULL),
('js{ǊW', 'zu-ZA', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `locale_translation`
--

CREATE TABLE `locale_translation` (
  `locale_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `territory` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`locale_id`,`language_id`),
  KEY `fk.locale_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `locale_translation`
--

INSERT INTO `locale_translation` VALUES
('jlrm%LJB', 'jlrm%LL7WJ', 'Englisch', 'Vereinigtes Königreich', NULL, '[[regtime_]]', NULL),
('jlrm%LJB', '/_MpXT|', 'English', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('jlrm%LKks', 'jlrm%LL7WJ', 'Deutsch', 'Deutschland', NULL, '[[regtime_]]', NULL),
('jlrm%LKks', '/_MpXT|', 'German', 'Germany', NULL, '[[regtime_]]', NULL),
('jsޤY\n)>', 'jlrm%LL7WJ', 'Afar', 'Dschibuti', NULL, '[[regtime_]]', NULL),
('jsޤY\n)>', '/_MpXT|', 'Afar', 'Djibouti', NULL, '[[regtime_]]', NULL),
('jsޤY\n', 'jlrm%LL7WJ', 'Afar', 'Eritrea', NULL, '[[regtime_]]', NULL),
('jsޤY\n', '/_MpXT|', 'Afar', 'Eritrea', NULL, '[[regtime_]]', NULL),
('jsޤY\n^', 'jlrm%LL7WJ', 'Afar', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('jsޤY\n^', '/_MpXT|', 'Afar', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('jsޤY\nVP', 'jlrm%LL7WJ', 'Afrikaans', 'Namibia', NULL, '[[regtime_]]', NULL),
('jsޤY\nVP', '/_MpXT|', 'Afrikaans', 'Namibia', NULL, '[[regtime_]]', NULL),
('jsޤY\n', 'jlrm%LL7WJ', 'Afrikaans', 'Südafrika', NULL, '[[regtime_]]', NULL),
('jsޤY\n', '/_MpXT|', 'Afrikaans', 'South Africa', NULL, '[[regtime_]]', NULL),
('jsޤY\n÷', 'jlrm%LL7WJ', 'Akan', 'Ghana', NULL, '[[regtime_]]', NULL),
('jsޤY\n÷', '/_MpXT|', 'Akan', 'Ghana', NULL, '[[regtime_]]', NULL),
('jsޤY\n', 'jlrm%LL7WJ', 'Amharisch', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('jsޤY\n', '/_MpXT|', 'Amharic', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('jsޤY\nL', 'jlrm%LL7WJ', 'Arabisch', 'Vereinigte Arabische Emirate', NULL, '[[regtime_]]', NULL),
('jsޤY\nL', '/_MpXT|', 'Arabic', 'United Arab Emirates', NULL, '[[regtime_]]', NULL),
('jsޤY\njH', 'jlrm%LL7WJ', 'Arabisch', 'Bahrain', NULL, '[[regtime_]]', NULL),
('jsޤY\njH', '/_MpXT|', 'Arabic', 'Bahrain', NULL, '[[regtime_]]', NULL),
('jsޤY\n]', 'jlrm%LL7WJ', 'Arabisch', 'Algerien', NULL, '[[regtime_]]', NULL),
('jsޤY\n]', '/_MpXT|', 'Arabic', 'Algeria', NULL, '[[regtime_]]', NULL),
('jsޤY\nP', 'jlrm%LL7WJ', 'Arabisch', 'Ägypten', NULL, '[[regtime_]]', NULL),
('jsޤY\nP', '/_MpXT|', 'Arabic', 'Egypt', NULL, '[[regtime_]]', NULL),
('jsޤY\nB', 'jlrm%LL7WJ', 'Arabisch', 'Irak', NULL, '[[regtime_]]', NULL),
('jsޤY\nB', '/_MpXT|', 'Arabic', 'Iraq', NULL, '[[regtime_]]', NULL),
('jsޤY\n', 'jlrm%LL7WJ', 'Arabisch', 'Jordanien', NULL, '[[regtime_]]', NULL),
('jsޤY\n', '/_MpXT|', 'Arabic', 'Jordan', NULL, '[[regtime_]]', NULL),
('jsޤY\nQIc', 'jlrm%LL7WJ', 'Arabisch', 'Kuwait', NULL, '[[regtime_]]', NULL),
('jsޤY\nQIc', '/_MpXT|', 'Arabic', 'Kuwait', NULL, '[[regtime_]]', NULL),
('jsޤY\nU', 'jlrm%LL7WJ', 'Arabisch', 'Libanon', NULL, '[[regtime_]]', NULL),
('jsޤY\nU', '/_MpXT|', 'Arabic', 'Lebanon', NULL, '[[regtime_]]', NULL),
('jsޤY\nK', 'jlrm%LL7WJ', 'Arabisch', 'Libyen', NULL, '[[regtime_]]', NULL),
('jsޤY\nK', '/_MpXT|', 'Arabic', 'Libya', NULL, '[[regtime_]]', NULL),
('jsޤY\nh7C', 'jlrm%LL7WJ', 'Arabisch', 'Marokko', NULL, '[[regtime_]]', NULL),
('jsޤY\nh7C', '/_MpXT|', 'Arabic', 'Morocco', NULL, '[[regtime_]]', NULL),
('jsEz', 'jlrm%LL7WJ', 'Arabisch', 'Oman', NULL, '[[regtime_]]', NULL),
('jsEz', '/_MpXT|', 'Arabic', 'Oman', NULL, '[[regtime_]]', NULL),
('jsEzîm5', 'jlrm%LL7WJ', 'Arabisch', 'Katar', NULL, '[[regtime_]]', NULL),
('jsEzîm5', '/_MpXT|', 'Arabic', 'Qatar', NULL, '[[regtime_]]', NULL),
('jsEz', 'jlrm%LL7WJ', 'Arabisch', 'Saudi-Arabien', NULL, '[[regtime_]]', NULL),
('jsEz', '/_MpXT|', 'Arabic', 'Saudi Arabia', NULL, '[[regtime_]]', NULL),
('jsEz3T', 'jlrm%LL7WJ', 'Arabisch', 'Sudan', NULL, '[[regtime_]]', NULL),
('jsEz3T', '/_MpXT|', 'Arabic', 'Sudan', NULL, '[[regtime_]]', NULL),
('jsEzĐp', 'jlrm%LL7WJ', 'Arabisch', 'Syrien', NULL, '[[regtime_]]', NULL),
('jsEzĐp', '/_MpXT|', 'Arabic', 'Syria', NULL, '[[regtime_]]', NULL),
('jsEzĬ', 'jlrm%LL7WJ', 'Arabisch', 'Tunesien', NULL, '[[regtime_]]', NULL),
('jsEzĬ', '/_MpXT|', 'Arabic', 'Tunisia', NULL, '[[regtime_]]', NULL),
('jsEzb', 'jlrm%LL7WJ', 'Arabisch', 'Jemen', NULL, '[[regtime_]]', NULL),
('jsEzb', '/_MpXT|', 'Arabic', 'Yemen', NULL, '[[regtime_]]', NULL),
('jsEz1', 'jlrm%LL7WJ', 'Assamesisch', 'Indien', NULL, '[[regtime_]]', NULL),
('jsEz1', '/_MpXT|', 'Assamese', 'India', NULL, '[[regtime_]]', NULL),
('jsEzt', 'jlrm%LL7WJ', 'Aserbaidschanisch', 'Aserbaidschan', NULL, '[[regtime_]]', NULL),
('jsEzt', '/_MpXT|', 'Azerbaijani', 'Azerbaijan', NULL, '[[regtime_]]', NULL),
('jsEz', 'jlrm%LL7WJ', 'Weißrussisch', 'Belarus', NULL, '[[regtime_]]', NULL),
('jsEz', '/_MpXT|', 'Belarusian', 'Belarus', NULL, '[[regtime_]]', NULL),
('jsEzǌ^.', 'jlrm%LL7WJ', 'Bulgarisch', 'Bulgarien', NULL, '[[regtime_]]', NULL),
('jsEzǌ^.', '/_MpXT|', 'Bulgarian', 'Bulgaria', NULL, '[[regtime_]]', NULL),
('jsEzf', 'jlrm%LL7WJ', 'Bengalisch', 'Bangladesch', NULL, '[[regtime_]]', NULL),
('jsEzf', '/_MpXT|', 'Bengali', 'Bangladesh', NULL, '[[regtime_]]', NULL),
('jsEzM', 'jlrm%LL7WJ', 'Bengalisch', 'Indien', NULL, '[[regtime_]]', NULL),
('jsEzM', '/_MpXT|', 'Bengali', 'India', NULL, '[[regtime_]]', NULL),
('jsEzP', 'jlrm%LL7WJ', 'Tibetisch', 'China', NULL, '[[regtime_]]', NULL),
('jsEzP', '/_MpXT|', 'Tibetan', 'China', NULL, '[[regtime_]]', NULL),
('jsEz''"w', 'jlrm%LL7WJ', 'Tibetisch', 'Indien', NULL, '[[regtime_]]', NULL),
('jsEz''"w', '/_MpXT|', 'Tibetan', 'India', NULL, '[[regtime_]]', NULL),
('jsEzȔ', 'jlrm%LL7WJ', 'Bosnisch', 'Bosnien und Herzegowina', NULL, '[[regtime_]]', NULL),
('jsEzȔ', '/_MpXT|', 'Bosnian', 'Bosnia and Herzegovina', NULL, '[[regtime_]]', NULL),
('jsEzDu', 'jlrm%LL7WJ', 'Blin', 'Eritrea', NULL, '[[regtime_]]', NULL),
('jsEzDu', '/_MpXT|', 'Blin', 'Eritrea', NULL, '[[regtime_]]', NULL),
('jsEzR,', 'jlrm%LL7WJ', 'Katalanisch', 'Spanien', NULL, '[[regtime_]]', NULL),
('jsEzR,', '/_MpXT|', 'Catalan', 'Spain', NULL, '[[regtime_]]', NULL),
('jsEzh', 'jlrm%LL7WJ', 'Atsam', 'Nigeria', NULL, '[[regtime_]]', NULL),
('jsEzh', '/_MpXT|', 'Atsam', 'Nigeria', NULL, '[[regtime_]]', NULL),
('jsEz)', 'jlrm%LL7WJ', 'Tschechisch', 'Tschechische Republik', NULL, '[[regtime_]]', NULL),
('jsEz)', '/_MpXT|', 'Czech', 'Czech Republic', NULL, '[[regtime_]]', NULL),
('jsEzʉWB', 'jlrm%LL7WJ', 'Walisisch', 'Vereinigtes Königreich', NULL, '[[regtime_]]', NULL),
('jsEzʉWB', '/_MpXT|', 'Welsh', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('jsEzʛ', 'jlrm%LL7WJ', 'Dänisch', 'Dänemark', NULL, '[[regtime_]]', NULL),
('jsEzʛ', '/_MpXT|', 'Danish', 'Denmark', NULL, '[[regtime_]]', NULL),
('jsEzʽ', 'jlrm%LL7WJ', 'Deutsch', 'Österreich', NULL, '[[regtime_]]', NULL),
('jsEzʽ', '/_MpXT|', 'German', 'Austria', NULL, '[[regtime_]]', NULL),
('jsEz˨', 'jlrm%LL7WJ', 'Deutsch', 'Belgien', NULL, '[[regtime_]]', NULL),
('jsEz˨', '/_MpXT|', 'German', 'Belgium', NULL, '[[regtime_]]', NULL),
('jsEz<22', 'jlrm%LL7WJ', 'Deutsch', 'Schweiz', NULL, '[[regtime_]]', NULL),
('jsEz<22', '/_MpXT|', 'German', 'Switzerland', NULL, '[[regtime_]]', NULL),
('jsEzڹD', 'jlrm%LL7WJ', 'Deutsch', 'Liechtenstein', NULL, '[[regtime_]]', NULL),
('jsEzڹD', '/_MpXT|', 'German', 'Liechtenstein', NULL, '[[regtime_]]', NULL),
('jsEz+', 'jlrm%LL7WJ', 'Deutsch', 'Luxemburg', NULL, '[[regtime_]]', NULL),
('jsEz+', '/_MpXT|', 'German', 'Luxemburg', NULL, '[[regtime_]]', NULL),
('jsEzaf[', 'jlrm%LL7WJ', 'Maledivisch', 'Malediven', NULL, '[[regtime_]]', NULL),
('jsEzaf[', '/_MpXT|', 'Maldivian', 'Maldive Islands', NULL, '[[regtime_]]', NULL),
('jsEz͒f', 'jlrm%LL7WJ', 'Bhutanisch', 'Bhutan', NULL, '[[regtime_]]', NULL),
('jsEz͒f', '/_MpXT|', 'Bhutanese', 'Bhutan', NULL, '[[regtime_]]', NULL),
('jsEz', 'jlrm%LL7WJ', 'Ewe-Sprache', 'Ghana', NULL, '[[regtime_]]', NULL),
('jsEz', '/_MpXT|', 'Ewe', 'Ghana', NULL, '[[regtime_]]', NULL),
('jsEzJ', 'jlrm%LL7WJ', 'Ewe-Sprache', 'Togo', NULL, '[[regtime_]]', NULL),
('jsEzJ', '/_MpXT|', 'Ewe', 'Togo', NULL, '[[regtime_]]', NULL),
('jsEzϟA', 'jlrm%LL7WJ', 'Griechisch', 'Zypern', NULL, '[[regtime_]]', NULL),
('jsEzϟA', '/_MpXT|', 'Greek', 'Cyprus', NULL, '[[regtime_]]', NULL),
('jsEzS', 'jlrm%LL7WJ', 'Griechisch', 'Griechenland', NULL, '[[regtime_]]', NULL),
('jsEzS', '/_MpXT|', 'Greek', 'Greece', NULL, '[[regtime_]]', NULL),
('jsEzЇ', 'jlrm%LL7WJ', 'Englisch', 'Amerikanisch-Samoa', NULL, '[[regtime_]]', NULL),
('jsEzЇ', '/_MpXT|', 'English', 'American Samoa', NULL, '[[regtime_]]', NULL),
('jsEzo', 'jlrm%LL7WJ', 'Englisch', 'Australien', NULL, '[[regtime_]]', NULL),
('jsEzo', '/_MpXT|', 'English', 'Australia', NULL, '[[regtime_]]', NULL),
('jsEz', 'jlrm%LL7WJ', 'Englisch', 'Belgien', NULL, '[[regtime_]]', NULL),
('jsEz', '/_MpXT|', 'English', 'Belgium', NULL, '[[regtime_]]', NULL),
('jsEz', 'jlrm%LL7WJ', 'Englisch', 'Botsuana', NULL, '[[regtime_]]', NULL),
('jsEz', '/_MpXT|', 'English', 'Botswana', NULL, '[[regtime_]]', NULL),
('jsEz', 'jlrm%LL7WJ', 'Englisch', 'Belize', NULL, '[[regtime_]]', NULL),
('jsEz', '/_MpXT|', 'English', 'Belize', NULL, '[[regtime_]]', NULL),
('jsEz', 'jlrm%LL7WJ', 'Englisch', 'Kanada', NULL, '[[regtime_]]', NULL),
('jsEz', '/_MpXT|', 'English', 'Canada', NULL, '[[regtime_]]', NULL),
('jsEz(', 'jlrm%LL7WJ', 'Englisch', 'Guam', NULL, '[[regtime_]]', NULL),
('jsEz(', '/_MpXT|', 'English', 'Guam', NULL, '[[regtime_]]', NULL),
('jsEzғ}', 'jlrm%LL7WJ', 'Englisch', 'Sonderverwaltungszone Hongkong', NULL, '[[regtime_]]', NULL),
('jsEzғ}', '/_MpXT|', 'English', 'Hong Kong', NULL, '[[regtime_]]', NULL),
('jsEz', 'jlrm%LL7WJ', 'Englisch', 'Irland', NULL, '[[regtime_]]', NULL),
('jsEz', '/_MpXT|', 'English', 'Ireland', NULL, '[[regtime_]]', NULL),
('jsEzӃ', 'jlrm%LL7WJ', 'Englisch', 'Indien', NULL, '[[regtime_]]', NULL),
('jsEzӃ', '/_MpXT|', 'English', 'India', NULL, '[[regtime_]]', NULL),
('jsEzӑ', 'jlrm%LL7WJ', 'Englisch', 'Jamaika', NULL, '[[regtime_]]', NULL),
('jsEzӑ', '/_MpXT|', 'English', 'Jamaica', NULL, '[[regtime_]]', NULL),
('jsEzі*', 'jlrm%LL7WJ', 'Englisch', 'Marshallinseln', NULL, '[[regtime_]]', NULL),
('jsEzі*', '/_MpXT|', 'English', 'Marshall Islands', NULL, '[[regtime_]]', NULL),
('jsEzاg', 'jlrm%LL7WJ', 'Englisch', 'Nördliche Marianen', NULL, '[[regtime_]]', NULL),
('jsEzاg', '/_MpXT|', 'English', 'Northern Mariana Islands', NULL, '[[regtime_]]', NULL),
('jsEzIHP', 'jlrm%LL7WJ', 'Englisch', 'Malta', NULL, '[[regtime_]]', NULL),
('jsEzIHP', '/_MpXT|', 'English', 'Malta', NULL, '[[regtime_]]', NULL),
('jsEzk', 'jlrm%LL7WJ', 'Englisch', 'Namibia', NULL, '[[regtime_]]', NULL),
('jsEzk', '/_MpXT|', 'English', 'Namibia', NULL, '[[regtime_]]', NULL),
('jsEzoI', 'jlrm%LL7WJ', 'Englisch', 'Neuseeland', NULL, '[[regtime_]]', NULL),
('jsEzoI', '/_MpXT|', 'English', 'New Zealand', NULL, '[[regtime_]]', NULL),
('jsEzA', 'jlrm%LL7WJ', 'Englisch', 'Philippinen', NULL, '[[regtime_]]', NULL),
('jsEzA', '/_MpXT|', 'English', 'Philippines', NULL, '[[regtime_]]', NULL),
('jsEzղ', 'jlrm%LL7WJ', 'Englisch', 'Pakistan', NULL, '[[regtime_]]', NULL),
('jsEzղ', '/_MpXT|', 'English', 'Pakistan', NULL, '[[regtime_]]', NULL),
('jsEz', 'jlrm%LL7WJ', 'Englisch', 'Singapur', NULL, '[[regtime_]]', NULL),
('jsEz', '/_MpXT|', 'English', 'Singapore', NULL, '[[regtime_]]', NULL),
('jsEz֍/:', 'jlrm%LL7WJ', 'Englisch', 'Trinidad und Tobago', NULL, '[[regtime_]]', NULL),
('jsEz֍/:', '/_MpXT|', 'English', 'Trinidad and Tobago', NULL, '[[regtime_]]', NULL),
('jsEzl', 'jlrm%LL7WJ', 'Englisch', 'Amerikanisch-Ozeanien', NULL, '[[regtime_]]', NULL),
('jsEzl', '/_MpXT|', 'English', 'U.S. Minor Outlying Islands', NULL, '[[regtime_]]', NULL),
('jsEz', 'jlrm%LL7WJ', 'Englisch (US)', 'Vereinigte Staaten', NULL, '[[regtime_]]', NULL),
('jsEz', '/_MpXT|', 'English (US)', 'United States', NULL, '[[regtime_]]', NULL),
('jsEz', 'jlrm%LL7WJ', 'Englisch', 'Amerikanische Jungferninseln', NULL, '[[regtime_]]', NULL),
('jsEz', '/_MpXT|', 'English', 'American Virgin Islands', NULL, '[[regtime_]]', NULL),
('jsEz:U', 'jlrm%LL7WJ', 'Englisch', 'Südafrika', NULL, '[[regtime_]]', NULL),
('jsEz:U', '/_MpXT|', 'English', 'South Africa', NULL, '[[regtime_]]', NULL),
('jsEzs', 'jlrm%LL7WJ', 'Englisch', 'Simbabwe', NULL, '[[regtime_]]', NULL),
('jsEzs', '/_MpXT|', 'English', 'Zimbabwe', NULL, '[[regtime_]]', NULL),
('jsEzDq', 'jlrm%LL7WJ', 'Spanisch', 'Argentinien', NULL, '[[regtime_]]', NULL),
('jsEzDq', '/_MpXT|', 'Spanish', 'Argentina', NULL, '[[regtime_]]', NULL),
('jsEza@', 'jlrm%LL7WJ', 'Spanisch', 'Bolivien', NULL, '[[regtime_]]', NULL),
('jsEza@', '/_MpXT|', 'Spanish', 'Bolivia', NULL, '[[regtime_]]', NULL),
('jsEzJ', 'jlrm%LL7WJ', 'Spanisch', 'Chile', NULL, '[[regtime_]]', NULL),
('jsEzJ', '/_MpXT|', 'Spanish', 'Chile', NULL, '[[regtime_]]', NULL),
('jsEzڒ', 'jlrm%LL7WJ', 'Spanisch', 'Kolumbien', NULL, '[[regtime_]]', NULL),
('jsEzڒ', '/_MpXT|', 'Spanish', 'Colombia', NULL, '[[regtime_]]', NULL),
('jsEz9\\', 'jlrm%LL7WJ', 'Spanisch', 'Costa Rica', NULL, '[[regtime_]]', NULL),
('jsEz9\\', '/_MpXT|', 'Spanish', 'Costa Rica', NULL, '[[regtime_]]', NULL),
('jsEz^!', 'jlrm%LL7WJ', 'Spanisch', 'Dominikanische Republik', NULL, '[[regtime_]]', NULL),
('jsEz^!', '/_MpXT|', 'Spanish', 'Dominican Republic', NULL, '[[regtime_]]', NULL),
('jsEzS', 'jlrm%LL7WJ', 'Spanisch', 'Ecuador', NULL, '[[regtime_]]', NULL),
('jsEzS', '/_MpXT|', 'Spanish', 'Ecuador', NULL, '[[regtime_]]', NULL),
('jsEz܉7', 'jlrm%LL7WJ', 'Spanisch', 'Spanien', NULL, '[[regtime_]]', NULL),
('jsEz܉7', '/_MpXT|', 'Spanish', 'Spain', NULL, '[[regtime_]]', NULL),
('jsEzûU', 'jlrm%LL7WJ', 'Spanisch', 'Guatemala', NULL, '[[regtime_]]', NULL),
('jsEzûU', '/_MpXT|', 'Spanish', 'Guatemala', NULL, '[[regtime_]]', NULL),
('jsEz>', 'jlrm%LL7WJ', 'Spanisch', 'Honduras', NULL, '[[regtime_]]', NULL),
('jsEz>', '/_MpXT|', 'Spanish', 'Honduras', NULL, '[[regtime_]]', NULL),
('jsEzݱ@', 'jlrm%LL7WJ', 'Spanisch', 'Mexiko', NULL, '[[regtime_]]', NULL),
('jsEzݱ@', '/_MpXT|', 'Spanish', 'Mexico', NULL, '[[regtime_]]', NULL),
('jsEzr\nY', 'jlrm%LL7WJ', 'Spanisch', 'Nicaragua', NULL, '[[regtime_]]', NULL),
('jsEzr\nY', '/_MpXT|', 'Spanish', 'Nicaragua', NULL, '[[regtime_]]', NULL),
('jsEzވ', 'jlrm%LL7WJ', 'Spanisch', 'Panama', NULL, '[[regtime_]]', NULL),
('jsEzވ', '/_MpXT|', 'Spanish', 'Panama', NULL, '[[regtime_]]', NULL),
('jsEzɭ', 'jlrm%LL7WJ', 'Spanisch', 'Peru', NULL, '[[regtime_]]', NULL),
('jsEzɭ', '/_MpXT|', 'Spanish', 'Peru', NULL, '[[regtime_]]', NULL),
('jsEz7', 'jlrm%LL7WJ', 'Spanisch', 'Puerto Rico', NULL, '[[regtime_]]', NULL),
('jsEz7', '/_MpXT|', 'Spanish', 'Puerto Rico', NULL, '[[regtime_]]', NULL),
('jsEzvH', 'jlrm%LL7WJ', 'Spanisch', 'Paraguay', NULL, '[[regtime_]]', NULL),
('jsEzvH', '/_MpXT|', 'Spanish', 'Paraguay', NULL, '[[regtime_]]', NULL),
('jsEz߂q', 'jlrm%LL7WJ', 'Spanisch', 'El Salvador', NULL, '[[regtime_]]', NULL),
('jsEz߂q', '/_MpXT|', 'Spanish', 'El Salvador', NULL, '[[regtime_]]', NULL),
('jsEzn', 'jlrm%LL7WJ', 'Spanisch', 'Vereinigte Staaten', NULL, '[[regtime_]]', NULL),
('jsEzn', '/_MpXT|', 'Spanish', 'United States', NULL, '[[regtime_]]', NULL),
('jsEz^`', 'jlrm%LL7WJ', 'Spanisch', 'Uruguay', NULL, '[[regtime_]]', NULL),
('jsEz^`', '/_MpXT|', 'Spanish', 'Uruguay', NULL, '[[regtime_]]', NULL),
('jsEzy', 'jlrm%LL7WJ', 'Spanisch', 'Venezuela', NULL, '[[regtime_]]', NULL),
('jsEzy', '/_MpXT|', 'Spanish', 'Venezuela', NULL, '[[regtime_]]', NULL),
('jsEz38', 'jlrm%LL7WJ', 'Estnisch', 'Estland', NULL, '[[regtime_]]', NULL),
('jsEz38', '/_MpXT|', 'Estonian', 'Estonia', NULL, '[[regtime_]]', NULL),
('jsEzẫ', 'jlrm%LL7WJ', 'Baskisch', 'Spanien', NULL, '[[regtime_]]', NULL),
('jsEzẫ', '/_MpXT|', 'Basque', 'Spain', NULL, '[[regtime_]]', NULL),
('jsEzf', 'jlrm%LL7WJ', 'Persisch', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('jsEzf', '/_MpXT|', 'Persian', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('jsEz`', 'jlrm%LL7WJ', 'Persisch', 'Iran', NULL, '[[regtime_]]', NULL),
('jsEz`', '/_MpXT|', 'Persian', 'Iran', NULL, '[[regtime_]]', NULL),
('jsEz', 'jlrm%LL7WJ', 'Finnisch', 'Finnland', NULL, '[[regtime_]]', NULL),
('jsEz', '/_MpXT|', 'Finnish', 'Finland', NULL, '[[regtime_]]', NULL),
('jsEzcw:', 'jlrm%LL7WJ', 'Filipino', 'Philippinen', NULL, '[[regtime_]]', NULL),
('jsEzcw:', '/_MpXT|', 'Filipino', 'Philippines', NULL, '[[regtime_]]', NULL),
('jsEzI', 'jlrm%LL7WJ', 'Färöisch', 'Färöer', NULL, '[[regtime_]]', NULL),
('jsEzI', '/_MpXT|', 'Faeroese', 'Faeroe Islands', NULL, '[[regtime_]]', NULL),
('jsEzk@L', 'jlrm%LL7WJ', 'Französisch', 'Belgien', NULL, '[[regtime_]]', NULL),
('jsEzk@L', '/_MpXT|', 'French', 'Belgium', NULL, '[[regtime_]]', NULL),
('jsEz{\n', 'jlrm%LL7WJ', 'Französisch', 'Kanada', NULL, '[[regtime_]]', NULL),
('jsEz{\n', '/_MpXT|', 'French', 'Canada', NULL, '[[regtime_]]', NULL),
('jsEza', 'jlrm%LL7WJ', 'Französisch', 'Schweiz', NULL, '[[regtime_]]', NULL),
('jsEza', '/_MpXT|', 'French', 'Switzerland', NULL, '[[regtime_]]', NULL),
('jsEzv', 'jlrm%LL7WJ', 'Französisch', 'Frankreich', NULL, '[[regtime_]]', NULL),
('jsEzv', '/_MpXT|', 'French', 'France', NULL, '[[regtime_]]', NULL),
('jsEz', 'jlrm%LL7WJ', 'Französisch', 'Luxemburg', NULL, '[[regtime_]]', NULL),
('jsEz', '/_MpXT|', 'French', 'Luxembourg', NULL, '[[regtime_]]', NULL),
('jsEzL', 'jlrm%LL7WJ', 'Französisch', 'Monaco', NULL, '[[regtime_]]', NULL),
('jsEzL', '/_MpXT|', 'French', 'Monaco', NULL, '[[regtime_]]', NULL),
('jsEzf$', 'jlrm%LL7WJ', 'Französisch', 'Senegal', NULL, '[[regtime_]]', NULL),
('jsEzf$', '/_MpXT|', 'French', 'Senegal', NULL, '[[regtime_]]', NULL),
('jsEz愤f', 'jlrm%LL7WJ', 'Friulisch', 'Italien', NULL, '[[regtime_]]', NULL),
('jsEz愤f', '/_MpXT|', 'Friulian', 'Italy', NULL, '[[regtime_]]', NULL),
('jsEz2\0', 'jlrm%LL7WJ', 'Irisch', 'Irland', NULL, '[[regtime_]]', NULL),
('jsEz2\0', '/_MpXT|', 'Irish', 'Ireland', NULL, '[[regtime_]]', NULL),
('jsEza', 'jlrm%LL7WJ', 'Ga-Sprache', 'Ghana', NULL, '[[regtime_]]', NULL),
('jsEza', '/_MpXT|', 'Ga', 'Ghana', NULL, '[[regtime_]]', NULL),
('jsEz&A', 'jlrm%LL7WJ', 'Geez', 'Eritrea', NULL, '[[regtime_]]', NULL),
('jsEz&A', '/_MpXT|', 'Geez', 'Eritrea', NULL, '[[regtime_]]', NULL),
('jsEz$', 'jlrm%LL7WJ', 'Geez', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('jsEz$', '/_MpXT|', 'Geez', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('jsEzJ', 'jlrm%LL7WJ', 'Galizisch', 'Spanien', NULL, '[[regtime_]]', NULL),
('jsEzJ', '/_MpXT|', 'Galician', 'Spain', NULL, '[[regtime_]]', NULL),
('jsEz', 'jlrm%LL7WJ', 'Schweizerdeutsch', 'Schweiz', NULL, '[[regtime_]]', NULL),
('jsEz', '/_MpXT|', 'Swiss German', 'Switzerland', NULL, '[[regtime_]]', NULL),
('jsEzǐQ', 'jlrm%LL7WJ', 'Gujarati', 'Indien', NULL, '[[regtime_]]', NULL),
('jsEzǐQ', '/_MpXT|', 'Gujarati', 'India', NULL, '[[regtime_]]', NULL),
('jsEz30', 'jlrm%LL7WJ', 'Manx', 'Vereinigtes Königreich', NULL, '[[regtime_]]', NULL),
('jsEz30', '/_MpXT|', 'Manx', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('jsEzv0', 'jlrm%LL7WJ', 'Hausa', 'Ghana', NULL, '[[regtime_]]', NULL),
('jsEzv0', '/_MpXT|', 'Hausa', 'Ghana', NULL, '[[regtime_]]', NULL),
('jsEzb7', 'jlrm%LL7WJ', 'Hausa', 'Niger', NULL, '[[regtime_]]', NULL),
('jsEzb7', '/_MpXT|', 'Hausa', 'Niger', NULL, '[[regtime_]]', NULL),
('jsEz=0', 'jlrm%LL7WJ', 'Hausa', 'Nigeria', NULL, '[[regtime_]]', NULL),
('jsEz=0', '/_MpXT|', 'Hausa', 'Nigeria', NULL, '[[regtime_]]', NULL),
('jsEz', 'jlrm%LL7WJ', 'Hausa', 'Sudan', NULL, '[[regtime_]]', NULL),
('jsEz', '/_MpXT|', 'Hausa', 'Sudan', NULL, '[[regtime_]]', NULL),
('jsEzU', 'jlrm%LL7WJ', 'Hawaiisch', 'Vereinigte Staaten', NULL, '[[regtime_]]', NULL),
('jsEzU', '/_MpXT|', 'Hawaiian', 'United States', NULL, '[[regtime_]]', NULL),
('jsEz땜', 'jlrm%LL7WJ', 'Hebräisch', 'Israel', NULL, '[[regtime_]]', NULL),
('jsEz땜', '/_MpXT|', 'Hebrew', 'Israel', NULL, '[[regtime_]]', NULL),
('jsEzt', 'jlrm%LL7WJ', 'Hindi', 'Indien', NULL, '[[regtime_]]', NULL),
('jsEzt', '/_MpXT|', 'Hindi', 'India', NULL, '[[regtime_]]', NULL),
('jsEz;', 'jlrm%LL7WJ', 'Kroatisch', 'Kroatien', NULL, '[[regtime_]]', NULL),
('jsEz;', '/_MpXT|', 'Croatian', 'Croatia', NULL, '[[regtime_]]', NULL),
('jsEzÂ', 'jlrm%LL7WJ', 'Ungarisch', 'Ungarn', NULL, '[[regtime_]]', NULL),
('jsEzÂ', '/_MpXT|', 'Hungarian', 'Hungary', NULL, '[[regtime_]]', NULL),
('jsEzv', 'jlrm%LL7WJ', 'Armenisch', 'Armenien', NULL, '[[regtime_]]', NULL),
('jsEzv', '/_MpXT|', 'Armenian', 'Armenia', NULL, '[[regtime_]]', NULL),
('jsEz', 'jlrm%LL7WJ', 'Indonesisch', 'Indonesien', NULL, '[[regtime_]]', NULL),
('jsEz', '/_MpXT|', 'Indonesian', 'Indonesia', NULL, '[[regtime_]]', NULL),
('jsEz飼', 'jlrm%LL7WJ', 'Igbo-Sprache', 'Nigeria', NULL, '[[regtime_]]', NULL),
('jsEz飼', '/_MpXT|', 'Igbo', 'Nigeria', NULL, '[[regtime_]]', NULL),
('jsEzu', 'jlrm%LL7WJ', 'Sichuan Yi', 'China', NULL, '[[regtime_]]', NULL),
('jsEzu', '/_MpXT|', 'Sichuan Yi', 'China', NULL, '[[regtime_]]', NULL),
('jsEzu', 'jlrm%LL7WJ', 'Isländisch', 'Island', NULL, '[[regtime_]]', NULL),
('jsEzu', '/_MpXT|', 'Icelandic', 'Iceland', NULL, '[[regtime_]]', NULL),
('jsEzD', 'jlrm%LL7WJ', 'Italienisch', 'Schweiz', NULL, '[[regtime_]]', NULL),
('jsEzD', '/_MpXT|', 'Italian', 'Switzerland', NULL, '[[regtime_]]', NULL),
('jsEz-&', 'jlrm%LL7WJ', 'Italienisch', 'Italien', NULL, '[[regtime_]]', NULL),
('jsEz-&', '/_MpXT|', 'Italian', 'Italy', NULL, '[[regtime_]]', NULL),
('jsEz!', 'jlrm%LL7WJ', 'Japanisch', 'Japan', NULL, '[[regtime_]]', NULL),
('jsEz!', '/_MpXT|', 'Japanese', 'Japan', NULL, '[[regtime_]]', NULL),
('jsEz0!v', 'jlrm%LL7WJ', 'Georgisch', 'Georgien', NULL, '[[regtime_]]', NULL),
('jsEz0!v', '/_MpXT|', 'Georgian', 'Georgia', NULL, '[[regtime_]]', NULL),
('jsEz󰯂', 'jlrm%LL7WJ', 'Jju', 'Nigeria', NULL, '[[regtime_]]', NULL),
('jsEz󰯂', '/_MpXT|', 'Jju', 'Nigeria', NULL, '[[regtime_]]', NULL),
('jsEz&', 'jlrm%LL7WJ', 'Kamba', 'Kenia', NULL, '[[regtime_]]', NULL),
('jsEz&', '/_MpXT|', 'Kamba', 'Kenya', NULL, '[[regtime_]]', NULL),
('jsEz%v', 'jlrm%LL7WJ', 'Tyap', 'Nigeria', NULL, '[[regtime_]]', NULL),
('jsEz%v', '/_MpXT|', 'Tyap', 'Nigeria', NULL, '[[regtime_]]', NULL),
('jsEz)', 'jlrm%LL7WJ', 'Koro', 'Elfenbeinküste', NULL, '[[regtime_]]', NULL),
('jsEz)', '/_MpXT|', 'Koro', 'Ivory Coast', NULL, '[[regtime_]]', NULL),
('jsEzhQ', 'jlrm%LL7WJ', 'Kasachisch', 'Kasachstan', NULL, '[[regtime_]]', NULL),
('jsEzhQ', '/_MpXT|', 'Kazakh', 'Kazakhstan', NULL, '[[regtime_]]', NULL),
('jsEz|', 'jlrm%LL7WJ', 'Grönländisch', 'Grönland', NULL, '[[regtime_]]', NULL),
('jsEz|', '/_MpXT|', 'Greenlandic', 'Greenland', NULL, '[[regtime_]]', NULL),
('jsEzv2', 'jlrm%LL7WJ', 'Kambodschanisch', 'Kambodscha', NULL, '[[regtime_]]', NULL),
('jsEzv2', '/_MpXT|', 'Cambodian', 'Cambodia', NULL, '[[regtime_]]', NULL),
('jsEzz', 'jlrm%LL7WJ', 'Kannada', 'Indien', NULL, '[[regtime_]]', NULL),
('jsEzz', '/_MpXT|', 'Kannada', 'India', NULL, '[[regtime_]]', NULL),
('jsEz@	', 'jlrm%LL7WJ', 'Koreanisch', 'Republik Korea', NULL, '[[regtime_]]', NULL),
('jsEz@	', '/_MpXT|', 'Korean', 'Republic of Korea', NULL, '[[regtime_]]', NULL),
('jsEz"m', 'jlrm%LL7WJ', 'Konkani', 'Indien', NULL, '[[regtime_]]', NULL),
('jsEz"m', '/_MpXT|', 'Konkani', 'India', NULL, '[[regtime_]]', NULL),
('jsEzp', 'jlrm%LL7WJ', 'Kpelle-Sprache', 'Guinea', NULL, '[[regtime_]]', NULL),
('jsEzp', '/_MpXT|', 'Kpelle', 'Guinea', NULL, '[[regtime_]]', NULL),
('jsEzU#0', 'jlrm%LL7WJ', 'Kpelle-Sprache', 'Liberia', NULL, '[[regtime_]]', NULL),
('jsEzU#0', '/_MpXT|', 'Kpelle', 'Liberia', NULL, '[[regtime_]]', NULL),
('jsEzn\Z', 'jlrm%LL7WJ', 'Kurdisch', 'Irak', NULL, '[[regtime_]]', NULL),
('jsEzn\Z', '/_MpXT|', 'Kurdish', 'Iraq', NULL, '[[regtime_]]', NULL),
('jsEzQ', 'jlrm%LL7WJ', 'Kurdisch', 'Iran', NULL, '[[regtime_]]', NULL),
('jsEzQ', '/_MpXT|', 'Kurdish', 'Iran', NULL, '[[regtime_]]', NULL),
('jsEz1/', 'jlrm%LL7WJ', 'Kurdisch', 'Syrien', NULL, '[[regtime_]]', NULL),
('jsEz1/', '/_MpXT|', 'Kurdish', 'Syria', NULL, '[[regtime_]]', NULL),
('jsEzNO', 'jlrm%LL7WJ', 'Kurdisch', 'Türkei', NULL, '[[regtime_]]', NULL),
('jsEzNO', '/_MpXT|', 'Kurdish', 'Turkey', NULL, '[[regtime_]]', NULL),
('jsEz\0d', 'jlrm%LL7WJ', 'Kornisch', 'Vereinigtes Königreich', NULL, '[[regtime_]]', NULL),
('jsEz\0d', '/_MpXT|', 'Cornish', 'United Kingdom', NULL, '[[regtime_]]', NULL),
('jsEz', 'jlrm%LL7WJ', 'Kirgisisch', 'Kirgisistan', NULL, '[[regtime_]]', NULL),
('jsEz', '/_MpXT|', 'Kirghiz', 'Kyrgyzstan', NULL, '[[regtime_]]', NULL),
('jsEz&@', 'jlrm%LL7WJ', 'Lingala', 'Demokratische Republik Kongo', NULL, '[[regtime_]]', NULL),
('jsEz&@', '/_MpXT|', 'Lingala', 'Democratic Republic of the Congo', NULL, '[[regtime_]]', NULL),
('jsEzx', 'jlrm%LL7WJ', 'Lingala', 'Kongo', NULL, '[[regtime_]]', NULL),
('jsEzx', '/_MpXT|', 'Lingala', 'Congo', NULL, '[[regtime_]]', NULL),
('jsEzKmF', 'jlrm%LL7WJ', 'Laotisch', 'Laos', NULL, '[[regtime_]]', NULL),
('jsEzKmF', '/_MpXT|', 'Lao', 'Laos', NULL, '[[regtime_]]', NULL),
('jsEzY', 'jlrm%LL7WJ', 'Litauisch', 'Litauen', NULL, '[[regtime_]]', NULL),
('jsEzY', '/_MpXT|', 'Lithuanian', 'Lithuania', NULL, '[[regtime_]]', NULL),
('jsEzj', 'jlrm%LL7WJ', 'Lettisch', 'Lettland', NULL, '[[regtime_]]', NULL),
('jsEzj', '/_MpXT|', 'Latvian', 'Latvia', NULL, '[[regtime_]]', NULL),
('jsEz.', 'jlrm%LL7WJ', 'Mazedonisch', 'Mazedonien', NULL, '[[regtime_]]', NULL),
('jsEz.', '/_MpXT|', 'Macedonian', 'Macedonia', NULL, '[[regtime_]]', NULL),
('jsEzK', 'jlrm%LL7WJ', 'Malayalam', 'Indien', NULL, '[[regtime_]]', NULL),
('jsEzK', '/_MpXT|', 'Malayalam', 'India', NULL, '[[regtime_]]', NULL),
('jsEzY@', 'jlrm%LL7WJ', 'Mongolisch', 'China', NULL, '[[regtime_]]', NULL),
('jsEzY@', '/_MpXT|', 'Mongol', 'China', NULL, '[[regtime_]]', NULL),
('jsE{\0SF', 'jlrm%LL7WJ', 'Mongolisch', 'Mongolei', NULL, '[[regtime_]]', NULL),
('jsE{\0SF', '/_MpXT|', 'Mongol', 'Mongolia', NULL, '[[regtime_]]', NULL),
('jsE{"ڧ', 'jlrm%LL7WJ', 'Marathi', 'Indien', NULL, '[[regtime_]]', NULL),
('jsE{"ڧ', '/_MpXT|', 'Marathi', 'India', NULL, '[[regtime_]]', NULL),
('jsE{', 'jlrm%LL7WJ', 'Malaiisch', 'Brunei Darussalam', NULL, '[[regtime_]]', NULL),
('jsE{', '/_MpXT|', 'Malay', 'Brunei Darussalam', NULL, '[[regtime_]]', NULL),
('jsE{8K', 'jlrm%LL7WJ', 'Malaiisch', 'Malaysia', NULL, '[[regtime_]]', NULL),
('jsE{8K', '/_MpXT|', 'Malay', 'Malaysia', NULL, '[[regtime_]]', NULL),
('jsE{R', 'jlrm%LL7WJ', 'Maltesisch', 'Malta', NULL, '[[regtime_]]', NULL),
('jsE{R', '/_MpXT|', 'Maltese', 'Malta', NULL, '[[regtime_]]', NULL),
('jsE{', 'jlrm%LL7WJ', 'Birmanisch', 'Myanmar', NULL, '[[regtime_]]', NULL),
('jsE{', '/_MpXT|', 'Burmese', 'Myanmar', NULL, '[[regtime_]]', NULL),
('jsE{RVU', 'jlrm%LL7WJ', 'Norwegisch Bokmål', 'Norwegen', NULL, '[[regtime_]]', NULL),
('jsE{RVU', '/_MpXT|', 'Norwegian Bokmål', 'Norway', NULL, '[[regtime_]]', NULL),
('jsE{~V', 'jlrm%LL7WJ', 'Niederdeutsch', 'Deutschland', NULL, '[[regtime_]]', NULL),
('jsE{~V', '/_MpXT|', 'Low German', 'Germany', NULL, '[[regtime_]]', NULL),
('jsE{', 'jlrm%LL7WJ', 'Nepalesisch', 'Indien', NULL, '[[regtime_]]', NULL),
('jsE{', '/_MpXT|', 'Nepalese', 'India', NULL, '[[regtime_]]', NULL),
('jsE{l_', 'jlrm%LL7WJ', 'Nepalesisch', 'Nepal', NULL, '[[regtime_]]', NULL),
('jsE{l_', '/_MpXT|', 'Nepalese', 'Nepal', NULL, '[[regtime_]]', NULL),
('jsE{.', 'jlrm%LL7WJ', 'Niederländisch', 'Belgien', NULL, '[[regtime_]]', NULL),
('jsE{.', '/_MpXT|', 'Dutch', 'Belgium', NULL, '[[regtime_]]', NULL),
('jsE{Z', 'jlrm%LL7WJ', 'Niederländisch', 'Niederlande', NULL, '[[regtime_]]', NULL),
('jsE{Z', '/_MpXT|', 'Dutch', 'Netherlands', NULL, '[[regtime_]]', NULL),
('jsE{', 'jlrm%LL7WJ', 'Norwegisch Nynorsk', 'Norwegen', NULL, '[[regtime_]]', NULL),
('jsE{', '/_MpXT|', 'Norwegian Nynorsk', 'Norway', NULL, '[[regtime_]]', NULL),
('jsE{o', 'jlrm%LL7WJ', 'Süd-Ndebele-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('jsE{o', '/_MpXT|', 'Southern Ndebele', 'South Africa', NULL, '[[regtime_]]', NULL),
('jsE{ӏ6', 'jlrm%LL7WJ', 'Nord-Sotho-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('jsE{ӏ6', '/_MpXT|', 'Northern Sotho language', 'South Africa', NULL, '[[regtime_]]', NULL),
('js{Jwj', 'jlrm%LL7WJ', 'Nyanja-Sprache', 'Malawi', NULL, '[[regtime_]]', NULL),
('js{Jwj', '/_MpXT|', 'Nyanja', 'Malawi', NULL, '[[regtime_]]', NULL),
('js{Kf', 'jlrm%LL7WJ', 'Okzitanisch', 'Frankreich', NULL, '[[regtime_]]', NULL),
('js{Kf', '/_MpXT|', 'Occitan', 'France', NULL, '[[regtime_]]', NULL),
('js{Ұ', 'jlrm%LL7WJ', 'Oromo', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('js{Ұ', '/_MpXT|', 'Oromo', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('js{"', 'jlrm%LL7WJ', 'Oromo', 'Kenia', NULL, '[[regtime_]]', NULL),
('js{"', '/_MpXT|', 'Oromo', 'Kenya', NULL, '[[regtime_]]', NULL),
('js{c\Z', 'jlrm%LL7WJ', 'Orija', 'Indien', NULL, '[[regtime_]]', NULL),
('js{c\Z', '/_MpXT|', 'Orija', 'India', NULL, '[[regtime_]]', NULL),
('js{', 'jlrm%LL7WJ', 'Pandschabisch', 'Indien', NULL, '[[regtime_]]', NULL),
('js{', '/_MpXT|', 'Punjabi', 'India', NULL, '[[regtime_]]', NULL),
('js{6', 'jlrm%LL7WJ', 'Pandschabisch', 'Pakistan', NULL, '[[regtime_]]', NULL),
('js{6', '/_MpXT|', 'Punjabi', 'Pakistan', NULL, '[[regtime_]]', NULL),
('js{-oS', 'jlrm%LL7WJ', 'Polnisch', 'Polen', NULL, '[[regtime_]]', NULL),
('js{-oS', '/_MpXT|', 'Polish', 'Poland', NULL, '[[regtime_]]', NULL),
('js{}', 'jlrm%LL7WJ', 'Paschtu', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('js{}', '/_MpXT|', 'Pashto', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('js{Ob', 'jlrm%LL7WJ', 'Portugiesisch', 'Brasilien', NULL, '[[regtime_]]', NULL),
('js{Ob', '/_MpXT|', 'Portuguese', 'Brazil', NULL, '[[regtime_]]', NULL),
('js{Q-', 'jlrm%LL7WJ', 'Portugiesisch', 'Portugal', NULL, '[[regtime_]]', NULL),
('js{Q-', '/_MpXT|', 'Portuguese', 'Portugal', NULL, '[[regtime_]]', NULL),
('js{', 'jlrm%LL7WJ', 'Rumänisch', 'Republik Moldau', NULL, '[[regtime_]]', NULL),
('js{', '/_MpXT|', 'Romanian', 'Republic of Moldova', NULL, '[[regtime_]]', NULL),
('js{6Z', 'jlrm%LL7WJ', 'Rumänisch', 'Rumänien', NULL, '[[regtime_]]', NULL),
('js{6Z', '/_MpXT|', 'Romanian', 'Romania', NULL, '[[regtime_]]', NULL),
('js{a', 'jlrm%LL7WJ', 'Russisch', 'Russische Föderation', NULL, '[[regtime_]]', NULL),
('js{a', '/_MpXT|', 'Russian', 'Russian Federation', NULL, '[[regtime_]]', NULL),
('js{x', 'jlrm%LL7WJ', 'Russisch', 'Ukraine', NULL, '[[regtime_]]', NULL),
('js{x', '/_MpXT|', 'Russian', 'Ukraine', NULL, '[[regtime_]]', NULL),
('js{Ԫ', 'jlrm%LL7WJ', 'Ruandisch', 'Ruanda', NULL, '[[regtime_]]', NULL),
('js{Ԫ', '/_MpXT|', 'Rwandan', 'Rwanda', NULL, '[[regtime_]]', NULL),
('js{L', 'jlrm%LL7WJ', 'Sanskrit', 'Indien', NULL, '[[regtime_]]', NULL),
('js{L', '/_MpXT|', 'Sanskrit', 'India', NULL, '[[regtime_]]', NULL),
('js{', 'jlrm%LL7WJ', 'Nord-Samisch', 'Finnland', NULL, '[[regtime_]]', NULL),
('js{', '/_MpXT|', 'Northen Samian', 'Finland', NULL, '[[regtime_]]', NULL),
('js{Dx', 'jlrm%LL7WJ', 'Nord-Samisch', 'Norwegen', NULL, '[[regtime_]]', NULL),
('js{Dx', '/_MpXT|', 'Northen Samian', 'Norway', NULL, '[[regtime_]]', NULL),
('js{@', 'jlrm%LL7WJ', 'Serbo-Kroatisch', 'Bosnien und Herzegowina', NULL, '[[regtime_]]', NULL),
('js{@', '/_MpXT|', 'Serbo-Croat', 'Bosnia and Herzegovina', NULL, '[[regtime_]]', NULL),
('js{.', 'jlrm%LL7WJ', 'Serbo-Kroatisch', 'Serbien und Montenegro', NULL, '[[regtime_]]', NULL),
('js{.', '/_MpXT|', 'Serbo-Croat', 'Serbia and Montenegro', NULL, '[[regtime_]]', NULL),
('js{B:', 'jlrm%LL7WJ', 'Singhalesisch', 'Sri Lanka', NULL, '[[regtime_]]', NULL),
('js{B:', '/_MpXT|', 'Singhalese', 'Sri Lanka', NULL, '[[regtime_]]', NULL),
('js{	Q', 'jlrm%LL7WJ', 'Sidamo', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('js{	Q', '/_MpXT|', 'Sidamo', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('js{', 'jlrm%LL7WJ', 'Slowakisch', 'Slowakei', NULL, '[[regtime_]]', NULL),
('js{', '/_MpXT|', 'Slovak', 'Slovakia', NULL, '[[regtime_]]', NULL),
('js{2', 'jlrm%LL7WJ', 'Slowenisch', 'Slowenien', NULL, '[[regtime_]]', NULL),
('js{2', '/_MpXT|', 'Slovene', 'Slovenia', NULL, '[[regtime_]]', NULL),
('js{vHs', 'jlrm%LL7WJ', 'Somali', 'Dschibuti', NULL, '[[regtime_]]', NULL),
('js{vHs', '/_MpXT|', 'Somali', 'Djibouti', NULL, '[[regtime_]]', NULL),
('js{9', 'jlrm%LL7WJ', 'Somali', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('js{9', '/_MpXT|', 'Somali', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('js{.	', 'jlrm%LL7WJ', 'Somali', 'Kenia', NULL, '[[regtime_]]', NULL),
('js{.	', '/_MpXT|', 'Somali', 'Kenya', NULL, '[[regtime_]]', NULL),
('js{', 'jlrm%LL7WJ', 'Somali', 'Somalia', NULL, '[[regtime_]]', NULL),
('js{', '/_MpXT|', 'Somali', 'Somalia', NULL, '[[regtime_]]', NULL),
('js{:L', 'jlrm%LL7WJ', 'Albanisch', 'Albanien', NULL, '[[regtime_]]', NULL),
('js{:L', '/_MpXT|', 'Albanian', 'Albania', NULL, '[[regtime_]]', NULL),
('js{@', 'jlrm%LL7WJ', 'Serbisch', 'Bosnien und Herzegowina', NULL, '[[regtime_]]', NULL),
('js{@', '/_MpXT|', 'Serbian', 'Bosnia and Herzegovina', NULL, '[[regtime_]]', NULL),
('js{w%k', 'jlrm%LL7WJ', 'Serbisch', 'Serbien und Montenegro', NULL, '[[regtime_]]', NULL),
('js{w%k', '/_MpXT|', 'Serbian', 'Serbia and Montenegro', NULL, '[[regtime_]]', NULL),
('js{I8', 'jlrm%LL7WJ', 'Serbisch', 'Montenegro', NULL, '[[regtime_]]', NULL),
('js{I8', '/_MpXT|', 'Serbian', 'Montenegro', NULL, '[[regtime_]]', NULL),
('js{c', 'jlrm%LL7WJ', 'Serbisch', 'Serbien', NULL, '[[regtime_]]', NULL),
('js{c', '/_MpXT|', 'Serbian', 'Serbia', NULL, '[[regtime_]]', NULL),
('js{֗', 'jlrm%LL7WJ', 'Swazi', 'Swasiland', NULL, '[[regtime_]]', NULL),
('js{֗', '/_MpXT|', 'Swazi', 'Swaziland', NULL, '[[regtime_]]', NULL),
('js{', 'jlrm%LL7WJ', 'Swazi', 'Südafrika', NULL, '[[regtime_]]', NULL),
('js{', '/_MpXT|', 'Swazi', 'South Africa', NULL, '[[regtime_]]', NULL),
('js{Tz', 'jlrm%LL7WJ', 'Süd-Sotho-Sprache', 'Lesotho', NULL, '[[regtime_]]', NULL),
('js{Tz', '/_MpXT|', 'Southern Sotho Language', 'Lesotho', NULL, '[[regtime_]]', NULL),
('js{bG', 'jlrm%LL7WJ', 'Süd-Sotho-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('js{bG', '/_MpXT|', 'Southern Sotho Language', 'South Africa', NULL, '[[regtime_]]', NULL),
('js{֔', 'jlrm%LL7WJ', 'Schwedisch', 'Finnland', NULL, '[[regtime_]]', NULL),
('js{֔', '/_MpXT|', 'Swedish', 'Finland', NULL, '[[regtime_]]', NULL),
('js{', 'jlrm%LL7WJ', 'Schwedisch', 'Schweden', NULL, '[[regtime_]]', NULL),
('js{', '/_MpXT|', 'Swedish', 'Sweden', NULL, '[[regtime_]]', NULL),
('js{q', 'jlrm%LL7WJ', 'Suaheli', 'Kenia', NULL, '[[regtime_]]', NULL),
('js{q', '/_MpXT|', 'Swahili', 'Kenya', NULL, '[[regtime_]]', NULL),
('js{7K', 'jlrm%LL7WJ', 'Suaheli', 'Tansania', NULL, '[[regtime_]]', NULL),
('js{7K', '/_MpXT|', 'Swahili', 'Tanzania', NULL, '[[regtime_]]', NULL),
('js{O', 'jlrm%LL7WJ', 'Syrisch', 'Syrien', NULL, '[[regtime_]]', NULL),
('js{O', '/_MpXT|', 'Syriac', 'Syria', NULL, '[[regtime_]]', NULL),
('js{I', 'jlrm%LL7WJ', 'Tamilisch', 'Indien', NULL, '[[regtime_]]', NULL),
('js{I', '/_MpXT|', 'Tamil', 'India', NULL, '[[regtime_]]', NULL),
('js{kQ', 'jlrm%LL7WJ', 'Telugu', 'Indien', NULL, '[[regtime_]]', NULL),
('js{kQ', '/_MpXT|', 'Telugu', 'India', NULL, '[[regtime_]]', NULL),
('js{\0', 'jlrm%LL7WJ', 'Tadschikisch', 'Tadschikistan', NULL, '[[regtime_]]', NULL),
('js{\0', '/_MpXT|', 'Tadjik', 'Tajikistan', NULL, '[[regtime_]]', NULL),
('js{.2{', 'jlrm%LL7WJ', 'Thailändisch', 'Thailand', NULL, '[[regtime_]]', NULL),
('js{.2{', '/_MpXT|', 'Thai', 'Thailand', NULL, '[[regtime_]]', NULL),
('js{&', 'jlrm%LL7WJ', 'Tigrinja', 'Eritrea', NULL, '[[regtime_]]', NULL),
('js{&', '/_MpXT|', 'Tigrinya', 'Eritrea', NULL, '[[regtime_]]', NULL),
('js{', 'jlrm%LL7WJ', 'Tigrinja', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('js{', '/_MpXT|', 'Tigrinya', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('js{|v', 'jlrm%LL7WJ', 'Tigre', 'Eritrea', NULL, '[[regtime_]]', NULL),
('js{|v', '/_MpXT|', 'Tigre', 'Eritrea', NULL, '[[regtime_]]', NULL),
('js{', 'jlrm%LL7WJ', 'Tswana-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('js{', '/_MpXT|', 'Tswana Language', 'South Africa', NULL, '[[regtime_]]', NULL),
('js{', 'jlrm%LL7WJ', 'Tongaisch', 'Tonga', NULL, '[[regtime_]]', NULL),
('js{', '/_MpXT|', 'Tongan', 'Tonga', NULL, '[[regtime_]]', NULL),
('js{\0G', 'jlrm%LL7WJ', 'Türkisch', 'Türkei', NULL, '[[regtime_]]', NULL),
('js{\0G', '/_MpXT|', 'Turkish', 'Turkey', NULL, '[[regtime_]]', NULL),
('js{P', 'jlrm%LL7WJ', 'Tsonga', 'Südafrika', NULL, '[[regtime_]]', NULL),
('js{P', '/_MpXT|', 'Tsonga', 'South Africa', NULL, '[[regtime_]]', NULL),
('js{$', 'jlrm%LL7WJ', 'Tatarisch', 'Russische Föderation', NULL, '[[regtime_]]', NULL),
('js{$', '/_MpXT|', 'Tartar', 'Russian Federation', NULL, '[[regtime_]]', NULL),
('js{2/', 'jlrm%LL7WJ', 'Uigurisch', 'China', NULL, '[[regtime_]]', NULL),
('js{2/', '/_MpXT|', 'Uighur', 'China', NULL, '[[regtime_]]', NULL),
('js{+F', 'jlrm%LL7WJ', 'Ukrainisch', 'Ukraine', NULL, '[[regtime_]]', NULL),
('js{+F', '/_MpXT|', 'Ukrainian', 'Ukraine', NULL, '[[regtime_]]', NULL),
('js{/n', 'jlrm%LL7WJ', 'Urdu', 'Indien', NULL, '[[regtime_]]', NULL),
('js{/n', '/_MpXT|', 'Urdu', 'India', NULL, '[[regtime_]]', NULL),
('js{	h', 'jlrm%LL7WJ', 'Urdu', 'Pakistan', NULL, '[[regtime_]]', NULL),
('js{	h', '/_MpXT|', 'Urdu', 'Pakistan', NULL, '[[regtime_]]', NULL),
('js{|', 'jlrm%LL7WJ', 'Usbekisch', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('js{|', '/_MpXT|', 'Uzbek', 'Afghanistan', NULL, '[[regtime_]]', NULL),
('js{,', 'jlrm%LL7WJ', 'Usbekisch', 'Usbekistan', NULL, '[[regtime_]]', NULL),
('js{,', '/_MpXT|', 'Uzbek', 'Uzbekistan', NULL, '[[regtime_]]', NULL);
INSERT INTO `locale_translation` VALUES
('js{', 'jlrm%LL7WJ', 'Venda-Sprache', 'Südafrika', NULL, '[[regtime_]]', NULL),
('js{', '/_MpXT|', 'Venda Language', 'South Africa', NULL, '[[regtime_]]', NULL),
('js{@', 'jlrm%LL7WJ', 'Vietnamesisch', 'Vietnam', NULL, '[[regtime_]]', NULL),
('js{@', '/_MpXT|', 'Vietnamese', 'Vietnam', NULL, '[[regtime_]]', NULL),
('js{', 'jlrm%LL7WJ', 'Walamo-Sprache', 'Äthiopien', NULL, '[[regtime_]]', NULL),
('js{', '/_MpXT|', 'Walamo Language', 'Ethiopia', NULL, '[[regtime_]]', NULL),
('js{kE]', 'jlrm%LL7WJ', 'Wolof', 'Senegal', NULL, '[[regtime_]]', NULL),
('js{kE]', '/_MpXT|', 'Wolof', 'Senegal', NULL, '[[regtime_]]', NULL),
('js{Ěc', 'jlrm%LL7WJ', 'Xhosa', 'Südafrika', NULL, '[[regtime_]]', NULL),
('js{Ěc', '/_MpXT|', 'Xhosa', 'South Africa', NULL, '[[regtime_]]', NULL),
('js{*t', 'jlrm%LL7WJ', 'Yoruba', 'Nigeria', NULL, '[[regtime_]]', NULL),
('js{*t', '/_MpXT|', 'Yoruba', 'Nigeria', NULL, '[[regtime_]]', NULL),
('js{;T', 'jlrm%LL7WJ', 'Chinesisch', 'China', NULL, '[[regtime_]]', NULL),
('js{;T', '/_MpXT|', 'Chinese', 'China', NULL, '[[regtime_]]', NULL),
('js{Ň~', 'jlrm%LL7WJ', 'Chinesisch', 'Sonderverwaltungszone Hongkong', NULL, '[[regtime_]]', NULL),
('js{Ň~', '/_MpXT|', 'Chinese', 'Hong Kong', NULL, '[[regtime_]]', NULL),
('js{2', 'jlrm%LL7WJ', 'Chinesisch', 'Sonderverwaltungszone Macao', NULL, '[[regtime_]]', NULL),
('js{2', '/_MpXT|', 'Chinese', 'Macao', NULL, '[[regtime_]]', NULL),
('js{', 'jlrm%LL7WJ', 'Chinesisch', 'Singapur', NULL, '[[regtime_]]', NULL),
('js{', '/_MpXT|', 'Chinese', 'Singapur', NULL, '[[regtime_]]', NULL),
('js{w', 'jlrm%LL7WJ', 'Chinesisch', 'Taiwan', NULL, '[[regtime_]]', NULL),
('js{w', '/_MpXT|', 'Chinese', 'Taiwan', NULL, '[[regtime_]]', NULL),
('js{ǊW', 'jlrm%LL7WJ', 'Zulu', 'Südafrika', NULL, '[[regtime_]]', NULL),
('js{ǊW', '/_MpXT|', 'Zulu', 'South Africa', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `log_entry`
--

CREATE TABLE `log_entry` (
  `id` binary(16) NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `level` smallint NOT NULL,
  `channel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `context` json DEFAULT NULL,
  `extra` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx.log_entry.created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `mail_header_footer`
--

CREATE TABLE `mail_header_footer` (
  `id` binary(16) NOT NULL,
  `system_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_header_footer`
--

INSERT INTO `mail_header_footer` VALUES
('!pV\rr\0', 1, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mail_header_footer_translation`
--

CREATE TABLE `mail_header_footer_translation` (
  `mail_header_footer_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `header_html` longtext COLLATE utf8mb4_unicode_ci,
  `header_plain` longtext COLLATE utf8mb4_unicode_ci,
  `footer_html` longtext COLLATE utf8mb4_unicode_ci,
  `footer_plain` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`mail_header_footer_id`,`language_id`),
  KEY `fk.mail_header_footer_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_header_footer_translation`
--

INSERT INTO `mail_header_footer_translation` VALUES
('!pV\rr\0', 'jlrm%LL7WJ', 'Standard-E-Mail-Fußzeile', 'Standard-E-Mail-Fußzeile basierend auf den Stammdaten', NULL, NULL, '<div style="font-family:arial; font-size:12px;">\n    Adresse:<br>\n    {{ config(''core.basicInformation.address'')|raw }}\n    <br>\n    Bankverbindung:<br>\n    {{ config(''core.basicInformation.bankAccount'')|raw }}\n</div>\n', '\n\n        Adresse:\n        {{ config(''core.basicInformation.address'')|striptags(''<br>'')|replace({"<br>":"\\n"}) }}\n\n        Bankverbindung:\n        {{ config(''core.basicInformation.bankAccount'')|striptags(''<br>'')|replace({"<br>":"\\n"}) }}\n', '[[regtime_]]', NULL),
('!pV\rr\0', '/_MpXT|', 'Default email footer', 'Default email footer derived from basic information', NULL, NULL, '<div style="font-family:arial; font-size:12px;">\n    Address:<br>\n    {{ config(''core.basicInformation.address'')|raw }}\n    <br>\n    Bank account:<br>\n    {{ config(''core.basicInformation.bankAccount'')|raw }}\n</div>\n', '\n\n        Address:\n        {{ config(''core.basicInformation.address'')|striptags(''<br>'')|replace({"<br>":"\\n"}) }}\n\n        Bank account:\n        {{ config(''core.basicInformation.bankAccount'')|striptags(''<br>'')|replace({"<br>":"\\n"}) }}\n', '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mail_template`
--

CREATE TABLE `mail_template` (
  `id` binary(16) NOT NULL,
  `mail_template_type_id` binary(16) DEFAULT NULL,
  `system_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk.mail_template.mail_template_type_id` (`mail_template_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_template`
--

INSERT INTO `mail_template` VALUES
('xpvWxT', 'wp88ț', 1, '[[regtime_]]', NULL),
('xpvWx''P', 'wp88', 1, '[[regtime_]]', NULL),
('z<rŨH59P;', 'wp88F', 1, '[[regtime_]]', NULL),
('zPsz\r', 'wp884', 1, '[[regtime_]]', NULL),
('z_rѾ', 'wp88h1', 1, '[[regtime_]]', NULL),
('ztr>dnү%K', 'wp88', 1, '[[regtime_]]', NULL),
('z}sŮM', 'wp88L', 1, '[[regtime_]]', NULL),
('	ruma', 'q{Z$', 1, '[[regtime_]]', NULL),
('s|\0O5<', 'q*0', 1, '[[regtime_]]', NULL),
('r{V2z', 'q?G<~', 1, '[[regtime_]]', NULL),
('RrAup5', 'wp88Α', 1, '[[regtime_]]', NULL),
('eqH	<', 'wp88ł', 1, '[[regtime_]]', NULL),
('vru', 'wp88A&x', 1, '[[regtime_]]', NULL),
('s\nI%', 'wp88=', 1, '[[regtime_]]', NULL),
('rEIe', 'wp88ϫ ', 1, '[[regtime_]]', NULL),
('s:a', 'wp88f', 1, '[[regtime_]]', NULL),
('pϪFUղ', 'wp88', 1, '[[regtime_]]', NULL),
('sW$', 'wp88z', 1, '[[regtime_]]', NULL),
('s|Va:', 'wp88#''e', 1, '[[regtime_]]', NULL),
('qsl(\n', 'wp88ӌ2', 1, '[[regtime_]]', NULL),
('qȽiҢ', 'wp88\09', 1, '[[regtime_]]', NULL),
('sՈ2^$C', 'wp88', 1, '[[regtime_]]', NULL),
('pCq6۞', 'wp88', 1, '[[regtime_]]', NULL),
('-r)#J>\ZD', 'wp88', 1, '[[regtime_]]', NULL),
('9r-[1{', 'wp88i', 1, '[[regtime_]]', NULL),
('Jq\0/*', 'wp88', 1, '[[regtime_]]', NULL),
('pŵ}\r6z', 'pŵ}', 1, '[[regtime_]]', NULL),
('rgR)', 'rg\0', 1, '[[regtime_]]', NULL),
('csЇn\nXV', 'Wr2=R3', 1, '[[regtime_]]', NULL),
('rԛ', 'vplSA', 1, '[[regtime_]]', NULL),
('7pΒ2a2\Z', '7pΒ2`B0', 1, '[[regtime_]]', NULL),
('7pΒ2b\r6', '7pΒ2aL', 1, '[[regtime_]]', NULL),
('7pΒ2b', '7pΒ2bX ', 1, '[[regtime_]]', NULL),
('7pΒ2d9', '7pΒ2cHi', 1, '[[regtime_]]', NULL),
('V[r`0"', 'VNsW-t\\', 1, '[[regtime_]]', NULL),
('qrĹ(o', 'qrĹ(C', 1, '[[regtime_]]', NULL),
('rff4?', 'qڤ#', 1, '[[regtime_]]', NULL),
('r`', 'p|,', 1, '[[regtime_]]', NULL),
('6rm#X', ',p|v|3', 1, '[[regtime_]]', NULL),
('Gs޾+r', '+sst9n', 1, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mail_template_media`
--

CREATE TABLE `mail_template_media` (
  `id` binary(16) NOT NULL,
  `mail_template_id` binary(16) NOT NULL,
  `language_id` binary(16) DEFAULT NULL,
  `media_id` binary(16) NOT NULL,
  `position` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `fk.mail_template_media.mail_template_id` (`mail_template_id`),
  KEY `fk.mail_template_media.media_id` (`media_id`),
  KEY `fk.mail_template_media.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `mail_template_translation`
--

CREATE TABLE `mail_template_translation` (
  `mail_template_id` binary(16) NOT NULL,
  `language_id` binary(16) NOT NULL,
  `sender_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `content_html` longtext COLLATE utf8mb4_unicode_ci,
  `content_plain` longtext COLLATE utf8mb4_unicode_ci,
  `custom_fields` json DEFAULT NULL,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  PRIMARY KEY (`mail_template_id`,`language_id`),
  KEY `fk.mail_template_translation.language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_template_translation`
--

INSERT INTO `mail_template_translation` VALUES
('xpvWxT', 'jlrm%LL7WJ', '{{ salesChannel.translated.name }}', 'Newsletter', '', '<h3>Hallo {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}</h3>\n                <p>Schön, dass Sie sich für unseren Newsletter interessieren!</p>\n                <p>Um einem Missbrauch Ihrer E-Mail-Adresse vorzubeugen, haben wir Ihnen diese Bestätigungsmail gesendet. Bestätigen Sie, dass Sie den Newsletter regelmäßig erhalten wollen, indem Sie <a href="{{ url }}">hier</a> klicken.</p>\n                <p>Sollten Sie den Newsletter nicht angefordert haben, ignorieren Sie diese E-Mail.</p>\n        ', 'Hallo {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}\n\n                Schön, dass Sie sich für unseren Newsletter interessieren!\n\n                Um einem Missbrauch Ihrer E-Mail-Adresse vorzubeugen, haben wir Ihnen diese Bestätigungsmail gesendet. Bestätigen Sie, dass Sie den Newsletter regelmäßig erhalten wollen, indem Sie auf den folgenden Link klicken: {{ url }}\n\n                Sollten Sie den Newsletter nicht angefordert haben, ignorieren Sie diese E-Mail.\n        ', NULL, '[[regtime_]]', NULL),
('xpvWxT', '/_MpXT|', '{{ salesChannel.translated.name }}', 'Newsletter', '', '<h3>Hello {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}</h3>\n                <p>Thank you for your interest in our newsletter!</p>\n                <p>In order to prevent misuse of your email address, we have sent you this confirmation email. Confirm that you wish to receive the newsletter regularly by clicking <a href="{{ url }}">here</a>.</p>\n                <p>If you have not subscribed to the newsletter, please ignore this email.</p>\n        ', 'Hello {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}\n\n                Thank you for your interest in our newsletter!\n\n                In order to prevent misuse of your email address, we have sent you this confirmation email. Confirm that you wish to receive the newsletter regularly by clicking on the link: {{ url }}\n\n                If you have not subscribed to the newsletter, please ignore this email.\n        ', NULL, '[[regtime_]]', NULL),
('xpvWx''P', 'jlrm%LL7WJ', '{{ salesChannel.translated.name }}', 'Register', '', '<h3>Hallo {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}</h3>\n                <p>vielen Dank für Ihre Anmeldung.</p>\n                <p>Sie haben sich erfolgreich zu unserem Newsletter angemeldet.</p>\n        ', 'Hallo {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}\n\n                vielen Dank für Ihre Anmeldung.\n\n                Sie haben sich erfolgreich zu unserem Newsletter angemeldet.\n        ', NULL, '[[regtime_]]', NULL),
('xpvWx''P', '/_MpXT|', '{{ salesChannel.translated.name }}', 'Register', '', '<h3>Hello {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}</h3>\n                <p>thank you very much for your registration.</p>\n                <p>You have successfully subscribed to our newsletter.</p>\n        ', 'Hello {{ newsletterRecipient.firstName }} {{ newsletterRecipient.lastName }}\n\n                thank you very much for your registration.\n\n                You have successfully subscribed to our newsletter.\n        ', NULL, '[[regtime_]]', NULL),
('z<rŨH59P;', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Bestellbestätigung', '', '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n\n    Hallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Ihre Bestellung ist am {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} bei uns eingegangen.<br>\n    <br>\n    Bestellnummer: {{ order.orderNumber }}<br>\n    <br>\n    Sobald ein Zahlungseingang erfolgt ist, erhalten Sie eine separate Benachrichtigung und Ihre Bestellung wird verarbeitet.<br>\n    <br>\n    Den aktuellen Status Ihrer Bestellung können Sie jederzeit über diesen Link abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}<br>\n    Über diesen Link können Sie auch die Bestellung bearbeiten, die Zahlungsart wechseln oder nachträglich eine Zahlung durchführen.<br>\n    <br>\n    <strong>Informationen zu Ihrer Bestellung:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt-Nr.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produktbild</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Bezeichnung</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Menge</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Preis</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Summe</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                                <span style="display: inline-block;\n                                    position: absolute;\n                                    width: 6px;\n                                    height: 20px;\n                                    top: 0;\n                                    border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                    margin-left: {{ i * 10 }}px;"></span>\n                            </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Versandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        Gesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Gesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Gesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Gewählte Zahlungsart:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Gewählte Versandart:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Rechnungsadresse:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Lieferadresse:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Ihre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\n            Bei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\n            bestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit. <br>\n        {% endif %}\n        <br>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        Für Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\nHallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIhre Bestellung ist am {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} bei uns eingegangen.\n\nBestellnummer: {{ order.orderNumber }}\n\nSobald ein Zahlungseingang erfolgt ist, erhalten Sie eine separate Benachrichtigung und Ihre Bestellung wird verarbeitet.\n\nDen aktuellen Status Ihrer Bestellung können Sie jederzeit über diesen Link abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nÜber diesen Link können Sie auch die Bestellung bearbeiten, die Zahlungsart wechseln oder nachträglich eine Zahlung durchführen.\n\nInformationen zu Ihrer Bestellung:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nArtikel-Nr. {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nProduktbild {{ lineItem.cover.alt }},\n{% endif %}\nBeschreibung {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nMenge {{ lineItem.quantity }},\nPreis {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nSumme {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nVersandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nGesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nGewählte Zahlungsart: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nGewählte Versandart: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nRechnungsadresse:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nLieferadresse:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nIhre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\nBei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\nbestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit.\n\n{% endif %}\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nFür Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        deepLinkCode: a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\nIm Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('z<rŨH59P;', '/_MpXT|', '{{ salesChannel.name }}', 'Order confirmation', '', '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    We have received your order from {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}.<br>\n    <br>\n    Order number: {{ order.orderNumber }}<br>\n    <br>\n    As soon as your payment has been made, you will receive a separate notification and your order will be processed.<br>\n    <br>\n    You may check the current status of your order with this link: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}<br>\n    You may use this link to edit your order, change the payment method or make additional payments.<br>\n    <br>\n    <strong>Information on your order:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Prod. no.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Product image</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Description</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Quantities</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Price</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Total</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                            <span style="display: inline-block;\n                                position: absolute;\n                                width: 6px;\n                                height: 20px;\n                                top: 0;\n                                border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                margin-left: {{ i * 10 }}px;"></span>\n                        </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Shipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n\n        Net total: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Total gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Rounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Selected payment type:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Selected shipping type:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Billing address:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Shipping address:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Your VAT-ID: {{ order.orderCustomer.vatIds|first }}\n            In case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.<br>\n        {% endif %}\n        <br>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        If you have any questions, do not hesitate to contact us.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\n{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nWe have received your order from {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}.\n\nOrder number: {{ order.orderNumber }}\n\nAs soon as your payment has been made, you will receive a separate notification and your order will be processed.\n\nYou may check the current status of your order with this link: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nYou may use this link to edit your order, change the payment method or make additional payments.\n\nInformation on your order:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nProduct number {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nImage {{ lineItem.cover.alt }},\n{% endif %}\nDescription {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nQuantity {{ lineItem.quantity }},\nPrice {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nTotal {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nShipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nNet total: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nTotal gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nRounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nSelected payment type: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nSelected shipping type: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nBilling address:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nShipping address:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nYour VAT-ID: {{ order.orderCustomer.vatIds|first }}\nIn case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.\n\n{% endif %}\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        ''deepLinkCode'': a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\nIn case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('zPsz\r', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Deine Registrierung bei {{ salesChannel.name }}', 'Registrierungsbestätigung', '<div style="font-family:arial; font-size:12px;">\n            <p>\n                {{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},<br/>\n                <br/>\n                vielen Dank für Ihre Anmeldung in unserem Shop.<br/>\n                Sie erhalten Zugriff über Ihre E-Mail-Adresse <strong>{{ customer.email }}</strong> und dem von Ihnen gewählten Kennwort.<br/>\n                Sie können Ihr Kennwort jederzeit nachträglich ändern.\n            </p>\n        </div>', '{{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},\n\n                vielen Dank für Ihre Anmeldung in unserem Shop.\n                Sie erhalten Zugriff über Ihre E-Mail-Adresse {{ customer.email }} und dem von Ihnen gewählten Kennwort.\n                Sie können Ihr Kennwort jederzeit nachträglich ändern.\n', NULL, '[[regtime_]]', NULL),
('zPsz\r', '/_MpXT|', '{{ salesChannel.name }}', 'Your sign-up with {{ salesChannel.translated.name }}', 'Registration confirmation', '<div style="font-family:arial; font-size:12px;">\n            <p>\n                {{ customer.salutation.translated.letterName }} {{ customer.firstName }} {{ customer.lastName }},<br/>\n                <br/>\n                thank you for your signing up with our Shop.<br/>\n                You will gain access via the email address <strong>{{ customer.email }}</strong> and the password you have chosen.<br/>\n                You can change your password anytime.\n            </p>\n        </div>', '{{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},\n\n                thank you for your signing up with our Shop.\n                You will gain access via the email address {{ customer.email }} and the password you have chosen.\n                You can change your password anytime.\n        ', NULL, '[[regtime_]]', NULL),
('z_rѾ', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Password zurücksetzen - {{ salesChannel.name }}', 'Anfrage zum Zurücksetzen des Passworts', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo {{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},<br/>\n        <br/>\n        im Shop {{ salesChannel.translated.name }} wurde eine Anfrage gestellt, um Ihr Passwort zurück zu setzen.\n        Bitte bestätigen Sie den unten stehenden Link, um ein neues Passwort zu definieren.<br/>\n        <br/>\n        <a href="{{ resetUrl }}">Passwort zurücksetzen</a><br/>\n        <br/>\n        Dieser Link ist nur für die nächsten 2 Stunden gültig. Danach muss das Zurücksetzen des Passwortes erneut beantragt werden.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.\n    </p>\n</div>', 'Hallo {{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},\n\nim Shop {{ salesChannel.translated.name }} wurde eine Anfrage gestellt, um Ihr Passwort zurück zu setzen.\nBitte bestätigen Sie den unten stehenden Link, um ein neues Passwort zu definieren.\n\nPasswort zurücksetzen: {{ resetUrl }}\n\nDieser Link ist nur für die nächsten 2 Stunden gültig. Danach muss das Zurücksetzen des Passwortes erneut beantragt werden.\nFalls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.', NULL, '[[regtime_]]', NULL),
('z_rѾ', '/_MpXT|', '{{ salesChannel.name }}', 'Password reset - {{ salesChannel.name }}', 'Password reset request', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.firstName }} {{ customer.lastName }},<br/>\n        <br/>\n        there has been a request to reset you Password in the Shop {{ salesChannel.translated.name }}\n        Please confirm the link below to specify a new password.<br/>\n        <br/>\n        <a href="{{ resetUrl }}">Reset password</a><br/>\n        <br/>\n        This link is valid for the next 2 hours. After that you have to request a new confirmation link.<br/>\n        If you do not want to reset your password, please ignore this email. No changes will be made.\n    </p>\n</div>\n', '{{ customer.salutation.translated.letterName }} {{customer.firstName}} {{ customer.lastName }},\n\nthere has been a request to reset you Password in the Shop {{ salesChannel.translated.name }}\nPlease confirm the link below to specify a new password.\n\nReset password: {{ resetUrl }}\n\nThis link is valid for the next 2 hours. After that you have to request a new confirmation link.\nIf you do not want to reset your password, please ignore this email. No changes will be made.', NULL, '[[regtime_]]', NULL),
('ztr>dnү%K', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Ihr Händleraccount wurde freigeschaltet - {{ salesChannel.name }}', 'Kundengruppenwechsel freigeschaltet', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo,<br/>\n        <br/>\n        ihr Händlerkonto bei {{ salesChannel.translated.name }} wurde freigeschaltet.<br/>\n        Von nun an werden wir Ihnen den Netto-Preis berechnen.\n    </p>\n</div>\n', 'Hallo,\n\nihr Händlerkonto bei {{ salesChannel.translated.name }} wurde freigeschaltet.\nVon nun an werden wir Ihnen den Netto-Preis berechnen.\n', NULL, '[[regtime_]]', NULL),
('ztr>dnү%K', '/_MpXT|', '{{ salesChannel.name }}', 'Your merchant account has been unlocked - {{ salesChannel.name }}', 'Customer Group Change accepted', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hello,<br/>\n        <br/>\n        your merchant account at {{ salesChannel.translated.name }} has been unlocked.<br/>\n        From now on, we will charge you the net purchase price.\n    </p>\n</div>\n', 'Hello,\n\nyour merchant account at {{ salesChannel.translated.name }} has been unlocked.\nFrom now on, we will charge you the net purchase price.\n', NULL, '[[regtime_]]', NULL),
('z}sŮM', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Ihr Händleraccountantrag wurde abgelehnt - {{ salesChannel.name }}', 'Kundengruppenwechsel abgelehnt', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo,<br/>\n        <br/>\n        vielen Dank für ihr Interesse an unseren Großhandelspreisen. Leider liegt uns bisher keine <br/>\n        Händlerauthentifizierung vor, und daher können wir Ihre Anfrage nicht bestätigen. <br/>\n        Bei weiteren Fragen kontaktieren Sie uns gerne per Telefon, Fax oder E-Mail. <br/>\n    </p>\n</div>\n', 'Hallo,\n\nvielen Dank für ihr Interesse an unseren Großhandelspreisen. Leider liegt uns bisher keine\nHändlerauthentifizierung vor, und daher können wir Ihre Anfrage nicht bestätigen.\nBei weiteren Fragen kontaktieren Sie uns gerne per Telefon, Fax oder E-Mail.\n', NULL, '[[regtime_]]', NULL),
('z}sŮM', '/_MpXT|', '{{ salesChannel.name }}', 'Your trader account has not been accepted - {{ salesChannel.name }}', 'Customer Group Change rejected', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hello,<br/>\n        <br/>\n        thank you for your interest in our trade prices.\n        Unfortunately, we do not have a trading license yet so that we cannot accept you as a merchant.<br/>\n        In case of further questions please do not hesitate to contact us via telephone, fax or email.\n    </p>\n</div>\n', 'Hello,\n\nthank you for your interest in our trade prices. Unfortunately,\nwe do not have a trading license yet so that we cannot accept you as a merchant.\nIn case of further questions please do not hesitate to contact us via telephone, fax or email.\n', NULL, '[[regtime_]]', NULL),
('	ruma', 'jlrm%LL7WJ', 'Shopware Administration', 'Password-Wiederherstellung', '', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo {{ userRecovery.user.firstName }} {{ userRecovery.user.lastName }},<br/>\n        <br/>\n        es wurde eine Anfrage gestellt, um Ihr Passwort zurück zu setzen.\n        Bitte bestätigen Sie den unten stehenden Link, um ein neues Passwort zu definieren.<br/>\n        <br/>\n        <a href="{{ resetUrl }}">Passwort zurücksetzen</a><br/>\n        <br/>\n        Dieser Link ist nur für die nächsten 2 Stunden gültig. Danach muss das Zurücksetzen des Passwortes erneut beantragt werden.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.\n    </p>\n</div>', '        Hallo {{ userRecovery.user.firstName }} {{ userRecovery.user.lastName }},\n\n        es wurde eine Anfrage gestellt, um Ihr Passwort zurück zu setzen.\n        Bitte bestätigen Sie den unten stehenden Link, um ein neues Passwort zu definieren.\n\n        Passwort zurücksetzen: {{ resetUrl }}\n\n        Dieser Link ist nur für die nächsten 2 Stunden gültig. Danach muss das Zurücksetzen des Passwortes erneut beantragt werden.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.', NULL, '[[regtime_]]', NULL),
('	ruma', '/_MpXT|', 'Shopware Administration', 'Password recovery', '', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Dear {{ userRecovery.user.firstName }} {{ userRecovery.user.lastName }},<br/>\n        <br/>\n        there has been a request to reset your password.\n        Please confirm the link below to specify a new password.<br/>\n        <br/>\n        <a href="{{ resetUrl }}">Reset password</a><br/>\n        <br/>\n        This link is valid for the next 2 hours. After that you have to request a new confirmation link.<br/>\n        If you do not want to reset your password, please ignore this email. No changes will be made.\n    </p>\n</div>', '        Dear {{ userRecovery.user.firstName }} {{ userRecovery.user.lastName }},\n\n        there has been a request to reset your password.\n        Please confirm the link below to specify a new password.\n\n        Reset password: {{ resetUrl }}\n\n        This link is valid for the next 2 hours. After that you have to request a new confirmation link.\n        If you do not want to reset your password, please ignore this email. No changes will be made.', NULL, '[[regtime_]]', NULL),
('s|\0O5<', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Kontaktanfrage erhalten - {{ salesChannel.name }}', 'Kontaktanfrage erhalten', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Folgende Nachricht wurde an Sie via Kontakt-Formular gesendet.<br/>\n        <br/>\n        Name: {{ contactFormData.firstName }} {{ contactFormData.lastName }}\n        <br/>\n        Kontakt E-Mail: {{ contactFormData.email }}<br/>\n        <br>\n        Telefonnummer: {{ contactFormData.phone }}<br/>\n        <br/>\n        Betreff: {{ contactFormData.subject }}<br/>\n        <br/>\n        Message:<br/>\n        {{ contactFormData.comment|nl2br }}<br/>\n    </p>\n</div>\n', 'Folgende Nachricht wurde an Sie via Kontakt-Formular gesendet.\n\nName: {{ contactFormData.firstName }} {{ contactFormData.lastName }}\nKontakt E-Mail: {{ contactFormData.email }}\n\nTelefonnummer: {{ contactFormData.phone }}\n\nBetreff: {{ contactFormData.subject }}\n\nNachricht:\n{{ contactFormData.comment }}\n', NULL, '[[regtime_]]', NULL),
('s|\0O5<', '/_MpXT|', '{{ salesChannel.name }}', 'Contact form received - {{ salesChannel.name }}', 'Contact form received', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        The following Message was sent to you via the contact form.<br/>\n        <br/>\n        Contact name: {{ contactFormData.firstName }} {{ contactFormData.lastName }}\n        <br/>\n        Contact email address: {{ contactFormData.email }}\n        <br/>\n        Phone: {{ contactFormData.phone }}<br/>\n        <br/>\n        Subject: {{ contactFormData.subject }}<br/>\n        <br/>\n        Message:<br/>\n        {{ contactFormData.comment|nl2br }}<br/>\n    </p>\n</div>\n', 'The following Message was sent to you via the contact form.\n\nContact name: {{ contactFormData.firstName }} {{ contactFormData.lastName }}\nContact email address: {{ contactFormData.email }}\nPhone: {{ contactFormData.phone }}\n\nSubject: {{ contactFormData.subject }}\n\nMessage:\n{{ contactFormData.comment }}\n', NULL, '[[regtime_]]', NULL),
('r{V2z', 'jlrm%LL7WJ', '{{ shopName }}', 'Password-Wiederherstellung', '', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo {{ customerRecovery.customer.firstName }} {{ customerRecovery.customer.lastName }},<br/>\n        <br/>\n        Sie haben ein neues Passwort für Ihren {{ shopName }}-Account angefordert.\n        Klicken Sie auf folgenden Link, um Ihr Passwort zurückzusetzen:<br/>\n        <br/>\n        <a href="{{ resetUrl }}">{{ resetUrl }}</a><br/>\n        <br/>\n        Dieser Link ist für die nächsten 2 Stunden gültig.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.<br/>\n        <br/>\n        Mit freundlichen Grüßen\n        Ihr {{ shopName }}-Team\n    </p>\n</div>', '        Hallo {{ customerRecovery.customer.firstName }} {{ customerRecovery.customer.lastName }},\n\n        Sie haben ein neues Passwort für Ihren {{ shopName }}-Account angefordert.\n        Klicken Sie auf folgenden Link, um Ihr Passwort zurückzusetzen:\n\n        {{ resetUrl }}\n\n        Dieser Link ist für die nächsten 2 Stunden gültig.\n        Falls Sie Ihr Passwort nicht zurücksetzen möchten, ignorieren Sie diese E-Mail - es wird dann keine Änderung vorgenommen.\n\n        Mit freundlichen Grüßen\n        Ihr {{ shopName }}-Team', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('r{V2z', '/_MpXT|', '{{ shopName }}', 'Password recovery', '', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hello {{ customerRecovery.customer.firstName }} {{ customerRecovery.customer.lastName }},<br/>\n        <br/>\n        You have requested a new password for your {{ shopName }} account.\n        Click on the following link to reset your password:<br/>\n        <br/>\n        <a href="{{ resetUrl }}">{{ resetUrl }}</a><br/>\n        <br/>\n        This link is valid for the next 2 hours.\n        If you don''t want to reset your password, ignore this email and no changes will be made.<br/>\n        <br/>\n        Yours sincerely\n        Your {{ shopName }} team\n    </p>\n</div>', '        Hello {{ customerRecovery.customer.firstName }} {{ customerRecovery.customer.lastName }},\n\n        You have requested a new password for your {{ shopName }} account.\n        Click on the following link to reset your password:\n\n        {{ resetUrl }}\n\n        This link is valid for the next 2 hours.\n        If you don''t want to reset your password, ignore this email and no changes will be made.\n\n        Yours sincerely\n        Your {{ shopName }}-Team', NULL, '[[regtime_]]', NULL),
('RrAup5', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('RrAup5', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('eqH	<', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('eqH	<', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('vru', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('vru', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('s\nI%', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('s\nI%', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('rEIe', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Lieferstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Lieferstatus: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('rEIe', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your delivery at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.deliveries.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('s:a', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('s:a', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('pϪFUղ', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('pϪFUղ', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n    <br/>\n    the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n    <strong>The new status is as follows: {{ order.stateMachineState.translated.name }}.</strong><br/>\n    <br/>\n    You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n    </br>\n    However, in case you have purchased without a registration or a customer account, you do not have this option.\n    <br><br>\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your email address and postal code of the billing address.<br>\n    {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('sW$', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('sW$', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('s|Va:', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Bestellstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Bestellstatus: {{ order.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('s|Va:', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('qsl(\n', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('qsl(\n', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('qȽiҢ', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('qȽiҢ', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('sՈ2^$C', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('sՈ2^$C', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('pCq6۞', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n    Hallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Wir haben Ihre Zahlung erhalten und werden die Bestellung nun weiter verarbeiten.<br>\n    <br>\n    Bestellnummer: {{ order.orderNumber }}<br>\n    <br>\n    <strong>Informationen zu Ihrer Bestellung:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt-Nr.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produktbild</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Bezeichnung</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Menge</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Preis</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Summe</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                                <span style="display: inline-block;\n                                    position: absolute;\n                                    width: 6px;\n                                    height: 20px;\n                                    top: 0;\n                                    border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                    margin-left: {{ i * 10 }}px;"></span>\n                            </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Versandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        Gesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Gesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Gesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Gewählte Zahlungsart:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Gewählte Versandart:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Rechnungsadresse:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Lieferadresse:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Ihre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\n            Bei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\n            bestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit. <br>\n        {% endif %}\n        <br>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        Für Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\nHallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nWir haben Ihre Zahlung erhalten und werden die Bestellung nun weiter verarbeiten.\n\nBestellnummer: {{ order.orderNumber }}\n\nInformationen zu Ihrer Bestellung:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nArtikel-Nr. {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nProduktbild {{ lineItem.cover.alt }},\n{% endif %}\nBeschreibung {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nMenge {{ lineItem.quantity }},\nPreis {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nSumme {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nVersandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nGesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nGewählte Zahlungsart: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nGewählte Versandart: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nRechnungsadresse:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nLieferadresse:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nIhre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\nBei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\nbestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit.\n\n{% endif %}\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nFür Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        deepLinkCode: a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\nIm Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('pCq6۞', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    We received your payment and will now start processing the order.<br>\n    Order number: {{ order.orderNumber }}<br>\n    <br>\n\n    <strong>Information on your order:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Prod. no.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Product image</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Description</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Quantities</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Price</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Total</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                            <span style="display: inline-block;\n                                position: absolute;\n                                width: 6px;\n                                height: 20px;\n                                top: 0;\n                                border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                margin-left: {{ i * 10 }}px;"></span>\n                        </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Shipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n\n        Net total: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Total gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Rounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Selected payment type:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Selected shipping type:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Billing address:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Shipping address:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Your VAT-ID: {{ order.orderCustomer.vatIds|first }}\n            In case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.<br>\n        {% endif %}\n        <br>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        If you have any questions, do not hesitate to contact us.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\n{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nWe received your payment and will now start processing the order.\n\nOrder number: {{ order.orderNumber }}\n\n\nInformation on your order:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nProduct number {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nImage {{ lineItem.cover.alt }},\n{% endif %}\nDescription {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nQuantity {{ lineItem.quantity }},\nPrice {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nTotal {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nShipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nNet total: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nTotal gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nRounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nSelected payment type: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nSelected shipping type: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nBilling address:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nShipping address:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nYour VAT-ID: {{ order.orderCustomer.vatIds|first }}\nIn case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.\n\n{% endif %}\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        ''deepLinkCode'': a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\nIn case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('-r)#J>\ZD', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n    Hallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Ihre Bestellung ist am {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} bei uns eingegangen.<br>\n    <br>\n    Bestellnummer: {{ order.orderNumber }}\n    <br>\n    Der Zahlungsprozess mit {{ order.transactions.first.paymentMethod.translated.name }} ist noch nicht abgeschlossen. Sie können den Zahlungsprozess über die folgende URL wieder aufnehmen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}<br>\n    <br>\n    <strong>Informationen zu Ihrer Bestellung:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt-Nr.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produktbild</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Bezeichnung</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Menge</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Preis</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Summe</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                                <span style="display: inline-block;\n                                    position: absolute;\n                                    width: 6px;\n                                    height: 20px;\n                                    top: 0;\n                                    border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                    margin-left: {{ i * 10 }}px;"></span>\n                            </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Versandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        Gesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Gesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Gesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Gewählte Zahlungsart:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Gewählte Versandart:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Rechnungsadresse:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Lieferadresse:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Ihre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\n            Bei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\n            bestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit. <br>\n        {% endif %}\n        <br>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        Für Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\nHallo {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIhre Bestellung ist am {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} bei uns eingegangen.\n\nBestellnummer: {{ order.orderNumber }}\n\nDer Zahlungsprozess mit {{ order.transactions.first.paymentMethod.translated.name }} ist noch nicht abgeschlossen. Sie können den Zahlungsprozess über die folgende URL wieder aufnehmen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n\nInformationen zu Ihrer Bestellung:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nArtikel-Nr. {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nProduktbild {{ lineItem.cover.alt }},\n{% endif %}\nBeschreibung {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} pro {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nMenge {{ lineItem.quantity }},\nPreis {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nSumme {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nVersandkosten: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Netto: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}zzgl.{% else %}inkl.{% endif %} {{ calculatedTax.taxRate }}% MwSt. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nGesamtkosten Brutto: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nGesamtkosten Brutto gerundet: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nGewählte Zahlungsart: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nGewählte Versandart: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nRechnungsadresse:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nLieferadresse:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nIhre Umsatzsteuer-ID: {{ order.orderCustomer.vatIds|first }}\nBei erfolgreicher Prüfung und sofern Sie aus dem EU-Ausland\nbestellen, erhalten Sie Ihre Ware umsatzsteuerbefreit.\n\n{% endif %}\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nFür Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        deepLinkCode: a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\nIm Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('-r)#J>\ZD', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% set currencyIsoCode = order.currency.isoCode %}\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    We have received your order on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}.<br>\n    <br>\n    Order number: {{ order.orderNumber }}.<br>\n    <br>\n    You have not completed your payment with {{ order.transactions.first.paymentMethod.translated.name }} yet. You can resume the payment process by using the following URL: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}<br>\n    <br>\n    <strong>Information on your order:</strong><br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Prod. no.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Product image</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Description</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Quantities</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Price</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Total</strong></td>\n        </tr>\n\n        {% for lineItem in order.nestedLineItems %}\n            {% set nestingLevel = 0 %}\n            {% set nestedItem = lineItem %}\n            {% block lineItem %}\n                <tr>\n                    <td>{% if nestedItem.payload.productNumber is defined %}{{ nestedItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                    <td>{% if nestedItem.cover is defined and nestedItem.cover is not null %}<img src="{{ nestedItem.cover.url }}" width="75" height="auto"/>{% endif %}</td>\n                    <td>\n                        {% if nestingLevel > 0 %}\n                            {% for i in 1..nestingLevel %}\n                                <span style="position: relative;">\n                            <span style="display: inline-block;\n                                position: absolute;\n                                width: 6px;\n                                height: 20px;\n                                top: 0;\n                                border-left:  2px solid rgba(0, 0, 0, 0.15);\n                                margin-left: {{ i * 10 }}px;"></span>\n                        </span>\n                            {% endfor %}\n                        {% endif %}\n\n                        <div{% if nestingLevel > 0 %} style="padding-left: {{ (nestingLevel + 1) * 10 }}px"{% endif %}>\n                            {{ nestedItem.label|u.wordwrap(80) }}\n                        </div>\n\n                        {% if nestedItem.payload.options is defined and nestedItem.payload.options|length >= 1 %}\n                            <div>\n                                {% for option in nestedItem.payload.options %}\n                                    {{ option.group }}: {{ option.option }}\n                                    {% if nestedItem.payload.options|last != option %}\n                                        {{ " | " }}\n                                    {% endif %}\n                                {% endfor %}\n                            </div>\n                        {% endif %}\n\n                        {% if nestedItem.payload.features is defined and nestedItem.payload.features|length >= 1 %}\n                            {% set referencePriceFeatures = nestedItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n                            {% if referencePriceFeatures|length >= 1 %}\n                                {% set referencePriceFeature = referencePriceFeatures|first %}\n                                <div>\n                                    {{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}\n                                    ({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }})\n                                </div>\n                            {% endif %}\n                        {% endif %}\n                    </td>\n                    <td style="text-align: center">{{ nestedItem.quantity }}</td>\n                    <td>{{ nestedItem.unitPrice|currency(currencyIsoCode) }}</td>\n                    <td>{{ nestedItem.totalPrice|currency(currencyIsoCode) }}</td>\n                </tr>\n\n                {% if nestedItem.children.count > 0 %}\n                    {% set nestingLevel = nestingLevel + 1 %}\n                    {% for lineItem in nestedItem.children %}\n                        {% set nestedItem = lineItem %}\n                        {{ block(''lineItem'') }}\n                    {% endfor %}\n                {% endif %}\n            {% endblock %}\n        {% endfor %}\n    </table>\n\n    {% set delivery = order.deliveries.first %}\n\n    {% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n    {% set decimals = order.totalRounding.decimals %}\n    {% set total = order.price.totalPrice %}\n    {% if displayRounded %}\n        {% set total = order.price.rawTotal %}\n        {% set decimals = order.itemRounding.decimals %}\n    {% endif %}\n    <p>\n        <br>\n        <br>\n        {% for shippingCost in order.deliveries %}\n            Shipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n\n        Net total: {{ order.amountNet|currency(currencyIsoCode) }}<br>\n        {% for calculatedTax in order.price.calculatedTaxes %}\n            {% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}<br>\n        {% endfor %}\n        {% if not displayRounded %}<strong>{% endif %}Total gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}{% if not displayRounded %}</strong>{% endif %}<br>\n        {% if displayRounded %}\n            <strong>Rounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}</strong><br>\n        {% endif %}\n        <br>\n\n        {% if order.transactions is defined and order.transactions is not empty %}\n            <strong>Selected payment type:</strong> {{ order.transactions.first.paymentMethod.translated.name }}<br>\n            {{ order.transactions.first.paymentMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% if delivery %}\n            <strong>Selected shipping type:</strong> {{ delivery.shippingMethod.translated.name }}<br>\n            {{ delivery.shippingMethod.translated.description }}<br>\n            <br>\n        {% endif %}\n\n        {% set billingAddress = order.addresses.get(order.billingAddressId) %}\n        <strong>Billing address:</strong><br>\n        {{ billingAddress.company }}<br>\n        {{ billingAddress.firstName }} {{ billingAddress.lastName }}<br>\n        {{ billingAddress.street }} <br>\n        {{ billingAddress.zipcode }} {{ billingAddress.city }}<br>\n        {{ billingAddress.country.translated.name }}<br>\n        <br>\n\n        {% if delivery %}\n            <strong>Shipping address:</strong><br>\n            {{ delivery.shippingOrderAddress.company }}<br>\n            {{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}<br>\n            {{ delivery.shippingOrderAddress.street }} <br>\n            {{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}<br>\n            {{ delivery.shippingOrderAddress.country.translated.name }}<br>\n            <br>\n        {% endif %}\n        {% if order.orderCustomer.vatIds %}\n            Your VAT-ID: {{ order.orderCustomer.vatIds|first }}\n            In case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.<br>\n        {% endif %}\n        <br>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        <br>\n        If you have any questions, do not hesitate to contact us.\n        <br>\n        {% if a11yDocuments is defined and a11yDocuments is not empty %}\n            <br>\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n            <ul>\n                {% for a11y in a11yDocuments %}\n                    {% set documentLink = rawUrl(\n                        ''frontend.account.order.single.document.a11y'',\n                        {\n                            documentId: a11y.documentId,\n                            deepLinkCode: a11y.deepLinkCode,\n                            fileType: a11y.fileExtension,\n                        },\n                        salesChannel.domains|first.url\n                    )%}\n                    <li><a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a></li>\n                {% endfor %}\n            </ul>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n    <br>\n</div>\n', '{% set currencyIsoCode = order.currency.isoCode %}\n{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nWe have received your order on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}.\n\nOrder number: {{ order.orderNumber }}.\n\nYou have not completed your payment with {{ order.transactions.first.paymentMethod.translated.name }} yet. You can resume the payment process by using the following URL: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n\nInformation on your order:\n\n{% for lineItem in order.lineItems %}\nPos. {{ loop.index }}\n---------------------\n{% if lineItem.payload.productNumber is defined %}\nProduct number {{ lineItem.payload.productNumber|u.wordwrap(80) }},\n{% endif %}\n{% if nestedItem.cover is defined and nestedItem.cover is not null %}\nImage {{ lineItem.cover.alt }},\n{% endif %}\nDescription {{ lineItem.label|u.wordwrap(80) }},\n{% if lineItem.payload.options is defined and lineItem.payload.options|length >= 1 %}\n{% for option in lineItem.payload.options %}\n{{ option.group }}: {{ option.option }}{{ ", " }}\n{% endfor %}\n{% endif %}\n{% if lineItem.payload.features is defined and lineItem.payload.features|length >= 1 %}\n{% set referencePriceFeatures = lineItem.payload.features|filter(feature => feature.type == ''referencePrice'') %}\n{% if referencePriceFeatures|length >= 1 %}\n{% set referencePriceFeature = referencePriceFeatures|first %}\n{{ referencePriceFeature.value.purchaseUnit }} {{ referencePriceFeature.value.unitName }}({{ referencePriceFeature.value.price|currency(currencyIsoCode) }} per {{ referencePriceFeature.value.referenceUnit }} {{ referencePriceFeature.value.unitName }}),\n{% endif %}\n{% endif %}\nQuantity {{ lineItem.quantity }},\nPrice {{ lineItem.unitPrice|currency(currencyIsoCode) }},\nTotal {{ lineItem.totalPrice|currency(currencyIsoCode) }},\n\n{% endfor %}\n{% set delivery = order.deliveries.first %}\n{% set displayRounded = order.totalRounding.interval != 0.01 or order.totalRounding.decimals != order.itemRounding.decimals %}\n{% set decimals = order.totalRounding.decimals %}\n{% set total = order.price.totalPrice %}\n{% if displayRounded %}\n    {% set total = order.price.rawTotal %}\n    {% set decimals = order.itemRounding.decimals %}\n{% endif %}\n{% for shippingCost in order.deliveries %}\nShipping costs: {{ shippingCost.shippingCosts.totalPrice|currency(currencyIsoCode) }}\n{% endfor %}\nNet total: {{ order.amountNet|currency(currencyIsoCode) }}\n{% for calculatedTax in order.price.calculatedTaxes %}\n{% if order.taxStatus is same as(''net'') %}plus{% else %}including{% endif %} {{ calculatedTax.taxRate }}% VAT. {{ calculatedTax.tax|currency(currencyIsoCode) }}\n{% endfor %}\nTotal gross: {{ total|currency(currencyIsoCode,decimals=decimals) }}\n{% if displayRounded %}\nRounded total gross: {{ order.price.totalPrice|currency(currencyIsoCode,decimals=order.totalRounding.decimals) }}\n{% endif %}\n\n{% if order.transactions is defined and order.transactions is not empty %}\nSelected payment type: {{ order.transactions.first.paymentMethod.translated.name }}\n{{ order.transactions.first.paymentMethod.translated.description }}\n{% endif %}\n\n{% if delivery %}\nSelected shipping type: {{ delivery.shippingMethod.translated.name }}\n{{ delivery.shippingMethod.translated.description }}\n{% endif %}\n{% set billingAddress = order.addresses.get(order.billingAddressId) %}\nBilling address:\n{{ billingAddress.company }}\n{{ billingAddress.firstName }} {{ billingAddress.lastName }}\n{{ billingAddress.street }}\n{{ billingAddress.zipcode }} {{ billingAddress.city }}\n{{ billingAddress.country.translated.name }}\n\n{% if delivery %}\nShipping address:\n{{ delivery.shippingOrderAddress.company }}\n{{ delivery.shippingOrderAddress.firstName }} {{ delivery.shippingOrderAddress.lastName }}\n{{ delivery.shippingOrderAddress.street }}\n{{ delivery.shippingOrderAddress.zipcode}} {{ delivery.shippingOrderAddress.city }}\n{{ delivery.shippingOrderAddress.country.translated.name }}\n{% endif %}\n\n{% if order.orderCustomer.vatIds %}\nYour VAT-ID: {{ order.orderCustomer.vatIds|first }}\nIn case of a successful order and if you are based in one of the EU countries, you will receive your goods exempt from turnover tax.\n\n{% endif %}\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments is defined and a11yDocuments is not empty %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n{% set documentLink = rawUrl(\n    ''frontend.account.order.single.document.a11y'',\n    {\n        documentId: a11y.documentId,\n        ''deepLinkCode'': a11y.deepLinkCode,\n        fileType: a11y.fileExtension,\n    },\n    salesChannel.domains|first.url\n)%}\n- {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\nIn case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('9r-[1{', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('9r-[1{', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Jq\0/*', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('Jq\0/*', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('pŵ}\r6z', 'jlrm%LL7WJ', '{{ salesChannel.translated.name }}', 'Bitte bestätigen Sie Ihre Anmeldung bei {{ salesChannel.translated.name }}', 'Anmeldebestätigung', '\n            <div style="font-family:arial; font-size:12px;">\n                <p>\n                    Hallo {{ customer.salutation.translated.displayName }} {{ customer.lastName }},<br/>\n                    <br/>\n                    vielen Dank für Ihre Anmeldung bei {{ salesChannel.translated.name }}.<br/>\n                    Bitte bestätigen Sie die Registrierung über den nachfolgenden Link:<br/>\n                    <br/>\n                    <a href="{{ confirmUrl }}">Anmeldung abschließen</a><br/>\n                    <br/>\n                    Durch diese Bestätigung erklären Sie sich ebenso damit einverstanden, dass wir Ihnen im Rahmen der Vertragserfüllung weitere E-Mails senden dürfen.\n                </p>\n            </div>\n        ', '\n            Hallo {{ customer.salutation.translated.displayName }} {{ customer.lastName }},\n\n            vielen Dank für Ihre Anmeldung bei {{ salesChannel.translated.name }}.\n            Bitte bestätigen Sie die Registrierung über den nachfolgenden Link:\n\n            {{ confirmUrl }}\n\n            Durch diese Bestätigung erklären Sie sich ebenso damit einverstanden, dass wir Ihnen im Rahmen der Vertragserfüllung weitere E-Mails senden dürfen.\n        ', NULL, '[[regtime_]]', NULL),
('pŵ}\r6z', '/_MpXT|', '{{ salesChannel.translated.name }}', 'Please confirm your sign-up with {{ salesChannel.translated.name }}', 'Registration confirmation', '\n            <div style="font-family:arial; font-size:12px;">\n                <p>\n                    Hello {{ customer.salutation.translated.displayName }} {{ customer.lastName }},<br/>\n                    <br/>\n                    thank you for your signing up with {{ salesChannel.translated.name }}.<br/>\n                    Please confirm the sign-up via the following link:<br/>\n                    <br/>\n                    <a href="{{ confirmUrl }}">Completing sign-up</a><br/>\n                    <br/>\n                    By this confirmation, you also agree that we may send you further emails as part of the fulfillment of the contract.\n                </p>\n            </div>\n        ', '\n            Hello {{ customer.salutation.translated.displayName }} {{ customer.lastName }},\n\n            thank you for your signing up with {{ salesChannel.translated.name }}.\n            Please confirm the sign-up via the following link:\n\n            {{ confirmUrl }}\n\n            By this confirmation, you also agree that we may send you further emails as part of the fulfillment of the contract.\n        ', NULL, '[[regtime_]]', NULL),
('rgR)', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Bitte bestätigen Sie Ihre E-Mail-Adresse bei {{ salesChannel.name }}', 'Anmeldebestätigung bei Gastbestellungen', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hallo {{ customer.salutation.translated.displayName }} {{ customer.lastName }},<br/>\n        <br/>\n        Bitte bestätigen Sie Ihre E-Mail-Adresse über den nachfolgenden Link:<br/>\n        <br/>\n        <a href="{{ confirmUrl }}">E-Mail bestätigen</a><br/>\n        <br/>\n        Nach der Bestätigung werden Sie in den Bestellabschluss geleitet, dort können Sie Ihre Bestellung nochmals überprüfen und abschließen.<br/>\n        Durch diese Bestätigung erklären Sie sich ebenso damit einverstanden, dass wir Ihnen im Rahmen der Vertragserfüllung weitere E-Mails senden dürfen.\n    </p>\n</div>\n', 'Hallo {{ customer.salutation.translated.displayName }} {{ customer.lastName }},\n\nBitte bestätigen Sie Ihre E-Mail-Adresse über den nachfolgenden Link:\n\n{{ confirmUrl }}\n\nNach der Bestätigung werden Sie in den Bestellabschluss geleitet, dort können Sie Ihre Bestellung nochmals überprüfen und abschließen.\nDurch diese Bestätigung erklären Sie sich ebenso damit einverstanden, dass wir Ihnen im Rahmen der Vertragserfüllung weitere E-Mails senden dürfen.\n', NULL, '[[regtime_]]', NULL),
('rgR)', '/_MpXT|', '{{ salesChannel.name }}', 'Please confirm your email address at {{ salesChannel.name }}', 'Email confirmation at guest orders', '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Hello {{ customer.salutation.translated.displayName }} {{ customer.lastName }},<br/>\n        <br/>\n        Please confirm your email address via the following link:<br/>\n        <br/>\n        <a href="{{ confirmUrl }}">Confirm email</a><br/>\n        <br/>\n        After the confirmation, you will be directed to the checkout, where you can check and complete your order again.<br/>\n        By this confirmation, you also agree that we may send you further emails as part of the fulfillment of the contract.\n    </p>\n</div>\n', 'Hello {{ customer.salutation.translated.displayName }} {{ customer.lastName }},\n\nPlease confirm your email address via the following link:\n\n{{ confirmUrl }}\n\nAfter the confirmation, you will be directed to the checkout, where you can check and complete your order again.\nBy this confirmation, you also agree that we may send you further emails as part of the fulfillment of the contract.\n', NULL, '[[regtime_]]', NULL),
('csЇn\nXV', 'jlrm%LL7WJ', 'Shop', 'Kunden Gruppen Registrierung Akzeptiert', '', '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\n        <br/>\n        Ihr Account wurde für die Kundengruppe {{ customerGroup.translated.name }} freigeschaltet.<br/>\n        Ab sofort kaufen Sie zu den neuen Konditionen dieser Kundengruppe ein.<br/>\n\n        Für Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n    </p>\n</div>\n', '{{ customer.salutation.translated.letterName }} {{ customer.lastName }},\nIhr Account wurde für die Kundengruppe {{ customerGroup.translated.name }} freigeschaltet.\nAb sofort kaufen Sie zu den neuen Konditionen dieser Kundengruppe ein.\n\nFür Rückfragen stehen wir Ihnen jederzeit gerne zur Verfügung.\n', NULL, '[[regtime_]]', NULL),
('csЇn\nXV', '/_MpXT|', 'Shop', 'Customer Group Registration Accepted', '', '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\n        <br/>\n        Your account has been activated for the customer group {{ customerGroup.translated.name }}.<br/>\n        From now on you can shop at the new conditions of this customer group.<br/><br/>\n\n        Please do not hesitate to contact us at any time if you have any questions.\n    </p>\n</div>\n', 'Hello {{ customer.salutation.translated.letterName }} {{ customer.lastName }},\nYour account has been activated for the customer group {{ customerGroup.translated.name }}.\nFrom now on you can shop at the new conditions of this customer group.\n\nPlease do not hesitate to contact us at any time if you have any questions.\n', NULL, '[[regtime_]]', NULL),
('rԛ', 'jlrm%LL7WJ', 'Shop', 'Kunden Gruppen Registrierung Abgelehnt', '', '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\n        <br/>\n        Vielen Dank für Ihr Interesse an den Konditionen für Kundengruppe {{ customerGroup.translated.name }}.<br/>\n        Leider können wir sie nicht für diese Kundengruppe freischalten.<br/>\n\n        Bei Rückfragen aller Art können Sie uns gerne telefonisch oder per Mail diesbezüglich erreichen.\n    </p>\n</div>\n', '{{ customer.salutation.translated.letterName }} {{ customer.lastName }},\nVielen Dank für Ihr Interesse an den Konditionen für Kundengruppe  {{ customerGroup.translated.name }}.\nLeider können wir sie nicht für diese Kundengruppe freischalten.\n\nBei Rückfragen aller Art können Sie uns gerne telefonisch oder per Mail diesbezüglich erreichen.\n', NULL, '[[regtime_]]', NULL),
('rԛ', '/_MpXT|', 'Shop', 'Customer Group Registration Declined', '', '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {{ customer.salutation.translated.letterName }} {{ customer.lastName }},<br/>\n        <br/>\n        Thank you for your interest in the conditions for customer group {{ customerGroup.translated.name }}.<br/>\n        Unfortunately we cannot activate your account for this customer group.<br/><br/>\n\n        If you have any questions, please feel free to contact us by phone or mail.\n    </p>\n</div>\n', '{{ customer.salutation.translated.letterName }} {{ customer.lastName }},\nThank you for your interest in the conditions for customer group {{ customerGroup.translated.name }}.\nUnfortunately we cannot activate your account for this customer group.\n\nIf you have any questions, please feel free to contact us by phone or mail.\n', NULL, '[[regtime_]]', NULL),
('7pΒ2a2\Z', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Im Anhang dieser E-Mail finden Sie die Rechnung für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}<br>\n    <br>\n    Sollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n    <br><br>\n\n    {% if a11yDocuments %}\n        Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n        Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIm Anhang dieser E-Mail finden Sie die Rechnung für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}\n\nSollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n\n{% if a11yDocuments %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\nIm Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('7pΒ2a2\Z', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the invoice for your order with the number: {{ order.orderNumber }}<br>\n    <br>\n    If you have any questions, do not hesitate to contact us.\n    <br><br>\n\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your email address and postal code of the billing address.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the invoice for your order with the number: {{ order.orderNumber }}\n\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            ''deepLinkCode'': a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\n\nIn case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('7pΒ2b\r6', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Im Anhang dieser E-Mail finden Sie den Lieferschein für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}<br>\n    <br>\n    Sollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n    <br><br>\n\n    {% if a11yDocuments %}\n        Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n        Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIm Anhang dieser E-Mail finden Sie den Lieferschein für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}\n\nSollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n\n{% if a11yDocuments %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\nIm Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('7pΒ2b\r6', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the delivery note for your order with the number: {{ order.orderNumber }}<br>\n    <br>\n    If you have any questions, do not hesitate to contact us.\n    <br><br>\n\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your email address and postal code of the billing address.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the delivery note for your order with the number: {{ order.orderNumber }}\n\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\n\nIn case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('7pΒ2b', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Im Anhang dieser E-Mail finden Sie die Gutschrift für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}<br>\n    <br>\n    Sollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n    <br><br>\n\n    {% if a11yDocuments %}\n        Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n        Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIm Anhang dieser E-Mail finden Sie die Gutschrift für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}\n\nSollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n\n{% if a11yDocuments %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\nIm Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('7pΒ2b', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the credit note for your order with the number: {{ order.orderNumber }}<br>\n    <br>\n    If you have any questions, do not hesitate to contact us.\n    <br><br>\n\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your email address and postal code of the billing address.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the credit note for your order with the number: {{ order.orderNumber }}\n\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\n\nIn case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('7pΒ2d9', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Im Anhang dieser E-Mail finden Sie die Stornorechnung für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}<br>\n    <br>\n    Sollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n    <br><br>\n\n    {% if a11yDocuments %}\n        Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n        Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nIm Anhang dieser E-Mail finden Sie die Stornorechnung für Ihre Bestellung mit der Nummer: {{ order.orderNumber }}\n\nSollten Sie Fragen haben, zögern Sie nicht, uns zu kontaktieren.\n\n{% if a11yDocuments %}\nFolgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\nAus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\nIm Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('7pΒ2d9', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the cancellation invoice for your order with the number: {{ order.orderNumber }}<br>\n    <br>\n    If you have any questions, do not hesitate to contact us.\n    <br><br>\n\n    {% if a11yDocuments %}\n        For better accessibility we also provide an HTML version of the documents here:<br><br>\n        {% for a11y in a11yDocuments %}\n            {% set documentLink = rawUrl(\n                ''frontend.account.order.single.document.a11y'',\n                {\n                    documentId: a11y.documentId,\n                    deepLinkCode: a11y.deepLinkCode,\n                    fileType: a11y.fileExtension,\n                },\n                salesChannel.domains|first.url\n            )%}\n\n            - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n        {% endfor %}<br>\n\n        For data protection reasons the HTML version requires a login. <br><br>\n        In case of a guest order, you can use your email address and postal code of the billing address.<br>\n    {% endif %}\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the cancellation invoice for your order with the number: {{ order.orderNumber }}\n\nIf you have any questions, do not hesitate to contact us.\n\n{% if a11yDocuments %}\nFor better accessibility we also provide an HTML version of the documents here:\n\n{% for a11y in a11yDocuments %}\n    {% set documentLink = rawUrl(\n        ''frontend.account.order.single.document.a11y'',\n        {\n            documentId: a11y.documentId,\n            deepLinkCode: a11y.deepLinkCode,\n            fileType: a11y.fileExtension,\n        },\n        salesChannel.domains|first.url\n    )%}\n\n    - {{ documentLink }}\n{% endfor %}\n\nFor data protection reasons the HTML version requires a login.\n\nIn case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('V[r`0"', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Ihre Dateien von {{ salesChannel.name }} stehen bereit', 'Shopware Default Template', '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Mit dieser E-Mail erhalten Sie die Dateien zu der Bestellung: {{ order.orderNumber }}.\n    <br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt-Nr.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Produkt</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Downloads</strong></td>\n        </tr>\n\n        {% for lineItem in order.lineItems %}\n            {% if lineItem.downloads is defined and lineItem.downloads|length %}\n                {% block lineItem %}\n                    <tr>\n                        <td>{% if lineItem.payload.productNumber is defined %}{{ lineItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                        <td>{{ lineItem.label|u.wordwrap(80) }}</td>\n                        <td>\n                            {% for download in lineItem.downloads %}\n                                {% if download.accessGranted %}\n                                    {% set downloadLink = rawUrl(''frontend.account.order.single.download'', {''orderId'': order.id, ''downloadId'': download.id, ''deepLinkCode'': order.deepLinkCode}, salesChannel.domains|first.url) %}\n                                    <a href="{{ downloadLink }}" target="_blank">\n                                        {{ download.media.fileName }}.{{ download.media.fileExtension }}\n                                    </a><br>\n                                {% endif %}\n                            {% endfor %}\n                        </td>\n                    </tr>\n                {% endblock %}\n            {% endif %}\n        {% endfor %}\n    </table>\n\n    <br>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nMit dieser E-Mail erhalten Sie die Dateien zu der Bestellung: {{ order.orderNumber }}.\n\n{% for lineItem in order.lineItems %}{% if lineItem.downloads is defined and lineItem.downloads|length %}\n{{ lineItem.label|u.wordwrap(80) }} {% if lineItem.payload.productNumber is defined %}({{ lineItem.payload.productNumber|u.wordwrap(80) }}){% endif %}\n\n-------------------------------------\n{% for download in lineItem.downloads %}{% if download.accessGranted %}\n{{ download.media.fileName }}.{{ download.media.fileExtension }} - {% set downloadLink = rawUrl(''frontend.account.order.single.download'', {''orderId'': order.id, ''downloadId'': download.id, ''deepLinkCode'': order.deepLinkCode}, salesChannel.domains|first.url) %}{{ downloadLink }}\n{% endif %}{% endfor %}\n\n{% endif %}{% endfor %}\n', NULL, '[[regtime_]]', NULL),
('V[r`0"', '/_MpXT|', '{{ salesChannel.name }}', 'Your downloads from {{ salesChannel.name }} are ready', 'Shopware Default Template', '<div style="font-family:arial; font-size:12px;">\n\n    {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br>\n    <br>\n    Attached to this email you will find the files to the order: {{ order.orderNumber }}\n    <br>\n    <br>\n\n    <table border="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">\n        <tr>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Prod. no.</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Product</strong></td>\n            <td bgcolor="#F7F7F2" style="border-bottom:1px solid #cccccc;"><strong>Downloads</strong></td>\n        </tr>\n\n        {% for lineItem in order.lineItems %}\n            {% if lineItem.downloads is defined and lineItem.downloads|length %}\n                {% block lineItem %}\n                    <tr>\n                        <td>{% if lineItem.payload.productNumber is defined %}{{ lineItem.payload.productNumber|u.wordwrap(80) }}{% endif %}</td>\n                        <td>{{ lineItem.label|u.wordwrap(80) }}</td>\n                        <td>\n                            {% for download in lineItem.downloads %}\n                                {% if download.accessGranted %}\n                                    {% set downloadLink = rawUrl(''frontend.account.order.single.download'', {''orderId'': order.id, ''downloadId'': download.id, ''deepLinkCode'': order.deepLinkCode}, salesChannel.domains|first.url) %}\n                                    <a href="{{ downloadLink }}" target="_blank">\n                                        {{ download.media.fileName }}.{{ download.media.fileExtension }}\n                                    </a><br>\n                                {% endif %}\n                            {% endfor %}\n                        </td>\n                    </tr>\n                {% endblock %}\n            {% endif %}\n        {% endfor %}\n    </table>\n\n    <br>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nAttached to this email you will find the files to the order: {{ order.orderNumber }}\n\n{% for lineItem in order.lineItems %}{% if lineItem.downloads is defined and lineItem.downloads|length %}\n{{ lineItem.label|u.wordwrap(80) }} {% if lineItem.payload.productNumber is defined %}({{ lineItem.payload.productNumber|u.wordwrap(80) }}){% endif %}\n\n-------------------------------------\n{% for download in lineItem.downloads %}{% if download.accessGranted %}\n{{ download.media.fileName }}.{{ download.media.fileExtension }} - {% set downloadLink = rawUrl(''frontend.account.order.single.download'', {''orderId'': order.id, ''downloadId'': download.id, ''deepLinkCode'': order.deepLinkCode}, salesChannel.domains|first.url) %}{{ downloadLink }}\n{% endif %}{% endfor %}\n\n{% endif %}{% endfor %}\n', NULL, '[[regtime_]]', NULL),
('qrĹ(o', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neue Produktbewertung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <p>\n        Eine Produktbewertung wurde soeben {% if reviewFormData.id is defined %}bearbeitet{% else %}abgegeben{% endif %}.<br/>\n        <br/>\n        {% if reviewFormData.name is defined %}\n            Name: {{ reviewFormData.name }}{% if reviewFormData.lastName is defined %} {{ reviewFormData.lastName }}{% endif %}\n            <br/>\n        {% endif %}\n        {% if reviewFormData.email is defined %}\n            E-Mail-Adresse: {{ reviewFormData.email }}<br/>\n            <br>\n        {% endif %}\n        {% if product.translated.name is defined %}\n            Produkt: {{ product.translated.name }}<br/>\n            <br>\n        {% endif %}\n        Bewertung: {{ reviewFormData.points }}<br/>\n        <br/>\n        Titel: {{ reviewFormData.title }}<br/>\n        <br/>\n        Inhalt:<br/>\n        {{ reviewFormData.content|nl2br }}<br/>\n    </p>\n</div>\n', 'Eine Produktbewertung wurde soeben {% if reviewFormData.id is defined %}bearbeitet{% else %}abgegeben{% endif %}.\n\n{% if reviewFormData.name is defined %}Name: {{ reviewFormData.name }}{% if reviewFormData.lastName is defined %} {{ reviewFormData.lastName }}{% endif %}{% endif %}\n\n{% if reviewFormData.email is defined %}E-Mail-Adresse: {{ reviewFormData.email }}{% endif %}\n\n{% if product.translated.name is defined %}Produkt: {{ product.translated.name }}{% endif %}\n\nBewertung: {{ reviewFormData.points }}\n\nTitel: {{ reviewFormData.title }}\n\nInhalt:\n{{ reviewFormData.content }}\n', NULL, '[[regtime_]]', NULL),
('qrĹ(o', '/_MpXT|', '{{ salesChannel.name }}', 'New product review', NULL, '<div style="font-family:arial; font-size:12px;">\n    <p>\n        A product review has just been {% if reviewFormData.id is defined %}edited{% else %}sent{% endif %}.<br/>\n        <br/>\n        {% if reviewFormData.name is defined %}\n            Name: {{ reviewFormData.name }}{% if reviewFormData.lastName is defined %} {{ reviewFormData.lastName }}{% endif %}\n            <br/>\n        {% endif %}\n        {% if reviewFormData.email is defined %}\n            Email address: {{ reviewFormData.email }}<br/>\n            <br>\n        {% endif %}\n        {% if product.translated.name is defined %}\n            Product: {{ product.translated.name }}<br/>\n            <br>\n        {% endif %}\n        Rating: {{ reviewFormData.points }}<br/>\n        <br/>\n        Title: {{ reviewFormData.title }}<br/>\n        <br/>\n        Content:<br/>\n        {{ reviewFormData.content|nl2br }}<br/>\n    </p>\n</div>\n', 'A product review has just been {% if reviewFormData.id is defined %}edited{% else %}sent{% endif %}.\n\n{% if reviewFormData.name is defined %}Name: {{ reviewFormData.name }}{% if reviewFormData.lastName is defined %} {{ reviewFormData.lastName }}{% endif %}{% endif %}\n\n{% if reviewFormData.email is defined %}Email address: {{ reviewFormData.email }}{% endif %}\n\n{% if product.translated.name is defined %}Product: {{ product.translated.name }}{% endif %}\n\nRating: {{ reviewFormData.points }}\n\nTitle: {{ reviewFormData.title }}\n\nContent:\n{{ reviewFormData.content }}\n', NULL, '[[regtime_]]', NULL),
('rff4?', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('rff4?', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('r`', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('r`', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('6rm#X', 'jlrm%LL7WJ', '{{ salesChannel.name }}', 'Neues Dokument für Ihre Bestellung', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        der Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert.<br/>\n        <strong>Die Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        Den aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        Sollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n        <br><br>\n        {% if a11yDocuments %}\n            Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:<br><br>\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n\n            Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.<br><br>\n            Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nder Zahlungsstatus für Ihre Bestellung bei {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) vom {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''de-DE'') }} hat sich geändert!\nDie Bestellung hat jetzt den Zahlungsstatus: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nDen aktuellen Status Ihrer Bestellung können Sie auch jederzeit auf unserer Webseite im  Bereich "Mein Konto" - "Meine Bestellungen" abrufen: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nSollten Sie allerdings den Kauf ohne Registrierung, also ohne Anlage eines Kundenkontos, gewählt haben, steht Ihnen diese Möglichkeit nicht zur Verfügung.\n\n{% if a11yDocuments %}\n    Folgend stellen wir barrierefreie Dokumente als HTML-Version zur Verfügung:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                deepLinkCode: a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n    Aus Datenschutzgründen ist für die HTML-Version ein Login erforderlich.\n\n    Im Falle einer Gastbestellung können Sie Ihre E-Mail-Adresse und die Postleitzahl der Rechnungsanschrift verwenden.\n{% endif %}\n', NULL, '[[regtime_]]', NULL),
('6rm#X', '/_MpXT|', '{{ salesChannel.name }}', 'New document for your order', NULL, '<div style="font-family:arial; font-size:12px;">\n    <br/>\n    <p>\n        {% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},<br/>\n        <br/>\n        the status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }} has changed.<br/>\n        <strong>The new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.</strong><br/>\n        <br/>\n        You can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\n        </br>\n        However, in case you have purchased without a registration or a customer account, you do not have this option.\n        <br><br>\n        {% if a11yDocuments %}\n            For better accessibility we also provide an HTML version of the documents here:<br><br>\n\n            {% for a11y in a11yDocuments %}\n                {% set documentLink = rawUrl(\n                    ''frontend.account.order.single.document.a11y'',\n                    {\n                        documentId: a11y.documentId,\n                        deepLinkCode: a11y.deepLinkCode,\n                        fileType: a11y.fileExtension,\n                    },\n                    salesChannel.domains|first.url\n                )%}\n\n                - <a href="{{ documentLink }}" target="_blank">{{ documentLink }}</a> <br>\n            {% endfor %}<br>\n            For data protection reasons the HTML version requires a login. <br><br>\n            In case of a guest order, you can use your email address and postal code of the billing address.<br>\n        {% endif %}\n    </p>\n</div>\n', '{% if order.orderCustomer.salutation %}{{ order.orderCustomer.salutation.translated.letterName ~ '' '' }}{% endif %}{{ order.orderCustomer.firstName }} {{ order.orderCustomer.lastName }},\n\nthe status of your order at {{ salesChannel.translated.name }} (Number: {{ order.orderNumber }}) on {{ order.orderDateTime|format_datetime(''medium'', ''short'', locale=''en-GB'') }}  has changed.\nThe new status is as follows: {{ order.transactions.first.stateMachineState.translated.name }}.\n\nYou can check the current status of your order on our website under "My account" - "My orders" anytime: {{ rawUrl(''frontend.account.order.single.page'', { ''deepLinkCode'': order.deepLinkCode }, salesChannel.domains|first.url) }}\nHowever, in case you have purchased without a registration or a customer account, you do not have this option.\n\n{% if a11yDocuments %}\n    For better accessibility we also provide an HTML version of the documents here:\n\n    {% for a11y in a11yDocuments %}\n        {% set documentLink = rawUrl(\n            ''frontend.account.order.single.document.a11y'',\n            {\n                documentId: a11y.documentId,\n                ''deepLinkCode'': a11y.deepLinkCode,\n                fileType: a11y.fileExtension,\n            },\n            salesChannel.domains|first.url\n        )%}\n\n        - {{ documentLink }}\n    {% endfor %}\n\n    For data protection reasons the HTML version requires a login.\n\n    In case of a guest order, you can use your email address and postal code of the billing address.\n{% endif %}\n', NULL, '[[regtime_]]', NULL);
INSERT INTO `mail_template_translation` VALUES
('Gs޾+r', 'jlrm%LL7WJ', 'Admin', '{{ nameOfInviter }} hat dich eingeladen, {{ storeName }} beizutreten', 'Shopware Sso Admin Einladung', '<html lang="de">\n<head>\n    <title>Einladung</title>\n</head>\n<body style="font-family: Inter, Arial, Helvetica, sans-serif; font-weight: 500; line-height: 1.5;">\n<div style="width: 400px; padding: 50px;">\n    <div style="padding-bottom: 25px">\n        <svg width="186" height="40" viewBox="0 0 186 40" fill="none" xmlns="http://www.w3.org/2000/svg">\n            <path d="M54.5636 20.1837C52.8632 19.4458 51.4643 18.777 51.4643 17.6684C51.4643 16.8906 52.3436 16.1528 53.826 16.1528C55.1559 16.1528 56.304 16.4872 57.4849 17.0033C57.8192 17.1523 58.3351 17.1886 58.5931 16.6689L59.1854 15.484C59.407 15.0405 59.2217 14.5208 58.8148 14.2264C57.9645 13.6703 56.1914 12.9688 53.8224 12.9688C49.6803 12.9688 47.9871 15.484 47.9871 17.6284C47.9871 20.4381 50.1635 21.8447 52.7869 23.0296C55.1522 24.1019 56.4457 24.8397 56.4457 25.9883C56.4457 26.9515 55.6319 27.653 54.1894 27.653C52.1546 27.653 50.9374 26.9515 49.9382 26.3954C49.495 26.1373 49.0153 26.2463 48.83 26.6171L48.0525 28.2091C47.8672 28.5798 48.0888 28.9106 48.3468 29.096C49.3097 29.7611 51.2681 30.8334 53.9677 30.8334C57.7756 30.8334 60.0683 28.5035 60.0683 25.8393C60.0719 22.6625 57.7065 21.5176 54.5636 20.1837Z" fill="#189EFF"/>\n            <path d="M31.8908 35.6202C30.154 34.3117 27.5924 33.3158 24.8819 32.2653C21.6554 31.015 17.9965 29.5938 15.2496 27.4094C12.1394 24.9305 10.6242 21.8046 10.6242 17.8537C10.6242 14.3062 12.0958 11.2749 14.879 9.08314C18.0001 6.62608 22.7309 5.32485 28.5553 5.32485C30.1649 5.32485 31.7019 5.42299 33.1262 5.61926C33.2533 5.63744 33.3733 5.56838 33.4241 5.4557C33.4786 5.33939 33.4496 5.20491 33.3551 5.12131C29.6853 1.81736 24.94 0 19.9985 0C14.6573 0 9.63591 2.07905 5.85712 5.85915C2.08197 9.63562 0 14.6588 0 19.9982C0 25.3412 2.07833 30.3644 5.85712 34.1408C9.63228 37.9173 14.6537 40 19.9985 40C24.3151 40 28.4245 38.6443 31.8872 36.0818C31.9598 36.0273 32.0034 35.9437 32.0034 35.8528C32.0034 35.7619 31.9635 35.6747 31.8908 35.6202Z" fill="#189EFF"/>\n            <path d="M39.9062 18.1512C39.8989 18.0749 39.8626 18.0022 39.8044 17.9549C35.6332 14.4911 32.2578 13.0771 28.1556 13.0771C25.9683 13.0771 24.2896 13.5169 23.1705 14.382C22.2004 15.1308 21.688 16.1776 21.688 17.4025C21.688 20.8373 25.8847 22.4038 30.7462 24.2175C33.2497 25.1517 35.8403 26.1185 38.2166 27.4379C38.2602 27.4633 38.3075 27.4742 38.3547 27.4742C38.3874 27.4742 38.4201 27.467 38.4528 27.4561C38.5291 27.427 38.5945 27.3688 38.6236 27.2889C39.5319 24.9627 39.9934 22.5092 39.9934 19.9976C39.9897 19.4088 39.9643 18.7873 39.9062 18.1512Z" fill="#189EFF"/>\n            <path d="M154.829 30.626C155.341 30.5679 155.693 30.1935 155.693 29.7283V21.0522C155.693 16.6142 155.152 13.1758 149.44 13.1758C146.159 13.1758 143.612 14.0627 143.303 14.179C142.878 14.3316 142.609 14.6042 142.726 15.2221L143.074 16.6905C143.191 17.1921 143.536 17.5411 144.077 17.4248C145.004 17.1558 147.009 16.5742 149.055 16.5742C151.293 16.5742 151.987 17.85 151.911 20.6669C151.911 20.6669 150.174 20.1253 148.321 20.1253C143.728 20.1253 141.181 22.597 141.181 25.8791C141.181 29.5865 143.532 30.8405 146.89 30.8405C149.629 30.8405 152.449 30.8078 153.622 30.7314L154.829 30.626ZM151.871 27.4784C151.33 28.3652 149.4 28.1435 147.743 28.1108C145.89 28.0708 144.964 27.4239 144.964 25.8391C144.964 23.9854 146.544 22.9059 148.63 22.9059C150.25 22.9059 151.642 23.3711 151.871 23.5238V27.4784Z" fill="#189EFF"/>\n            <path d="M183.969 12.9719C185.092 12.9719 186 12.0669 186 10.9474C186 9.82789 185.092 8.92285 183.969 8.92285C182.846 8.92285 181.938 9.82789 181.938 10.9474C181.938 12.0669 182.846 12.9719 183.969 12.9719ZM183.969 9.2209C184.91 9.2209 185.68 9.99873 185.68 10.9474C185.68 11.896 184.914 12.6739 183.969 12.6739C183.028 12.6739 182.261 11.896 182.261 10.9474C182.261 9.99873 183.028 9.2209 183.969 9.2209Z" fill="#189EFF"/>\n            <path d="M183.279 11.9731H183.468C183.497 11.9731 183.522 11.9477 183.522 11.9186V11.1735H183.965L184.347 11.9368C184.358 11.9622 184.376 11.9731 184.409 11.9731H184.627C184.677 11.9731 184.696 11.9258 184.677 11.8895L184.278 11.1444C184.532 11.0426 184.71 10.8209 184.71 10.5519C184.71 10.203 184.423 9.92676 184.074 9.92676H183.279C183.246 9.92676 183.224 9.9522 183.224 9.98128V11.9186C183.224 11.9477 183.246 11.9731 183.279 11.9731ZM183.529 10.2103H184.049C184.238 10.2103 184.405 10.3666 184.405 10.5592C184.405 10.7627 184.238 10.9227 184.049 10.9227H183.529V10.2103Z" fill="#189EFF"/>\n            <path d="M71.4301 12.9727C68.7304 12.9727 66.881 14.452 66.4777 14.7501V7.12082C66.4777 6.71373 66.0707 6.30664 65.6638 6.30664H63.5927C63.1494 6.30664 62.7788 6.71373 62.7788 7.12082V30.0231C62.7788 30.4666 63.1494 30.8373 63.5927 30.8373H65.6274C66.147 30.8373 66.4777 30.5029 66.4777 30.0231V18.9663C66.8483 18.2285 68.3271 16.4875 70.9504 16.4875C73.1705 16.4875 74.3514 18.1522 74.3514 20.9618V30.0268C74.3514 30.4702 74.722 30.8409 75.1653 30.8409H77.2363C77.6433 30.8409 78.0502 30.4702 78.0502 30.0268V21.0381C78.0466 16.3784 76.2735 12.9727 71.4301 12.9727Z" fill="#189EFF"/>\n            <path d="M114.73 21.2162C114.526 15.4115 112.096 12.9727 106.496 12.9727C103.808 12.9727 100.599 13.7796 100.127 13.9867C99.5457 14.2375 99.1169 14.5356 99.1169 14.9427V15.2807V16.5201V20.5329V21.0781V36.6892C99.1169 37.1326 99.4876 37.5033 99.9308 37.5033H101.646C102.202 37.5033 102.532 37.1689 102.532 36.6892L102.529 30.5429C103.048 30.6773 105.704 30.9027 107.921 30.8336C111.874 30.71 114.526 27.8386 114.748 22.9899C114.781 22.332 114.73 21.2162 114.73 21.2162ZM111.158 22.9863C111.082 26.2757 110.126 27.7296 107.358 27.8822C105.988 27.9586 102.754 27.5769 102.754 27.5769C102.62 27.5333 102.529 27.4752 102.529 27.3516L102.525 20.6855V16.9054C102.525 16.8036 102.601 16.72 102.703 16.7091C103.085 16.6692 104.484 16.2185 106.496 16.2185C109.868 16.2185 111.056 16.7128 111.165 20.9836C111.173 21.5469 111.176 22.3357 111.158 22.9863Z" fill="#189EFF"/>\n            <path d="M139.223 13.3434H137.672C137.228 13.3434 136.6 13.3434 136.378 13.8632L133.642 23.6987H133.569L128.984 13.3797C128.911 13.158 128.65 12.9727 128.246 12.9727H127.988C127.654 12.9727 127.396 13.158 127.287 13.3797L122.662 23.6623H122.589L119.78 13.8632C119.708 13.5288 119.337 13.3434 119.043 13.3434H116.823C116.231 13.3434 115.973 13.7868 116.231 14.3066L121.223 30.3938C121.296 30.6519 121.557 30.8373 121.924 30.8373H122.146C122.516 30.8373 122.738 30.6519 122.811 30.4302L128.061 18.8173H128.134L133.348 30.4302C133.46 30.6519 133.718 30.8373 134.085 30.8373H134.234C134.605 30.8373 134.936 30.6519 135.012 30.3938L139.892 14.3066C140.15 13.7868 139.815 13.3434 139.223 13.3434Z" fill="#189EFF"/>\n            <path d="M166.496 13.1758C166.405 13.1758 166.321 13.1831 166.23 13.1867C166.081 13.1831 165.936 13.1758 165.78 13.1758C164.893 13.1758 164.043 13.2049 163.247 13.2448C161.714 13.3066 160.806 13.4229 160.159 13.4956C160.159 13.4956 159.745 13.5356 159.261 13.5974C158.938 13.6374 158.702 13.7719 158.557 13.9572C158.458 14.0626 158.397 14.1971 158.397 14.3607V14.4189V14.7569V15.9963V19.4348V30.019C158.397 30.4625 158.767 30.8332 159.211 30.8332H160.911C161.612 30.8332 162.096 30.7605 162.096 30.019V19.4348V17.0068C162.096 16.905 162.255 16.7778 162.343 16.7233C162.76 16.4725 163.763 16.2907 165.78 16.2907C165.976 16.2907 166.103 16.2944 166.249 16.298C166.71 16.3416 167.44 16.4834 167.677 16.6179C168.047 16.8032 168.49 16.6905 168.712 16.2108L169.599 14.7605C170.155 13.6192 168.123 13.1758 166.496 13.1758Z" fill="#189EFF"/>\n            <path d="M178.199 12.9727C173.061 12.9727 169.697 17.0799 169.697 21.885C169.697 26.7664 173.061 30.8336 178.235 30.8336C181.08 30.8336 183.337 29.7977 184.557 28.7255C185.073 28.2821 184.928 27.9477 184.63 27.5806L183.631 26.0285C183.337 25.5851 183.002 25.6941 182.632 25.9558C181.596 26.6937 180.412 27.3988 178.453 27.3988C175.459 27.3988 173.388 25.0326 173.352 22.7391H185.146C185.517 22.7391 185.884 22.4411 185.924 21.9976C185.96 21.7032 185.996 21.1108 185.996 20.8127C185.996 16.2657 182.635 12.9727 178.199 12.9727ZM173.541 19.9986C173.799 17.8541 175.427 16.1167 178.126 16.1167C180.641 16.1167 182.268 17.9304 182.341 19.9986H173.541V19.9986Z" fill="#189EFF"/>\n            <path d="M96.1556 18.2573C95.7704 17.1559 95.229 16.2109 94.5351 15.4258C93.8411 14.6407 93.009 14.0337 92.0461 13.6085C91.0833 13.1832 89.7171 12.9688 88.5835 12.9688C87.4498 12.9688 86.0873 13.1832 85.1244 13.6085C84.1615 14.0337 83.3331 14.6407 82.6355 15.4258C81.9415 16.2109 81.4001 17.1559 81.015 18.2573C80.6298 19.3586 80.4373 20.5762 80.4373 21.9065C80.4373 23.2586 80.6298 24.4799 81.015 25.5703C81.4001 26.6607 81.9415 27.5985 82.6355 28.3836C83.3295 29.1687 84.1615 29.7757 85.1244 30.2009C86.0873 30.6262 87.4498 30.837 88.5835 30.837C89.7171 30.837 91.0833 30.6262 92.0461 30.2009C93.009 29.7757 93.8374 29.1687 94.5351 28.3836C95.229 27.5985 95.7704 26.6607 96.1556 25.5703C96.5407 24.4799 96.7333 23.2586 96.7333 21.9065C96.7333 20.5762 96.5407 19.3586 96.1556 18.2573ZM88.489 27.8929C85.4042 27.8929 83.8491 25.2795 83.8491 22.0555C83.8491 18.8315 85.4005 16.2182 88.489 16.2182C91.5774 16.2182 93.1289 18.8315 93.1289 22.0555C93.1289 25.2795 91.5738 27.8929 88.489 27.8929Z" fill="#189EFF"/>\n        </svg>\n    </div>\n    <div>\n        <p><span style="font-weight: bold">{{ nameOfInviter }}</span> hat Dich eingeladen, am Shopware-Store <span style="font-weight: bold">{{ storeName }}</span> mitzuarbeiten.</p>\n        <p>Um Zugriff auf den Shop zu erhalten, logge Dich bitte entweder ein oder registriere Dich mit der E-Mail-Adresse <span style="font-weight: bold">{{ invitedEmailAddress }}</span>.</p>\n    </div>\n    <div style="padding-top: 25px;">\n        <a href="{{ signupUrl }}" style="border: 1px solid; border-radius: 5px; background: #0870FF; color: #fff; padding:10px 15px; text-decoration: none; font-size: 0.9em; font-weight:bold;">Loslegen</a>\n    </div>\n</div>\n</body>\n</html>\n', '{{ nameOfInviter }} hat Dich eingeladen, am Shopware-Store {{ storeName }} mitzuarbeiten.\n\nUm Zugriff auf den Shop zu erhalten, logge Dich bitte entweder ein oder registriere Dich mit der E-Mail-Adresse {{ invitedEmailAddress }}.\n\n{{ signupUrl }}\n', NULL, '[[regtime_]]', NULL),
('Gs޾+r', '/_MpXT|', 'Admin', '{{ nameOfInviter }} invited you to join {{ storeName }}', 'Shopware Sso admin Invitation', '<html lang="en">\n<head>\n    <title>Invitation</title>\n</head>\n<body style="font-family: Inter, Arial, Helvetica, sans-serif; font-weight: 500; line-height: 1.5;">\n<div style="width: 400px; padding: 50px;">\n    <div style="padding-bottom: 25px">\n        <svg width="186" height="40" viewBox="0 0 186 40" fill="none" xmlns="http://www.w3.org/2000/svg">\n            <path d="M54.5636 20.1837C52.8632 19.4458 51.4643 18.777 51.4643 17.6684C51.4643 16.8906 52.3436 16.1528 53.826 16.1528C55.1559 16.1528 56.304 16.4872 57.4849 17.0033C57.8192 17.1523 58.3351 17.1886 58.5931 16.6689L59.1854 15.484C59.407 15.0405 59.2217 14.5208 58.8148 14.2264C57.9645 13.6703 56.1914 12.9688 53.8224 12.9688C49.6803 12.9688 47.9871 15.484 47.9871 17.6284C47.9871 20.4381 50.1635 21.8447 52.7869 23.0296C55.1522 24.1019 56.4457 24.8397 56.4457 25.9883C56.4457 26.9515 55.6319 27.653 54.1894 27.653C52.1546 27.653 50.9374 26.9515 49.9382 26.3954C49.495 26.1373 49.0153 26.2463 48.83 26.6171L48.0525 28.2091C47.8672 28.5798 48.0888 28.9106 48.3468 29.096C49.3097 29.7611 51.2681 30.8334 53.9677 30.8334C57.7756 30.8334 60.0683 28.5035 60.0683 25.8393C60.0719 22.6625 57.7065 21.5176 54.5636 20.1837Z" fill="#189EFF"/>\n            <path d="M31.8908 35.6202C30.154 34.3117 27.5924 33.3158 24.8819 32.2653C21.6554 31.015 17.9965 29.5938 15.2496 27.4094C12.1394 24.9305 10.6242 21.8046 10.6242 17.8537C10.6242 14.3062 12.0958 11.2749 14.879 9.08314C18.0001 6.62608 22.7309 5.32485 28.5553 5.32485C30.1649 5.32485 31.7019 5.42299 33.1262 5.61926C33.2533 5.63744 33.3733 5.56838 33.4241 5.4557C33.4786 5.33939 33.4496 5.20491 33.3551 5.12131C29.6853 1.81736 24.94 0 19.9985 0C14.6573 0 9.63591 2.07905 5.85712 5.85915C2.08197 9.63562 0 14.6588 0 19.9982C0 25.3412 2.07833 30.3644 5.85712 34.1408C9.63228 37.9173 14.6537 40 19.9985 40C24.3151 40 28.4245 38.6443 31.8872 36.0818C31.9598 36.0273 32.0034 35.9437 32.0034 35.8528C32.0034 35.7619 31.9635 35.6747 31.8908 35.6202Z" fill="#189EFF"/>\n            <path d="M39.9062 18.1512C39.8989 18.0749 39.8626 18.0022 39.8044 17.9549C35.6332 14.4911 32.2578 13.0771 28.1556 13.0771C25.9683 13.0771 24.2896 13.5169 23.1705 14.382C22.2004 15.1308 21.688 16.1776 21.688 17.4025C21.688 20.8373 25.8847 22.4038 30.7462 24.2175C33.2497 25.1517 35.8403 26.1185 38.2166 27.4379C38.2602 27.4633 38.3075 27.4742 38.3547 27.4742C38.3874 27.4742 38.4201 27.467 38.4528 27.4561C38.5291 27.427 38.5945 27.3688 38.6236 27.2889C39.5319 24.9627 39.9934 22.5092 39.9934 19.9976C39.9897 19.4088 39.9643 18.7873 39.9062 18.1512Z" fill="#189EFF"/>\n            <path d="M154.829 30.626C155.341 30.5679 155.693 30.1935 155.693 29.7283V21.0522C155.693 16.6142 155.152 13.1758 149.44 13.1758C146.159 13.1758 143.612 14.0627 143.303 14.179C142.878 14.3316 142.609 14.6042 142.726 15.2221L143.074 16.6905C143.191 17.1921 143.536 17.5411 144.077 17.4248C145.004 17.1558 147.009 16.5742 149.055 16.5742C151.293 16.5742 151.987 17.85 151.911 20.6669C151.911 20.6669 150.174 20.1253 148.321 20.1253C143.728 20.1253 141.181 22.597 141.181 25.8791C141.181 29.5865 143.532 30.8405 146.89 30.8405C149.629 30.8405 152.449 30.8078 153.622 30.7314L154.829 30.626ZM151.871 27.4784C151.33 28.3652 149.4 28.1435 147.743 28.1108C145.89 28.0708 144.964 27.4239 144.964 25.8391C144.964 23.9854 146.544 22.9059 148.63 22.9059C150.25 22.9059 151.642 23.3711 151.871 23.5238V27.4784Z" fill="#189EFF"/>\n            <path d="M183.969 12.9719C185.092 12.9719 186 12.0669 186 10.9474C186 9.82789 185.092 8.92285 183.969 8.92285C182.846 8.92285 181.938 9.82789 181.938 10.9474C181.938 12.0669 182.846 12.9719 183.969 12.9719ZM183.969 9.2209C184.91 9.2209 185.68 9.99873 185.68 10.9474C185.68 11.896 184.914 12.6739 183.969 12.6739C183.028 12.6739 182.261 11.896 182.261 10.9474C182.261 9.99873 183.028 9.2209 183.969 9.2209Z" fill="#189EFF"/>\n            <path d="M183.279 11.9731H183.468C183.497 11.9731 183.522 11.9477 183.522 11.9186V11.1735H183.965L184.347 11.9368C184.358 11.9622 184.376 11.9731 184.409 11.9731H184.627C184.677 11.9731 184.696 11.9258 184.677 11.8895L184.278 11.1444C184.532 11.0426 184.71 10.8209 184.71 10.5519C184.71 10.203 184.423 9.92676 184.074 9.92676H183.279C183.246 9.92676 183.224 9.9522 183.224 9.98128V11.9186C183.224 11.9477 183.246 11.9731 183.279 11.9731ZM183.529 10.2103H184.049C184.238 10.2103 184.405 10.3666 184.405 10.5592C184.405 10.7627 184.238 10.9227 184.049 10.9227H183.529V10.2103Z" fill="#189EFF"/>\n            <path d="M71.4301 12.9727C68.7304 12.9727 66.881 14.452 66.4777 14.7501V7.12082C66.4777 6.71373 66.0707 6.30664 65.6638 6.30664H63.5927C63.1494 6.30664 62.7788 6.71373 62.7788 7.12082V30.0231C62.7788 30.4666 63.1494 30.8373 63.5927 30.8373H65.6274C66.147 30.8373 66.4777 30.5029 66.4777 30.0231V18.9663C66.8483 18.2285 68.3271 16.4875 70.9504 16.4875C73.1705 16.4875 74.3514 18.1522 74.3514 20.9618V30.0268C74.3514 30.4702 74.722 30.8409 75.1653 30.8409H77.2363C77.6433 30.8409 78.0502 30.4702 78.0502 30.0268V21.0381C78.0466 16.3784 76.2735 12.9727 71.4301 12.9727Z" fill="#189EFF"/>\n            <path d="M114.73 21.2162C114.526 15.4115 112.096 12.9727 106.496 12.9727C103.808 12.9727 100.599 13.7796 100.127 13.9867C99.5457 14.2375 99.1169 14.5356 99.1169 14.9427V15.2807V16.5201V20.5329V21.0781V36.6892C99.1169 37.1326 99.4876 37.5033 99.9308 37.5033H101.646C102.202 37.5033 102.532 37.1689 102.532 36.6892L102.529 30.5429C103.048 30.6773 105.704 30.9027 107.921 30.8336C111.874 30.71 114.526 27.8386 114.748 22.9899C114.781 22.332 114.73 21.2162 114.73 21.2162ZM111.158 22.9863C111.082 26.2757 110.126 27.7296 107.358 27.8822C105.988 27.9586 102.754 27.5769 102.754 27.5769C102.62 27.5333 102.529 27.4752 102.529 27.3516L102.525 20.6855V16.9054C102.525 16.8036 102.601 16.72 102.703 16.7091C103.085 16.6692 104.484 16.2185 106.496 16.2185C109.868 16.2185 111.056 16.7128 111.165 20.9836C111.173 21.5469 111.176 22.3357 111.158 22.9863Z" fill="#189EFF"/>\n            <path d="M139.223 13.3434H137.672C137.228 13.3434 136.6 13.3434 136.378 13.8632L133.642 23.6987H133.569L128.984 13.3797C128.911 13.158 128.65 12.9727 128.246 12.9727H127.988C127.654 12.9727 127.396 13.158 127.287 13.3797L122.662 23.6623H122.589L119.78 13.8632C119.708 13.5288 119.337 13.3434 119.043 13.3434H116.823C116.231 13.3434 115.973 13.7868 116.231 14.3066L121.223 30.3938C121.296 30.6519 121.557 30.8373 121.924 30.8373H122.146C122.516 30.8373 122.738 30.6519 122.811 30.4302L128.061 18.8173H128.134L133.348 30.4302C133.46 30.6519 133.718 30.8373 134.085 30.8373H134.234C134.605 30.8373 134.936 30.6519 135.012 30.3938L139.892 14.3066C140.15 13.7868 139.815 13.3434 139.223 13.3434Z" fill="#189EFF"/>\n            <path d="M166.496 13.1758C166.405 13.1758 166.321 13.1831 166.23 13.1867C166.081 13.1831 165.936 13.1758 165.78 13.1758C164.893 13.1758 164.043 13.2049 163.247 13.2448C161.714 13.3066 160.806 13.4229 160.159 13.4956C160.159 13.4956 159.745 13.5356 159.261 13.5974C158.938 13.6374 158.702 13.7719 158.557 13.9572C158.458 14.0626 158.397 14.1971 158.397 14.3607V14.4189V14.7569V15.9963V19.4348V30.019C158.397 30.4625 158.767 30.8332 159.211 30.8332H160.911C161.612 30.8332 162.096 30.7605 162.096 30.019V19.4348V17.0068C162.096 16.905 162.255 16.7778 162.343 16.7233C162.76 16.4725 163.763 16.2907 165.78 16.2907C165.976 16.2907 166.103 16.2944 166.249 16.298C166.71 16.3416 167.44 16.4834 167.677 16.6179C168.047 16.8032 168.49 16.6905 168.712 16.2108L169.599 14.7605C170.155 13.6192 168.123 13.1758 166.496 13.1758Z" fill="#189EFF"/>\n            <path d="M178.199 12.9727C173.061 12.9727 169.697 17.0799 169.697 21.885C169.697 26.7664 173.061 30.8336 178.235 30.8336C181.08 30.8336 183.337 29.7977 184.557 28.7255C185.073 28.2821 184.928 27.9477 184.63 27.5806L183.631 26.0285C183.337 25.5851 183.002 25.6941 182.632 25.9558C181.596 26.6937 180.412 27.3988 178.453 27.3988C175.459 27.3988 173.388 25.0326 173.352 22.7391H185.146C185.517 22.7391 185.884 22.4411 185.924 21.9976C185.96 21.7032 185.996 21.1108 185.996 20.8127C185.996 16.2657 182.635 12.9727 178.199 12.9727ZM173.541 19.9986C173.799 17.8541 175.427 16.1167 178.126 16.1167C180.641 16.1167 182.268 17.9304 182.341 19.9986H173.541V19.9986Z" fill="#189EFF"/>\n            <path d="M96.1556 18.2573C95.7704 17.1559 95.229 16.2109 94.5351 15.4258C93.8411 14.6407 93.009 14.0337 92.0461 13.6085C91.0833 13.1832 89.7171 12.9688 88.5835 12.9688C87.4498 12.9688 86.0873 13.1832 85.1244 13.6085C84.1615 14.0337 83.3331 14.6407 82.6355 15.4258C81.9415 16.2109 81.4001 17.1559 81.015 18.2573C80.6298 19.3586 80.4373 20.5762 80.4373 21.9065C80.4373 23.2586 80.6298 24.4799 81.015 25.5703C81.4001 26.6607 81.9415 27.5985 82.6355 28.3836C83.3295 29.1687 84.1615 29.7757 85.1244 30.2009C86.0873 30.6262 87.4498 30.837 88.5835 30.837C89.7171 30.837 91.0833 30.6262 92.0461 30.2009C93.009 29.7757 93.8374 29.1687 94.5351 28.3836C95.229 27.5985 95.7704 26.6607 96.1556 25.5703C96.5407 24.4799 96.7333 23.2586 96.7333 21.9065C96.7333 20.5762 96.5407 19.3586 96.1556 18.2573ZM88.489 27.8929C85.4042 27.8929 83.8491 25.2795 83.8491 22.0555C83.8491 18.8315 85.4005 16.2182 88.489 16.2182C91.5774 16.2182 93.1289 18.8315 93.1289 22.0555C93.1289 25.2795 91.5738 27.8929 88.489 27.8929Z" fill="#189EFF"/>\n        </svg>\n    </div>\n    <div>\n        <p><span style="font-weight: bold">{{ nameOfInviter }}</span> has invited you to collaborate on the Shopware store <span style="font-weight: bold">{{ storeName }}</span>.</p>\n        <p>To get access to the store, please either log in or sign up using the email address <span style="font-weight: bold">{{ invitedEmailAddress }}</span>.</p>\n    </div>\n    <div style="padding-top: 25px;">\n        <a href="{{ signupUrl }}" style="border: 1px solid; border-radius: 5px; background: #0870FF; color: #fff; padding:10px 15px; text-decoration: none; font-size: 0.9em; font-weight:bold;">Get started</a>\n    </div>\n</div>\n</body>\n</html>\n', '{{ nameOfInviter }} has invited you to collaborate on the Shopware store {{ storeName }}.\n\nTo get access to the store, please either log in or sign up using the email address {{ invitedEmailAddress }}.\n\n{{ signupUrl }}\n', NULL, '[[regtime_]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `mail_template_type`
--

CREATE TABLE `mail_template_type` (
  `id` binary(16) NOT NULL,
  `technical_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `available_entities` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` datetime(3) NOT NULL,
  `updated_at` datetime(3) DEFAULT NULL,
  `template_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq.mail_template_type.technical_name` (`technical_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_template_type`
--

INSERT INTO `mail_template_type` VALUES
('wp884', 'customer_register', '{"customer":"customer","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"cf7892d60b794b65b7badae58462715b","salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"b8794be7a6d840e99ffc76f17320df2b","defaultShippingAddressId":"b8794be7a6d840e99ffc76f17320df2b","customerNumber":"10060","salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","company":null,"email":"testing@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":"2021-03-29T12:53:05.736+00:00","lastLogin":null,"newsletter":false,"birthday":null,"lastOrderDate":null,"orderCount":0,"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":{"salutationKey":"mr","displayName":"Mr.","letterName":"Dear Mr.","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"bd3fd9c43c754e02a11d92b7f7cedc4f","versionId":null,"translated":{"displayName":"Mr.","letterName":"Dear Mr."},"createdAt":"2021-03-09T09:43:59.659+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bd3fd9c43c754e02a11d92b7f7cedc4f"},"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":[{"customerId":"c3445cbcbcec4678b3f15639a892afd1","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","countryStateId":null,"salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","zipcode":"12345","city":"Musterstadt","company":null,"department":null,"title":null,"street":"Musterstr. 2","phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":null,"countryState":null,"salutation":null,"customer":null,"customFields":null,"_uniqueIdentifier":"b8794be7a6d840e99ffc76f17320df2b","versionId":null,"translated":[],"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b8794be7a6d840e99ffc76f17320df2b"}],"orderCustomers":null,"autoIncrement":62,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":null,"requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"c3445cbcbcec4678b3f15639a892afd1","versionId":null,"translated":[],"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c3445cbcbcec4678b3f15639a892afd1"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('wp88ț', 'newsletterDoubleOptIn', '{"newsletterRecipient":"newsletter_recipient","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"newsletterRecipient":{"email":"test@example.com","title":null,"firstName":"Max","lastName":"Mustermann","zipCode":"48624","city":"Sch\\u00f6ppingen","street":null,"status":"direct","hash":"7ee7a7cb1fb741f387b07f4b86a67124","salutationId":"44706b43d8bd4b34a4582185c3fd07f1","salutation":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"customFields":null,"confirmedAt":null,"tags":null,"_uniqueIdentifier":"e622fb2224fc4baa9125e0bfd0f2a927","versionId":null,"translated":[],"createdAt":"2021-03-29T15:10:10.880+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e622fb2224fc4baa9125e0bfd0f2a927"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('wp88', 'newsletterRegister', '{"newsletterRecipient":"newsletter_recipient","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"newsletterRecipient":{"email":"test@example.com","title":null,"firstName":"Max","lastName":"Mustermann","zipCode":"48624","city":"Sch\\u00f6ppingen","street":null,"status":"direct","hash":"7ee7a7cb1fb741f387b07f4b86a67124","salutationId":"44706b43d8bd4b34a4582185c3fd07f1","salutation":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"customFields":null,"confirmedAt":null,"tags":null,"_uniqueIdentifier":"e622fb2224fc4baa9125e0bfd0f2a927","versionId":null,"translated":[],"createdAt":"2021-03-29T15:10:10.880+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e622fb2224fc4baa9125e0bfd0f2a927"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('wp88F', 'order_confirmation_mail', '{"order":"order","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"08757990bf314633b5d0fa55efc5e63d","billingAddressId":"3e112279819f4c1d8f5d7107f6b33a25","orderDateTime":"2021-04-12T08:39:51.371+00:00","orderDate":"2021-04-12T00:00:00.000+00:00","price":{"netPrice":799.0700000000000500222085975110530853271484375,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"positionPrice":855,"taxStatus":"gross","rawTotal":855,"extensions":[]},"amountTotal":855,"amountNet":799.0700000000000500222085975110530853271484375,"positionPrice":855,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":7,"price":0,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"e96e47f99c844f1b9997e613bc621f65","salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"7f0eef7a233a41f886a2fc69b0ca79df","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"69867b98038e4d41bde2382bbb5810fc","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"c9036a6e1bf84f769f06d0ba6490d75b","defaultShippingAddressId":"3fc4a0d7787c466daeb6fade1b51c4fd","customerNumber":"1337","salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","company":null,"password":"$2y$10$9xvO2tM3dEfcOG4lO9CA3eogJD1wkYhW7erQv0d14AAUA9u0V5Dpy","email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-12T08:39:36.376+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-12T08:39:51.371+00:00","orderCount":4,"createdAt":"2021-04-12T07:54:30.118+00:00","updatedAt":"2021-04-12T08:39:51.671+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"7f0eef7a233a41f886a2fc69b0ca79df","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7f0eef7a233a41f886a2fc69b0ca79df"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"4f602c9cb4994a7a96a06630d9f62cee","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-12T07:52:38.207+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"4f602c9cb4994a7a96a06630d9f62cee"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"e61b6f06cbe5421ebb41d428ce457ac2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.542+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e61b6f06cbe5421ebb41d428ce457ac2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-12T07:52:38.772+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":null,"addresses":[{"countryId":"f68b900afd7644dfb8b7f5392183efd9","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Saint Barth\\u00e9lemy","iso":"BL","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"BLM","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"f68b900afd7644dfb8b7f5392183efd9","versionId":null,"translated":{"name":"Saint Barth\\u00e9lemy","customFields":[]},"createdAt":"2021-04-12T07:52:46.949+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"f68b900afd7644dfb8b7f5392183efd9"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"3e112279819f4c1d8f5d7107f6b33a25","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.556+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"3e112279819f4c1d8f5d7107f6b33a25","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Kazakhstan","iso":"KZ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"KAZ","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","versionId":null,"translated":{"name":"Kazakhstan","customFields":[]},"createdAt":"2021-04-12T07:52:46.847+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"7796bf226130426fb71bef6270dcf8e3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.561+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7796bf226130426fb71bef6270dcf8e3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","shippingOrderAddressId":"7796bf226130426fb71bef6270dcf8e3","shippingMethodId":"7ab645770dbb4a648268248492ed5f0a","trackingCodes":[],"shippingDateEarliest":"2021-04-13T00:00:00.000+00:00","shippingDateLatest":"2021-04-15T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":7,"price":0,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Kazakhstan","iso":"KZ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"KAZ","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","versionId":null,"translated":{"name":"Kazakhstan","customFields":[]},"createdAt":"2021-04-12T07:52:46.847+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"7796bf226130426fb71bef6270dcf8e3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.561+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7796bf226130426fb71bef6270dcf8e3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"4753bf682a1640d8a89ca672f3982b1b","stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"2669c221e38a477980f8bef5e9cccdaf","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"4753bf682a1640d8a89ca672f3982b1b","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.108+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"4753bf682a1640d8a89ca672f3982b1b"},"shippingMethod":{"name":"Standard","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"d5352c5bdd10417db10125050af38b64","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"d5352c5bdd10417db10125050af38b64","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-12T07:52:38.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"d5352c5bdd10417db10125050af38b64"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"132058274b4c4ba5b292e78b79e7fd90","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"7ab645770dbb4a648268248492ed5f0a","versionId":null,"translated":{"name":"Standard","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-12T07:52:38.814+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ab645770dbb4a648268248492ed5f0a"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"35bf2776cc6c4857980ed8a651bf6060","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.565+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"35bf2776cc6c4857980ed8a651bf6060","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","identifier":"f47e72bf6d0e40c4aa290330a7ffd44d","referencedId":"f47e72bf6d0e40c4aa290330a7ffd44d","productId":"f47e72bf6d0e40c4aa290330a7ffd44d","quantity":1,"unitPrice":855,"totalPrice":855,"label":"Aerodynamic Cotton Brand Muffin","description":null,"good":true,"removable":true,"coverId":"5f3c1ac1ce3744009cc8613f1524fc80","stackable":true,"position":1,"price":{"unitPrice":855,"quantity":1,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":855,"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"40afe75845934469b3528a06573bd395","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-12 07:54:39.961","optionIds":null,"isCloseout":false,"categoryIds":["e38a91bb89b94313acd546bb813c9bde","f5fd0ad1b7904012adeab43c5571249f","1f232fdf7e744a6188e70373c64059ec"],"propertyIds":["08342bf3c949475081380d7f18ac3013","1f4a747cd9084a91b5b3354483f64d5c","242c6322e09642db9a6dd34e4945563b","2f8fdf5146e3495b93f1477a13b30a70","33443da934024d7d9a4e949f2dbade33","38414ab339ae45e8a34c742f74ca951c","517fa1113cc749cb82acca7a7a911f51","5db7f83261c746818e2cb119d7b690e3","6b463dcccdcf44b69c1d64aaa99f465a","7b0924b10e6c4e7c8cebb21f779014fe","95746abcc9fe46cc93277210e7184e38","98a65897b93440e7b5f848e51efa53df","ad24e8a73b0f4018827e267346c08254","af8b23072130451b8a80b1a94af2a529","c021d77e23eb44568bd321158519b807","e4a316f3eaf64983a6af02654f7d2fc7","fdfb81dcdbb2400aab7ac18e9c967350","fe4960c9a2df4bfd9e977b473983bd86"],"releaseDate":null,"customFields":[],"productNumber":"dc0f18c1a31f4f189e7ef7d921052fe6","manufacturerId":"0f721bed5f054043a2b5d0986f55757c","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":31.570093457943923,\\"gross\\":33.78,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"2095623819c546a2893afe2db1557bec","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.572+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"2095623819c546a2893afe2db1557bec","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","paymentMethodId":"69867b98038e4d41bde2382bbb5810fc","amount":{"unitPrice":855,"quantity":1,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"69867b98038e4d41bde2382bbb5810fc","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-12T07:52:38.793+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"69867b98038e4d41bde2382bbb5810fc"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"3e52d2ea8045489bbc13528a1cd68170","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"db5897dec897426985f29b105875e6a8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.129+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"db5897dec897426985f29b105875e6a8"},"stateId":"db5897dec897426985f29b105875e6a8","customFields":null,"_uniqueIdentifier":"a57d8d1c18f64f55bfb48b39ceec660f","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.575+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"a57d8d1c18f64f55bfb48b39ceec660f","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"s2i1jbau4LeH0R7RUDrzHo8Y7KglbZ_D","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"040ddecd833d4c98a1935f19b5617e8c","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"ed244ea9e52c4497ab57c4a12b10d962","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"ed244ea9e52c4497ab57c4a12b10d962"},"stateId":"ed244ea9e52c4497ab57c4a12b10d962","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["132058274b4c4ba5b292e78b79e7fd90","5bbbd6951e8f4c91a8de6544a5fb8ea2","b3963d2ae9f04c8ebd7ea09304f6294f","8583f4c0d9254ea091c8354a180a3a6d"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"e96e47f99c844f1b9997e613bc621f65","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.578+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e96e47f99c844f1b9997e613bc621f65","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"69867b98038e4d41bde2382bbb5810fc","shippingMethodId":"7ab645770dbb4a648268248492ed5f0a","countryId":"77304b7727794e1c9460f192a55d66cf","navigationCategoryId":"e38a91bb89b94313acd546bb813c9bde","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCOGFIOGDVTJLZOVZ5WLEWEA","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"c6dd40a58bfd4c54979eaf1c6be56cb1","snippetSet":null,"salesChannelId":"08757990bf314633b5d0fa55efc5e63d","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"46d268ec94c5430295ec21fa5952ca53","versionId":null,"translated":[],"createdAt":"2021-04-12T07:53:19.452+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"46d268ec94c5430295ec21fa5952ca53"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["69867b98038e4d41bde2382bbb5810fc","81fcce6eda1e4ee994281cf6c41e1208","8b9ed316d2da4756ab995bd0fa46ef87","9c8bb5aa0c974f87b44b4a61a9d61d0a"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"08757990bf314633b5d0fa55efc5e63d","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-12T07:53:19.452+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"08757990bf314633b5d0fa55efc5e63d","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('wp88', 'customer_group_change_accept', '{"customer":"customer","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"cf7892d60b794b65b7badae58462715b","salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"b8794be7a6d840e99ffc76f17320df2b","defaultShippingAddressId":"b8794be7a6d840e99ffc76f17320df2b","customerNumber":"10060","salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","company":null,"email":"testing@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":"2021-03-29T12:53:05.736+00:00","lastLogin":null,"newsletter":false,"birthday":null,"lastOrderDate":null,"orderCount":0,"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":{"salutationKey":"mr","displayName":"Mr.","letterName":"Dear Mr.","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"bd3fd9c43c754e02a11d92b7f7cedc4f","versionId":null,"translated":{"displayName":"Mr.","letterName":"Dear Mr."},"createdAt":"2021-03-09T09:43:59.659+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bd3fd9c43c754e02a11d92b7f7cedc4f"},"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":[{"customerId":"c3445cbcbcec4678b3f15639a892afd1","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","countryStateId":null,"salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","zipcode":"12345","city":"Musterstadt","company":null,"department":null,"title":null,"street":"Musterstr. 2","phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":null,"countryState":null,"salutation":null,"customer":null,"customFields":null,"_uniqueIdentifier":"b8794be7a6d840e99ffc76f17320df2b","versionId":null,"translated":[],"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b8794be7a6d840e99ffc76f17320df2b"}],"orderCustomers":null,"autoIncrement":62,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":null,"requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"c3445cbcbcec4678b3f15639a892afd1","versionId":null,"translated":[],"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c3445cbcbcec4678b3f15639a892afd1"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('wp88L', 'customer_group_change_reject', '{"customer":"customer","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"cf7892d60b794b65b7badae58462715b","salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"b8794be7a6d840e99ffc76f17320df2b","defaultShippingAddressId":"b8794be7a6d840e99ffc76f17320df2b","customerNumber":"10060","salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","company":null,"email":"testing@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":"2021-03-29T12:53:05.736+00:00","lastLogin":null,"newsletter":false,"birthday":null,"lastOrderDate":null,"orderCount":0,"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":{"salutationKey":"mr","displayName":"Mr.","letterName":"Dear Mr.","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"bd3fd9c43c754e02a11d92b7f7cedc4f","versionId":null,"translated":{"displayName":"Mr.","letterName":"Dear Mr."},"createdAt":"2021-03-09T09:43:59.659+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bd3fd9c43c754e02a11d92b7f7cedc4f"},"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":[{"customerId":"c3445cbcbcec4678b3f15639a892afd1","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","countryStateId":null,"salutationId":"bd3fd9c43c754e02a11d92b7f7cedc4f","firstName":"Max","lastName":"Mustermann","zipcode":"12345","city":"Musterstadt","company":null,"department":null,"title":null,"street":"Musterstr. 2","phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":null,"countryState":null,"salutation":null,"customer":null,"customFields":null,"_uniqueIdentifier":"b8794be7a6d840e99ffc76f17320df2b","versionId":null,"translated":[],"createdAt":"2021-03-29T12:53:05.958+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b8794be7a6d840e99ffc76f17320df2b"}],"orderCustomers":null,"autoIncrement":62,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":null,"requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"c3445cbcbcec4678b3f15639a892afd1","versionId":null,"translated":[],"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c3445cbcbcec4678b3f15639a892afd1"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"cf7892d60b794b65b7badae58462715b","shippingMethodId":"71ebb873740e4f44a9f49a3229961a69","countryId":"c0da63f63ceb4d8ebaa5874dbe48f5dc","navigationCategoryId":"edffcfe389e84a5aaa40c56874f97e39","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCAETKEFPZSJJHZVBNQ2D6YG","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"530d80c5293b402d84fe903b9579eb19","snippetSet":null,"salesChannelId":"e87ba37297a94629abc2be5ea1d0a1e0","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"c448b63e00d448ca939b311edce409d3","versionId":null,"translated":[],"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c448b63e00d448ca939b311edce409d3"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["a4386b473b24419591511f2d60cda25f","bfb351a897eb4a699c7c1d6718e1674b","cf7892d60b794b65b7badae58462715b","eee8328b1c3240a8873fe99723dcdf27"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"e87ba37297a94629abc2be5ea1d0a1e0","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-03-09T09:44:27.960+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e87ba37297a94629abc2be5ea1d0a1e0","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('wp88h1', 'password_change', '{"customer":"customer","resetUrl":null,"salesChannel":"sales_channel"}', '[[regtime_]]', NULL, NULL),
('wp88:c', 'sepa_confirmation', '{"order":"order","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"08757990bf314633b5d0fa55efc5e63d","billingAddressId":"3e112279819f4c1d8f5d7107f6b33a25","orderDateTime":"2021-04-12T08:39:51.371+00:00","orderDate":"2021-04-12T00:00:00.000+00:00","price":{"netPrice":799.0700000000000500222085975110530853271484375,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"positionPrice":855,"taxStatus":"gross","rawTotal":855,"extensions":[]},"amountTotal":855,"amountNet":799.0700000000000500222085975110530853271484375,"positionPrice":855,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":7,"price":0,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"e96e47f99c844f1b9997e613bc621f65","salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"7f0eef7a233a41f886a2fc69b0ca79df","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"69867b98038e4d41bde2382bbb5810fc","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"c9036a6e1bf84f769f06d0ba6490d75b","defaultShippingAddressId":"3fc4a0d7787c466daeb6fade1b51c4fd","customerNumber":"1337","salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","company":null,"password":"$2y$10$9xvO2tM3dEfcOG4lO9CA3eogJD1wkYhW7erQv0d14AAUA9u0V5Dpy","email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-12T08:39:36.376+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-12T08:39:51.371+00:00","orderCount":4,"createdAt":"2021-04-12T07:54:30.118+00:00","updatedAt":"2021-04-12T08:39:51.671+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"7f0eef7a233a41f886a2fc69b0ca79df","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7f0eef7a233a41f886a2fc69b0ca79df"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"4f602c9cb4994a7a96a06630d9f62cee","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-12T07:52:38.207+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"4f602c9cb4994a7a96a06630d9f62cee"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"e61b6f06cbe5421ebb41d428ce457ac2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.542+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e61b6f06cbe5421ebb41d428ce457ac2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-12T07:52:38.772+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":null,"addresses":[{"countryId":"f68b900afd7644dfb8b7f5392183efd9","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Saint Barth\\u00e9lemy","iso":"BL","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"BLM","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"f68b900afd7644dfb8b7f5392183efd9","versionId":null,"translated":{"name":"Saint Barth\\u00e9lemy","customFields":[]},"createdAt":"2021-04-12T07:52:46.949+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"f68b900afd7644dfb8b7f5392183efd9"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"3e112279819f4c1d8f5d7107f6b33a25","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.556+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"3e112279819f4c1d8f5d7107f6b33a25","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Kazakhstan","iso":"KZ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"KAZ","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","versionId":null,"translated":{"name":"Kazakhstan","customFields":[]},"createdAt":"2021-04-12T07:52:46.847+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"7796bf226130426fb71bef6270dcf8e3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.561+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7796bf226130426fb71bef6270dcf8e3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","shippingOrderAddressId":"7796bf226130426fb71bef6270dcf8e3","shippingMethodId":"7ab645770dbb4a648268248492ed5f0a","trackingCodes":[],"shippingDateEarliest":"2021-04-13T00:00:00.000+00:00","shippingDateLatest":"2021-04-15T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":7,"price":0,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","countryStateId":null,"salutationId":"4f602c9cb4994a7a96a06630d9f62cee","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Kazakhstan","iso":"KZ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"KAZ","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b","versionId":null,"translated":{"name":"Kazakhstan","customFields":[]},"createdAt":"2021-04-12T07:52:46.847+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bf7fe4dae0aa4ebcb28f8e91a4aabc8b"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"e96e47f99c844f1b9997e613bc621f65","customFields":null,"_uniqueIdentifier":"7796bf226130426fb71bef6270dcf8e3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.561+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7796bf226130426fb71bef6270dcf8e3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"4753bf682a1640d8a89ca672f3982b1b","stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"2669c221e38a477980f8bef5e9cccdaf","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"4753bf682a1640d8a89ca672f3982b1b","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.108+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"4753bf682a1640d8a89ca672f3982b1b"},"shippingMethod":{"name":"Standard","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"d5352c5bdd10417db10125050af38b64","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"d5352c5bdd10417db10125050af38b64","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-12T07:52:38.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"d5352c5bdd10417db10125050af38b64"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"132058274b4c4ba5b292e78b79e7fd90","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"7ab645770dbb4a648268248492ed5f0a","versionId":null,"translated":{"name":"Standard","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-12T07:52:38.814+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ab645770dbb4a648268248492ed5f0a"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"35bf2776cc6c4857980ed8a651bf6060","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.565+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"35bf2776cc6c4857980ed8a651bf6060","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","identifier":"f47e72bf6d0e40c4aa290330a7ffd44d","referencedId":"f47e72bf6d0e40c4aa290330a7ffd44d","productId":"f47e72bf6d0e40c4aa290330a7ffd44d","quantity":1,"unitPrice":855,"totalPrice":855,"label":"Aerodynamic Cotton Brand Muffin","description":null,"good":true,"removable":true,"coverId":"5f3c1ac1ce3744009cc8613f1524fc80","stackable":true,"position":1,"price":{"unitPrice":855,"quantity":1,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":855,"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"40afe75845934469b3528a06573bd395","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-12 07:54:39.961","optionIds":null,"isCloseout":false,"categoryIds":["e38a91bb89b94313acd546bb813c9bde","f5fd0ad1b7904012adeab43c5571249f","1f232fdf7e744a6188e70373c64059ec"],"propertyIds":["08342bf3c949475081380d7f18ac3013","1f4a747cd9084a91b5b3354483f64d5c","242c6322e09642db9a6dd34e4945563b","2f8fdf5146e3495b93f1477a13b30a70","33443da934024d7d9a4e949f2dbade33","38414ab339ae45e8a34c742f74ca951c","517fa1113cc749cb82acca7a7a911f51","5db7f83261c746818e2cb119d7b690e3","6b463dcccdcf44b69c1d64aaa99f465a","7b0924b10e6c4e7c8cebb21f779014fe","95746abcc9fe46cc93277210e7184e38","98a65897b93440e7b5f848e51efa53df","ad24e8a73b0f4018827e267346c08254","af8b23072130451b8a80b1a94af2a529","c021d77e23eb44568bd321158519b807","e4a316f3eaf64983a6af02654f7d2fc7","fdfb81dcdbb2400aab7ac18e9c967350","fe4960c9a2df4bfd9e977b473983bd86"],"releaseDate":null,"customFields":[],"productNumber":"dc0f18c1a31f4f189e7ef7d921052fe6","manufacturerId":"0f721bed5f054043a2b5d0986f55757c","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":31.570093457943923,\\"gross\\":33.78,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"2095623819c546a2893afe2db1557bec","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.572+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"2095623819c546a2893afe2db1557bec","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"e96e47f99c844f1b9997e613bc621f65","paymentMethodId":"69867b98038e4d41bde2382bbb5810fc","amount":{"unitPrice":855,"quantity":1,"totalPrice":855,"calculatedTaxes":[{"tax":55.92999999999999971578290569595992565155029296875,"taxRate":7,"price":855,"extensions":[]}],"taxRules":[{"taxRate":7,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"69867b98038e4d41bde2382bbb5810fc","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-12T07:52:38.793+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"69867b98038e4d41bde2382bbb5810fc"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"3e52d2ea8045489bbc13528a1cd68170","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"db5897dec897426985f29b105875e6a8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.129+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"db5897dec897426985f29b105875e6a8"},"stateId":"db5897dec897426985f29b105875e6a8","customFields":null,"_uniqueIdentifier":"a57d8d1c18f64f55bfb48b39ceec660f","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.575+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"a57d8d1c18f64f55bfb48b39ceec660f","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"s2i1jbau4LeH0R7RUDrzHo8Y7KglbZ_D","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"040ddecd833d4c98a1935f19b5617e8c","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"ed244ea9e52c4497ab57c4a12b10d962","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-12T07:52:39.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"ed244ea9e52c4497ab57c4a12b10d962"},"stateId":"ed244ea9e52c4497ab57c4a12b10d962","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["132058274b4c4ba5b292e78b79e7fd90","5bbbd6951e8f4c91a8de6544a5fb8ea2","b3963d2ae9f04c8ebd7ea09304f6294f","8583f4c0d9254ea091c8354a180a3a6d"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"e96e47f99c844f1b9997e613bc621f65","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-12T08:39:51.578+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"e96e47f99c844f1b9997e613bc621f65","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"69867b98038e4d41bde2382bbb5810fc","shippingMethodId":"7ab645770dbb4a648268248492ed5f0a","countryId":"77304b7727794e1c9460f192a55d66cf","navigationCategoryId":"e38a91bb89b94313acd546bb813c9bde","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCOGFIOGDVTJLZOVZ5WLEWEA","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"c6dd40a58bfd4c54979eaf1c6be56cb1","snippetSet":null,"salesChannelId":"08757990bf314633b5d0fa55efc5e63d","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"46d268ec94c5430295ec21fa5952ca53","versionId":null,"translated":[],"createdAt":"2021-04-12T07:53:19.452+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"46d268ec94c5430295ec21fa5952ca53"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["69867b98038e4d41bde2382bbb5810fc","81fcce6eda1e4ee994281cf6c41e1208","8b9ed316d2da4756ab995bd0fa46ef87","9c8bb5aa0c974f87b44b4a61a9d61d0a"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"08757990bf314633b5d0fa55efc5e63d","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-12T07:53:19.452+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"08757990bf314633b5d0fa55efc5e63d","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}'),
('wp88v', 'product_stock_warning', '{"product":"product","salesChannel":"sales_channel"}', '[[regtime_]]', NULL, NULL);
INSERT INTO `mail_template_type` VALUES
('wp88ł', 'order_delivery.state.returned_partially', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('wp88Α', 'order_delivery.state.shipped_partially', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('wp88A&x', 'order_delivery.state.returned', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('wp88ϫ ', 'order_delivery.state.shipped', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('wp88=', 'order_delivery.state.cancelled', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('wp88\09', 'order_transaction.state.reminded', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('wp88ӌ2', 'order_transaction.state.refunded_partially', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":false,"birthday":null,"lastOrderDate":"2021-04-08T08:06:47.547+00:00","orderCount":3,"createdAt":"2021-04-08T07:31:30.853+00:00","updatedAt":"2021-04-08T08:06:47.769+00:00","legacyEncoder":null,"legacyPassword":null,"group":null,"defaultPaymentMethod":null,"salesChannel":null,"language":null,"lastPaymentMethod":null,"salutation":null,"defaultBillingAddress":null,"defaultShippingAddress":null,"activeBillingAddress":null,"activeShippingAddress":null,"addresses":null,"orderCustomers":null,"autoIncrement":61,"tags":null,"tagIds":null,"promotions":null,"recoveryCustomer":null,"customFields":null,"productReviews":null,"remoteAddress":"::","requestedGroupId":null,"requestedGroup":null,"boundSalesChannelId":null,"boundSalesChannel":null,"wishlists":null,"_uniqueIdentifier":"6b216f01cab54ef5807f1aa180414ce7","versionId":null,"translated":[],"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6b216f01cab54ef5807f1aa180414ce7"},"salutation":{"salutationKey":"not_specified","displayName":"Not specified","letterName":" ","translations":null,"customers":null,"customerAddresses":null,"orderCustomers":null,"orderAddresses":null,"newsletterRecipients":null,"_uniqueIdentifier":"b3b9251279764583a0f11ff92e3d40ef","versionId":null,"translated":{"displayName":"Not specified","letterName":" "},"createdAt":"2021-04-08T07:30:01.479+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b3b9251279764583a0f11ff92e3d40ef"},"order":null,"customFields":null,"remoteAddress":"::","_uniqueIdentifier":"9105dcbe44d9424fab96d351be47a927","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.671+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"9105dcbe44d9424fab96d351be47a927","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"currency":{"isoCode":"EUR","factor":1,"symbol":"\\u20ac","shortName":"EUR","name":"Euro","position":1,"translations":null,"orders":null,"salesChannels":null,"salesChannelDefaultAssignments":null,"salesChannelDomains":null,"customFields":null,"shippingMethodPrices":null,"promotionDiscountPrices":null,"isSystemDefault":true,"productExports":null,"countryRoundings":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"b7d2554b0ce847cd82f3ac9bd1c0dfca","versionId":null,"translated":{"shortName":"EUR","name":"Euro","customFields":[]},"createdAt":"2021-04-08T07:30:01.679+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b7d2554b0ce847cd82f3ac9bd1c0dfca"},"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":null,"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null},"addresses":[{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},{"countryId":"b0baef05cfca4995bfbdd75a95b1d2d7","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Bahnhofstra\\u00dfe 27","zipcode":"10332","city":"Berlin","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Djibouti","iso":"DJ","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"DJI","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"b0baef05cfca4995bfbdd75a95b1d2d7","versionId":null,"translated":{"name":"Djibouti","customFields":[]},"createdAt":"2021-04-08T07:30:10.954+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"b0baef05cfca4995bfbdd75a95b1d2d7"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"658f064fb7214daca0821410c265a54a","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.687+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"658f064fb7214daca0821410c265a54a","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"billingAddress":null,"deliveries":[{"orderId":"666434556c72430e8626f13339ea7bdc","shippingOrderAddressId":"5a915d3e124b409389785aa5a7534472","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","trackingCodes":[],"shippingDateEarliest":"2021-04-09T00:00:00.000+00:00","shippingDateLatest":"2021-04-11T00:00:00.000+00:00","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingOrderAddress":{"countryId":"add8539b11814972818256faa91f3316","countryStateId":null,"salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","street":"Ebbinghoff 10","zipcode":"48624","city":"Sch\\u00f6ppingen","company":null,"department":null,"title":null,"vatId":null,"phoneNumber":null,"additionalAddressLine1":null,"additionalAddressLine2":null,"country":{"name":"Paraguay","iso":"PY","position":10,"taxFree":false,"active":true,"shippingAvailable":true,"iso3":"PRY","displayStateInRegistration":false,"forceStateInRegistration":false,"companyTaxFree":false,"checkVatIdPattern":false,"vatIdPattern":null,"states":null,"translations":null,"orderAddresses":null,"customerAddresses":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"taxRules":null,"currencyCountryRoundings":null,"_uniqueIdentifier":"add8539b11814972818256faa91f3316","versionId":null,"translated":{"name":"Paraguay","customFields":[]},"createdAt":"2021-04-08T07:30:11.066+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"add8539b11814972818256faa91f3316"},"countryState":null,"order":null,"salutation":null,"orderDeliveries":null,"orderId":"666434556c72430e8626f13339ea7bdc","customFields":null,"_uniqueIdentifier":"5a915d3e124b409389785aa5a7534472","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.691+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5a915d3e124b409389785aa5a7534472","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"stateId":"da7999756a0b4f24a8f1b2c3517c63c6","stateMachineState":{"name":"Shipped","technicalName":"shipped","stateMachineId":"fa6a3f6ee9ac40b88cb2383890b96e4b","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"da7999756a0b4f24a8f1b2c3517c63c6","versionId":null,"translated":{"name":"Shipped","customFields":[]},"createdAt":"2021-04-08T07:30:01.817+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"da7999756a0b4f24a8f1b2c3517c63c6"},"shippingMethod":{"name":"Express","active":true,"description":null,"trackingUrl":null,"deliveryTimeId":"0733a509484c40daa1225173e6ccf382","deliveryTime":{"name":"1-3 days","min":1,"max":3,"unit":"day","shippingMethods":null,"translations":null,"customFields":null,"products":null,"_uniqueIdentifier":"0733a509484c40daa1225173e6ccf382","versionId":null,"translated":{"name":"1-3 days","customFields":[]},"createdAt":"2021-04-08T07:30:01.000+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"0733a509484c40daa1225173e6ccf382"},"translations":null,"orderDeliveries":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"customFields":null,"availabilityRule":null,"availabilityRuleId":"f52b985fe172452d8eb4be30ae838bca","prices":[],"mediaId":null,"taxId":null,"media":null,"tags":null,"taxType":"auto","tax":null,"_uniqueIdentifier":"03168af91f804087b7bc24eea072c2d6","versionId":null,"translated":{"name":"Express","customFields":[],"description":null,"trackingUrl":null},"createdAt":"2021-04-08T07:30:01.696+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"03168af91f804087b7bc24eea072c2d6"},"order":null,"positions":null,"customFields":null,"_uniqueIdentifier":"bdd092a2bd9547d3a05c513c2dc37e13","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.694+00:00","updatedAt":"2021-04-08T08:07:42.742+00:00","extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"bdd092a2bd9547d3a05c513c2dc37e13","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","shippingOrderAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"lineItems":[{"orderId":"666434556c72430e8626f13339ea7bdc","identifier":"26641f6d8e52424a9238cb25b59ac402","referencedId":"26641f6d8e52424a9238cb25b59ac402","productId":"26641f6d8e52424a9238cb25b59ac402","quantity":1,"unitPrice":740,"totalPrice":740,"label":"Aerodynamic Bronze Brush n Flush","description":null,"good":true,"removable":true,"coverId":"04e72112470e4e989372b03e356eea70","stackable":true,"position":1,"price":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"priceDefinition":{"price":740,"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"quantity":1,"isCalculated":true,"referencePriceDefinition":null,"listPrice":null,"extensions":[],"type":"quantity"},"payload":{"isNew":false,"taxId":"a8e6660add084484988909a3eba996f8","tagIds":null,"options":[],"features":[],"createdAt":"2021-04-08 07:31:35.403","optionIds":null,"isCloseout":false,"categoryIds":["aee8846cc9214295bd832fc436ff0891","7f21a683489742aeac15c846ff26089b","6901b0428273411fafb4c20657a87819"],"propertyIds":["1f320a0a3e1e4032b9840c25b216c01c","27c7db6c50e1458b80bd48b7fd156bbb","2ac677dfc0ea43d9afc33ff4eba10557","33856bf045a74d438a85232de72555ce","4868b068ff0b4706ad02b2beb7fb68ae","4afcfa4dc9444ae28b2bc4fc5e37fca8","5f0d692e20774e22b1339acb55a4ab8c","7c29e4c1659b4c1e86703cb8c57ad017","7e4b7a49eda545dd8619bf350534d2b9","9975751305c542d592674b0a516e7faf","9b7ba56210154b05a71de31f1fdef294","a5d876efaf824a4f83f146d9280a833e","ab47e83d07f14b978730c28fcdcf7dbb","bd885d5a1fbe467d92fc1d9878b69308","bfc247a0147b43b1900c16437a59d2ac","c73ec99cbf3c4e6da14727f34bc79a1b","ec048350008846569f8e3e786b2f3839","f40a4cb7036d48a3bb92901ea9806de4"],"releaseDate":null,"customFields":[],"productNumber":"63695d9584c7469f923053c43e6bc51b","manufacturerId":"60fe1e82644c4ac98024d37428848ef0","purchasePrices":"{\\"currencyId\\":\\"b7d2554b0ce847cd82f3ac9bd1c0dfca\\",\\"net\\":6.5,\\"gross\\":6.5,\\"linked\\":true,\\"listPrice\\":null,\\"extensions\\":[]}","markAsTopseller":null},"parentId":null,"type":"product","order":null,"orderDeliveryPositions":null,"customFields":null,"cover":null,"children":null,"product":null,"_uniqueIdentifier":"782f865d67ba4c7fa4b0295523860bd3","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.700+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"782f865d67ba4c7fa4b0295523860bd3","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","productVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","parentVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"transactions":[{"orderId":"666434556c72430e8626f13339ea7bdc","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","amount":{"unitPrice":740,"quantity":1,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"paymentMethod":{"pluginId":null,"handlerIdentifier":"Shopware\\\\Core\\\\Checkout\\\\Payment\\\\Cart\\\\PaymentHandler\\\\CashPayment","name":"Cash on delivery","description":"Payment upon receipt of goods.","position":1,"active":true,"afterOrderEnabled":true,"plugin":null,"translations":null,"orderTransactions":null,"customers":null,"salesChannelDefaultAssignments":null,"salesChannels":null,"availabilityRule":null,"availabilityRuleId":null,"mediaId":null,"media":null,"customFields":null,"formattedHandlerIdentifier":"handler_shopware_cashpayment","shortName":"cash_payment","_uniqueIdentifier":"11491d8f829143c9a1f15c9c55e3df0c","versionId":null,"translated":{"name":"Cash on delivery","description":"Payment upon receipt of goods.","customFields":[]},"createdAt":"2021-04-08T07:30:01.687+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"11491d8f829143c9a1f15c9c55e3df0c"},"order":null,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"6e6136e244b94bb7a45cc0892710d8e5","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"c535a5a0502041cf82876451ddb6e9d8","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.828+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"c535a5a0502041cf82876451ddb6e9d8"},"stateId":"c535a5a0502041cf82876451ddb6e9d8","customFields":null,"_uniqueIdentifier":"5d5231dbd1e246919b334d26733b4fd2","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.702+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"5d5231dbd1e246919b334d26733b4fd2","orderVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"}],"deepLinkCode":"xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE","autoIncrement":61,"stateMachineState":{"name":"Open","technicalName":"open","stateMachineId":"79a76fe8cd784a469aaa34f628713cfd","stateMachine":null,"fromStateMachineTransitions":null,"toStateMachineTransitions":null,"translations":null,"orders":null,"orderTransactions":null,"orderDeliveries":null,"fromStateMachineHistoryEntries":null,"toStateMachineHistoryEntries":null,"customFields":null,"_uniqueIdentifier":"7c5f81be5ede4c4f88efc6689cea5f62","versionId":null,"translated":{"name":"Open","customFields":[]},"createdAt":"2021-04-08T07:30:01.796+00:00","updatedAt":null,"extensions":{"internal_mapping_storage":{"apiAlias":null,"extensions":[]},"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7c5f81be5ede4c4f88efc6689cea5f62"},"stateId":"7c5f81be5ede4c4f88efc6689cea5f62","customFields":null,"documents":null,"tags":null,"affiliateCode":null,"campaignCode":null,"customerComment":null,"ruleIds":["ddc661de2b4449f2aee52bd73f8884ec","f52b985fe172452d8eb4be30ae838bca","fe822fb82ad74e6d85821673de316388","6ccc3d984ec04f07a9ddb1e288c0b7f4"],"createdById":null,"createdBy":null,"updatedById":null,"updatedBy":null,"itemRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"totalRounding":{"decimals":2,"interval":0.01000000000000000020816681711721685132943093776702880859375,"roundForNet":true,"extensions":[]},"_uniqueIdentifier":"666434556c72430e8626f13339ea7bdc","versionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","translated":[],"createdAt":"2021-04-08T08:06:47.705+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"666434556c72430e8626f13339ea7bdc","billingAddressVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425"},"salesChannel":{"typeId":"8a243080f92e4c719546314b577cf82b","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","paymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","shippingMethodId":"03168af91f804087b7bc24eea072c2d6","countryId":"36159d966ed844e6add50a0a370c99b2","navigationCategoryId":"aee8846cc9214295bd832fc436ff0891","navigationCategoryDepth":2,"homeSlotConfig":null,"homeCmsPageId":null,"homeCmsPage":null,"homeEnabled":null,"homeName":null,"homeMetaTitle":null,"homeMetaDescription":null,"homeKeywords":null,"footerCategoryId":null,"serviceCategoryId":null,"name":"Storefront","shortName":null,"accessKey":"SWSCATLQZHBWBVZ1SGHNQNBLAQ","currencies":null,"languages":null,"configuration":null,"active":true,"maintenance":false,"maintenanceIpWhitelist":null,"taxCalculationType":"horizontal","type":null,"currency":null,"language":null,"paymentMethod":null,"shippingMethod":null,"country":null,"orders":null,"customers":null,"countries":null,"paymentMethods":null,"shippingMethods":null,"translations":null,"domains":[{"url":"http:\\/\\/localhost\\/development\\/public","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currency":null,"snippetSetId":"765a7f1059ee4f75a4592194291d1e1e","snippetSet":null,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","salesChannel":null,"languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","language":null,"customFields":null,"productExports":null,"salesChannelDefaultHreflang":null,"hreflangUseOnlyLocale":false,"_uniqueIdentifier":"7ed2b68f70284aea83d1c2747b622848","versionId":null,"translated":[],"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"7ed2b68f70284aea83d1c2747b622848"}],"systemConfigs":null,"customFields":null,"navigationCategory":null,"footerCategory":null,"serviceCategory":null,"productVisibilities":null,"mailHeaderFooterId":null,"numberRangeSalesChannels":null,"mailHeaderFooter":null,"customerGroupId":"cfbd5018d38d41d8adca10d94fc8bdd6","customerGroup":null,"newsletterRecipients":null,"promotionSalesChannels":null,"documentBaseConfigSalesChannels":null,"productReviews":null,"seoUrls":null,"seoUrlTemplates":null,"mainCategories":null,"paymentMethodIds":["02f698f2ca24408bbbd40370ac95275d","11491d8f829143c9a1f15c9c55e3df0c","68cd624bbe2946f4afbdc1ae2f389e0e","e226a70069af441f965e79459acccb41"],"productExports":null,"hreflangActive":false,"hreflangDefaultDomainId":null,"hreflangDefaultDomain":null,"analyticsId":null,"analytics":null,"customerGroupsRegistrations":null,"eventActions":null,"boundCustomers":null,"wishlists":null,"landingPages":null,"_uniqueIdentifier":"6d5b12a8049e411cb463296092b0e887","versionId":null,"translated":{"name":"Storefront","customFields":[]},"createdAt":"2021-04-08T07:30:38.224+00:00","updatedAt":null,"extensions":{"foreignKeys":{"apiAlias":null,"extensions":[]}},"id":"6d5b12a8049e411cb463296092b0e887","navigationCategoryVersionId":"0fa91ce3e96a4bc2be4bd9ce752c3425","footerCategoryVersionId":null,"serviceCategoryVersionId":null}}');
INSERT INTO `mail_template_type` VALUES
('wp88', 'order_transaction.state.cancelled', '{"order":"order","previousState":"state_machine_state","newState":"state_machine_state","salesChannel":"sales_channel","editOrderUrl":null}', '[[regtime_]]', NULL, '{"order":{"orderNumber":"10060","currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","currencyFactor":1,"salesChannelId":"6d5b12a8049e411cb463296092b0e887","billingAddressId":"658f064fb7214daca0821410c265a54a","orderDateTime":"2021-04-08T08:06:47.547+00:00","orderDate":"2021-04-08T00:00:00.000+00:00","price":{"netPrice":740,"totalPrice":740,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":740,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"positionPrice":740,"taxStatus":"gross","rawTotal":740,"extensions":[]},"amountTotal":740,"amountNet":740,"positionPrice":740,"taxStatus":"gross","shippingCosts":{"unitPrice":0,"quantity":1,"totalPrice":0,"calculatedTaxes":[{"tax":0,"taxRate":0,"price":0,"extensions":[]}],"taxRules":[{"taxRate":0,"percentage":100,"extensions":[]}],"referencePrice":null,"listPrice":null,"extensions":[]},"shippingTotal":0,"orderCustomer":{"email":"test@example.com","orderId":"666434556c72430e8626f13339ea7bdc","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","title":null,"vatIds":null,"company":null,"customerNumber":"1337","customerId":"6b216f01cab54ef5807f1aa180414ce7","customer":{"groupId":"cfbd5018d38d41d8adca10d94fc8bdd6","defaultPaymentMethodId":"11491d8f829143c9a1f15c9c55e3df0c","salesChannelId":"98432def39fc4624b33213a56b8c944d","languageId":"2fbb5fe2e29a4d70aa5854ce7ce3e20b","lastPaymentMethodId":null,"defaultBillingAddressId":"a3d3353fc86f4cc78bc4d4ccf5fd0f5e","defaultShippingAddressId":"7cd64c81e0dc4488a4c461dab4e9bf4b","customerNumber":"1337","salutationId":"b3b9251279764583a0f11ff92e3d40ef","firstName":"Max","lastName":"Mustermann","company":null,"email":"test@example.com","title":null,"vatIds":null,"affiliateCode":null,"campaignCode":null,"active":true,"doubleOptInRegistration":false,"doubleOptInEmailSentDate":null,"doubleOptInConfirmDate":null,"hash":null,"guest":false,"firstLogin":null,"lastLogin":"2021-04-08T08:06:35.953+00:00","newsletter":fals