<?php declare(strict_types=1);

namespace Shopware\Core\Framework\Demodata\Faker;

use Bezhanov\Faker\Provider\Commerce as FakerCommerce;
use Shopware\Core\Framework\Log\Package;

/**
 * @internal
 */
#[Package('framework')]
class Commerce extends FakerCommerce
{
    /**
     * @var array<string, array<string>>
     *
     * @phpstan-ignore shopware.propertyNativeType, property.phpDocType (Cannot be typed because parent is not typed)
     */
    protected static $productName = [
        'adjective' => ['Small', 'Ergonomic', 'Rustic', 'Intelligent', 'Gorgeous', 'Incredible', 'Fantastic', 'Practical', 'Sleek', 'Awesome', 'Enormous', 'Mediocre', 'Synergistic', 'Heavy Duty', 'Lightweight', 'Aerodynamic', 'Durable'],
        'material' => ['Steel', 'Wooden', 'Concrete', 'Plastic', 'Cotton', 'Granite', 'Rubber', 'Leather', 'Silk', 'Wool', 'Linen', 'Marble', 'Iron', 'Bronze', 'Copper', 'Aluminum', 'Paper'],
        'product' => [
            'Chair', 'Car', 'Computer', 'Gloves', 'Pants', 'Shirt', 'Table', 'Shoes', 'Hat', 'Plate', 'Knife', 'Bottle', 'Coat', 'Lamp', 'Keyboard', 'Bag', 'Bench', 'Clock', 'Watch', 'Wallet',
            '33 Record and Vinyl', '33Ease', '3Deem Yourself', '3Demon', '3-DOM', '70 Umpa', 'A Brisket a Tasket', 'A Dog’s Life Gourmet Chews', 'Abundance', 'Acclimaze', 'Acclimite', 'Accountant Monte Cristo', 'Accruex', 'Accufarm', 'Accugel', 'Accumax', 'Accupharm', 'Accuprint', 'Accusage', 'Achy Breaky Chatterbox', 'Aclima', 'Action Floss', 'Action Floss Figure', 'Action Link', 'Active Radio', 'Active Sleep', 'Active Taco Digestive Cream', 'AcuVirt', 'Ad Caddy', 'Ad Liberace', 'Add It Up', 'AddVice', 'Adornica', 'Advanced Aluminum Siding', 'Advanced Calculation Engine', 'Advarnish', 'Advertis Miss', 'ADvise', 'Aerosol Cheese', 'Aerosol Jesus', 'Aesthetic Bug Gloss', 'Affluential', 'Affluex', 'Aftertizer', 'Agriox', 'Air Apparent', 'Air Bingo', 'Air Collar', 'Air Fair', 'Air Pool', 'Air Trust', 'Airborne Pickle', 'AirDock', 'AirHead', 'Airplex', 'Airprint', 'AirSync', 'Airvoyance', 'Algae Bra', 'All Indigo', 'AllBody', 'AllegroQuote', 'Allformz', 'AL-Lite', 'AllYear', 'Alphaplasti', 'AL-Right', 'ALstruct', 'ALswell', 'Altrodronal', 'AL-Tube', 'AluMAX', 'Alumetal', 'Alumicell', 'Alumicide', 'Alumiform', 'AlumiLast', 'Alumilife', 'Alumilight', 'Alumiline', 'Alumilite', 'Alumiloft', 'Alumimagic', 'Alumina', 'Aluminal', 'AlumiNation', 'Alumineer', 'Alumiplode', 'Alumiscape', 'Alumisheer', 'Alumistrong', 'Alumistruct', 'Alumisys', 'Alumitech', 'Alumitrude', 'Alumitude', 'Alumivac', 'Alumix', 'AL-Ways', 'Amalcell', 'Amazeprint', 'Ambronatron', 'Ambrotonic', 'Ampitup!', 'Amputation Wizard', 'Amuflox', 'Anacho', 'Andryx', 'Andy Brand', 'Anivet', 'Anti Money', 'Aposture Free', 'AppAbout', 'AppAround', 'Apple Cheeks', 'Applica', 'Applicode', 'Applidec', 'Applideck', 'Applitrans', 'AppShare', 'Apptrans', 'Appular', 'Appy Planet', 'AppyPlanet', 'AppySpace', 'AppyTown', 'Aqua Duck', 'Aqua Pulp', 'Aqua Radiant', 'Aquacine', 'Aquafat', 'Aquafire', 'Aquamate', 'AquaQleen', 'AquaRanger', 'Aquasseur', 'Aquasure', 'Aquazure', 'Aquicin', 'Aquoavo', 'Architexture', 'Arctiq', 'Argggggghhhhhhh', 'Aria Crystals', 'Aria Safari', 'Armor Dildo', 'Aroma Modules', 'Aromacise',
            'Aromantic', 'Aromawraps', 'Art Sphere', 'Artego', 'Asimiline', 'ASirTea', 'Ask Jesus', 'Ass Curtain', 'Astral Revisionist', 'Astro Gin', 'AstroGel', 'AstroKnots', 'Asymilate', 'Atheistic Nativity Tomb', 'ATM Music', 'ATMbot', 'Atomic Coffee', 'Atomic Conch', 'Atomic Donut', 'Atomica', 'Attila the Honey Bee', 'Auction Logic', 'Audio Farm', 'Audio Fusion', 'Audio Poison', 'Audiovinyl', 'Austech', 'Austen’s Bloomers', 'Austex', 'Auto Bon Bons', 'Auto Labotomy', 'Autoconsole', 'Autograte', 'AutoMain', 'Automatic Insult Generator', 'aVa', 'Avenetro', 'Ax-O-Matic', 'AzoFlux', 'B Cool 2 School', 'Baby Donuts', 'Baby Sausage', 'Bacon Jerky', 'Bacon Sticks', 'BactoWeave', 'Baffledil', 'Bag It!', 'Bag of Scones', 'Balancing Action', 'Balkan Beef', 'Ball Lightning', 'Bamboo Gnu', 'Bamboolong', 'Bang’aBone', 'Banned', 'Barbie Real', 'Barely Bacon', 'Barn Soup', 'Barnacle Power', 'Barnacle Tap', 'Barney Babies', 'BarTelevision', 'Basil Bromide', 'Bath and Relax', 'Bathe Away', 'Bath-Lite', 'Battle Screen', 'Baubles', 'BBQ’d Napkins', 'Bead2Bead', 'Beadniks', 'BeanCounter', 'BeanThere', 'Beauty in a Bottle', 'BeautyStretch', 'Bedder', 'Bedlam', 'Bedleham', 'Bedware', 'Bee Salt', 'Bee Salts', 'Bee Saw', 'Beef Blackout', 'Beef Blanks', 'Beef Bowl Knoll', 'Beefbelly', 'Beer Puppets', 'Beeragra', 'Before Breakfast', 'Beg', 'Beige and Briney', 'Bela Bites', 'Bella Outdoors', 'Belly Jelly', 'Belly-flop Buffet', 'Beluga Gum', 'Bermo', 'Berryboy', 'Besto', 'Better Then Postmen', 'Bewildering Chicken', 'Beyond Bedding', 'BeyondSleep', 'Bflatshares', 'Bicyclone', 'BiffPaste', 'Biflex', 'Big Juicy', 'BigCookie', 'BigTent', 'BigWay', 'Bike Along', 'Billion Air', 'Bimbowl', 'Binarium', 'Bingles', 'Bingo Storm', 'Biolid', 'Biological Interface', 'Birthday Potato', 'Biscotti de Chien', 'Bite’Ems', 'Bitskater', 'Bitter Plaid', 'Bittor', 'Bizmatic', 'BizSweeper', 'BizWhiz', 'Black Belt Barbie', 'Black Vinyl', 'Blahg', 'Blanked Beef', 'Blazarus', 'Blaze', 'Bleach Melba', 'Blind Truss', 'Blink!', 'Blinq', 'Bliss', 'Blister Bliss', 'Blister Burger', 'Blisterine', 'Blogger Lager', 'Bloodpudding', 'Bloomsbury Pie', 'BlowHard', 'Blue Sushi', 'Bluegrain', 'BoboLinks', 'Body Liquers', 'BodyChrome', 'Bodyflower', 'BodyJob', 'Boil Head', 'Boilcat', 'Boiltanker', 'Boink', 'Boink!', 'Bolax', 'Boltonic', 'Bone Bag', 'Bone BaGGies', 'Bone Biter', 'Boob Nu Nu', 'Booger Beer', 'Book Tube', 'Bookmaker', 'Books-Mobile', 'Booster Cake', 'Bostonic', 'Botea Bliss', 'Botea For Two', 'Botox Barbie', 'Botox Detox', 'Boudware', 'Bouldergrain', 'Bounding Blocks', 'Bowel Badger', 'Bowel Brightener', 'Bowel Detective', 'Brain Brand', 'Brain Butter', 'Brainclip', 'Brainquil', 'BrainWire', 'Bran Dandy', 'Brand Aid', 'Brand Dandy', 'Brand Muffin', 'Brand Royalty', 'breezz', 'Brew-n-Go', 'Bricksoil', 'Brigadier Coffee', 'Bring it!', 'Briny', 'Bris-o-matic', 'Britchies', 'Bronte Thesaurus', 'Bronze Cheese', 'Brunchilli', 'Brunchilli Sunrise', 'Brush n Flush', 'Bubbleonia', 'Bubboil', 'Buddha Bait', 'Buddha Bread', 'Buddha Loops', 'Buddy Ebsen Salt', 'Buffalo Butter', 'Bug Eyes', 'Bug Pod', 'Bug’aBone', 'Bugabug', 'BugSack', 'BugSock', 'Building Blocks', 'Building Glass', 'Bull Throttle', 'Bum Bait', 'Bum Chum', 'Bum Dot', 'Bunga Ding Dang',
            'Burl Whirl', 'BurnFree', 'Burning Man Ultimate Sunscreen', 'Burning Man’s Afterburn', 'Business Card Shark', 'Business In A Box', 'BusinessBro', 'Buster Boon', 'Butros Butros Biscotti', 'Butter Butt', 'Buttertop', 'Buzz Kilt', 'Buzz Skill', 'Buzzmaker', 'Buzzy', 'Bytrex', 'CactiDance', 'CactiLoops', 'Cadaver Jelly', 'Caffeine Serene', 'Cajun Sation', 'Call it Green', 'Callflex', 'Calling Card Shark', 'Calque', 'Camel Meal Tea', 'Camelot Chamomile', 'Campxotica', 'Camus the Killer Tale', 'Candecor', 'Candelarium', 'CandID', 'Candlelight Vittles', 'Candy Ask', 'Candy Floss', 'Candy Palanquin', 'Canine Cuisine', 'Canned Cobra', 'Cannon Balm', 'Canopoly', 'CanvArt', 'Capri-corndog', 'Captain Bamboo', 'Captain Fennel', 'Captain Zip', 'CaptiVite', 'Carbo Lode', 'CardIt', 'Cardster', 'Cardvark', 'Care Corp', 'Career Cast', 'Careful Hairful', 'CareWare', 'Carmel Knowledge', 'Carnage Asada', 'Carnal Coffee', 'Carnival Coffee', 'Carpet Clean', 'Carpet Fresh', 'Carrot Smiles', 'Cascadence', 'Cashioca', 'Cashish', 'Cast Glass', 'Castleware', 'Castration Oil', 'Category Five', 'Cattle Ack', 'Caulk Sure', 'Celebrionics', 'Cemention', 'Censor Ship', 'Censortium', 'Centigrand', 'Central Pork', 'CentricSource', 'CentriSource', 'Centuria PowerShots', 'CerealPort', 'ChalkLine', 'ChalkTalk', 'Chambermaid Placemats', 'Chamberware', 'Chandel', 'Chateau Low-blow', 'Châteaux Double Wide', 'Chaucer’s Choice', 'Chauncey Dog', 'Cheers!', 'Cheese by DuPont', 'Cheese Nibblers', 'Cheese Whispers', 'Cheetah Chat', 'CheetahPrint', 'Cheeze By DuPont', 'Cheeze Pleeze', 'Cheney Chain', 'Cherry Asphalt', 'Cherry Cherry', 'Cherry Potter', 'Chew', 'Chez Moi', 'Chez Toupee', 'Chic Treats', 'Chicken Piano', 'Chicory Basil', 'Chien Biscuit', 'Chigger Pops', 'Chillennium', 'Chillinnium', 'Chin-Up', 'Choco Lulu', 'Chocolate Mussolini', 'Christmas PeaceFest 2001', 'Christ’s Cliff Notes', 'Chrononaut', 'Chuffy', 'Chunck’s Chunks', 'Churn Over', 'Chutney Rabbit', 'ChuZ', 'Ciao Buddha', 'Cincyr', 'Cinesanctum', 'Circuitship', 'Citizen Canine', 'City Sick', 'Clarifect', 'Class Wire', 'ClassWire', 'Classy Collars', 'Clean Fun', 'Clean Grooves', 'Clean Music', 'Clean Sounds', 'Clean Vibes', 'CleanWeave', 'Cleanze', 'Clear Vinyl', 'Clem Clogs', 'Clever Leather', 'Click Fix', 'Clickogram', 'Clippety Clips', 'Clippies', 'Clone Tone', 'Clonitone', 'Clorox Coffee Crystals', 'Closet Palace', 'Cloud Nine', 'Coash', 'Cockney Sucker', 'Cocoa Beef', 'Cocoa Clasp', 'Coda Al Mundo', 'CodaCode', 'Codacrat', 'Codact', 'Codamundi', 'Codax', 'CodeAbout', 'CodeAround', 'CodeBlaster', 'Codecript', 'Codeform', 'Codeleon', 'Codeology', 'CodeOnce', 'CodeOne', 'CodeTrans', 'Codexport', 'Coffee Bin', 'Coffee Cat', 'Coffee Cobbler', 'Coffee Fresh', 'Coffee Melt', 'Coffee Moat', 'Coffee Panache', 'Coffee Patch', 'Coffee Squeegie', 'Coffee Squeeze', 'Coffee Squeeze Tube', 'Coffeebags', 'CoffeeMatic', 'Cognicode', 'Cola Cones', 'Cola Plex', 'COLAR', 'Coldshower Gearbox', 'Collar Magic', 'Collar STUPID – Standard Terminology for Unique Pet IDentification', 'Collarama', 'Collarful', 'Collarfy', 'Collarit Beautiful', 'Collarit ImPetus', 'Collarit Nexus', 'Collarus ImPetus', 'CollegiaSoundz', 'Color Rocket', 'Color-Band', 'ColorFab', 'ColorJet', 'Colormatrix', 'ColorSpeed', 'ColorTherm 2000', 'ColorVista', 'ColorWide', 'Columbo Gumbo', 'Coma Toast', 'Combath', 'Combination Hand Cuffs', 'Combot', 'Comdom', 'Comfidant', 'Comfort Foods', 'Comfortmate', 'Comfront', 'Comgo', 'Comgress', 'ComIT', 'Commersheen', 'Commodoors', 'Commplete Ports', 'Comnect', 'Compglass', 'Complete Meat', 'Complex Ports', 'Complimentia', 'Compo-bricks', 'ComposeTicker', 'ComprehendIT', 'CompuBooth', 'Computercate', 'Comquest', 'Comramp', 'Comrush', 'Comscript', 'Comsequence', 'Comshot', 'Comsole', 'Comsomme', 'Comstar', 'Comstruct', 'Comtact', 'Comtexture', 'Comtime', 'Comtrail', 'Comtraption', 'Comtroller', 'Comvex', 'Comveyer', 'Comveyor', 'Comway', 'Con Artistry', 'Conceive Now', 'Concert Concierge', 'Conciergency', 'Condimantra', 'Condimench', 'Condimentary', 'ConductorQuote', 'Coney Island Minibars', 'Connecto', 'Conservative Pornography', 'Constant Taco', 'Consumer Trendwatch', 'Consumerville', 'Contessa Casual', 'Contour Travel', 'Contrary Beauty', 'Convenience Shrine', 'Cookie Butter', 'Cool Cola', 'Cool Motion', 'Cool to School', 'Cool Torque', 'Coola', 'CoolThread', 'Copytractors', 'Cordon Coffee', 'Corduroy Nation', 'Core Care', 'Corepan', 'Corsets For Kids', 'Cosmetex', 'Cosmic Cocoon', 'Cosmo Knot', 'Costco Can of Worms', 'Cotatti Mondavi', 'Cotton Mouth Samples', 'Cough Machine', 'Counter Clone', 'Counter Coy', 'Coup de Veal', 'Cover Your Assets',
            'Cows and Meows', 'Crab Cookies', 'Crab-ola', 'Crackerbox', 'Crackerhead', 'Cracklebox', 'Cranialid', 'Crassabout', 'Craveman', 'Creamola', 'Credit Mart', 'CreditNET', 'CreTech', 'Crockery Taco', 'Crock-o-Dial', 'Crotch Bacon', 'Crumbaloney', 'Crumble Cheese', 'Cryogel', 'Cryosphere', 'Crystal Ball', 'Crystal Geyser Potato Vodka', 'Crystal Qlear', 'Crystal Qleen', 'Cthulhu Hoops', 'Cubicide', 'Cubicle Machine', 'Cubicle Remover', 'Cubicoil', 'Cubix', 'Culture Squirrel', 'Cup of Hot Kafka', 'CUPID – Collars for Unique Pet IDentification', 'Curb Appeal', 'Currency Net', 'Curt Ales', 'Cutter Claw', 'Cut-Throat Jeans', 'Cuzzles', 'Cycle Suave', 'Cyclone', 'Cyclovista', 'Cytrak', 'Cytrek', 'Cytrex', 'Cytrexaline', 'D. E. Light', 'D.E. Lightful', 'Dadbone', 'Daffodildo', 'Daily Plan It', 'Daily Plan-it', 'Daisu', 'Daisy Couturier', 'Daisy Cutlery', 'Dancallica', 'Dandy Brand', 'Dano Books', 'Dare Care', 'Darvane', 'Darwin 911', 'Darwin Media', 'Darwinium', 'Data Basket', 'Data Breeze', 'Data Dot', 'Databaseball', 'Daycore', 'Deal Light', 'Dearlescent', 'Deco Pube', 'DecodeIT', 'DecraPet', 'Dedicadence', 'Deep Anxietea',
            'Deep C', 'DefineIT', 'De-Lightful', 'Delivery Planet', 'Delusion Oil', 'Deminimum', 'Demo Lotion', 'Denim Minimum', 'Dentrex', 'Deoder Bear', 'DePort', 'Dermaway', 'DermiDown', 'Desert Loops', 'Design of the Times', 'Detachable Respiration Units', 'DetectID', 'Develaport', 'Devil Music', 'Devilette', 'Deviltoe', 'Dial-A-Smile', 'DialUp', 'Diamantra', 'Diamond Sky', 'Diaper Vision', 'Diet Smokes', 'Dig It!', 'DigestIT', 'DigiGate', 'Digimirror', 'DigiPrawn', 'Digiprint', 'Digirang', 'Digital Quarry', 'Dijon Bomb', 'Dino Diamonds', 'Director’s Chair', 'Dirt Flyers', 'Disappointment Ointment', 'Disaster Diet', 'Dishography', 'Dishytalk', 'DisOdor', 'Displaytech', 'Distilitone', 'Distinked', 'DJ Clean', 'DLink', 'Doc Hollandaise', 'Doggie Dreams', 'Doggy Biscotti', 'DogKandy', 'Dognost', 'Dogspa', 'doIT', 'Domismiles', 'Donation Vault', 'Doo Duds', 'DoorPrize', 'Dot Candy', 'Dot Circus', 'Dot Com Beetle', 'Dot Compactor', 'Dot Companion', 'Dot Compass', 'Dot Complex', 'Dot Condom', 'Dot Doggie', 'Dot Donut', 'Dot Forecast', 'Dot Future', 'Dot Vasion', 'Dot Vision', 'DotCondom',
            'Double Wide Châteaux Blanc', 'DoubleOver Stretch', 'Doubtlaw', 'DoveSongs', 'DowSonata', 'Doze n Dream', 'Dozze', 'Dr. Grout', 'Dr. Prudent', 'Dr. Rumi', 'Dr. Vegan', 'Dragbot', 'Drain Age', 'Drastic Plastic', 'Dream Fire', 'Dreamease', 'Dreamington', 'DreamTown', 'DreamWeb', 'Dress Up Pet', 'Drifting Off', 'Driftwoody', 'DrinkUp', 'DRIP', 'Drive Vibe', 'Dronebot', 'DroneCam', 'Drops of Divine', 'Drowsease', 'Druid Fluid', 'Duck a la Strange', 'Duckadoo', 'Duflex', 'Dug Fur', 'Dukakisite', 'Dune Drops', 'DuneTunes', 'Dunk n’ Dip', 'Duoflex', 'DurALloy', 'Dutch Oven Gretel', 'DVaud', 'Dye IT', 'Dyenamic', 'DyeNamo', 'DyeRite', 'Dynamantra', 'DyoRama', 'E. Vixen', 'Ear Blind', 'Ear Pudding', 'Earbang', 'Eargo', 'Earth Cup', 'Earth Kit', 'Earth to Earth', 'Earthmark', 'Earthplex', 'Earthpure', 'Earthscope', 'Earthstack', 'Earthwax', 'Earwig', 'Easy Seed', 'eBait', 'eBaste', 'Ebicto', 'eBlinq', 'Ebola Cola', 'eBreeze', 'eBrother(s)', 'eButter', 'eCake', 'Echo Shack', 'eCinch', 'eCLIPs', 'eCola', 'Ecolight', 'Ecosys', 'EdWeb', 'eFlow', 'eGate', 'Eggs Benadryl', 'eGleem', 'eGlimpse', 'eLava', 'Elder Carrot', 'Elderdrama', 'Electoad', 'Electric Board', 'Electric Waffle', 'Electro Techno', 'Electrocation', 'ElectroECSTATIC!', 'Electrolance', 'Electron Grains', 'Electronic Corner', 'Elemantra', 'Elentrix', 'Elephane', 'Elephatron', 'Elita', 'eLivery Service', 'Embarrassmentation', 'Emerald Comfort', 'eMerge', 'Emoltra', 'Emotion Detector', 'Empirica', 'emPower', 'Empower Mints', 'enCycle', 'Endicil', 'Endipin', 'Endipine', 'Ener Thighs', 'Enerforce', 'Energy Wize', 'Enigma on Rye', 'Enjola', 'Enlighten Mints', 'Enormo', 'Entality', 'Enter Prize Fighter', 'Enterpride', 'Enterprise Fighter', 'Enterprise Ring', 'Enterprise Surprise', 'Entertecture', 'Enthaze', 'Entroflex', 'EntryPit', 'Enzillium', 'ePeak', 'ePeek', 'Epidermawear', 'Equitynotes', 'Erect-AL', 'eSeed', 'Esplendidos', 'Essentia', 'Essentiaplex', 'eTurn', 'eTurnIt', 'Evaflox', 'eVe', 'Event Savvy', 'Evidence Everywhere', 'Evidends',
            'eVlinq', 'Excelleprint', 'Exchangesound', 'Exerta', 'Exhibit E', 'Exhibit Pudding', 'Existential X', 'Exoblue', 'ExoGame', 'ExoLove', 'ExoMonk', 'ExoRocket', 'ExoSmart', 'Exostream', 'Exoswitch', 'ExoTrek', 'Exovent', 'Exoville', 'Exozent', 'Expandirt', 'Exploitation Device', 'Exposa', 'Express Lane', 'Expresso Paints', 'ExtraSoft', 'Extremercise', 'Extro', 'Extrudia', 'Extrusia', 'Eye Bristles', 'Eye Gum', 'Eye Handy', 'Eyecatcher', 'EyeD', 'Eyedentify', 'Eyeris', 'Eyes Tea', 'EyesClosed', 'Eyesolate', 'Eyesore Rum', 'Eyewax', 'eZalis', 'ezBuddy', 'ezFun', 'Ezient', 'eZinch', 'ezNet', 'ezypod', 'Face Candy', 'Face It!', 'Facebreak', 'FaceField', 'FaceForce', 'Faceguard', 'Facelifter', 'FaceMaster', 'Facestrap', 'Facial Lettuce', 'Factomeal', 'FairWay', 'Family Food', 'Fanfare', 'Fangold', 'Fantastiprint', 'Farm Glue', 'Farmex', 'FarmIt', 'Fast Proof', 'FastHook', 'FatJet', 'Faux Bones', 'Faux Certain', 'Faux Fire', 'Faux Fro', 'Faux Pa',
            'Faxy Lady', 'Fear Cure', 'Fear Cut', 'Fear Fire', 'Fear Foil', 'Feather Lace', 'Featherbaby', 'Featherbaby Dreamtime', 'Federal Preserve', 'Feelin’ Guiltea', 'Feminaire', 'Feral', 'Fetidex', 'Fetid-X', 'Fever Blaster', 'Fife Insurance', 'Figure Lean', 'File Ranger', 'Fill the GAAP', 'Filmnastics', 'FinRap', 'Fire Floss', 'Fire Friendly', 'Fire Waltz', 'Fire Writer', 'Firebrand 500', 'Firefly Friends', 'Firelight Forge', 'Firewax', 'FisCali', 'Fish Fingers', 'Fish Soda', 'Fishing Basket', 'FistFire', 'Fitcore', 'Five Bubbies', 'Fix n’ Vix', 'Fizz', 'Fizzy Water', 'Flaming Tongue Whiskey Suckoff', 'Flannel Magic', 'Flash in the Pants', 'FlashPrint', 'Fleece Collar', 'Fleece Panties', 'Fleetmix', 'Flexigen', 'Flight Box', 'Flip', 'Flo Pac', 'Floam', 'Flop Star', 'Floppy Zinger', 'Florax', 'Floss and Go', 'Floss and Joes', 'Floss and Toss', 'Floss-O-Matic', 'Flossy Wipes', 'Flotilla the Honey Bee', 'Flotonic', 'Flow Chard', 'Flu Bot', 'Flum', 'Fly’s Water', 'FlyButter', 'Flying Edge', 'Flying Gravity', 'Flying Monk', 'Flying Noodle', 'Flying Potato', 'Flying Salad Bear', 'Flying Tortoise', 'FoamBone', 'Focus Group in a Can', 'Fog Blog', 'Folio Systems', 'Folk Smog', 'Foma', 'Fontaceutical', 'FontFun', 'Food Caulk', 'Food Dump', 'Food for Feet', 'Food Replicas', 'Food Storm', 'Foot Sauce', 'Forever Blonde', 'Fork 3D', 'For-Moolah', 'Fornican’t', 'Fornicon', 'Fountain of Youth', 'Fountain of Youth Booth', 'Foxy by Proxy', 'Foyer Information', 'Frau Lean', 'Freakin', 'Free Pass', 'Free Ranger', 'Free Throw', 'Freedom Fire', 'FreeFlow', 'FreeTime', 'Freezefry', 'Fresh Vinyl', 'FreshFun', 'Freudian Slipper', 'Freudian Slippers', 'Frhythm', 'Friction Dictionary', 'Fried Fruit',
            'Friendly Fire Muscle Cream', 'Frog Box', 'Frog Jerkey', 'Frog Meal', 'FrogMail', 'Frosted Ptarmigan', 'Frothy Logic', 'FroZEN', 'Fruit Chowder', 'Fuelton', 'Full Moon Kathy', 'Full Spread', 'Fun and Folicals', 'Fun Dah Mentals', 'Funk Junk', 'Funky Crunchies', 'FunkyClips', 'Furnafix', 'Furnichorizo', 'Furryfashioners', 'Fuss Potty', 'Future Cat', 'Future Fertilizer', 'Future Finder', 'Future This!', 'Futurelizer', 'G2-También', 'GAAPtek', 'Game Choy', 'Gandhi Jar', 'Garden Burger Variety', 'Gargle Oil', 'GasKan', 'GateGear', 'Gawdy Goddy', 'GD Peanut Brittle', 'Gear God', 'GearLinka', 'Gee Spotty', 'GeekBug', 'GeekChicken', 'Gelatinous Plastic', 'Gellopax', 'Gem Cream', 'Gems for Jesus', 'GeneSink', 'Genetically Modified Happy', 'Genitol', 'Genius in a Bottle', 'Genome Soup', 'GenSink', 'Gentle Purity', 'Geo Circus', 'GeoDash', 'Geofarm', 'Geoform', 'GeoQuest', 'Germ’s Choice', 'Get it There!', 'Get Over Zit', 'Ghost Voices', 'Giant Path', 'Gig Digit', 'Gigazilla', 'Ginger Snapping', 'Ginger Vitro', 'Ginger’s Ailment', 'Girdle Hurdle', 'Gland Weapon', 'Glass Curtain', 'Glassinni', 'Glassiture', 'Glassomatic', 'Gleamer', 'Gliding Light', 'Glint', 'Globo Sphere', 'Glow Ball', 'Glow Wonder', 'Gluid', 'Gluquil', 'Gluz', 'Godka', 'Godzilla Pizza', 'Godzilla’s Playground', 'Goiter Belt', 'Goko', 'Golden Pet', 'Goldworthy Body Tats', 'Golestrex', 'Golistic', 'Good Woody', 'Good Woody Two Shoes', 'GoodKoil', 'Googoyle', 'Gopher Baroque', 'Goreskin', 'Gorganic', 'GorillaTwenty', 'GoTee', 'Gothic Gas Mask', 'gotIT', 'Graco Expectations', 'Grainspot', 'GrainStorm', 'Grandma’s Doily', 'Grassmasher', 'Gravikitty', 'Graviteam', 'GreedKreme', 'Greenclick', 'Greenclicks', 'GreenGo', 'Gristle Bits', 'Gristle Chips', 'Gritty Pudding', 'Groove Cleaner', 'Groove Duster', 'Groove Juice', 'Groove Master', 'Groove Mix', 'Groove Thong', 'GroovEase', 'GrooveClear', 'GrooveKleen', 'GrooveQleen', 'Groovy Cleaner', 'Groovy Suds', 'Ground Grippers', 'Ground Round Publishing', 'Growing Panes', 'Guano Ameretto', 'Guest Host Virus', 'GuiltyKilts', 'Gulliver’s Truffles', 'Gumby’s Choice', 'Guru Gear', 'Guru Smile', 'Gush Puppet', 'Habitalk', 'Habitrail Hole', 'Hair Apparent', 'Hair Easy', 'Hair Looms', 'Hair Paper', 'Hair Peace', 'Hair Test', 'Hairiffic', 'Hairpiece Shoewipe', 'Hairplane', 'Hairport', 'Hairricane', 'Hairs of the Dog', 'Hair-Two-Four', 'Ham Crunchers', 'Ham Horns', 'Ham Licker', 'Ham-Fed Corn Flakes', 'Handshake', 'Hank’s Gadget', 'Happy Clips', 'Happy Hair', 'Happy Snout', 'Harbingel', 'Harmoney', 'Healthy Stance', 'Hear 24', 'Heart Worms', 'Heat Wave Goodbye', 'Heat Waves', 'HeaveHo', 'Heaven Forbid', 'Heaven Lite', 'Heaven’s Hug', 'Heidi Floss', 'Helix Elixer', 'Helixer', 'Hell 2Pay', 'Hell Toupee', 'HelpingHand', 'Helpol', 'Hemi More', 'Hemline of Fire', 'Hequality', 'Her Bath', 'Her Majesty’s Little Black Handbag',
            'Herbal Euphoria', 'Herbal Favour', 'Herbalance', 'Herbowl', 'Hercules Jerky', 'Hesterine', 'Hi Que', 'HighTee', 'Hinderene', 'Hindu Barbie', 'Ho Chi Minhute Maid', 'Hocus Focus', 'Hog Leather', 'Hold It', 'Holy Sauce', 'Homelux', 'Honor Roll', 'Hop ‘N Toss', 'Horizon Glue', 'Horse Maxi', 'Hot Belly Underground', 'Hot Geology!', 'Hot Magma!', 'Hot Poddy', 'Hot Vinyl', 'Hotrod Logic', 'House Scents', 'HouseWax', 'Hover Crank', 'Human Soup', 'Hunky Hurry', 'Hush Now Healthcare', 'HyperMagic', 'iBox', 'Ice Can', 'Ice Lava', 'Ice Tools', 'Icon [Incontinence Control]', 'ICON Incontinence Control System', 'Ideoswitch', 'IDICode', 'IdiMatch', 'Illumilife', 'Illumity', 'Imageflow', 'Imaginart', 'Immunics', 'Immunotrak', 'Imperial Fire', 'ImPetuous Collars', 'inBead', 'Incrediprint', 'Independa', 'Industrial Strength Farm Animals', 'Inferno', 'InfinitySleep', 'inFire', 'Inflamatron', 'Info Sausage', 'InfoDrill', 'Information Plantation', 'InGear', 'inHeat', 'Injoy', 'Inquala', 'Inspect a Miracle', 'Inspiration Hat', 'Inspire Fire', 'InstaBrew', 'Installity', 'InstantServe', 'Insta-Perk', 'Integres', 'Intelemarket', 'Inteliroute', 'Inteliswitch', 'Intelitree', 'intellibox', 'intellipod', 'Intelliprint', 'IntelliSHOP', 'Interactive Learning Stable', 'Interactive Teaching Booth', 'Interbreed', 'InterCode', 'Internet Bubble Bath', 'Internet Bubbly', 'InterPotty', 'InterpretIT', 'Intradisk', 'iPlug', 'Ipod', 'IQ-U', 'Irack', 'Iron Horace', 'iSet', 'Isodrive', 'Isoflux', 'Isologia', 'Isologica', 'Isologics', 'Isologix', 'IsoMonk', 'Isopop', 'IsoPrint', 'Isosphere', 'Isostream', 'Isoswitch', 'IsoTrek', 'IT Magma', 'IT Party', 'IT Planet',
            'ITeam', 'I-Team', 'Jalapeño Fire Waltz', 'Jamnation', 'Jazz Poker', 'Jean Pool', 'Jeans Us', 'Jeeze-Its!', 'Jelity', 'Jesus Blush', 'Jesus Crest', 'Jesus Jeans', 'Jesus Jello', 'Jesus Juice', 'Jesus Waves', 'Jetsilk', 'JetSpeed', 'JetWide', 'Jimbies', 'Jockface', 'Jockstrap Molasses', 'Jog Face', 'Johnny Cashbook', 'JoinHands', 'Joseph K’s Quiz Castle', 'JotBox', 'Jowlsupport', 'Juan Knight Stand', 'Juice Monster', 'Juice-Its!', 'JuiceMaster', 'Juicemate', 'JuJu', 'Jumbo Grunion', 'Jumpnastics', 'Jumpstack', 'Jungle Jewlery', 'Just Encase', 'Just For Her', 'Jute Box', 'Kafka’s Klues', 'Kage', 'KanGas', 'Karma Check', 'Karma Farm', 'Karma Suit', 'Karma Suture', 'Keen Clip', 'Keiretsu Barbie', 'Kettle Pa', 'KeyPlay', 'KidChat', 'Kidgrease', 'Kidline', 'KidsOnly', 'Kidstock', 'KidTalk', 'KidZone Chatterbox', 'Kiev Kreme', 'Kinder Rock', 'Kinderdrama', 'KinderZoo', 'King Bling', 'Kiosk', 'Kioxi', 'Kiss My Buddha', 'Kitch Bitch', 'Kitch Kids', 'Kitchen Caboodle', 'Kitchen Hydraulics', 'Kitsch Bitch', 'Kitty Tonic', 'KleenGrooves', 'Kloth Kops', 'KnackGrip', 'Kneedles', 'Knit and Caboodle', 'Know Boat', 'Know Kidding', 'Know Order', 'Knowcode', 'Knowitol', 'Knowlysis', 'Koffee Kat', 'KollGanja', 'Konnectron', 'KoolBug', 'KoTexas', 'Koughitup', 'Krackers', 'Krill Kream', 'Krill Steaks', 'Krillcream', 'KrillGreen', 'La Canada Cutter', 'La Niña Colada', 'La Nouvelle Chien', 'La Port', 'Lab Along', 'Lamb Bikini', 'Lancelot Boil Cream', 'Landscalpel', 'Landscape Artist', 'Landscapel', 'Lasagne Nudge', 'Laser Senses', 'Lather Gather', 'Lauralight', 'Lazy Fair', 'Lazy Fare', 'Le Boudoir Series', 'Le Crunch',
            'Le Petit Chef', 'Leaf Beef', 'LearnAround', 'Learning Stations', 'Leather Lather', 'Leather Magic', 'LeatherChrome', 'Legal Begal', 'Legal Ease', 'Lemon Pledge Chicken', 'LemonAday', 'Len Made', 'LessStress', 'Letpro', 'Letter Vision', 'Lewd Licorice', 'Lexicondo', 'Life Caddy', 'Life Dialer', 'LifeDrops', 'Lifestyle Tailoring', 'LightSpeed 3000', 'LimberUp', 'Limbratics', 'Linger Foods', 'Lingerie Menagerie', 'Link-It-All', 'Lip Frog', 'LiquiBuzz', 'Liquid Ambassador', 'Liquid Granite', 'Liquid Grooves', 'Liquid Health', 'Liquid Kitty', 'Liquid Leather', 'Liquid Lozenge', 'Liquid Motion', 'Liquid Qleen', 'Liquid Radiant', 'Liquid Silk', 'Liquid Skin', 'Liquid Velvet', 'Liquidation Station', 'Liquidoc', 'Liquinex', 'LiquiPrawn', 'LiquiSpace', 'Liquix', 'LIVE – Library for Interactive Video Education', 'Live God', 'Livin’ Lard', 'Local Globe', 'Loco Motion', 'Locomo', 'Lode and Lock', 'LogonFire', 'Lolipop Flower', 'Lollipopper', 'Loopy', 'Loopy Tuna', 'Loose Leeches', 'Loot & Lather', 'Lord Debit Card', 'Lord Martini', 'Lotus Boogie', 'Louise Jeans', 'Loungerie', 'Love Bomb', 'Love Drops', 'Lovebox', 'LoveFuel', 'LoveMusic', 'Lovepad', 'LowLifeLemon', 'L-Spot', 'Lucky Ducky Soaps', 'Lumbrex', 'Lumi', 'Lunatox', 'Lunchpad', 'Luxury Realm', 'Lyrichord', 'machPRINT', 'Macronaut', 'Mad Grahams', 'MadRush', 'MadRush Media', 'Magellanic Penguin', 'Magic Leather', 'Magic Pan', 'Magic Putter', 'Magic Wand', 'MagiCoil', 'Magma Doodle', 'Magma Pure', 'Magma Radiant', 'Magmina', 'Magnafone', 'Magnaphone', 'Magneato', 'Magnemo', 'Magnina', 'MailPlus', 'Mainline', 'Mainstay', 'Maintain', 'MaintainIT', 'Malta Fur Hide', 'Mama’s Bug', 'Man Swatter', 'Manager Man', 'Manatea', 'Mane Ingredients', 'Mangelica', 'Mannequin Mime', 'MANzania', 'Maple Thor', 'Market Tang', 'Marketoid', 'Marketonic', 'Marquee de Card', 'Marshello', 'Marshmallow Toast', 'Martha Graham Crackers', 'Marvane', 'Marvelous Mutton', 'Massage in a Bottle', 'Mastic Fantastic', 'Mastic Music', 'Math Compressor', 'Matter of Fast', 'Mattermind', 'Mauve Lava', 'Mauve Suave', 'MaxiDog', 'Maximind', 'Maximum Coconut', 'MaxiPrint', 'Maytime Moonsong', 'Mealy Mouthfulls', 'Measure Maid', 'Meaty Boy', 'Mechanical Pudding', 'Media Booths', 'Media Pet', 'Media Supplement Booths', 'MediaLearn', 'Medical Candy', 'Medi-coal',
            'Meet Jesus', 'MegaCoffee', 'Megahurts', 'Megall', 'Memora', 'Memory Cloth', 'Memory Loft', 'Memory Works', 'Menagerie Consolidated', 'Menagerie Margerine', 'Menbrain', 'MercuryWIde', 'Mermaidian', 'Merry Bilgewater', 'MetAL', 'Meteor Media', 'Mexican Botox', 'mGravy', 'Micro Softdrink', 'Microluxe', 'MicroMarquee', 'Micronaut', 'Microsensual', 'Microsmooth', 'MicroToto', 'Midishares', 'Milk Machine', 'Millenium Sandwich', 'Millennial Condom', 'Millennium Sandwich', 'Millennium Starter Kit', 'MillennYum', 'MilqueMade', 'Mind Over Mayhem', 'Mind Rocket', 'MindWrap', 'Mine the Zone', 'Mineral Massage', 'MiniMarquee', 'Minnesota Double Domes', 'Miracle Massage', 'Miraclis', 'Miracula', 'Miss Thought', 'MissApparel', 'Mister Digit', 'Mister Manbubble', 'Mixed Feelings', 'Mobesity', 'Mobildata', 'Mobile Huge', 'Mobile Mousse', 'Mobius Mix', 'Modern Mulch', 'MoldFind', 'Moltantric', 'Molten Tacos', 'Moltonic', 'Mondicil', 'Mondoprint', 'Mongerfish', 'Mongo Shag', 'Monisphere', 'Monk Ease', 'Monkey Darts', 'Monque', 'Monster Cream', 'Monster Juice', 'Mood Lantern', 'Mood Points', 'Mood Puppets', 'Mood Salvo', 'Moonshine Wagon', 'Moose Linen', 'Moose Metal', 'Moose Toe', 'Moreganic', 'MotherWalk', 'MotherWalkers', 'Motherwit', 'Motion Control', 'Motobodies', 'Motovate', 'Motovation', 'Mountain Edge', 'Mountain Mud', 'Mountain Sea Sky', 'Mounty Metal', 'Mouse Tuner', 'Moxi Biloxi', 'Mr. Big Bend', 'Mr. Bookkeeper', 'Mr. Demeanor', 'Mr. Flosty', 'Mr. Fortnight', 'Mr. Frenzy', 'Mr. Interiors', 'Mr. Juice', 'Mr. Losty', 'Mr. Mastic', 'Mr. Pin Action', 'Mr. Rubber Room', 'Mr. Scoopy', 'Mr. Stain', 'Mr. Surely', 'Mr. Tee', 'Mr. Ten Pin', 'Mr. Title Man', 'Ms. Beehaven', 'Mud Puppet', 'MultiChan', 'Multiflex', 'Multiform', 'Musanpoly', 'Muscle Bar', 'Muscle Linen', 'Muscle Magic', 'Muscle Morsels', 'MusiBlast', 'Music Moods', 'MusicMarket', 'Musicoal', 'Musicurities', 'MusicUs', 'MusiFarm', 'MusiPlosion', 'MusiStock', 'Musix', 'Mutt Medallions', 'Muttonchop Sticks', 'My Bad', 'My Concierge', 'myCthulhu', 'myFlip', 'myPass', 'myPortal', 'Mystery Soap', 'Nabokov Drops', 'Naipaul Clamps', 'Naipul Rings', 'Namebox', 'Namegen', 'Nano Bait', 'Nano Courier', 'Nano Delivery', 'Nano Messenger', 'Naom Nuts', 'Narrow Barrow', 'Nasty Good',
            'Natural Software', 'Nature’s Cradle', 'Naxolide', 'Nebulean', 'Neils Particle Board', 'Neonomatic', 'Neoxy 7', 'Neptide', 'Nest Vesting', 'Netbook', 'NetMeter', 'netPhun', 'Netstalgia', 'Netstalgic', 'Netwonderman', 'Neurocell', 'Neutron Bingo', 'Neutron Storm', 'New Age Slurpy', 'New Centurian', 'New Dad', 'New Glass', 'New Gut', 'New Record', 'New Sense', 'New Tab', 'New Vinyl', 'NewSmile', 'Newszorba', 'Nexgene', 'Nexost', 'Nexus Collar', 'Nifty Glob', 'Nightwords', 'Nob Hill', 'Nocturnica', 'Nonvomita', 'Noodle Doodle', 'Norse Code', 'Norse Nurse', 'Nose Curtains', 'Nose Needles', 'Noseballs', 'Noslow', 'Notecushion', 'Notes-n-Quotes', 'Nuclear Winter Mint', 'Nuclear Winter Squash', 'Nucloud', 'Nucrete', 'Nuetrinofast', 'NumberCruncher', 'NuPhoney', 'Nurture Cream', 'Nutri-Taco', 'Nutritious Pirate', 'nuWay', 'Objective Banking', 'Obones', 'Occupassion', 'OCTAPAN – Open Console Technology Application for Performance Area Network', 'Octaplex Ports', 'Octaports', 'Octopush', 'Octorex', 'OdorAll', 'OdorEx', 'OdorOn', 'Off the Cufflinks', 'OffAndOn', 'Oh That Baby', 'Old Butter Scotch Whiskey', 'Old Plywood (Scotch)', 'Old World Technology in a Can', 'Olucore', 'Omatom', 'OmniDog', 'Omnigoggles', 'On Any Line', 'On Holds Barred', 'OnceCode', 'Once’t', 'OnceWrite', 'One Legged Jambox', 'OneCode', 'OneWrite', 'onFire', 'Ontality', 'OpenDoor', 'Opportech', 'Opportunity Spam', 'Option Storm', 'Optique', 'Orange Bounce', 'Orangutan', 'Orbeania', 'Orbiflex', 'Orbit Runner', 'Orbital Luxury', 'Orbixtar', 'Original Bloom', 'Ornamantis', 'Orno', 'Ottoman Dove', 'Ouch Pouch', 'Oui Monsieur Jeans', 'Oulu', 'Oulu Rocinante', 'Ourchive', 'Out There', 'Outer Granola', 'OuterBasics', 'Ovaq', 'Overchurros', 'Overfork', 'Overplex', 'OzMatazz', 'Package Fax', 'Paella Machine', 'Pageclean', 'Pagedrive', 'PageGear', 'Pain by Numbers', 'Paint Me a Picture', 'PANbox', 'PANcan', 'Pandea’s Picture Pages', 'Pandea’s Virtual Recreation Vehicle', 'PANdora', 'Pandora’s Boxers', 'PANEL – Performance Area Network Electronic Links', 'PANELA – Performance Area Network Expedient Links Access', 'Pang Meringue', 'Panoptimist', 'PanSol', 'PANSwich', 'Pantry Liner', 'PANwich', 'Paper Lass', 'Paper Machete', 'PaperPlastic', 'Papricut', 'Paprikut', 'Parallel Patch', 'Parrot Site', 'Particle Farm', 'Party Pour', 'Parvenu Barbie', 'Parvenu Charlie',
            'Parvenu Porkchop', 'Passion Pork', 'Passionaire', 'Pasta Flakes', 'Pasta la Vista', 'Pasture Prime', 'Patchwork Kilt', 'Patty Meal', 'Pawn Bons', 'Pawn Storm', 'Paws’n Rest', 'Pea Kind', 'Pea King', 'PeaceFest', 'Peach Fuzz', 'Peanut Buddha', 'Peanuttle', 'Pearlescient', 'Pearlesex', 'Pedlid', 'Peek-A-Boo Buddha', 'Peek-A-Boo Pork', 'Peek-a-Boom', 'Peek-A-Buddha', 'Peek-a-Pooch', 'Penetratea', 'Penny Karma', 'Penultimate Cute', 'Penultimate Sharpie', 'People Pipes', 'Pepp', 'Pepperboard', 'Pepto Mosh', 'Perceive IT', 'Perfomancer', 'Performance Enhancing Cheese', 'Performance Enhancing Chilli', 'Performancierge', 'Performunch', 'Peril', 'Perk and Peak', 'Perk Mate', 'Perkle', 'Perma Beast', 'Permablonde', 'Permadyne', 'Permanent Post-It', 'Perma-nudge', 'Perotti Biscotti', 'Personal Mars Rover Vehicle', 'Peruvian Mayonaise', 'Pesto Control', 'Pesto Praline', 'Pesto Quest', 'Pet Cookies', 'Pet Couture', 'Pet Gold', 'Pet Pendants', 'PetsNeck', 'Pew Chew', 'PharmCode', 'Phat Attic', 'Phat Chic', 'Phat Tech', 'PhatVat', 'Pheno Barbie Doll', 'Pheromonia', 'Phone Shui', 'Phormula', 'Photo Touch', 'Phuel', 'Pickin’ & Lickin’ Chicken', 'Pigzart', 'Pine Sold', 'Pink Hundred Watt', 'Pinnacoil', 'Pirate Bath', 'Pisserd', 'Pixel Jockey', 'Pizzazilla', 'Plan Along', 'Planet Health', 'Planet Right', 'Plank 10', 'Plaster Blaster', 'Plastic Fantastic', 'Plasto', 'Platformia', 'Platinum PR', 'Playmequotes', 'Plexi Koogle', 'Plexi9', 'Pliable Pudding', 'Plooza', 'PluggedUP', 'Plugzapper', 'Plumb Bum', 'Plumb Magic', 'Plumb Siding', 'Plushy Butter Sandwiches', 'Pocket Marquee', 'Pocket Marketing', 'Pocket Tones', 'Pockmarked Porcelin', 'Poifect', 'Poison Dart Board', 'PokeMonster', 'Polarium', 'Pole Cheese', 'Polka Inferno', 'Pollyantics', 'Pomegarnet', 'Poochouse', 'POP Smart', 'Popcorndog', 'Pope Cycles', 'Popsicle Loops', 'Pore Gold', 'Pore It On!', 'Pork Chopsticks', 'Pork Slurry', 'Porkscrew', 'Porno Corn', 'Port Linker', 'Porta Prawn', 'PortAble', 'Portable Fish', 'PortaCode', 'Portage', 'Portagram', 'Portal LZ', 'Portalib', 'Portaline', 'PortaLink', 'Portalite', 'Portality', 'PortalPro', 'PortalSense', 'PortalStorm', 'PortalTown', 'PortGear', 'Portlite', 'Ports O’ Call Tawny', 'Portsicle', 'PoshPet Collars', 'PoshPooch Collars', 'Post Up', 'Posturion', 'Potato of the Brain', 'Potter Fodder', 'Potty Snax', 'Power Coffee', 'Power Cruisers', 'Power Keg', 'Power Latte', 'Power Portal', 'Power Shadow', 'Power Taco', 'Power Tortoise', 'Power Zilla', 'PowerCast', 'PowerPort', 'PowerPortal', 'PowerPotato', 'PowerPrint', 'PowerRain', 'Practical Pork', 'Prawn Alfredo', 'Prawn and Pretzel', 'Prawn Bons', 'Prawn Crystals', 'Prawn Danish', 'Prawn Flakes', 'Prawn Gravy', 'Prawn Leather', 'Prawn Patties', 'Prawn Perfect', 'Prawn Pudding', 'Prawn Sausage', 'Prawn Ton Soup', 'Prawnchilada', 'Prawnlette', 'Pray and Play', 'Precious Potato', 'Pre-fab Burritos', 'Premiant',
            'Presto Pesto', 'Prettease', 'PrettyPet', 'Pretundra', 'Prevalax', 'Previewshop', 'Prim n’ Print', 'Princess Fresh', 'Princess Jellybean', 'Princess Plex', 'Princess Prawn', 'PrintBUZZ', 'Printo Supremo', 'Printorama', 'PrintPlosion', 'Printspan', 'Prior IT', 'Prismplane', 'Pristea', 'PrivateEye', 'Pro Coke', 'Pro Testors', 'Procrawler', 'Proflex', 'Progenex', 'PromoteIt', 'ProPortal', 'Prospectix', 'Prosperity Cafe', 'Protectaderm', 'ProteX', 'Prothopedic', 'Proton Storm', 'Protoshades', 'Protoshape', 'Psychic Pizza', 'Psychotron', 'Psychotrone', 'Pub Parrot', 'Pubic Coil', 'Pubicoil', 'Pubisphere', 'Pudding Queen', 'Pumpty Dumpty', 'Punacium', 'Punk Blaster', 'Punkies', 'Puns and Needles', 'Puppet Box', 'Puppet Mustard', 'Puppytropic', 'Pure Chipotle Pleasure', 'Pure Penguin', 'PureShare', 'Purpletown', 'Pursy Print', 'Pylon Hose', 'Qaboos', 'Q-lean', 'Qleen', 'Qleen Air', 'Qleen Tooth', 'Qnekt', 'Quadvert', 'Quadzoonple', 'Qualicolor', 'Qualiprint', 'Quality Planet', 'Qualiwide', 'Quantitine', 'Quantoflex', 'Quantum Taco', 'Quarmony', 'Quarx', 'Quatrain Tsunami', 'Quatro 7', 'Que West', 'Queen Beam', 'Quella', 'Quench Drench', 'Quencha', 'Quesylax', 'Quick Licks', 'Quick Milk', 'Quick Tart', 'Quick Turtle', 'QuickFrame', 'QuickGear', 'QuickPort', 'Quicksoil', 'QuickUps', 'Quiet Time', 'Quilch', 'Quill Terminal', 'Quiltreen', 'Quiznost', 'Quoductor', 'Quonata', 'Quotagio', 'Quotebang!', 'QuoteBeat', 'QuoteChorus', 'QuoteConductor', 'Quotephony', 'Quotezart', 'Quothoven', 'Racketier', 'Radiant Butane', 'Radiant Earth', 'Radiant Ease', 'Radiant Fire', 'Radiant Fresh', 'Radiant Penguin', 'Radiantix', 'Radio Free University', 'Radio GPA', 'Radio Underwear', 'Radioblade', 'Radiopaste', 'Radiospigot', 'Radiotronic', 'RADr', 'Raising Music', 'RALLOY', 'Ramsmack', 'RAPID – Radical Accessories for Pet IDentification', 'Rare IT', 'Raspberry Perfect', 'Rasta Pops', 'Re Dye', 'Ready Fortune Teller', 'Real Virtual', 'Rebooth', 'Rebuttal Rocket', 'Reco Lab', 'Record Doctor', 'Record Rehab', 'Record Revitalizer', 'Record Wash', 'Record Wizard', 'Recordclear', 'Recrisys', 'Recritube', 'Red Butter', 'Red eScent', 'Red Hot Chilli Butter', 'Red Nerve', 'Red Thunder', 'Regiment [Incontinence Control]',
            'ReLeash Me', 'Remotion', 'Renalator', 'Repetwire', 'Rescreen', 'Resorcerer', 'Restease', 'Restware', 'Resumé Candy', 'Retrack', 'Retro Cocoa', 'Retro Salts', 'Retrotex', 'ReturnStiles', 'ReturnStyles', 'Reverse Curse', 'Reward Chord', 'Rice-A-Raunchy', 'Ricki Martini', 'Rin Tin Thin', 'Ring Bling', 'Rio Rocinante', 'Riot Grrill', 'Rippers', 'Rithmaticker', 'Ritual Wave', 'Riverman', 'Road Krill', 'Road Quil', 'Road Rabbit', 'Road Rodent', 'Robo Cot', 'Robotox', 'Rock Meet', 'Rock Paper Sisters', 'Rockabye', 'Rocket Gloss', 'Rocket Print', 'Rocket Red', 'Rocket Silence', 'Rocket Wide', 'Rocko Blast', 'Roll Aid', 'Roll Aide', 'Ronelon', 'Roof Rabbits', 'Rooforia', 'Rot Dog', 'Rotation Tanks', 'Row Bust', 'Royal Plush', 'Royal Pudding', 'RSVP', 'Rubadub', 'Rubber Slapjack', 'Ruby Friday', 'Ruby Suite', 'Rug Rockers', 'Running Rocks', 'Sabercloth', 'Sabertooth', 'Sacrificial Ham', 'Safe Yarn', 'SafeChat', 'SafeSurf', 'SafeWeave', 'Saguarro Foam', 'Sales Driver', 'Salon Da Bomb', 'Salsa Man', 'Salton Sea Crisps', 'Salud!', 'Sandman Sleeps', 'Saphire Rose', 'Sara Soda', 'Sarin-Aide', 'Sassessories', 'Sasskatchy!', 'Sassy Boils', 'Sassybox', 'Satiance', 'Save the Date', 'SaveIT', 'Savvy Ass', 'Scalpel Scrupulous', 'Scatterbox', 'Scene Caddy', 'Scentric', 'Scentwicks', 'Schoolio', 'Scienscribe', 'Scissor Fresh', 'Scorched Sunwear', 'Score 4', 'Screen Bubbles', 'Screen Sculptor', 'Screen Seder', 'Screenfree', 'Scriptease', 'Scrub Down', 'Sea Edge', 'Sea Ocean Sky', 'Sea Quinn', 'Sea Script', 'Sea Sleigh', 'Sea Spam', 'Seafood Seranade', 'SeaMountain', 'Secret Soap', 'See-Thru Composites', 'SemiFood', 'Señor Serene', 'Sensor Ship', 'Sensual Pores', 'Sequin', 'Sequitur', 'ServeRate', 'Service Tree', 'Sesproctyl', 'Sexaphone', 'Shadease', 'ShakeHands', 'ShakeOut', 'Shameless Flu Waistcoat', 'Shangrilatte', 'Shark Fin Suit', 'ShelfStore', 'Shhh!', 'Shiny Spinners', 'Shipping Court', 'Shipping Magneto', 'Shoot the Messenger', 'Shopabout', 'Shopping Stones', 'ShopSMART', 'ShowerPower', 'ShowTuner.com', 'Shpritz', 'Sigh Bore', 'Sigh Clone', 'Signity', 'Silent Swift', 'Silkia Sunrise', 'Silly Satan', 'Silly String Serene', 'SillySoap', 'Silodyne', 'Simplex Ports', 'Sin n’ Spin', 'Sin Sin', 'Sinchiladas', 'Sing Bling', 'Single Happiness', 'Sinus Side', 'SipitUp', 'Sizzling Brainpan', 'Sketch-a-Screen', 'Skin Bin', 'Skin Deeper', 'SkinGear', 'Skinny Boboli', 'Skinserve', 'Skintights', 'Skull King', 'Skullite', 'SkyBag', 'SkyMountain', 'Slackex', 'Slang Machine', 'Slashed Chicken', 'Sleeky', 'Sleeper Waves', 'SleepWatch', 'Sleeveport', 'Sleevy Wonder', 'Slim Tricks', 'SlimAll', 'Slo-Cooked Prawns', 'Slofast', 'Sludgehammer', 'SlumberBed', 'Slumberia', 'Smart Ask', 'Smart Board', 'Smart Clone', 'Smart Cream', 'Smart Glue', 'Smash and Grab', 'Smash Pop', 'Smashed Potatoes', 'SmileAwhile', 'Smoking Data Guns', 'Smoochy Goochy Bar', 'Snack Action', 'Snack Patrol', 'Snack-A-Poo', 'Snacktion', 'SnailPost', 'Snake Cakes', 'Snappers', 'Snappy Clips', 'Snappy Trails', 'Snapricot', 'Snatch Shacks', 'SnobDobbler', 'Snolvent', 'Snoozarium Sectionals', 'Snorepads', 'Snowpoke', 'So So Choritzo', 'Soap Capsule', 'Socks Appeal', 'Soda Baking', 'Soda Fonze', 'Soda Jerky', 'Soda Popcorn', 'SodaPoppin', 'Soft and Strong', 'Soft Shark', 'SoftGeek', 'Softmicro', 'SoftSoaks', 'Softstream',
            'Softwar', 'Software', 'Soilarium', 'Solar Bingo', 'Solar Certain', 'Solaren', 'Solarmovie', 'Soldier’s Neckbrace', 'Solgan', 'SoluDye', 'Soma Night', 'Sonata Fast', 'Songbird', 'Songlines', 'SongUP', 'Sonic Boombooms', 'Sonic Faucet', 'SonicQuotes', 'SonicStock', 'SonicStreet', 'Sonique', 'Soniquote', 'Sorb', 'SoreBeGone', 'Sorely Mist', 'Soul Sketch', 'Soundcircus', 'Soundquotes', 'Souperb', 'Sour Crocodile', 'Sour Organic Grapes', 'Source Rack', 'Source Sports', 'South Mouth Southern Mash', 'Sox Box', 'Soy Milk-toast', 'Soylean', 'Space Barge', 'Spacewax', 'Spam and Deliver', 'Spam Sushi', 'Spam Tartare', 'Spamo', 'Spavane', 'Special eLivery', 'Special Sticks', 'SpectraPrint', 'Speed ‘n Spot', 'Speed Street', 'Speedbolt', 'SpeedSpot', 'Spelltech', 'Spinalysis', 'Spin-n-Clean', 'Spire', 'Spiritablets', 'Splash', 'Splinter', 'Spong', 'Sponge Taco', 'Spontaneous Combustion', 'Spoon Bait', 'Spoonbeam', 'Spooncake', 'Sport Chai', 'Sport Foam', 'Sportan', 'SpotOn', 'Spraytection', 'Spring Clips', 'Spring to Life', 'Springbee', 'Springers', 'Spurt', 'Square Root Beer', 'Squeegee Spree', 'Squeeze Play', 'Squid Pops', 'Stallag Dry', 'Stand By Your Manicotti', 'Standalone Uniques', 'Standing Chocolate', 'State Mints', 'Steak Surprise', 'Steering Wheel', 'Stelaecor', 'Stereoscopic Endromes', 'SteriThread', 'Stim Kitty', 'StinkX', 'Stockdagio', 'Stockductor', 'StockMarketBlues', 'StockMusic', 'Stockposer', 'StockSonic', 'Stomp Fish', 'Store Your Oats', 'StoreGear', 'Strain Away', 'Straloy', 'Stralum', 'Strange Tails', 'Strataform', 'Streamantic', 'Strepaway', 'Strepbegone', 'Streptease', 'StressLess', 'Stretch and Go', 'Stretch For Strength', 'Stretch n’ Kvetch', 'Stretchercise', 'Stretchmatic', 'Stretch-n-Shape', 'Stretch-O-Mania', 'Stretch-O-Rama', 'Strideline', 'Structural Glass', 'Structure-AL', 'Strydesdale', 'Stunt Cake', 'Stylennium Mylennium', 'Subtle Stubble', 'Sudden Enemy', 'SuddSurprize', 'Sugar Caulk', 'Sugar Dog', 'Sugar Floss', 'Suicidal Post-Its', 'Suicide Abs', 'Sulpha Flight', 'Sulpha Mate', 'Sulpha Quik', 'Sulpha Sphere', 'Sulpha Spread', 'Sulphafloss', 'Sultracin', 'Sultrax', 'Sum Bum', 'Sumper', 'Sun Bite', 'Sunclipse', 'Sunscreen by Burning Man', 'Sunsight', 'Super Ciao', 'Super Cize', 'Super Nothing', 'Super Scale', 'Super Sonic Market Tonic', 'Super Tin', 'Superglass', 'SuperHelix', 'SuperPrint 1000', 'Supersoap', 'Supersonic Printron', 'Supplex', 'Supportal', 'Sure Paw', 'SurfSafe', 'Sushi Spam', 'SustainFrame', 'Sutra Tonic', 'Svelt Smelt', 'Sweet Dreams', 'Sweet Suds', 'SweetSport', 'Sweetums', 'Swift Shift', 'Swim Beam', 'Swindle Gadget', 'Swing Bling', 'Swing Saw', 'Swing Sing', 'Swingzen', 'SwitchStream', 'Sycofont', 'Sycophant Pants', 'Symbiotica', 'Syncopatch', 'SynCOR', 'Syndrome Dome', 'Syndromo', 'Synonym Toast', 'SystemFire', 'Tabtotaler',
            'Taco Bear', 'Taco Hash', 'Tae-Can-Do', 'TakeCare', 'Talent Shout', 'Tali-Band-Aid', 'Tali-Bon Bons', 'Talkalong.com', 'Talkalot', 'Talking Tuna', 'Talkola', 'Talkomatic', 'Tally Forth', 'Tango Latté', 'Tango Puppy', 'Tango!', 'Tarmodial 14', 'Tart’n Tingly', 'Té Tango', 'Tea Bones', 'Teach Yourself', 'Teaky Freaky', 'Teal Worms', 'Teavine', 'Tech Tap', 'Tech Tech Goose', 'Techade', 'Technoracks', 'Tedrigan', 'Teen Cream', 'Teledrone', 'Telemarket Tear', 'Telemarket Tier', 'Telepark', 'Tele-Taco', 'Telethong', 'Tell-E', 'Tellifly', 'Temporary Bone', 'Tempura Sunrise', 'Ten More Pounds Cake', 'Tender Ties', 'Tender Tough Tushettes', 'Tendon C', 'TentAL', 'TeqRaq', 'Teraprene', 'Terascape', 'Terra Cotta Jones', 'Terra Monk', 'Terrablast', 'Terrago', 'Terrapod', 'TerraSwitch', 'Test Ease', 'Thai Cheetos', 'That’s a Wrap!', 'The Ass-tronaut', 'The Atomizer', 'The Audiomat', 'The Bean Machine', 'The Blinder', 'The Boss-buster', 'The Calling Companion', 'The Carpet Caretakers', 'The Chickery', 'The Chopper’s Block', 'The Cinch', 'The Circus', 'The Cthulhu Interactive Novel', 'The Deal Finder', 'The Dollop', 'The Element', 'The Entity', 'The Eyeful Tour', 'The Face Friend', 'The Interactive Online Cthulhu Game', 'The Lazy Mate', 'The Learning Lab', 'The Lost Lampoon Gold Mine', 'The Mobe', 'The Monte Magum', 'The Mouth Piece', 'The Pavery', 'The Pool of Pep', 'The Print Rocket', 'The Profit Taker', 'The Quiche of Death', 'The Route 66 Guide to Lost Wages', 'The Royal Ensemble', 'The Spigot', 'The Sports Barge', 'The Tao of Fragrance', 'The Toilet Triage', 'The Trouble Shovel', 'The Video Cube', 'The Vinyl Solution', 'theCommingler', 'Third Eye Focus', 'This Damn Planet', 'This Ware', 'Thong Bong', 'Through Port', 'Thumb Butter', 'ThunderBag', 'ThunderSea', 'Thunderwear', 'Tick Talk', 'Tickerband', 'Ticker-me-Alamo', 'Tickernotes', 'Tickerplay', 'Tickersonic', 'Tickertalks', 'Ticket Lift', 'Tickle Tan', 'Tickle Town', 'Tiger Tan', 'Time Released Chill Pill', 'TINCTURE', 'TINGLE', 'Tipper Tape', 'Titonic', 'Toe Food', 'Tofu Magician', 'Toggle Town', 'Toggle Turn', 'Toggletopper', 'Tokyo Yo', 'Tone Bone', 'Toot Boot', 'Tooth and Nail', 'Topicpro', 'Tori Spelling Salts', 'Torpor Snacks', 'Tossed Cookie Salad', 'Toy Botox', 'Toylet', 'Toyletry', 'Toylid', 'Trackers', 'TransApp', 'Transcoder', 'Transluscent', 'TransmitID', 'Transparent Structures', 'Transparent Wood', 'TransPort', 'Transputer',
            'Trasola', 'Treasure Soap', 'Troché', 'Trojan 60 Grit', 'Trollery', 'Tropicava', 'Tropolis', 'Trouser Smarts', 'True By You', 'True Faux', 'Trupro', 'TrustNow', 'TryAL', 'TryMe', 'Tsunami Tsandwich', 'Tub Tea', 'TubAL', 'Tubalum', 'Tubesys', 'Tubinum', 'Tufferwear', 'Tumble Bees', 'Tuna Bar', 'Tuna Milton', 'Tuna Truffle', 'Tungsten Throatswitch', 'Turkey Biscotti', 'Turkey Fins', 'Turnkey Vulture', 'Turnling', 'Turtle Magic', 'Turtle Quick', 'Turtlemania', 'Tushy Tickles', 'Tushy Towels', 'Tutor de Force', 'Tutubang', 'Tweezy', 'Twelve Steps Exercise Program', 'Twiggery', 'Twiist', 'Twinkle Tows', 'Two by Faux', 'Two Faux', 'Two Like You', 'Typhoon Booth', 'Typo Generator', 'Tyrannasaurus Pyrex', 'Tyrannosaurus Rocks!', 'Uber Goober', 'Uberlux', 'UberPrawn', 'Ultra Beef', 'Ultra Mouse', 'UltraAll', 'Ultraboost.com', 'Ultrafloxi', 'Ultramouse', 'UltraPrint', 'Ultrasound of Music', 'Ultrasounder', 'Ultrimax', 'Umbilical Cordials', 'Umbrella Grouper', 'Umbrella Wet', 'Uncle Bulgaria’s Wand of Sand', 'Undertap', 'UniNerve', 'Unique-Band', 'UnSmell', 'Unwine', 'Up Your Sleeve', 'Upperimage', 'UpScaleSoda', 'Urban She', 'Urban Sturgeon', 'Urbanshee', 'Vagilax', 'Vaginex', 'Valreda', 'Van Mango', 'Vaporia', 'VegiGate', 'VegiLax', 'Vegone', 'Veil Crow', 'Velocitizer', 'Velveeta ‘N Grits', 'Velvet Stucco', 'Venetian Sack', 'Vervetine', 'Vettigan', 'VGates', 'Viacrobat', 'Viagrand', 'Viagrandy', 'Viagreat', 'Vibemaker', 'Video Booth', 'VideoBounce', 'Videoputer', 'Videorang!', 'Villagevault', 'Vinch', 'Vineclimber', 'Vinyl Maid', 'Vinyl-E', 'Vinylwash', 'Viogre', 'Vireal', 'Virtual CEO', 'Virtual Horseshoes', 'Virtual Rodeo', 'VirtualGates', 'VirtualGear', 'Vision Air', 'Vision Launch', 'Vision Maximizer', 'Visionary Dairy', 'Visionary Summit', 'Visualix', 'VitaKids', 'Vital Java', 'Vitea', 'Voice Writer', 'Volax', 'Voodles', 'Voodoo Chart', 'Voodoo Vat', 'Voodude', 'Voodulce', 'Vortax', 'Voyeur Information', 'Vulvamatic', 'Vulvax', 'Waab', 'Wade Away', 'Waisting Away', 'Walkers-R-Us', 'Walla Wild', 'Wannabeans', 'Wannabeast', 'War Balm', 'Wardrobe of Mass Destruction', 'Wasabi Fresh', 'Wash and Play', 'Water Lily Scum Snaps', 'Water Rabbit', 'Water Rodeo',
            'Water Whole', 'Waterbaby', 'Watersprout', 'We Monsieur', 'Wear Wolf', 'Weatherwear', 'Webalot', 'Webphonics', 'Website of Mass Deconstruction', 'WebTex', 'Week-A-Drink', 'Weight and Sea', 'WenchSip', 'Wheat Toaist', 'Wheeze Ease', 'Wheeze Whiz', 'Wheezebox', 'Whim-Wham-Wash', 'Whipped Words', 'Whiskey and Bits', 'Whispering Stone', 'White Worm Cigarettes', 'Whole Suite Software', 'Why Fi', 'Wicked Cute', 'Wicker Script', 'WideBody Printer', 'WideColor', 'Widespeed', 'WideVision', 'Wig It!', 'Wildfelt', 'Winky Stick', 'Wire House', 'Wirehopper', 'Wirelass', 'WiseGuide', 'WiseWeave', 'Wish Kiss', 'Withstand and Deliver', 'Wolf Wear', 'Wonderwear', 'Woolicream', 'Word Borg', 'Word Salad', 'Word Village', 'WordBlab', 'WordFrame', 'Wordlab Exclusivo', 'Wordlobster', 'Wordly Wise', 'WordQuizzers', 'Words to the Wise', 'World Processor', 'World Sage', 'Wrapture', 'Write Light', 'WriteOnce', 'WriteTech', 'X Flip', 'Xbones', 'Xedenex', 'Xeno Logics', 'XENO Sphere', 'Xinware', 'Xleen', 'Xoggle', 'XORCat', 'XORCat 5000', 'Xorette', 'XORtrak', 'XORts', 'Xplor', 'Xth', 'Xurban', 'Xymonk', 'Y2Canine', 'Y2Kocktail', 'Y2OK!', 'Yada Yada Prada', 'Yak Candy', 'Yakima Burger', 'Yangtze Doodle', 'Yankee Ass', 'Yardvark', 'Yeasty Pete', 'Yo Phat!', 'Yo Yorkshire', 'Yogurt Hygene', 'YOU TURN – Leadership Program for Youth', 'YouthZest', 'Zaggle', 'Zaggles', 'Zaj', 'Zamox', 'Zanilla', 'Zanthral', 'Zanymax', 'Zaphire', 'Zappix', 'Zaya', 'Zazz', 'Zazz!', 'Zboo', 'Zeam', 'Zeam Seam', 'Zedalis', 'Zelluloid', 'Zelpo', 'Zen BBQ', 'Zen Coin', 'Zen Collar', 'Zen Kola', 'Zenchiladas', 'Zendo', 'Zenka', 'Zenlighten', 'Zenod', 'Zenodium', 'Zenolux', 'Zensor', 'Zensure', 'Zensus', 'Zenthall', 'Zentia', 'Zentime', 'Zentix', 'Zentrapore', 'Zentric Pure', 'Zentricity', 'Zentry', 'Zentury', 'Zepitope', 'Zerbina', 'Zero Logic', 'Zestea', 'Zialactic', 'Zidant', 'Zidox', 'Ziggles', 'Ziggy Endust', 'Zilch', 'Zilencio', 'Zilidium', 'Zilla', 'Zilla Drop', 'Zilla Nation', 'Zillabells', 'Zillaberry', 'Zillaboard', 'Zillabug', 'Zillacom', 'Zillactic', 'Zilladyne', 'Zillagod', 'Zillagoogle', 'Zillamatic', 'Zillan', 'Zillanet', 'Zillanoid', 'Zillidium', 'Zinch', 'Zing!', 'Ziore', 'Zipadipoolda', 'Zipak', 'Zip-Lock Body Bags', 'ZippyNet', 'Zitgone', 'Zizzle', 'Zizzy', 'Z-lestial', 'Z-licious', 'Zog', 'Zoinage', 'Zolar', 'Zolarex', 'Zolarity', 'Zoom Zoom Shipping', 'ZoomZoom', 'Zork', 'Zorromop', 'Zounds', 'Zwebby', 'Zyple', 'Zytrac', 'Zytrax', 'Zytrek', 'Zytrexaline',
        ],
    ];

    public function customFieldSet(): string
    {
        return str_replace(' ', '_', static::randomElement(static::$productName['adjective']) . ' ' . static::randomElement(static::$department) . ' ' . static::randomNumber(5));
    }
}
