const a=`<mt-text-editor-toolbar-button :button="button" :editor="editor" :disabled="disabled" @click="openLinkModal" /> <mt-modal-root :is-open="showLinkModal" @change="($event) => (showLinkModal = $event)" > <mt-modal width="s" :title="$t('sw-text-editor-toolbar-button-link.modalTitle')" class="sw-text-editor-toolbar-button-link__modal" > <template #default> <mt-loader v-if="isLoading" /> <div v-else class="sw-text-editor__link-modal" > <mt-select :label="$t('sw-text-editor-toolbar-button-link.linkType')" :options="linkOptions" :model-value="linkType" @update:model-value="onSelectFieldChange" /> <mt-text-field v-if="linkType === 'link'" v-model="linkHref" :label="$t('sw-text-editor-toolbar-button-link.linkUrl')" placeholder="https://example.com" required /> <mt-text-field v-if="linkType === 'phone'" v-model="linkHref" :label="$t('sw-text-editor-toolbar-button-link.linkPhone')" placeholder="+123456789" required > <template #prefix> {{ $t('sw-text-editor-toolbar-button-link.linkPhonePrefix') }} </template> </mt-text-field> <mt-email-field v-if="linkType === 'email'" v-model="linkHref" :label="$t('sw-text-editor-toolbar-button-link.linkEmail')" :placeholder="$t('sw-text-editor-toolbar-button-link.linkEmailPlaceholder')" /> <sw-entity-single-select v-if="linkType === 'detail'" v-model:value="linkHref" entity="product" should-show-active-state :criteria="productEntityFilter" :label="$t('sw-text-editor-toolbar-button-link.linkDetail')" :placeholder="$t('sw-text-editor-toolbar-button-link.detailPlaceholder')" show-clearable-button display-variants /> <sw-category-tree-field v-if="linkType === 'navigation'" :label="$tc('sw-text-editor-toolbar-button-link.linkTo')" :placeholder="$tc('sw-text-editor-toolbar-button-link.categoryPlaceholder')" :categories-collection="categoryCollection" single-select @selection-add="replaceCategorySelection" @selection-remove="removeCategorySelection" /> <sw-media-field v-if="linkType === 'media'" v-model:value="linkHref" :label="$tc('sw-text-editor-toolbar-button-link.linkTo')" :criteria="entityFilter" single-select /> <mt-switch v-if="showOpenInNewTabToggle" :label="$t('sw-text-editor-toolbar-button-link.openInNewTab')" :model-value="linkTarget === '_blank'" :aria-label="$t('sw-text-editor-toolbar-button-link.openInNewTab')" class="sw-text-editor-toolbar-button-link__open-in-new-tab-switch" @update:model-value=" (checked) => { linkTarget = checked ? '_blank' : null; } " /> <mt-switch v-model="displayAsButton" :label="$tc('sw-text-editor-toolbar-button-link.displayAsButton')" class="sw-text-editor-toolbar-button-link__display-as-button-switch" /> <mt-select v-if="displayAsButton" v-model="buttonVariant" :options="buttonVariantList" /> </div> </template> <template #footer> <div class="sw-text-editor__link-modal-footer"> <div class="sw-text-editor__link-modal-footer-left"> <mt-button variant="critical" :disabled="!isLink()" @click="removeLink" > {{ $t("sw-text-editor-toolbar-button-link.removeLink") }} </mt-button> </div> <div class="sw-text-editor__link-modal-footer-right"> <mt-modal-close as="mt-button" variant="secondary" > {{ $t("global.default.cancel") }} </mt-modal-close> <mt-button variant="primary" @click="applyLink" > {{ $t("sw-text-editor-toolbar-button-link.applyLink") }} </mt-button> </div> </div> </template> </mt-modal> </mt-modal-root>`,{Criteria:i,EntityCollection:r}=Shopware.Data,s=Shopware.Component.wrapComponentConfig({template:a,inject:["repositoryFactory"],props:{editor:{type:Object,required:!0},button:{type:Object,required:!0},disabled:{type:Boolean,default:!1}},data(){return{isLoading:!0,showLinkModal:!1,linkHref:"",linkTarget:null,linkType:"link",categoryCollection:null,displayAsButton:!1,buttonVariant:"primary"}},computed:{linkOptions(){return[{id:"link",label:this.$t("sw-text-editor-toolbar-button-link.linkOptions.link"),value:"link"},{id:"detail",label:this.$t("sw-text-editor-toolbar-button-link.linkOptions.product"),value:"detail"},{id:"navigation",label:this.$t("sw-text-editor-toolbar-button-link.linkOptions.category"),value:"navigation"},{id:"media",label:this.$t("sw-text-editor-toolbar-button-link.linkOptions.media"),value:"media"},{id:"email",label:this.$t("sw-text-editor-toolbar-button-link.linkOptions.email"),value:"email"},{id:"phone",label:this.$t("sw-text-editor-toolbar-button-link.linkOptions.phoneNumber"),value:"phone"}]},buttonVariantList(){return[{id:"primary",value:"primary",label:this.$tc("sw-text-editor-toolbar-button-link.buttonVariantPrimary")},{id:"secondary",value:"secondary",label:this.$tc("sw-text-editor-toolbar-button-link.buttonVariantSecondary")},{id:"primary-sm",value:"primary-sm",label:this.$tc("sw-text-editor-toolbar-button-link.buttonVariantPrimarySmall")},{id:"secondary-sm",value:"secondary-sm",label:this.$tc("sw-text-editor-toolbar-button-link.buttonVariantSecondarySmall")}]},seoUrlReplacePrefix(){return"124c71d524604ccbad6042edce3ac799"},categoryRepository(){return this.repositoryFactory.create("category")},showOpenInNewTabToggle(){return["link","detail","navigation","media"].includes(this.linkType)},productEntityFilter(){const t=new i(1,25);return t.addAssociation("options.group"),t.addFilter(i.multi("OR",[i.equals("product.childCount",0),i.equals("product.childCount",null)])),t},entityFilter(){const t=new i(1,25);return t.addAssociation("options.group"),t.addFilter(i.multi("OR",[i.equals("product.childCount",0),i.equals("product.childCount",null)])),t}},created(){this.categoryCollection=this.getEmptyCategoryCollection()},methods:{async openLinkModal(){var l;this.isLoading=!0,this.showLinkModal=!0,this.linkHref=this.editor.getAttributes("link").href??"",this.linkTarget=this.editor.getAttributes("link").target??"";const{linkType:t,linkHref:e}=await this.parseLink(this.linkHref);this.displayAsButton=(l=this.editor.getAttributes("link").class)==null?void 0:l.includes("btn"),this.displayAsButton&&(this.buttonVariant=this.parseButtonClass()),this.linkType=t,this.linkHref=e,this.isLoading=!1},async parseLink(t){const e=t.slice(0,-1).split("/");return t.startsWith(this.seoUrlReplacePrefix)&&["navigation","detail","mediaId"].includes(e[1])?(e[1]==="navigation"?this.categoryCollection=await this.getCategoryCollection(e[2]):e[1]==="mediaId"&&(e[1]="media"),{linkType:e[1],linkHref:e[2]}):t.startsWith("mailto:")?{linkType:"email",linkHref:t.replace("mailto:","")}:t.startsWith("tel:")?{linkType:"phone",linkHref:t.replace("tel:","")}:{linkType:"link",linkHref:t}},parseButtonClass(){const e=(this.editor.getAttributes("link").class??"").split(" "),l=this.buttonVariantList.find(o=>e.find(n=>n===`btn-${o.value}`?o:!1));return(l==null?void 0:l.value)??"primary"},applyLink(){const t=this.prepareLink(),e=this.prepareClass();this.prepareTarget(),this.editor.chain().focus().extendMarkRange("link").setLink({href:t,target:this.linkTarget,class:e}).run(),this.showLinkModal=!1},removeLink(){this.editor.chain().focus().unsetLink().run(),this.showLinkModal=!1},isLink(){return this.editor.isActive("link")},prepareLink(){switch(this.linkType){case"detail":return`${this.seoUrlReplacePrefix}/detail/${this.linkHref}#`;case"navigation":return`${this.seoUrlReplacePrefix}/navigation/${this.linkHref}#`;case"media":return`${this.seoUrlReplacePrefix}/mediaId/${this.linkHref}#`;case"email":return`mailto:${this.linkHref}`;case"phone":return`tel:${this.linkHref.replace(/\//,"")}`;default:return this.addProtocolToLink(this.linkHref)}},prepareClass(){return this.displayAsButton?`btn btn-${this.buttonVariant}`:void 0},prepareTarget(){this.showOpenInNewTabToggle||(this.linkTarget=null)},addProtocolToLink(t){if(/(^(\w+):\/\/)|(mailto:)|(fax:)|(tel:)/.test(t))return t;const e=/^\/[^\/\s]/.test(t),l=t.substring(0,1)==="#",o=/^\/\/[^\/\s]/.test(t);return!e&&!l&&!o&&(t=`https://${t}`),t},getCategoryCollection(t){const e=new i(1,25).addFilter(i.equals("id",t));return this.categoryRepository.search(e)},getEmptyCategoryCollection(){return new r(this.categoryRepository.route,this.categoryRepository.entityName,Shopware.Context.api)},replaceCategorySelection(t){this.linkHref=t.id},removeCategorySelection(){this.linkHref=""},onSelectFieldChange(t){this.linkType=t,this.linkHref=""}}});export{s as default};
