const r=`{% block sw_order_send_document_modal %} <sw-modal class="sw-order-send-document-modal" :title="$tc('sw-order.documentCard.labelSendDocument')" :is-loading="isLoading" @modal-close="$emit('modal-close')" > {% block sw_order_send_document_modal_info %} <sw-container class="sw-order-send-document-modal__info-container" columns="1fr 1fr 1fr" > {% block sw_order_send_document_modal_info_number %} <sw-description-list> <dt>{{ $tc('sw-order.documentSendModal.labelNumber') }}</dt> <dd>{{ document.config.documentNumber }}</dd> </sw-description-list> {% endblock %} {% block sw_order_send_document_modal_info_type %} <sw-description-list> <dt>{{ $tc('sw-order.documentSendModal.labelType') }}</dt> <dd>{{ document.documentType.name }}</dd> </sw-description-list> {% endblock %} {% block sw_order_send_document_modal_info_date %} <sw-description-list> <dt>{{ $tc('sw-order.documentSendModal.labelDate') }}</dt> <dd><sw-time-ago :date="document.createdAt" :date-time-format="{ month: '2-digit', day: '2-digit' }" /></dd> </sw-description-list> {% endblock %} </sw-container> {% endblock %} {% block sw_order_send_document_modal_mail_template_select %} <sw-entity-single-select v-model:value="mailTemplateId" class="sw-order-send-document-modal__mail-template-select" entity="mail_template" :criteria="mailTemplateCriteria" label-property="mailTemplateType.name" :label="$tc('sw-order.documentSendModal.labelMailTemplate')" description-position="bottom" required @update:value="onMailTemplateChange" > <template #result-description-property="{ item }"> {{ truncateFilter(item.description, 160) }} </template> </sw-entity-single-select> {% endblock %} {% block sw_order_send_document_modal_customer_mail_select %} <mt-text-field v-model="recipient" :label="$tc('sw-order.documentSendModal.labelRecipient')" required /> {% endblock %} {% block sw_order_send_document_modal_subject %} <mt-text-field v-model="subject" class="sw-order-send-document-modal__subject" :label="$tc('sw-order.documentSendModal.labelSubject')" required /> {% endblock %} {% block sw_order_send_document_modal_mail_content %} <div class="sw-order-send-document-modal__email-content-label" > {{ $tc('sw-order.documentSendModal.labelContent') }} </div> <div class="sw-order-send-document-modal__email-content" v-html="$sanitize(content)" > </div> {% endblock %} <template #modal-footer> {% block sw_order_send_document_modal_secondary_action %} <mt-button variant="secondary" data-analytics-id="sw-order-send-document-modal.close" @click="$emit('modal-close')" > {{ $tc('sw-order.documentSendModal.labelClose') }} </mt-button> {% endblock %} {% block sw_order_send_document_modal_primary_action %} <mt-button :disabled="primaryActionDisabled" variant="primary" data-analytics-id="sw-order-send-document-modal.send-document" @click="onSendDocument" > {{ $tc('sw-order.documentCard.labelSendDocument') }} </mt-button> {% endblock %} </template> </sw-modal> {% endblock %}`,{Filter:s}=Shopware,{Criteria:d}=Shopware.Data,m={template:r,inject:["mailService","repositoryFactory"],emits:["modal-close","document-sent"],mixins:["notification"],props:{document:{type:Object,required:!0},order:{type:Object,required:!0}},data(){return{isLoading:!1,mailTemplateId:null,subject:"",recipient:"",content:"",a11yDocuments:[]}},computed:{truncateFilter(){return s.getByName("truncate")},mailTemplateRepository(){return this.repositoryFactory.create("mail_template")},mailHeaderFooterRepository(){return this.repositoryFactory.create("mail_header_footer")},mailTemplateCriteria(){const e=new d(1,25);return e.addAssociation("mailTemplateType"),e.addFilter(d.equalsAny("mailTemplateType.technicalName",["delivery_mail","invoice_mail","credit_note_mail","cancellation_mail"])),e},mailTemplateSendCriteria(){const e=new d(1,25);return e.addAssociation("mailTemplateType"),e},primaryActionDisabled(){return this.mailTemplateId===null||this.subject.length<=0||this.recipient.length<=0},dateFilter(){return Shopware.Filter.getByName("date")}},created(){this.createdComponent()},methods:{createdComponent(){this.recipient=this.order.orderCustomer.email,this.setEmailTemplateAccordingToDocumentType(),this.loadTheLinksForA11y()},setEmailTemplateAccordingToDocumentType(){const e={invoice:"invoice_mail",credit_note:"credit_note_mail",delivery_note:"delivery_mail",storno:"cancellation_mail"};e.hasOwnProperty(this.document.documentType.technicalName)&&this.mailTemplateRepository.search(this.mailTemplateCriteria,{...Shopware.Context.api,languageId:this.order.languageId}).then(a=>{const t=a.filter(i=>i.mailTemplateType.technicalName===e[this.document.documentType.technicalName]).first();t&&(this.mailTemplateId=t.id,this.onMailTemplateChange(t.id,t))})},onMailTemplateChange(e,a){var n,l;if(e===null)return this.subject="",this.content="",Promise.resolve();const t={...a};if((l=(n=t==null?void 0:t.mailTemplateType)==null?void 0:n.templateData)!=null&&l.order&&(this!=null&&this.order)&&(t.mailTemplateType.templateData.order=this.order),this.subject=t.subject,!this.order.salesChannel||!this.order.salesChannel.mailHeaderFooterId)return this.mailService.buildRenderPreview(t.mailTemplateType,t).then(o=>{this.content=o});const i={...t};return this.mailHeaderFooterRepository.search(new d(1,1).addFilter(d.equals("id",this.order.salesChannel.mailHeaderFooterId))).then(o=>(o[0].headerHtml&&(i.contentHtml=o[0].headerHtml+i.contentHtml),o[0].footerHtml&&(i.contentHtml+=o[0].footerHtml),this.mailService.buildRenderPreview(i.mailTemplateType,i))).then(o=>{this.content=o})},onSendDocument(){this.isLoading=!0;const e={...Shopware.Context.api,languageId:this.order.languageId||Shopware.Context.api.languageId};this.mailTemplateRepository.get(this.mailTemplateId,e,this.mailTemplateSendCriteria).then(a=>{this.mailService.sendMailTemplate(this.recipient,`${this.order.orderCustomer.firstName} ${this.order.orderCustomer.lastName}`,{...a,subject:this.subject,recipient:this.recipient},{getIds:()=>{}},this.order.salesChannelId,!1,[this.document.id],{order:this.order,salesChannel:this.order.salesChannel,document:this.document,a11yDocuments:this.a11yDocuments},null,null,e).catch(()=>{this.createNotificationError({message:this.$tc("sw-order.documentSendModal.errorMessage")}),this.$emit("modal-close")}).then(()=>{this.$emit("document-sent")}).finally(()=>{this.isLoading=!1})})},loadTheLinksForA11y(){var e;(e=this.document)!=null&&e.documentA11yMediaFile&&this.a11yDocuments.push({documentId:this.document.id,deepLinkCode:this.document.deepLinkCode,fileExtension:this.document.documentA11yMediaFile.fileExtension})}}};export{m as default};
