const o=`{% block sw_import_export_exporter %} <div class="sw-import-export-exporter"> {% block sw_import_export_exporter_header %}{% endblock %} {% block sw_import_export_exporter_profile_select %} <sw-entity-single-select class="sw-import-export-exporter__profile-select" :disabled="isLoading" :label="$tc('sw-import-export.importer.profileLabel')" :criteria="profileCriteria" entity="import_export_profile" label-property="technicalName" :value="selectedProfileId" required show-clearable-button @update:value="onProfileSelect" /> {% endblock %} <template v-if="selectedProfile && selectedProfile.sourceEntity === 'product'"> {% block sw_import_export_exporter_profile_select_product_variants_switch %} <mt-switch v-model="config.parameters.includeVariants" class="sw-import-export-exporter__variants-switch-field" :label="$tc('sw-import-export.exporter.exportVariants')" /> {% endblock %} </template> <template v-if="showProductVariantsInfo"> {% block sw_import_export_exporter_product_variants_warning %} <mt-banner variant="attention" class="sw-import-export-exporter__variants-warning" > {% block sw_import_export_exporter_product_variants_warning_text %} <p> <span v-html="$tc('sw-import-export.exporter.variantsWarning')"></span> </p> <p> <a href="#" class="sw-import-export-exporter__link" @click.prevent="setExportModalProfile('product_configurator_setting')" > {{ $tc('sw-import-export.exporter.directExportVariantsLabel') }} </a> <br> <a href="#" class="sw-import-export-exporter__link" @click.prevent="setExportModalProfile('property_group_option')" > {{ $tc('sw-import-export.exporter.directExportPropertiesLabel') }} </a> </p> {% endblock %} </mt-banner> {% endblock %} </template> {% block sw_import_export_exporter_modal %} <sw-modal v-if="exportModalProfile" :title="$tc('sw-import-export.exporter.exportLabel')" @modal-close="setExportModalProfile(null)" > {% block sw_import_export_exporter_modal_exporter %} <sw-import-export-exporter :source-entity="exportModalProfile" @export-started="$emit('export-started', $event)" /> {% endblock %} <template #modal-footer> {% block sw_import_export_exporter_modal_footer %} <mt-button size="small" variant="secondary" @click="setExportModalProfile(null)" > {{ $tc('sw-import-export.exporter.close') }} </mt-button> {% endblock %} </template> </sw-modal> {% endblock %} {% block sw_import_export_exporter_progress %} <sw-import-export-progress activity-type="export" :disable-button="disableExporting" @process-start="onStartProcess" /> {% endblock %} </div> {% endblock %}`,{Mixin:i}=Shopware,{Criteria:t}=Shopware.Data,s={template:o,inject:["importExport","repositoryFactory","feature"],emits:["export-started"],mixins:[i.getByName("notification")],props:{sourceEntity:{type:String,required:!1,default:""}},data(){return{selectedProfileId:null,selectedProfile:null,config:{parameters:{}},isLoading:!1,exportModalProfile:null}},computed:{profileCriteria(){const e=new t(1,25);return e.addSorting(t.sort("technicalName")),this.sourceEntity.length>0&&e.addFilter(t.equals("sourceEntity",this.sourceEntity)),e.addFilter(t.not("AND",[t.equals("type","import")])),e},disableExporting(){return this.isLoading||this.selectedProfileId===null},showProductVariantsInfo(){return this.selectedProfile&&this.selectedProfile.sourceEntity==="product"&&this.config&&this.config.parameters&&this.config.parameters.includeVariants},logRepository(){return this.repositoryFactory.create("import_export_log")}},methods:{onProfileSelect(e,r){this.selectedProfileId=e,this.selectedProfile=r},onStartProcess(){this.isLoading=!0,this.importExport.export(this.selectedProfileId,this.handleProgress,this.config).catch(e=>{!e.response||!e.response.data||!e.response.data.errors?this.createNotificationError({message:e.message}):e.response.data.errors.forEach(r=>{this.createNotificationError({message:`${r.code}: ${r.detail}`})}),this.isLoading=!1})},handleProgress(e){this.createNotificationInfo({message:this.$tc("sw-import-export.exporter.messageExportStarted")}),this.isLoading=!1,this.$emit("export-started",e)},setExportModalProfile(e){this.exportModalProfile=e}}};export{s as default};
