const n=`{% block sw_extension_permissions_modal %} <sw-modal class="sw-extension-permissions-modal" :title="modalTitle" variant="small" @modal-close="close" > {% block sw_extension_permissions_modal_content %} {% block sw_extension_permissions_modal_intro %} <div class="sw-extension-permissions-modal__intro"> {% block sw_extension_permissions_modal_intro_image %} <img class="sw-extension-permissions-modal__image" :src="assetFilter('/administration/administration/static/img/extension-store/permissions.svg')" alt="" > {% endblock %} {% block sw_extension_permissions_modal_intro_text %} <p class="sw-extension-permissions-modal__description"> {{ descriptionText }} </p> <p v-if="domainsList.length > 0" class="sw-extension-permissions-modal__domain-hint" > {{ $tc('sw-extension-store.component.sw-extension-permissions-modal.domainHint') }} </p> {% endblock %} </div> {% endblock %} {% block sw_extension_permissions_modal_categories %} <div class="sw-extension-permissions-modal__categories"> {% block sw_extension_permissions_modal_category %} <div v-for="(permission, key) in permissionsWithGroupedOperations" :key="key" class="sw-extension-permissions-modal__category" > {% block sw_extension_permissions_modal_category_inner %} {% block sw_extension_permissions_modal_category_label %} <span class="sw-extension-permissions-modal__category-label"> {{ categoryLabel(key) }} </span> {% endblock %} {% block sw_extension_permissions_modal_link %} <mt-link class="sw-extension-permissions-modal__detail-link" as="button" type="internal" @click="openDetailsModal(key)" > {{ $tc('sw-extension-store.component.sw-extension-permissions-modal.textEntities') }} </mt-link> {% endblock %} {% endblock %} </div> {% endblock %} {% block sw_extension_permissions_modal_category_domains %} <div v-if="domainsList.length > 0" class="sw-extension-permissions-modal__category" > <span class="sw-extension-permissions-modal__category-label"> {{ $tc('sw-extension-store.component.sw-extension-permissions-modal.domains') }} </span> <mt-link class="sw-extension-permissions-modal__detail-link" as="button" type="internal" @click="toggleDomainsModal(true)" > {{ $tc('sw-extension-store.component.sw-extension-permissions-modal.showDomains') }} </mt-link> </div> {% endblock %} </div> {% endblock %} {% endblock %} {% block sw_extension_permissions_modal_footer %} <template #modal-footer> {% block sw_extension_permissions_modal_footer_inner %} {% block sw_extension_permissions_modal_footer_close %} <mt-button :variant="actionLabel === null ? 'primary' : ''" size="small" @click="close" > {{ closeBtnLabel }} </mt-button> {% endblock %} {% block sw_extension_permissions_modal_footer_action %} <mt-button v-if="actionLabel" variant="primary" size="small" @click="closeWithAction" > {{ actionLabel }} </mt-button> {% endblock %} {% endblock %} </template> {% endblock %} {% block sw_extension_permissions_modal_details %} <sw-extension-permissions-details-modal v-if="showDetailsModal" :modal-title="modalTitle" :permissions="permissionsWithGroupedOperations" :selected-entity="selectedEntity" @modal-close="closeDetailsModal" /> {% endblock %} {% block sw_extension_permissions_modal_domains %} <sw-extension-domains-modal v-if="showDomainsModal" :extension-label="extensionLabel" :domains="domainsList" @modal-close="toggleDomainsModal(false)" /> {% endblock %} </sw-modal> {% endblock %}`,l={template:n,emits:["modal-close","close-with-action"],props:{permissions:{type:Object,required:!0},domains:{type:Array,required:!1,default:()=>[]},extensionLabel:{type:String,required:!0},actionLabel:{type:String,required:!1,default:null},closeLabel:{type:String,required:!1,default:null},title:{type:String,required:!1,default:null},description:{type:String,required:!1,default:null}},data(){return{showDetailsModal:!1,showDomainsModal:!1,selectedEntity:""}},computed:{modalTitle(){return this.title?this.title:this.$tc("sw-extension-store.component.sw-extension-permissions-modal.title",{extensionLabel:this.extensionLabel},1)},permissionsWithGroupedOperations(){return Object.fromEntries(Object.entries(this.permissions).map(([e,o])=>(o=o.reduce((s,i)=>{const t=i.entity;return t==="additional_privileges"?(s[i.operation]=[],s):(s[t]=(s[t]||[]).concat(i.operation),s)},{}),[e,o])))},domainsList(){return this.domains&&Array.isArray(this.domains)?this.domains:[]},closeBtnLabel(){return this.closeLabel?this.closeLabel:this.$tc("global.sw-modal.labelClose")},descriptionText(){return this.description?this.description:this.$tc("sw-extension-store.component.sw-extension-permissions-modal.description",{extensionLabel:this.extensionLabel},1)},assetFilter(){return Shopware.Filter.getByName("asset")}},methods:{close(){this.$emit("modal-close")},closeWithAction(){this.$emit("close-with-action")},categoryLabel(e){return this.$tc(`entityCategories.${e}.title`)},openDetailsModal(e){this.selectedEntity=e,this.showDetailsModal=!0},closeDetailsModal(){this.selectedEntity="",this.showDetailsModal=!1},toggleDomainsModal(e){this.showDomainsModal=!!e}}};export{l as default};
