const l=`{% block sw_order_detail %} <sw-page v-if="orderId" class="sw-order-detail" > {% block sw_order_detail_header %} <template #smart-bar-header> {% block sw_order_detail_header_title %} <h2 v-if="orderIdentifier"> {{ $tc('sw-order.detail.textHeadline') }} {{ orderIdentifier }} {% block sw_order_detail_header_label_manual_order %} <sw-label v-if="order.createdById" appearance="pill" size="small" class="sw-order-detail__manual-order-label" > {{ $tc('sw-order.detail.labelManualOrder') }} </sw-label> {% endblock %} </h2> {% endblock %} {% block sw_order_detail_header_title_new %} <h2 v-else> {{ $tc('sw-order.detail.textHeadlineNew') }} </h2> {% endblock %} </template> {% endblock %} {% block sw_order_detail_language_switch %} <template #language-switch> <sw-language-switch @on-change="onChangeLanguage" /> </template> {% endblock %} {% block sw_order_detail_actions %} <template #smart-bar-actions> {% block sw_order_detail_actions_slot_smart_bar_actions %} {% block sw_order_detail_actions_abort %} <mt-button v-tooltip="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('order.editor'), showOnDisabledElements: true }" class="sw-order-detail__smart-bar-cancel-button" :disabled="loading.order || !acl.can('order.editor')" variant="secondary" size="default" data-analytics-id="sw-order-detail.cancel-editing" @click="onCancelEditing" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_order_detail_actions_save %} <sw-button-process v-tooltip="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('order.editor'), showOnDisabledElements: true }" class="sw-order-detail__smart-bar-save-button" variant="primary" :disabled="loading.order || loading.recalculation || !acl.can('order.editor')" :is-loading="loading.order" :process-success="isSaveSuccessful" data-analytics-id="sw-order-detail.save-edits" @update:process-success="saveEditsFinish" @click.prevent="onSaveEdits" > {{ $tc('global.default.save') }} </sw-button-process> {% endblock %} {% endblock %} </template> {% endblock %} {% block sw_order_detail_content %} <template #content> {% block sw_order_detail_content_leave_page_modal %} <sw-order-leave-page-modal v-if="isDisplayingLeavePageWarning" @page-leave-cancel="onLeaveModalClose" @page-leave-confirm="onLeaveModalConfirm" /> {% endblock %} {% block sw_order_detail_content_save_changes_beforehand_modal %} <sw-order-save-changes-beforehand-modal v-if="askForSaveBeforehand" @cancel="onAskAndSaveEditsCancel" @confirm="onAskAndSaveEditsConfirm" > {{ askForSaveBeforehand.reason }} </sw-order-save-changes-beforehand-modal> {% endblock %} <sw-card-view> <mt-banner v-if="isOrderEditing" class="sw-order-detail__alert" variant="attention" > {{ $tc('sw-order.detail.textUnsavedOrderWarning') }} </mt-banner> <mt-banner v-if="missingProductLineItems.length > 0" class="sw-order-detail__alert" variant="attention" > {{ $tc('sw-order.detailBase.textMissingProductLineItems') }} <ul class="sw_order_detail_base__missing_products_alert-list"> <li v-for="lineItem in missingProductLineItems" :key="lineItem.id" > {{ lineItem.label }} </li> </ul> {{ $tc('sw-order.detailBase.textMissingProductLineItemsDescription') }} </mt-banner> <mt-banner v-if="convertedProductLineItems.length > 0" class="sw-order-detail__alert" variant="info" > {{ $tc('sw-order.detailBase.textConvertedProductLineItems') }} <ul class="sw_order_detail_base__converted_products_alert-list"> <li v-for="lineItem in convertedProductLineItems" :key="lineItem.id" > {{ lineItem.label }} </li> </ul> {{ $tc('sw-order.detailBase.textConvertedProductLineItemsDescription') }} </mt-banner> {% block sw_order_detail_content_tabs %} <sw-tabs v-if="showTabs" class="sw-order-detail__tabs" :class="{ 'has-warning': showWarningTabStyle }" position-identifier="sw-order-detail" > {% block sw_order_detail_content_tabs_general %} <sw-tabs-item class="sw-order-detail__tabs-tab-general" :route="{ name: 'sw.order.detail.general', params: { id: $route.params.id } }" :title="$tc('sw-order.detail.tabGeneral')" > {{ $tc('sw-order.detail.tabGeneral') }} </sw-tabs-item> {% endblock %} {% block sw_order_detail_content_tabs_details %} <sw-tabs-item class="sw-order-detail__tabs-tab-details" :route="{ name: 'sw.order.detail.details', params: { id: $route.params.id } }" :title="$tc('sw-order.detail.tabDetails')" > {{ $tc('sw-order.detail.tabDetails') }} </sw-tabs-item> {% endblock %} {% block sw_order_detail_content_tabs_documents %} <sw-tabs-item class="sw-order-detail__tabs-tab-documents" :class="{ 'has-warning': isOrderEditing }" :route="{ name: 'sw.order.detail.documents', params: { id: $route.params.id } }" :title="$tc('sw-order.detail.tabDocuments')" > {{ $tc('sw-order.detail.tabDocuments') }} <mt-icon v-if="isOrderEditing" v-tooltip="{ message: $tc('sw-order.documentTab.tooltipSaveBeforeCreateDocument') }" class="sw-order-detail__tab-warning-badge" name="solid-exclamation-circle" size="12px" /> </sw-tabs-item> {% endblock %} {% block sw_order_detail_content_tabs_extension %}{% endblock %} </sw-tabs> {% endblock %} <sw-extension-component-section position-identifier="sw-order-detail__before-content" /> {% block sw_order_detail_content_view %} <template v-if="loading.order"> <sw-skeleton /> <sw-skeleton /> </template> {# v-show is used here as underlying components influence the loading state and v-if would destroy this behaviour #} {# @deprecated tag:v6.8.0 - remove \`is-save-successful\`, \`is-editing\`, \`@created-by-id-change\`, \`@loading-change\`, \`@editing-change\` #} <router-view v-if="order" v-show="!loading.order" ref="baseComponent" :order-id="orderId" :is-editing="isEditing" :is-loading="loading.order" :is-save-successful="isSaveSuccessful" @created-by-id-change="updateCreatedById" @loading-change="onUpdateLoading" @editing-change="onUpdateEditing" @save-and-recalculate="onSaveAndRecalculate" @recalculate-and-reload="onRecalculateAndReload" @reload-entity-data="reloadEntityData" @save-and-reload="saveAndReload" @save-edits="onSaveEdits" @error="onError" /> {% endblock %} </sw-card-view> </template> {% endblock %} </sw-page> {% endblock %}`;Shopware.Store.register({id:"swOrderDetail",state(){return{order:null,loading:{order:!1,recalculation:!1,states:!1},editing:!1,savedSuccessful:!1,versionContext:null,orderAddressIds:[]}},getters:{isLoading:e=>Object.values(e.loading).some(t=>t),isEditing:e=>e.editing},actions:{setLoading(e){const t=e[0],r=e[1];typeof r=="boolean"&&(this.loading[t]=r)},setOrderAddressIds(e){if(!e){this.orderAddressIds=[];return}const{orderAddressId:t,customerAddressId:r,type:i,edited:n}=e;if(t===r&&!n){this.orderAddressIds=this.orderAddressIds.filter(d=>!(d.orderAddressId===t&&d.type===i));return}const o=this.orderAddressIds.findIndex(d=>d.orderAddressId===t&&d.type===i);if(o!==-1){this.orderAddressIds[o].customerAddressId=r;return}this.orderAddressIds.push(e)}}});const{Store:s,Mixin:c,Utils:h}=Shopware,{Criteria:a}=Shopware.Data,{array:u}=h,g=Shopware.Classes.ApiService,w={template:l,inject:["repositoryFactory","acl","orderService","feature"],provide(){return{swOrderDetailOnCreatedByIdChange:this.updateCreatedById,swOrderDetailOnLoadingChange:this.onUpdateLoading,swOrderDetailOnEditingChange:this.onUpdateEditing,swOrderDetailOnSaveAndRecalculate:this.onSaveAndRecalculate,swOrderDetailOnRecalculateAndReload:this.onRecalculateAndReload,swOrderDetailOnReloadEntityData:this.reloadEntityData,swOrderDetailOnSaveAndReload:this.saveAndReload,swOrderDetailOnSaveEdits:this.onSaveEdits,swOrderDetailAskAndSaveEdits:this.askAndSaveEdits,swOrderDetailOnError:this.onError,swOrderDetailHandleCartErrors:this.handleCartErrors}},mixins:[c.getByName("notification")],props:{orderId:{type:String,required:!1,default:null}},data(){return{isEditing:!1,createdById:"",isDisplayingLeavePageWarning:!1,nextRoute:null,hasNewVersionId:!1,hasOrderDeepEdit:!1,missingProductLineItems:[],promotionsToDelete:[],deliveryDiscountsToDelete:[],askForSaveBeforehand:null}},metaInfo(){return{title:this.$createTitle(this.orderIdentifier)}},computed:{order:()=>s.get("swOrderDetail").order,versionContext:()=>s.get("swOrderDetail").versionContext,orderAddressIds:()=>s.get("swOrderDetail").orderAddressIds,editing:()=>s.get("swOrderDetail").editing,loading:()=>s.get("swOrderDetail").loading,isLoading:{get(){return this.loading.order},set(e){s.get("swOrderDetail").setLoading(["order",e])}},isSaveSuccessful:{get(){return s.get("swOrderDetail").savedSuccessful},set(e){s.get("swOrderDetail").savedSuccessful=e}},orderIdentifier(){var e;return((e=this.order)==null?void 0:e.orderNumber)??""},orderChanges(){return this.order?this.orderRepository.hasChanges(this.order):!1},showTabs(){return this.$route.meta.$module.routes.detail.children.length>1},showWarningTabStyle(){return this.isOrderEditing&&this.$route.name==="sw.order.detail.documents"},isOrderEditing(){var e;return this.orderChanges||this.hasOrderDeepEdit||((e=this.orderAddressIds)==null?void 0:e.length)>0},orderRepository(){return this.repositoryFactory.create("order")},automaticPromotions(){return this.order.lineItems.filter(e=>e.type==="promotion"&&e.referencedId===null)},deliveryDiscounts(){return Shopware.Feature.isActive("v6.8.0.0")?this.order.deliveries.filter(e=>e.id!==this.order.primaryOrderDeliveryId):u.slice(this.order.deliveries,1)||[]},orderCriteria(){const e=new a(1,25);return e.addAssociation("currency").addAssociation("orderCustomer.salutation").addAssociation("language"),e.getAssociation("lineItems").addFilter(a.equals("parentId",null)).addSorting(a.sort("position","ASC")),e.getAssociation("lineItems.children").addSorting(a.sort("position","ASC")),e.addAssociation("salesChannel.domains"),e.addAssociation("addresses.country").addAssociation("addresses.countryState").addAssociation("documents.documentType").addAssociation("tags").addAssociation("primaryOrderTransaction").addAssociation("primaryOrderTransaction.paymentMethod").addAssociation("primaryOrderTransaction.stateMachineState").addAssociation("primaryOrderDelivery").addAssociation("primaryOrderDelivery.shippingMethod").addAssociation("primaryOrderDelivery.stateMachineState").addAssociation("primaryOrderDelivery.shippingOrderAddress.country"),Shopware.Feature.isActive("v6.8.0.0")||e.addAssociation("deliveries.shippingMethod").addAssociation("deliveries.shippingOrderAddress").addAssociation("transactions.paymentMethod"),e.addAssociation("stateMachineState"),e.getAssociation("deliveries").addAssociation("stateMachineState").addSorting(a.sort("shippingCosts.unitPrice","DESC")),e.getAssociation("transactions").addAssociation("stateMachineState").addSorting(a.sort("createdAt")),e.addAssociation("billingAddress"),e},convertedProductLineItems(){var e,t;return((t=(e=this.order)==null?void 0:e.lineItems)==null?void 0:t.filter(r=>{var i;return((i=r.payload)==null?void 0:i.isConvertedProductLineItem)&&r.type==="custom"&&!this.missingProductLineItems.includes(r)}))||[]}},watch:{orderId(){this.createdComponent()},isOrderEditing(e){this.updateEditing(e)}},beforeUnmount(){this.beforeDestroyComponent()},beforeRouteLeave(e,t,r){this.isOrderEditing?(this.nextRoute=r,this.isDisplayingLeavePageWarning=!0):(Shopware.Store.get("shopwareApps").selectedIds=[],r())},created(){this.createdComponent()},methods:{createdComponent(){Shopware.ExtensionAPI.publishData({id:"sw-order-detail-base__order",path:"order",scope:this}),window.addEventListener("beforeunload",this.beforeDestroyComponent),Shopware.Store.get("shopwareApps").selectedIds=this.orderId?[this.orderId]:[],Shopware.Store.get("swOrderDetail").setLoading(["order",!0]),this.createNewVersionId().finally(()=>{Shopware.Store.get("swOrderDetail").setLoading(["order",!1])})},async beforeDestroyComponent(){if(this.hasNewVersionId){const e=this.versionContext;s.get("swOrderDetail").versionContext=Shopware.Context.api,this.hasNewVersionId=!1,await this.orderRepository.deleteVersion(this.orderId,e.versionId,e)}window.removeEventListener("beforeunload",this.beforeDestroyComponent)},updateCreatedById(e){this.createdById=e},onChangeLanguage(){},saveEditsFinish(){this.isSaveSuccessful=!1,this.isEditing=!1},onStartEditing(){},async onSaveEdits(){if(s.get("swOrderDetail").setLoading(["order",!0]),await this.handleOrderAddressUpdate(this.orderAddressIds),this.promotionsToDelete.length>0&&(this.order.lineItems=this.order.lineItems.filter(e=>!this.promotionsToDelete.includes(e.id))),this.order.lineItems.length===0){this.createNotificationError({message:this.$tc("sw-order.detail.messageEmptyLineItems")}),this.createNewVersionId().then(()=>{s.get("swOrderDetail").setLoading(["order",!1])});return}this.deliveryDiscountsToDelete.length>0&&(this.order.deliveries=this.order.deliveries.filter(e=>!this.deliveryDiscountsToDelete.includes(e.id))),await this.orderRepository.save(this.order,this.versionContext).then(()=>(this.hasOrderDeepEdit=!1,this.promotionsToDelete=[],this.deliveryDiscountsToDelete=[],this.orderRepository.mergeVersion(this.versionContext.versionId,this.versionContext))).then(()=>this.createNewVersionId()).then(()=>{this.isSaveSuccessful=!0}).catch(e=>{this.onError("error",e)}).finally(()=>{s.get("swOrderDetail").setLoading(["order",!1])})},async handleOrderAddressUpdate(e){const t=[];if(e.forEach(r=>{if(r.customerAddressId===r.orderAddressId)return;const i={customerAddressId:r.customerAddressId,type:r.type};r.type==="shipping"&&(i.deliveryId=this.order.primaryOrderDeliveryId,Shopware.Feature.isActive("v6.8.0.0")||(i.deliveryId=this.order.deliveries[0].id)),t.push(i)}),t.length===0){s.get("swOrderDetail").setOrderAddressIds(!1);return}await this.updateOrderAddresses(t).then(()=>{s.get("swOrderDetail").setOrderAddressIds(!1)}).catch(r=>{this.createNotificationError({message:r})})},onCancelEditing(){s.get("swOrderDetail").setLoading(["order",!0]);const e=this.versionContext;return s.get("swOrderDetail").versionContext=Shopware.Context.api,this.hasNewVersionId=!1,this.orderRepository.deleteVersion(this.orderId,e.versionId,e).then(()=>{this.hasOrderDeepEdit=!1,s.get("swOrderDetail").setOrderAddressIds(!1)}).catch(t=>{this.onError("error",t)}).finally(()=>(this.missingProductLineItems=[],this.createNewVersionId().then(()=>{s.get("swOrderDetail").setLoading(["order",!1])})))},async onSaveAndRecalculate(){await this.saveAndReload(()=>this.orderService.recalculateOrder(this.orderId,this.versionContext.versionId,{},{}).then(this.handleCartErrors.bind(this)))},async onRecalculateAndReload(){s.get("swOrderDetail").setLoading(["recalculation",!0]);try{await this.orderService.recalculateOrder(this.orderId,this.versionContext.versionId,{},{}).then(this.handleCartErrors.bind(this)),await this.reloadEntityData()}catch(e){this.onError("error",e)}finally{s.get("swOrderDetail").setLoading(["recalculation",!1])}},onSaveAndReload(){return this.saveAndReload()},async saveAndReload(e=null){s.get("swOrderDetail").setLoading(["recalculation",!0]);try{await this.orderRepository.save(this.order,this.versionContext),e&&await e(),await this.reloadEntityData()}catch(t){this.onError("error",t)}finally{s.get("swOrderDetail").setLoading(["recalculation",!1])}},onUpdateLoading(e){this.isLoading=e},onUpdateEditing(e){this.isEditing=e},onError(e){let t=null;try{t=e.response.data.errors[0].detail}catch{t=""}this.createNotificationError({message:this.$tc("sw-order.detail.messageRecalculationError")+t})},onLeaveModalClose(){this.nextRoute(!1),this.nextRoute=null,this.isDisplayingLeavePageWarning=!1},onLeaveModalConfirm(){this.isDisplayingLeavePageWarning=!1,this.$nextTick(()=>{this.nextRoute()})},reloadEntityData(e=!0){return this.orderRepository.get(this.orderId,this.versionContext,this.orderCriteria).then(t=>{this.$route.name!=="sw.order.detail.documents"&&e&&(this.hasOrderDeepEdit=!0),s.get("swOrderDetail").order=t})},createNewVersionId(){return s.get("swOrderDetail").versionContext=Shopware.Context.api,this.hasNewVersionId=!1,this.orderRepository.createVersion(this.orderId,this.versionContext).then(e=>(this.hasNewVersionId=!0,s.get("swOrderDetail").versionContext=e,this.reloadEntityData(!1))).then(()=>this.convertMissingProductLineItems())},updateOrderAddresses(e){return this.orderService.updateOrderAddresses(this.orderId,e,{},g.getVersionHeader(this.order.versionId))},updateEditing(e){s.get("swOrderDetail").editing=e},convertMissingProductLineItems(){var e,t;return this.missingProductLineItems=((t=(e=this.order)==null?void 0:e.lineItems)==null?void 0:t.filter(r=>r.productId===null&&r.type==="product"))||[],this.missingProductLineItems.length===0?Promise.resolve():(this.missingProductLineItems.forEach(r=>{r.type="custom",r.productId=null,r.referencedId=null,r.payload.isConvertedProductLineItem=!0}),this.orderRepository.save(this.order,this.versionContext))},handleCartErrors(e){var t;(t=e==null?void 0:e.data)!=null&&t.errors&&Object.values(e.data.errors).forEach(({level:r,message:i})=>{switch(r){case 0:{this.createNotificationInfo({message:i});break}case 10:{this.createNotificationWarning({message:i});break}default:{this.createNotificationError({message:i});break}}})},askAndSaveEdits(e="status"){return this.isOrderEditing?new Promise((t,r)=>{this.askForSaveBeforehand={reason:this.$tc(`sw-order.saveChangesBeforehandModal.${e}Description`),resolve:t,reject:r}}):Promise.resolve(!0)},async onAskAndSaveEditsConfirm(){await this.onSaveEdits(),this.askForSaveBeforehand.resolve(this.isSaveSuccessful),this.askForSaveBeforehand=null},onAskAndSaveEditsCancel(){this.askForSaveBeforehand.resolve(!1),this.askForSaveBeforehand=null}}};export{w as default};
