const o=`{% block sw_license_violation %} <sw-modal v-if="visible" :title="$tc('sw-license-violation.title')" :closable="false" variant="large" class="sw-license-violation" :is-loading="isLoading" > <span class="sw-license-violation__text"> {{ $tc('sw-license-violation.alertText') }} </span> <table class="sw-license-violation__table"> <thead> <tr> <th width="200px"> {{ $tc('sw-license-violation.table.plugin') }} </th> <th>{{ $tc('sw-license-violation.table.warning') }}</th> <th width="350px"></th> </tr> </thead> <tbody> <tr v-for="violation in violations" :key="violation.name" > <td class="sw-license-violation__table-name"> <template v-if="getPluginForViolation(violation)"> <img v-if="getPluginForViolation(violation).icon || getPluginForViolation(violation).iconRaw" :src="'data:image/png;base64, ' + (getPluginForViolation(violation).iconRaw || getPluginForViolation(violation).icon)" alt="" > <strong> {{ (getPluginForViolation(violation).translated && getPluginForViolation(violation).translated.label) || getPluginForViolation(violation).label}} </strong> </template> <template v-else> <p> <strong>{{ violation.name }}</strong> </p> </template> </td> <td>{{ violation.extensions.licenseViolation.text }}</td> <td class="sw-license-violation__table-actions"> <div v-for="action in violation.extensions.licenseViolation.actions" :key="action.externalLink" class="sw-license-violation__table-actions-wrap" > <mt-button class="sw-license-violation__table-action-remove" variant="critical" ghost size="small" @click.prevent="deletePlugin(violation)" > {{ $tc('sw-license-violation.deletePlugin') }} </mt-button> <mt-button :link="action.externalLink" ghost size="small" variant="secondary" >{{ action.label }} </mt-button> </div> </td> </tr> </tbody> </table> <template #modal-footer> <mt-checkbox v-model:checked="readNotice" :label="$tc('sw-license-violation.checkboxMessage')" /> <mt-button variant="primary" :disabled="!readNotice" size="small" @click="deactivateTemporary" > {{ $tc('sw-license-violation.closeModal') }} </mt-button> </template> <sw-modal v-if="showDeleteModal" :title="$tc('sw-license-violation.title')" class="sw-license-violation-confirm-delete" variant="small" @modal-close="onCloseDeleteModal" > <p class="sw-plugin-list__confirm-delete-text"> {{ $tc('sw-license-violation.messageDeleteConfirm', { pluginName: deletePluginItem.label }) }} </p> <template #modal-footer> <mt-button size="small" variant="secondary" @click="onCloseDeleteModal" > {{ $tc('global.default.cancel') }} </mt-button> <mt-button size="small" variant="critical" @click="onConfirmDelete" > {{ $tc('global.default.delete') }} </mt-button> </template> </sw-modal> </sw-modal> {% endblock %}`,n={template:o,inject:["cacheApiService","extensionStoreActionService","licenseViolationService","loginService"],mixins:[Shopware.Mixin.getByName("notification")],data(){return{licenseSubscription:null,showViolation:!1,readNotice:!1,loading:[],showDeleteModal:!1,deletePluginItem:null}},computed:{violations(){return Shopware.Store.get("licenseViolation").violations},warnings(){return Shopware.Store.get("licenseViolation").warnings},visible(){return this.showViolation?this.violations.length>0:!1},pluginCriteria(){return new Shopware.Data.Criteria(1,50)},isLoading(){return this.loading.length>0}},watch:{$route:{handler(){this.$nextTick(()=>{this.getPluginViolation()})},immediate:!0},visible:{handler(i){i===!0&&this.fetchPlugins()},immediate:!0}},methods:{getPluginViolation(){return this.loginService.isLoggedIn()?(this.showViolation=this.licenseViolationService.isTimeExpired(this.licenseViolationService.key.showViolationsKey),this.addLoading("getPluginViolation"),this.licenseViolationService.checkForLicenseViolations().then(({violations:i,warnings:e,other:t})=>{const l=Shopware.Store.get("licenseViolation");l.violations=i,l.warnings=e,l.other=t}).finally(()=>{this.finishLoading("getPluginViolation")})):Promise.resolve()},reloadViolations(){return this.licenseViolationService.resetLicenseViolations(),this.getPluginViolation()},deactivateTemporary(){this.licenseViolationService.saveTimeToLocalStorage(this.licenseViolationService.key.showViolationsKey),this.readNotice=!1,this.showViolation=this.licenseViolationService.isTimeExpired(this.licenseViolationService.key.showViolationsKey)},fetchPlugins(){this.loginService.isLoggedIn()&&(this.addLoading("fetchPlugins"),this.extensionStoreActionService.getMyExtensions().then(i=>{this.plugins=i}).finally(()=>{this.finishLoading("fetchPlugins")}))},deletePlugin(i){this.deletePluginItem=i,this.showDeleteModal=!0},onCloseDeleteModal(){this.deletePluginItem=null,this.showDeleteModal=!1},onConfirmDelete(){const i=this.deletePluginItem;this.showDeleteModal=!1,this.addLoading("deletePlugin");const e=this.plugins.find(t=>t.name===i.name);return this.licenseViolationService.forceDeletePlugin(e).then(()=>(this.createNotificationSuccess({message:this.$tc("sw-license-violation.successfullyDeleted")}),this.reloadViolations())).finally(()=>{this.finishLoading("deletePlugin")})},getPluginForViolation(i){return Array.isArray(this.plugins)&&this.plugins.find(t=>t.name===i.name)||null},addLoading(i){this.loading.push(i)},finishLoading(i){this.loading=this.loading.filter(e=>e!==i)}}};export{n as default};
